/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.rest.parameters;

import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.internal.rest.ParmValidation;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.transport.IParameterWrapper;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.internal.ChangeHistoryHandle;
import com.ibm.team.scm.common.internal.ScmFactory;

public final class ParmsContext
implements IParameterWrapper {
    public String repositoryUrl;
    public String itemId;
    public String type;
    public long state;
    public ParmsContext subContext = null;

    public ParmsContext() {
    }

    public ParmsContext(String type, String url, String itemId) {
        this.type = type;
        this.repositoryUrl = url;
        this.itemId = itemId;
    }

    public void validate(String requestName, Object ... parameterName) {
        ParmValidation.requiredValue(this.repositoryUrl, requestName, parameterName, "repositoryUrl");
        ParmValidation.requiredValue(this.itemId, requestName, parameterName, "itemId");
        ParmValidation.inEnumIgnoreCase(this.type, requestName, new String[]{"baseline", "baselineset", "workspace", "snapshot", "component", "changehistory", "historyreference"}, parameterName, "type");
        if (this.subContext != null) {
            this.subContext.validate(requestName, parameterName);
        }
    }

    public IItemHandle getContextHandle() throws TeamRepositoryException {
        if (this.type == null || this.itemId == null) {
            return null;
        }
        if (this.type.equalsIgnoreCase("historyreference")) {
            return null;
        }
        ITeamRepository repo = CommonUtil.getTeamRepository(this.repositoryUrl);
        UUID uuid = UUID.valueOf((String)this.itemId);
        if (this.type.equalsIgnoreCase("baseline")) {
            return IBaseline.ITEM_TYPE.createItemHandle((Object)repo, uuid, null);
        }
        if (this.type.equalsIgnoreCase("baselineset") || this.type.equalsIgnoreCase("snapshot")) {
            return IBaselineSet.ITEM_TYPE.createItemHandle((Object)repo, uuid, null);
        }
        if (this.type.equalsIgnoreCase("workspace")) {
            return IWorkspace.ITEM_TYPE.createItemHandle((Object)repo, uuid, null);
        }
        if (this.type.equalsIgnoreCase("component")) {
            return IComponent.ITEM_TYPE.createItemHandle((Object)repo, uuid, null);
        }
        if (this.type.equalsIgnoreCase("changehistory")) {
            ChangeHistoryHandle historyHandle = ScmFactory.eINSTANCE.createChangeHistoryHandle();
            historyHandle.setItemId(uuid);
            historyHandle.setOrigin((Object)repo);
            return historyHandle;
        }
        return null;
    }
}

