/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.utils;

import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.RepoIdConnectionComponentTriple;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.internal.IConfigurationDescriptor;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;

public class WorkspaceLockUtil {
    public static FlowNodeLock acquireWrite(IConnection connection, IProgressMonitor monitor) {
        FlowNodeLock lock = new FlowNodeLock();
        lock.toWriteLock(connection.getContextHandle());
        lock.acquire(monitor);
        return lock;
    }

    public static FlowNodeLock acquireWrite(IWorkspaceConnection workspace, IComponentHandle componentToLock, IProgressMonitor monitor) {
        return WorkspaceLockUtil.acquireWrite((IConnection)workspace, componentToLock, (Collection<? extends IAuditable>)Collections.EMPTY_LIST, monitor);
    }

    public static FlowNodeLock acquireWrite(IConnection workspace, IComponentHandle componentToLock, Collection<? extends IAuditable> determinants, IProgressMonitor monitor) {
        FlowNodeLock lock = new FlowNodeLock();
        lock.toWriteLock(new RepoIdConnectionComponentTriple(workspace.teamRepository().getId(), workspace.getContextHandle(), componentToLock));
        lock.addDeterminants(determinants);
        lock.acquire(monitor);
        return lock;
    }

    public static FlowNodeLock acquireWrite(IWorkspaceConnection workspace, Collection<IComponentHandle> componentsToLock, IProgressMonitor monitor) {
        return WorkspaceLockUtil.acquireWrite(workspace, componentsToLock, (Collection<? extends IAuditable>)Collections.EMPTY_LIST, monitor);
    }

    public static FlowNodeLock acquireWrite(IWorkspaceConnection workspace, Collection<IComponentHandle> componentsToLock, Collection<? extends IAuditable> determinants, IProgressMonitor monitor) {
        FlowNodeLock lock = new FlowNodeLock();
        for (IComponentHandle componentHandle : componentsToLock) {
            lock.toWriteLock(new RepoIdConnectionComponentTriple(workspace.teamRepository().getId(), workspace.getContextHandle(), componentHandle));
        }
        lock.addDeterminants(determinants);
        lock.acquire(monitor);
        return lock;
    }

    public static FlowNodeLock acquireWrite(Collection<? extends IConfigurationDescriptor> configurationsToLock, IProgressMonitor monitor) {
        return WorkspaceLockUtil.acquireWrite(configurationsToLock, Collections.EMPTY_LIST, monitor);
    }

    public static FlowNodeLock acquireWrite(Collection<? extends IConfigurationDescriptor> configurationsToLock, Collection<? extends IAuditable> determinants, IProgressMonitor monitor) {
        FlowNodeLock lock = new FlowNodeLock();
        for (IConfigurationDescriptor iConfigurationDescriptor : configurationsToLock) {
            lock.toWriteLock(iConfigurationDescriptor);
        }
        lock.addDeterminants(determinants);
        lock.acquire(monitor);
        return lock;
    }

    public static FlowNodeLock acquireWrite(Collection<? extends IConfigurationDescriptor> configurationsToLock, Collection<IContextHandle> contexts, Collection<? extends IAuditable> determinants, IProgressMonitor monitor) {
        FlowNodeLock lock = new FlowNodeLock();
        for (IConfigurationDescriptor iConfigurationDescriptor : configurationsToLock) {
            lock.toWriteLock(iConfigurationDescriptor);
        }
        for (IContextHandle iContextHandle : contexts) {
            lock.toWriteLock(iContextHandle);
        }
        lock.addDeterminants(determinants);
        lock.acquire(monitor);
        return lock;
    }

    public static FlowNodeLock acquireRead(IConnection connection, IProgressMonitor monitor) {
        FlowNodeLock lock = new FlowNodeLock();
        lock.toReadLock(connection.getContextHandle());
        lock.acquire(monitor);
        return lock;
    }

    public static FlowNodeLock acquireRead(IWorkspaceConnection workspace, Collection<IComponentHandle> componentsToLock, IProgressMonitor monitor) {
        return WorkspaceLockUtil.acquireRead(workspace, componentsToLock, Collections.EMPTY_LIST, monitor);
    }

    public static FlowNodeLock acquireRead(IWorkspaceConnection workspace, Collection<IComponentHandle> componentsToLock, Collection<? extends IAuditable> determinants, IProgressMonitor monitor) {
        FlowNodeLock lock = new FlowNodeLock();
        for (IComponentHandle componentHandle : componentsToLock) {
            lock.toReadLock(new RepoIdConnectionComponentTriple(workspace.teamRepository().getId(), workspace.getContextHandle(), componentHandle));
        }
        lock.addDeterminants(determinants);
        lock.acquire(monitor);
        return lock;
    }

    public static FlowNodeLock acquireRead(Collection<? extends IConfigurationDescriptor> configurationsToLock, IProgressMonitor monitor) {
        return WorkspaceLockUtil.acquireRead(configurationsToLock, Collections.EMPTY_LIST, monitor);
    }

    public static FlowNodeLock acquireRead(Collection<? extends IConfigurationDescriptor> configurationsToLock, Collection<? extends IAuditable> determinants, IProgressMonitor monitor) {
        FlowNodeLock lock = new FlowNodeLock();
        for (IConfigurationDescriptor iConfigurationDescriptor : configurationsToLock) {
            lock.toReadLock(iConfigurationDescriptor);
        }
        lock.addDeterminants(determinants);
        lock.acquire(monitor);
        return lock;
    }

    public static void release(FlowNodeLock flowNodeLock) {
        flowNodeLock.release();
    }

    public static FlowNodeLock acquireLocks(Collection<? extends IContextHandle> contextsToRead, Collection<? extends IContextHandle> contextsToWrite, Collection<? extends IConfigurationDescriptor> configurationsToRead, Collection<? extends IConfigurationDescriptor> configurationsToWrite, IProgressMonitor monitor) {
        return WorkspaceLockUtil.acquireLocks(contextsToRead, contextsToWrite, configurationsToRead, configurationsToWrite, Collections.EMPTY_LIST, monitor);
    }

    public static FlowNodeLock acquireLocks(Collection<? extends IContextHandle> contextsToRead, Collection<? extends IContextHandle> contextsToWrite, Collection<? extends IConfigurationDescriptor> configurationsToRead, Collection<? extends IConfigurationDescriptor> configurationsToWrite, Collection<? extends IAuditable> determinants, IProgressMonitor monitor) {
        FlowNodeLock lock = new FlowNodeLock();
        for (IContextHandle iContextHandle : contextsToRead) {
            lock.toReadLock(iContextHandle);
        }
        for (IContextHandle iContextHandle : contextsToWrite) {
            lock.toWriteLock(iContextHandle);
        }
        for (IConfigurationDescriptor iConfigurationDescriptor : configurationsToRead) {
            lock.toReadLock(iConfigurationDescriptor);
        }
        for (IConfigurationDescriptor iConfigurationDescriptor : configurationsToWrite) {
            lock.toWriteLock(iConfigurationDescriptor);
        }
        lock.addDeterminants(determinants);
        lock.acquire(monitor);
        return lock;
    }

    public static FlowNodeLock acquireReadForConfigurations(Collection<ConfigurationFacade> configurationsToLock, IProgressMonitor monitor) {
        FlowNodeLock lock = new FlowNodeLock();
        for (ConfigurationFacade configuration : configurationsToLock) {
            lock.toReadLock(new RepoIdConnectionComponentTriple(configuration.getRepositoryId(), configuration.getConnectionHandle(), configuration.getComponentHandle()));
        }
        lock.acquire(monitor);
        return lock;
    }

    public static FlowNodeLock acquireWriteForConfigurations(Collection<ConfigurationFacade> configurationsToLock, Collection<IContextHandle> contexts, Collection<? extends IAuditable> determinants, IProgressMonitor monitor) {
        FlowNodeLock lock = new FlowNodeLock();
        for (ConfigurationFacade configuration : configurationsToLock) {
            lock.toWriteLock(new RepoIdConnectionComponentTriple(configuration.getRepositoryId(), configuration.getConnectionHandle(), configuration.getComponentHandle()));
        }
        for (IContextHandle contextHandle : contexts) {
            lock.toWriteLock(contextHandle);
        }
        lock.addDeterminants(determinants);
        lock.acquire(monitor);
        return lock;
    }
}

