/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.utils;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class VersionableStateCache {
    Map<UUID, IVersionableHandle> stateHandles = new HashMap<UUID, IVersionableHandle>();
    Map<UUID, IVersionable> states = new HashMap<UUID, IVersionable>();
    private IWorkspaceManager manager;

    public VersionableStateCache(IWorkspaceManager manager) {
        this.manager = manager;
    }

    public void add(IVersionableHandle versionableHandle) {
        if (versionableHandle.getStateId() == null) {
            throw new IllegalArgumentException();
        }
        this.stateHandles.put(versionableHandle.getStateId(), versionableHandle);
    }

    public boolean isEmpty() {
        return this.stateHandles.isEmpty();
    }

    public void populate(IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IVersionableHandle> toFetch = new ArrayList<IVersionableHandle>(this.stateHandles.values());
        List fetched = this.manager.versionableManager().fetchCompleteStates(toFetch, monitor);
        for (IVersionable versionable : fetched) {
            if (versionable == null) continue;
            if (!(versionable instanceof IFileItem)) {
                throw new FileSystemException("performAutoMerge only supported for Files");
            }
            this.states.put(versionable.getStateId(), versionable);
        }
    }

    public IVersionable getVersionable(IVersionableHandle versionableHandle) {
        return this.states.get(versionableHandle.getStateId());
    }
}

