/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.utils;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.HardcodedPermissionUtils;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.utils.FilesystemLock;
import com.ibm.team.filesystem.client.internal.utils.IPermissionUtil;
import com.ibm.team.filesystem.client.util.IRepositoryRecord;
import com.ibm.team.filesystem.client.util.IRepositoryRegistry;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.ObfuscationHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public class RepositoryRegistry
implements IRepositoryRegistry {
    private static final String FILE_FORMAT_MAGIC = "###";
    private static final String FILE_FORMAT_TYPE = "reporeg";
    private static final int FILE_FORMAT_VERSION = 0;
    private static final String FILE_PREAMBLE = "### reporeg 0";
    public static final String REPOSITORIES_FILE_v2 = "repositories.txt";
    public static final String REPOSITORIES_FILE_v1 = "repositories";
    private List<IRepositoryRecord> records = new LinkedList<IRepositoryRecord>();
    private boolean loaded = false;
    private static final String REPOSITORIES_FILE_LOCK = "repo.lck";
    private static final long LOCK_WAIT = 20000L;
    private FilesystemLock lock = null;
    private long repoFileLastModTime = 0L;
    private long repoFileSize = 0L;
    private final File recordFile;
    private final IPermissionUtil permUtils;
    private boolean allowResolutionOfRepoIds = false;

    public RepositoryRegistry(IPermissionUtil permissionUtils, File root) {
        this.permUtils = permissionUtils;
        this.recordFile = root;
        if (this.recordFile != null) {
            this.lock = new FilesystemLock(new File(this.recordFile.getParentFile(), REPOSITORIES_FILE_LOCK));
        }
    }

    public RepositoryRegistry(File root) {
        this(null, root);
    }

    /*
     * Exception decompiling
     */
    protected void load(boolean shouldLock) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void consumePreamble(String line) throws FileSystemException {
        if (!line.startsWith(FILE_FORMAT_MAGIC)) {
            throw new FileSystemStatusException(FileSystemStatusUtil.getStatusFor(2, NLS.bind((String)Messages.RepositoryRegistry_7, (Object)FILE_FORMAT_MAGIC, (Object)FILE_FORMAT_TYPE)));
        }
        if (!line.startsWith(RepositoryRegistry.getVersionString())) {
            throw new FileSystemStatusException(FileSystemStatusUtil.getStatusFor(2, NLS.bind((String)Messages.RepositoryRegistry_8, (Object)0)));
        }
    }

    private static String getVersionString() {
        return FILE_PREAMBLE;
    }

    protected static void save(IPermissionUtil permUtils, File recordFile, List<IRepositoryRecord> records) throws FileSystemException {
        if (records == null && recordFile != null) {
            throw new IllegalStateException();
        }
        if (recordFile == null) {
            return;
        }
        if (records == null) {
            records = Collections.emptyList();
        }
        RepositoryRegistry.secureFile(permUtils, recordFile);
        FileOutputStream fileStream = null;
        BufferedWriter out = null;
        try {
            try {
                fileStream = new FileOutputStream(recordFile);
                out = new BufferedWriter(new OutputStreamWriter((OutputStream)fileStream, "UTF-8"));
                out.write(RepositoryRegistry.getVersionString());
                out.newLine();
                for (IRepositoryRecord record : records) {
                    ((RepositoryRecord)record).write(out);
                    out.newLine();
                }
            }
            catch (FileNotFoundException e) {
                throw RepositoryRegistry.misconfiguredLocalFS(NLS.bind((String)Messages.RepositoryRegistry_10, (Object)recordFile.getAbsolutePath()));
            }
            catch (IOException e) {
                throw RepositoryRegistry.failure(NLS.bind((String)Messages.RepositoryRegistry_11, (Object)recordFile.getAbsolutePath()), e);
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            if (fileStream != null) {
                try {
                    ((OutputStream)fileStream).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void secureFile(IPermissionUtil permUtils, File recordFile) throws FileSystemException {
        if (permUtils == null) {
            return;
        }
        File parent = recordFile.getParentFile();
        try {
            permUtils.mkRoot(parent.getCanonicalPath());
        }
        catch (IPermissionUtil.CannotCreateException e) {
            throw RepositoryRegistry.misconfiguredLocalFS(NLS.bind((String)Messages.RepositoryRegistry_PARENT_CREATE_FAIL, (Object)recordFile.getAbsolutePath()));
        }
        catch (IPermissionUtil.CannotModifyException e) {
            throw RepositoryRegistry.misconfiguredLocalFS(NLS.bind((String)Messages.RepositoryRegistry_PARENT_MODIFY_FAIL, (Object)recordFile.getAbsolutePath()));
        }
        catch (IPermissionUtil.PermissionUtilsException e) {
            throw RepositoryRegistry.failure(NLS.bind((String)Messages.RepositoryRegistry_PARENT_BLANKET_FAIL, (Object)parent.getAbsolutePath()), e);
        }
        catch (InterruptedException e) {
            throw RepositoryRegistry.failure("Unexpected interruption", e);
        }
        catch (IOException e) {
            throw RepositoryRegistry.failure(NLS.bind((String)Messages.RepositoryRegistry_CANNOT_FIND_PATH, (Object)parent.getPath()), e);
        }
        if (recordFile.exists() && recordFile.isDirectory()) {
            recordFile.delete();
        }
        try {
            permUtils.mkFile(recordFile.getCanonicalPath());
        }
        catch (IPermissionUtil.CannotCreateException e) {
            throw RepositoryRegistry.misconfiguredLocalFS(NLS.bind((String)Messages.RepositoryRegistry_FILE_CREATE_FAIL, (Object)recordFile.getAbsolutePath()));
        }
        catch (IPermissionUtil.CannotModifyException e) {
            throw RepositoryRegistry.misconfiguredLocalFS(NLS.bind((String)Messages.RepositoryRegistry_FILE_MODIFY_FAIL, (Object)recordFile.getAbsolutePath()));
        }
        catch (HardcodedPermissionUtils.MisbehavingScriptException e) {
            throw RepositoryRegistry.failure(NLS.bind((String)Messages.RepositoryRegistry_FILE_RETURNCODE_FAIL, (Object)recordFile.getAbsolutePath(), (Object)Integer.toString(e.getReturnValue())), null);
        }
        catch (IPermissionUtil.PermissionUtilsException e) {
            throw RepositoryRegistry.failure(NLS.bind((String)Messages.RepositoryRegistry_FILE_BLANKET_FAIL, (Object)recordFile.getAbsolutePath()), e);
        }
        catch (InterruptedException e) {
            throw RepositoryRegistry.failure("Unexpected interruption", e);
        }
        catch (IOException e) {
            throw RepositoryRegistry.failure(NLS.bind((String)Messages.RepositoryRegistry_CANNOT_FIND_PATH, (Object)recordFile.getPath()), e);
        }
    }

    private static FileSystemException misconfiguredLocalFS(String message) {
        return new MisconfiguredFilesystemRegistryException(message);
    }

    private static FileSystemException failure(String message, Exception e) {
        return new FailureRegistryException(message, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRepositoryRecord getRecordByURL(String url) {
        if (url == null) {
            throw new IllegalArgumentException();
        }
        List<IRepositoryRecord> list = this.records;
        synchronized (list) {
            this.load(true);
            if (!url.endsWith("/")) {
                url = String.valueOf(url) + "/";
            }
            for (IRepositoryRecord rec : this.records) {
                String otherUrl = rec.getUrl();
                if (!otherUrl.endsWith("/")) {
                    otherUrl = String.valueOf(otherUrl) + "/";
                }
                if (!url.equals(otherUrl)) continue;
                return rec;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRepositoryRecord getRecordByNickname(String nick) {
        if (nick == null) {
            throw new IllegalArgumentException();
        }
        List<IRepositoryRecord> list = this.records;
        synchronized (list) {
            this.load(true);
            for (IRepositoryRecord rec : this.records) {
                if (!nick.equals(rec.getNickname())) continue;
                return rec;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRepositoryRecord getRecordByRepositoryId(UUID repoId) {
        if (repoId == null) {
            throw new IllegalArgumentException();
        }
        List<IRepositoryRecord> list = this.records;
        synchronized (list) {
            this.load(true);
            for (IRepositoryRecord rec : this.records) {
                if (!repoId.equals((Object)rec.getRepositoryId())) continue;
                return rec;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRepositoryRecord getRecordByUserId(UUID userId) {
        if (userId == null) {
            throw new IllegalArgumentException();
        }
        List<IRepositoryRecord> list = this.records;
        synchronized (list) {
            this.load(true);
            for (IRepositoryRecord rec : this.records) {
                if (!userId.equals((Object)rec.getUserId())) continue;
                return rec;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRepositoryRecord getRecord(String urlOrNick) {
        IRepositoryRecord rec = null;
        List<IRepositoryRecord> list = this.records;
        synchronized (list) {
            rec = this.getRecordByURL(urlOrNick);
            if (rec != null) {
                return rec;
            }
            return this.getRecordByNickname(urlOrNick);
        }
    }

    @Override
    public IRepositoryRecord addRecord(String url, String nickname, String username, String password) throws FileSystemException {
        return this.addRecord(url, nickname, username, password, null, null, false);
    }

    @Override
    public IRepositoryRecord addRecord(String url, String nickname, String username, String password, String passwordFileLoc, String certificateLoc, boolean smartCard) throws FileSystemException {
        return this.addRecord(url, nickname, username, password, passwordFileLoc, certificateLoc, smartCard, null);
    }

    @Override
    public IRepositoryRecord addRecord(String url, String nickname, String username, String password, String passwordFileLoc, String certificateLoc, boolean smartCard, UUID repoId) throws FileSystemException {
        return this.addRecord(url, nickname, username, password, passwordFileLoc, certificateLoc, smartCard, false, false, repoId);
    }

    @Override
    public IRepositoryRecord addRecord(String url, String nickname, String username, String password, String passwordFileLoc, String certificateLoc, boolean smartCard, boolean kerberos, boolean integratedWindows, UUID repoId) throws FileSystemException {
        RepositoryRecord record = new RepositoryRecord(url, nickname, username, password, passwordFileLoc, certificateLoc, smartCard, kerberos, integratedWindows, repoId, null);
        return this.addRecord(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRepositoryRecord addRecord(IRepositoryRecord record) throws FileSystemException {
        RepositoryRecord rec = null;
        List<IRepositoryRecord> list = this.records;
        synchronized (list) {
            if (!this.lock.acquire(20000L, null).isOK()) {
                throw new IllegalStateException("Could not acquire lock");
            }
            try {
                this.load(false);
                if (record.getNickname() != null && (rec = (RepositoryRecord)this.getRecordByNickname(record.getNickname())) != null) {
                    this.records.remove(rec);
                }
                if ((rec = (RepositoryRecord)this.getRecordByURL(record.getUrl())) != null) {
                    this.records.remove(rec);
                }
                if (record.getRepositoryId() != null && (rec = (RepositoryRecord)this.getRecordByRepositoryId(record.getRepositoryId())) != null) {
                    this.records.remove(rec);
                }
                this.records.add(record);
                this.save();
            }
            finally {
                this.lock.release(null);
            }
            return rec;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRecord(IRepositoryRecord rec) throws FileSystemException {
        List<IRepositoryRecord> list = this.records;
        synchronized (list) {
            if (!this.lock.acquire(20000L, null).isOK()) {
                throw new IllegalStateException("Could not acquire lock");
            }
            try {
                this.load(false);
                rec = (RepositoryRecord)this.getRecordByURL(rec.getUrl());
                if (rec != null) {
                    this.records.remove(rec);
                }
                if (rec.getRepositoryId() != null && (rec = (RepositoryRecord)this.getRecordByRepositoryId(rec.getRepositoryId())) != null) {
                    this.records.remove(rec);
                }
                this.save();
            }
            finally {
                this.lock.release(null);
            }
        }
    }

    private void save() throws FileSystemException {
        try {
            RepositoryRegistry.save(this.permUtils, this.recordFile, this.records);
            this.repoFileLastModTime = this.recordFile.lastModified();
            this.repoFileSize = this.recordFile.length();
        }
        catch (FileSystemException e) {
            this.records = null;
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<IRepositoryRecord> iterator() {
        List<IRepositoryRecord> list = this.records;
        synchronized (list) {
            this.load(true);
            if (this.records != null) {
                return this.records.iterator();
            }
        }
        return Collections.EMPTY_LIST.iterator();
    }

    private static String escape(String str, Map<Character, Character> toEscape, char escapeChar) {
        StringBuffer buf = new StringBuffer(str.length());
        char[] cArray = str.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            Character item = toEscape.get(Character.valueOf(c));
            if (item == null) {
                buf.append(c);
            } else {
                buf.append(escapeChar);
                buf.append(item);
            }
            ++n2;
        }
        return buf.toString();
    }

    public static List<String> splitEscaped(String str, Map<Character, Character> toEscape, char splitOn, char escapeChar) {
        LinkedList<String> toReturn = new LinkedList<String>();
        StringBuffer accumulator = new StringBuffer(str.length());
        boolean isEscaped = false;
        char[] cArray = str.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (isEscaped) {
                accumulator.append(c);
                isEscaped = false;
            } else if (c == escapeChar) {
                isEscaped = true;
                accumulator.append(c);
            } else if (c == splitOn) {
                toReturn.add(RepositoryRegistry.unescape(accumulator.toString(), toEscape, escapeChar));
                accumulator = new StringBuffer(str.length());
            } else {
                accumulator.append(c);
            }
            ++n2;
        }
        toReturn.add(accumulator.toString());
        return toReturn;
    }

    public static String unescape(String str, Map<Character, Character> toEscape, char escapeChar) {
        StringBuffer buf = new StringBuffer(str.length());
        HashMap<Character, Character> escaped = new HashMap<Character, Character>();
        for (Map.Entry<Character, Character> entry : toEscape.entrySet()) {
            if (escaped.containsKey(entry.getValue())) {
                throw new IllegalArgumentException(NLS.bind((String)Messages.RepositoryRegistry_12, (Object)entry.getValue()));
            }
            escaped.put(entry.getValue(), entry.getKey());
        }
        boolean isEscaped = false;
        char[] cArray = str.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            Character item = Character.valueOf(c);
            if (isEscaped) {
                if (!escaped.containsKey(item)) {
                    throw new IllegalArgumentException(NLS.bind((String)Messages.RepositoryRegistry_13, (Object)item));
                }
                buf.append(escaped.get(item));
                isEscaped = false;
            } else if (c == escapeChar) {
                isEscaped = true;
            } else {
                buf.append(c);
            }
            ++n2;
        }
        return buf.toString();
    }

    @Override
    public void setAllowMigrationForRepositoryId(boolean allow) {
        this.allowResolutionOfRepoIds = allow;
    }

    public static class FailureRegistryException
    extends RepositoryRegistryException {
        public FailureRegistryException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class MisconfiguredFilesystemRegistryException
    extends RepositoryRegistryException {
        public MisconfiguredFilesystemRegistryException(String s) {
            super(s);
        }
    }

    public static class RepositoryRecord
    implements Serializable,
    IRepositoryRecord {
        private static final long serialVersionUID = -5376770411269416777L;
        private static final char SEP = ',';
        private static final char ESCAPE_CHAR = '\\';
        private static final Map<Character, Character> ESCAPE_MAPPING = new HashMap<Character, Character>();
        private final String url;
        private final String nickname;
        private final String username;
        private final String password;
        private final String passwordFileLoc;
        private final String certificateLoc;
        private final boolean smartCard;
        private final UUID repoId;
        private final UUID userId;
        private final boolean kerberos;
        private final boolean integratedWindows;

        static {
            ESCAPE_MAPPING.put(Character.valueOf(','), Character.valueOf(','));
            ESCAPE_MAPPING.put(Character.valueOf('\n'), Character.valueOf('n'));
            ESCAPE_MAPPING.put(Character.valueOf('\\'), Character.valueOf('\\'));
        }

        public RepositoryRecord(String url, String nick, String user, String pass, String certLoc, boolean smartCard, boolean kerberos, boolean integratedWindows, UUID repoId, UUID userid) {
            this(url, nick, user, pass, null, certLoc, smartCard, kerberos, integratedWindows, repoId, userid);
        }

        public RepositoryRecord(String url, String nick, String user, String pass, String passLoc, String certLoc, boolean smartCard, boolean kerberos, boolean integratedWindows, UUID repoId, UUID userid) {
            this.url = url;
            this.nickname = nick;
            this.username = user;
            this.password = pass;
            this.passwordFileLoc = passLoc;
            this.certificateLoc = certLoc;
            this.smartCard = smartCard;
            this.kerberos = kerberos;
            this.integratedWindows = integratedWindows;
            this.repoId = repoId;
            this.userId = userid;
        }

        @Override
        public String getUrl() {
            return this.url;
        }

        @Override
        public String getNickname() {
            return this.nickname;
        }

        @Override
        public String getUsername() {
            return this.username;
        }

        @Override
        public String getPassword() {
            return this.password;
        }

        @Override
        public String getPasswordFileLocation() {
            return this.passwordFileLoc;
        }

        @Override
        public String getCertficiateLocation() {
            return this.certificateLoc;
        }

        @Override
        public boolean isSmartCard() {
            return this.smartCard;
        }

        @Override
        public boolean isKerberos() {
            return this.kerberos;
        }

        @Override
        public UUID getRepositoryId() {
            return this.repoId;
        }

        @Override
        public UUID getUserId() {
            return this.userId;
        }

        public void write(BufferedWriter out) throws IOException {
            out.write(RepositoryRegistry.escape(this.url, RepositoryRecord.ESCAPE_MAPPING, '\\'));
            out.write(44);
            String nick = this.nickname == null ? "" : this.nickname;
            out.write(RepositoryRegistry.escape(nick, RepositoryRecord.ESCAPE_MAPPING, '\\'));
            out.write(44);
            String user = this.username == null ? "" : this.username;
            out.write(RepositoryRegistry.escape(user, RepositoryRecord.ESCAPE_MAPPING, '\\'));
            out.write(44);
            String certLoc = this.certificateLoc == null ? "" : this.certificateLoc;
            out.write(RepositoryRegistry.escape(certLoc, RepositoryRecord.ESCAPE_MAPPING, '\\'));
            out.write(44);
            out.write(RepositoryRegistry.escape(Boolean.toString(this.smartCard), RepositoryRecord.ESCAPE_MAPPING, '\\'));
            out.write(44);
            if (this.passwordFileLoc == null || this.passwordFileLoc.length() == 0) {
                out.write(RepositoryRecord.obfuscatePassword(this.password));
            } else {
                out.write("");
            }
            out.write(44);
            if (this.repoId != null) {
                out.write(RepositoryRegistry.escape(this.repoId.getUuidValue(), RepositoryRecord.ESCAPE_MAPPING, '\\'));
            }
            out.write(44);
            if (this.userId != null) {
                out.write(RepositoryRegistry.escape(this.userId.getUuidValue(), RepositoryRecord.ESCAPE_MAPPING, '\\'));
            }
            out.write(44);
            out.write(RepositoryRegistry.escape(Boolean.toString(this.kerberos), RepositoryRecord.ESCAPE_MAPPING, '\\'));
            out.write(44);
            out.write(RepositoryRegistry.escape(Boolean.toString(this.integratedWindows), RepositoryRecord.ESCAPE_MAPPING, '\\'));
            out.write(44);
            if (this.passwordFileLoc != null && this.passwordFileLoc.length() > 0) {
                out.write(RepositoryRecord.obfuscatePassword(this.passwordFileLoc));
            }
        }

        public static RepositoryRecord read(String line) throws IOException, FileSystemException {
            List<String> items = RepositoryRegistry.splitEscaped(line, ESCAPE_MAPPING, ',', '\\');
            if (items.size() == 0) {
                return null;
            }
            if (items.size() < 4) {
                throw new IOException(NLS.bind((String)Messages.RepositoryRegistry_2, (Object)items.size(), (Object)line));
            }
            String url = items.get(0);
            String nickname = items.get(1);
            String username = items.get(2);
            String obfuscatedPassword = null;
            String passLoc = null;
            String certLoc = null;
            boolean smartCard = false;
            boolean kerberos = false;
            boolean integratedWindows = false;
            String repoIdString = null;
            String userIdString = null;
            if (items.size() == 4) {
                obfuscatedPassword = items.get(3);
            } else {
                certLoc = items.get(3);
                if (items.size() > 4) {
                    smartCard = Boolean.valueOf(items.get(4));
                }
                if (items.size() > 5) {
                    obfuscatedPassword = items.get(5);
                }
                if (items.size() > 6) {
                    repoIdString = items.get(6);
                }
                if (items.size() > 7) {
                    userIdString = items.get(7);
                }
                if (items.size() > 8) {
                    kerberos = Boolean.valueOf(items.get(8));
                }
                if (items.size() > 9) {
                    integratedWindows = Boolean.valueOf(items.get(9));
                }
                if (items.size() > 10) {
                    passLoc = items.get(10);
                }
            }
            if (url.length() == 0) {
                throw new FileSystemStatusException(FileSystemStatusUtil.getStatusFor(2, NLS.bind((String)Messages.RepositoryRegistry_3, (Object)line), null));
            }
            if (nickname.length() == 0) {
                nickname = null;
            }
            if (username.length() == 0) {
                username = null;
            }
            String password = null;
            if (obfuscatedPassword != null && obfuscatedPassword.length() > 0) {
                password = RepositoryRecord.deobfuscatePassword(obfuscatedPassword);
            }
            String passwordFileLocation = null;
            if (passLoc != null && passLoc.length() > 0) {
                passwordFileLocation = RepositoryRecord.deobfuscatePassword(passLoc);
            }
            if (certLoc != null && certLoc.length() == 0) {
                certLoc = null;
            }
            UUID repoId = null;
            if (repoIdString != null && repoIdString.length() > 0) {
                repoId = UUID.valueOf((String)repoIdString);
            }
            UUID userId = null;
            if (userIdString != null && userIdString.length() > 0) {
                userId = UUID.valueOf((String)userIdString);
            }
            return new RepositoryRecord(url, nickname, username, password, passwordFileLocation, certLoc, smartCard, kerberos, integratedWindows, repoId, userId);
        }

        public static String obfuscatePassword(String password) {
            if (password == null) {
                return "";
            }
            StringBuffer buf = new StringBuffer();
            buf.append("z");
            buf.append(password);
            try {
                byte[] bytes = ObfuscationHelper.encrypt((byte[])buf.toString().getBytes("UTF-8"));
                return new String(bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LoggingHelper.log(FileSystemStatusUtil.getStatusFor(e));
                return "";
            }
            catch (GeneralSecurityException e) {
                LoggingHelper.log(FileSystemStatusUtil.getStatusFor(e));
                return "";
            }
        }

        public static String deobfuscatePassword(String obfuscatedPassword) {
            try {
                byte[] bytes = ObfuscationHelper.decrypt((byte[])obfuscatedPassword.getBytes("UTF-8"));
                String password = new String(bytes, "UTF-8");
                if (password.length() > 0) {
                    return password.substring(1);
                }
            }
            catch (UnsupportedEncodingException e) {
                LoggingHelper.log(FileSystemStatusUtil.getStatusFor(e));
            }
            catch (GeneralSecurityException e) {
                LoggingHelper.log(FileSystemStatusUtil.getStatusFor(e));
            }
            return null;
        }

        @Override
        public boolean isIntegratedWindows() {
            return this.integratedWindows;
        }
    }

    public static class RepositoryRegistryException
    extends FileSystemException {
        public RepositoryRegistryException(String message, Throwable cause) {
            super(message, cause);
        }

        public RepositoryRegistryException(String msg) {
            super(msg);
        }
    }

    private static class RepositoryRegistryImporter_v1 {
        private RepositoryRegistryImporter_v1() {
        }

        private static void runImport(IPermissionUtil permUtils, File configDir) {
            try {
                RepositoryRegistryImporter_v1.runImportSafe(permUtils, configDir);
            }
            catch (FileSystemException e) {
                LoggingHelper.log(FileSystemStatusUtil.getStatusFor(2, Messages.RepositoryRegistry_0, (Throwable)((Object)e)));
            }
            catch (IOException e) {
                LoggingHelper.log(FileSystemStatusUtil.getStatusFor(2, Messages.RepositoryRegistry_1, e));
            }
        }

        private static void runImportSafe(IPermissionUtil permUtils, File configDir) throws IOException, FileSystemException {
            File oldFile = new File(configDir, RepositoryRegistry.REPOSITORIES_FILE_v1);
            if (!oldFile.exists()) {
                return;
            }
            LinkedList<IRepositoryRecord> records = new LinkedList<IRepositoryRecord>();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(oldFile), "UTF-8"));){
                String line;
                while ((line = reader.readLine()) != null) {
                    RepositoryRecord rec;
                    if ((line = line.trim()).startsWith("#") || (rec = RepositoryRegistryImporter_v1.read(line)) == null) continue;
                    records.add(rec);
                }
            }
            File newFile = new File(configDir, RepositoryRegistry.REPOSITORIES_FILE_v2);
            RepositoryRegistry.save(permUtils, newFile, records);
            oldFile.delete();
        }

        private static RepositoryRecord read(String line) {
            List<String> items = RepositoryRegistry.splitEscaped(line, RepositoryRecord.ESCAPE_MAPPING, ',', '\\');
            if (items.size() == 0) {
                return null;
            }
            if (items.size() < 4) {
                return null;
            }
            String url = items.get(0);
            String nickname = items.get(1);
            String username = items.get(2);
            String password = items.get(3);
            if (url.length() == 0) {
                return null;
            }
            if (nickname.length() == 0) {
                nickname = null;
            }
            if (username.length() == 0) {
                return null;
            }
            if (password.length() == 0) {
                password = null;
            }
            return new RepositoryRecord(url, nickname, username, password, null, null, false, false, false, null, null);
        }

        static /* synthetic */ void access$0(IPermissionUtil iPermissionUtil, File file) {
            RepositoryRegistryImporter_v1.runImport(iPermissionUtil, file);
        }
    }
}

