/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.utils;

import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.utils.IPersistentFlag;
import com.ibm.team.repository.common.util.NLS;
import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;

public class PersistentFlag
implements IPersistentFlag {
    private boolean state = false;
    private File file;
    private Log log;

    public PersistentFlag(File file) {
        this.file = file;
        this.state = file.exists();
        this.initializeLogging();
    }

    @Override
    public boolean setState(boolean newState) throws IOException {
        boolean oldState = this.state;
        this.state = newState;
        boolean debugEnabled = this.isDebugEnabled();
        if (debugEnabled) {
            if (oldState == newState) {
                this.debug(String.valueOf(this.toString()) + " already at requested state");
            } else {
                String message = this.toString();
                IOException exception = new IOException(message);
                exception.fillInStackTrace();
                this.debug(message, exception);
            }
        }
        try {
            if (newState) {
                this.writeTrue();
            } else {
                this.writeFalse();
            }
        }
        catch (IOException e) {
            if (debugEnabled) {
                this.debug("Write failed for PersistentFlag: " + this.file.getAbsolutePath(), e);
            }
            throw e;
        }
        return oldState;
    }

    private void writeTrue() throws IOException {
        this.ensureParents();
        if (!this.file.createNewFile()) {
            if (this.file.exists()) {
                return;
            }
            throw new IOException(NLS.bind((String)Messages.PersistentFlag_0, (Object)this.file.getAbsolutePath(), (Object[])new Object[0]));
        }
    }

    private void writeFalse() throws IOException {
        this.ensureParents();
        if (!this.file.delete() && this.file.exists()) {
            throw new IOException(NLS.bind((String)Messages.PersistentFlag_1, (Object)this.file.getAbsolutePath(), (Object[])new Object[0]));
        }
    }

    private void ensureParents() throws IOException {
        File parent = this.file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
    }

    @Override
    public boolean getState() {
        return this.state;
    }

    public String toString() {
        return "PersistentFlag: " + this.file.getAbsolutePath() + " (" + this.state + ')';
    }

    private void initializeLogging() {
        Log log = LoggingHelper.getLog(PersistentFlag.class, this.file.getName());
        this.log = log != null && log.isTraceEnabled() ? log : null;
    }

    private boolean isDebugEnabled() {
        return this.log != null && this.log.isTraceEnabled();
    }

    private void debug(String message, IOException exception) {
        if (this.log != null) {
            this.log.trace((Object)message, (Throwable)exception);
        }
    }

    private void debug(String message) {
        if (this.log != null) {
            this.log.trace((Object)message);
        }
    }
}

