/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.utils;

import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.internal.ManagedFileStore;
import java.io.File;
import java.io.IOException;
import java.nio.file.AccessMode;
import java.nio.file.InvalidPathException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import java.nio.file.spi.FileSystemProvider;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class PathUtils {
    public static String getString(List<String> path) {
        return PathUtils.getString(path.toArray(new String[path.size()]));
    }

    public static IPath getPath(String[] path) {
        return new Path(PathUtils.getString(path));
    }

    public static String getString(String[] path) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < path.length) {
            buffer.append('/').append(path[i]);
            ++i;
        }
        return buffer.toString();
    }

    public static boolean samePath(ILocation copyFileAreaRoot1, boolean caseSensitive1, ILocation copyFileAreaRoot2, boolean caseSensitive2) {
        return copyFileAreaRoot1.sameLocation(copyFileAreaRoot2, caseSensitive1 & caseSensitive2);
    }

    public static boolean sameRelativePath(IRelativeLocation relativePath1, boolean caseSensitive1, IRelativeLocation relativePath2, boolean caseSensitive2) {
        return relativePath1.sameLocation(relativePath2, caseSensitive1 && caseSensitive2);
    }

    public static boolean isLoadedWithAnotherName(ISandbox sandbox, IRelativeLocation path, String remoteName) {
        boolean isLoadedWithAnotherName = sandbox.isCaseSensitive() ? !path.getName().equals(remoteName) : (remoteName == null ? true : !path.getName().toLowerCase().equals(remoteName.toLowerCase()));
        return isLoadedWithAnotherName;
    }

    public static String getRealPath(String path) {
        try {
            return ManagedFileStore.getResolvedPath(path);
        }
        catch (CoreException e) {
            return new File(path).getAbsolutePath();
        }
    }

    private static boolean isCaseSensitiveSimple(java.nio.file.Path p) {
        String pathString = p.toString();
        return !new File(pathString.concat("a")).equals(new File(pathString.concat("A")));
    }

    public static boolean isCaseSensitive(String path) {
        boolean isCaseSensitive;
        java.nio.file.Path p = Paths.get(path, new String[0]);
        int numSegments = p.getNameCount();
        if (numSegments == 0) {
            return PathUtils.isCaseSensitiveSimple(p);
        }
        try {
            FileSystemProvider fsp = p.getFileSystem().provider();
            fsp.checkAccess(p, new AccessMode[0]);
            try {
                String last = p.getName(numSegments - 1).toString();
                String newLast = PathUtils.changeCaseOfOneLetter(last);
                java.nio.file.Path parent = p.getParent();
                if (parent == null) {
                    return PathUtils.isCaseSensitiveSimple(p);
                }
                java.nio.file.Path p2 = parent.resolve(newLast);
                isCaseSensitive = !fsp.isSameFile(p, p2);
            }
            catch (NoSuchFileException e) {
                isCaseSensitive = true;
            }
        }
        catch (IOException | IllegalArgumentException e) {
            isCaseSensitive = PathUtils.isCaseSensitiveSimple(p);
        }
        return isCaseSensitive;
    }

    private static String changeCaseOfOneLetter(String s) {
        int i = 0;
        while (i < s.length()) {
            Character lower;
            Character upper;
            char chr = s.charAt(i);
            if (Character.isLowerCase(chr) && (upper = Character.valueOf(Character.toUpperCase(chr))).charValue() != chr) {
                return String.valueOf(s.substring(0, i)) + upper + s.substring(i + 1);
            }
            if (Character.isUpperCase(chr) && (lower = Character.valueOf(Character.toLowerCase(chr))).charValue() != chr) {
                return String.valueOf(s.substring(0, i)) + lower + s.substring(i + 1);
            }
            ++i;
        }
        throw new IllegalArgumentException();
    }

    public static boolean isValidPath(String pathString) {
        try {
            Paths.get(pathString, new String[0]);
        }
        catch (InvalidPathException e) {
            return false;
        }
        return true;
    }
}

