/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.utils;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IFileStorageVisitor;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreEvent;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreManager;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class IgnoreUtils {
    public static void findIgnoresForEvent(final IIgnoreEvent event, final IIgnoredShareablesVisitor visitor, IProgressMonitor monitor) throws FileSystemException {
        final Exception[] exception = new Exception[1];
        IIgnoreManager localManager = null;
        try {
            localManager = (IIgnoreManager)event.getEventSource();
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("Could not cast an ignore event to be an IIgnoreManager", e);
        }
        final IIgnoreManager manager = localManager;
        for (IShareable root : event.getOptimalKnownTraversalRoots()) {
            ((Shareable)root).getFileStorage().accept(new IFileStorageVisitor(){

                @Override
                public boolean visit(IFileStorage storage, IProgressMonitor progress) {
                    if (exception[0] != null) {
                        return false;
                    }
                    SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)3);
                    try {
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        Shareable shareable = storage.getShareable();
                        if (!event.isInEffectFor(shareable)) {
                            return false;
                        }
                        if (visitor.shouldSkip(null, shareable, (IProgressMonitor)monitor.newChild(1))) {
                            return false;
                        }
                        if (manager.shouldBeIgnored(shareable, (IProgressMonitor)monitor.newChild(1))) {
                            visitor.visitShareableIgnoredByRule(null, shareable, (IProgressMonitor)monitor.newChild(1));
                            return false;
                        }
                        return true;
                    }
                    catch (FileSystemException e) {
                        exception[0] = e;
                        return false;
                    }
                    finally {
                        monitor.done();
                    }
                }
            }, Integer.MAX_VALUE, monitor);
        }
    }

    public static void findIgnoresForRules(Collection rules, final Collection collection, IProgressMonitor progress) throws FileSystemException {
        IgnoreUtils.findIgnoresForRules((Collection<? extends IIgnoreProvider.IIgnoreRule>)rules, new IIgnoredShareablesVisitor(){

            @Override
            public void visitShareableIgnoredByRule(IIgnoreProvider.IIgnoreRule rule, IShareable shareable, IProgressMonitor monitor) {
                collection.add(shareable);
            }

            @Override
            public boolean shouldSkip(IIgnoreProvider.IIgnoreRule rule, IShareable shareable, IProgressMonitor monitor) throws FileSystemException {
                return shareable.shouldBeIgnored(monitor);
            }
        }, progress);
    }

    public static void findIgnoresForRules(Collection rules, final boolean visitCurrentlyIgnored, final Collection collection, IProgressMonitor progress) throws FileSystemException {
        IgnoreUtils.findIgnoresForRules((Collection<? extends IIgnoreProvider.IIgnoreRule>)rules, new IIgnoredShareablesVisitor(){

            @Override
            public void visitShareableIgnoredByRule(IIgnoreProvider.IIgnoreRule rule, IShareable shareable, IProgressMonitor monitor) {
                collection.add(shareable);
            }

            @Override
            public boolean shouldSkip(IIgnoreProvider.IIgnoreRule rule, IShareable shareable, IProgressMonitor monitor) throws FileSystemException {
                return !visitCurrentlyIgnored && shareable.shouldBeIgnored(monitor);
            }
        }, progress);
    }

    public static void findIgnoresForRules(Collection<? extends IIgnoreProvider.IIgnoreRule> rules, IIgnoredShareablesVisitor visitor, IProgressMonitor progress) throws FileSystemException {
        if (rules == null) {
            throw new IllegalArgumentException("rules may not be null");
        }
        FileStorageIgnoreVisitor fileStorageVisitor = new FileStorageIgnoreVisitor(rules, visitor);
        fileStorageVisitor.visitRoots(progress);
    }

    public static void removeContainedRules(List<IgnoreRule> localRules) {
        Iterator<IgnoreRule> it = localRules.iterator();
        while (it.hasNext()) {
            IgnoreRule rule = it.next();
            IShareable ignoreFile = rule.getFile();
            boolean remove = false;
            for (IgnoreRule potentialParent : localRules) {
                if (!IgnoreUtils.ruleOccludes(potentialParent, ignoreFile)) continue;
                remove = true;
                break;
            }
            if (!remove) continue;
            it.remove();
        }
    }

    private static boolean ruleOccludes(IgnoreRule potentialParent, IShareable shareable) {
        IRelativeLocation shareablePath;
        IShareable effectiveFrom = potentialParent.getRootShareable();
        IRelativeLocation root = effectiveFrom.getLocalPath();
        if (root.isPrefixOf(shareablePath = shareable.getLocalPath())) {
            int len = root.segmentCount();
            while (len < shareablePath.segmentCount()) {
                IRelativeLocation walker = shareablePath.removeLastSegments(shareablePath.segmentCount() - len);
                if (potentialParent.shouldBeIgnored(walker)) {
                    return true;
                }
                ++len;
            }
        }
        return false;
    }

    public static HashSet<IIgnoreProvider.IIgnoreRule> extractRulesFromReasons(List<IIgnoreManager.IIgnoreReason> reasons) {
        HashSet<IIgnoreProvider.IIgnoreRule> rules = new HashSet<IIgnoreProvider.IIgnoreRule>();
        for (IIgnoreManager.IIgnoreReason reason : reasons) {
            rules.addAll(reason.getRules());
        }
        return rules;
    }

    public static String describeRule(IIgnoreProvider.IIgnoreRule rule) {
        return rule.getShortDescription();
    }

    private static List<IShareable> getRootShareables(IProgressMonitor monitor) {
        IShare[] shares;
        try {
            shares = SharingManager.getInstance().allShares(monitor);
        }
        catch (FileSystemException e) {
            LoggingHelper.log(FileSystemStatusUtil.getStatusFor((Throwable)((Object)e)));
            return Collections.emptyList();
        }
        ArrayList<IShareable> shareables = new ArrayList<IShareable>(shares.length);
        IShare[] iShareArray = shares;
        int n = shares.length;
        int n2 = 0;
        while (n2 < n) {
            IShare share = iShareArray[n2];
            shareables.add(share.getShareable());
            ++n2;
        }
        return shareables;
    }

    public static List<IShareable> findShareablesToRefresh(List<? extends IIgnoreEvent> events, MultiStatus errors, IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(events.size() * 2));
        ArrayList<IShareable> toRefresh = new ArrayList<IShareable>();
        TreeSet<? super IIgnoreEvent> sortedEvents = new TreeSet<IIgnoreEvent>(IgnoreUtils.getIgnoreEventComparator());
        sortedEvents.addAll(events);
        for (IIgnoreEvent iIgnoreEvent : sortedEvents) {
            try {
                IShareable ignoreRoot = iIgnoreEvent.getRoot();
                if (IgnoreUtils.isAlreadyIncludedInRefresh(ignoreRoot, toRefresh)) continue;
                Collection<IShareable> changed = iIgnoreEvent.getChanged((IProgressMonitor)monitor.newChild(1));
                if (changed == null) {
                    changed = Collections.singletonList(ignoreRoot);
                }
                boolean shouldRefresh = true;
                for (IShareable c : changed) {
                    Iterator iterator = toRefresh.iterator();
                    while (iterator.hasNext()) {
                        IShareable shareable = (IShareable)iterator.next();
                        if (shareable.getFullPath().isPrefixOf(c.getFullPath())) {
                            shouldRefresh = false;
                            break;
                        }
                        if (!c.getFullPath().isPrefixOf(shareable.getFullPath())) continue;
                        iterator.remove();
                    }
                    if (!shouldRefresh) continue;
                    toRefresh.add(c);
                }
            }
            catch (FileSystemException e) {
                if (errors == null) {
                    throw e;
                }
                errors.add(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.IgnoreUtils_0, (Object)iIgnoreEvent.toString()), (Throwable)((Object)e)));
            }
        }
        return toRefresh;
    }

    private static Comparator<? super IIgnoreEvent> getIgnoreEventComparator() {
        return new Comparator<IIgnoreEvent>(){

            @Override
            public int compare(IIgnoreEvent o1, IIgnoreEvent o2) {
                ILocation l2;
                ILocation l1 = o1.getRoot().getFullPath();
                if (l1.isPrefixOf(l2 = o2.getRoot().getFullPath())) {
                    return -1;
                }
                if (l2.isPrefixOf(l1)) {
                    return 1;
                }
                return l1.toString().compareTo(l2.toString());
            }
        };
    }

    private static boolean isAlreadyIncludedInRefresh(IShareable ignoreRoot, List<IShareable> toRefresh) {
        for (IShareable shareable : toRefresh) {
            if (!shareable.getFullPath().isPrefixOf(ignoreRoot.getFullPath())) continue;
            return true;
        }
        return false;
    }

    private static class FileStorageIgnoreVisitor
    implements IFileStorageVisitor {
        private final IIgnoredShareablesVisitor ignoreVistor;
        Map<IShareable, List<IIgnoreProvider.IIgnoreRule>> recursiveRulesByRoot = new HashMap<IShareable, List<IIgnoreProvider.IIgnoreRule>>();
        Map<IShareable, List<IIgnoreProvider.IIgnoreRule>> localRulesByRoot = new HashMap<IShareable, List<IIgnoreProvider.IIgnoreRule>>();
        List<IIgnoreProvider.IIgnoreRule> globalRules = new ArrayList<IIgnoreProvider.IIgnoreRule>();
        private FileSystemException exception;

        FileStorageIgnoreVisitor(Collection<? extends IIgnoreProvider.IIgnoreRule> rules, IIgnoredShareablesVisitor ignoreVistor) {
            this.ignoreVistor = ignoreVistor;
            for (IIgnoreProvider.IIgnoreRule iIgnoreRule : rules) {
                if (iIgnoreRule.isGlobal()) {
                    this.globalRules.add(iIgnoreRule);
                    continue;
                }
                IShareable root = iIgnoreRule.getRootShareable();
                Map<IShareable, List<IIgnoreProvider.IIgnoreRule>> rulesByRoot = iIgnoreRule.isRecursive() ? this.recursiveRulesByRoot : this.localRulesByRoot;
                List<IIgnoreProvider.IIgnoreRule> list = rulesByRoot.get(root);
                if (list == null) {
                    list = new ArrayList<IIgnoreProvider.IIgnoreRule>();
                    rulesByRoot.put(root, list);
                }
                list.add(iIgnoreRule);
            }
        }

        @Override
        public boolean visit(IFileStorage storage, IProgressMonitor progress) {
            if (this.exception != null) {
                return false;
            }
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)2);
            try {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                Shareable shareable = storage.getShareable();
                Collection<IIgnoreProvider.IIgnoreRule> rulesToCheck = this.getRulesToCheckFor(shareable, monitor.newChild(1));
                if (rulesToCheck.isEmpty()) {
                    boolean bl = this.isRootOfLocalRule(shareable);
                    return bl;
                }
                for (IIgnoreProvider.IIgnoreRule rule : rulesToCheck) {
                    if (!rule.shouldBeIgnored(shareable)) continue;
                    this.ignoreVistor.visitShareableIgnoredByRule(rule, shareable, (IProgressMonitor)monitor.newChild(1));
                    return false;
                }
                return true;
            }
            catch (FileSystemException e) {
                this.exception = e;
                return false;
            }
            finally {
                monitor.done();
            }
        }

        private boolean isRootOfLocalRule(IShareable shareable) {
            for (Map.Entry<IShareable, List<IIgnoreProvider.IIgnoreRule>> entry : this.localRulesByRoot.entrySet()) {
                if (!entry.getKey().equals(shareable)) continue;
                return true;
            }
            return false;
        }

        private Collection<IIgnoreProvider.IIgnoreRule> getRulesToCheckFor(IShareable shareable, SubMonitor monitor) throws FileSystemException {
            ArrayList<IIgnoreProvider.IIgnoreRule> rules = new ArrayList<IIgnoreProvider.IIgnoreRule>(this.globalRules);
            for (Map.Entry<IShareable, List<IIgnoreProvider.IIgnoreRule>> entry : this.recursiveRulesByRoot.entrySet()) {
                if (!entry.getKey().getFullPath().isPrefixOf(shareable.getFullPath())) continue;
                rules.addAll((Collection<IIgnoreProvider.IIgnoreRule>)entry.getValue());
            }
            IShareable parent = ((Shareable)shareable).getParent();
            List<IIgnoreProvider.IIgnoreRule> list = this.localRulesByRoot.get(parent);
            if (list != null) {
                rules.addAll(list);
            }
            Iterator iterator = rules.iterator();
            while (iterator.hasNext()) {
                IIgnoreProvider.IIgnoreRule rule = (IIgnoreProvider.IIgnoreRule)iterator.next();
                if (rule.isEffectiveBelow(shareable) && !this.ignoreVistor.shouldSkip(rule, shareable, (IProgressMonitor)monitor)) continue;
                iterator.remove();
            }
            return rules;
        }

        public void visitRoots(IProgressMonitor progress) throws FileSystemException {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
            Collection<IShareable> roots = this.getTraversalRoots((IProgressMonitor)monitor.newChild(10));
            for (IShareable root : roots) {
                ((Shareable)root).getFileStorage().accept(this, Integer.MAX_VALUE, (IProgressMonitor)monitor.newChild(90));
            }
            if (this.exception != null) {
                throw this.exception;
            }
        }

        private Collection<IShareable> getTraversalRoots(IProgressMonitor monitor) {
            ILocation shareablePath;
            ILocation rootPath;
            if (!this.globalRules.isEmpty()) {
                return IgnoreUtils.getRootShareables(monitor);
            }
            ArrayList<IShareable> toVisit = new ArrayList<IShareable>();
            for (IShareable root : this.recursiveRulesByRoot.keySet()) {
                boolean visit = true;
                rootPath = root.getFullPath();
                Iterator iterator = toVisit.iterator();
                while (iterator.hasNext()) {
                    IShareable shareable = (IShareable)iterator.next();
                    shareablePath = shareable.getFullPath();
                    if (rootPath.isPrefixOf(shareablePath)) {
                        iterator.remove();
                        continue;
                    }
                    if (!shareablePath.isPrefixOf(rootPath)) continue;
                    visit = false;
                    break;
                }
                if (!visit) continue;
                toVisit.add(root);
            }
            ArrayList<IShareable> localToVisit = new ArrayList<IShareable>(this.localRulesByRoot.keySet());
            Iterator iterator = localToVisit.iterator();
            block2: while (iterator.hasNext()) {
                IShareable root = (IShareable)iterator.next();
                rootPath = root.getFullPath();
                for (IShareable shareable : toVisit) {
                    shareablePath = shareable.getFullPath();
                    if (!shareablePath.isPrefixOf(rootPath)) continue;
                    iterator.remove();
                    continue block2;
                }
            }
            toVisit.addAll(localToVisit);
            return toVisit;
        }
    }

    public static interface IIgnoredShareablesVisitor {
        public void visitShareableIgnoredByRule(IIgnoreProvider.IIgnoreRule var1, IShareable var2, IProgressMonitor var3) throws FileSystemException;

        public boolean shouldSkip(IIgnoreProvider.IIgnoreRule var1, IShareable var2, IProgressMonitor var3) throws FileSystemException;
    }
}

