/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.utils;

import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.util.ConnectionUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.internal.ConnectionDescriptor;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.flow.FlowTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class FlowTableUtil {
    public static void addCollaboration(IWorkspaceConnection local, IWorkspaceConnection remote, IProgressMonitor monitor) throws TeamRepositoryException {
        IFlowTable flowTable = local.getFlowTable().getWorkingCopy();
        FlowTableUtil.addCollaboration(flowTable, local, remote);
        local.setFlowTable(flowTable, monitor);
    }

    public static void addIncomingCollaboration(IWorkspaceConnection local, IWorkspaceConnection remote, IProgressMonitor monitor) throws TeamRepositoryException {
        IFlowTable flowTable = local.getFlowTable().getWorkingCopy();
        FlowTableUtil.addIncomingCollaboration(flowTable, local, remote);
        local.setFlowTable(flowTable, monitor);
    }

    public static void addOutgoingCollaboration(IWorkspaceConnection local, IWorkspaceConnection remote, IProgressMonitor monitor) throws TeamRepositoryException {
        IFlowTable flowTable = local.getFlowTable().getWorkingCopy();
        FlowTableUtil.addOutgoingCollaboration(flowTable, local, remote);
        local.setFlowTable(flowTable, monitor);
    }

    public static void addCollaboration(IFlowTable flowTable, IWorkspaceConnection local, IWorkspaceConnection remote) throws TeamRepositoryException {
        FlowTableUtil.addIncomingCollaboration(flowTable, local, remote);
        FlowTableUtil.addOutgoingCollaboration(flowTable, local, remote);
    }

    public static void addIncomingCollaboration(IFlowTable flowTable, IWorkspaceConnection local, IWorkspaceConnection remote) throws TeamRepositoryException {
        if (remote == null) {
            return;
        }
        IWorkspaceHandle target = (IWorkspaceHandle)remote.getResolvedWorkspace().getItemHandle();
        List<IComponentHandle> components = FlowTableUtil.getCommonComponents((IConnection)local, (IConnection)remote);
        UUID remoteRepoId = null;
        String remoteRepoURI = null;
        if (!local.sameRepository((IConnection)remote)) {
            ITeamRepository remoteRepo = remote.teamRepository();
            remoteRepoId = remoteRepo.getId();
            remoteRepoURI = remoteRepo.getRepositoryURI();
        }
        IFlowEntry acceptFlow = ((FlowTable)flowTable).getAcceptFlow((IFlowNodeHandle)target, true);
        List componentHandles = Collections.EMPTY_LIST;
        if (acceptFlow != null) {
            componentHandles = acceptFlow.getComponentScopes();
        }
        flowTable.addAcceptFlow((IFlowNodeHandle)target, remoteRepoId, remoteRepoURI, (Collection)componentHandles, null);
        IFlowEntry deliverFlow = ((FlowTable)flowTable).getDeliverFlow((IFlowNodeHandle)target, true);
        if (deliverFlow == null) {
            flowTable.addDeliverFlow((IFlowNodeHandle)target, remoteRepoId, remoteRepoURI, components, "PlaceHolder");
        }
        List acceptSources = flowTable.acceptSources();
        boolean setNewDefaultCurrent = true;
        for (Object obj : acceptSources) {
            IFlowEntry entry = (IFlowEntry)obj;
            IFlowNodeHandle flowNode = entry.getFlowNode();
            if (target != null && flowNode.sameItemId((IItemHandle)target) || flowNode.sameItemId(local.getResolvedWorkspace().getItemHandle())) continue;
            setNewDefaultCurrent = false;
            break;
        }
        if (setNewDefaultCurrent && target != null) {
            FlowTableUtil.setDefaultIncomingCollaboration(flowTable, target);
            FlowTableUtil.setCurrentIncomingCollaboration(flowTable, target);
        }
    }

    public static void addOutgoingCollaboration(IFlowTable flowTable, IWorkspaceConnection local, IWorkspaceConnection remote) throws TeamRepositoryException {
        if (remote == null) {
            return;
        }
        IWorkspaceHandle target = (IWorkspaceHandle)remote.getResolvedWorkspace().getItemHandle();
        List<IComponentHandle> components = FlowTableUtil.getCommonComponents((IConnection)local, (IConnection)remote);
        UUID remoteRepoId = null;
        String remoteRepoURI = null;
        if (!local.sameRepository((IConnection)remote)) {
            ITeamRepository remoteRepo = remote.teamRepository();
            remoteRepoId = remoteRepo.getId();
            remoteRepoURI = remoteRepo.getRepositoryURI();
        }
        IFlowEntry deliverFlow = ((FlowTable)flowTable).getDeliverFlow((IFlowNodeHandle)target, true);
        String description = null;
        if (deliverFlow != null && "Scoped".equals(deliverFlow.getDescription())) {
            description = deliverFlow.getDescription();
        }
        flowTable.addDeliverFlow((IFlowNodeHandle)target, remoteRepoId, remoteRepoURI, components, description);
        IFlowEntry acceptFlow = ((FlowTable)flowTable).getAcceptFlow((IFlowNodeHandle)target, true);
        if (acceptFlow == null) {
            flowTable.addAcceptFlow((IFlowNodeHandle)target, remoteRepoId, remoteRepoURI, (Collection)Collections.EMPTY_LIST, "PlaceHolder");
        }
        List deliverTargets = flowTable.deliverTargets();
        boolean setNewDefaultCurrent = true;
        for (Object obj : deliverTargets) {
            IFlowEntry entry = (IFlowEntry)obj;
            IFlowNodeHandle flowNode = entry.getFlowNode();
            if (target != null && flowNode.sameItemId((IItemHandle)target) || flowNode.sameItemId(local.getResolvedWorkspace().getItemHandle())) continue;
            setNewDefaultCurrent = false;
            break;
        }
        if (setNewDefaultCurrent && target != null) {
            FlowTableUtil.setDefaultOutgoingCollaboration(flowTable, target);
            FlowTableUtil.setCurrentOutgoingCollaboration(flowTable, target);
        }
    }

    private static List<IComponentHandle> getCommonComponents(IConnection c1, IConnection c2) throws TeamRepositoryException {
        Map<UUID, IComponentHandle> components1 = FlowTableUtil.getComponents(c1);
        Map<UUID, IComponentHandle> components2 = FlowTableUtil.getComponents(c2);
        ArrayList<IComponentHandle> result = new ArrayList<IComponentHandle>();
        for (Map.Entry<UUID, IComponentHandle> entry : components1.entrySet()) {
            if (!components2.containsKey(entry.getKey())) continue;
            result.add(entry.getValue());
        }
        return result;
    }

    private static Map<UUID, IComponentHandle> getComponents(IConnection connection) throws TeamRepositoryException {
        try {
            if (connection instanceof IWorkspaceConnection) {
                HashMap<UUID, IComponentHandle> result = new HashMap<UUID, IComponentHandle>();
                for (IComponentHandle component : ((IWorkspaceConnection)connection).getComponents()) {
                    result.put(component.getItemId(), component);
                }
                return result;
            }
            if (connection instanceof IBaselineConnection) {
                IComponentHandle component = ((IBaselineConnection)connection).getComponent();
                return Collections.singletonMap(component.getItemId(), component);
            }
            throw new IllegalArgumentException("Unsupported type " + connection);
        }
        catch (ItemNotFoundException e) {
            return Collections.EMPTY_MAP;
        }
    }

    public static void removeCollaboration(IWorkspaceConnection local, IWorkspaceConnection remote, IProgressMonitor monitor) throws TeamRepositoryException {
        IFlowTable flowTable = local.getFlowTable().getWorkingCopy();
        FlowTableUtil.removeCollaboration(flowTable, (IWorkspaceHandle)remote.getResolvedWorkspace());
        local.setFlowTable(flowTable, monitor);
    }

    public static void removeCollaboration(IFlowTable flowTable, IWorkspaceHandle remote) {
        flowTable.removeAcceptFlow((IFlowNodeHandle)remote);
        flowTable.removeDeliverFlow((IFlowNodeHandle)remote);
    }

    public static void removeCollaboration(IWorkspaceConnection local, IFlowNodeHandle remote, IProgressMonitor monitor) throws TeamRepositoryException {
        IFlowTable flowTable = local.getFlowTable().getWorkingCopy();
        flowTable.removeAcceptFlow(remote);
        flowTable.removeDeliverFlow(remote);
        local.setFlowTable(flowTable, monitor);
    }

    public static boolean removeIncomingCollaboration(IFlowTable flowTable, IFlowNodeHandle remote, IProgressMonitor monitor) throws TeamRepositoryException {
        boolean changed = false;
        IFlowEntry acceptEntry = flowTable.getAcceptFlow(remote);
        if (acceptEntry != null) {
            if (flowTable.getCurrentAcceptFlow() != null && flowTable.getCurrentAcceptFlow().getFlowNode().sameItemId((IItemHandle)acceptEntry.getFlowNode())) {
                flowTable.unsetCurrentAcceptFlow();
            }
            if (flowTable.getDefaultAcceptFlow() != null && flowTable.getDefaultAcceptFlow().getFlowNode().sameItemId((IItemHandle)acceptEntry.getFlowNode())) {
                flowTable.unsetDefaultAcceptFlow();
            }
            flowTable.setFlowEntryDescription(acceptEntry, "PlaceHolder");
            changed = true;
        }
        return changed;
    }

    public static boolean removeOutgoingCollaboration(IFlowTable flowTable, IFlowNodeHandle remote, IProgressMonitor monitor) throws TeamRepositoryException {
        boolean changed = false;
        IFlowEntry deliverEntry = flowTable.getDeliverFlow(remote);
        if (deliverEntry != null) {
            if (flowTable.getCurrentDeliverFlow() != null && flowTable.getCurrentDeliverFlow().getFlowNode().sameItemId((IItemHandle)deliverEntry.getFlowNode())) {
                flowTable.unsetCurrentDeliverFlow();
            }
            if (flowTable.getDefaultDeliverFlow() != null && flowTable.getDefaultDeliverFlow().getFlowNode().sameItemId((IItemHandle)deliverEntry.getFlowNode())) {
                flowTable.unsetDefaultDeliverFlow();
            }
            flowTable.setFlowEntryDescription(deliverEntry, "PlaceHolder");
            changed = true;
        }
        return changed;
    }

    public static boolean hasCollaboration(IWorkspaceConnection local, IWorkspaceConnection remote) throws TeamRepositoryException {
        IWorkspace target = remote.getResolvedWorkspace();
        return local.getFlowTable().getAcceptFlow((IFlowNodeHandle)target) != null || local.getFlowTable().getDeliverFlow((IFlowNodeHandle)target) != null;
    }

    public static boolean hasIncomingCollaboration(IWorkspaceConnection local, IWorkspace remote) throws TeamRepositoryException {
        return local.getFlowTable().getAcceptFlow((IFlowNodeHandle)remote) != null;
    }

    public static boolean hasOutgoingCollaboration(IWorkspaceConnection local, IWorkspace remote) throws TeamRepositoryException {
        return local.getFlowTable().getDeliverFlow((IFlowNodeHandle)remote) != null;
    }

    public static boolean hasIncomingCollaboration(IWorkspaceConnection local, IWorkspaceConnection remote) throws TeamRepositoryException {
        IWorkspace target = remote.getResolvedWorkspace();
        return FlowTableUtil.hasIncomingCollaboration(local, target);
    }

    public static boolean hasOutgoingCollaboration(IWorkspaceConnection local, IWorkspaceConnection remote) throws TeamRepositoryException {
        IWorkspace target = remote.getResolvedWorkspace();
        return FlowTableUtil.hasOutgoingCollaboration(local, target);
    }

    public static boolean hasCollaboration(IWorkspaceConnection local) {
        return !local.getFlowTable().acceptSources().isEmpty() || !local.getFlowTable().deliverTargets().isEmpty();
    }

    public static boolean hasCurrentCollaboration(IWorkspaceConnection local) {
        return local.getFlowTable().getCurrentAcceptFlow() != null || local.getFlowTable().getCurrentDeliverFlow() != null;
    }

    public static boolean isCurrentIncomingCollaboration(IWorkspaceConnection local, IWorkspace target) {
        IFlowEntry flowEntry = local.getFlowTable().getCurrentAcceptFlow();
        return flowEntry != null && flowEntry.getFlowNode().sameItemId((IItemHandle)target);
    }

    public static boolean isCurrentOutgoingCollaboration(IWorkspaceConnection local, IWorkspace target) {
        IFlowEntry flowEntry = local.getFlowTable().getCurrentDeliverFlow();
        return flowEntry != null && flowEntry.getFlowNode().sameItemId((IItemHandle)target);
    }

    public static void setDefaultCollaboration(IFlowTable flowTable, IWorkspaceHandle target) {
        FlowTableUtil.setDefaultIncomingCollaboration(flowTable, target);
        FlowTableUtil.setDefaultOutgoingCollaboration(flowTable, target);
    }

    public static void setDefaultIncomingCollaboration(IFlowTable flowTable, IWorkspaceHandle target) {
        if (target == null) {
            flowTable.unsetDefaultAcceptFlow();
        } else {
            IFlowEntry acceptEntry = flowTable.getAcceptFlow((IFlowNodeHandle)target);
            if (acceptEntry != null) {
                flowTable.setDefault(acceptEntry);
            }
        }
    }

    public static void setDefaultOutgoingCollaboration(IFlowTable flowTable, IWorkspaceHandle target) {
        if (target == null) {
            flowTable.unsetDefaultDeliverFlow();
        } else {
            IFlowEntry deliverEntry = flowTable.getDeliverFlow((IFlowNodeHandle)target);
            if (deliverEntry != null) {
                flowTable.setDefault(deliverEntry);
            }
        }
    }

    public static IWorkspaceConnection[] getAllAccessibleCollaborations(IWorkspaceConnection connection, IRepositoryResolver resolver, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IWorkspaceConnection> result = new ArrayList<IWorkspaceConnection>();
        IFlowTable flowTable = connection.getFlowTable();
        Map<ITeamRepository, List<IWorkspaceHandle>> requests = FlowTableUtil.getAllCollaborationHandles(connection, resolver, flowTable);
        result.addAll(ConnectionUtil.getAccessibleConnections(requests, monitor));
        return result.toArray(new IWorkspaceConnection[result.size()]);
    }

    public static IWorkspaceConnection[] getAllCollaborations(IWorkspaceConnection connection, IRepositoryResolver resolver, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IWorkspaceConnection> result = new ArrayList<IWorkspaceConnection>();
        IFlowTable flowTable = connection.getFlowTable();
        Map<ITeamRepository, List<IWorkspaceHandle>> requests = FlowTableUtil.getAllCollaborationHandles(connection, resolver, flowTable);
        result.addAll(ConnectionUtil.getConnections(requests, monitor));
        return result.toArray(new IWorkspaceConnection[result.size()]);
    }

    public static IWorkspaceConnection[] getAllIncomingCollaborations(IWorkspaceConnection connection, IRepositoryResolver resolver, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IWorkspaceConnection> result = new ArrayList<IWorkspaceConnection>();
        IFlowTable flowTable = connection.getFlowTable();
        Map<ITeamRepository, List<IWorkspaceHandle>> requests = FlowTableUtil.getAllCollaborationHandles(connection, resolver, flowTable.acceptSources());
        result.addAll(ConnectionUtil.getConnections(requests, monitor));
        return result.toArray(new IWorkspaceConnection[result.size()]);
    }

    public static IWorkspaceConnection[] getAllOutgoingCollaborations(IWorkspaceConnection connection, IRepositoryResolver resolver, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IWorkspaceConnection> result = new ArrayList<IWorkspaceConnection>();
        IFlowTable flowTable = connection.getFlowTable();
        Map<ITeamRepository, List<IWorkspaceHandle>> requests = FlowTableUtil.getAllCollaborationHandles(connection, resolver, flowTable.deliverTargets());
        result.addAll(ConnectionUtil.getConnections(requests, monitor));
        return result.toArray(new IWorkspaceConnection[result.size()]);
    }

    private static Map<ITeamRepository, List<IWorkspaceHandle>> getAllCollaborationHandles(IWorkspaceConnection connection, IRepositoryResolver resolver, List<IFlowEntry> flowEntries) {
        HashMap<ITeamRepository, List<IWorkspaceHandle>> workspacesByRepos = new HashMap<ITeamRepository, List<IWorkspaceHandle>>();
        for (IFlowEntry entry : flowEntries) {
            ArrayList<IWorkspaceHandle> wsHandles;
            if (!(entry.getFlowNode() instanceof IWorkspaceHandle)) continue;
            ITeamRepository repo = connection.teamRepository();
            if (entry.getRemoteRepositoryURI() != null || entry.getRemoteRepositoryIdentifier() != null) {
                try {
                    repo = resolver.getRepoFor(entry.getRemoteRepositoryURI(), entry.getRemoteRepositoryIdentifier());
                }
                catch (TeamRepositoryException e) {
                    continue;
                }
            }
            if ((wsHandles = (ArrayList<IWorkspaceHandle>)workspacesByRepos.get(repo)) == null) {
                wsHandles = new ArrayList<IWorkspaceHandle>();
                workspacesByRepos.put(repo, wsHandles);
            }
            wsHandles.add((IWorkspaceHandle)entry.getFlowNode());
        }
        return workspacesByRepos;
    }

    private static Map<ITeamRepository, List<IWorkspaceHandle>> getAllCollaborationHandles(IWorkspaceConnection connection, IRepositoryResolver resolver, IFlowTable flowTable) {
        Map<ITeamRepository, List<IWorkspaceHandle>> incomingRequests = FlowTableUtil.getAllCollaborationHandles(connection, resolver, flowTable.acceptSources());
        Map<ITeamRepository, List<IWorkspaceHandle>> outgoingRequests = FlowTableUtil.getAllCollaborationHandles(connection, resolver, flowTable.deliverTargets());
        Map<ITeamRepository, List<IWorkspaceHandle>> requests = incomingRequests;
        for (Map.Entry<ITeamRepository, List<IWorkspaceHandle>> entry : requests.entrySet()) {
            List<IWorkspaceHandle> outgoingWorkspaces = null;
            for (Map.Entry<ITeamRepository, List<IWorkspaceHandle>> outgoingEntry : outgoingRequests.entrySet()) {
                if (!outgoingEntry.getKey().getId().equals((Object)entry.getKey().getId())) continue;
                outgoingWorkspaces = outgoingEntry.getValue();
            }
            if (outgoingWorkspaces == null) continue;
            for (IWorkspaceHandle outgoingWorkspaceHandle : outgoingWorkspaces) {
                boolean found = false;
                for (IWorkspaceHandle workspaceHandle : entry.getValue()) {
                    if (!workspaceHandle.equals((Object)outgoingWorkspaceHandle)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                entry.getValue().add(outgoingWorkspaceHandle);
            }
        }
        return requests;
    }

    private static List<ConnectionDescriptor> getCollaborationDescriptors(List<IFlowEntry> flowEntries, ITeamRepository repo) {
        ArrayList<ConnectionDescriptor> collaborationHandles = new ArrayList<ConnectionDescriptor>();
        for (IFlowEntry flowEntry : flowEntries) {
            collaborationHandles.add(FlowTableUtil.getConnectionDescriptor(flowEntry, repo));
        }
        return collaborationHandles;
    }

    public static List<ConnectionDescriptor> getIncomingCollaborationDescriptors(IFlowTable flowTable, ITeamRepository repo) {
        return FlowTableUtil.getCollaborationDescriptors(flowTable.acceptSources(), repo);
    }

    public static List<ConnectionDescriptor> getOutgoingCollaborationDescriptors(IFlowTable flowTable, ITeamRepository repo) {
        return FlowTableUtil.getCollaborationDescriptors(flowTable.deliverTargets(), repo);
    }

    public static void setCurrentCollaboration(IFlowTable flowTable, IWorkspaceHandle target) {
        FlowTableUtil.setCurrentIncomingCollaboration(flowTable, target);
        FlowTableUtil.setCurrentOutgoingCollaboration(flowTable, target);
    }

    public static void setCurrentIncomingCollaboration(IFlowTable flowTable, IWorkspaceHandle target) {
        if (target == null) {
            flowTable.unsetCurrentAcceptFlow();
        } else {
            IFlowEntry acceptEntry = flowTable.getAcceptFlow((IFlowNodeHandle)target);
            if (acceptEntry != null) {
                flowTable.setCurrent(acceptEntry);
            }
        }
    }

    public static void setCurrentOutgoingCollaboration(IFlowTable flowTable, IWorkspaceHandle target) {
        if (target == null) {
            flowTable.unsetCurrentDeliverFlow();
        } else {
            IFlowEntry deliverEntry = flowTable.getDeliverFlow((IFlowNodeHandle)target);
            if (deliverEntry != null) {
                flowTable.setCurrent(deliverEntry);
            }
        }
    }

    @Deprecated
    public static ConnectionDescriptor getCurrentCollaborationDescriptor(IWorkspaceConnection connection) {
        return FlowTableUtil.getCurrentCollaborationDescriptor(connection, true);
    }

    private static ConnectionDescriptor getCurrentCollaborationDescriptor(IWorkspaceConnection connection, boolean incoming) {
        IFlowTable flowTable = connection.getFlowTable();
        ITeamRepository repository = connection.teamRepository();
        IFlowEntry entry = incoming ? flowTable.getCurrentAcceptFlow() : flowTable.getCurrentDeliverFlow();
        return FlowTableUtil.getConnectionDescriptor(entry, repository);
    }

    public static ConnectionDescriptor getCurrentIncomingCollaborationDescriptor(IWorkspaceConnection connection) {
        return FlowTableUtil.getCurrentCollaborationDescriptor(connection, true);
    }

    public static ConnectionDescriptor getCurrentOutgoingCollaborationDescriptor(IWorkspaceConnection connection) {
        return FlowTableUtil.getCurrentCollaborationDescriptor(connection, false);
    }

    public static ConnectionDescriptor getCurrentIncomingCollaborationDescriptor(IWorkspaceConnection connection, IComponentHandle component) {
        IFlowTable flowTable = connection.getFlowTable();
        IFlowEntry entry = flowTable.getCurrentAcceptFlow(component);
        return FlowTableUtil.getConnectionDescriptor(entry, connection.teamRepository());
    }

    public static ConnectionDescriptor getCurrentOutgoingCollaborationDescriptor(IWorkspaceConnection connection, IComponentHandle component) {
        IFlowTable flowTable = connection.getFlowTable();
        IFlowEntry entry = flowTable.getCurrentDeliverFlow(component);
        return FlowTableUtil.getConnectionDescriptor(entry, connection.teamRepository());
    }

    public static ConnectionDescriptor getCurrentIncomingCollaborationDescriptor(IFlowTable flowTable, ITeamRepository repo) {
        IFlowEntry flowEntry = flowTable.getCurrentAcceptFlow();
        return flowEntry != null ? FlowTableUtil.getConnectionDescriptor(flowEntry, repo) : null;
    }

    public static ConnectionDescriptor getCurrentOutgoingCollaborationDescriptor(IFlowTable flowTable, ITeamRepository repo) {
        IFlowEntry flowEntry = flowTable.getCurrentDeliverFlow();
        return flowEntry != null ? FlowTableUtil.getConnectionDescriptor(flowEntry, repo) : null;
    }

    private static ConnectionDescriptor getDefaultCollaborationDescriptor(IWorkspaceConnection connection, boolean incoming) {
        IFlowTable flowTable = connection.getFlowTable();
        ITeamRepository repository = connection.teamRepository();
        IFlowEntry entry = incoming ? flowTable.getDefaultAcceptFlow() : flowTable.getDefaultDeliverFlow();
        return FlowTableUtil.getConnectionDescriptor(entry, repository);
    }

    public static ConnectionDescriptor getDefaultIncomingCollaborationDescriptor(IWorkspaceConnection connection) {
        return FlowTableUtil.getDefaultCollaborationDescriptor(connection, true);
    }

    public static ConnectionDescriptor getDefaultOutgoingCollaborationDescriptor(IWorkspaceConnection connection) {
        return FlowTableUtil.getDefaultCollaborationDescriptor(connection, false);
    }

    public static ConnectionDescriptor getDefaultIncomingCollaborationDescriptor(IFlowTable flowTable, ITeamRepository repo) {
        IFlowEntry flowEntry = flowTable.getDefaultAcceptFlow();
        return flowEntry != null ? FlowTableUtil.getConnectionDescriptor(flowEntry, repo) : null;
    }

    public static ConnectionDescriptor getDefaultOutgoingCollaborationDescriptor(IFlowTable flowTable, ITeamRepository repo) {
        IFlowEntry flowEntry = flowTable.getDefaultDeliverFlow();
        return flowEntry != null ? FlowTableUtil.getConnectionDescriptor(flowEntry, repo) : null;
    }

    private static ConnectionDescriptor getConnectionDescriptor(IFlowEntry entry, ITeamRepository repository) {
        if (entry != null && entry.getFlowNode() instanceof IWorkspaceHandle) {
            IWorkspaceHandle handle = (IWorkspaceHandle)entry.getFlowNode();
            UUID repositoryId = repository.getId();
            String repositoryURI = repository.getRepositoryURI();
            if (entry.getRemoteRepositoryURI() != null) {
                repositoryURI = entry.getRemoteRepositoryURI();
            }
            if (entry.getRemoteRepositoryIdentifier() != null) {
                repositoryId = entry.getRemoteRepositoryIdentifier();
            }
            return new ConnectionDescriptor(repositoryId, repositoryURI, (IContextHandle)handle);
        }
        return null;
    }

    public static void setCurrentIncomingCollaboration(IFlowTable flowTable, IComponentHandle component, IWorkspaceHandle target) {
        if (target == null) {
            flowTable.unsetCurrentAcceptFlow(component);
        } else {
            IFlowEntry acceptEntry = flowTable.getAcceptFlow((IFlowNodeHandle)target);
            if (acceptEntry != null) {
                flowTable.setCurrent(acceptEntry, component);
            }
        }
    }

    public static void setCurrentOutgoingCollaboration(IFlowTable flowTable, IComponentHandle component, IWorkspaceHandle target) {
        if (target == null) {
            flowTable.unsetCurrentDeliverFlow(component);
        } else {
            IFlowEntry deliverEntry = flowTable.getDeliverFlow((IFlowNodeHandle)target);
            if (deliverEntry != null) {
                flowTable.setCurrent(deliverEntry, component);
            }
        }
    }

    public static void setCurrentCollaboration(IFlowTable flowTable, IComponentHandle component, IWorkspaceHandle target) {
        FlowTableUtil.setCurrentIncomingCollaboration(flowTable, component, target);
        FlowTableUtil.setCurrentOutgoingCollaboration(flowTable, component, target);
    }
}

