/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.utils;

import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.Messages;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.HashMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class FilesystemLock {
    private final File lockFile;
    protected RandomAccessFile lockRAF;
    protected FileLock lock;
    private static final HashMap<File, FilesystemLock> lockMap = new HashMap();

    public FilesystemLock(File location) {
        this.lockFile = location;
    }

    public FilesystemLock(IPath path) {
        this.lockFile = path.toFile();
    }

    public IStatus acquire(IProgressMonitor mon) {
        IStatus status = FilesystemLock.acquirePath(this);
        if (status.isOK()) {
            boolean acquired = false;
            try {
                status = this.acquireInternal(mon);
                acquired = status.isOK();
                IStatus iStatus = status;
                return iStatus;
            }
            finally {
                if (!acquired) {
                    FilesystemLock.releasePath(this);
                }
            }
        }
        return status;
    }

    private IStatus acquireInternal(IProgressMonitor mon) {
        if (this.lockFile.exists() && this.lockFile.isDirectory()) {
            throw new IllegalStateException(NLS.bind((String)Messages.FilesystemLock_DIRECTORY_COLLISION, (Object)this.lockFile.getAbsolutePath()));
        }
        if (this.lockFile.exists()) {
            if (!this.lockFile.isFile()) {
                return FileSystemStatusUtil.getStatusFor(1, NLS.bind((String)Messages.FilesystemLock_NOT_A_FILE, (Object)this.lockFile.getAbsolutePath()));
            }
        } else {
            File lockParent = this.lockFile.getParentFile();
            if (lockParent.exists()) {
                if (!lockParent.isDirectory()) {
                    return FileSystemStatusUtil.getStatusFor(1, NLS.bind((String)Messages.FilesystemLock_NOT_A_DIRECTORY, (Object)this.lockFile.getAbsolutePath()));
                }
            } else if (!lockParent.mkdirs()) {
                return FileSystemStatusUtil.getStatusFor(1, NLS.bind((String)Messages.FilesystemLock_COULD_NOT_CREATE, (Object)lockParent.getAbsolutePath()));
            }
            try {
                if (!this.lockFile.createNewFile()) {
                    return FileSystemStatusUtil.getStatusFor(1, NLS.bind((String)Messages.FilesystemLock_COULD_NOT_CREATE, (Object)this.lockFile.getAbsolutePath()));
                }
            }
            catch (IOException e) {
                return FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.FilesystemLock_COULD_NOT_CREATE, (Object)this.lockFile.getAbsolutePath()), e);
            }
        }
        try {
            this.lockRAF = new RandomAccessFile(this.lockFile, "rw");
        }
        catch (IOException e) {
            return FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.FilesystemLock_COULD_NOT_OPEN_FILE, (Object)this.lockFile.getAbsolutePath()), e);
        }
        IStatus lockStatus = null;
        try {
            try {
                this.lock = this.lockRAF.getChannel().tryLock(0L, 1L, false);
            }
            catch (IOException e) {
                IStatus iStatus = lockStatus = FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.FilesystemLock_COULD_NOT_LOCK_FILE, (Object)this.lockFile.getAbsolutePath()), e);
                if (this.lock == null) {
                    try {
                        if (this.lockRAF != null) {
                            this.lockRAF.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (lockStatus == null) {
                        return FileSystemStatusUtil.getStatusFor(1, NLS.bind((String)Messages.FilesystemLock_1, (Object)this.lockFile.getAbsolutePath()));
                    }
                    return lockStatus;
                }
                return iStatus;
            }
        }
        finally {
            if (this.lock == null) {
                try {
                    if (this.lockRAF != null) {
                        this.lockRAF.close();
                    }
                }
                catch (IOException iOException) {}
                if (lockStatus == null) {
                    return FileSystemStatusUtil.getStatusFor(1, NLS.bind((String)Messages.FilesystemLock_1, (Object)this.lockFile.getAbsolutePath()));
                }
                return lockStatus;
            }
        }
        return Status.OK_STATUS;
    }

    public IStatus acquire(long timeout, IProgressMonitor progress) {
        IStatus status = null;
        long WAIT = 50L;
        long stopTime = System.currentTimeMillis() + timeout;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)((int)(timeout / 50L) + 1));
        while (!(status = this.acquire((IProgressMonitor)monitor.newChild(1))).isOK()) {
            if (stopTime < System.currentTimeMillis()) {
                monitor.done();
                break;
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                status = FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.FilesystemLock_INTERRUPTED, (Object)this.lockFile.getAbsolutePath()), e);
                break;
            }
        }
        return status;
    }

    public IStatus release(IProgressMonitor mon) {
        FilesystemLock.releasePath(this);
        if (this.lock != null) {
            this.lock = null;
        }
        if (this.lockRAF != null) {
            try {
                this.lockRAF.close();
                this.lockRAF = null;
            }
            catch (IOException e) {
                return FileSystemStatusUtil.getStatusFor(1, NLS.bind((String)Messages.FilesystemLock_COULD_NOT_CLOSE_FILE, (Object)this.lockFile.getAbsolutePath()), e);
            }
        }
        this.lockFile.delete();
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IStatus acquirePath(FilesystemLock fsLock) {
        HashMap<File, FilesystemLock> hashMap = lockMap;
        synchronized (hashMap) {
            FilesystemLock conflictingLock = lockMap.get(fsLock.lockFile);
            if (conflictingLock == null) {
                lockMap.put(fsLock.lockFile, fsLock);
            }
            return conflictingLock == null ? Status.OK_STATUS : FileSystemStatusUtil.getStatusFor(1, NLS.bind((String)Messages.FilesystemLock_0, (Object)fsLock.lockFile.getAbsolutePath(), (Object)conflictingLock.lockFile.getAbsolutePath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releasePath(FilesystemLock fsLock) {
        HashMap<File, FilesystemLock> hashMap = lockMap;
        synchronized (hashMap) {
            lockMap.remove(fsLock.lockFile);
        }
    }

    public File getFile() {
        return this.lockFile;
    }

    public IPath getPath() {
        return new Path(this.lockFile.getAbsolutePath());
    }

    public boolean isAcquired() {
        return FilesystemLock.isAquired(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized boolean isAquired(FilesystemLock filesystemLock) {
        HashMap<File, FilesystemLock> hashMap = lockMap;
        synchronized (hashMap) {
            FilesystemLock conflictingLock = lockMap.get(filesystemLock.lockFile);
            return conflictingLock == filesystemLock;
        }
    }
}

