/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.utils;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.internal.content.DeletedContent;
import com.ibm.team.filesystem.client.internal.utils.FileContentDilemmaHandler;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.util.LineDelimiterUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.utils.ReaderToInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class FileContentInputStream
extends InputStream {
    private InputStream underlyingInputStream = null;
    private ITeamRepository repository;
    private IFileItemHandle item;
    private IFileContent content;
    private FileLineDelimiter desiredLineDelimiter;
    private final IProgressMonitor monitor;
    private FileContentDilemmaHandler contentDilemmaHandler;

    public FileContentInputStream(ITeamRepository repository, IFileItemHandle item, IFileContent content, FileContentDilemmaHandler contentDilemmaHandler, IProgressMonitor monitor) {
        this(repository, item, content, content.getLineDelimiter(), contentDilemmaHandler, monitor);
    }

    public FileContentInputStream(ITeamRepository repository, IFileItemHandle item, IFileContent content, FileLineDelimiter desiredLineDelimiter, FileContentDilemmaHandler contentDilemmaHandler, IProgressMonitor monitor) {
        this.repository = repository;
        this.content = content;
        this.desiredLineDelimiter = desiredLineDelimiter;
        this.monitor = monitor;
        this.item = item;
        this.contentDilemmaHandler = contentDilemmaHandler == null ? FileContentDilemmaHandler.getDefault() : contentDilemmaHandler;
    }

    @Override
    public int available() throws IOException {
        if (this.underlyingInputStream == null) {
            return 0;
        }
        return this.underlyingInputStream.available();
    }

    @Override
    public int read() throws IOException {
        InputStream underlyingStream = this.getUnderlyingStream();
        return underlyingStream.read();
    }

    private InputStream getUnderlyingStream() throws IOException {
        if (this.underlyingInputStream == null) {
            try {
                this.underlyingInputStream = FileSystemCore.getContentManager(this.repository).retrieveContentStream(this.item, this.content, this.monitor);
            }
            catch (TeamRepositoryException e) {
                if (DeletedContent.isRootCauseDeletedContent(e)) {
                    int instruction = this.contentDilemmaHandler.versionedContentDeleted(this.item, this.content);
                    if (instruction == 0) {
                        this.underlyingInputStream = DeletedContent.getDeletedContentInputStream(this.content.getCharacterEncoding());
                    }
                    if (instruction == 1) {
                        throw new OperationCanceledException();
                    }
                    IOException ex = new IOException(e.getMessage());
                    ex.initCause(e);
                    throw ex;
                }
                IOException ex = new IOException(e.getMessage());
                ex.initCause(e);
                throw ex;
            }
            if (!(this.content.getLineDelimiter() == this.desiredLineDelimiter || this.content.getLineDelimiter() == FileLineDelimiter.LINE_DELIMITER_PLATFORM && FileLineDelimiter.getPlatformDelimiter() == this.desiredLineDelimiter || this.desiredLineDelimiter == FileLineDelimiter.LINE_DELIMITER_PLATFORM && this.content.getLineDelimiter() == FileLineDelimiter.getPlatformDelimiter() || this.desiredLineDelimiter == FileLineDelimiter.LINE_DELIMITER_NONE)) {
                this.underlyingInputStream = new ReaderToInputStream((InputStreamReader)LineDelimiterUtil.getNonVerifyingLineDelimiterConverter((InputStream)this.underlyingInputStream, (String)this.content.getCharacterEncoding(), (FileLineDelimiter)this.desiredLineDelimiter));
            }
        }
        InputStream underlyingStream = this.underlyingInputStream;
        return underlyingStream;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.getUnderlyingStream().read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.getUnderlyingStream().read(b, off, len);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.getUnderlyingStream().reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.getUnderlyingStream().skip(n);
    }

    @Override
    public void close() throws IOException {
        if (this.underlyingInputStream != null) {
            this.underlyingInputStream.close();
            this.underlyingInputStream = null;
        }
        super.close();
    }
}

