/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.utils;

import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.ConnectionDescriptor;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class ConnectionFacade
extends ConnectionDescriptor {
    private IConnection theConnection;
    private IRepositoryResolver resolver;

    public ConnectionFacade(IConnection connection) {
        super(connection.teamRepository().getId(), connection.teamRepository().getRepositoryURI(), connection.getContextHandle());
        if (!(connection instanceof IWorkspaceConnection) && !(connection instanceof IBaselineConnection)) {
            throw new IllegalArgumentException();
        }
        this.theConnection = connection;
        this.resolver = new IRepositoryResolver(){

            @Override
            public ITeamRepository getRepoFor(String uri, UUID id) {
                return ConnectionFacade.this.theConnection.teamRepository();
            }
        };
    }

    public ConnectionFacade(UUID repositoryId, String repositoryUri, IRepositoryResolver resolver, IContextHandle connectionHandle) {
        super(repositoryId, repositoryUri, connectionHandle);
        this.resolver = resolver;
    }

    public ConnectionFacade(ConnectionDescriptor descriptor, IRepositoryResolver resolver) {
        super(descriptor.id, descriptor.uri, descriptor.connectionHandle);
        this.resolver = resolver;
    }

    public ConnectionFacade(final ITeamRepository repository, IContextHandle connectionHandle) {
        this(repository.getId(), repository.getRepositoryURI(), new IRepositoryResolver(){

            @Override
            public ITeamRepository getRepoFor(String uri, UUID id) {
                return repository;
            }
        }, connectionHandle);
    }

    public ITeamRepository getTeamRepository() throws TeamRepositoryException {
        if (this.theConnection != null) {
            this.theConnection.teamRepository();
        }
        return this.resolver.getRepoFor(this.uri, this.id);
    }

    private IConnection getConnection(WorkspaceIsTrackedParam isTrackedParam, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)progress, (int)10);
        if (this.theConnection == null) {
            ITeamRepository repo;
            try {
                repo = this.getTeamRepository();
            }
            catch (TeamRepositoryException e) {
                repo = null;
            }
            if (repo == null || !repo.loggedIn()) {
                return null;
            }
            IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
            if (this.connectionHandle instanceof IWorkspaceHandle) {
                this.theConnection = isTrackedParam.equals((Object)WorkspaceIsTrackedParam.IS_NOT_TRACKED) ? workspaceManager.getWorkspaceConnectionUntracked((IWorkspaceHandle)this.connectionHandle, (IProgressMonitor)mon) : workspaceManager.getWorkspaceConnection((IWorkspaceHandle)this.connectionHandle, (IProgressMonitor)mon);
            } else if (this.connectionHandle instanceof IBaselineHandle) {
                this.theConnection = workspaceManager.getBaselineConnection((IBaselineHandle)this.connectionHandle, (IProgressMonitor)mon);
            }
        }
        mon.done();
        return this.theConnection;
    }

    public IConnection getConnection(IProgressMonitor progress) throws TeamRepositoryException {
        return this.getConnection(WorkspaceIsTrackedParam.IS_TRACKED_OR_UNKNOWN, progress);
    }

    public IConnection getConnectionUntracked(IProgressMonitor progress) throws TeamRepositoryException {
        return this.getConnection(WorkspaceIsTrackedParam.IS_NOT_TRACKED, progress);
    }

    public IConnection getCachedConnection() {
        if (this.theConnection == null) {
            try {
                ArrayList knownConnections = new ArrayList();
                ITeamRepository teamRepository = this.getTeamRepository();
                knownConnections.addAll(SCMPlatform.getWorkspaceManager((ITeamRepository)teamRepository).knownWorkspaceConnections());
                knownConnections.addAll(SCMPlatform.getWorkspaceManager((ITeamRepository)teamRepository).knownBaselineConnections());
                for (IConnection c : knownConnections) {
                    if (!c.getContextHandle().getItemId().equals((Object)this.getContextHandle().getItemId())) continue;
                    this.theConnection = c;
                    break;
                }
            }
            catch (TeamRepositoryException e) {
                return null;
            }
        }
        return this.theConnection;
    }

    public String getRepositoryURI() {
        return this.uri;
    }

    public IWorkspaceConnection getWorkspaceConnection(IProgressMonitor progress) throws TeamRepositoryException {
        IConnection connection = this.getConnection(progress);
        if (connection instanceof IWorkspaceConnection) {
            return (IWorkspaceConnection)connection;
        }
        return null;
    }

    public boolean describesConnection(IConnection connection) {
        Assert.isNotNull((Object)connection);
        if (this.theConnection == connection) {
            return true;
        }
        return connection.getContextHandle().sameItemId((IItemHandle)this.connectionHandle) && this.id.equals((Object)connection.teamRepository().getId());
    }

    public IContextHandle getContextHandle() {
        return this.connectionHandle;
    }

    public String getName() {
        IConnection cachedConnection = this.getCachedConnection();
        if (cachedConnection != null) {
            return cachedConnection.getName();
        }
        if (this.getContextHandle() instanceof IWorkspace) {
            return ((IWorkspace)this.getContextHandle()).getName();
        }
        return NLS.bind((String)Messages.ConnectionDescriptor_0, (Object)this.getRepositoryURI());
    }

    public boolean sameRepository(IWorkspaceConnection connection) {
        IConnection cachedConnection = this.getCachedConnection();
        if (cachedConnection != null) {
            return connection.sameRepository(cachedConnection);
        }
        return this.id.equals((Object)connection.teamRepository().getId());
    }

    public static IConnection getConnection(ITeamRepository teamRepository, IContextHandle connectionHandle, IProgressMonitor mon) throws TeamRepositoryException {
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)teamRepository);
        if (connectionHandle instanceof IWorkspaceHandle) {
            return workspaceManager.getWorkspaceConnection((IWorkspaceHandle)connectionHandle, mon);
        }
        if (connectionHandle instanceof IBaselineHandle) {
            return workspaceManager.getBaselineConnection((IBaselineHandle)connectionHandle, mon);
        }
        return null;
    }

    public static enum WorkspaceIsTrackedParam {
        IS_TRACKED_OR_UNKNOWN,
        IS_NOT_TRACKED;

    }
}

