/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.utils;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.operations.IFilesystemRefresher;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.ConnectionFacade;
import com.ibm.team.filesystem.client.internal.utils.RationalizingTree;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IItemConflictReport;
import com.ibm.team.scm.common.dto.INameItemPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public abstract class ChangeSetRefreshUtils {
    public static void refreshForBaselineChange(IFilesystemRefresher refresher, Collection<ISandbox> sandboxes, IWorkspaceConnection wsConn, List<IBaselineHandle> blHandles, IProgressMonitor progress) throws FileSystemException, TeamRepositoryException {
        ChangeSetRefreshUtils.refreshForBaselineChange(refresher, sandboxes, wsConn, wsConn.teamRepository(), blHandles, progress);
    }

    public static void refreshForBaselineChange(IFilesystemRefresher refresher, Collection<ISandbox> sandboxes, IWorkspaceConnection wsConn, ITeamRepository repo, List<IBaselineHandle> blHandles, IProgressMonitor progress) throws FileSystemException, TeamRepositoryException {
        if (blHandles.isEmpty()) {
            return;
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress);
        monitor.setWorkRemaining(2 * blHandles.size());
        List baselines = repo.itemManager().fetchCompleteItems(blHandles, 0, (IProgressMonitor)monitor.newChild(blHandles.size()));
        for (IBaseline bl : baselines) {
            refresher.addToRefresh(sandboxes, wsConn.getContextHandle(), bl.getComponent(), (IProgressMonitor)monitor.newChild(1));
        }
    }

    public static void refreshForBaselineConnectionDescriptorChange(IFilesystemRefresher refresher, Collection<ISandbox> sandboxes, IWorkspaceConnection wsConn, List<ConnectionFacade> descriptors, IProgressMonitor progress) throws FileSystemException, TeamRepositoryException {
        if (descriptors.isEmpty()) {
            return;
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress);
        monitor.setWorkRemaining(descriptors.size() * 2);
        HashMap<ITeamRepository, ArrayList<IBaselineHandle>> baselinesByRepo = new HashMap<ITeamRepository, ArrayList<IBaselineHandle>>();
        for (ConnectionFacade descriptor : descriptors) {
            ITeamRepository repo = descriptor.getTeamRepository();
            ArrayList<IBaselineHandle> baselines = (ArrayList<IBaselineHandle>)baselinesByRepo.get(repo);
            if (baselines == null) {
                baselines = new ArrayList<IBaselineHandle>();
            }
            baselines.add((IBaselineHandle)descriptor.connectionHandle);
            baselinesByRepo.put(repo, baselines);
        }
        for (ITeamRepository repo : baselinesByRepo.keySet()) {
            List itemHandles = (List)baselinesByRepo.get(repo);
            ChangeSetRefreshUtils.refreshForBaselineChange(refresher, sandboxes, wsConn, repo, itemHandles, (IProgressMonitor)monitor.newChild(1));
        }
    }

    public static void refreshLocalForAddition(IFilesystemRefresher refresher, Map<ISandbox, Set<ConfigurationFacade>> affectedAreas, IWorkspaceConnection workspaceConnection, List<IChangeSetHandle> changeSetHandles, IProgressMonitor progress) throws FileSystemException, TeamRepositoryException {
        ChangeSetRefreshUtils.refreshLocalForAddition(refresher, affectedAreas, workspaceConnection.teamRepository(), workspaceConnection, changeSetHandles, progress);
    }

    public static void refreshLocalForAddition(IFilesystemRefresher refresher, Map<ISandbox, Set<ConfigurationFacade>> affectedAreas, ITeamRepository repo, IWorkspaceConnection workspaceConnection, List<IChangeSetHandle> changeSetHandles, IProgressMonitor progress) throws FileSystemException, TeamRepositoryException {
        ChangeSetRefreshUtils.refreshLocalFor(new VersionableExtractor(){

            @Override
            public IVersionableHandle extract(IChange change) {
                IVersionableHandle refreshState = change.afterState();
                if (refreshState == null) {
                    refreshState = change.beforeState();
                }
                return refreshState;
            }
        }, repo, workspaceConnection, changeSetHandles, refresher, affectedAreas, progress);
    }

    public static void refreshLocalForRemoval(IFilesystemRefresher refresher, Map<ISandbox, Set<ConfigurationFacade>> affectedAreas, IWorkspaceConnection workspaceConnection, List<? extends IChangeSetHandle> changeSetHandles, IProgressMonitor progress) throws FileSystemException, TeamRepositoryException {
        ChangeSetRefreshUtils.refreshLocalFor(new VersionableExtractor(){

            @Override
            public IVersionableHandle extract(IChange change) {
                IVersionableHandle refreshState = change.beforeState();
                if (refreshState == null) {
                    refreshState = change.afterState();
                }
                return refreshState;
            }
        }, workspaceConnection, changeSetHandles, refresher, affectedAreas, progress);
    }

    public static List<IShareable> rationalizeRefreshTree(Collection<IShareable> shareables) {
        HashMap<ISandbox, RationalizingTree<String, IShareable>> rationalized = new HashMap<ISandbox, RationalizingTree<String, IShareable>>();
        for (IShareable shareable : shareables) {
            RationalizingTree<String, IShareable> tree = (RationalizingTree<String, IShareable>)rationalized.get(shareable.getSandbox());
            if (tree == null) {
                tree = new RationalizingTree<String, IShareable>();
                rationalized.put(shareable.getSandbox(), tree);
            }
            tree.put(shareable.getLocalPath().segments(), shareable);
        }
        ArrayList<IShareable> toReturn = new ArrayList<IShareable>(shareables.size());
        for (RationalizingTree tree : rationalized.values()) {
            for (IShareable shareable : tree) {
                toReturn.add(shareable);
            }
        }
        return toReturn;
    }

    private static void refreshLocalFor(VersionableExtractor versionableExtractor, IWorkspaceConnection workspaceConnection, List<? extends IChangeSetHandle> changeSetHandles, IFilesystemRefresher refresher, Map<ISandbox, Set<ConfigurationFacade>> affectedAreas, IProgressMonitor progress) throws TeamRepositoryException, FileSystemException {
        ChangeSetRefreshUtils.refreshLocalFor(versionableExtractor, workspaceConnection.teamRepository(), workspaceConnection, changeSetHandles, refresher, affectedAreas, progress);
    }

    private static void refreshLocalFor(VersionableExtractor versionableExtractor, ITeamRepository repo, IWorkspaceConnection workspaceConnection, List<? extends IChangeSetHandle> changeSetHandles, IFilesystemRefresher refresher, Map<ISandbox, Set<ConfigurationFacade>> affectedAreas, IProgressMonitor progress) throws TeamRepositoryException, FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)5);
        List cses = repo.itemManager().fetchCompleteItems(changeSetHandles, 0, (IProgressMonitor)monitor.newChild(1));
        LinkedList<IVersionableHandle> evilTwinCandidates = new LinkedList<IVersionableHandle>();
        ArrayList<IComponentHandle> evilTwinComp = new ArrayList<IComponentHandle>();
        Set<ISandbox> sandboxes = affectedAreas.keySet();
        SubMonitor csMonitor = monitor.newChild(1, 2);
        csMonitor.beginTask(null, cses.size());
        for (IChangeSet cs : cses) {
            SubMonitor changeMonitor = csMonitor.newChild(1);
            changeMonitor.beginTask(null, 2);
            for (IChange change : cs.changes()) {
                IVersionableHandle refreshState = versionableExtractor.extract(change);
                if (refreshState == null) continue;
                evilTwinCandidates.add(refreshState);
                evilTwinComp.add(cs.getComponent());
                Collection<IShareable> shareables = ChangeSetRefreshUtils.getAllShareablesFor(workspaceConnection.getContextHandle(), cs.getComponent(), change.item(), sandboxes, changeMonitor.newChild(1));
                refresher.addToRefresh(shareables);
            }
        }
        SubMonitor compMonitor = monitor.newChild(1);
        Collection<IComponentHandle> comps = ChangeSetRefreshUtils.findComponentsIn(affectedAreas, workspaceConnection);
        compMonitor.setWorkRemaining(comps.size());
        for (IComponentHandle comp : comps) {
            SubMonitor conflictMonitor = compMonitor.newChild(1);
            Collection conflicts = workspaceConnection.conflictReport(comp).conflicts();
            conflictMonitor.setWorkRemaining(conflicts.size());
            for (IItemConflictReport conflict : conflicts) {
                IVersionableHandle after = conflict.getProposedContributorState();
                if (after != null) {
                    evilTwinCandidates.add(after);
                    evilTwinComp.add(conflict.getComponent());
                }
                Collection<IShareable> shareables = ChangeSetRefreshUtils.getAllShareablesFor(workspaceConnection.getContextHandle(), conflict.getComponent(), conflict.item(), sandboxes, conflictMonitor.newChild(1));
                refresher.addToRefresh(shareables);
            }
        }
        List fullEvilTwinCandidates = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).versionableManager().fetchCompleteStates(evilTwinCandidates, (IProgressMonitor)monitor.newChild(1));
        ArrayList<IFolderHandle> evilTwinParents = new ArrayList<IFolderHandle>(fullEvilTwinCandidates.size());
        ArrayList<String> evilTwinNames = new ArrayList<String>(fullEvilTwinCandidates.size());
        for (IVersionable evilTwinCandidate : fullEvilTwinCandidates) {
            if (evilTwinCandidate != null) {
                evilTwinParents.add(evilTwinCandidate.getParent());
                evilTwinNames.add(evilTwinCandidate.getName());
                continue;
            }
            evilTwinParents.add(null);
            evilTwinNames.add("");
        }
        SubMonitor evilTwinMonitor = monitor.newChild(1);
        evilTwinMonitor.setWorkRemaining(evilTwinCandidates.size());
        int i = 0;
        while (i < evilTwinCandidates.size()) {
            SubMonitor sandboxMonitor = evilTwinMonitor.newChild(1);
            sandboxMonitor.setWorkRemaining(affectedAreas.size());
            for (ISandbox sb : affectedAreas.keySet()) {
                String diskName;
                IShareable parent;
                IVersionableHandle evilTwinParent = (IVersionableHandle)evilTwinParents.get(i);
                if (evilTwinParent == null || (parent = sb.findShareable(workspaceConnection.getContextHandle(), (IComponentHandle)evilTwinComp.get(i), evilTwinParent, (IProgressMonitor)evilTwinMonitor.newChild(1))) == null) continue;
                IShareable evilTwin = sb.findShareable(parent.getLocalPath().append((String)evilTwinNames.get(i)), ResourceType.getResourceType((IVersionableHandle)fullEvilTwinCandidates.get(i)));
                if (!sb.isCaseSensitive() && evilTwin.exists((IProgressMonitor)evilTwinMonitor.newChild(1)) && !(diskName = ((Shareable)evilTwin).getFileStorage().getActualName()).equals(evilTwin.getLocalPath().getName())) {
                    evilTwin = sb.findShareable(parent.getLocalPath().append(diskName), ResourceType.getResourceType((IVersionableHandle)fullEvilTwinCandidates.get(i)));
                }
                refresher.addToRefresh(evilTwin);
            }
            ++i;
        }
    }

    public static Collection<IShareable> refreshLocalForLogicalChanges(IWorkspaceConnection workspaceConnection, Set<ISandbox> sandboxes, Collection<ILogicalChange> changes, IProgressMonitor progress) throws TeamRepositoryException, FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(3 * changes.size() * sandboxes.size()));
        HashSet<IShareable> result = new HashSet<IShareable>();
        IContextHandle context = workspaceConnection.getContextHandle();
        for (ILogicalChange change : changes) {
            IComponentHandle component = change.component();
            IVersionableHandle item = change.item();
            for (ISandbox sandbox : sandboxes) {
                IShareable parent;
                IShareable shareable = sandbox.findShareable(context, component, item, (IProgressMonitor)monitor.newChild(1));
                if (shareable != null) {
                    result.add(shareable);
                }
                if ((parent = sandbox.findShareable(context, component, (IVersionableHandle)change.parent(), (IProgressMonitor)monitor.newChild(1))) == null) continue;
                String name = null;
                List hint = change.isChangeType(32) ? null : (change.isChangeType(8) ? change.getNewAncestorPathHint() : change.getAncestorPathHint());
                if (hint == null || hint.size() <= 1) continue;
                name = ((INameItemPair)hint.get(hint.size() - 1)).getName();
                shareable = sandbox.findShareable(parent.getLocalPath().append(name), ResourceType.getResourceType(item));
                if (shareable == null) continue;
                result.add(shareable);
            }
        }
        return result;
    }

    private static Collection<IComponentHandle> findComponentsIn(Map<ISandbox, Set<ConfigurationFacade>> affectedAreas, IWorkspaceConnection workspaceConnection) throws TeamRepositoryException {
        HashMap<UUID, IComponentHandle> components = new HashMap<UUID, IComponentHandle>();
        List componentHandles = workspaceConnection.getComponents();
        for (Set<ConfigurationFacade> descriptors : affectedAreas.values()) {
            block1: for (ConfigurationFacade desc : descriptors) {
                for (IComponentHandle componentHandle : componentHandles) {
                    if (!componentHandle.getItemId().equals((Object)desc.getComponentHandle().getItemId())) continue;
                    components.put(desc.getComponentHandle().getItemId(), desc.getComponentHandle());
                    continue block1;
                }
            }
        }
        return components.values();
    }

    private static Collection<IShareable> getAllShareablesFor(IContextHandle ctx, IComponentHandle comp, IVersionableHandle versionable, Collection<ISandbox> sandboxes, SubMonitor monitor) throws FileSystemException {
        ArrayList<IShareable> shareables = new ArrayList<IShareable>(sandboxes.size());
        monitor = SubMonitor.convert((IProgressMonitor)monitor, (int)sandboxes.size());
        for (ISandbox sb : sandboxes) {
            IShareable shareable = sb.findShareable(ctx, comp, versionable, (IProgressMonitor)monitor.newChild(1));
            if (shareable == null) continue;
            shareables.add(shareable);
        }
        return shareables;
    }

    private static interface VersionableExtractor {
        public IVersionableHandle extract(IChange var1);
    }
}

