/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.snapshot;

import com.ibm.team.filesystem.client.internal.namespace.ItemLocator;
import com.ibm.team.filesystem.client.internal.snapshot.ISnapshot;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.client.internal.snapshot.WorkspaceSnapshot;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ISimpleItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import org.eclipse.core.runtime.IProgressMonitor;

public final class WorkspaceId
extends SnapshotId {
    private ItemLocator<IWorkspace> id;

    public WorkspaceId(ItemLocator<IWorkspace> id) {
        this.id = id;
    }

    @Override
    public ISnapshot createSnapshot(IProgressMonitor progress) throws TeamRepositoryException {
        return WorkspaceSnapshot.create((IWorkspaceConnection)this.getConnection(progress));
    }

    public static WorkspaceId create(ItemLocator<IWorkspace> baseline) {
        return new WorkspaceId(baseline);
    }

    public static WorkspaceId create(ITeamRepository repository, IWorkspaceHandle baseline) {
        ItemLocator<IWorkspace> locator = ItemLocator.create(repository, (ISimpleItemHandle)baseline);
        return WorkspaceId.create(locator);
    }

    public static WorkspaceId create(ITeamRepository repository, ItemId<IWorkspace> baseline) {
        ItemLocator<IWorkspace> locator = ItemLocator.create(repository, baseline);
        return WorkspaceId.create(locator);
    }

    @Override
    public IItemHandle getIdentifyingHandle() {
        return this.id.toHandle();
    }

    @Override
    public IConnection getConnection(IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkspaceManager mgr = SCMPlatform.getWorkspaceManager((ITeamRepository)this.id.getRepository());
        return mgr.getWorkspaceConnection((IWorkspaceHandle)this.id.toHandle(), monitor);
    }

    @Override
    public ITeamRepository getRepository() {
        return this.id.getRepository();
    }

    public ItemLocator<IWorkspace> getId() {
        return this.id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WorkspaceId other = (WorkspaceId)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public IWorkspaceHandle getWorkspaceHandle() {
        return (IWorkspaceHandle)this.id.toHandle();
    }
}

