/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.snapshot;

import com.ibm.team.filesystem.client.internal.era.EraDescriptor;
import com.ibm.team.filesystem.client.internal.namespace.EraNamespace;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.filesystem.client.internal.snapshot.BaselineId;
import com.ibm.team.filesystem.client.internal.snapshot.BaselineSetId;
import com.ibm.team.filesystem.client.internal.snapshot.HistoryReferenceId;
import com.ibm.team.filesystem.client.internal.snapshot.ISnapshot;
import com.ibm.team.filesystem.client.internal.snapshot.NamespaceSetId;
import com.ibm.team.filesystem.client.internal.snapshot.WorkspaceId;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.collection.SoftValueMap;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IHistoryReference;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.ChangeHistoryHandle;
import com.ibm.team.scm.common.internal.ScmFactory;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class SnapshotId {
    private static SoftValueMap<SnapshotId, ISnapshot> snapshotCache = new SoftValueMap();

    public static SnapshotId createEmptyId(ITeamRepository repo) {
        return NamespaceSetId.create(repo, Collections.emptySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ISnapshot getSnapshot(IProgressMonitor monitor) throws TeamRepositoryException {
        ISnapshot result;
        SoftValueMap<SnapshotId, ISnapshot> softValueMap = snapshotCache;
        synchronized (softValueMap) {
            result = (ISnapshot)snapshotCache.get((Object)this);
            if (result != null) {
                return result;
            }
        }
        result = this.createSnapshot(monitor);
        softValueMap = snapshotCache;
        synchronized (softValueMap) {
            snapshotCache.put((Object)this, (Object)result);
        }
        return result;
    }

    protected abstract ISnapshot createSnapshot(IProgressMonitor var1) throws TeamRepositoryException;

    public abstract ITeamRepository getRepository();

    public abstract IItemHandle getIdentifyingHandle();

    public static SnapshotId getSnapshotId(IItemHandle itemHandle) {
        if (itemHandle == null || !(itemHandle.getOrigin() instanceof ITeamRepository)) {
            throw new IllegalArgumentException("Handle must have a team repository origin");
        }
        return SnapshotId.getSnapshotId((ITeamRepository)itemHandle.getOrigin(), itemHandle);
    }

    public static SnapshotId getSnapshotId(IHistoryReference reference, ITeamRepository repo) {
        return HistoryReferenceId.create(repo, reference);
    }

    public static SnapshotId getSnapshotId(ITeamRepository repo, IItemHandle itemHandle) {
        if (itemHandle instanceof IBaselineHandle) {
            IBaselineHandle baseline = (IBaselineHandle)itemHandle;
            return BaselineId.create(repo, baseline);
        }
        if (itemHandle instanceof IBaselineSetHandle) {
            IBaselineSetHandle baselineSet = (IBaselineSetHandle)itemHandle;
            return BaselineSetId.create(repo, baselineSet);
        }
        if (itemHandle instanceof IWorkspaceHandle) {
            IWorkspaceHandle workspace = (IWorkspaceHandle)itemHandle;
            return WorkspaceId.create(repo, workspace);
        }
        return SnapshotId.createEmptyId(repo);
    }

    public static SnapshotId getSnapshotId(ITeamRepository repo, Map<String, IItemHandle> handles, IProgressMonitor monitor) throws TeamRepositoryException {
        if (handles == null || handles.isEmpty()) {
            throw new IllegalArgumentException("Handles must not be null or empty");
        }
        if (handles.size() == 1) {
            return SnapshotId.getSnapshotId(repo, handles.values().iterator().next());
        }
        IItemType changeHistoryType = ScmFactory.eINSTANCE.createChangeHistoryHandle().getItemType();
        IWorkspaceHandle workspace = (IWorkspaceHandle)handles.get(IWorkspace.ITEM_TYPE.getName());
        IComponentHandle component = (IComponentHandle)handles.get(IComponent.ITEM_TYPE.getName());
        ChangeHistoryHandle era = (ChangeHistoryHandle)handles.get(changeHistoryType.getName());
        if (workspace != null && component != null && era != null) {
            WorkspaceNamespace workspaceNamespace = WorkspaceNamespace.create(repo, workspace.getItemId(), component.getItemId());
            EraNamespace namespace = EraNamespace.create(EraDescriptor.createStaticDescriptor(workspaceNamespace, era, monitor));
            return NamespaceSetId.create(namespace);
        }
        return SnapshotId.createEmptyId(repo);
    }

    public boolean isEmpty() {
        return false;
    }

    public IConnection getConnection(IProgressMonitor monitor) throws TeamRepositoryException {
        return null;
    }
}

