/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.snapshot;

import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.namespace.IItemContext;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.snapshot.AbstractSnapshot;
import com.ibm.team.filesystem.client.internal.snapshot.ISnapshot;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.client.internal.snapshot.WorkspaceId;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IHistoryReference;
import com.ibm.team.scm.common.dto.IHistoryReferenceDescription;
import com.ibm.team.scm.common.internal.dto2.WorkspaceComponentState;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class HistoryReferenceSnapshot
extends AbstractSnapshot {
    private ITeamRepository repository;
    private IHistoryReferenceDescription description;
    private ISnapshot workspaceSnapshot;

    private HistoryReferenceSnapshot(IHistoryReferenceDescription description, ISnapshot workspaceSnapshot, ITeamRepository repository) {
        if (!(description.getHistoryReference() instanceof WorkspaceComponentState)) {
            throw new IllegalArgumentException();
        }
        this.description = description;
        this.repository = repository;
        this.workspaceSnapshot = workspaceSnapshot;
    }

    public static ISnapshot create(IHistoryReference reference, ITeamRepository repository, IProgressMonitor monitor) throws TeamRepositoryException {
        if (reference instanceof IItemHandle) {
            SnapshotId snapshotId = SnapshotId.getSnapshotId(repository, (IItemHandle)reference);
            return snapshotId.getSnapshot(monitor);
        }
        if (reference instanceof WorkspaceComponentState) {
            IWorkspaceManager mgr = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
            WorkspaceComponentState wcs = (WorkspaceComponentState)reference;
            IComponentHandle[] filter = new IComponentHandle[]{wcs.getComponent()};
            IHistoryReferenceDescription historyDescription = mgr.getHistoryDescription(reference, filter, monitor);
            return new HistoryReferenceSnapshot(historyDescription, null, repository);
        }
        return SnapshotId.createEmptyId(repository).getSnapshot(monitor);
    }

    @Override
    public IHistoryReference getHistoryReference() {
        return this.description.getHistoryReference();
    }

    @Override
    public Set<ItemNamespace> getNamespaces(IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        ISnapshot snapshot = this.getWorkspaceSnapshot((IProgressMonitor)progress.newChild(1));
        return snapshot.getNamespaces((IProgressMonitor)progress.newChild(1));
    }

    @Override
    public ItemNamespace getNamespaceFor(ItemId<IComponent> component, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        ISnapshot snapshot = this.getWorkspaceSnapshot((IProgressMonitor)progress.newChild(1));
        return snapshot.getNamespaceFor(component, (IProgressMonitor)progress.newChild(1));
    }

    @Override
    public Map<ItemId<IComponent>, IItemContext> getContexts(IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        ISnapshot snapshot = this.getWorkspaceSnapshot((IProgressMonitor)progress.newChild(1));
        return snapshot.getContexts((IProgressMonitor)progress.newChild(1));
    }

    @Override
    public String getName() {
        Date date = new Date(this.description.getDate());
        return NLS.bind((String)Messages.HistoryReference_NAME_DATE, (Object)this.description.getName(), (Object[])new Object[]{date});
    }

    @Override
    public ITeamRepository getRepository() {
        return this.repository;
    }

    private ISnapshot getWorkspaceSnapshot(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.workspaceSnapshot == null) {
            WorkspaceComponentState wcs = (WorkspaceComponentState)this.description.getHistoryReference();
            this.workspaceSnapshot = WorkspaceId.create(this.repository, wcs.getWorkspace()).getSnapshot(monitor);
        }
        monitor.done();
        return this.workspaceSnapshot;
    }
}

