/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.snapshot;

import com.ibm.team.filesystem.client.internal.snapshot.BaselineSetId;
import com.ibm.team.filesystem.client.internal.snapshot.HistoryReferenceSnapshot;
import com.ibm.team.filesystem.client.internal.snapshot.ISnapshot;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.client.internal.snapshot.WorkspaceId;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IHistoryReference;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.dto2.WorkspaceComponentState;
import org.eclipse.core.runtime.IProgressMonitor;

public class HistoryReferenceId
extends SnapshotId {
    private ITeamRepository repository;
    private WorkspaceComponentState state;

    private HistoryReferenceId(WorkspaceComponentState state, ITeamRepository repository) {
        this.state = state;
        this.repository = repository;
    }

    public static SnapshotId create(ITeamRepository repository, IHistoryReference reference) {
        if (reference instanceof IWorkspaceHandle) {
            return WorkspaceId.create(repository, (IWorkspaceHandle)reference);
        }
        if (reference instanceof IBaselineSetHandle) {
            return BaselineSetId.create(repository, (IBaselineSetHandle)reference);
        }
        if (reference instanceof WorkspaceComponentState) {
            WorkspaceComponentState wcs = (WorkspaceComponentState)reference;
            return new HistoryReferenceId(wcs, repository);
        }
        return SnapshotId.createEmptyId(repository);
    }

    @Override
    protected ISnapshot createSnapshot(IProgressMonitor monitor) throws TeamRepositoryException {
        return HistoryReferenceSnapshot.create((IHistoryReference)this.state, this.repository, monitor);
    }

    @Override
    public ITeamRepository getRepository() {
        return this.repository;
    }

    @Override
    public IItemHandle getIdentifyingHandle() {
        return null;
    }

    public IWorkspaceHandle getWorkspaceHandle() {
        return this.state.getWorkspace();
    }

    public int hashCode() {
        return this.state.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof HistoryReferenceId)) {
            return false;
        }
        HistoryReferenceId other = (HistoryReferenceId)o;
        return this.repository.equals(other.repository) && this.state.equals(other.state);
    }
}

