/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.snapshot;

import com.ibm.team.filesystem.client.internal.namespace.BaselineNamespace;
import com.ibm.team.filesystem.client.internal.namespace.EmptyNamespace;
import com.ibm.team.filesystem.client.internal.namespace.IItemContext;
import com.ibm.team.filesystem.client.internal.namespace.ItemFetcher;
import com.ibm.team.filesystem.client.internal.namespace.ItemLocator;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.impl.BaselineContext;
import com.ibm.team.filesystem.client.internal.snapshot.AbstractSnapshot;
import com.ibm.team.filesystem.client.util.ConnectionUtil;
import com.ibm.team.filesystem.common.internal.util.ItemUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IHistoryReference;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.ItemLists;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public class BaselineSetSnapshot
extends AbstractSnapshot {
    private ITeamRepository repository;
    private IBaselineSet snapshot;

    public static BaselineSetSnapshot create(ItemLocator<IBaselineSet> snapshotLocator, IProgressMonitor monitor) throws TeamRepositoryException {
        IBaselineSet snapshot = ItemFetcher.fetchCurrent(snapshotLocator, monitor);
        return new BaselineSetSnapshot(snapshotLocator.getRepository(), snapshot);
    }

    private BaselineSetSnapshot(ITeamRepository repository, IBaselineSet snapshot) {
        this.repository = repository;
        this.snapshot = snapshot;
    }

    public IBaselineSet getSnapshot() {
        return this.snapshot;
    }

    @Override
    public ITeamRepository getRepository() {
        return this.repository;
    }

    @Override
    public String getName() {
        return this.snapshot.getName();
    }

    @Override
    public IHistoryReference getHistoryReference() {
        return (IHistoryReference)this.snapshot.getItemHandle();
    }

    @Override
    public Map<ItemId<IComponent>, IItemContext> getContexts(IProgressMonitor monitor) throws TeamRepositoryException {
        List baselineList = this.snapshot.getBaselines();
        IWorkspaceManager mgr = SCMPlatform.getWorkspaceManager((ITeamRepository)this.repository);
        HashMap result = NewCollection.hashMap();
        List baselineConnections = mgr.getBaselineConnections(baselineList, monitor);
        for (IBaselineConnection baselineConnection : baselineConnections) {
            result.put(ConnectionUtil.getComponent(baselineConnection), new BaselineContext(baselineConnection));
        }
        return result;
    }

    @Override
    public ItemNamespace getNamespaceFor(ItemId<IComponent> component, IProgressMonitor monitor) throws TeamRepositoryException {
        List baselineHandles = ItemLists.handlesToIds((Collection)this.snapshot.getBaselines());
        Collection baselines = RepoFetcher.fetchCurrents((ITeamRepository)this.repository, (Collection)baselineHandles, (boolean)false, (IProgressMonitor)monitor).values();
        for (IBaseline next : baselines) {
            ItemId nextComponent = ItemUtil.getComponent((IBaseline)next);
            if (!nextComponent.equals(component)) continue;
            return BaselineNamespace.create(this.repository, (IBaselineHandle)next);
        }
        return EmptyNamespace.create(this.repository, component);
    }

    @Override
    public Set<ItemNamespace> getNamespaces(IProgressMonitor monitor) throws TeamRepositoryException {
        List baselineHandles = this.snapshot.getBaselines();
        HashSet result = NewCollection.hashSet();
        for (IBaselineHandle next : baselineHandles) {
            result.add(BaselineNamespace.create(this.repository, next));
        }
        return result;
    }
}

