/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.share;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Sandbox;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaUtil;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreasLock;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.operations.IFilesystemRefresher;
import com.ibm.team.filesystem.client.internal.utils.ChangeSetRefreshUtils;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.RepoIdConnectionComponentTriple;
import com.ibm.team.filesystem.client.operations.ICheckinOperation;
import com.ibm.team.filesystem.client.operations.ICheckinOptions;
import com.ibm.team.filesystem.client.operations.IUnshareOperation;
import com.ibm.team.filesystem.client.operations.UnshareDilemmaHandler;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.internal.ConfigurationDescriptor;
import com.ibm.team.scm.client.internal.IConfigurationDescriptor;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class UnshareOperation
extends FileSystemOperation
implements IUnshareOperation,
ICheckinOptions {
    private ArrayList<IShare> sharesToUnshare;
    private boolean deleteContent = false;
    private Map<IConfigurationDescriptor, List<Shareable>> shareablesToUnshare;
    private ArrayList<IConfigurationDescriptor> configurationsToUnshare;
    private UnshareDilemmaHandler unshareDilemmaHandler;
    private final Log traceLog;
    private boolean refreshBeforeRun = false;
    private boolean nonAtomicCommitIsAnOption = true;
    private int nonAtomicCommitFileUploadLimit = 200;
    private IRepositoryResolver resolver;
    private Comparator<Shareable> comparator = new Comparator<Shareable>(){

        @Override
        public int compare(Shareable one, Shareable two) {
            int result = two.getLocalPath().segmentCount() - one.getLocalPath().segmentCount();
            return result == 0 ? two.getLocalPath().toString().compareTo(one.getLocalPath().toString()) : result;
        }
    };

    public UnshareOperation(UnshareDilemmaHandler dilemmaHandler, IRepositoryResolver resolver) {
        super(dilemmaHandler == null ? UnshareDilemmaHandler.getDefault() : dilemmaHandler);
        this.unshareDilemmaHandler = (UnshareDilemmaHandler)this.getDilemmaHandler();
        this.configurationsToUnshare = new ArrayList();
        this.sharesToUnshare = new ArrayList();
        this.shareablesToUnshare = new HashMap<IConfigurationDescriptor, List<Shareable>>();
        this.resolver = resolver;
        Log log = LoggingHelper.getLog(UnshareOperation.class);
        this.traceLog = log != null && log.isTraceEnabled() ? log : null;
    }

    private void traceIfEnabled(String message) {
        if (this.traceLog != null && this.traceLog.isTraceEnabled()) {
            this.traceLog.trace((Object)message);
        }
    }

    @Override
    public void requestUnshareShares(Collection<IShare> sharesToUnshare) {
        this.sharesToUnshare.addAll(sharesToUnshare);
    }

    @Override
    public void requestUnshare(IConnection connection, Collection<? extends IComponentHandle> components) {
        if (connection == null) {
            throw new IllegalArgumentException("connection cannot be null");
        }
        if (components == null) {
            throw new IllegalArgumentException("component cannot be null");
        }
        for (IComponentHandle iComponentHandle : components) {
            ITeamRepository teamRepository = connection.teamRepository();
            this.configurationsToUnshare.add((IConfigurationDescriptor)new ConfigurationDescriptor(teamRepository.getId(), teamRepository.getRepositoryURI(), connection.getContextHandle(), iComponentHandle));
        }
    }

    @Override
    public void requestUnshare(Collection<? extends IConfigurationDescriptor> configurationsToUnshare) {
        if (configurationsToUnshare == null) {
            throw new IllegalArgumentException();
        }
        this.configurationsToUnshare.addAll(configurationsToUnshare);
    }

    @Override
    public void setDeleteContent(boolean deleteContentOnUnshare) {
        this.deleteContent = deleteContentOnUnshare;
    }

    private void checkinPendingChanges(Set<IConfigurationDescriptor> affectedConfigurations, UnshareDilemmaHandler problemHandler, IProgressMonitor progress) throws FileSystemException, TeamRepositoryException {
        HashMap<IConfigurationDescriptor, List<ILocalChange>> checkin = new HashMap<IConfigurationDescriptor, List<ILocalChange>>();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)150);
        Map<ISandbox, Set<IConfigurationDescriptor>> affectedAreas = this.getCopyFileAreasAffected(affectedConfigurations, (IProgressMonitor)monitor.newChild(1));
        if (this.getRefreshBeforeRun()) {
            monitor.setTaskName(Messages.ChangeHistoryChangeSetsOperation_REFRESHING_FILESYSTEM);
            Refresher refresher = new Refresher();
            this.refreshLocal(refresher, affectedAreas, (IProgressMonitor)monitor.newChild(10));
            List<IShareable> shareables = ChangeSetRefreshUtils.rationalizeRefreshTree(refresher.shareables);
            monitor.setWorkRemaining(110 + shareables.size() * 2);
            for (IShareable shareable : shareables) {
                ((Shareable)shareable).getFileStorage().refreshCachedSubTree(Integer.MAX_VALUE, (IProgressMonitor)monitor.newChild(1));
            }
            LocalChangeManager.getInstance().refreshChanges(shareables, (IProgressMonitor)monitor.newChild(shareables.size()));
            SubMonitor syncMon = monitor.newChild(10);
            syncMon.setWorkRemaining(affectedAreas.size());
            for (Map.Entry<ISandbox, Set<IConfigurationDescriptor>> area : affectedAreas.entrySet()) {
                SubMonitor descMon = syncMon.newChild(1);
                descMon.setWorkRemaining(area.getValue().size());
                for (IConfigurationDescriptor desc : area.getValue()) {
                    LocalChangeManager.getInstance().syncPendingChanges(desc.getConnectionHandle(), desc.getComponentHandle(), area.getKey(), (IProgressMonitor)descMon.newChild(1));
                }
            }
        }
        monitor.setWorkRemaining(100);
        SubMonitor iterProgress = monitor.newChild(5).setWorkRemaining(affectedAreas.size());
        for (Map.Entry<ISandbox, Set<IConfigurationDescriptor>> entry : affectedAreas.entrySet()) {
            ISandbox sandbox = entry.getKey();
            Set<IConfigurationDescriptor> configurationsForCFA = entry.getValue();
            SubMonitor subIterProgress = iterProgress.newChild(1).setWorkRemaining(configurationsForCFA.size());
            for (IConfigurationDescriptor descriptor : configurationsForCFA) {
                ILocalChangeManager lcm = FileSystemCore.getSharingManager().getLocalChangeManager();
                lcm.syncPendingChanges(descriptor.getConnectionHandle(), descriptor.getComponentHandle(), sandbox, (IProgressMonitor)subIterProgress.newChild(1));
                ILocalChange[] localChanges = lcm.getPendingChanges(descriptor.getConnectionHandle(), descriptor.getComponentHandle(), sandbox);
                if (localChanges.length <= 0) continue;
                List<ILocalChange> changes = Arrays.asList(localChanges);
                changes = Collections.unmodifiableList(changes);
                checkin.put(descriptor, changes);
            }
        }
        if (!checkin.isEmpty()) {
            int result = problemHandler.uncheckedInChanges(Collections.unmodifiableMap(checkin));
            if (result == 0) {
                SubMonitor subProgress = monitor.newChild(10).setWorkRemaining(checkin.size() * 2);
                ICheckinOperation op = IOperationFactory.instance.getCheckinOperation(problemHandler.getCommitDilemmaHandler(), this.resolver);
                if (this.nonAtomicCommitIsAnOption) {
                    op.enableNonAtomicCommit(this.nonAtomicCommitFileUploadLimit);
                } else {
                    op.disableNonAtomicCommit();
                }
                op.setRefreshBeforeRun(false);
                for (Map.Entry entry : checkin.entrySet()) {
                    Collection changesToCheckin = (Collection)entry.getValue();
                    ILocalChange[] changes = changesToCheckin.toArray(new ILocalChange[changesToCheckin.size()]);
                    if (changesToCheckin.isEmpty()) continue;
                    op.requestCheckin(changes, null, "", (IProgressMonitor)subProgress.newChild(1));
                }
                op.run((IProgressMonitor)monitor.newChild(84));
            } else {
                if (result == 1) {
                    throw new OperationCanceledException();
                }
                if (result != 3) {
                    throw new FileSystemException(Messages.ChangeHistoryChangeSetsOperation_0);
                }
            }
        }
        monitor.done();
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        final Set<IConfigurationDescriptor> affected = this.getAffectedConfigurations();
        IRunnableWithProgress workspaceOp = new IRunnableWithProgress(){

            /*
             * WARNING - void declaration
             */
            @Override
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                int totalNumberOfSharablesToUnshare;
                SubMonitor progress;
                block52: {
                    progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"", (int)100);
                    ICopyFileAreaManager cfaMgr = ICopyFileAreaManager.instance;
                    totalNumberOfSharablesToUnshare = 0;
                    try {
                        SubMonitor childMonitor;
                        ICopyFileAreaLockRequest lockRequest = cfaMgr.lockRequestFactory().getLockRequest(affected, true);
                        ICopyFileAreasLock cfaLock = cfaMgr.lock(Collections.singleton(lockRequest), (IProgressMonitor)progress.newChild(1));
                        HashMap<ILocation, Sandbox> emptyCFAs = new HashMap<ILocation, Sandbox>();
                        int direction = 3;
                        HashSet<ICopyFileArea> interestingCopyFileAreas = new HashSet<ICopyFileArea>();
                        HashMap<RepoIdConnectionComponentTriple, Collection<ICopyFileArea>> componentsToUnload = new HashMap<RepoIdConnectionComponentTriple, Collection<ICopyFileArea>>();
                        int numCopyFileAreas = 0;
                        try {
                            childMonitor = progress.newChild(8);
                            if (UnshareOperation.this.configurationsToUnshare != null) {
                                childMonitor.setWorkRemaining(UnshareOperation.this.configurationsToUnshare.size());
                                for (IConfigurationDescriptor iConfigurationDescriptor : UnshareOperation.this.configurationsToUnshare) {
                                    Collection<ICopyFileArea> copyFileAreas = cfaMgr.getCopyFileAreasForConfiguration(iConfigurationDescriptor, (IProgressMonitor)childMonitor.newChild(1));
                                    interestingCopyFileAreas.addAll(copyFileAreas);
                                    RepoIdConnectionComponentTriple toUnload = new RepoIdConnectionComponentTriple(iConfigurationDescriptor.getRepositoryId(), iConfigurationDescriptor.getConnectionHandle(), iConfigurationDescriptor.getComponentHandle());
                                    componentsToUnload.put(toUnload, copyFileAreas);
                                    numCopyFileAreas += copyFileAreas.size();
                                }
                                for (ICopyFileArea iCopyFileArea : interestingCopyFileAreas) {
                                    Collection<IShare> shares = iCopyFileArea.allShares();
                                    for (IShare share : shares) {
                                        ISharingDescriptor descriptor = share.getSharingDescriptor();
                                        RepoIdConnectionComponentTriple configuration = new RepoIdConnectionComponentTriple(descriptor.getRepositoryId(), descriptor.getConnectionHandle(), descriptor.getComponent());
                                        if (!affected.contains(configuration)) continue;
                                        Shareable shareable = (Shareable)share.getShareable();
                                        if (UnshareOperation.this.shareablesToUnshare.containsKey(configuration)) {
                                            ((List)UnshareOperation.this.shareablesToUnshare.get(configuration)).add(shareable);
                                            continue;
                                        }
                                        ArrayList<Shareable> shareables = new ArrayList<Shareable>();
                                        shareables.add(shareable);
                                        UnshareOperation.this.shareablesToUnshare.put(configuration, shareables);
                                    }
                                }
                            }
                            UnshareOperation.this.checkinPendingChanges(affected, UnshareOperation.this.unshareDilemmaHandler, (IProgressMonitor)progress.newChild(10));
                            for (List list : UnshareOperation.this.shareablesToUnshare.values()) {
                                totalNumberOfSharablesToUnshare += list.size();
                            }
                            for (Map.Entry entry : UnshareOperation.this.shareablesToUnshare.entrySet()) {
                                Collections.sort((List)entry.getValue(), UnshareOperation.this.comparator);
                            }
                            boolean bl = true;
                            boolean unsetWorkspaceComponentState = false;
                            int errorsBeforeSandboxChanges = UnshareOperation.this.getErrors().length;
                            IConfigurationDescriptor configurationBeingProcessedForUnshare = null;
                            HashSet<IConfigurationDescriptor> configurationHavingFailedUnshares = new HashSet<IConfigurationDescriptor>();
                            HashMap configurationsWithWCStateSetToUnknown = new HashMap();
                            HashMap cfaRootToLoadedComponentConfigurations = new HashMap();
                            childMonitor = progress.newChild(UnshareOperation.this.deleteContent ? 30 : 60);
                            childMonitor.setWorkRemaining(UnshareOperation.this.shareablesToUnshare.keySet().size() + 1);
                            try {
                                try {
                                    for (IConfigurationDescriptor configuration : UnshareOperation.this.shareablesToUnshare.keySet()) {
                                        SubMonitor childSubMonitor_1 = childMonitor.newChild(1);
                                        childSubMonitor_1.setWorkRemaining(((List)UnshareOperation.this.shareablesToUnshare.get(configuration)).size());
                                        configurationBeingProcessedForUnshare = configuration;
                                        for (Shareable shareable : (List)UnshareOperation.this.shareablesToUnshare.get(configuration)) {
                                            void var13_28;
                                            if (childMonitor.isCanceled()) {
                                                throw new OperationCanceledException();
                                            }
                                            try {
                                                childMonitor.subTask(NLS.bind((String)Messages.UnshareProjectsOperation_ProgressMessage, (Object)shareable.getLocalPath(), (Object[])new Object[]{(int)var13_28, totalNumberOfSharablesToUnshare}));
                                                shareable.unshare((IProgressMonitor)childSubMonitor_1.newChild(1));
                                                interestingCopyFileAreas.add(cfaMgr.getCopyFileAreaForPath(shareable.getCopyFileAreaRoot()));
                                            }
                                            catch (FileSystemException e) {
                                                configurationHavingFailedUnshares.add(configuration);
                                                UnshareOperation.this.collectStatus(FileSystemStatusUtil.getStatusFor((Throwable)((Object)e)));
                                            }
                                            ++var13_28;
                                        }
                                        configurationBeingProcessedForUnshare = null;
                                    }
                                    childMonitor.subTask("");
                                }
                                catch (Exception e) {
                                    unsetWorkspaceComponentState = true;
                                    throw e;
                                }
                            }
                            finally {
                                if (unsetWorkspaceComponentState || UnshareOperation.this.getErrors().length > errorsBeforeSandboxChanges) {
                                    UnshareOperation.this.traceIfEnabled("UnshareOperation#execute: There were errors while performing unshare operation. Set the workspace component state of all the components where the operation failed to UNKNOWN, in the metadata.");
                                    UnshareOperation.this.updateWorkspaceComponentStateToUnknownForUnshare(configurationsWithWCStateSetToUnknown, configurationBeingProcessedForUnshare, configurationHavingFailedUnshares, cfaRootToLoadedComponentConfigurations, (IProgressMonitor)childMonitor.newChild(1));
                                } else {
                                    childMonitor.worked(1);
                                }
                            }
                            unsetWorkspaceComponentState = false;
                            errorsBeforeSandboxChanges = UnshareOperation.this.getErrors().length;
                            RepoIdConnectionComponentTriple configurationBeingProcessedForUnload = null;
                            HashSet<RepoIdConnectionComponentTriple> configurationHavingFailedUnloads = new HashSet<RepoIdConnectionComponentTriple>();
                            childMonitor = progress.newChild(10);
                            childMonitor.setWorkRemaining(numCopyFileAreas + 1);
                            try {
                                try {
                                    for (Map.Entry entry : componentsToUnload.entrySet()) {
                                        RepoIdConnectionComponentTriple descriptor;
                                        configurationBeingProcessedForUnload = descriptor = (RepoIdConnectionComponentTriple)entry.getKey();
                                        for (ICopyFileArea cfa : (Collection)entry.getValue()) {
                                            try {
                                                ((CopyFileAreaStore)((Object)cfa)).componentUnloaded(descriptor.getComponentHandle(), descriptor.getConnectionHandle(), (IProgressMonitor)childMonitor.newChild(1));
                                            }
                                            catch (FileSystemException e) {
                                                configurationHavingFailedUnloads.add(descriptor);
                                                UnshareOperation.this.collectStatus(FileSystemStatusUtil.getStatusFor((Throwable)((Object)e)));
                                            }
                                        }
                                        configurationBeingProcessedForUnload = null;
                                    }
                                }
                                catch (Exception e) {
                                    unsetWorkspaceComponentState = true;
                                    throw e;
                                }
                            }
                            finally {
                                if (unsetWorkspaceComponentState || UnshareOperation.this.getErrors().length > errorsBeforeSandboxChanges) {
                                    UnshareOperation.this.traceIfEnabled("UnshareOperation#execute: There were errors while performing unload. Set the workspace component state of all the components where the unload failed to UNKNOWN, in the metadata.");
                                    UnshareOperation.this.updateWorkspaceComponentStateToUnknownForUnload(configurationsWithWCStateSetToUnknown, componentsToUnload, configurationBeingProcessedForUnload, configurationHavingFailedUnloads, cfaRootToLoadedComponentConfigurations, (IProgressMonitor)childMonitor.newChild(1));
                                } else {
                                    childMonitor.worked(1);
                                }
                            }
                            for (ICopyFileArea cfa : interestingCopyFileAreas) {
                                if (!cfa.allShares().isEmpty()) continue;
                                emptyCFAs.put(cfa.getRoot(), new Sandbox(cfa));
                            }
                            if (!emptyCFAs.isEmpty()) {
                                direction = UnshareOperation.this.unshareDilemmaHandler.emptySandbox(Collections.unmodifiableCollection(emptyCFAs.values()));
                            }
                        }
                        finally {
                            cfaLock.release((IProgressMonitor)progress.newChild(1));
                        }
                        childMonitor = progress.newChild(10);
                        if (!emptyCFAs.isEmpty() && direction == 0) {
                            childMonitor.setWorkRemaining(emptyCFAs.size() * 2 + 2);
                            ICopyFileAreaLockRequest iCopyFileAreaLockRequest = cfaMgr.lockRequestFactory().getLockRequestForRemoval(emptyCFAs.keySet());
                            ICopyFileAreasLock removeCFALock = cfaMgr.lock(Collections.singleton(iCopyFileAreaLockRequest), (IProgressMonitor)childMonitor.newChild(1));
                            try {
                                for (ISandbox sandbox : emptyCFAs.values()) {
                                    if (sandbox == null || sandbox.allShares((IProgressMonitor)childMonitor.newChild(1)).length != 0) continue;
                                    SharingManager.getInstance().deregister(sandbox, true, (IProgressMonitor)childMonitor.newChild(1));
                                }
                                break block52;
                            }
                            finally {
                                removeCFALock.release((IProgressMonitor)childMonitor.newChild(1));
                            }
                        }
                        if (direction == 1) {
                            throw new OperationCanceledException();
                        }
                    }
                    catch (TeamRepositoryException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                if (UnshareOperation.this.deleteContent) {
                    final SubMonitor childMonitor = progress.newChild(30);
                    childMonitor.setWorkRemaining(totalNumberOfSharablesToUnshare);
                    int i = 1;
                    for (IConfigurationDescriptor configuration : UnshareOperation.this.shareablesToUnshare.keySet()) {
                        for (final Shareable shareable : (List)UnshareOperation.this.shareablesToUnshare.get(configuration)) {
                            childMonitor.subTask(NLS.bind((String)Messages.UnshareProjectsOperation_ProgressMessage, (Object)shareable.getLocalPath(), (Object[])new Object[]{i + 1, totalNumberOfSharablesToUnshare}));
                            try {
                                SharingManager.getInstance().doSilentChange(new SharingManager.FileSystemAccessor(){

                                    @Override
                                    public void run() throws FileSystemException {
                                        shareable.getFileStorage().delete((IProgressMonitor)childMonitor.newChild(1));
                                    }
                                });
                            }
                            catch (TeamRepositoryException e) {
                                UnshareOperation.this.collectStatus(FileSystemStatusUtil.getStatusFor(e));
                            }
                            if (childMonitor.isCanceled()) {
                                throw new OperationCanceledException();
                            }
                            ++i;
                        }
                    }
                }
                progress.done();
            }
        };
        this.runWithinFileSystemLock(workspaceOp, Messages.UnshareProjectsOperation_0, monitor);
    }

    private Set<IConfigurationDescriptor> getAffectedConfigurations() {
        this.shareablesToUnshare = new HashMap<IConfigurationDescriptor, List<Shareable>>();
        HashSet<IConfigurationDescriptor> configurations = new HashSet<IConfigurationDescriptor>();
        if (this.configurationsToUnshare != null) {
            for (IConfigurationDescriptor configurationToUnshare : this.configurationsToUnshare) {
                configurations.add(new RepoIdConnectionComponentTriple(configurationToUnshare.getRepositoryId(), configurationToUnshare.getConnectionHandle(), configurationToUnshare.getComponentHandle()));
            }
        }
        if (this.sharesToUnshare != null) {
            for (IShare share : this.sharesToUnshare) {
                ISharingDescriptor descriptor = share.getSharingDescriptor();
                RepoIdConnectionComponentTriple configuration = new RepoIdConnectionComponentTriple(descriptor.getRepositoryId(), descriptor.getConnectionHandle(), descriptor.getComponent());
                configurations.add(configuration);
                Shareable shareable = (Shareable)share.getShareable();
                if (this.shareablesToUnshare.containsKey(configuration)) {
                    this.shareablesToUnshare.get(configuration).add(shareable);
                    continue;
                }
                ArrayList<Shareable> shareables = new ArrayList<Shareable>();
                shareables.add(shareable);
                this.shareablesToUnshare.put(configuration, shareables);
            }
        }
        return configurations;
    }

    protected void refreshLocal(IFilesystemRefresher refresher, Map<ISandbox, Set<IConfigurationDescriptor>> affectedAreas, IProgressMonitor progress) throws FileSystemException, TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (String)Messages.CreateBaselineOperation_REFRESHING_LOCAL_FILESYSTEM, (int)affectedAreas.size());
        for (Map.Entry<ISandbox, Set<IConfigurationDescriptor>> entry : affectedAreas.entrySet()) {
            IShare[] iShareArray = entry.getKey().allShares((IProgressMonitor)monitor);
            int n = iShareArray.length;
            int n2 = 0;
            while (n2 < n) {
                IShare share = iShareArray[n2];
                refresher.addToRefresh(share.getShareable());
                ++n2;
            }
        }
    }

    protected final Map<ISandbox, Set<IConfigurationDescriptor>> getCopyFileAreasAffected(Set<IConfigurationDescriptor> affectedConfigurations, IProgressMonitor progress) throws FileSystemException {
        HashMap<ISandbox, Set<IConfigurationDescriptor>> result = new HashMap<ISandbox, Set<IConfigurationDescriptor>>();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)affectedConfigurations.size());
        ICopyFileAreaManager copyFileAreaManager = ICopyFileAreaManager.instance;
        for (IConfigurationDescriptor configuration : affectedConfigurations) {
            Collection<ICopyFileArea> copyFileAreas = copyFileAreaManager.getCopyFileAreasForConfiguration(configuration, (IProgressMonitor)monitor.newChild(1));
            for (ICopyFileArea cfa : copyFileAreas) {
                Sandbox sandbox = new Sandbox(cfa);
                HashSet<IConfigurationDescriptor> configurations = (HashSet<IConfigurationDescriptor>)result.get(sandbox);
                if (configurations == null) {
                    configurations = new HashSet<IConfigurationDescriptor>();
                    result.put(sandbox, configurations);
                }
                configurations.add(configuration);
            }
        }
        return result;
    }

    @Override
    public void disableNonAtomicCommit() {
        this.nonAtomicCommitIsAnOption = false;
    }

    @Override
    public void enableNonAtomicCommit(int numberUploads) {
        this.nonAtomicCommitIsAnOption = true;
        this.nonAtomicCommitFileUploadLimit = numberUploads;
    }

    @Override
    public final void setRefreshBeforeRun(boolean newValue) {
        this.refreshBeforeRun = newValue;
    }

    @Override
    public final boolean getRefreshBeforeRun() {
        return this.refreshBeforeRun;
    }

    private void updateWorkspaceComponentStateToUnknownForUnshare(Map<IConfigurationDescriptor, Set<ILocation>> configurationsWithWCStateSetToUnknown, IConfigurationDescriptor configurationBeingProcessedForUnshare, Set<IConfigurationDescriptor> configurationHavingFailedUnshares, Map<ILocation, Collection<LoadedConfigurationDescriptor>> cfaRootToLoadedComponentConfigurations, IProgressMonitor monitor) throws FileSystemException {
        this.traceIfEnabled("UnshareOperation#updateWorkspaceComponentStateToUnknownForUnshare: Start.");
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (configurationBeingProcessedForUnshare != null) {
            configurationHavingFailedUnshares.add(configurationBeingProcessedForUnshare);
        }
        this.traceIfEnabled("UnshareOperation#updateWorkspaceComponentStateToUnknownForUnshare: Start setting the workspace component state to UNKNOWN, of all the components that had issues during unshare of projects.");
        SubMonitor subProgress = progress.newChild(100);
        subProgress.setWorkRemaining(configurationHavingFailedUnshares.size());
        for (IConfigurationDescriptor configuration : configurationHavingFailedUnshares) {
            UUID componentId = configuration.getComponentHandle().getItemId();
            UUID workspaceId = configuration.getConnectionHandle().getItemId();
            HashSet<ILocation> cfaRootsOfProjectsBeingUnShared = new HashSet<ILocation>();
            for (Shareable shareable : this.shareablesToUnshare.get(configuration)) {
                cfaRootsOfProjectsBeingUnShared.add(shareable.getSandbox().getRoot());
            }
            SubMonitor subSubProgress = subProgress.newChild(1);
            subSubProgress.setWorkRemaining(cfaRootsOfProjectsBeingUnShared.size());
            for (ILocation cfaRoot : cfaRootsOfProjectsBeingUnShared) {
                if (configurationsWithWCStateSetToUnknown.containsKey(configuration)) {
                    configurationsWithWCStateSetToUnknown.get(configuration).add(cfaRoot);
                } else {
                    HashSet<ILocation> cfaRootList = new HashSet<ILocation>();
                    cfaRootList.add(cfaRoot);
                    configurationsWithWCStateSetToUnknown.put(configuration, cfaRootList);
                }
                this.updateWorkspaceComponentStateToUnknown(cfaRoot, componentId, workspaceId, cfaRootToLoadedComponentConfigurations, (IProgressMonitor)subSubProgress.newChild(1));
            }
        }
        this.traceIfEnabled("UnshareOperation#updateWorkspaceComponentStateToUnknownForUnshare: Done setting the workspace component state to UNKNOWN, of all the components that had issues during unshare of projects.");
        this.traceIfEnabled("UnshareOperation#updateWorkspaceComponentStateToUnknownForUnshare: End.");
    }

    private void updateWorkspaceComponentStateToUnknownForUnload(Map<IConfigurationDescriptor, Set<ILocation>> configurationsWithWCStateSetToUnknown, HashMap<RepoIdConnectionComponentTriple, Collection<ICopyFileArea>> componentsToUnload, IConfigurationDescriptor configurationBeingProcessedForUnload, Set<IConfigurationDescriptor> configurationHavingFailedUnloads, Map<ILocation, Collection<LoadedConfigurationDescriptor>> cfaRootToLoadedComponentConfigurations, IProgressMonitor monitor) throws FileSystemException {
        this.traceIfEnabled("UnshareOperation#updateWorkspaceComponentStateToUnknownForUnload: Start.");
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (configurationBeingProcessedForUnload != null) {
            configurationHavingFailedUnloads.add(configurationBeingProcessedForUnload);
        }
        this.traceIfEnabled("UnshareOperation#updateWorkspaceComponentStateToUnknownForUnload: Start setting the workspace component state to UNKNOWN, of all the components that had failed to unload.");
        SubMonitor subProgress_2 = progress.newChild(100);
        subProgress_2.setWorkRemaining(configurationHavingFailedUnloads.size());
        for (IConfigurationDescriptor configuration : configurationHavingFailedUnloads) {
            UUID componentId = configuration.getComponentHandle().getItemId();
            UUID workspaceId = configuration.getConnectionHandle().getItemId();
            Set<ILocation> cfaRootsAlreadyProcessed = configurationsWithWCStateSetToUnknown.get(configuration);
            SubMonitor subSubProgress = subProgress_2.newChild(1);
            subSubProgress.setWorkRemaining(componentsToUnload.get(configuration).size());
            for (ICopyFileArea cfa : componentsToUnload.get(configuration)) {
                ILocation cfaRoot = cfa.getRoot();
                if (cfaRootsAlreadyProcessed == null || !cfaRootsAlreadyProcessed.contains(cfaRoot)) {
                    this.updateWorkspaceComponentStateToUnknown(cfaRoot, componentId, workspaceId, cfaRootToLoadedComponentConfigurations, (IProgressMonitor)subSubProgress.newChild(1));
                    continue;
                }
                subSubProgress.worked(1);
            }
        }
        this.traceIfEnabled("UnshareOperation#updateWorkspaceComponentStateToUnknownForUnload: Done setting the workspace component state to UNKNOWN, of all the components that had failed to unload.");
        this.traceIfEnabled("UnshareOperation#updateWorkspaceComponentStateToUnknownForUnload: End.");
    }

    private void updateWorkspaceComponentStateToUnknown(ILocation cfaRoot, UUID componentId, UUID workspaceId, Map<ILocation, Collection<LoadedConfigurationDescriptor>> cfaRootToLoadedComponentConfigurations, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.traceIfEnabled(NLS.bind((String)"UnshareOperation#updateWorkspaceComponentStateToUnknown: Processing the sandbox at location: \"{0}\".", (Object)cfaRoot, (Object[])new Object[0]));
        this.traceIfEnabled("UnshareOperation#updateWorkspaceComponentStateToUnknown: Fetching all the loaded configuration descriptors for the sandbox.");
        Collection<LoadedConfigurationDescriptor> allLoadedComponentConfigurations = SharingManager.getInstance().allLoadedConfigurations(cfaRoot, cfaRootToLoadedComponentConfigurations, (IProgressMonitor)progress.newChild(50));
        this.traceIfEnabled(NLS.bind((String)"UnshareOperation#updateWorkspaceComponentStateToUnknown: Retrieving the loaded configuration descriptor for the component with itemId \"{0}\".", (Object)componentId.getUuidValue(), (Object[])new Object[0]));
        LoadedConfigurationDescriptor loadedComponentConfiguration = CopyFileAreaUtil.getFilteredLoadedConfigurationForComponent(workspaceId, componentId, allLoadedComponentConfigurations);
        if (loadedComponentConfiguration != null) {
            this.traceIfEnabled("UnshareOperation#updateWorkspaceComponentStateToUnknown: Invoking CopyFileAreaUtil#updateWorkspaceComponentStateToUnknown().");
            CopyFileAreaUtil.updateWorkspaceComponentStateToUnknown(cfaRoot, Collections.singletonList(loadedComponentConfiguration), this.traceLog, (IProgressMonitor)progress.newChild(50));
        } else {
            this.traceIfEnabled(NLS.bind((String)"UnshareOperation#updateWorkspaceComponentStateToUnknown: The component with itemId: \"{0}\" is not loaded, hence we do not update it's workspace component state to UNKNOWN in the metadata.", (Object)componentId.getUuidValue(), (Object[])new Object[0]));
            progress.worked(50);
        }
    }

    private static class Refresher
    implements IFilesystemRefresher {
        private List<IShareable> shareables = new LinkedList<IShareable>();
        private Map<ISandbox, Map<UUID, Set<UUID>>> fullyRefreshedComponents = new HashMap<ISandbox, Map<UUID, Set<UUID>>>();

        private Refresher() {
        }

        @Override
        public void addToRefresh(IShareable toAdd) {
            this.shareables.add(toAdd);
        }

        @Override
        public void addToRefresh(Collection<IShareable> toAdd) {
            this.shareables.addAll(toAdd);
        }

        @Override
        public void addToRefresh(Collection<ISandbox> affectedAreas, IContextHandle contextHandle, IComponentHandle component, IProgressMonitor progress) throws FileSystemException {
            SubMonitor sbMon = SubMonitor.convert((IProgressMonitor)progress);
            sbMon.setWorkRemaining(affectedAreas.size());
            for (ISandbox sandbox : affectedAreas) {
                if (!this.shouldRefreshComponent(sandbox, contextHandle, component)) continue;
                IShare[] iShareArray = SharingManager.getInstance().allShares(sandbox.getRoot(), contextHandle, component, (IProgressMonitor)sbMon.newChild(1));
                int n = iShareArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IShare share = iShareArray[n2];
                    this.addToRefresh(share.getShareable());
                    ++n2;
                }
            }
        }

        private boolean shouldRefreshComponent(ISandbox sandbox, IContextHandle contextHandle, IComponentHandle componentHandle) {
            Set<UUID> refreshedComponents;
            Map<UUID, Set<UUID>> refreshedContexts = this.fullyRefreshedComponents.get(sandbox);
            if (refreshedContexts == null) {
                refreshedContexts = new HashMap<UUID, Set<UUID>>();
                this.fullyRefreshedComponents.put(sandbox, refreshedContexts);
            }
            if ((refreshedComponents = refreshedContexts.get(contextHandle.getItemId())) == null) {
                refreshedComponents = new HashSet<UUID>();
                refreshedContexts.put(contextHandle.getItemId(), refreshedComponents);
            }
            return refreshedComponents.add(componentHandle.getItemId());
        }
    }
}

