/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.share;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IFileContentManagerSession;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileItemInfoProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.LinkInfo;
import com.ibm.team.filesystem.client.internal.LinkType;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.MetadataProperties;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingDescriptor;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.checkin.CheckinUploadData;
import com.ibm.team.filesystem.client.internal.checkin.CheckinUploadHandler;
import com.ibm.team.filesystem.client.internal.checkin.EncodingUploadFailure;
import com.ibm.team.filesystem.client.internal.checkin.LineDelimiterUploadFailure;
import com.ibm.team.filesystem.client.internal.checkin.NewCheckInOperation;
import com.ibm.team.filesystem.client.internal.checkin.UploadHandler;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaUtil;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.operations.ILoadEvaluator;
import com.ibm.team.filesystem.client.internal.share.ShareOperation;
import com.ibm.team.filesystem.client.internal.share.ShareOverlap;
import com.ibm.team.filesystem.client.internal.share.ShareUploadHandler;
import com.ibm.team.filesystem.client.internal.utils.CancellationMonitor;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.RepoIdConnectionComponentTriple;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICheckinOperation;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.common.internal.FileContent;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import com.ibm.team.scm.common.dto.IItemUpdateReport;
import com.ibm.team.scm.common.dto.ISyncTime;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class ShareVersionables {
    final IWorkspaceConnection workspace;
    final IChangeSetHandle changeSet;
    final IComponent component;
    final IFolderHandle parentFolder;
    final String[] newFolderUnderParent;
    final boolean overwrite;
    private final Map<String, IShareable> shareables;
    private CommitDilemmaHandler problemHandler;
    private Map<UUID, IChangeSetHandle> changeSetsCommitted;
    private boolean newProjectContentsToBeCommitted;
    private Shed backupShed;
    private final Map<ILocation, ShareOperation.ShareProperties> properties;
    private final Map<String, byte[]> clientData;
    private HashMap<RepoIdConnectionComponentTriple, Set<ILocation>> cfasAffected;
    private NewCheckInOperation.SymbolicLinkDetails linkWarnings = new NewCheckInOperation.SymbolicLinkDetails();
    private boolean commitShareChildren;
    private final Log traceLog;

    public ShareVersionables(IWorkspaceConnection workspace, IChangeSetHandle changeSet, IComponent component, IFolderHandle parentFolder, String[] newFolderUnderParent, boolean overwrite, Map<ILocation, ShareOperation.ShareProperties> properties, Map<String, byte[]> clientData, boolean commitShareChildren, Log traceLog, HashMap<RepoIdConnectionComponentTriple, Set<ILocation>> cfasAffected, CommitDilemmaHandler problemHandler) {
        this.workspace = workspace;
        this.changeSet = changeSet;
        this.component = component;
        this.parentFolder = parentFolder;
        this.newFolderUnderParent = newFolderUnderParent;
        this.properties = properties;
        this.clientData = clientData;
        this.shareables = new HashMap<String, IShareable>();
        this.overwrite = overwrite;
        this.commitShareChildren = commitShareChildren;
        this.problemHandler = problemHandler;
        this.changeSetsCommitted = new HashMap<UUID, IChangeSetHandle>();
        this.cfasAffected = cfasAffected;
        this.traceLog = traceLog;
        this.backupShed = new Shed(this.problemHandler.getBackupDilemmaHandler());
    }

    private void traceIfEnabled(String message) {
        if (this.traceLog != null && this.traceLog.isTraceEnabled()) {
            this.traceLog.trace((Object)message);
        }
    }

    public void addShareable(IShareable shareableRoot, String remoteName) {
        this.shareables.put(remoteName, shareableRoot);
    }

    public Collection<IShareable> getShareables() {
        return this.shareables.values();
    }

    public int getShareableCount() {
        return this.shareables.size();
    }

    public Collection<IStatus> share(Map<String, IFolder> foldersCreated, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        ArrayList<IStatus> result = new ArrayList<IStatus>();
        this.changeSetsCommitted = new HashMap<UUID, IChangeSetHandle>();
        if (this.shareables.isEmpty()) {
            return result;
        }
        int numProjects = this.shareables.size();
        SubMonitor reporter = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ArrayList<IWorkspaceConnection.ISaveOp> newFolderChanges = new ArrayList<IWorkspaceConnection.ISaveOp>();
        IFolderHandle folderToShareUnder = this.createNewFolderToShareUnder(this.parentFolder, foldersCreated, newFolderChanges);
        reporter.setTaskName(NLS.bind((String)Messages.ShareProjects_0, (Object)numProjects, (Object[])new Object[0]));
        Map<UUID, ShareableVersionablePair> changes = this.mapShareablesToVersionablesToBeCommitted(folderToShareUnder, this.component.getName(), (IProgressMonitor)reporter.newChild(5));
        if (!changes.isEmpty() || !newFolderChanges.isEmpty()) {
            result.addAll(this.commitNewShares(folderToShareUnder, newFolderChanges, changes, (IProgressMonitor)reporter.newChild(95)));
            if (!changes.isEmpty() && this.commitShareChildren) {
                this.newProjectContentsToBeCommitted = true;
            }
        } else {
            reporter.worked(95);
        }
        return result;
    }

    private IFolderHandle createNewFolderToShareUnder(IFolderHandle folderToShareUnder, Map<String, IFolder> foldersCreated, ArrayList<IWorkspaceConnection.ISaveOp> newFolderChanges) {
        if (this.newFolderUnderParent.length > 0) {
            IWorkspaceConnection.IConfigurationOpFactory opFactory = this.workspace.configurationOpFactory();
            String relativePath = "";
            String[] stringArray = this.newFolderUnderParent;
            int n = this.newFolderUnderParent.length;
            int n2 = 0;
            while (n2 < n) {
                String folderToCreate = stringArray[n2];
                IFolder folder = foldersCreated.get(relativePath = String.valueOf(relativePath) + "/" + folderToCreate);
                if (folder == null) {
                    folder = (IFolder)IFolder.ITEM_TYPE.createItem();
                    folder.setName(folderToCreate);
                    folder.setParent(folderToShareUnder);
                    newFolderChanges.add(opFactory.save((IVersionable)folder));
                    foldersCreated.put(relativePath, folder);
                }
                folderToShareUnder = folder;
                ++n2;
            }
        }
        return folderToShareUnder;
    }

    public void commitNewProjectContents(IProgressMonitor progress) throws TeamRepositoryException, FileSystemException {
        if (this.newProjectContentsToBeCommitted) {
            ICheckinOperation commit = IOperationFactory.instance.getCheckinOperation(this.problemHandler, new IRepositoryResolver(){

                @Override
                public ITeamRepository getRepoFor(String uri, UUID id) throws TeamRepositoryException {
                    if (id.equals((Object)ShareVersionables.this.workspace.teamRepository().getId())) {
                        return ShareVersionables.this.workspace.teamRepository();
                    }
                    return null;
                }
            });
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
            commit.requestCheckin(this.shareables.values().toArray(new IShareable[this.shareables.size()]), this.changeSet, Messages.ShareProjects_1, (IProgressMonitor)monitor.newChild(1));
            commit.enableNonAtomicCommit(1);
            commit.run((IProgressMonitor)monitor.newChild(99));
            for (IChangeSetHandle changeSet : commit.getCommittedChangeSets()) {
                this.changeSetsCommitted.put(changeSet.getItemId(), changeSet);
            }
        }
        if (!this.linkWarnings.isEmpty()) {
            this.problemHandler.linkWarnings(this.linkWarnings.isAnyBroken(), this.linkWarnings.isAnyNonInteroperable(), this.linkWarnings.getShareables(), this.linkWarnings.getTargets(), this.linkWarnings.getDirectoryLinks(), this.linkWarnings.getBroken(), this.linkWarnings.getNonInteroperable());
            this.linkWarnings = new NewCheckInOperation.SymbolicLinkDetails();
        }
    }

    public Collection<IChangeSetHandle> getCommittedChangeSets() {
        return this.changeSetsCommitted.values();
    }

    private Collection<IStatus> commitNewShares(IFolderHandle parentFolderForShare, ArrayList<IWorkspaceConnection.ISaveOp> newFolderChanges, Map<UUID, ShareableVersionablePair> changes, IProgressMonitor progress) throws TeamRepositoryException, FileSystemException {
        SubMonitor reporter = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        boolean isNonAtomicCommitAllowed = true;
        CheckinUploadData uploadData = new CheckinUploadData();
        List<IStatus> sessionStatuses = this.upload(changes, uploadData, true, (IProgressMonitor)reporter.newChild(50));
        IWorkspaceConnection.IConfigurationOpFactory opFactory = this.workspace.configurationOpFactory();
        ArrayList<IWorkspaceConnection.ISaveOp> allOps = new ArrayList<IWorkspaceConnection.ISaveOp>(changes.size() + newFolderChanges.size());
        allOps.addAll(newFolderChanges);
        for (ShareableVersionablePair pair : changes.values()) {
            if (pair.versionable instanceof IFileItem) {
                if (uploadData.isUploadFailed((IComponentHandle)this.component, (IVersionableHandle)pair.versionable)) continue;
                IFileItem file = (IFileItem)pair.versionable;
                FileContent content = uploadData.getContent((IComponentHandle)this.component, (IVersionableHandle)pair.versionable);
                if (content == null) continue;
                file.setContent((IFileContent)content);
                String currentContentType = uploadData.getContentType((IComponentHandle)this.component, (IVersionableHandle)pair.versionable);
                file.setContentType(currentContentType);
                allOps.add(opFactory.save((IVersionable)file));
                continue;
            }
            allOps.add(opFactory.save(pair.getVersionable()));
        }
        IChangeSetHandle changeSetCommitted = this.changeSet;
        if (changeSetCommitted == null) {
            changeSetCommitted = this.workspace.getCurrentChangeSet((IComponentHandle)this.component);
            if (changeSetCommitted == null) {
                changeSetCommitted = this.workspace.createChangeSet((IComponentHandle)this.component, Messages.ShareProjects_2, true, (IProgressMonitor)reporter.newChild(1));
            } else {
                reporter.worked(1);
            }
        } else {
            reporter.worked(1);
        }
        reporter.setTaskName(Messages.ShareProjects_3);
        IUpdateReport outcome = this.workspace.commit(changeSetCommitted, allOps, (IProgressMonitor)reporter.newChild(4));
        this.changeSetsCommitted.put(changeSetCommitted.getItemId(), changeSetCommitted);
        ArrayList allUpdates = new ArrayList(outcome.updates().size() + outcome.incidentalResolutionUpdates().size());
        allUpdates.addAll(outcome.updates());
        allUpdates.addAll(outcome.incidentalResolutionUpdates());
        int cnt = 0;
        int total = allUpdates.size();
        ICopyFileAreaManager cfaMgr = ICopyFileAreaManager.instance;
        ISyncTime beforeConfigurationState = this.getConfigurationState(outcome.getComponentStatesBefore());
        ISyncTime configurationState = this.getConfigurationState(outcome.getComponentStatesAfter());
        ITeamRepository teamRepository = this.workspace.teamRepository();
        Set<ILocation> cfaRoots = this.cfasAffected.get(new RepoIdConnectionComponentTriple(teamRepository.getId(), this.workspace.getContextHandle(), (IComponentHandle)this.component));
        HashSet<ILocation> cfaRootsOfProjectsBeingShared = new HashSet<ILocation>();
        SubMonitor subProgress_1 = reporter.newChild(35);
        subProgress_1.setWorkRemaining(total * 2);
        for (IItemUpdateReport current : allUpdates) {
            ShareableVersionablePair toUpdate = changes.get(current.getNewCurrentState().getItemId());
            if (toUpdate != null) {
                boolean loadedWithAlternativeName;
                cfaRootsOfProjectsBeingShared.add(toUpdate.getShareable().getSandbox().getRoot());
                subProgress_1.setTaskName(NLS.bind((String)Messages.ShareProjects_4, (Object)cnt, (Object[])new Object[]{total, toUpdate.getShareable().getLocalPath()}));
                IFolderHandle loadRoot = null;
                ILoadEvaluator loadEvaluator = SharingManager.getInstance().getLoadEvaluators(Collections.singletonList(toUpdate.shareable.getSandbox())).values().iterator().next();
                if (loadEvaluator.getSupportedValidations().contains((Object)ILoadEvaluator.LoadValidations.USES_LOAD_ROOT)) {
                    loadRoot = toUpdate.versionable.getParent();
                }
                SharingDescriptor descriptor = SharingDescriptor.create((IConnection)this.workspace, this.component, current.getNewCurrentState(), loadRoot, this.clientData, configurationState);
                FileItemInfo info = null;
                boolean bl = loadedWithAlternativeName = !toUpdate.versionable.getName().equals(toUpdate.shareable.getLocalPath().getName());
                if (current.getNewCurrentState() instanceof IFolderHandle) {
                    info = new FileItemInfo((IFolderHandle)current.getNewCurrentState(), toUpdate.versionable.getParent(), toUpdate.versionable.getName(), loadedWithAlternativeName);
                } else if (current.getNewCurrentState() instanceof ISymbolicLinkHandle) {
                    ISymbolicLink link = (ISymbolicLink)toUpdate.versionable;
                    String target = link.getTarget();
                    target = ((Shareable)toUpdate.getShareable()).getFileStorage().convertTargetIntoLocalForm(target);
                    FileItemInfoProxy proxy = new FileItemInfoProxy(current.getNewCurrentState(), toUpdate.versionable.getParent(), toUpdate.versionable.getName(), loadedWithAlternativeName);
                    proxy.setTarget(((Shareable)toUpdate.getShareable()).getFileStorage().getModificationStamp(), link.getTarget(), target, link.isDirectoryLink());
                    info = proxy.getFileItemInfo();
                } else {
                    FileItemInfoProxy proxy = new FileItemInfoProxy(current.getNewCurrentState(), toUpdate.versionable.getParent(), toUpdate.versionable.getName(), loadedWithAlternativeName);
                    Long contentSize = uploadData.getLocalContentSize((IComponentHandle)this.component, (IVersionableHandle)toUpdate.versionable);
                    if (contentSize != null) {
                        ContentHash hash = uploadData.getLocalHashCode((IComponentHandle)this.component, (IVersionableHandle)toUpdate.versionable);
                        long contentLength = contentSize;
                        Long modTime = uploadData.getModTime((IComponentHandle)this.component, (IVersionableHandle)toUpdate.versionable);
                        FileContent contentUploaded = uploadData.getContent((IComponentHandle)this.component, (IVersionableHandle)toUpdate.versionable);
                        proxy.setContentInfo(modTime, hash, contentLength, contentUploaded);
                        proxy.setContentType(uploadData.getContentType((IComponentHandle)this.component, (IVersionableHandle)toUpdate.versionable));
                        info = proxy.getFileItemInfo();
                    }
                }
                if (info != null) {
                    ((Shareable)toUpdate.getShareable()).share(descriptor, info, new MetadataProperties(toUpdate.versionable.getUserProperties()), this.overwrite, true, (IProgressMonitor)subProgress_1.newChild(1));
                } else {
                    subProgress_1.worked(1);
                }
                SubMonitor subSubProgress = subProgress_1.newChild(1);
                subSubProgress.setWorkRemaining(cfaRoots.size() * 2);
                for (ILocation cfaRoot : cfaRoots) {
                    if (!cfaRoot.equals(toUpdate.getShareable().getSandbox().getRoot())) {
                        ICopyFileArea cfa = cfaMgr.getExistingCopyFileArea(cfaRoot);
                        IShare share = cfa.getShare(this.workspace.getContextHandle(), (IComponentHandle)this.component, (IVersionableHandle)this.parentFolder, (IProgressMonitor)subSubProgress.newChild(1));
                        if (share != null) {
                            cfa.setUnknownConfigurationState(this.workspace.getContextHandle(), (IComponentHandle)this.component, share.getPath(), (IProgressMonitor)subSubProgress.newChild(1));
                            continue;
                        }
                        subSubProgress.worked(1);
                        continue;
                    }
                    subSubProgress.worked(2);
                }
            } else {
                subProgress_1.worked(2);
            }
            ++cnt;
        }
        long workspaceComponentState = this.getWorkspaceComponentState(outcome.getComponentStatesAfter());
        SubMonitor subProgress_2 = reporter.newChild(5);
        subProgress_2.setWorkRemaining(cfaRootsOfProjectsBeingShared.size());
        for (ILocation cfaRoot : cfaRootsOfProjectsBeingShared) {
            this.updateWorkspaceComponentState(cfaRoot, workspaceComponentState, (IProgressMonitor)subProgress_2.newChild(1));
        }
        SubMonitor subProgress_3 = reporter.newChild(5);
        subProgress_3.setWorkRemaining(cfaRoots.size());
        for (ILocation cfaRoot : cfaRoots) {
            ICopyFileArea cfa = cfaMgr.getExistingCopyFileArea(cfaRoot);
            cfa.setConfigurationState((IContextHandle)this.workspace.getResolvedWorkspace(), (IComponentHandle)this.component, beforeConfigurationState, configurationState, (IProgressMonitor)subProgress_3.newChild(1));
        }
        ArrayList<IStatus> toReport = new ArrayList<IStatus>();
        toReport.addAll(Arrays.asList(uploadData.getUploadFailureStatuses()));
        toReport.addAll(sessionStatuses);
        for (IStatus status : toReport) {
            if (status.getSeverity() != 8) continue;
            RepositoryUtils.throwAppropriateException(Messages.ShareVersionables_0, toReport.toArray(new IStatus[toReport.size()]));
        }
        return toReport;
    }

    private void updateWorkspaceComponentState(ILocation cfaRoot, long wcState, IProgressMonitor monitor) throws FileSystemException {
        this.traceIfEnabled("ShareVersionables#updateWorkspaceComponentState: Start.");
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.traceIfEnabled(NLS.bind((String)"ShareVersionables#updateWorkspaceComponentState: Processing the sandbox at location: \"{0}\".", (Object)cfaRoot, (Object[])new Object[0]));
        this.traceIfEnabled("ShareVersionables#updateWorkspaceComponentState: Fetching all the loaded configuration descriptors for the sandbox.");
        Collection<LoadedConfigurationDescriptor> loadedComponentConfigurations = SharingManager.getInstance().allLoadedConfigurations(cfaRoot, (IProgressMonitor)progress.newChild(50));
        this.traceIfEnabled(NLS.bind((String)"ShareVersionables#updateWorkspaceComponentState: Retrieving the loaded configuration descriptor for the component \"{0}\".", (Object)this.component.getName(), (Object[])new Object[0]));
        LoadedConfigurationDescriptor loadedComponentConfiguration = CopyFileAreaUtil.getFilteredLoadedConfigurationForComponent(this.workspace.getContextHandle().getItemId(), this.component.getItemId(), loadedComponentConfigurations);
        if (loadedComponentConfiguration != null) {
            this.traceIfEnabled("ShareVersionables#updateWorkspaceComponentState: Invoking CopyFileAreaUtil#updateWorkspaceComponentState().");
            CopyFileAreaUtil.updateWorkspaceComponentState(cfaRoot, wcState, false, loadedComponentConfiguration, this.traceLog, (IProgressMonitor)progress.newChild(50));
        } else {
            this.traceIfEnabled(NLS.bind((String)"ShareVersionables#updateWorkspaceComponentState: The component \"{0}\" is not loaded, hence we do not update it's workspace component state in the metadata.", (Object)this.component.getName(), (Object[])new Object[0]));
            progress.worked(50);
        }
        this.traceIfEnabled("ShareVersionables#updateWorkspaceComponentState: End.");
    }

    private ISyncTime getConfigurationState(Collection<IComponentStateSummary> configurationStates) {
        ISyncTime configurationState = null;
        for (IComponentStateSummary summary : configurationStates) {
            if (!summary.getComponent().sameItemId((IItemHandle)this.component)) continue;
            configurationState = summary.getConfigurationTime();
            break;
        }
        return configurationState;
    }

    private long getWorkspaceComponentState(Collection<IComponentStateSummary> configurationStates) {
        long wcState = -1L;
        for (IComponentStateSummary summary : configurationStates) {
            if (!summary.getComponent().sameItemId((IItemHandle)this.component)) continue;
            wcState = summary.getWorkspaceComponentState();
            break;
        }
        return wcState;
    }

    private Map<UUID, ShareableVersionablePair> mapShareablesToVersionablesToBeCommitted(IFolderHandle rootFolder, String componentName, IProgressMonitor reporter) throws FileSystemException, TeamRepositoryException {
        int numShareRoots = this.shareables.size();
        SubMonitor shareProgress = SubMonitor.convert((IProgressMonitor)reporter, (int)(numShareRoots * 2));
        HashMap<UUID, ShareableVersionablePair> changes = new HashMap<UUID, ShareableVersionablePair>();
        try {
            int processed = 0;
            for (Map.Entry<String, IShareable> entry : this.shareables.entrySet()) {
                IShareable shareable = entry.getValue();
                String remoteName = entry.getKey();
                ShareOperation.ShareProperties shareProperties = this.properties.get(shareable.getFullPath());
                if (shareProgress.isCanceled()) {
                    throw new OperationCanceledException();
                }
                shareProgress.setTaskName(NLS.bind((String)Messages.ShareProjects_5, (Object)shareable.getLocalPath().toString(), (Object[])new Object[]{++processed, numShareRoots}));
                ResourceType type = shareable.getResourceType((IProgressMonitor)shareProgress.newChild(1));
                if (type == ResourceType.FOLDER) {
                    IFolder folder = (IFolder)IFolder.ITEM_TYPE.createItem();
                    changes.put(folder.getItemId(), new ShareableVersionablePair(shareable, (IVersionable)folder));
                    folder.setName(remoteName);
                    folder.setParent(rootFolder);
                    if (shareProperties != null) {
                        shareProperties.update((IVersionable)folder);
                    }
                    shareProgress.worked(1);
                    continue;
                }
                if (type == ResourceType.FILE) {
                    IFileItem file = (IFileItem)IFileItem.ITEM_TYPE.createItem();
                    ShareableVersionablePair pair = new ShareableVersionablePair(shareable, (IVersionable)file);
                    changes.put(file.getItemId(), pair);
                    file.setName(remoteName);
                    file.setParent(rootFolder);
                    IFileStorage storage = ((Shareable)shareable).getFileStorage();
                    boolean isExecutable = storage.isExecutable((IProgressMonitor)shareProgress.newChild(1));
                    file.setExecutable(isExecutable);
                    long localTimeStamp = storage.getLocalTimeStamp();
                    if (localTimeStamp < 0L) {
                        localTimeStamp = System.currentTimeMillis();
                    }
                    file.setFileTimestamp(new Date(localTimeStamp));
                    if (shareProperties == null) continue;
                    shareProperties.update((IVersionable)file);
                    continue;
                }
                if (type != ResourceType.SYMBOLIC_LINK) continue;
                ISymbolicLink link = (ISymbolicLink)ISymbolicLink.ITEM_TYPE.createItem();
                changes.put(link.getItemId(), new ShareableVersionablePair(shareable, (IVersionable)link));
                link.setName(remoteName);
                link.setParent(rootFolder);
                IFileStorage storage = ((Shareable)shareable).getFileStorage();
                LinkInfo diskLinkInfo = storage.getLinkInfo((IProgressMonitor)shareProgress.newChild(1));
                String target = diskLinkInfo.getTarget();
                boolean isDirectoryLink = diskLinkInfo.getType() == LinkType.DIRECTORY;
                link.setTarget(target);
                link.setIsDirectoryLink(isDirectoryLink);
                this.linkWarnings.push(shareable, target, isDirectoryLink, storage.isBrokenLink((IProgressMonitor)shareProgress.newChild(1)), !storage.isInteroperableLink(diskLinkInfo, isDirectoryLink, (IProgressMonitor)shareProgress.newChild(1)));
                link.setLinkTimestamp(new Date(storage.getLocalTimeStamp()));
                if (shareProperties == null) continue;
                shareProperties.update((IVersionable)link);
            }
        }
        finally {
            shareProgress.done();
        }
        return changes;
    }

    private List<IStatus> upload(Map<UUID, ShareableVersionablePair> changes, CheckinUploadData uploadData, boolean isNonAtomicCommitAllowed, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        CancellationMonitor cMon = new CancellationMonitor((IProgressMonitor)mon);
        ArrayList<IStatus> sessionStatuses = new ArrayList<IStatus>();
        if (!changes.isEmpty()) {
            ArrayList<ShareableVersionablePair> uploads = new ArrayList<ShareableVersionablePair>();
            for (ShareableVersionablePair pair : changes.values()) {
                if (!(pair.versionable instanceof IFileItemHandle)) continue;
                uploads.add(pair);
            }
            if (!uploads.isEmpty()) {
                IFileContentManagerSession session = FileSystemCore.getContentManager(this.workspace.teamRepository()).createSession(NLS.bind((String)Messages.ShareVersionables_1, (Object)this.workspace.getName(), (Object[])new Object[0]), true, uploads.size(), (IProgressMonitor)mon.newChild(40));
                for (ShareableVersionablePair pair : uploads) {
                    if (!(pair.versionable instanceof IFileItemHandle)) continue;
                    ShareOperation.ShareProperties shareProperties = this.properties.get(pair.shareable.getFullPath());
                    ShareUploadHandler shareUploadHandler = new ShareUploadHandler(pair.shareable, this.workspace, (IComponentHandle)this.component, (IVersionableHandle)pair.versionable, false, uploadData, cMon);
                    if (shareProperties != null) {
                        shareProperties.update(pair.shareable, shareUploadHandler);
                    }
                    try {
                        session.storeContent(shareUploadHandler);
                    }
                    catch (TeamRepositoryException teamRepositoryException) {
                        // empty catch block
                    }
                }
                session.join();
                this.doDilemmaHandling(this.workspace, isNonAtomicCommitAllowed, session, sessionStatuses, uploadData, mon.newChild(20));
                Collection<CheckinUploadHandler> filesNeedingConversion = uploadData.clearFilesNeedingConversion();
                SubMonitor subProgress = mon.newChild(4);
                subProgress.setWorkRemaining(filesNeedingConversion.size());
                for (UploadHandler uploadHandler : filesNeedingConversion) {
                    try {
                        uploadHandler.convert(this.backupShed, (IProgressMonitor)subProgress.newChild(1));
                    }
                    catch (FileSystemException e) {
                        if (isNonAtomicCommitAllowed) {
                            sessionStatuses.add(FileSystemStatusUtil.getStatusFor((Throwable)((Object)e)));
                            continue;
                        }
                        throw e;
                    }
                }
            }
        }
        return sessionStatuses;
    }

    private void doDilemmaHandling(IWorkspaceConnection workspace, boolean isNonAtomicCommitAllowed, IFileContentManagerSession session, List<IStatus> sessionStatuses, CheckinUploadData uploadData, SubMonitor mon) throws FileSystemException, TeamRepositoryException {
        boolean moreContentUploaded;
        int paranoiaCount = 0;
        do {
            moreContentUploaded = false;
            IStatus[] uploadFailureStatuses = uploadData.getUploadFailureStatuses();
            IStatus[] statuses = session.getErrorStatus();
            IStatus[] allErrors = new IStatus[sessionStatuses.size() + uploadFailureStatuses.length + statuses.length];
            allErrors = sessionStatuses.toArray(allErrors);
            System.arraycopy(uploadFailureStatuses, 0, allErrors, sessionStatuses.size(), uploadFailureStatuses.length);
            System.arraycopy(statuses, 0, allErrors, sessionStatuses.size() + uploadFailureStatuses.length, statuses.length);
            if (isNonAtomicCommitAllowed) {
                this.checkCancellationStatus(allErrors);
            } else if (allErrors.length > 0) {
                RepositoryUtils.throwAppropriateException(Messages.NewCheckInOperation_4, allErrors);
            }
            session = null;
            Collection<LineDelimiterUploadFailure> lineDelimiterFailures = uploadData.clearLineDelimiterFailures();
            Collection<EncodingUploadFailure> encodingFailures = uploadData.clearEncodingFailures();
            if (!lineDelimiterFailures.isEmpty() || !encodingFailures.isEmpty()) {
                mon.setWorkRemaining(100);
                session = FileSystemCore.getContentManager(workspace.teamRepository()).createSession(NLS.bind((String)Messages.NewCheckInOperation_3, (Object)workspace.getName(), (Object[])new Object[0]), true, lineDelimiterFailures.size() + encodingFailures.size(), (IProgressMonitor)mon.newChild(40));
                try {
                    int reaction;
                    if (!lineDelimiterFailures.isEmpty()) {
                        reaction = this.problemHandler.lineDelimiterErrors(lineDelimiterFailures, (IProgressMonitor)mon.newChild(1));
                        if (reaction == 1) {
                            throw new OperationCanceledException();
                        }
                        if (reaction == 3 && isNonAtomicCommitAllowed) {
                            for (LineDelimiterUploadFailure lineDelimiterUploadFailure : lineDelimiterFailures) {
                                uploadData.uploadFailure(lineDelimiterUploadFailure);
                            }
                            session.decrementTransferCount(lineDelimiterFailures.size());
                        } else if (reaction == 0) {
                            mon.setWorkRemaining(100);
                            for (LineDelimiterUploadFailure lineDelimiterUploadFailure : lineDelimiterFailures) {
                                if (lineDelimiterUploadFailure.isSkipFailure()) {
                                    uploadData.uploadFailure(lineDelimiterUploadFailure);
                                    session.decrementTransferCount(1L);
                                    continue;
                                }
                                try {
                                    session.storeContent(lineDelimiterUploadFailure.getUploadHandler());
                                    moreContentUploaded = true;
                                }
                                catch (TeamRepositoryException teamRepositoryException) {
                                    // empty catch block
                                }
                            }
                        } else if (reaction == 100) {
                            session.decrementTransferCount(lineDelimiterFailures.size());
                            Iterator<LineDelimiterUploadFailure> iterator = lineDelimiterFailures.iterator();
                            while (iterator.hasNext()) {
                                this.removeProject(iterator.next().getShareable());
                            }
                        } else {
                            for (LineDelimiterUploadFailure lineDelimiterUploadFailure : lineDelimiterFailures) {
                                uploadData.uploadFailure(lineDelimiterUploadFailure);
                            }
                            for (EncodingUploadFailure encodingUploadFailure : encodingFailures) {
                                uploadData.uploadFailure(encodingUploadFailure);
                            }
                            uploadFailureStatuses = uploadData.getUploadFailureStatuses();
                            RepositoryUtils.throwAppropriateException(Messages.NewCheckInOperation_4, uploadFailureStatuses);
                        }
                    }
                    if (!encodingFailures.isEmpty()) {
                        reaction = this.problemHandler.encodingErrors(encodingFailures, (IProgressMonitor)mon.newChild(1));
                        if (reaction == 1) {
                            throw new OperationCanceledException();
                        }
                        if (reaction == 3 && isNonAtomicCommitAllowed) {
                            for (EncodingUploadFailure encodingUploadFailure : encodingFailures) {
                                uploadData.uploadFailure(encodingUploadFailure);
                            }
                            session.decrementTransferCount(encodingFailures.size());
                        } else if (reaction == 0) {
                            mon.setWorkRemaining(100);
                            if (!isNonAtomicCommitAllowed) {
                                for (EncodingUploadFailure encodingUploadFailure : encodingFailures) {
                                    if (encodingUploadFailure.isIgnoreEncoding() || !encodingUploadFailure.getEncoding().equals(encodingUploadFailure.getAlternativeEncoding())) continue;
                                    uploadData.uploadFailure(encodingUploadFailure);
                                }
                                uploadFailureStatuses = uploadData.getUploadFailureStatuses();
                                RepositoryUtils.throwAppropriateException(Messages.NewCheckInOperation_4, uploadFailureStatuses);
                            }
                            for (EncodingUploadFailure encodingUploadFailure : encodingFailures) {
                                if (encodingUploadFailure.isSkipFailure()) {
                                    uploadData.uploadFailure(encodingUploadFailure);
                                    session.decrementTransferCount(1L);
                                    continue;
                                }
                                try {
                                    session.storeContent(encodingUploadFailure.getUploadHandler());
                                    moreContentUploaded = true;
                                }
                                catch (TeamRepositoryException teamRepositoryException) {
                                    // empty catch block
                                }
                            }
                        } else {
                            for (EncodingUploadFailure encodingUploadFailure : encodingFailures) {
                                uploadData.uploadFailure(encodingUploadFailure);
                            }
                            uploadFailureStatuses = uploadData.getUploadFailureStatuses();
                            RepositoryUtils.throwAppropriateException(Messages.NewCheckInOperation_4, uploadFailureStatuses);
                        }
                    }
                }
                finally {
                    if (session != null && moreContentUploaded) {
                        session.join();
                    }
                }
            }
            if (++paranoiaCount < 500) continue;
            for (LineDelimiterUploadFailure failure : lineDelimiterFailures) {
                uploadData.uploadFailure(failure);
            }
            for (EncodingUploadFailure failure : encodingFailures) {
                uploadData.uploadFailure(failure);
            }
            uploadFailureStatuses = uploadData.getUploadFailureStatuses();
            RepositoryUtils.throwAppropriateException(Messages.NewCheckInOperation_4, uploadFailureStatuses);
        } while (moreContentUploaded && paranoiaCount < 500);
    }

    private void checkCancellationStatus(IStatus[] errorStatus) {
        IStatus[] iStatusArray = errorStatus;
        int n = errorStatus.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus status = iStatusArray[n2];
            if (status.matches(8)) {
                throw new OperationCanceledException();
            }
            ++n2;
        }
    }

    public void removeProject(IShareable shareRootToRemove) {
        String remoteName = null;
        for (Map.Entry<String, IShareable> entry : this.shareables.entrySet()) {
            IShareable shareable = entry.getValue();
            if (!shareable.equals(shareRootToRemove)) continue;
            remoteName = entry.getKey();
            break;
        }
        if (remoteName != null) {
            this.shareables.remove(remoteName);
        }
    }

    public void determineOverlaps(HashMap<IShareable, ShareOverlap> overlaps, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)this.shareables.size());
        HashSet<ISandbox> goodSandbox = new HashSet<ISandbox>();
        for (IShareable shareable : this.shareables.values()) {
            ISandbox sandbox = shareable.getSandbox();
            if (goodSandbox.contains(sandbox)) continue;
            ICopyFileArea cfa = ICopyFileAreaManager.instance.getCopyFileAreaForPath(sandbox.getRoot());
            IShare share = cfa.getShare(this.workspace.getContextHandle(), (IComponentHandle)this.component, (IVersionableHandle)this.parentFolder, (IProgressMonitor)progress.newChild(1));
            if (share == null) {
                goodSandbox.add(sandbox);
                continue;
            }
            if (cfa.getItemInfo((IVersionableHandle)this.parentFolder, (IComponentHandle)this.component, this.workspace.getContextHandle(), false) == null) continue;
            ShareOverlap overlap = overlaps.get(shareable);
            if (overlap == null) {
                overlap = new ShareOverlap((IConnection)this.workspace, (IComponentHandle)this.component, shareable);
                overlaps.put(shareable, overlap);
            }
            overlap.addShareOverlap(share);
        }
    }

    private class ShareableVersionablePair {
        private IShareable shareable;
        private IVersionable versionable;

        public IShareable getShareable() {
            return this.shareable;
        }

        public IVersionable getVersionable() {
            return this.versionable;
        }

        public ShareableVersionablePair(IShareable shareable, IVersionable versionable) {
            this.shareable = shareable;
            this.versionable = versionable;
        }
    }
}

