/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.share;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IContentExaminer;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileItemInfoProxy;
import com.ibm.team.filesystem.client.internal.FileOptions;
import com.ibm.team.filesystem.client.internal.FileSystemManager;
import com.ibm.team.filesystem.client.internal.FileSystemServiceProxy;
import com.ibm.team.filesystem.client.internal.IFileOptions;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.LinkInfo;
import com.ibm.team.filesystem.client.internal.LinkType;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.MetadataProperties;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingDescriptor;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.api.storage.FileOptionsFactory;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaUtil;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.operations.ILoadEvaluator;
import com.ibm.team.filesystem.client.internal.operations.ILoadMutator;
import com.ibm.team.filesystem.client.internal.share.ShareOperation;
import com.ibm.team.filesystem.client.internal.share.ShareOverlap;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.common.internal.FileContent;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdate;
import com.ibm.team.filesystem.common.internal.dto.LoadTree;
import com.ibm.team.filesystem.common.util.VerifyConvertToCRInputStream;
import com.ibm.team.filesystem.common.util.VerifyConvertToCRLFInputStream;
import com.ibm.team.filesystem.common.util.VerifyConvertToLFInputStream;
import com.ibm.team.internal.repository.rcp.streams.DigestComputingInputStream;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.common.utils.ContentLineDelimiterError;
import com.ibm.team.repository.common.utils.ReaderToInputStream;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.VersionedContentDeleted;
import com.ibm.team.scm.common.dto.ISyncTime;
import com.ibm.team.scm.common.internal.dto.ExternalLinkEntry;
import com.ibm.team.scm.common.internal.gc.ExternalLinks;
import com.ibm.team.scm.common.internal.gc.ExternalLinksDTOUtils;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ReshareVersionables {
    private static final int BUFFER_LENGTH = 16384;
    final IConnection connection;
    final IComponent component;
    final Shareable shareableRoot;
    final IFolderHandle parentForShare;
    final IVersionableHandle remoteShare;
    final String remoteName;
    private final Map<String, byte[]> clientData;
    final boolean overwrite;
    Collection<LoadedConfigurationDescriptor> loadedComponentConfigurations;
    private final Log traceLog;
    private final Map<ILocation, ShareOperation.ShareProperties> properties;

    public ReshareVersionables(IConnection connection, IComponent component, IFolderHandle parentForShare, IVersionableHandle remoteShare, String remoteName, Shareable itemToReshare, Map<ILocation, ShareOperation.ShareProperties> properties, Map<String, byte[]> clientData, boolean overwrite, Collection<LoadedConfigurationDescriptor> loadedComponentConfigurations, Log traceLog) {
        this.connection = connection;
        this.component = component;
        this.parentForShare = parentForShare;
        this.remoteShare = remoteShare;
        this.remoteName = remoteName;
        this.shareableRoot = itemToReshare;
        this.properties = properties;
        this.clientData = clientData;
        this.overwrite = overwrite;
        this.loadedComponentConfigurations = loadedComponentConfigurations;
        this.traceLog = traceLog;
    }

    private void traceIfEnabled(String message) {
        if (this.traceLog != null && this.traceLog.isTraceEnabled()) {
            this.traceLog.trace((Object)message);
        }
    }

    public void reShare(IProgressMonitor progress) throws TeamRepositoryException, FileSystemException {
        MetadataProperties properties;
        FileItemInfo proxy;
        ExternalLinkEntry[] linkInfo;
        IVersionable remoteProjectState;
        SubMonitor reshareProgress = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        ITeamRepository repo = this.connection.teamRepository();
        FileSystemServiceProxy fileSystemService = ((FileSystemManager)FileSystemCore.getFileSystemManager(repo)).getFileSystemService();
        progress.setTaskName(NLS.bind((String)Messages.ReshareProject_0, (Object)this.shareableRoot.getLocalPath(), (Object[])new Object[0]));
        if (this.connection instanceof IWorkspaceConnection) {
            remoteProjectState = ((IWorkspaceConnection)this.connection).configuration((IComponentHandle)this.component).fetchCompleteItem(this.remoteShare, (IProgressMonitor)reshareProgress.newChild(1));
            linkInfo = ((IWorkspaceConnection)this.connection).getLinkInfo(this.remoteShare, (IProgressMonitor)reshareProgress.newChild(1));
        } else {
            remoteProjectState = ((IBaselineConnection)this.connection).configuration().fetchCompleteItem(this.remoteShare, (IProgressMonitor)reshareProgress.newChild(1));
            linkInfo = ((IBaselineConnection)this.connection).getLinkInfo(this.remoteShare, (IProgressMonitor)reshareProgress.newChild(1));
        }
        ExternalLinks links = ExternalLinksDTOUtils.create((ExternalLinkEntry[])linkInfo);
        ShareOperation.ShareProperties shareProperties = this.properties.get(this.shareableRoot.getFullPath());
        if (remoteProjectState instanceof IFolderHandle) {
            proxy = new FileItemInfoProxy((IVersionableHandle)((IFolderHandle)remoteProjectState.getStateHandle()), this.parentForShare, this.remoteName, PathUtils.isLoadedWithAnotherName(this.shareableRoot.getSandbox(), this.shareableRoot.getLocalPath(), this.remoteName)).getFileItemInfo();
            reshareProgress.worked(1);
        } else if (remoteProjectState instanceof ISymbolicLink) {
            ISymbolicLink link = (ISymbolicLink)remoteProjectState;
            proxy = ReshareVersionables.sameLinkContents(this.shareableRoot, (ISymbolicLinkHandle)link.getStateHandle(), this.remoteName, this.parentForShare, link, (IProgressMonitor)reshareProgress.newChild(1));
        } else if (remoteProjectState instanceof IFileItem) {
            IFileItem fileItem = (IFileItem)remoteProjectState;
            boolean transformsContents = SharingManager.getInstance().transformsContentsSet(this.shareableRoot.getSandbox());
            proxy = this.buildFileItemInfo(this.shareableRoot, (IFileItemHandle)fileItem.getStateHandle(), this.remoteName, this.parentForShare, fileItem.isExecutable(), fileItem.getContentType(), (FileContent)fileItem.getContent(), fileItem.getUserProperties(), links, new byte[16384], repo, shareProperties, transformsContents, (IProgressMonitor)reshareProgress.newChild(1));
        } else {
            throw new FileSystemException(NLS.bind((String)Messages.ReshareVersionables_0, (Object)this.remoteName, (Object[])new Object[]{remoteProjectState.getItemType().getName()}));
        }
        ICopyFileArea cfa = ICopyFileAreaManager.instance.getExistingCopyFileArea(this.shareableRoot.getSandbox().getRoot());
        IFolderHandle loadRoot = null;
        ILoadEvaluator loadEvaluator = SharingManager.getInstance().getLoadEvaluators(Collections.singletonList(this.shareableRoot.getSandbox())).values().iterator().next();
        if (loadEvaluator.getSupportedValidations().contains((Object)ILoadEvaluator.LoadValidations.USES_LOAD_ROOT)) {
            loadRoot = remoteProjectState.getParent();
        }
        SharingDescriptor descriptor = SharingDescriptor.create(this.connection, this.component, (IVersionableHandle)remoteProjectState, loadRoot, this.clientData);
        InverseFileItemInfo oldInfo = cfa.getItemInfo((IVersionableHandle)remoteProjectState, (IComponentHandle)this.component, this.connection.getContextHandle(), false);
        Map<String, String> userProperties = shareProperties == null || shareProperties.getProperties() == null || shareProperties.getProperties().isEmpty() ? remoteProjectState.getUserProperties() : shareProperties.getProperties();
        if (oldInfo == null) {
            properties = new MetadataProperties(userProperties);
        } else {
            MetadataProperties oldProperties = new MetadataProperties(oldInfo.getOriginalProperties(), oldInfo.getChangedProperties(), oldInfo.getRemovedProperties());
            properties = new MetadataProperties(userProperties, oldProperties);
        }
        SharingManager.getInstance().share(this.shareableRoot, descriptor, proxy, properties, 1, (IProgressMonitor)reshareProgress.newChild(2));
        progress.setTaskName(NLS.bind((String)Messages.ReshareProject_1, (Object)this.shareableRoot.getLocalPath().toString(), (Object[])new Object[0]));
        LoadTree loadTree = fileSystemService.getFileTreeByVersionable(this.connection, (IComponentHandle)this.component, new IVersionableHandle[]{this.remoteShare}, -1, true, null, (IProgressMonitor)reshareProgress.newChild(20));
        progress.setTaskName(NLS.bind((String)Messages.ReshareProject_1, (Object)this.shareableRoot.getLocalPath().toString(), (Object[])new Object[0]));
        this.loadMetadata(cfa, loadTree.getFileAreaUpdates(), (IProgressMonitor)reshareProgress.newChild(60));
        cfa.setConfigurationState(this.connection.getContextHandle(), (IComponentHandle)this.component, this.remoteShare, ISyncTime.FACTORY.createFrom(loadTree.getConfigurationState()), (IProgressMonitor)reshareProgress.newChild(3));
        this.updateWorkspaceComponentState(cfa.getRoot(), loadTree.getWorkspaceComponentState(), (IProgressMonitor)reshareProgress.newChild(3));
        IShare share = this.shareableRoot.getShare((IProgressMonitor)reshareProgress.newChild(1));
        LocalChangeManager.getInstance().refreshChanges(share.getShareable(), (IProgressMonitor)reshareProgress.newChild(8));
    }

    private void updateWorkspaceComponentState(ILocation cfaRoot, long workspaceComponentState, IProgressMonitor monitor) throws FileSystemException {
        this.traceIfEnabled("ReshareVersionables#updateWorkspaceComponentState: Start.");
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        boolean refetchLoadedConfigurationDescriptor = true;
        for (LoadedConfigurationDescriptor compConfiguration : this.loadedComponentConfigurations) {
            if (!compConfiguration.getComponentHandle().getItemId().equals((Object)this.component.getItemId())) continue;
            refetchLoadedConfigurationDescriptor = false;
            break;
        }
        this.traceIfEnabled(NLS.bind((String)"ReshareVersionables#updateWorkspaceComponentState: Processing the sandbox at location: \"{0}\".", (Object)cfaRoot, (Object[])new Object[0]));
        this.traceIfEnabled("ReshareVersionables#updateWorkspaceComponentState: Fetching all the loaded configuration descriptors for the sandbox.");
        if (refetchLoadedConfigurationDescriptor) {
            this.loadedComponentConfigurations = SharingManager.getInstance().allLoadedConfigurations(cfaRoot, (IProgressMonitor)progress.newChild(50));
        } else {
            progress.worked(50);
        }
        this.traceIfEnabled(NLS.bind((String)"ReshareVersionables#updateWorkspaceComponentState: Retrieving the loaded configuration descriptor for the component \"{0}\".", (Object)this.component.getName(), (Object[])new Object[0]));
        LoadedConfigurationDescriptor loadedComponentConfiguration = CopyFileAreaUtil.getFilteredLoadedConfigurationForComponent(this.connection.getContextHandle().getItemId(), this.component.getItemId(), this.loadedComponentConfigurations);
        if (loadedComponentConfiguration != null) {
            this.traceIfEnabled("ReshareVersionables#updateWorkspaceComponentState: Invoking CopyFileAreaUtil#updateWorkspaceComponentState().");
            CopyFileAreaUtil.updateWorkspaceComponentState(cfaRoot, workspaceComponentState, false, loadedComponentConfiguration, this.traceLog, (IProgressMonitor)progress.newChild(50));
        } else {
            this.traceIfEnabled(NLS.bind((String)"ReshareVersionables#updateWorkspaceComponentState: The component \"{0}\" is not loaded, hence we do not update it's workspace component state in the metadata.", (Object)this.component.getName(), (Object[])new Object[0]));
            progress.worked(50);
        }
        this.traceIfEnabled("ReshareVersionables#updateWorkspaceComponentState: End.");
    }

    private FileItemInfo buildFileItemInfo(Shareable file, IFileItemHandle afterState, String name, IFolderHandle parent, boolean executable, String contentType, FileContent content, Map<String, String> properties, ExternalLinks links, byte[] buffer, ITeamRepository repo, ShareOperation.ShareProperties shareProperties, boolean transformsContentsSet, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        Map<String, String> userProperties = shareProperties == null || shareProperties.getProperties() == null || shareProperties.getProperties().isEmpty() ? properties : shareProperties.getProperties();
        return ReshareVersionables.sameFileContents(file, afterState, name, parent, executable, contentType, content, userProperties, links, buffer, repo, transformsContentsSet, (IProgressMonitor)progress);
    }

    private void loadMetadata(ICopyFileArea cfa, List<FileAreaUpdate> additions, IProgressMonitor monitor) throws TeamRepositoryException {
        HashMap foldersEncountered = NewCollection.hashMap();
        byte[] buffer = new byte[16384];
        SharingManager sharingManager = SharingManager.getInstance();
        ISandbox sandbox = this.shareableRoot.getSandbox();
        boolean transformsContents = sharingManager.transformsContentsSet(sandbox);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)additions.size());
        try {
            try {
                for (FileAreaUpdate currentAddition : additions) {
                    ShareOperation.ShareProperties shareProperties;
                    boolean isLoadedWithAnotherName;
                    IRelativeLocation resourcePath;
                    SubMonitor subProgress = progress.newChild(1);
                    IRelativeLocation parentPath = (IRelativeLocation)foldersEncountered.get(currentAddition.parent().getItemId());
                    if (parentPath == null) {
                        resourcePath = this.shareableRoot.getLocalPath();
                        isLoadedWithAnotherName = PathUtils.isLoadedWithAnotherName(sandbox, resourcePath, currentAddition.getName());
                    } else {
                        resourcePath = parentPath.append(currentAddition.getName());
                        isLoadedWithAnotherName = false;
                    }
                    IVersionableHandle handle = currentAddition.afterState();
                    Assert.isTrue((boolean)handle.hasStateId());
                    ResourceType hint = ResourceType.getResourceType(handle);
                    Shareable resource = sharingManager.findShareable(sandbox, resourcePath, hint);
                    ResourceType type = resource.getResourceType((IProgressMonitor)subProgress.newChild(1));
                    if (hint == ResourceType.FOLDER) {
                        foldersEncountered.put(handle.getItemId(), resourcePath);
                    }
                    Map<String, String> userProperties = (shareProperties = this.properties.get(resource.getFullPath())) == null || shareProperties.getProperties() == null || shareProperties.getProperties().isEmpty() ? currentAddition.getMetadataProperties() : shareProperties.getProperties();
                    ExternalLinks links = currentAddition.getLinkInfo();
                    IFolderHandle parent = currentAddition.parent();
                    FileItemInfo itemInfo = null;
                    if (type != null) {
                        if (type == ResourceType.FOLDER) {
                            if (hint == ResourceType.FOLDER) {
                                itemInfo = new FileItemInfoProxy(handle, parent, currentAddition.getName(), isLoadedWithAnotherName).getFileItemInfo();
                            }
                        } else if (type == ResourceType.FILE) {
                            if (hint == ResourceType.FILE) {
                                subProgress.setWorkRemaining(2);
                                itemInfo = ReshareVersionables.sameFileContents(resource, (IFileItemHandle)currentAddition.afterState(), currentAddition.getName(), currentAddition.getDestinationParent(), currentAddition.isExecutable(), currentAddition.getContentType(), (FileContent)currentAddition.getOptionalContent(), userProperties, links, buffer, this.connection.teamRepository(), transformsContents, (IProgressMonitor)subProgress.newChild(1));
                            }
                        } else if (type == ResourceType.SYMBOLIC_LINK && hint == ResourceType.SYMBOLIC_LINK) {
                            subProgress.setWorkRemaining(2);
                            itemInfo = ReshareVersionables.sameLinkContents(resource, (ISymbolicLinkHandle)currentAddition.afterState(), currentAddition.getName(), currentAddition.getDestinationParent(), currentAddition, (IProgressMonitor)subProgress);
                        }
                    }
                    subProgress.setWorkRemaining(1);
                    if (itemInfo != null) {
                        subProgress.setWorkRemaining(1);
                        cfa.setItemMetaData(resourcePath, itemInfo, ICopyFileArea.PropertyUpdate.REPLACE_ORIGINAL, new MetadataProperties(userProperties), (IProgressMonitor)subProgress.newChild(1));
                    } else {
                        long lastCheckStamp;
                        boolean modified;
                        ContentHash hash = null;
                        long size = -1L;
                        FileLineDelimiter lineDelimiter = null;
                        String contentType = null;
                        ContentHash predecessorHintHash = null;
                        long storedSize = -1L;
                        String encoding = null;
                        ContentHash storedHash = null;
                        long storedNumLineDelimiters = -1L;
                        if (currentAddition.getOptionalContent() != null) {
                            FileContent content = (FileContent)currentAddition.getOptionalContent();
                            if (FileSystemCore.getContentManager(this.connection.teamRepository()).convertDelimitersDuringRetrieval((IFileContent)content)) {
                                subProgress.setWorkRemaining(10);
                                try (InputStream in = FileSystemCore.getContentManager(this.connection.teamRepository()).retrieveContentStream((IFileItemHandle)currentAddition.afterState(), (IFileContent)content, (IProgressMonitor)subProgress.newChild(9));){
                                    DigestComputingInputStream hin = ContentHash.getDigestComputingStream((InputStream)in);
                                    while (hin.read(buffer) != -1) {
                                    }
                                    hash = ContentHash.valueOf((byte[])hin.getFinalDigest());
                                    size = hin.getContentSize();
                                }
                                catch (VersionedContentDeleted e) {
                                    hash = content.getHash();
                                    size = content.getSize();
                                }
                            } else {
                                hash = content.getHash();
                                size = content.getEstimatedConvertedLength();
                            }
                            lineDelimiter = content.getLineDelimiter();
                            contentType = currentAddition.getContentType();
                            predecessorHintHash = content.getPredecessorHintHash();
                            storedSize = content.getSize();
                            encoding = content.getCharacterEncoding();
                            storedHash = content.getHash();
                            storedNumLineDelimiters = content.getLineDelimiterCount();
                        } else if (currentAddition.afterState() instanceof ISymbolicLinkHandle) {
                            String remoteTargetInLocalForm = resource.getFileStorage().convertTargetIntoLocalForm(currentAddition.getLinkTarget());
                            hash = storedHash = FileItemInfoProxy.getLinkTargetHash(remoteTargetInLocalForm);
                        }
                        subProgress.setWorkRemaining(1);
                        InverseFileItemInfo oldInfo = cfa.getItemInfo(handle, (IComponentHandle)this.component, this.connection.getContextHandle(), false);
                        if (oldInfo == null || handle instanceof IFolderHandle) {
                            modified = false;
                            lastCheckStamp = -1L;
                        } else if (oldInfo.getHash() != null && oldInfo.getHash().equals((Object)hash) && (handle instanceof ISymbolicLinkHandle || handle instanceof IFileItemHandle && oldInfo.getContentLength() == size)) {
                            modified = oldInfo.isContentChanged();
                            lastCheckStamp = oldInfo.getLastContentChangeCheckStamp();
                        } else {
                            modified = true;
                            lastCheckStamp = -1L;
                        }
                        itemInfo = new FileItemInfo(handle, modified, lastCheckStamp, parent, currentAddition.getName(), isLoadedWithAnotherName, hash, size, lineDelimiter, lineDelimiter, contentType, contentType, predecessorHintHash, storedSize, encoding, storedHash, storedNumLineDelimiters, currentAddition.isExecutable(), currentAddition.isExecutable(), currentAddition.isDirectoryLink(), currentAddition.isDirectoryLink(), links, links);
                        cfa.setItemMetaData(this.connection.getContextHandle(), (IComponentHandle)this.component, itemInfo, ICopyFileArea.PropertyUpdate.REPLACE_ORIGINAL, new MetadataProperties(userProperties), (IProgressMonitor)subProgress.newChild(1));
                    }
                    subProgress.done();
                }
            }
            catch (IOException e) {
                throw new FileSystemException(e);
            }
        }
        finally {
            progress.done();
        }
    }

    private static FileItemInfo sameLinkContents(Shareable link, ISymbolicLinkHandle afterState, String name, IFolderHandle parent, ISymbolicLink remote, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        boolean contentChanged;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IFileStorage linkStorage = link.getFileStorage();
        LinkInfo diskTargetInfo = linkStorage.getLinkInfo((IProgressMonitor)progress.newChild(1));
        String remoteTarget = remote.getTarget();
        remoteTarget = link.getFileStorage().convertTargetIntoLocalForm(remoteTarget);
        boolean isLoadedWithAnotherName = PathUtils.isLoadedWithAnotherName(link.getSandbox(), link.getLocalPath(), name);
        ContentHash hashCode = FileItemInfoProxy.getLinkTargetHash(diskTargetInfo.getTarget());
        ContentHash remoteHashCode = FileItemInfoProxy.getLinkTargetHash(remoteTarget);
        ContentHash realRemoteHashCode = FileItemInfoProxy.getLinkTargetHash(remote.getTarget());
        boolean bl = contentChanged = !hashCode.equals((Object)remoteHashCode);
        boolean isDirectoryLink = diskTargetInfo.getType() != LinkType.NONE ? diskTargetInfo.getType() == LinkType.DIRECTORY : remote.isDirectoryLink();
        return new FileItemInfo(afterState, contentChanged, parent, name, isLoadedWithAnotherName, remoteHashCode, realRemoteHashCode, isDirectoryLink, remote.isDirectoryLink());
    }

    private static FileItemInfo sameLinkContents(Shareable link, ISymbolicLinkHandle afterState, String name, IFolderHandle parent, FileAreaUpdate update, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        boolean contentChanged;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IFileStorage linkStorage = link.getFileStorage();
        LinkInfo diskTargetInfo = linkStorage.getLinkInfo((IProgressMonitor)progress.newChild(1));
        String remoteTarget = update.getLinkTarget();
        remoteTarget = link.getFileStorage().convertTargetIntoLocalForm(remoteTarget);
        boolean isLoadedWithAnotherName = PathUtils.isLoadedWithAnotherName(link.getSandbox(), link.getLocalPath(), name);
        ContentHash hashCode = FileItemInfoProxy.getLinkTargetHash(diskTargetInfo.getTarget());
        ContentHash remoteHashCode = FileItemInfoProxy.getLinkTargetHash(remoteTarget);
        ContentHash realRemoteHashCode = FileItemInfoProxy.getLinkTargetHash(update.getLinkTarget());
        boolean bl = contentChanged = !hashCode.equals((Object)remoteHashCode);
        boolean isDirectoryLink = diskTargetInfo.getType() != LinkType.NONE ? diskTargetInfo.getType() == LinkType.DIRECTORY : update.isDirectoryLink();
        return new FileItemInfo(afterState, contentChanged, parent, name, isLoadedWithAnotherName, remoteHashCode, realRemoteHashCode, isDirectoryLink, update.isDirectoryLink());
    }

    private static FileItemInfo sameFileContents(Shareable file, IFileItemHandle afterState, String name, IFolderHandle parent, boolean executable, String contentType, FileContent content, Map<String, String> properties, ExternalLinks links, byte[] buffer, ITeamRepository repo, boolean transformsContentsSet, IProgressMonitor monitor) throws TeamRepositoryException {
        String actualContentType;
        String originalContentType;
        FileLineDelimiter actualLineDelimiter;
        FileLineDelimiter originalLineDelimiter;
        ContentHash hashCode;
        long contentSize;
        boolean contentChanged;
        long modificationTime;
        SubMonitor progress;
        block36: {
            progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            modificationTime = -1L;
            contentChanged = true;
            contentSize = content.getEstimatedConvertedLength();
            hashCode = null;
            originalLineDelimiter = content.getLineDelimiter();
            actualLineDelimiter = content.getLineDelimiter();
            originalContentType = contentType;
            actualContentType = contentType;
            IFileStorage fileStorage = file.getFileStorage();
            if (fileStorage.exists((IProgressMonitor)progress.newChild(1))) {
                try {
                    DigestComputingInputStream localHashedStream;
                    DigestComputingInputStream remoteHashedStream;
                    long localLength;
                    modificationTime = fileStorage.getModificationStamp();
                    if (transformsContentsSet || (localLength = fileStorage.getSize((IProgressMonitor)progress.newChild(1))) != content.getEstimatedConvertedLength() && localLength != -1L) break block36;
                    FileOptions options = new FileOptions(true, content.getLineDelimiter(), content.getCharacterEncoding(), properties);
                    InputStream inStream = fileStorage.getContents(options);
                    IContentExaminer contentExaminer = SharingManager.getInstance().getContentExaminer(fileStorage.getShareable());
                    try {
                        block7 : switch (originalLineDelimiter) {
                            case LINE_DELIMITER_CR: {
                                String encoding = contentExaminer.getEncoding(file, (IProgressMonitor)progress.newChild(1));
                                inStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToCRInputStream(inStream, encoding));
                                localHashedStream = remoteHashedStream = ContentHash.getDigestComputingStream((InputStream)inStream);
                                break;
                            }
                            case LINE_DELIMITER_PLATFORM: {
                                String encoding = contentExaminer.getEncoding(file, (IProgressMonitor)progress.newChild(1));
                                switch (FileLineDelimiter.getPlatformDelimiter()) {
                                    case LINE_DELIMITER_CRLF: {
                                        inStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToCRLFInputStream(inStream, encoding));
                                        localHashedStream = ContentHash.getDigestComputingStream((InputStream)inStream);
                                        inStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToLFInputStream((InputStream)localHashedStream, encoding));
                                        remoteHashedStream = ContentHash.getDigestComputingStream((InputStream)inStream);
                                        break block7;
                                    }
                                    case LINE_DELIMITER_CR: {
                                        inStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToCRInputStream(inStream, encoding));
                                        localHashedStream = ContentHash.getDigestComputingStream((InputStream)inStream);
                                        inStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToLFInputStream((InputStream)localHashedStream, encoding));
                                        remoteHashedStream = ContentHash.getDigestComputingStream((InputStream)inStream);
                                        break block7;
                                    }
                                }
                                inStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToLFInputStream(inStream, encoding));
                                localHashedStream = remoteHashedStream = ContentHash.getDigestComputingStream((InputStream)inStream);
                                break;
                            }
                            case LINE_DELIMITER_LF: {
                                String encoding = contentExaminer.getEncoding(file, (IProgressMonitor)progress.newChild(1));
                                inStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToLFInputStream(inStream, encoding));
                                localHashedStream = remoteHashedStream = ContentHash.getDigestComputingStream((InputStream)inStream);
                                break;
                            }
                            case LINE_DELIMITER_CRLF: {
                                String encoding = contentExaminer.getEncoding(file, (IProgressMonitor)progress.newChild(1));
                                inStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToCRLFInputStream(inStream, encoding));
                                localHashedStream = remoteHashedStream = ContentHash.getDigestComputingStream((InputStream)inStream);
                                break;
                            }
                            default: {
                                localHashedStream = remoteHashedStream = ContentHash.getDigestComputingStream((InputStream)inStream);
                            }
                        }
                        while (remoteHashedStream.read(buffer) != -1) {
                        }
                    }
                    finally {
                        inStream.close();
                    }
                    ContentHash convertedRemoteHashCode = ContentHash.valueOf((byte[])remoteHashedStream.getFinalDigest());
                    if (convertedRemoteHashCode.equals((Object)content.getHash()) && remoteHashedStream.getContentSize() == content.getRawLength() && localHashedStream.getContentSize() == content.getEstimatedConvertedLength()) {
                        hashCode = localHashedStream == remoteHashedStream ? convertedRemoteHashCode : ContentHash.valueOf((byte[])localHashedStream.getFinalDigest());
                        contentSize = localHashedStream.getContentSize();
                        contentChanged = false;
                    }
                }
                catch (ContentLineDelimiterError e) {
                    actualLineDelimiter = FileLineDelimiter.LINE_DELIMITER_NONE;
                }
                catch (IOException ioe) {
                    actualLineDelimiter = FileLineDelimiter.LINE_DELIMITER_NONE;
                }
            }
        }
        if (hashCode == null) {
            if (FileSystemCore.getContentManager(repo).convertDelimitersDuringRetrieval((IFileContent)content) || transformsContentsSet) {
                progress.setWorkRemaining(20);
                try {
                    InputStream in = FileSystemCore.getContentManager(repo).retrieveContentStream(afterState, (IFileContent)content, (IProgressMonitor)progress.newChild(20));
                    DigestComputingInputStream hin = null;
                    try {
                        try {
                            ILoadMutator loadMutator = SharingManager.getInstance().getLoadMutator(file.getSandbox(), LoadDilemmaHandler.getDefault());
                            IFileOptions fileOptions = FileOptionsFactory.getFileOptions(true, content.getLineDelimiter(), content.getCharacterEncoding(), properties);
                            in = loadMutator.prepareContentsToSet(fileOptions, in);
                            hin = ContentHash.getDigestComputingStream((InputStream)in);
                            while (hin.read(buffer) != -1) {
                            }
                            hashCode = ContentHash.valueOf((byte[])hin.getFinalDigest());
                            contentSize = hin.getContentSize();
                        }
                        catch (IOException e) {
                            throw new TeamRepositoryException((Throwable)e);
                        }
                    }
                    finally {
                        try {
                            if (hin != null) {
                                hin.close();
                            } else {
                                in.close();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (VersionedContentDeleted e) {
                    hashCode = content.getHash();
                    contentSize = content.getSize();
                }
            } else {
                hashCode = content.getHash();
                contentSize = content.getEstimatedConvertedLength();
            }
        }
        boolean isLoadedWithAnotherName = PathUtils.isLoadedWithAnotherName(file.getSandbox(), file.getLocalPath(), name);
        return new FileItemInfo((IVersionableHandle)afterState, contentChanged, modificationTime, parent, name, isLoadedWithAnotherName, hashCode, contentSize, originalLineDelimiter, actualLineDelimiter, originalContentType, actualContentType, content.getPredecessorHintHash(), content.getSize(), content.getCharacterEncoding(), content.getHash(), content.getLineDelimiterCount(), executable, executable, false, false, links, links);
    }

    public void determineOverlaps(Map<IShareable, ShareOverlap> overlaps, IProgressMonitor monitor) throws FileSystemException {
        ISandbox sandbox = this.shareableRoot.getSandbox();
        ICopyFileArea cfa = ICopyFileAreaManager.instance.getCopyFileAreaForPath(sandbox.getRoot());
        IShare share = cfa.getShare(this.connection.getContextHandle(), (IComponentHandle)this.component, (IVersionableHandle)this.parentForShare, monitor);
        if (share != null) {
            ShareOverlap overlap = overlaps.get(this.shareableRoot);
            if (overlap == null) {
                overlap = new ShareOverlap(this.connection, (IComponentHandle)this.component, this.shareableRoot);
                overlaps.put(this.shareableRoot, overlap);
            }
            overlap.addShareOverlap(share);
        }
    }
}

