/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.rest.util;

import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.OperationFactory;
import com.ibm.team.filesystem.client.internal.componenthierarchy.ComponentHierarchyManager;
import com.ibm.team.filesystem.client.internal.operations.IUpdateSubcomponentOperation;
import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.internal.rest.util.CoreUtil;
import com.ibm.team.filesystem.client.internal.rest.util.ISyncViewProxy;
import com.ibm.team.filesystem.client.internal.rest.util.RefreshUtil;
import com.ibm.team.filesystem.client.internal.rest.util.WorkspaceUpdateUtil;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.FlowTableUtil;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.client.operations.IWorkspaceUpdateOperation;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.client.operations.WorkspaceUpdateDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsChangeSetCustomAttributes;
import com.ibm.team.filesystem.client.rest.parameters.ParmsComponentChange;
import com.ibm.team.filesystem.client.rest.parameters.ParmsComponentCustomAttributes;
import com.ibm.team.filesystem.client.rest.parameters.ParmsComponentHierarchyChange;
import com.ibm.team.filesystem.client.rest.parameters.ParmsComponentSeed;
import com.ibm.team.filesystem.client.rest.parameters.ParmsConfigurationChanges;
import com.ibm.team.filesystem.client.rest.parameters.ParmsFlowTargetChange;
import com.ibm.team.filesystem.client.rest.parameters.ParmsGetWorkspaceDetails;
import com.ibm.team.filesystem.client.rest.parameters.ParmsHistoryReference;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPendingChangesDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPostWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPostWorkspaceFromHistoryReference;
import com.ibm.team.filesystem.client.rest.parameters.ParmsProperty;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPutComponent;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPutWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsReadScope;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceCustomAttributes;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceSandboxSubfolder;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceUpdateDilemmaHandler;
import com.ibm.team.filesystem.common.internal.rest.client.core.ComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.FilesystemRestClientDTOcoreFactory;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceDetailsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.ChangeSetCustomAttributesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.ComponentCustomAttributesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.ComponentHierarchyUpdateResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.FilesystemRestClientDTOworkspaceFactory;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.GetWorkspaceDetailsResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.PutWorkspaceResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.WorkspaceCustomAttributesDTO;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.internal.common.ProcessPackage;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.model.ItemType;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.ConnectionDescriptor;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineHierarchyResult;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IComponentHierarchyResult;
import com.ibm.team.scm.common.IComponentHierarchyUpdateResult;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IHierarchyNode;
import com.ibm.team.scm.common.IHierarchyResult;
import com.ibm.team.scm.common.IHistoryReference;
import com.ibm.team.scm.common.IScmService;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IContributorDeferringScope;
import com.ibm.team.scm.common.dto.IPermissionContextProvider;
import com.ibm.team.scm.common.dto.IReadScope;
import com.ibm.team.scm.common.internal.dto.AccessGroupScope;
import com.ibm.team.scm.common.internal.dto2.ScmDto2Factory;
import com.ibm.team.scm.common.internal.dto2.WorkspaceComponentState;
import com.ibm.team.scm.common.internal.subcomponents.SubcomponentCommonUtils;
import com.ibm.team.scm.common.internal.util.RestUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class WorkspaceUtil {
    private static final String putWorkspaceRequest = "postPutWorkspace";

    public static PutWorkspaceResultDTO putWorkspace(ParmsPutWorkspace parms, ISyncViewProxy syncViewProxy, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        ITeamRepository repo = CommonUtil.getTeamRepository(parms.workspace.repositoryUrl);
        IWorkspaceConnection wc = parms.workspace.getWorkspaceConnection((IProgressMonitor)monitor.newChild(10));
        IWorkspace workspace = wc.getResolvedWorkspace();
        if (RestUtils.isSet((String)parms.name) && !workspace.getName().equals(parms.name)) {
            wc.setName(parms.name, (IProgressMonitor)monitor.newChild(5));
        }
        if (parms.description != null && !parms.description.equals(workspace.getDescription())) {
            wc.setDescription(parms.description, (IProgressMonitor)monitor.newChild(5));
        }
        IReadScope scope = IScmService.DEFAULT_VISIBILITY;
        if (parms.readScope != null) {
            scope = WorkspaceUtil.createVisibility(parms.readScope);
        }
        IAuditableHandle newOwner = IScmService.NOOP_OWNER;
        if (RestUtils.isSet((String)parms.newOwnerItemId)) {
            if (wc.isStream()) {
                if (!RestUtils.isSet((String)parms.newOwnerItemType)) {
                    throw new IllegalArgumentException("require project area type to be set for streams");
                }
                ItemType itemType = ItemUtil.itemTypeFor((String)parms.newOwnerItemType, (String)ProcessPackage.eINSTANCE.getNsURI());
                if (itemType == null) {
                    throw new IllegalArgumentException("invalid newOwnerItemType : " + parms.newOwnerItemType);
                }
                IProcessAreaHandle processAreaHandle = (IProcessAreaHandle)itemType.createItemHandle((Object)repo, UUID.valueOf((String)parms.newOwnerItemId), null);
                newOwner = processAreaHandle;
            } else {
                newOwner = (IContributorHandle)IContributor.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)parms.newOwnerItemId), null);
            }
        }
        if (scope != IScmService.DEFAULT_VISIBILITY || newOwner != IScmService.NOOP_OWNER) {
            wc.setOwnerAndVisibility(newOwner, scope, (IProgressMonitor)monitor.newChild(5));
        }
        if (parms.exclusiveFileLockPatterns != null) {
            wc.setExclusiveFileLockPatterns(parms.exclusiveFileLockPatterns, (IProgressMonitor)monitor.newChild(5));
        }
        PutWorkspaceResultDTO result = FilesystemRestClientDTOworkspaceFactory.eINSTANCE.createPutWorkspaceResultDTO();
        try {
            WorkspaceUtil.applyComponentChanges(wc, parms.configurationChanges, result, (IProgressMonitor)monitor.newChild(50));
            if (parms.componentHierarchyChanges != null) {
                ComponentHierarchyUpdateResultDTO componentHierarchyUpdateResultDTO = WorkspaceUtil.applyComponentHierarchyChanges(wc, parms.componentHierarchyChanges, (IProgressMonitor)monitor.newChild(10));
                result.setComponentHierarchyUpdateResult(componentHierarchyUpdateResultDTO);
            }
            WorkspaceUtil.applyFlowTableChanges(wc, parms, syncViewProxy, (IProgressMonitor)monitor.newChild(10));
            result.setWorkspace(CoreUtil.translateWorkspace(wc, true, true, true, true, true, (IProgressMonitor)monitor.newChild(10)));
        }
        catch (OperationCanceledException e) {
            result.setCancelled(true);
        }
        return result;
    }

    private static void applyFlowTableChanges(IWorkspaceConnection connection, ParmsPutWorkspace parms, ISyncViewProxy syncViewProxy, IProgressMonitor monitor) throws TeamRepositoryException {
        ConnectionDescriptor updatedCurrentOutgoingDescriptor;
        ConnectionDescriptor updatedCurrentIncomingDescriptor;
        IWorkspaceHandle defaultWorkspaceHandle;
        int n;
        int n2;
        Object[] objectArray;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IFlowTable flowTable = connection.getFlowTable().getWorkingCopy();
        boolean changed = false;
        ConnectionDescriptor oldCurrentIncomingDescriptor = FlowTableUtil.getCurrentIncomingCollaborationDescriptor(flowTable, connection.teamRepository());
        ConnectionDescriptor oldCurrentOutgoingDescriptor = FlowTableUtil.getCurrentOutgoingCollaborationDescriptor(flowTable, connection.teamRepository());
        if (parms.flowTargetsToRemove != null && parms.flowTargetsToRemove.length > 0) {
            objectArray = parms.flowTargetsToRemove;
            n2 = parms.flowTargetsToRemove.length;
            n = 0;
            while (n < n2) {
                Object workspace = objectArray[n];
                IWorkspaceHandle workspaceHandle = ((ParmsWorkspace)workspace).getWorkspaceHandle();
                FlowTableUtil.removeCollaboration(flowTable, workspaceHandle);
                ++n;
            }
            changed = true;
        }
        if (parms.flowTargets != null && parms.flowTargets.length > 0) {
            objectArray = parms.flowTargets;
            n2 = parms.flowTargets.length;
            n = 0;
            while (n < n2) {
                Object change = objectArray[n];
                IWorkspaceHandle flowTarget = ((ParmsFlowTargetChange)change).workspace.getWorkspaceHandle();
                if (flowTable.getAcceptFlow((IFlowNodeHandle)flowTarget) != null || flowTable.getDeliverFlow((IFlowNodeHandle)flowTarget) != null) {
                    if (((ParmsFlowTargetChange)change).getComponentScopes() != null) {
                        flowTable.setComponentScopes((IFlowNodeHandle)flowTarget, ((ParmsFlowTargetChange)change).getComponentScopes());
                        changed = true;
                    }
                    boolean collaborationChanged = false;
                    if (((ParmsFlowTargetChange)change).flowDirection != null) {
                        boolean incomingCollaborationSet;
                        if (((ParmsFlowTargetChange)change).flowDirection.equals("incoming")) {
                            incomingCollaborationSet = WorkspaceUtil.setFlowTarget(connection, flowTable, ((ParmsFlowTargetChange)change).workspace, 1, progress.newChild(20));
                            boolean outgoingCollaborationRemoved = FlowTableUtil.removeOutgoingCollaboration(flowTable, (IFlowNodeHandle)flowTarget, (IProgressMonitor)progress.newChild(20));
                            collaborationChanged = incomingCollaborationSet || outgoingCollaborationRemoved;
                        } else if (((ParmsFlowTargetChange)change).flowDirection.equals("outgoing")) {
                            boolean outgoingCollaborationSet = WorkspaceUtil.setFlowTarget(connection, flowTable, ((ParmsFlowTargetChange)change).workspace, 2, progress.newChild(20));
                            boolean incomingCollaborationRemoved = FlowTableUtil.removeIncomingCollaboration(flowTable, (IFlowNodeHandle)flowTarget, (IProgressMonitor)progress.newChild(20));
                            collaborationChanged = outgoingCollaborationSet || incomingCollaborationRemoved;
                        } else if (((ParmsFlowTargetChange)change).flowDirection.equals("incoming_outgoing")) {
                            incomingCollaborationSet = WorkspaceUtil.setFlowTarget(connection, flowTable, ((ParmsFlowTargetChange)change).workspace, 1, progress.newChild(20));
                            boolean outgoingCollaborationSet = WorkspaceUtil.setFlowTarget(connection, flowTable, ((ParmsFlowTargetChange)change).workspace, 2, progress.newChild(20));
                            boolean bl = collaborationChanged = incomingCollaborationSet || outgoingCollaborationSet;
                        }
                        if (collaborationChanged) {
                            changed = true;
                        }
                    }
                } else {
                    IWorkspaceConnection remote = ((ParmsFlowTargetChange)change).workspace.getWorkspaceConnection((IProgressMonitor)progress.newChild(10));
                    if (((ParmsFlowTargetChange)change).flowDirection == null || ((ParmsFlowTargetChange)change).flowDirection.equals("incoming_outgoing")) {
                        FlowTableUtil.addCollaboration(flowTable, connection, remote);
                    } else if (((ParmsFlowTargetChange)change).flowDirection.equals("incoming")) {
                        FlowTableUtil.addIncomingCollaboration(flowTable, connection, remote);
                    } else if (((ParmsFlowTargetChange)change).flowDirection.equals("outgoing")) {
                        FlowTableUtil.addOutgoingCollaboration(flowTable, connection, remote);
                    }
                    flowTable.setComponentScopes((IFlowNodeHandle)flowTarget, ((ParmsFlowTargetChange)change).getComponentScopes() == null ? Collections.EMPTY_LIST : ((ParmsFlowTargetChange)change).getComponentScopes());
                    changed = true;
                }
                ++n;
            }
        }
        if (parms.defaultIncomingFlowTarget != null && WorkspaceUtil.setDefaultFlowTarget(connection, flowTable, defaultWorkspaceHandle = parms.defaultIncomingFlowTarget.getWorkspaceHandle(), 1)) {
            changed = true;
        }
        if (parms.defaultOutgoingFlowTarget != null && WorkspaceUtil.setDefaultFlowTarget(connection, flowTable, defaultWorkspaceHandle = parms.defaultOutgoingFlowTarget.getWorkspaceHandle(), 2)) {
            changed = true;
        }
        boolean currentIncomingChanged = false;
        IWorkspaceConnection newCurrentIncomingConnection = null;
        if (parms.currentIncomingFlowTarget != null && WorkspaceUtil.setCurrentFlowTarget(connection, flowTable, newCurrentIncomingConnection = parms.currentIncomingFlowTarget.getWorkspaceConnection((IProgressMonitor)progress.newChild(10)), 1)) {
            currentIncomingChanged = true;
            changed = true;
        }
        if (!currentIncomingChanged && (newCurrentIncomingConnection = WorkspaceUtil.isUpdatedCurrentFlowTarget(oldCurrentIncomingDescriptor, updatedCurrentIncomingDescriptor = FlowTableUtil.getCurrentIncomingCollaborationDescriptor(flowTable, connection.teamRepository()), connection, progress.newChild(10))) != null) {
            currentIncomingChanged = true;
        }
        boolean currentOutgoingChanged = false;
        IWorkspaceConnection newCurrentOutgoingConnection = null;
        if (parms.currentOutgoingFlowTarget != null && WorkspaceUtil.setCurrentFlowTarget(connection, flowTable, newCurrentOutgoingConnection = parms.currentOutgoingFlowTarget.getWorkspaceConnection((IProgressMonitor)progress.newChild(10)), 2)) {
            currentOutgoingChanged = true;
            changed = true;
        }
        if (!currentOutgoingChanged && (newCurrentOutgoingConnection = WorkspaceUtil.isUpdatedCurrentFlowTarget(oldCurrentOutgoingDescriptor, updatedCurrentOutgoingDescriptor = FlowTableUtil.getCurrentOutgoingCollaborationDescriptor(flowTable, connection.teamRepository()), connection, progress.newChild(10))) != null) {
            currentOutgoingChanged = true;
        }
        if (changed) {
            connection.setFlowTable(flowTable, (IProgressMonitor)progress.newChild(29));
        }
        if (currentIncomingChanged) {
            syncViewProxy.setWorkspaceIncomingCollaboration(connection.getResolvedWorkspace(), newCurrentIncomingConnection, false, (IProgressMonitor)progress.newChild(1));
        }
        if (currentOutgoingChanged) {
            syncViewProxy.setWorkspaceOutgoingCollaboration(connection.getResolvedWorkspace(), newCurrentOutgoingConnection, false, (IProgressMonitor)progress.newChild(1));
        }
    }

    private static IWorkspaceConnection isUpdatedCurrentFlowTarget(ConnectionDescriptor oldDescriptor, ConnectionDescriptor updatedDescriptor, IWorkspaceConnection sourceConnection, SubMonitor monitor) throws TeamRepositoryException {
        boolean changed;
        IWorkspaceHandle updatedConnectionHandle;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IWorkspaceConnection newConnection = null;
        IWorkspaceHandle oldConnectionHandle = oldDescriptor != null ? (IWorkspaceHandle)oldDescriptor.connectionHandle : null;
        IWorkspaceHandle iWorkspaceHandle = updatedConnectionHandle = updatedDescriptor != null ? (IWorkspaceHandle)updatedDescriptor.connectionHandle : null;
        boolean bl = oldConnectionHandle == null ? updatedDescriptor != null : (changed = !oldConnectionHandle.sameItemId((IItemHandle)updatedConnectionHandle));
        if (changed) {
            if (updatedConnectionHandle == null) {
                newConnection = sourceConnection;
            } else {
                ParmsWorkspace workspace = new ParmsWorkspace(updatedDescriptor.uri, updatedConnectionHandle.getItemId().getUuidValue());
                newConnection = workspace.getWorkspaceConnection((IProgressMonitor)progress.newChild(100));
            }
        }
        return newConnection;
    }

    private static boolean setFlowTarget(IWorkspaceConnection connection, IFlowTable flowTable, ParmsWorkspace flowTargetWorkspace, int flowType, SubMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        boolean changed = false;
        List<ConnectionDescriptor> flowTargets = (flowType & 1) != 0 ? FlowTableUtil.getIncomingCollaborationDescriptors(flowTable, connection.teamRepository()) : FlowTableUtil.getOutgoingCollaborationDescriptors(flowTable, connection.teamRepository());
        boolean found = false;
        for (ConnectionDescriptor flowTarget : flowTargets) {
            if (!flowTargetWorkspace.workspaceItemId.equals(flowTarget.connectionHandle.getItemId().getUuidValue())) continue;
            found = true;
        }
        if (!found) {
            IWorkspaceConnection remoteConnection = flowTargetWorkspace.getWorkspaceConnection((IProgressMonitor)progress.newChild(100));
            if ((flowType & 1) != 0) {
                FlowTableUtil.addIncomingCollaboration(flowTable, connection, remoteConnection);
            } else {
                FlowTableUtil.addOutgoingCollaboration(flowTable, connection, remoteConnection);
            }
            changed = true;
        }
        return changed;
    }

    private static boolean setDefaultFlowTarget(IWorkspaceConnection connection, IFlowTable flowTable, IWorkspaceHandle defaultWorkspaceHandle, int flowType) {
        boolean changed = false;
        ConnectionDescriptor oldDefaultFlowTargetDescriptor = (flowType & 1) != 0 ? FlowTableUtil.getDefaultIncomingCollaborationDescriptor(flowTable, connection.teamRepository()) : FlowTableUtil.getDefaultOutgoingCollaborationDescriptor(flowTable, connection.teamRepository());
        IWorkspaceHandle oldDefaultFlowTargetHandle = (IWorkspaceHandle)(oldDefaultFlowTargetDescriptor != null ? oldDefaultFlowTargetDescriptor.connectionHandle : null);
        if (!defaultWorkspaceHandle.sameItemId((IItemHandle)oldDefaultFlowTargetHandle)) {
            IFlowEntry flowEntry;
            IFlowEntry iFlowEntry = flowEntry = (flowType & 1) != 0 ? flowTable.getAcceptFlow((IFlowNodeHandle)defaultWorkspaceHandle) : flowTable.getDeliverFlow((IFlowNodeHandle)defaultWorkspaceHandle);
            if (flowEntry == null && connection.getResolvedWorkspace().getItemHandle().getItemId().equals((Object)defaultWorkspaceHandle.getItemId())) {
                defaultWorkspaceHandle = null;
            }
            if ((flowType & 1) != 0) {
                FlowTableUtil.setDefaultIncomingCollaboration(flowTable, defaultWorkspaceHandle);
            } else {
                FlowTableUtil.setDefaultOutgoingCollaboration(flowTable, defaultWorkspaceHandle);
            }
            changed = true;
        }
        return changed;
    }

    private static boolean setCurrentFlowTarget(IWorkspaceConnection connection, IFlowTable flowTable, IWorkspaceConnection newCurrentConnection, int flowType) {
        boolean changed = false;
        ConnectionDescriptor oldCurrentFlowTargetDescriptor = (flowType & 1) != 0 ? FlowTableUtil.getCurrentIncomingCollaborationDescriptor(flowTable, connection.teamRepository()) : FlowTableUtil.getCurrentOutgoingCollaborationDescriptor(flowTable, connection.teamRepository());
        IWorkspaceHandle oldCurrentFlowTargetHandle = (IWorkspaceHandle)(oldCurrentFlowTargetDescriptor != null ? oldCurrentFlowTargetDescriptor.connectionHandle : null);
        if (!newCurrentConnection.getContextHandle().sameItemId((IItemHandle)oldCurrentFlowTargetHandle)) {
            IFlowEntry flowEntry;
            IWorkspace currentWorkspaceHandle = newCurrentConnection.getResolvedWorkspace();
            IFlowEntry iFlowEntry = flowEntry = (flowType & 1) != 0 ? flowTable.getAcceptFlow((IFlowNodeHandle)currentWorkspaceHandle) : flowTable.getDeliverFlow((IFlowNodeHandle)currentWorkspaceHandle);
            if (flowEntry == null && connection.equals((Object)newCurrentConnection)) {
                currentWorkspaceHandle = null;
            }
            if ((flowType & 1) != 0) {
                FlowTableUtil.setCurrentIncomingCollaboration(flowTable, (IWorkspaceHandle)currentWorkspaceHandle);
            } else {
                FlowTableUtil.setCurrentOutgoingCollaboration(flowTable, (IWorkspaceHandle)currentWorkspaceHandle);
            }
            changed = true;
        }
        return changed;
    }

    private static ComponentHierarchyUpdateResultDTO applyComponentHierarchyChanges(IWorkspaceConnection workspaceConnection, ParmsComponentHierarchyChange componentHierarchyChanges, IProgressMonitor progress) throws TeamRepositoryException {
        ITeamRepository teamRepository = workspaceConnection.teamRepository();
        UUID parentComponentUuid = UUID.valueOf((String)componentHierarchyChanges.parentComponentUuid);
        IComponentHandle parentComponentHandle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((Object)teamRepository, parentComponentUuid, null);
        List<IComponentHandle> subcomponentsToAdd = WorkspaceUtil.uuidStringsToComponentHandles(teamRepository, componentHierarchyChanges.subcomponentsToAddUuids);
        List<IComponentHandle> subcomponentsToRemove = WorkspaceUtil.uuidStringsToComponentHandles(teamRepository, componentHierarchyChanges.subcomponentsToRemoveUuids);
        IChangeSetHandle changesetHandle = null;
        if (componentHierarchyChanges.changeSetUuid != null) {
            UUID changesetUuid = UUID.valueOf((String)componentHierarchyChanges.changeSetUuid);
            changesetHandle = (IChangeSetHandle)IChangeSet.ITEM_TYPE.createItemHandle((Object)teamRepository, changesetUuid, null);
        }
        IUpdateSubcomponentOperation updateSubcomponentOperation = OperationFactory.getInstance().getUpdateSubcomponentOperation(UpdateDilemmaHandler.getDefault());
        updateSubcomponentOperation.addSubcomponents(workspaceConnection, parentComponentHandle, subcomponentsToAdd, changesetHandle);
        updateSubcomponentOperation.removeSubcomponents(workspaceConnection, parentComponentHandle, subcomponentsToRemove, changesetHandle);
        updateSubcomponentOperation.run(progress);
        IComponentHierarchyUpdateResult updateSubcomponentData = updateSubcomponentOperation.getResult();
        ComponentHierarchyUpdateResultDTO result = FilesystemRestClientDTOworkspaceFactory.eINSTANCE.createComponentHierarchyUpdateResultDTO();
        IChangeSetHandle affectedChangeSets = updateSubcomponentData.getAffectedChangeSet();
        if (affectedChangeSets != null) {
            result.setAffectedChangeSetItemId(affectedChangeSets.getItemId().getUuidValue());
        }
        for (IComponentHandle componentHandle : updateSubcomponentData.getUpdatedChildren()) {
            result.getUpdatedChildrenItemIds().add(componentHandle.getItemId().getUuidValue());
        }
        return result;
    }

    private static List<IComponentHandle> uuidStringsToComponentHandles(ITeamRepository teamRepository, String[] uuidStrings) {
        ArrayList<IComponentHandle> componentHandles = new ArrayList<IComponentHandle>();
        if (uuidStrings != null) {
            String[] stringArray = uuidStrings;
            int n = uuidStrings.length;
            int n2 = 0;
            while (n2 < n) {
                String uuidString = stringArray[n2];
                UUID uuid = UUID.valueOf((String)uuidString);
                IComponentHandle componentHandle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((Object)teamRepository, uuid, null);
                componentHandles.add(componentHandle);
                ++n2;
            }
        }
        return componentHandles;
    }

    public static void putComponent(ParmsPutComponent parms, IProgressMonitor progress) throws TeamRepositoryException {
        IAuditableHandle newOwner;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)3);
        ITeamRepository repo = CommonUtil.getTeamRepository(parms.repositoryUrl);
        IComponentHandle componentHandle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)parms.componentItemId), null);
        IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        if (RestUtils.isSet((String)parms.name)) {
            wm.renameComponent(componentHandle, parms.name, (IProgressMonitor)monitor.newChild(1));
        }
        IReadScope newViz = parms.readScope != null ? WorkspaceUtil.createVisibility(parms.readScope) : IScmService.DEFAULT_VISIBILITY;
        if (RestUtils.isSet((String)parms.newOwnerItemId)) {
            if (parms.newOwnerItemType.equals(IContributor.ITEM_TYPE.getName())) {
                newOwner = (IContributorHandle)IContributor.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)parms.newOwnerItemId), null);
            } else {
                ItemType itemType = ItemUtil.itemTypeFor((String)parms.newOwnerItemType, (String)ProcessPackage.eINSTANCE.getNsURI());
                newOwner = (IProcessAreaHandle)itemType.createItemHandle((Object)repo, UUID.valueOf((String)parms.newOwnerItemId), null);
            }
        } else {
            newOwner = IScmService.NOOP_OWNER;
        }
        if (newViz != IScmService.DEFAULT_VISIBILITY || newOwner != IScmService.NOOP_OWNER) {
            wm.setComponentOwnerAndVisibility(componentHandle, newOwner, newViz, (IProgressMonitor)monitor.newChild(1));
        }
    }

    public static IReadScope createVisibility(ParmsReadScope readScope) {
        if ("contributor_deferring_scope".equals(readScope.scope)) {
            IContributorDeferringScope scope = IReadScope.FACTORY.createContributorDeferringScope();
            scope.setScope((IAuditableHandle)((IProjectAreaHandle)IProjectArea.ITEM_TYPE.createItemHandle(UUID.valueOf((String)readScope.defer_to), null)));
            return scope;
        }
        if ("private_scope".equals(readScope.scope)) {
            return IReadScope.FACTORY.createPrivateScope();
        }
        if ("process_area_scope".equals(readScope.scope)) {
            return IReadScope.FACTORY.createProcessAreaScope();
        }
        if ("public_scope".equals(readScope.scope)) {
            return IReadScope.FACTORY.createPublicScope();
        }
        if ("team_area_private_scope".equals(readScope.scope)) {
            return IReadScope.FACTORY.createTeamAreaPrivateScope();
        }
        if ("access_group_scope".equals(readScope.scope)) {
            AccessGroupScope scope = (AccessGroupScope)IReadScope.FACTORY.createAccessGroupScope();
            scope.setAccessGroupId(UUID.valueOf((String)readScope.defer_to));
            return scope;
        }
        if ("archived_scope".equals(readScope.scope)) {
            return IReadScope.FACTORY.createArchivedScope();
        }
        throw new IllegalArgumentException("Bad scope: " + readScope);
    }

    public static WorkspaceDetailsDTO postWorkspaceFromHistoryReference(ParmsPostWorkspaceFromHistoryReference parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        ITeamRepository repo = CommonUtil.getTeamRepository(parms.repositoryUrl);
        IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        IContributorHandle owner = RepositoryUtils.getLoggedInContributor(repo);
        IHistoryReference seed = WorkspaceUtil.createHistoryReference(parms.seed);
        IWorkspaceConnection created = wm.createWorkspace(owner, parms.name, parms.description, seed, (IProgressMonitor)monitor.newChild(90));
        return CoreUtil.translateWorkspace(created, true, false, true, true, true, (IProgressMonitor)monitor.newChild(10));
    }

    public static IHistoryReference createHistoryReference(ParmsHistoryReference parms) {
        if (parms == null) {
            throw new IllegalArgumentException("History reference cannot be null");
        }
        ITeamRepository repository = null;
        try {
            repository = CommonUtil.getTeamRepository(parms.repositoryUrl);
        }
        catch (TeamRepositoryException e) {
            throw new IllegalArgumentException(e);
        }
        if (parms.snapshotId != null) {
            return CommonUtil.createBaselineSetHandle(repository, parms.snapshotId);
        }
        if (parms.workspaceId != null && parms.componentId != null && parms.state != -1L) {
            WorkspaceComponentState wcs = ScmDto2Factory.eINSTANCE.createWorkspaceComponentState();
            wcs.setWorkspace(CommonUtil.createWorkspaceHandle(repository, parms.workspaceId));
            wcs.setComponent(CommonUtil.createComponentHandle(repository, parms.componentId));
            wcs.setState(parms.state);
            return wcs;
        }
        if (parms.workspaceId != null) {
            return CommonUtil.createWorkspaceHandle(repository, parms.workspaceId);
        }
        throw new IllegalArgumentException("Invalid ParmsHistoryReference object.");
    }

    public static WorkspaceDetailsDTO postWorkspace(ParmsPostWorkspace parms, IProgressMonitor progress) throws TeamRepositoryException {
        IWorkspaceConnection created;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        ITeamRepository repo = CommonUtil.getTeamRepository(parms.repositoryUrl);
        IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        IWorkspaceConnection seedConnection = null;
        if (parms.seed != null) {
            seedConnection = parms.seed.getWorkspaceConnection((IProgressMonitor)monitor.newChild(5));
        }
        ArrayList<IFlowNodeConnection.IComponentAdditionOp> ops = new ArrayList<IFlowNodeConnection.IComponentAdditionOp>();
        if (seedConnection != null) {
            IFetchResult result;
            seedConnection.refresh((IProgressMonitor)monitor.newChild(5));
            List visibleComponentsInSeed = seedConnection.getComponents();
            final HashSet<UUID> componentsInWorkspace = new HashSet<UUID>();
            for (IComponentHandle workspaceComponent : visibleComponentsInSeed) {
                componentsInWorkspace.add(workspaceComponent.getItemId());
            }
            IComponentHierarchyResult incomingHierarchy = seedConnection.getComponentHierarchy(null);
            final ArrayList componentsNotInSeedWorkspace = new ArrayList();
            SubcomponentCommonUtils.visitHierarchy((IHierarchyResult)incomingHierarchy, (SubcomponentCommonUtils.IHierarchyVisitor)new SubcomponentCommonUtils.IHierarchyVisitor(){

                public boolean visit(IHierarchyNode node) {
                    IComponentHandle componentHandle = node.getComponentHandle();
                    UUID id = componentHandle.getItemId();
                    if (!componentsInWorkspace.contains(id)) {
                        componentsNotInSeedWorkspace.add(componentHandle);
                    }
                    return true;
                }
            });
            if (!componentsNotInSeedWorkspace.isEmpty() && (result = seedConnection.teamRepository().itemManager().fetchCompleteItemsPermissionAware(componentsNotInSeedWorkspace, 1, (IProgressMonitor)monitor.newChild(50))).hasMissingItems()) {
                HashSet<UUID> unreadableComponents = new HashSet<UUID>();
                for (IComponentHandle handle : seedConnection.getUnreadableComponents()) {
                    unreadableComponents.add(handle.getItemId());
                }
                for (Object o : result.getMissingItems()) {
                    IComponentHandle componentHandle;
                    if (!(o instanceof IComponentHandle) || !unreadableComponents.contains((componentHandle = (IComponentHandle)o).getItemId())) continue;
                    String uuid = componentHandle.getItemId().getUuidValue();
                    if (parms.isStream.booleanValue()) {
                        throw new TeamRepositoryException(NLS.bind((String)Messages.InaccessibleSubcomponentForStream, (Object)uuid));
                    }
                    throw new TeamRepositoryException(NLS.bind((String)Messages.InaccessibleSubcomponentForWorkspace, (Object)uuid));
                }
            }
            for (IComponentHandle component : visibleComponentsInSeed) {
                ops.add(seedConnection.componentOpFactory().addComponent(component, (IConnection)seedConnection, false));
            }
        }
        if (parms.isStream.booleanValue()) {
            ItemType itemType = ItemUtil.itemTypeFor((String)parms.processAreaType, (String)ProcessPackage.eINSTANCE.getNsURI());
            IProcessAreaHandle processAreaHandle = (IProcessAreaHandle)itemType.createItemHandle((Object)repo, UUID.valueOf((String)parms.processAreaId), null);
            created = wm.createStream(processAreaHandle, parms.name, parms.description, (IProgressMonitor)monitor.newChild(10));
        } else {
            IContributorHandle owner = RepositoryUtils.getLoggedInContributor(repo);
            created = wm.createWorkspace(owner, parms.name, parms.description, seedConnection, null, (IProgressMonitor)monitor.newChild(10));
        }
        created.applyComponentOperations(ops, (IProgressMonitor)monitor.newChild(29));
        if (parms.readScope != null) {
            IReadScope scope = WorkspaceUtil.createVisibility(parms.readScope);
            monitor.setWorkRemaining(10);
            created.setOwnerAndVisibility(IScmService.NOOP_OWNER, scope, (IProgressMonitor)monitor.newChild(10));
        }
        if (parms.autoFileLockPatterns != null) {
            monitor.setWorkRemaining(10);
            created.setExclusiveFileLockPatterns(parms.autoFileLockPatterns, (IProgressMonitor)monitor.newChild(10));
        }
        return CoreUtil.translateWorkspace(created, true, false, true, true, true, (IProgressMonitor)monitor.newChild(1));
    }

    private static void applyComponentChanges(IWorkspaceConnection connection, ParmsConfigurationChanges parms, PutWorkspaceResultDTO result, IProgressMonitor monitor) throws TeamRepositoryException {
        ComponentDTO compDto;
        Collection children;
        if (parms == null) {
            return;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(100 + 10 * parms.components.length));
        ParmsWorkspaceUpdateDilemmaHandler workspaceUpdateDilemmaHandler = null;
        if (parms.workspaceUpdateDilemmaHandler != null) {
            workspaceUpdateDilemmaHandler = parms.workspaceUpdateDilemmaHandler;
        } else {
            workspaceUpdateDilemmaHandler = new ParmsWorkspaceUpdateDilemmaHandler();
            workspaceUpdateDilemmaHandler.componentFlowDirection = "continue";
            workspaceUpdateDilemmaHandler.disconnectedComponentsDirection = "continue";
            workspaceUpdateDilemmaHandler.noBackupBaselineDirection = "continue";
            workspaceUpdateDilemmaHandler.multipleParticipantsDirection = "continue";
            workspaceUpdateDilemmaHandler.componentInMultipleHierarchiesDirection = "continue";
            workspaceUpdateDilemmaHandler.inaccessibleComponentsNotInSeedDirection = "continue";
            workspaceUpdateDilemmaHandler.validate(putWorkspaceRequest, "workspaceUpdateDilemmaHandler");
        }
        ParmsPendingChangesDilemmaHandler pendingChangesDilemmaHandler = null;
        if (parms.pendingChangesDilemmaHandler != null) {
            pendingChangesDilemmaHandler = parms.pendingChangesDilemmaHandler;
        } else {
            pendingChangesDilemmaHandler = new ParmsPendingChangesDilemmaHandler();
            pendingChangesDilemmaHandler.pendingChangesInstruction = "continue";
            pendingChangesDilemmaHandler.pendingChangesInSubcomponentsInstruction = "continue";
            pendingChangesDilemmaHandler.validate(putWorkspaceRequest, "pendingChangesDilemmaHandler");
        }
        WorkspaceUpdateDilemmaHandler dilemmaHandler = WorkspaceUpdateUtil.getWorkspaceUpdateDilemmaHandler(workspaceUpdateDilemmaHandler, pendingChangesDilemmaHandler, result.getConfigurationsWithUncheckedInChanges(), result.getCommitDilemma(), parms.outOfSyncInstructions, result.getOutOfSyncShares(), parms.sandboxUpdateDilemmaHandler, result.getSandboxUpdateDilemma(), parms.updateDilemmaHandler, result.getUpdateDilemma(), null, null, null, null, null, null, null, null, null, null, null, false, null, null, result.getSelectedComponentsWithMultipleParticipants(), result.getSubcomponentsWithMultipleParticipants(), result.getNoBackupBaselinesComponents(), result.getInaccessibleComponentsNotInSeed(), false, null, (IProgressMonitor)progress.newChild(5));
        IWorkspaceUpdateOperation workspaceUpdateOperation = IOperationFactory.instance.getWorkspaceUpdateOperation(dilemmaHandler);
        RefreshUtil.configureRefresh(parms.preoperationRefresh, workspaceUpdateOperation);
        ITeamRepository repo = connection.teamRepository();
        HashSet<UUID> componentsToRemove = new HashSet<UUID>();
        boolean hierarchicalOperation = parms.hierarchicalOperation && ComponentHierarchyManager.getInstance().isHierarchicalComponentsEnabled(repo);
        ParmsComponentChange[] parmsComponentChangeArray = parms.components;
        int n = parms.components.length;
        int n2 = 0;
        while (n2 < n) {
            IComponentHandle component;
            IComponentHandle component2;
            IConnection seedConnection;
            ParmsComponentChange command = parmsComponentChangeArray[n2];
            if (command.cmd.equals("addComponent")) {
                if (command.componentItemId == null) {
                    workspaceUpdateOperation.addComponent(connection, command.name);
                } else if (command.seed != null) {
                    seedConnection = WorkspaceUtil.getSeedConnection(command.componentItemId, command.seed, (IProgressMonitor)progress.newChild(5));
                    component2 = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((Object)seedConnection.teamRepository(), UUID.valueOf((String)command.componentItemId), null);
                    WorkspaceUtil.replaceComponent(workspaceUpdateOperation, hierarchicalOperation, connection, seedConnection, component2, true, progress.newChild(5));
                } else {
                    component = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)command.componentItemId), null);
                    workspaceUpdateOperation.addComponent(connection, repo, component);
                }
            } else if (command.cmd.equals("removeComponent")) {
                IComponentHierarchyResult componentHierarchy;
                component = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)command.componentItemId), null);
                if (!hierarchicalOperation && (children = (Collection)(componentHierarchy = connection.getComponentHierarchy(Collections.singletonList(component))).getParentToChildrenMap().get(component.getItemId())) != null && !children.isEmpty()) {
                    throw new TeamRepositoryException((Throwable)new IllegalStateException(Messages.RemoveComponentsInHierarchy));
                }
                componentsToRemove.add(component.getItemId());
                workspaceUpdateOperation.removeComponent(connection, component);
            } else if (command.cmd.equals("replaceComponent")) {
                seedConnection = WorkspaceUtil.getSeedConnection(command.componentItemId, command.seed, (IProgressMonitor)progress.newChild(5));
                component2 = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((Object)seedConnection.teamRepository(), UUID.valueOf((String)command.componentItemId), null);
                WorkspaceUtil.replaceComponent(workspaceUpdateOperation, hierarchicalOperation, connection, seedConnection, component2, false, progress.newChild(5));
            }
            ++n2;
        }
        progress.setWorkRemaining(80);
        if (!componentsToRemove.isEmpty()) {
            IComponentHierarchyResult componentHierarchy = connection.getComponentHierarchy(null);
            Map parentStructure = componentHierarchy.getChildToParentsMap();
            HashSet allUnremovedParents = new HashSet();
            for (UUID componentId : componentsToRemove) {
                Collection parents = (Collection)parentStructure.get(componentId);
                if (parents == null) continue;
                Set ids = parents.stream().map(IItemHandle::getItemId).collect(Collectors.toSet());
                allUnremovedParents.addAll(ids);
            }
            allUnremovedParents.removeAll(componentsToRemove);
            if (!allUnremovedParents.isEmpty()) {
                UUID exampleParentId = (UUID)allUnremovedParents.iterator().next();
                IComponentHandle exampleParent = WorkspaceUtil.findComponentHandle(exampleParentId, parentStructure);
                IComponentHandle exampleChild = null;
                children = (Collection)componentHierarchy.getParentToChildrenMap().get(exampleParentId);
                if (children != null) {
                    for (IComponentHandle child : children) {
                        if (!componentsToRemove.contains(child.getItemId())) continue;
                        exampleChild = child;
                        break;
                    }
                }
                List<IComponentHandle> componentHandles = Arrays.asList(exampleChild, exampleParent);
                List components = connection.teamRepository().itemManager().fetchCompleteItems(componentHandles, 0, (IProgressMonitor)progress.newChild(10));
                String name = components.get(0) == null ? null : ((IComponent)components.get(0)).getName();
                String parentName = components.get(1) == null ? null : ((IComponent)components.get(1)).getName();
                String message = NLS.bind((String)Messages.WorkspaceUtil_RemoveSubcomponentNotAllowed, (Object)name, (Object)parentName);
                throw new TeamRepositoryException((Throwable)new IOException(message));
            }
            componentsToRemove = null;
        }
        progress.setWorkRemaining(70);
        workspaceUpdateOperation.run((IProgressMonitor)progress.newChild(60));
        for (ConfigurationFacade descriptor : workspaceUpdateOperation.getComponentsAdded()) {
            result.getComponentsAdded().add(CoreUtil.translateConfigurationDescriptor(descriptor));
        }
        Collection<ConfigurationFacade> componentsRemoved = workspaceUpdateOperation.getComponentsRemoved();
        ArrayList<IComponentHandle> componentHandles = new ArrayList<IComponentHandle>(componentsRemoved.size());
        for (ConfigurationFacade facade : componentsRemoved) {
            componentHandles.add(facade.getComponentHandle());
        }
        List components = connection.teamRepository().itemManager().fetchCompleteItems(componentHandles, 0, (IProgressMonitor)progress.newChild(10));
        for (IComponent comp : components) {
            compDto = FilesystemRestClientDTOcoreFactory.eINSTANCE.createComponentDTO();
            compDto.setName(comp.getName());
            compDto.setItemId(comp.getItemId().getUuidValue());
            result.getComponentsRemoved().add(compDto);
        }
        for (IComponent comp : workspaceUpdateOperation.getComponentsCreated()) {
            compDto = FilesystemRestClientDTOcoreFactory.eINSTANCE.createComponentDTO();
            compDto.setName(comp.getName());
            compDto.setItemId(comp.getItemId().getUuidValue());
            result.getComponentsCreated().add(compDto);
        }
    }

    private static IComponentHandle findComponentHandle(UUID id, Map<UUID, Collection<IComponentHandle>> parentStructure) {
        for (Collection<IComponentHandle> handles : parentStructure.values()) {
            for (IComponentHandle h : handles) {
                if (!h.getItemId().equals((Object)id)) continue;
                return h;
            }
        }
        return null;
    }

    private static void replaceComponent(IWorkspaceUpdateOperation workspaceUpdateOperation, boolean hierarchicalReplace, IWorkspaceConnection connection, IConnection seedConnection, IComponentHandle component, boolean fromAdd, SubMonitor monitor) throws TeamRepositoryException {
        if (hierarchicalReplace) {
            if (seedConnection instanceof IBaselineConnection) {
                workspaceUpdateOperation.replaceFromHierarchicalBaseline(connection, (IBaselineConnection)seedConnection);
            } else if (fromAdd) {
                workspaceUpdateOperation.add(connection, (IWorkspaceConnection)seedConnection, Collections.singletonList(component), true);
            } else {
                workspaceUpdateOperation.replace(connection, (IWorkspaceConnection)seedConnection, Collections.singletonList(component), true);
            }
        } else if (seedConnection instanceof IBaselineConnection) {
            IBaselineHierarchyResult baselineHierarchy;
            Collection subComponents;
            IBaselineConnection baselineConnection = (IBaselineConnection)seedConnection;
            if (fromAdd && (subComponents = (Collection)(baselineHierarchy = baselineConnection.getBaselineHierarchy((IProgressMonitor)monitor)).getParentToChildrenMap().get(baselineConnection.getBaseline().getItemId())) != null && !subComponents.isEmpty()) {
                throw new TeamRepositoryException((Throwable)new IllegalStateException(Messages.AddComponentsInHierarchy));
            }
            workspaceUpdateOperation.replace(connection, baselineConnection);
        } else {
            IComponentHierarchyResult componentHierarchy;
            Collection children;
            IWorkspaceConnection workspaceConnection = (IWorkspaceConnection)seedConnection;
            if (fromAdd && (children = (Collection)(componentHierarchy = workspaceConnection.getComponentHierarchy(Collections.singletonList(component))).getParentToChildrenMap().get(component.getItemId())) != null && !children.isEmpty()) {
                throw new TeamRepositoryException((Throwable)new IllegalStateException(Messages.AddComponentsInHierarchy));
            }
            workspaceUpdateOperation.replace(connection, workspaceConnection, Collections.singletonList(component), false);
        }
    }

    private static IConnection getSeedConnection(String componentItemId, ParmsComponentSeed seed, IProgressMonitor progress) throws TeamRepositoryException {
        if (seed != null) {
            UUID componentId = UUID.valueOf((String)componentItemId);
            ITeamRepository repo = CommonUtil.getTeamRepository(seed.repositoryUrl);
            if (seed.itemTypeId.equalsIgnoreCase("workspace")) {
                IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)seed.itemId), null);
                IWorkspaceConnection workspaceConnection = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection(workspaceHandle, progress);
                for (IComponentHandle component : workspaceConnection.getComponents()) {
                    if (!component.getItemId().equals((Object)componentId)) continue;
                    return workspaceConnection;
                }
                throw new TeamRepositoryException(NLS.bind((String)Messages.FilesystemRestClient_3, (Object)workspaceConnection.getName()));
            }
            if (seed.itemTypeId.equalsIgnoreCase("baseline")) {
                IBaselineHandle bh = (IBaselineHandle)IBaseline.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)seed.itemId), null);
                IBaselineConnection baselineConnection = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getBaselineConnection(bh, progress);
                if (baselineConnection.getComponent().getItemId().equals((Object)componentId)) {
                    return baselineConnection;
                }
                throw new TeamRepositoryException(NLS.bind((String)Messages.FilesystemRestClient_2, (Object)baselineConnection.getName()));
            }
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
            IBaselineSetHandle sh = (IBaselineSetHandle)IBaselineSet.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)seed.itemId), null);
            IBaselineSet snapShot = (IBaselineSet)repo.itemManager().fetchCompleteItem((IItemHandle)sh, 0, (IProgressMonitor)monitor.newChild(25));
            List baselines = repo.itemManager().fetchCompleteItems(snapShot.getBaselines(), 0, (IProgressMonitor)monitor.newChild(25));
            for (IBaseline baseline : baselines) {
                if (!baseline.getComponent().getItemId().equals((Object)componentId)) continue;
                return SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getBaselineConnection(baseline, (IProgressMonitor)monitor.newChild(50));
            }
            throw new TeamRepositoryException(NLS.bind((String)Messages.FilesystemRestClient_1, (Object)snapShot.getName()));
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static GetWorkspaceDetailsResultDTO getWorkspaceDetails(ParmsGetWorkspaceDetails parms, IProgressMonitor progress) {
        monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(100 * parms.workspaces.length * 4));
        result = FilesystemRestClientDTOworkspaceFactory.eINSTANCE.createGetWorkspaceDetailsResultDTO();
        toFetch = new HashMap<ITeamRepository, ArrayList<IWorkspaceHandle>>();
        var8_5 = parms.workspaces;
        var7_6 = parms.workspaces.length;
        var6_8 = 0;
        while (var6_8 < var7_6) {
            request = var8_5[var6_8];
            try {
                if (!(request.includeComponents.booleanValue() || request.includeComponentHierarchy.booleanValue() || request.includeFlowTargets.booleanValue() || request.refresh.booleanValue() || request.includeSandboxSubfolder.booleanValue())) {
                    repo = CommonUtil.getTeamRepository(request.workspace.repositoryUrl);
                    workspacesToFetch = (ArrayList<IWorkspaceHandle>)toFetch.get(repo);
                    if (workspacesToFetch == null) {
                        workspacesToFetch = new ArrayList<IWorkspaceHandle>();
                        toFetch.put(repo, workspacesToFetch);
                    }
                    workspacesToFetch.add(request.workspace.getWorkspaceHandle());
                } else {
                    connection = request.workspace.getWorkspaceConnection((IProgressMonitor)monitor.newChild(1));
                    if (request.refresh.booleanValue()) {
                        connection.refresh((IProgressMonitor)monitor.newChild(1));
                    }
                    details = CoreUtil.translateWorkspace(connection, request.includeComponents, request.includeComponentHierarchy, request.includeFlowTargets, request.includeComponentOwner, request.includeComponentReadScope, request.includeSandboxSubfolder, request.refresh, (IProgressMonitor)monitor.newChild(2));
                    result.getWorkspaceDetails().add(details);
                }
            }
            catch (TeamRepositoryException e) {
                error = FilesystemRestClientDTOworkspaceFactory.eINSTANCE.createGetWorkspaceDetailsErrorDTO();
                error.setMessage(e.getMessage());
                repo = null;
                try {
                    repo = CommonUtil.getTeamRepository(request.workspace.repositoryUrl);
                }
                catch (TeamRepositoryException var12_16) {
                    // empty catch block
                }
                if (repo != null) {
                    error.setRepositoryId(CoreUtil.translateRepositoryId(repo));
                }
                error.setRepositoryUrl(request.workspace.repositoryUrl);
                error.setWorkspaceId(request.workspace.workspaceItemId);
                result.getErrors().add(error);
            }
            ++var6_8;
        }
        if (!toFetch.isEmpty()) {
            block7: for (Map.Entry<K, V> workspacesToFetchEntry : toFetch.entrySet()) {
                repository = (ITeamRepository)workspacesToFetchEntry.getKey();
                repoUrl = repository.getRepositoryURI();
                repoId = CoreUtil.translateRepositoryId(repository);
                try {
                    fetched = repository.itemManager().fetchCompleteItemsPermissionAware((List)workspacesToFetchEntry.getValue(), 0, (IProgressMonitor)monitor.newChild(3 * ((List)workspacesToFetchEntry.getValue()).size()));
                    for (IWorkspace workspace : fetched.getRetrievedItems()) {
                        details = CoreUtil.translateWorkspace((ITeamRepository)workspacesToFetchEntry.getKey(), workspace, monitor.newChild(1));
                        result.getWorkspaceDetails().add(details);
                    }
                    for (IItemHandle item : fetched.getNotFoundItems()) {
                        error = FilesystemRestClientDTOworkspaceFactory.eINSTANCE.createGetWorkspaceDetailsErrorDTO();
                        error.setMessage(Messages.WorkspaceUtil_0);
                        error.setRepositoryId(repoId);
                        error.setRepositoryUrl(repoUrl);
                        error.setWorkspaceId(item.getItemId().getUuidValue());
                        result.getErrors().add(error);
                    }
                    for (IItemHandle item : fetched.getPermissionDeniedItems()) {
                        error = FilesystemRestClientDTOworkspaceFactory.eINSTANCE.createGetWorkspaceDetailsErrorDTO();
                        error.setMessage(Messages.WorkspaceUtil_1);
                        error.setRepositoryId(repoId);
                        error.setRepositoryUrl(repoUrl);
                        error.setWorkspaceId(item.getItemId().getUuidValue());
                        result.getErrors().add(error);
                    }
                    continue;
                }
                catch (TeamRepositoryException e) {
                    ** for (workspaceHandle : (List)workspacesToFetchEntry.getValue())
                }
lbl-1000:
                // 1 sources

                {
                    error = FilesystemRestClientDTOworkspaceFactory.eINSTANCE.createGetWorkspaceDetailsErrorDTO();
                    error.setMessage(e.getMessage());
                    error.setRepositoryId(repoId);
                    error.setRepositoryUrl(repoUrl);
                    error.setWorkspaceId(workspaceHandle.getItemId().getUuidValue());
                    result.getErrors().add(error);
                    continue;
lbl85:
                    // 1 sources

                }
            }
        }
        return result;
    }

    public static void setVersionablePermissions(IVersionableHandle[] versionables, IComponentHandle componentHandle, ParmsComponentSeed seed, IPermissionContextProvider contextProvider, SubMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IConnection connection = WorkspaceUtil.getSeedConnection(componentHandle.getItemId().getUuidValue(), seed, (IProgressMonitor)monitor.newChild(1));
        connection.setVersionablePermissions(versionables, componentHandle, contextProvider, (IProgressMonitor)monitor.newChild(99));
    }

    public static void putWorkspaceCustomAttributes(ParmsWorkspaceCustomAttributes parms, ISyncViewProxy syncViewProxy, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IWorkspaceConnection wc = parms.workspace.getWorkspaceConnection((IProgressMonitor)monitor.newChild(10));
        HashMap<String, String> setCustomAttrs = new HashMap<String, String>(parms.setCustomAttrs.length);
        ParmsProperty[] parmsPropertyArray = parms.setCustomAttrs;
        int n = parms.setCustomAttrs.length;
        int n2 = 0;
        while (n2 < n) {
            ParmsProperty key = parmsPropertyArray[n2];
            setCustomAttrs.put(key.propertyName, key.propertyValue);
            ++n2;
        }
        String[] unsetCustomAttributes = parms.unsetCustomAttrs;
        wc.setCustomAttributes(setCustomAttrs, unsetCustomAttributes, (IProgressMonitor)monitor.newChild(5));
    }

    public static WorkspaceCustomAttributesDTO getWorkspaceCustomAttributes(ParmsWorkspace parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        WorkspaceCustomAttributesDTO customAttrs = FilesystemRestClientDTOworkspaceFactory.eINSTANCE.createWorkspaceCustomAttributesDTO();
        IWorkspaceConnection connection = parms.getWorkspaceConnection((IProgressMonitor)monitor.newChild(10));
        WorkspaceDetailsDTO wsDetails = CoreUtil.translateWorkspace(connection, false, false, false, false, false, (IProgressMonitor)monitor.newChild(90));
        customAttrs.setWorkspace(wsDetails);
        IWorkspace workspace = connection.getResolvedWorkspace();
        customAttrs.getCustomAttributes().putAll(workspace.getCustomAttributes());
        return customAttrs;
    }

    public static void putComponentCustomAttributes(ParmsComponentCustomAttributes parms, ISyncViewProxy syncViewProxy, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)3);
        ITeamRepository repo = CommonUtil.getTeamRepository(parms.repositoryUrl);
        IComponentHandle componentHandle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)parms.componentUuid), null);
        IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        HashMap<String, String> setCustomAttrs = new HashMap<String, String>(parms.setCustomAttrs.length);
        ParmsProperty[] parmsPropertyArray = parms.setCustomAttrs;
        int n = parms.setCustomAttrs.length;
        int n2 = 0;
        while (n2 < n) {
            ParmsProperty key = parmsPropertyArray[n2];
            setCustomAttrs.put(key.propertyName, key.propertyValue);
            ++n2;
        }
        String[] unsetCustomAttributes = parms.unsetCustomAttrs;
        wm.setComponentCustomAttributes(componentHandle, setCustomAttrs, unsetCustomAttributes, (IProgressMonitor)monitor.newChild(5));
    }

    public static ComponentCustomAttributesDTO getComponentCustomAttributes(ParmsComponentCustomAttributes parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)3);
        ComponentCustomAttributesDTO customAttrs = FilesystemRestClientDTOworkspaceFactory.eINSTANCE.createComponentCustomAttributesDTO();
        ITeamRepository repo = CommonUtil.getTeamRepository(parms.repositoryUrl);
        UUID componentUuid = UUID.valueOf((String)parms.componentUuid);
        IComponentHandle componentHandle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((Object)repo, componentUuid, null);
        IComponent component = (IComponent)repo.itemManager().fetchCompleteItem((IItemHandle)componentHandle, 0, (IProgressMonitor)monitor.newChild(25));
        Map componentAttrs = component.getCustomAttributes();
        customAttrs.getCustomAttributes().putAll(componentAttrs);
        return customAttrs;
    }

    public static void putWorkspaceSandboxSubfolder(ParmsWorkspaceSandboxSubfolder parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IWorkspaceConnection connection = parms.workspace.getWorkspaceConnection((IProgressMonitor)monitor.newChild(50));
        connection.setParentFolder(parms.subfolder, (IProgressMonitor)monitor.newChild(50));
    }

    public static void putChangeSetCustomAttributes(ParmsChangeSetCustomAttributes parms, IProgressMonitor progress) throws TeamRepositoryException {
        ITeamRepository repo = CommonUtil.getTeamRepository(parms.repositoryUrl);
        IChangeSetHandle changeSetHandle = (IChangeSetHandle)IChangeSet.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)parms.chnageSetUUID), null);
        IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        HashMap<String, String> setCustomAttrs = new HashMap<String, String>(parms.setCustomAttrs.length);
        ParmsProperty[] parmsPropertyArray = parms.setCustomAttrs;
        int n = parms.setCustomAttrs.length;
        int n2 = 0;
        while (n2 < n) {
            ParmsProperty key = parmsPropertyArray[n2];
            setCustomAttrs.put(key.propertyName, key.propertyValue);
            ++n2;
        }
        String[] unsetCustomAttributes = parms.unsetCustomAttrs;
        wm.setChangeSetCustomAttributes(changeSetHandle, setCustomAttrs, unsetCustomAttributes, progress);
    }

    public static ChangeSetCustomAttributesDTO getChangeSetCustomAttributes(ParmsChangeSetCustomAttributes parms, IProgressMonitor progress) throws TeamRepositoryException {
        ChangeSetCustomAttributesDTO customAttrs = FilesystemRestClientDTOworkspaceFactory.eINSTANCE.createChangeSetCustomAttributesDTO();
        ITeamRepository repo = CommonUtil.getTeamRepository(parms.repositoryUrl);
        IChangeSetHandle changeSetHandle = (IChangeSetHandle)IChangeSet.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)parms.chnageSetUUID), null);
        IChangeSet changeset = (IChangeSet)repo.itemManager().fetchCompleteItem((IItemHandle)changeSetHandle, 0, progress);
        Map componentAttrs = changeset.getCustomAttributes();
        customAttrs.getCustomAttributes().putAll(componentAttrs);
        return customAttrs;
    }
}

