/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.rest.util;

import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.IFileContentMerger;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.componenthierarchy.ComponentHierarchyManager;
import com.ibm.team.filesystem.client.internal.operations.WorkspaceUpdateOperation;
import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.internal.rest.util.CommitUtil;
import com.ibm.team.filesystem.client.internal.rest.util.ConflictResolutionUtil;
import com.ibm.team.filesystem.client.internal.rest.util.CoreUtil;
import com.ibm.team.filesystem.client.internal.rest.util.ISyncViewProxy;
import com.ibm.team.filesystem.client.internal.rest.util.PortsDTOUtil;
import com.ibm.team.filesystem.client.internal.rest.util.RefreshUtil;
import com.ibm.team.filesystem.client.internal.rest.util.SandboxUpdateDilemmaUtil;
import com.ibm.team.filesystem.client.internal.rest.util.UpdateDilemmaUtil;
import com.ibm.team.filesystem.client.internal.rest.util.VerifyOutOfSyncUtil;
import com.ibm.team.filesystem.client.internal.rest.util.WorkspaceUtil;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.operations.ApplyAcceptedDilemmaHandler;
import com.ibm.team.filesystem.client.operations.AutoResolveConflictsDilemmaHandler;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICheckinOptions;
import com.ibm.team.filesystem.client.operations.IWorkspaceRollbackOperation;
import com.ibm.team.filesystem.client.operations.IWorkspaceUpdateOperation;
import com.ibm.team.filesystem.client.operations.IWorkspaceUpdateReport;
import com.ibm.team.filesystem.client.operations.MarkAsMergedDilemmaHandler;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.operations.WorkspaceUpdateDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsAcceptChangeSets;
import com.ibm.team.filesystem.client.rest.parameters.ParmsChangeSet;
import com.ibm.team.filesystem.client.rest.parameters.ParmsHistoryReference;
import com.ibm.team.filesystem.client.rest.parameters.ParmsMissingStorageMergerDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsOutOfSyncInstructions;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPendingChangesDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSandboxUpdateDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsUpdateDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceAccept;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceAcceptDetailed;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceComponentReplaceWithBaseline;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceReplaceWithHistory;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceReplaceWithSnapshot;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceReplaceWithWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceUpdate;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceUpdateDilemmaHandler;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.FilesystemRestClientDTOchangesetFactory;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.GapChangeSetsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.ProblemChangeSetsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.StaleDataDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.StructuredBaselineUpdateReportDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.StructuredComponentUpdateReportDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.StructuredUpdateReportDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.WorkspaceUpdateResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ConfigurationDescriptorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ConfigurationWithUncheckedInChangesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.FilesystemRestClientDTOcoreFactory;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareDTO;
import com.ibm.team.filesystem.common.internal.rest.client.dilemma.CommitDilemmaDTO;
import com.ibm.team.filesystem.common.internal.rest.client.dilemma.SandboxUpdateDilemmaDTO;
import com.ibm.team.filesystem.common.internal.rest.client.dilemma.UpdateDilemmaDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ComponentSyncDTO;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IComponentHierarchyResult;
import com.ibm.team.scm.common.ICurrentPatch;
import com.ibm.team.scm.common.IHistoryReference;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.dto.IItemConflictReport;
import com.ibm.team.scm.common.dto.IStreamLockReport;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class WorkspaceUpdateUtil {
    private static final String request = "WorkspaceUpdate";

    public static WorkspaceUpdateResultDTO workspaceUpdate(ParmsWorkspaceUpdate parms, ISyncViewProxy syncViewProxy, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        parms.validate(request, new Object[0]);
        WorkspaceUpdateResultDTO result = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createWorkspaceUpdateResultDTO();
        WorkspaceUpdateDilemmaHandler dilemmaHandler = WorkspaceUpdateUtil.getWorkspaceUpdateDilemmaHandler(parms.workspaceUpdateDilemmaHandler, parms.pendingChangesDilemmaHandler, result.getConfigurationsWithUncheckedInChanges(), result.getCommitDilemma(), parms.outOfSyncInstructions, result.getOutOfSyncShares(), parms.sandboxUpdateDilemmaHandler, result.getSandboxUpdateDilemma(), parms.updateDilemmaHandler, result.getUpdateDilemma(), result.getComponentFlowAdditions(), result.getComponentFlowDeletions(), result.getComponentReplacementCandidates(), result.getDisconnectedComponents(), result.getActiveChangeSets(), result.getActiveChangeSetsOverlap(), result.getActiveChangeSetsInComponent(), result.getGap(), result.getComponentsWithNWayConflicts(), result.getStaleData(), result.getChangeSetsBlockedByPortInProgress(), parms.autoAcquireLocks, result.getLocksWereHeld(), result.getLocksToAcquire(), result.getSelectedComponentsInMultipleHierarchies(), result.getSubcomponentsInMultipleHierarchies(), result.getNoBackupBaselinesComponents(), result.getInaccessibleComponentsNotInSeed(), parms.autoResolve, result, (IProgressMonitor)monitor.newChild(10));
        ArrayList<ComponentSyncDTO> conflictingComponents = new ArrayList<ComponentSyncDTO>();
        ArrayList<ComponentSyncDTO> multipleParticipants = new ArrayList<ComponentSyncDTO>();
        IWorkspaceUpdateOperation workspaceUpdateOperation = WorkspaceUpdateUtil.prepareWorkspaceUpdateOperation(parms, syncViewProxy, dilemmaHandler, conflictingComponents, multipleParticipants, (IProgressMonitor)monitor.newChild(9));
        if (!conflictingComponents.isEmpty()) {
            result.getComponentsWithConflictingTargets().addAll(conflictingComponents);
            result.setCancelled(true);
            return result;
        }
        if (!multipleParticipants.isEmpty() && !"continue".equals(parms.workspaceUpdateDilemmaHandler.multipleParticipantsDirection)) {
            result.getComponentsWithMultipleParticipants().addAll(multipleParticipants);
            result.setCancelled(true);
            return result;
        }
        if (workspaceUpdateOperation == null) {
            return result;
        }
        if (parms.reportDeleteDeleteConflicts.booleanValue()) {
            workspaceUpdateOperation.setReportDeleteDeleteConflicts(true);
        }
        try {
            if (parms.evaluateRequestOnly == null || !parms.evaluateRequestOnly.booleanValue()) {
                workspaceUpdateOperation.run((IProgressMonitor)monitor.newChild(80));
            } else {
                workspaceUpdateOperation.runPreConditionsOnly((IProgressMonitor)monitor.newChild(80));
            }
            result.setChangeSetsAlreadyInHistory(workspaceUpdateOperation.changeSetsAlreadyInHistory());
            result.setAcceptedSuspendedChanges(workspaceUpdateOperation.acceptedSuspendedChangeSets());
        }
        catch (OperationCanceledException e) {
            result.setChangeSetsAlreadyInHistory(workspaceUpdateOperation.changeSetsAlreadyInHistory());
            result.setAcceptedSuspendedChanges(workspaceUpdateOperation.acceptedSuspendedChangeSets());
            result.setCancelled(true);
        }
        WorkspaceUpdateUtil.recordConfigurationDescriptors(workspaceUpdateOperation.getComponentsAdded(), result.getComponentsAdded());
        if (workspaceUpdateOperation.isEclipseMetadataReadFailure()) {
            result.getEclipseReadFailureMessage().addAll(workspaceUpdateOperation.getEclipseMetadataReadFailureMessage());
        }
        if (parms.structuredResultOptions != null) {
            WorkspaceUpdateUtil.populateWorkspaceUpdateResult(workspaceUpdateOperation.getUpdateReport(), result.getStructuredResult(), (IProgressMonitor)monitor.newChild(1));
        }
        return result;
    }

    public static void populateWorkspaceUpdateResult(IWorkspaceUpdateReport report, List<StructuredUpdateReportDTO> result, IProgressMonitor monitor) throws TeamRepositoryException {
        if (report == null) {
            return;
        }
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.WorkspaceUpdateUtil_POPULATING_RESULT_OBJECT, (int)report.getConnections().size());
        for (IWorkspaceConnection wsConn : report.getConnections()) {
            SubMonitor wsMon = mon.newChild(1);
            wsMon.beginTask(NLS.bind((String)Messages.WorkspaceUpdateUtil_POPULATING_RESULT_FOR_REMOTE_WORKSPACE, (Object)wsConn.getName(), (Object[])new Object[0]), 3);
            StructuredUpdateReportDTO dto = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createStructuredUpdateReportDTO();
            result.add(dto);
            ITeamRepository teamRepository = wsConn.teamRepository();
            dto.setRepositoryId(CoreUtil.translateRepositoryId(teamRepository));
            dto.setRepositoryUrl(teamRepository.getRepositoryURI());
            dto.setWorkspaceItemId(wsConn.getContextHandle().getItemId().getUuidValue());
            dto.setWorkspaceName(wsConn.getName());
            List<IComponentHandle> compHandles = report.getAffectedComponents(wsConn);
            List comps = teamRepository.itemManager().fetchCompleteItems(compHandles, 0, (IProgressMonitor)wsMon.newChild(1));
            wsMon.setWorkRemaining(comps.size());
            boolean hasConflicts = false;
            for (IComponent comp : comps) {
                SubMonitor compMon = wsMon.newChild(1);
                compMon.beginTask(NLS.bind((String)Messages.WorkspaceUpdateUtil_POPULATING_RESULT_FOR_REMOTE_WORKSPACE_AND_COMPONENT, (Object)wsConn.getName(), (Object[])new Object[]{comp.getName()}), report.getBaselines(wsConn, (IComponentHandle)comp).size() + 1);
                StructuredComponentUpdateReportDTO compDto = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createStructuredComponentUpdateReportDTO();
                dto.getComponents().add(compDto);
                compDto.setComponentItemId(comp.getItemId().getUuidValue());
                compDto.setComponentName(comp.getName());
                if (report.isRemovedComponent(wsConn, (IComponentHandle)comp)) continue;
                List changeSets = compDto.getChangeSetItemIds();
                for (IChangeSetHandle changeSet : report.getAcceptedChanges(wsConn, (IComponentHandle)comp)) {
                    changeSets.add(changeSet.getItemId().getUuidValue());
                }
                List<IBaselineHandle> baselineHandles = report.getBaselines(wsConn, (IComponentHandle)comp);
                List baselines = teamRepository.itemManager().fetchCompleteItems(baselineHandles, 0, (IProgressMonitor)compMon.newChild(1));
                for (IBaseline baseline : baselines) {
                    StructuredBaselineUpdateReportDTO baselineDto = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createStructuredBaselineUpdateReportDTO();
                    compDto.getBaselines().add(baselineDto);
                    baselineDto.setBaselineItemId(baseline.getItemId().getUuidValue());
                    baselineDto.setBaselineId((long)baseline.getId());
                    baselineDto.setBaselineName(baseline.getName());
                }
                IUpdateReport update = wsConn.conflictReport((IComponentHandle)comp);
                for (IItemConflictReport conflict : update.getConflictsForComponent((IComponentHandle)comp)) {
                    compDto.getConflictedItemIds().add(conflict.item().getItemId().getUuidValue());
                    hasConflicts = true;
                }
                ICurrentPatch currentPort = wsConn.getCurrentPatch((IComponentHandle)comp);
                if (currentPort == null) continue;
                compDto.setCurrentPatch(PortsDTOUtil.asCurrentPortDTO(currentPort));
            }
            dto.setHasConflicts(hasConflicts);
        }
    }

    private static IWorkspaceUpdateOperation prepareWorkspaceUpdateOperation(ParmsWorkspaceUpdate parms, ISyncViewProxy syncViewProxy, WorkspaceUpdateDilemmaHandler dilemmaHandler, List<ComponentSyncDTO> conflictingComponents, List<ComponentSyncDTO> multipleParticipants, IProgressMonitor progress) throws TeamRepositoryException {
        IWorkspaceConnection sourceWorkspace;
        IWorkspaceConnection workspace;
        int n;
        Object[] objectArray;
        SubMonitor subMonitor;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)600);
        WorkspaceUpdateOperation workspaceUpdateOperation = null;
        try {
            workspaceUpdateOperation = parms.workspaceReplaceWithHistory == null ? (WorkspaceUpdateOperation)IOperationFactory.instance.getWorkspaceUpdateOperation(dilemmaHandler) : (WorkspaceUpdateOperation)((Object)IOperationFactory.instance.getWorkspaceRollbackOperation(dilemmaHandler));
        }
        catch (ClassCastException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        CommitUtil.configureCommit(parms.pendingChangesDilemmaHandler, (ICheckinOptions)workspaceUpdateOperation);
        RefreshUtil.configureRefresh(parms.preoperationRefresh, workspaceUpdateOperation);
        workspaceUpdateOperation.setPopulateUpdateReport(parms.structuredResultOptions != null);
        if (parms.acceptChangeSets != null && parms.acceptChangeSets.length > 0) {
            subMonitor = monitor.newChild(100).setWorkRemaining(parms.acceptChangeSets.length * 10);
            objectArray = parms.acceptChangeSets;
            n = parms.acceptChangeSets.length;
            int n2 = 0;
            while (n2 < n) {
                Object acceptChangeSetsParm = objectArray[n2];
                workspace = ((ParmsAcceptChangeSets)acceptChangeSetsParm).workspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                HashMap<ITeamRepository, ArrayList<IChangeSetHandle>> requests = new HashMap<ITeamRepository, ArrayList<IChangeSetHandle>>();
                ParmsChangeSet[] parmsChangeSetArray = ((ParmsAcceptChangeSets)acceptChangeSetsParm).changeSets;
                int n3 = ((ParmsAcceptChangeSets)acceptChangeSetsParm).changeSets.length;
                int n4 = 0;
                while (n4 < n3) {
                    ParmsChangeSet changeSet = parmsChangeSetArray[n4];
                    ITeamRepository repo = CommonUtil.getTeamRepository(changeSet.repositoryUrl);
                    ArrayList<IChangeSetHandle> changeSets = (ArrayList<IChangeSetHandle>)requests.get(repo);
                    if (changeSets == null) {
                        changeSets = new ArrayList<IChangeSetHandle>();
                        requests.put(repo, changeSets);
                    }
                    changeSets.add(CommonUtil.createChangeSetHandle(repo, changeSet.changeSetItemId));
                    ++n4;
                }
                for (ITeamRepository repo : requests.keySet()) {
                    List changeSets = (List)requests.get(repo);
                    workspaceUpdateOperation.acceptChangeSets(workspace, repo, changeSets);
                }
                ++n2;
            }
        }
        if (parms.workspaceAcceptDetailed != null && parms.workspaceAcceptDetailed.length > 0) {
            ArrayList<ParmsWorkspaceAcceptDetailed> hierarchicalWorkspaceAcceptDetailedList = new ArrayList<ParmsWorkspaceAcceptDetailed>();
            ArrayList<ParmsWorkspaceAcceptDetailed> nonHierarchicalWorkspaceAcceptDetailedList = new ArrayList<ParmsWorkspaceAcceptDetailed>();
            WorkspaceUpdateUtil.groupAcceptDetailsByHierarchialAccept(parms, hierarchicalWorkspaceAcceptDetailedList, nonHierarchicalWorkspaceAcceptDetailedList);
            SubMonitor subMonitor2 = SubMonitor.convert((IProgressMonitor)monitor, (int)(hierarchicalWorkspaceAcceptDetailedList.size() + nonHierarchicalWorkspaceAcceptDetailedList.size()));
            WorkspaceUpdateUtil.hierarchicalAcceptDetails(workspaceUpdateOperation, hierarchicalWorkspaceAcceptDetailedList, syncViewProxy, conflictingComponents, multipleParticipants, (IProgressMonitor)subMonitor2.newChild(hierarchicalWorkspaceAcceptDetailedList.size()));
            if (!conflictingComponents.isEmpty()) {
                return null;
            }
            if (!multipleParticipants.isEmpty() && !"continue".equals(parms.workspaceUpdateDilemmaHandler.multipleParticipantsDirection)) {
                return null;
            }
            WorkspaceUpdateUtil.nonHierarchicalAccept(workspaceUpdateOperation, nonHierarchicalWorkspaceAcceptDetailedList, syncViewProxy, (IProgressMonitor)subMonitor2.newChild(nonHierarchicalWorkspaceAcceptDetailedList.size()));
        }
        if (parms.workspaceAccept != null && parms.workspaceAccept.length > 0) {
            subMonitor = monitor.newChild(100).setWorkRemaining(parms.workspaceAccept.length * 30);
            objectArray = parms.workspaceAccept;
            n = parms.workspaceAccept.length;
            int n5 = 0;
            while (n5 < n) {
                Object workspaceAccept = objectArray[n5];
                workspace = ((ParmsWorkspaceAccept)workspaceAccept).workspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                sourceWorkspace = ((ParmsWorkspaceAccept)workspaceAccept).sourceWorkspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                IChangeHistorySyncReport syncReport = syncViewProxy.getCompareReport(workspace, sourceWorkspace, (IProgressMonitor)subMonitor.newChild(10));
                workspaceUpdateOperation.accept(workspace, sourceWorkspace, syncReport);
                ++n5;
            }
        }
        if (parms.workspaceReplaceWithBaseline != null && parms.workspaceReplaceWithBaseline.length > 0) {
            subMonitor = monitor.newChild(100).setWorkRemaining(parms.workspaceReplaceWithBaseline.length * 30);
            objectArray = parms.workspaceReplaceWithBaseline;
            n = parms.workspaceReplaceWithBaseline.length;
            int n6 = 0;
            while (n6 < n) {
                boolean hierarchicalReplace;
                Object workspaceReplaceWithBaseline = objectArray[n6];
                workspace = ((ParmsWorkspaceComponentReplaceWithBaseline)workspaceReplaceWithBaseline).workspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                IBaselineConnection sourceBaseline = ((ParmsWorkspaceComponentReplaceWithBaseline)workspaceReplaceWithBaseline).baseline.getBaselineConnection((IProgressMonitor)subMonitor.newChild(10));
                IWorkspaceHandle operationSource = null;
                if (((ParmsWorkspaceComponentReplaceWithBaseline)workspaceReplaceWithBaseline).sourceWorkspace != null) {
                    operationSource = ((ParmsWorkspaceComponentReplaceWithBaseline)workspaceReplaceWithBaseline).sourceWorkspace.getWorkspaceHandle();
                }
                boolean bl = hierarchicalReplace = parms.hierarchicalOperation && ComponentHierarchyManager.getInstance().isHierarchicalComponentsEnabled(workspace.teamRepository());
                if (hierarchicalReplace) {
                    if (operationSource != null) {
                        workspaceUpdateOperation.replaceFromHierarchicalBaseline(workspace, sourceBaseline, operationSource);
                    } else {
                        workspaceUpdateOperation.replaceFromHierarchicalBaseline(workspace, sourceBaseline);
                    }
                } else if (operationSource != null) {
                    workspaceUpdateOperation.replace(workspace, sourceBaseline, operationSource);
                } else {
                    workspaceUpdateOperation.replace(workspace, sourceBaseline);
                }
                ++n6;
            }
        }
        if (parms.workspaceReplaceWithSnapshot != null && parms.workspaceReplaceWithSnapshot.length > 0) {
            subMonitor = monitor.newChild(100).setWorkRemaining(parms.workspaceReplaceWithSnapshot.length * 10);
            objectArray = parms.workspaceReplaceWithSnapshot;
            n = parms.workspaceReplaceWithSnapshot.length;
            int n7 = 0;
            while (n7 < n) {
                List<IComponentHandle> components;
                Object workspaceReplaceWithSnapshot = objectArray[n7];
                workspace = ((ParmsWorkspaceReplaceWithSnapshot)workspaceReplaceWithSnapshot).workspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                ITeamRepository baselineRepository = CommonUtil.getTeamRepository(((ParmsWorkspaceReplaceWithSnapshot)workspaceReplaceWithSnapshot).baselineSet.repositoryUrl);
                IBaselineSetHandle sourceBaselineSet = ((ParmsWorkspaceReplaceWithSnapshot)workspaceReplaceWithSnapshot).baselineSet.getBaselineSetHandle();
                IWorkspaceHandle operationSource = null;
                if (((ParmsWorkspaceReplaceWithSnapshot)workspaceReplaceWithSnapshot).sourceWorkspace != null) {
                    operationSource = ((ParmsWorkspaceReplaceWithSnapshot)workspaceReplaceWithSnapshot).sourceWorkspace.getWorkspaceHandle();
                }
                if ((components = ((ParmsWorkspaceReplaceWithSnapshot)workspaceReplaceWithSnapshot).getComponentHandles()).isEmpty()) {
                    if (operationSource != null) {
                        workspaceUpdateOperation.replace(workspace, baselineRepository, sourceBaselineSet, operationSource);
                    } else {
                        workspaceUpdateOperation.replace(workspace, baselineRepository, sourceBaselineSet);
                    }
                } else if (operationSource != null) {
                    workspaceUpdateOperation.replace(workspace, baselineRepository, sourceBaselineSet, operationSource, components);
                } else {
                    workspaceUpdateOperation.replace(workspace, baselineRepository, sourceBaselineSet, components);
                }
                ++n7;
            }
        }
        if (parms.workspaceReplaceWithWorkspace != null && parms.workspaceReplaceWithWorkspace.length > 0) {
            subMonitor = monitor.newChild(100).setWorkRemaining(parms.workspaceReplaceWithWorkspace.length * 10);
            objectArray = parms.workspaceReplaceWithWorkspace;
            n = parms.workspaceReplaceWithWorkspace.length;
            int n8 = 0;
            while (n8 < n) {
                Object workspaceReplaceWithWorkspace = objectArray[n8];
                workspace = ((ParmsWorkspaceReplaceWithWorkspace)workspaceReplaceWithWorkspace).workspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                sourceWorkspace = ((ParmsWorkspaceReplaceWithWorkspace)workspaceReplaceWithWorkspace).sourceWorkspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                List<IComponentHandle> components = ((ParmsWorkspaceReplaceWithWorkspace)workspaceReplaceWithWorkspace).getComponentHandles();
                if (components.isEmpty()) {
                    workspaceUpdateOperation.replace(workspace, sourceWorkspace);
                } else {
                    workspaceUpdateOperation.replace(workspace, sourceWorkspace, components, parms.hierarchicalOperation);
                }
                ++n8;
            }
        }
        if (workspaceUpdateOperation instanceof IWorkspaceRollbackOperation && parms.workspaceReplaceWithHistory != null && parms.workspaceReplaceWithHistory.length > 0) {
            subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(parms.workspaceReplaceWithHistory.length * 10));
            objectArray = parms.workspaceReplaceWithHistory;
            n = parms.workspaceReplaceWithHistory.length;
            int n9 = 0;
            while (n9 < n) {
                Object workspaceReplaceWithHistory = objectArray[n9];
                workspace = ((ParmsWorkspaceReplaceWithHistory)workspaceReplaceWithHistory).workspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(1));
                ParmsHistoryReference historyParm = ((ParmsWorkspaceReplaceWithHistory)workspaceReplaceWithHistory).seed;
                IHistoryReference history = WorkspaceUtil.createHistoryReference(historyParm);
                ITeamRepository sourceRepository = TeamPlatform.getTeamRepositoryService().getTeamRepository(historyParm.repositoryUrl);
                ArrayList<IComponentHandle> filter = null;
                String[] componentItemIds = ((ParmsWorkspaceReplaceWithHistory)workspaceReplaceWithHistory).componentItemIds;
                if (componentItemIds != null && componentItemIds.length > 0) {
                    filter = new ArrayList<IComponentHandle>();
                    String[] stringArray = componentItemIds;
                    int n10 = componentItemIds.length;
                    int n11 = 0;
                    while (n11 < n10) {
                        String itemId = stringArray[n11];
                        if (itemId != null) {
                            filter.add((IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(UUID.valueOf((String)itemId), null));
                        }
                        ++n11;
                    }
                }
                ((IWorkspaceRollbackOperation)((Object)workspaceUpdateOperation)).rollback(workspace, sourceRepository, history, filter, (IProgressMonitor)subMonitor.newChild(9));
                ++n9;
            }
        }
        workspaceUpdateOperation.setAutoAcquireLocks(parms.autoAcquireLocks);
        return workspaceUpdateOperation;
    }

    private static void groupAcceptDetailsByHierarchialAccept(ParmsWorkspaceUpdate parms, List<ParmsWorkspaceAcceptDetailed> hierarchicalWorkspaceAcceptDetailedList, List<ParmsWorkspaceAcceptDetailed> nonHierarchicalWorkspaceAcceptDetailedList) throws TeamRepositoryException {
        ParmsWorkspaceAcceptDetailed[] parmsWorkspaceAcceptDetailedArray = parms.workspaceAcceptDetailed;
        int n = parms.workspaceAcceptDetailed.length;
        int n2 = 0;
        while (n2 < n) {
            ParmsWorkspaceAcceptDetailed workspaceAcceptDetaileds = parmsWorkspaceAcceptDetailedArray[n2];
            ITeamRepository repo = workspaceAcceptDetaileds.workspace.getTeamRepository();
            boolean hierarchialAccept = workspaceAcceptDetaileds.hierarchicalAccept & ComponentHierarchyManager.getInstance().isHierarchicalComponentsEnabled(repo);
            if (hierarchialAccept) {
                hierarchicalWorkspaceAcceptDetailedList.add(workspaceAcceptDetaileds);
            } else {
                nonHierarchicalWorkspaceAcceptDetailedList.add(workspaceAcceptDetaileds);
            }
            ++n2;
        }
    }

    private static void hierarchicalAcceptDetails(IWorkspaceUpdateOperation workspaceUpdateOperation, List<ParmsWorkspaceAcceptDetailed> hierarchicalWorkspaceAcceptDetailedList, ISyncViewProxy syncViewProxy, List<ComponentSyncDTO> conflictingComponents, List<ComponentSyncDTO> multipleParticipants, IProgressMonitor monitor) throws TeamRepositoryException {
        HashMap<IWorkspaceConnection, Map<IWorkspaceConnection, List<IComponentHandle>>> targetToSourceToComponentsMap = new HashMap<IWorkspaceConnection, Map<IWorkspaceConnection, List<IComponentHandle>>>();
        HashMap<IWorkspaceConnection, Map<IWorkspaceConnection, List<IBaselineHandle>>> targetToSourceToBaselinesMap = new HashMap<IWorkspaceConnection, Map<IWorkspaceConnection, List<IBaselineHandle>>>();
        HashMap<IWorkspaceConnection, Map<IWorkspaceConnection, List<IChangeSetHandle>>> targetToSourceToChangeSetsMap = new HashMap<IWorkspaceConnection, Map<IWorkspaceConnection, List<IChangeSetHandle>>>();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        WorkspaceUpdateUtil.extractAcceptDetailsToMaps(syncViewProxy, conflictingComponents, multipleParticipants, hierarchicalWorkspaceAcceptDetailedList, targetToSourceToComponentsMap, targetToSourceToBaselinesMap, targetToSourceToChangeSetsMap, (IProgressMonitor)subMonitor.newChild(1));
        WorkspaceUpdateUtil.hierarchicalAcceptMaps(workspaceUpdateOperation, syncViewProxy, targetToSourceToComponentsMap, targetToSourceToBaselinesMap, targetToSourceToChangeSetsMap, (IProgressMonitor)subMonitor.newChild(1));
    }

    private static void extractAcceptDetailsToMaps(ISyncViewProxy syncViewProxy, List<ComponentSyncDTO> conflictingComponents, List<ComponentSyncDTO> multipleParticipants, List<ParmsWorkspaceAcceptDetailed> hierarchicalWorkspaceAcceptDetailedList, Map<IWorkspaceConnection, Map<IWorkspaceConnection, List<IComponentHandle>>> targetToSourceToComponentsMap, Map<IWorkspaceConnection, Map<IWorkspaceConnection, List<IBaselineHandle>>> targetToSourceToBaselinesMap, Map<IWorkspaceConnection, Map<IWorkspaceConnection, List<IChangeSetHandle>>> targetToSourceToChangeSetsMap, IProgressMonitor monitor) throws TeamRepositoryException {
        boolean isSourceWorkspaceExplicit = hierarchicalWorkspaceAcceptDetailedList.isEmpty() ? false : hierarchicalWorkspaceAcceptDetailedList.get((int)0).sourceWorkspaceExplicit;
        Map<ParmsWorkspace, List<ParmsWorkspaceAcceptDetailed>> targetToDetails = WorkspaceUpdateUtil.getTargetToDetails(hierarchicalWorkspaceAcceptDetailedList);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(targetToDetails.size() * 2));
        for (Map.Entry<ParmsWorkspace, List<ParmsWorkspaceAcceptDetailed>> targetToDetailsEntry : targetToDetails.entrySet()) {
            ParmsWorkspace workspaceParms = targetToDetailsEntry.getKey();
            List<ParmsWorkspaceAcceptDetailed> workspaceAcceptDetaileds = targetToDetailsEntry.getValue();
            IWorkspaceConnection workspaceConnection = workspaceParms.getWorkspaceConnection((IProgressMonitor)progress.newChild(1));
            Map<ParmsWorkspace, List<ParmsWorkspaceAcceptDetailed>> sourceToDetails = WorkspaceUpdateUtil.getSourceToDetails(workspaceAcceptDetaileds);
            SubMonitor loopProgress = progress.newChild(1).setWorkRemaining(sourceToDetails.size());
            for (Map.Entry<ParmsWorkspace, List<ParmsWorkspaceAcceptDetailed>> sourceToDetailsEntry : sourceToDetails.entrySet()) {
                IWorkspaceConnection sourceWorkspace = sourceToDetailsEntry.getKey().getWorkspaceConnection((IProgressMonitor)loopProgress.newChild(1));
                ArrayList<Object> components = new ArrayList<Object>();
                ArrayList<IBaselineHandle> baselines = new ArrayList<IBaselineHandle>();
                ArrayList<IChangeSetHandle> changeSets = new ArrayList<IChangeSetHandle>();
                for (ParmsWorkspaceAcceptDetailed workspaceAcceptDetailed : sourceToDetailsEntry.getValue()) {
                    components.addAll(workspaceAcceptDetailed.getComponentHandles());
                    baselines.addAll(workspaceAcceptDetailed.getBaselineHandles());
                    changeSets.addAll(workspaceAcceptDetailed.getChangeSetHandles());
                }
                if (isSourceWorkspaceExplicit) {
                    IComponentHierarchyResult hierarchy = sourceWorkspace.getComponentHierarchy(components);
                    Map subComponents = hierarchy.getFlattenedElementsMap();
                    components.addAll(subComponents.values());
                }
                WorkspaceUpdateUtil.put(targetToSourceToComponentsMap, workspaceConnection, sourceWorkspace, components);
                WorkspaceUpdateUtil.put(targetToSourceToBaselinesMap, workspaceConnection, sourceWorkspace, baselines);
                WorkspaceUpdateUtil.put(targetToSourceToChangeSetsMap, workspaceConnection, sourceWorkspace, changeSets);
            }
        }
        if (!isSourceWorkspaceExplicit) {
            HashMap<IWorkspaceConnection, List<IComponentHandle>> targetsToComponentsMap = new HashMap<IWorkspaceConnection, List<IComponentHandle>>();
            for (Map.Entry<IWorkspaceConnection, Map<IWorkspaceConnection, List<IComponentHandle>>> targetToSourceToComponentsEntry : targetToSourceToComponentsMap.entrySet()) {
                IWorkspaceConnection target = targetToSourceToComponentsEntry.getKey();
                Map<IWorkspaceConnection, List<IComponentHandle>> sourceToComponentsMap = targetToSourceToComponentsEntry.getValue();
                ArrayList<IComponentHandle> allComponentHandles = new ArrayList<IComponentHandle>();
                for (List<IComponentHandle> componentHandles : sourceToComponentsMap.values()) {
                    allComponentHandles.addAll(componentHandles);
                }
                targetsToComponentsMap.put(target, allComponentHandles);
            }
            Map<IWorkspaceConnection, Map<IWorkspaceConnection, List<IComponentHandle>>> componentHierarchyChildren = syncViewProxy.getComponentHierarchyChildren(targetsToComponentsMap, false, conflictingComponents, multipleParticipants);
            targetToSourceToComponentsMap.clear();
            targetToSourceToComponentsMap.putAll(componentHierarchyChildren);
        }
    }

    private static Map<ParmsWorkspace, List<ParmsWorkspaceAcceptDetailed>> getTargetToDetails(Collection<ParmsWorkspaceAcceptDetailed> workspaceAcceptDetaileds) {
        HashMap<ParmsWorkspace, List<ParmsWorkspaceAcceptDetailed>> targetToDetails = new HashMap<ParmsWorkspace, List<ParmsWorkspaceAcceptDetailed>>();
        for (ParmsWorkspaceAcceptDetailed workspaceAcceptDetailed : workspaceAcceptDetaileds) {
            ParmsWorkspace workspace = workspaceAcceptDetailed.workspace;
            ArrayList<ParmsWorkspaceAcceptDetailed> details = (ArrayList<ParmsWorkspaceAcceptDetailed>)targetToDetails.get(workspace);
            if (details == null) {
                details = new ArrayList<ParmsWorkspaceAcceptDetailed>();
                targetToDetails.put(workspace, details);
            }
            details.add(workspaceAcceptDetailed);
        }
        return targetToDetails;
    }

    private static Map<ParmsWorkspace, List<ParmsWorkspaceAcceptDetailed>> getSourceToDetails(List<ParmsWorkspaceAcceptDetailed> workspaceAcceptDetaileds) {
        HashMap<ParmsWorkspace, List<ParmsWorkspaceAcceptDetailed>> targetToDetails = new HashMap<ParmsWorkspace, List<ParmsWorkspaceAcceptDetailed>>();
        for (ParmsWorkspaceAcceptDetailed workspaceAcceptDetailed : workspaceAcceptDetaileds) {
            ParmsWorkspace workspace = workspaceAcceptDetailed.sourceWorkspace;
            ArrayList<ParmsWorkspaceAcceptDetailed> details = (ArrayList<ParmsWorkspaceAcceptDetailed>)targetToDetails.get(workspace);
            if (details == null) {
                details = new ArrayList<ParmsWorkspaceAcceptDetailed>();
                targetToDetails.put(workspace, details);
            }
            details.add(workspaceAcceptDetailed);
        }
        return targetToDetails;
    }

    private static <T> void put(Map<IWorkspaceConnection, Map<IWorkspaceConnection, List<T>>> targetToSourceToListMap, IWorkspaceConnection workspaceConnection, IWorkspaceConnection sourceWorkspace, List<T> list) {
        Map<IWorkspaceConnection, List<T>> sourceToListMap = targetToSourceToListMap.get(workspaceConnection);
        if (sourceToListMap == null) {
            sourceToListMap = new HashMap<IWorkspaceConnection, List<T>>();
            targetToSourceToListMap.put(workspaceConnection, sourceToListMap);
        }
        sourceToListMap.put(sourceWorkspace, list);
    }

    private static void hierarchicalAcceptMaps(IWorkspaceUpdateOperation workspaceUpdateOperation, ISyncViewProxy syncViewProxy, Map<IWorkspaceConnection, Map<IWorkspaceConnection, List<IComponentHandle>>> targetToSourceToComponentsMap, Map<IWorkspaceConnection, Map<IWorkspaceConnection, List<IBaselineHandle>>> targetToSourceToBaselinesMap, Map<IWorkspaceConnection, Map<IWorkspaceConnection, List<IChangeSetHandle>>> targetToSourceToChangeSetsMap, IProgressMonitor monitor) throws TeamRepositoryException {
        HashSet<IWorkspaceConnection> targets = new HashSet<IWorkspaceConnection>();
        targets.addAll(targetToSourceToComponentsMap.keySet());
        targets.addAll(targetToSourceToBaselinesMap.keySet());
        targets.addAll(targetToSourceToChangeSetsMap.keySet());
        SubMonitor submonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)targets.size());
        for (IWorkspaceConnection workspaceConnection : targets) {
            Map<IWorkspaceConnection, List<IComponentHandle>> sourceToComponents = targetToSourceToComponentsMap.containsKey(workspaceConnection) ? targetToSourceToComponentsMap.get(workspaceConnection) : Collections.EMPTY_MAP;
            Map<IWorkspaceConnection, List<IBaselineHandle>> sourceToBaselinesMap = targetToSourceToBaselinesMap.containsKey(targetToSourceToBaselinesMap) ? targetToSourceToBaselinesMap.get(workspaceConnection) : Collections.EMPTY_MAP;
            Map<IWorkspaceConnection, List<IChangeSetHandle>> sourceToChangeSetsMap = targetToSourceToChangeSetsMap.containsKey(workspaceConnection) ? targetToSourceToChangeSetsMap.get(workspaceConnection) : Collections.EMPTY_MAP;
            HashSet<IWorkspaceConnection> sources = new HashSet<IWorkspaceConnection>();
            sources.addAll(sourceToComponents.keySet());
            sources.addAll(sourceToBaselinesMap.keySet());
            sources.addAll(sourceToChangeSetsMap.keySet());
            SubMonitor submonitor2 = SubMonitor.convert((IProgressMonitor)submonitor.newChild(1), (int)sources.size());
            for (IWorkspaceConnection sourceWorkspace : sources) {
                List<IComponentHandle> components = sourceToComponents.containsKey(sourceWorkspace) ? sourceToComponents.get(sourceWorkspace) : Collections.EMPTY_LIST;
                List<IBaselineHandle> baselines = sourceToBaselinesMap.containsKey(sourceWorkspace) ? sourceToBaselinesMap.get(sourceWorkspace) : Collections.EMPTY_LIST;
                List<IChangeSetHandle> changeSets = sourceToChangeSetsMap.containsKey(sourceWorkspace) ? sourceToChangeSetsMap.get(sourceWorkspace) : Collections.EMPTY_LIST;
                IChangeHistorySyncReport syncReport = syncViewProxy.getCompareReport(workspaceConnection, sourceWorkspace, (IProgressMonitor)submonitor2.newChild(1));
                workspaceUpdateOperation.accept(workspaceConnection, sourceWorkspace, syncReport, baselines, changeSets, components);
            }
        }
    }

    private static void nonHierarchicalAccept(IWorkspaceUpdateOperation workspaceUpdateOperation, List<ParmsWorkspaceAcceptDetailed> nonHierarchicalWorkspaceAcceptDetailedList, ISyncViewProxy syncViewProxy, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(nonHierarchicalWorkspaceAcceptDetailedList.size() * 3));
        for (ParmsWorkspaceAcceptDetailed workspaceAcceptDetailed : nonHierarchicalWorkspaceAcceptDetailedList) {
            IWorkspaceConnection workspaceConnection = workspaceAcceptDetailed.workspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(1));
            IWorkspaceConnection sourceWorkspace = workspaceAcceptDetailed.sourceWorkspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(1));
            List<IBaselineHandle> baselines = workspaceAcceptDetailed.getBaselineHandles();
            List<IChangeSetHandle> changeSets = workspaceAcceptDetailed.getChangeSetHandles();
            List<IComponentHandle> components = workspaceAcceptDetailed.getComponentHandles();
            IChangeHistorySyncReport syncReport = syncViewProxy.getCompareReport(workspaceConnection, sourceWorkspace, (IProgressMonitor)subMonitor.newChild(1));
            workspaceUpdateOperation.accept(workspaceConnection, sourceWorkspace, syncReport, baselines, changeSets, components);
        }
    }

    public static WorkspaceUpdateDilemmaHandler getWorkspaceUpdateDilemmaHandler(ParmsWorkspaceUpdateDilemmaHandler workspaceUpdateDilemmaParms, ParmsPendingChangesDilemmaHandler pendingChangesDilemmaParms, final List<ConfigurationWithUncheckedInChangesDTO> configurationsWithUncheckedInChanges, CommitDilemmaDTO commitDilemma, ParmsOutOfSyncInstructions outOfSyncInstructions, List<ShareDTO> outOfSyncShares, ParmsSandboxUpdateDilemmaHandler sandboxUpdateDilemmaHandler, SandboxUpdateDilemmaDTO sandboxUpdateDilemma, ParmsUpdateDilemmaHandler updateDilemmaHandler, UpdateDilemmaDTO updateDilemma, final List<ConfigurationDescriptorDTO> componentFlowAdditions, final List<ConfigurationDescriptorDTO> componentFlowDeletions, final List<ConfigurationDescriptorDTO> componentReplacementCandidates, final List<ConfigurationDescriptorDTO> disconnectedComponents, final List<ProblemChangeSetsDTO> activeChangeSetsEncountered, final List<ProblemChangeSetsDTO> activeChangeSetsOverlapEncountered, final List<ProblemChangeSetsDTO> activeChangeSetsInComponents, final List<GapChangeSetsDTO> gapEncountered, final List<ComponentDTO> componentsWithNWayConflicts, final List<StaleDataDTO> staleDataEncountered, final List<ProblemChangeSetsDTO> changeSetsBlockedByPortInProgress, final boolean autoAcquireLocks, final List locksWereHeld, final List locksToAcquire, final List<ComponentDTO> selectedComponentsInMultipleHierarchies, final List<ComponentDTO> subcomponentsInMultipleHierarchies, final List<ComponentDTO> noBackupBaselineComponents, final List<ComponentDTO> inaccessibleComponentsNotInSeed, final boolean autoResolve, final WorkspaceUpdateResultDTO result, IProgressMonitor progress) throws TeamRepositoryException {
        int inaccessibleComponentsNotInSeedInstruction;
        int componentInMultipleHierarchiesInstruction;
        int noBackupBaselineInstruction;
        int nWayConflictInstruction;
        int portInProgressInstruction;
        int gapInstruction;
        int activeChangeSetsOverlapInstruction;
        int activeChangeSetsComponentInstruction;
        int activeChangeSetsInstruction;
        int staleDataInstruction;
        int disconnectedComponentsInstruction;
        int componentFlowInstruction;
        int replaceComponentsInstruction;
        if (workspaceUpdateDilemmaParms == null) {
            replaceComponentsInstruction = 2;
            componentFlowInstruction = 2;
            disconnectedComponentsInstruction = 2;
            staleDataInstruction = 2;
            activeChangeSetsInstruction = 2;
            activeChangeSetsComponentInstruction = 0;
            activeChangeSetsOverlapInstruction = 2;
            gapInstruction = 2;
            portInProgressInstruction = 2;
            nWayConflictInstruction = 2;
            noBackupBaselineInstruction = 2;
            componentInMultipleHierarchiesInstruction = 2;
            inaccessibleComponentsNotInSeedInstruction = 2;
        } else {
            replaceComponentsInstruction = WorkspaceUpdateUtil.getInstruction(workspaceUpdateDilemmaParms.componentReplacementCandidatesDirection, true, "workspaceUpdateDilemmaHandler.componentReplacementCandidatesDirection");
            componentFlowInstruction = WorkspaceUpdateUtil.getInstruction(workspaceUpdateDilemmaParms.componentFlowDirection, true, "workspaceUpdateDilemmaHandler.componentFlowDirection");
            disconnectedComponentsInstruction = WorkspaceUpdateUtil.getInstruction(workspaceUpdateDilemmaParms.disconnectedComponentsDirection, false, "workspaceUpdateDilemmaHandler.disconnectedComponentsDirection");
            staleDataInstruction = WorkspaceUpdateUtil.getInstruction(workspaceUpdateDilemmaParms.staleDataDirection, false, "workspaceUpdateDilemmaHandler.staleDataDirection");
            activeChangeSetsInstruction = WorkspaceUpdateUtil.getInstruction(workspaceUpdateDilemmaParms.activeChangeSetsDirection, true, "activeChangeSetsDirection");
            activeChangeSetsComponentInstruction = WorkspaceUpdateUtil.getInstruction(workspaceUpdateDilemmaParms.activeChangeSetsComponentDirection, false, "activeChangeSetsComponentDirection");
            activeChangeSetsOverlapInstruction = WorkspaceUpdateUtil.getInstruction(workspaceUpdateDilemmaParms.activeChangeSetsOverlapDirection, true, "activeChangeSetsOverlapDirection");
            gapInstruction = WorkspaceUpdateUtil.getInstruction(workspaceUpdateDilemmaParms.gapDirection, true, "gapDirection");
            portInProgressInstruction = WorkspaceUpdateUtil.getInstruction(workspaceUpdateDilemmaParms.portInProgressDirection, true, "portInProgressDirection");
            nWayConflictInstruction = WorkspaceUpdateUtil.getInstruction(workspaceUpdateDilemmaParms.nWayConflictDirection, false, "nWayConflictDirection");
            noBackupBaselineInstruction = WorkspaceUpdateUtil.getInstruction(workspaceUpdateDilemmaParms.noBackupBaselineDirection, false, "noBackupBaselineDirection");
            componentInMultipleHierarchiesInstruction = WorkspaceUpdateUtil.getInstruction(workspaceUpdateDilemmaParms.componentInMultipleHierarchiesDirection, false, "multipleParticipantsDirection");
            inaccessibleComponentsNotInSeedInstruction = WorkspaceUpdateUtil.getInstruction(workspaceUpdateDilemmaParms.inaccessibleComponentsNotInSeedDirection, false, "inaccessibleComponentsNotInSeedDirection");
        }
        final int uncheckedInChangesInstruction = CommitUtil.getUncheckedInChangesInstruction(pendingChangesDilemmaParms);
        ArrayList missingRequiredChanges = new ArrayList();
        ArrayList missingStorageMergers = new ArrayList();
        ParmsPendingChangesDilemmaHandler subHandler = new ParmsPendingChangesDilemmaHandler();
        subHandler.pendingChangesInstruction = "continue";
        if (pendingChangesDilemmaParms != null) {
            subHandler.checkInOptions = pendingChangesDilemmaParms.checkInOptions;
            subHandler.commitDilemmaHandler = pendingChangesDilemmaParms.commitDilemmaHandler;
            subHandler.pendingChangesInSubcomponentsInstruction = pendingChangesDilemmaParms.pendingChangesInSubcomponentsInstruction;
        }
        ParmsMissingStorageMergerDilemmaHandler missingStorageMergerHandler = new ParmsMissingStorageMergerDilemmaHandler();
        missingStorageMergerHandler.generalStorageMergerInstruction = "continue";
        WorkspaceUpdateDilemmaHandler workspaceUpdateDilemmaHandler = new WorkspaceUpdateDilemmaHandler(sandboxUpdateDilemmaHandler, sandboxUpdateDilemma, updateDilemmaHandler, updateDilemma, outOfSyncInstructions, outOfSyncShares, progress, pendingChangesDilemmaParms, commitDilemma, subHandler, missingRequiredChanges, missingStorageMergerHandler, missingStorageMergers){
            final SandboxUpdateDilemmaUtil sandboxUpdateDilemmaUtil;
            final UpdateDilemmaUtil updateDilemmaUtil;
            final OutOfSyncDilemmaHandler outOfSyncDilemmaHandler;
            final CommitDilemmaHandler commitDilemmaHandler;
            final MarkAsMergedDilemmaHandler markAsMergeddilemmaHandler;
            final ApplyAcceptedDilemmaHandler applyAcceptedDilemmaHandler;
            final AutoResolveConflictsDilemmaHandler autoResolveDilemmaHandler;
            {
                this.sandboxUpdateDilemmaUtil = new SandboxUpdateDilemmaUtil(parmsSandboxUpdateDilemmaHandler, sandboxUpdateDilemmaDTO);
                this.updateDilemmaUtil = new UpdateDilemmaUtil(parmsUpdateDilemmaHandler, updateDilemmaDTO);
                this.outOfSyncDilemmaHandler = VerifyOutOfSyncUtil.getOutOfSyncDilemmaHandler(parmsOutOfSyncInstructions, list, parmsSandboxUpdateDilemmaHandler, sandboxUpdateDilemmaDTO, iProgressMonitor);
                this.commitDilemmaHandler = CommitUtil.getCommitDilemmaHandler(parmsPendingChangesDilemmaHandler, commitDilemmaDTO, parmsSandboxUpdateDilemmaHandler, sandboxUpdateDilemmaDTO, parmsUpdateDilemmaHandler, updateDilemmaDTO, this.outOfSyncDilemmaHandler);
                this.markAsMergeddilemmaHandler = ConflictResolutionUtil.getMarkAsMergedDilemmaHandler(null, parmsOutOfSyncInstructions, list, parmsPendingChangesDilemmaHandler2, null, commitDilemmaDTO, "no", list2, "continue", null, parmsSandboxUpdateDilemmaHandler, sandboxUpdateDilemmaDTO, parmsUpdateDilemmaHandler, updateDilemmaDTO, iProgressMonitor);
                this.applyAcceptedDilemmaHandler = ConflictResolutionUtil.getApplyAcceptedDilemmaHandler(parmsOutOfSyncInstructions, list, "no", list2, parmsSandboxUpdateDilemmaHandler, sandboxUpdateDilemmaDTO, parmsUpdateDilemmaHandler, updateDilemmaDTO, iProgressMonitor);
                this.autoResolveDilemmaHandler = ConflictResolutionUtil.getAutoResolveConflictDilemmaHandler(this.markAsMergeddilemmaHandler, this.applyAcceptedDilemmaHandler, this.sandboxUpdateDilemmaUtil.getBackupDilemmaHandler(), this.outOfSyncDilemmaHandler, parmsMissingStorageMergerDilemmaHandler, parmsPendingChangesDilemmaHandler, commitDilemmaDTO, list3);
            }

            @Override
            public int componentReplacementCandidates(Collection<ConfigurationFacade> replaceConfigurations) {
                WorkspaceUpdateUtil.recordConfigurationDescriptors(replaceConfigurations, componentReplacementCandidates);
                return replaceComponentsInstruction;
            }

            @Override
            public int componentsToBeAddedOrRemoved(Collection<ConfigurationFacade> added, Collection<ConfigurationFacade> removed) {
                WorkspaceUpdateUtil.recordConfigurationDescriptors(added, componentFlowAdditions);
                WorkspaceUpdateUtil.recordConfigurationDescriptors(removed, componentFlowDeletions);
                return componentFlowInstruction;
            }

            @Override
            public int disconnectedComponents(Collection<ConfigurationFacade> configurations) {
                WorkspaceUpdateUtil.recordConfigurationDescriptors(configurations, disconnectedComponents);
                return disconnectedComponentsInstruction;
            }

            @Override
            public CommitDilemmaHandler getCommitDilemmaHandler() {
                return this.commitDilemmaHandler;
            }

            @Override
            public int staleData(IWorkspaceConnection workspaceConnection, IWorkspaceConnection sourceWorkspaceConnection) {
                if (staleDataEncountered != null) {
                    StaleDataDTO staleDataDTO = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createStaleDataDTO();
                    ITeamRepository teamRepository = workspaceConnection.teamRepository();
                    staleDataDTO.setRepositoryId(CoreUtil.translateRepositoryId(teamRepository));
                    staleDataDTO.setRepositoryURL(teamRepository.getRepositoryURI());
                    staleDataDTO.setWorkspaceItemId(workspaceConnection.getContextHandle().getItemId().getUuidValue());
                    ITeamRepository sourceTeamRepository = sourceWorkspaceConnection.teamRepository();
                    staleDataDTO.setSourceRepositoryId(CoreUtil.translateRepositoryId(sourceTeamRepository));
                    staleDataDTO.setSourceRepositoryURL(sourceTeamRepository.getRepositoryURI());
                    staleDataDTO.setSourceWorkspaceItemId(sourceWorkspaceConnection.getContextHandle().getItemId().getUuidValue());
                    staleDataEncountered.add(staleDataDTO);
                }
                return staleDataInstruction;
            }

            @Override
            public int portInProgress(IWorkspaceConnection workspaceConnection, List<IChangeSetHandle> changeSets) {
                if (changeSetsBlockedByPortInProgress != null) {
                    changeSetsBlockedByPortInProgress.add(CoreUtil.translateProblemChangeSetsDTO(workspaceConnection, changeSets));
                }
                return portInProgressInstruction;
            }

            @Override
            public int uncheckedInChanges(Map<ConfigurationFacade, Collection<ILocalChange>> configurationToChangesMap) {
                if (configurationsWithUncheckedInChanges != null) {
                    for (Map.Entry<ConfigurationFacade, Collection<ILocalChange>> entry : configurationToChangesMap.entrySet()) {
                        ConfigurationWithUncheckedInChangesDTO uncheckedInChanges = FilesystemRestClientDTOcoreFactory.eINSTANCE.createConfigurationWithUncheckedInChangesDTO();
                        uncheckedInChanges.setConfiguration(CoreUtil.translateConfigurationDescriptor(entry.getKey()));
                        uncheckedInChanges.setChangeCount(entry.getValue().size());
                        configurationsWithUncheckedInChanges.add(uncheckedInChanges);
                    }
                }
                return uncheckedInChangesInstruction;
            }

            @Override
            public OutOfSyncDilemmaHandler getOutOfSyncDilemmaHandler() {
                return this.outOfSyncDilemmaHandler;
            }

            @Override
            public int activeChangeSets(IWorkspaceConnection workspace, Collection<IChangeSetHandle> activeChangeSets) {
                if (activeChangeSets != null) {
                    activeChangeSetsEncountered.add(CoreUtil.translateProblemChangeSetsDTO(workspace, activeChangeSets));
                }
                return activeChangeSetsInstruction;
            }

            @Override
            public int activeChangeSetsComponent(IWorkspaceConnection workspace, IComponentHandle component, Collection<? extends IChangeSetHandle> activeChangeSets) {
                if (activeChangeSetsInComponents != null) {
                    activeChangeSetsInComponents.add(CoreUtil.translateProblemChangeSetsDTO(workspace, activeChangeSets));
                }
                return activeChangeSetsComponentInstruction;
            }

            @Override
            public int activeChangeSetsOverlap(IWorkspaceConnection workspace, Collection<? extends IChangeSetHandle> activeChangeSets) {
                if (activeChangeSetsOverlapEncountered != null) {
                    activeChangeSetsOverlapEncountered.add(CoreUtil.translateProblemChangeSetsDTO(workspace, activeChangeSets));
                }
                return activeChangeSetsOverlapInstruction;
            }

            @Override
            public int gap(IWorkspaceConnection workspace, List<IChangeSetHandle> changeSetsWithGap, boolean handlingSuspended) {
                if (gapEncountered != null) {
                    gapEncountered.add(CoreUtil.translateGapProblemChangeSetsDTO(workspace, changeSetsWithGap, handlingSuspended));
                }
                return gapInstruction;
            }

            @Override
            public BackupDilemmaHandler getBackupDilemmaHandler() {
                return this.sandboxUpdateDilemmaUtil.getBackupDilemmaHandler();
            }

            @Override
            public int deletedContent(Collection<IShareable> contentDeleted) {
                return this.sandboxUpdateDilemmaUtil.deletedContent(contentDeleted);
            }

            @Override
            public int inaccessibleForUpdate(Collection<IShareable> shareables) {
                return this.updateDilemmaUtil.inaccessibleForUpdate(shareables);
            }

            @Override
            public int siblingSharesToAdd(Collection<IShareable> shareables) {
                return this.updateDilemmaUtil.siblingSharesToAdd(shareables);
            }

            @Override
            public IFileContentMerger getFileContentMerger() {
                return this.updateDilemmaUtil.getFileContentMerger();
            }

            @Override
            public void locksWereHeld(Map<IStreamLockReport, IWorkspaceConnection> locks) {
                for (Map.Entry<IStreamLockReport, IWorkspaceConnection> entry : locks.entrySet()) {
                    locksWereHeld.add(CoreUtil.getStreamLockReportDTO(entry.getValue(), entry.getKey()));
                }
            }

            @Override
            public Map<IStreamLockReport, IWorkspaceConnection> locksToAcquire(Map<IStreamLockReport, IWorkspaceConnection> locks) {
                for (Map.Entry<IStreamLockReport, IWorkspaceConnection> entry : locks.entrySet()) {
                    locksToAcquire.add(CoreUtil.getStreamLockReportDTO(entry.getValue(), entry.getKey()));
                }
                return autoAcquireLocks ? locks : Collections.EMPTY_MAP;
            }

            @Override
            public int nWayConflict(IWorkspaceConnection workspaceConnection, IComponent component, List<IBaseline> affectedBaselines, IProgressMonitor monitor) {
                if (component != null) {
                    ComponentDTO compDto = FilesystemRestClientDTOcoreFactory.eINSTANCE.createComponentDTO();
                    compDto.setName(component.getName());
                    compDto.setItemId(component.getItemId().getUuidValue());
                    componentsWithNWayConflicts.add(compDto);
                }
                return nWayConflictInstruction;
            }

            @Override
            public int componentInMultipleHierarchies(IWorkspaceConnection workspaceConnection, Collection<IComponentHandle> selectedComponents, Collection<IComponentHandle> subComponents, IProgressMonitor monitor) {
                ComponentDTO compDto2;
                IComponent component;
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(selectedComponents.size() + subComponents.size()));
                IItemManager itemManager = workspaceConnection.teamRepository().itemManager();
                if (selectedComponentsInMultipleHierarchies != null) {
                    for (IComponentHandle componentHandle : selectedComponents) {
                        if (componentHandle == null) continue;
                        component = null;
                        try {
                            component = (IComponent)itemManager.fetchCompleteItem((IItemHandle)componentHandle, 0, (IProgressMonitor)progress.newChild(1));
                        }
                        catch (TeamRepositoryException teamRepositoryException) {
                            // empty catch block
                        }
                        if (component == null) continue;
                        compDto2 = FilesystemRestClientDTOcoreFactory.eINSTANCE.createComponentDTO();
                        compDto2.setName(component.getName());
                        compDto2.setItemId(component.getItemId().getUuidValue());
                        selectedComponentsInMultipleHierarchies.add(compDto2);
                    }
                }
                if (subcomponentsInMultipleHierarchies != null) {
                    for (IComponentHandle componentHandle : subComponents) {
                        if (componentHandle == null) continue;
                        component = null;
                        try {
                            component = (IComponent)itemManager.fetchCompleteItem((IItemHandle)componentHandle, 0, (IProgressMonitor)progress.newChild(1));
                        }
                        catch (TeamRepositoryException compDto2) {
                            // empty catch block
                        }
                        if (component == null) continue;
                        compDto2 = FilesystemRestClientDTOcoreFactory.eINSTANCE.createComponentDTO();
                        compDto2.setName(component.getName());
                        compDto2.setItemId(component.getItemId().getUuidValue());
                        subcomponentsInMultipleHierarchies.add(compDto2);
                    }
                }
                return componentInMultipleHierarchiesInstruction;
            }

            @Override
            public int noBackupBaselineForComponent(Collection<ConfigurationFacade> configurations, IProgressMonitor monitor) {
                if (noBackupBaselineComponents != null) {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(configurations.size() * 2));
                    for (ConfigurationFacade facade : configurations) {
                        IComponentHandle componentHandle = facade.getComponentHandle();
                        if (componentHandle == null) continue;
                        ComponentDTO compDto = FilesystemRestClientDTOcoreFactory.eINSTANCE.createComponentDTO();
                        IComponent component = null;
                        try {
                            IWorkspaceConnection wc = facade.getWorkspaceConnection((IProgressMonitor)progress.newChild(1));
                            component = (IComponent)wc.teamRepository().itemManager().fetchCompleteItem((IItemHandle)componentHandle, 0, (IProgressMonitor)progress.newChild(1));
                        }
                        catch (TeamRepositoryException teamRepositoryException) {
                            // empty catch block
                        }
                        if (component == null) continue;
                        compDto.setName(component.getName());
                        compDto.setItemId(component.getItemId().getUuidValue());
                        noBackupBaselineComponents.add(compDto);
                    }
                }
                return noBackupBaselineInstruction;
            }

            @Override
            public int inaccessibleComponentsNotInSeedWorkspace(Collection<ConfigurationFacade> configurations, IProgressMonitor monitor) {
                if (inaccessibleComponentsNotInSeed != null) {
                    for (ConfigurationFacade facade : configurations) {
                        IComponentHandle componentHandle = facade.getComponentHandle();
                        ComponentDTO compDto = FilesystemRestClientDTOcoreFactory.eINSTANCE.createComponentDTO();
                        compDto.setItemId(componentHandle.getItemId().getUuidValue());
                        inaccessibleComponentsNotInSeed.add(compDto);
                    }
                }
                return inaccessibleComponentsNotInSeedInstruction;
            }

            @Override
            public boolean isAutoResolveEnabled() {
                return autoResolve;
            }

            @Override
            public AutoResolveConflictsDilemmaHandler getAutoResolveConflictsDilemmaHandler() {
                return this.autoResolveDilemmaHandler;
            }

            @Override
            public void setConflictsAutoResolved(int numberOfConflictsResolved) {
                if (result != null) {
                    result.setNumberConflictsResolved(numberOfConflictsResolved);
                }
            }
        };
        return workspaceUpdateDilemmaHandler;
    }

    private static void recordConfigurationDescriptors(Collection<ConfigurationFacade> configurationDescriptors, List<ConfigurationDescriptorDTO> configurationDescriptorDTOs) {
        if (configurationDescriptorDTOs != null) {
            for (ConfigurationFacade descriptor : configurationDescriptors) {
                configurationDescriptorDTOs.add(CoreUtil.translateConfigurationDescriptor(descriptor));
            }
        }
    }

    public static int getInstruction(String direction, boolean noIsValidDirection, String field) {
        int instruction = 2;
        if ("continue".equals(direction)) {
            instruction = 0;
        } else if (direction == null) {
            instruction = 2;
        } else if ("cancel".equals(direction)) {
            instruction = 1;
        } else if ("fail".equals(direction)) {
            instruction = 2;
        } else if ("no".equals(direction) && noIsValidDirection) {
            instruction = 3;
        } else {
            if (noIsValidDirection) {
                throw new IllegalArgumentException(NLS.bind((String)"Invalid value {0} of {1} must be one of {2}, {3}, {4} or {5}", (Object[])new Object[]{direction, field, "cancel", "continue", "no", "fail"}, (Object[])new Object[0]));
            }
            throw new IllegalArgumentException(NLS.bind((String)"Invalid value {0} of {1} must be one of {2}, {3}, or {4}", (Object[])new Object[]{direction, field, "cancel", "continue", "fail"}, (Object[])new Object[0]));
        }
        return instruction;
    }
}

