/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.rest.util;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.rest.util.CoreUtil;
import com.ibm.team.filesystem.client.internal.rest.util.SandboxUpdateDilemmaUtil;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICollision;
import com.ibm.team.filesystem.client.operations.IRemovedShare;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsOutOfSyncInstructions;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSandboxUpdateDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsVerifyInSync;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareDTO;
import com.ibm.team.filesystem.common.internal.rest.client.dilemma.SandboxUpdateDilemmaDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.FilesystemRestClientDTOsyncFactory;
import com.ibm.team.filesystem.common.internal.rest.client.sync.VerifyInSyncResultDTO;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class VerifyOutOfSyncUtil {
    public static VerifyInSyncResultDTO verifyInSync(ParmsVerifyInSync parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        VerifyInSyncResultDTO result = FilesystemRestClientDTOsyncFactory.eINSTANCE.createVerifyInSyncResultDTO();
        OutOfSyncDilemmaHandler dilemmaHandler = VerifyOutOfSyncUtil.getOutOfSyncDilemmaHandler(parms.outOfSyncInstructions, result.getOutOfSyncShares(), parms.sandboxUpdateDilemmaHandler, result.getSandboxUpdateDilemma(), (IProgressMonitor)monitor.newChild(10));
        IVerifyInSyncOperation verifyOp = IOperationFactory.instance.getVerifyInSyncOperation(dilemmaHandler);
        IWorkspaceConnection workspace = parms.workspace.getWorkspaceConnection((IProgressMonitor)monitor.newChild(1));
        if (parms.componentItemIds == null || parms.componentItemIds.length == 0) {
            verifyOp.addToVerify(workspace);
        } else {
            String[] stringArray = parms.componentItemIds;
            int n = parms.componentItemIds.length;
            int n2 = 0;
            while (n2 < n) {
                String componentItemId = stringArray[n2];
                IComponentHandle componentHandle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((Object)workspace, UUID.valueOf((String)componentItemId), null);
                verifyOp.addToVerify((IConnection)workspace, componentHandle);
                ++n2;
            }
        }
        try {
            verifyOp.run((IProgressMonitor)monitor.newChild(89));
        }
        catch (OperationCanceledException e) {
            result.setCancelled(true);
        }
        return result;
    }

    public static OutOfSyncDilemmaHandler getOutOfSyncDilemmaHandler(ParmsOutOfSyncInstructions outOfSyncInstructions, final List<ShareDTO> sharesOutOfSyncReported, ParmsSandboxUpdateDilemmaHandler sandboxUpdateDilemmaHandler, SandboxUpdateDilemmaDTO sandboxUpdateDilemma, IProgressMonitor monitor) {
        final SubMonitor dilemmaMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (outOfSyncInstructions == null) {
            return OutOfSyncDilemmaHandler.getDefault();
        }
        final SandboxUpdateDilemmaUtil sandboxUpdateDilemmaUtil = new SandboxUpdateDilemmaUtil(sandboxUpdateDilemmaHandler, sandboxUpdateDilemma);
        final int noPendingChangesInstruction = VerifyOutOfSyncUtil.getInstruction(outOfSyncInstructions.outOfSyncNoPendingChanges);
        final int withPendingChangesInstruction = VerifyOutOfSyncUtil.getInstruction(outOfSyncInstructions.outOfSyncWithPendingChanges);
        final boolean removedSharesInstruction = outOfSyncInstructions.deleteRemovedShares == null ? false : outOfSyncInstructions.deleteRemovedShares;
        final boolean preserveLocalChangesInstruction = outOfSyncInstructions.preserveLocalChanges == null ? false : outOfSyncInstructions.preserveLocalChanges;
        OutOfSyncDilemmaHandler outOfSyncDilemmaHandler = new OutOfSyncDilemmaHandler(){

            @Override
            public int outOfSync(Collection<IShareOutOfSync> sharesOutOfSync) {
                if (sharesOutOfSyncReported != null) {
                    dilemmaMonitor.setWorkRemaining(sharesOutOfSync.size());
                    for (IShareOutOfSync shareOutOfSync : sharesOutOfSync) {
                        sharesOutOfSyncReported.add(CoreUtil.translateShare(shareOutOfSync.getShare(), (IProgressMonitor)dilemmaMonitor.newChild(1)));
                    }
                }
                IShare[] shares = new IShare[sharesOutOfSync.size()];
                int i = 0;
                for (IShareOutOfSync shareOutOfSync : sharesOutOfSync) {
                    shares[i] = shareOutOfSync.getShare();
                    ++i;
                }
                ILocalChange[] changes = FileSystemCore.getSharingManager().getLocalChangeManager().getPendingChanges(shares);
                if (changes.length == 0) {
                    return noPendingChangesInstruction;
                }
                return withPendingChangesInstruction;
            }

            @Override
            public boolean willIgnoreAllSharesOutOfSync() {
                return sharesOutOfSyncReported == null && noPendingChangesInstruction == 0 && withPendingChangesInstruction == 0;
            }

            @Override
            public int collision(Collection<ICollision> collisions, Collection<IRemovedShare> removedShares, Collection<IShareOutOfSync> sharesOutOfSync) {
                for (ICollision collision : collisions) {
                    if (collision.getLocations().size() == 1) {
                        collision.setLoadLocation(collision.getLocations().iterator().next());
                        continue;
                    }
                    return 2;
                }
                for (IRemovedShare removedShare : removedShares) {
                    removedShare.isToBeDeleted(removedSharesInstruction);
                }
                return 0;
            }

            @Override
            public BackupDilemmaHandler getBackupDilemmaHandler() {
                return sandboxUpdateDilemmaUtil.getBackupDilemmaHandler();
            }

            @Override
            public int deletedContent(Collection<IShareable> contentDeleted) {
                return sandboxUpdateDilemmaUtil.deletedContent(contentDeleted);
            }

            @Override
            public boolean isPreserveLocalChangesOnLoadOutOfSync() {
                return preserveLocalChangesInstruction;
            }
        };
        return outOfSyncDilemmaHandler;
    }

    private static int getInstruction(String instruction) {
        if ("load".equals(instruction)) {
            return 100;
        }
        if ("cancel".equals(instruction)) {
            return 1;
        }
        if ("continue".equals(instruction)) {
            return 0;
        }
        return 2;
    }
}

