/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.rest.util;

import com.ibm.team.calm.foundation.common.internal.ICALMFoundationRPCService;
import com.ibm.team.calm.foundation.common.internal.rcp.dto.GCInfo_DTO;
import com.ibm.team.calm.foundation.common.internal.rcp.dto.OslcDialog_DTO;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.filesystem.client.IFileSystemView;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IMetadataProperties;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.MetadataProperties;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.gc.ContextUtilities;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreManager;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.internal.rest.IValidatingParameterWrapper;
import com.ibm.team.filesystem.client.internal.rest.util.BackupUtil;
import com.ibm.team.filesystem.client.internal.rest.util.CoreUtil;
import com.ibm.team.filesystem.client.internal.rest.util.IgnoresUtil;
import com.ibm.team.filesystem.client.internal.rest.util.RefreshUtil;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ChangeExtendedPropertiesDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ChangePropertiesDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IChangeExtendedPropertiesOperation;
import com.ibm.team.filesystem.client.operations.IChangeExtendedPropertiesRequest;
import com.ibm.team.filesystem.client.operations.IChangePropertiesOperation;
import com.ibm.team.filesystem.client.operations.IChangePropertiesRequest;
import com.ibm.team.filesystem.client.operations.ILineDelimiterUploadFailure;
import com.ibm.team.filesystem.client.rest.parameters.ParamsAddOSLCLink;
import com.ibm.team.filesystem.client.rest.parameters.ParamsRemoveOSLCLink;
import com.ibm.team.filesystem.client.rest.parameters.ParmsChangeSummary;
import com.ibm.team.filesystem.client.rest.parameters.ParmsGetRelatedArtifacts;
import com.ibm.team.filesystem.client.rest.parameters.ParmsGlobalConfigurationDialog;
import com.ibm.team.filesystem.client.rest.parameters.ParmsInvalidMimeTypeDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsInvalidPropertiesDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLineDelimiterDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLineDelimiterErrorInstructions;
import com.ibm.team.filesystem.client.rest.parameters.ParmsProperty;
import com.ibm.team.filesystem.client.rest.parameters.ParmsResourceProperties;
import com.ibm.team.filesystem.client.rest.parameters.ParmsResourcePropertyChange;
import com.ibm.team.filesystem.client.rest.parameters.ParmsResourcePropertyUpdates;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSandboxPaths;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IChangeSetSummary;
import com.ibm.team.filesystem.common.IChangeSummary;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.common.internal.rest.client.core.PathDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareableDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ChangeSummaryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.CustomAttributesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.FileLinkTypeDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.FilePropertiesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.FilesystemRestClientDTOresourceFactory;
import com.ibm.team.filesystem.common.internal.rest.client.resource.IgnoreReasonDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.InvalidPropertyDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.LineDelimiterErrorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.MimeTypeErrorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.OslcFileLinkDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.PermissionsContextDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.PropertyFailureDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.RelatedArtifactsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ResourcePropertiesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ResourcePropertyChangeResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ResourcesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.SandboxPathsResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.SymlinkPropertiesDTO;
import com.ibm.team.links.common.ILinkTypeHandle;
import com.ibm.team.links.common.LinkTypeExtendedPropertyUtil;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IItemCustomAttributes;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.LinkTypeClientUtils;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.RelatedArtifactsUtils;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IScmService;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.RelatedArtifacts;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.INameItemPair;
import com.ibm.team.scm.common.dto.IVersionablePermissionsReport;
import com.ibm.team.scm.common.internal.gc.Direction;
import com.ibm.team.scm.common.internal.gc.GCUriUtils;
import com.ibm.team.scm.common.internal.gc.OslcFileLink;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.internal.util.StateId;
import com.ibm.team.scm.common.links.CustomLinkTypeInfo;
import com.ibm.team.scm.common.links.ILinkTypeInfo;
import com.ibm.team.scm.common.links.LinkTypeIdentifier;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public class ResourceUtil {
    public static FileLinkTypeDTO[] getAllLinkTypes(String filepath, IProgressMonitor monitor) throws TeamRepositoryException {
        IShareable shareable;
        PathLocation path = new PathLocation((IPath)new Path(filepath));
        SubMonitor submonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ResourceType resourceType = CommonUtil.getResourceType(path, (IProgressMonitor)submonitor.newChild(20));
        if (resourceType == null) {
            resourceType = ResourceType.FILE;
        }
        if ((shareable = SharingManager.getInstance().findShareable(path, resourceType)) == null) {
            throw new TeamRepositoryException("Internal error. The path " + path.toOSString() + " does not fall into a copy file area.");
        }
        IShare share = shareable.getShare((IProgressMonitor)submonitor.newChild(20));
        if (share == null) {
            throw new TeamRepositoryException("Internal error. The path " + path.toOSString() + " is not in a share.");
        }
        ISharingDescriptor descriptor = share.getSharingDescriptor();
        IContextHandle ch = descriptor.getConnectionHandle();
        if (!(ch instanceof IWorkspaceHandle)) {
            return new FileLinkTypeDTO[0];
        }
        IWorkspaceHandle workspacehandle = (IWorkspaceHandle)ch;
        ITeamRepository repo = RepositoryUtils.getTeamRepositoryById(descriptor.getRepositoryId());
        if (repo == null) {
            throw new TeamRepositoryException("Internal error. Can not get repository from the path " + path.toOSString());
        }
        IProjectAreaHandle pa = ContextUtilities.getProjectArea(workspacehandle, repo, (IProgressMonitor)submonitor.newChild(20));
        if (pa == null) {
            throw new TeamRepositoryException("Internal error. The path " + path.toOSString() + " does not lead to project area");
        }
        return ResourceUtil.getAllLinkTypes(pa, (IProgressMonitor)submonitor.newChild(40));
    }

    public static FileLinkTypeDTO[] getAllLinkTypes(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        if (projectArea == null) {
            return new FileLinkTypeDTO[0];
        }
        ITeamRepository repo = (ITeamRepository)projectArea.getOrigin();
        Collection types = LinkTypeClientUtils.getAllLinkTypes((ITeamRepository)repo, (IProjectAreaHandle)projectArea, (IItemType)IFileItem.ITEM_TYPE, (IProgressMonitor)monitor);
        ArrayList allLinkTypes = NewCollection.arrayList();
        for (ILinkType type : types) {
            FileLinkTypeDTO typesDto = FilesystemRestClientDTOresourceFactory.eINSTANCE.createFileLinkTypeDTO();
            typesDto.setLinkTypeID(type.getLinkTypeId());
            ILinkTypeHandle typeHandle = LinkTypeExtendedPropertyUtil.getInstance().getLinkTypeHandle(type);
            typesDto.setLinkTypeInstance(typeHandle.getLinkTypeInstanceId());
            ILinkTypeInfo typeInfo = CustomLinkTypeInfo.create((ILinkType)type);
            typesDto.setLinkTypeLabel(typeInfo.getLabel());
            URI icon = typeInfo.getIconUri();
            if (icon != null) {
                typesDto.setLinkTypeIcon(icon.toString());
            }
            allLinkTypes.add(typesDto);
        }
        return allLinkTypes.toArray(new FileLinkTypeDTO[allLinkTypes.size()]);
    }

    public static OslcDialog_DTO[] getGlobalConfigurationDialogs(ParmsGlobalConfigurationDialog parms, IProgressMonitor progress) throws TeamRepositoryException {
        ArrayList<OslcDialog_DTO> oslcDialogs = new ArrayList<OslcDialog_DTO>();
        if (parms.repositoryUris == null || parms.repositoryUris.length < 1) {
            return oslcDialogs.toArray(new OslcDialog_DTO[oslcDialogs.size()]);
        }
        String[] stringArray = parms.repositoryUris;
        int n = parms.repositoryUris.length;
        int n2 = 0;
        while (n2 < n) {
            GCInfo_DTO gcInfo;
            IClientLibraryContext context;
            ICALMFoundationRPCService gcService;
            String repositoryURI = stringArray[n2];
            ITeamRepository repo = null;
            OslcDialog_DTO gcDialogInfo = null;
            repo = RepositoryUtils.getTeamRepository(repositoryURI);
            if (repo != null && (gcService = (ICALMFoundationRPCService)(context = (IClientLibraryContext)repo).getServiceInterface(ICALMFoundationRPCService.class)) != null && (gcInfo = gcService.getGcUri()) != null) {
                gcDialogInfo = gcInfo.getPickerDialog();
            }
            oslcDialogs.add(gcDialogInfo);
            ++n2;
        }
        return oslcDialogs.toArray(new OslcDialog_DTO[oslcDialogs.size()]);
    }

    public static RelatedArtifactsDTO[] getRelatedArtifacts(ParmsGetRelatedArtifacts parms, IProgressMonitor progress) throws TeamRepositoryException {
        if (parms.gcContext == null || parms.gcContext.isEmpty()) {
            Status status = new Status(4, "com.ibm.team.filesystem.client", Messages.FetchResourceproperties_oslclinks);
            throw new FileSystemStatusException((IStatus)status);
        }
        if (parms.fullResourcePaths != null && parms.fullResourcePaths.length > 0) {
            return ResourceUtil.getRelatedArtifactsFromPaths(parms, progress);
        }
        if (parms.versionables != null && parms.versionables.length > 0) {
            return ResourceUtil.getRelatedArtifactsFromVersionableHandles(parms, progress);
        }
        Status status = new Status(4, "com.ibm.team.filesystem.client", "No files or versionables provided. Must provide valid files or versionables.");
        throw new FileSystemStatusException((IStatus)status);
    }

    private static RelatedArtifactsDTO[] getRelatedArtifactsFromPaths(ParmsGetRelatedArtifacts parms, IProgressMonitor progress) throws TeamRepositoryException {
        ArrayList<IShareable> shareables = new ArrayList<IShareable>(parms.fullResourcePaths.length);
        ArrayList options = NewCollection.arrayList();
        String[] stringArray = parms.options;
        int n = parms.options.length;
        int n2 = 0;
        while (n2 < n) {
            String option = stringArray[n2];
            options.add(option);
            ++n2;
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(options.contains("INCOMING_LINKS") ? parms.fullResourcePaths.length + 3 : parms.fullResourcePaths.length + 2));
        SubMonitor subMonitor = monitor.newChild(1);
        subMonitor.setWorkRemaining(parms.fullResourcePaths.length);
        String[] stringArray2 = parms.fullResourcePaths;
        int n3 = parms.fullResourcePaths.length;
        int n4 = 0;
        while (n4 < n3) {
            String fullResourceStringPath = stringArray2[n4];
            PathLocation path = new PathLocation((IPath)new Path(fullResourceStringPath));
            Object resourceType = CommonUtil.getResourceType(path, (IProgressMonitor)subMonitor.newChild(1));
            if (resourceType == null) {
                resourceType = ResourceType.FILE;
            }
            shareables.add(SharingManager.getInstance().findShareable(path, (ResourceType)((Object)resourceType)));
            ++n4;
        }
        ArrayList versionables = NewCollection.arrayList();
        SharingManager.getInstance().getIgnoreManager().flushInAbsenceOfEvents(shareables, (IProgressMonitor)monitor.newChild(1));
        RelatedArtifactsDTO[] result = new RelatedArtifactsDTO[parms.fullResourcePaths.length];
        HashMap relatedArtifactsInResultMap = NewCollection.hashMap();
        int resultIndex = -1;
        for (IShareable shareable : shareables) {
            FileItemInfo info;
            RelatedArtifactsDTO resource;
            ++resultIndex;
            SubMonitor resourceMonitor = monitor.newChild(1);
            resourceMonitor.setWorkRemaining(100);
            if (shareable == null) continue;
            ResourceType type = shareable.getResourceType((IProgressMonitor)resourceMonitor.newChild(20));
            IShare share = shareable.getShare((IProgressMonitor)resourceMonitor.newChild(15));
            if (share == null) continue;
            IVersionableHandle versionable = shareable.getVersionable((IProgressMonitor)resourceMonitor.newChild(20));
            result[resultIndex] = resource = FilesystemRestClientDTOresourceFactory.eINSTANCE.createRelatedArtifactsDTO();
            if (type != ResourceType.FILE || versionable == null) continue;
            if (shareable.isPresentInRepository((IProgressMonitor)resourceMonitor.newChild(10))) {
                versionables.add(versionable);
                relatedArtifactsInResultMap.put(new StateId((IItemHandle)versionable), resource);
            }
            if ((info = ((Shareable)shareable).getFileItemInfo((IProgressMonitor)resourceMonitor.newChild(10))) == null || !options.contains("OUTGOING_LINKS")) continue;
            RelatedArtifacts links = shareable.getRelatedArtifacts(parms.gcContext, (IProgressMonitor)resourceMonitor.newChild(25));
            resource.getRelatedArtifacts().addAll(ResourceUtil.createOslcFileLinkDTO(links));
        }
        if (options.contains("INCOMING_LINKS")) {
            ITeamRepository repo = RepositoryUtils.getTeamRepository(parms.repositoryURI);
            Map artifacts = RelatedArtifactsUtils.getRelatedArtifacts((Collection)versionables, (URI)GCUriUtils.optionalUri((String)parms.gcContext), (String[])IScmService.FETCH_INCOMING_LINKS_ONLY, (ITeamRepository)repo, (IProgressMonitor)monitor.newChild(1));
            for (Map.Entry entry : artifacts.entrySet()) {
                ((RelatedArtifactsDTO)relatedArtifactsInResultMap.get(entry.getKey())).getRelatedArtifacts().addAll(ResourceUtil.createOslcFileLinkDTO((RelatedArtifacts)entry.getValue()));
            }
        }
        return result;
    }

    public static List<OslcFileLinkDTO> createOslcFileLinkDTO(RelatedArtifacts links) {
        ArrayList result = NewCollection.arrayList();
        if (links != null) {
            for (OslcFileLink link : links.getRelatedArtifacts()) {
                OslcFileLinkDTO oslcLink = FilesystemRestClientDTOresourceFactory.eINSTANCE.createOslcFileLinkDTO();
                oslcLink.setRelatedArtifactUri(link.getRelatedArtifactUrl().toString());
                oslcLink.setOslcRelationshipUri(Objects.toString(link.getOslcRelationshipUri(), null));
                oslcLink.setRelationshipDisplayName(link.getRelationshipDisplayName());
                oslcLink.setRelationshipIcon(Objects.toString(link.getRelationshipIcon(), null));
                oslcLink.setIsOutgoingLink(Boolean.valueOf(link.getDirection() == Direction.Outgoing));
                result.add(oslcLink);
            }
        }
        return result;
    }

    private static RelatedArtifactsDTO[] getRelatedArtifactsFromVersionableHandles(ParmsGetRelatedArtifacts parms, IProgressMonitor progress) throws TeamRepositoryException {
        if (parms.repositoryURI == null) {
            Status status = new Status(4, "com.ibm.team.filesystem.client", "Empty or null repository uri. Must provide a valid repository.");
            throw new FileSystemStatusException((IStatus)status);
        }
        ITeamRepository repo = RepositoryUtils.getTeamRepository(parms.repositoryURI);
        IVersionableHandle[] versionables = parms.getVersionableHandles(repo);
        ArrayList options = NewCollection.arrayList();
        String[] stringArray = parms.options;
        int n = parms.options.length;
        int n2 = 0;
        while (n2 < n) {
            String option = stringArray[n2];
            if (option.equals("INCOMING_LINKS")) {
                options.add("FETCH_INCOMING_LINKS");
            }
            if (option.equals("OUTGOING_LINKS")) {
                options.add("FETCH_OUTGOING_LINKS");
            }
            ++n2;
        }
        Map allArtifacts = RelatedArtifactsUtils.getRelatedArtifacts(Arrays.asList(versionables), (URI)GCUriUtils.optionalUri((String)parms.gcContext), (String[])options.toArray(new String[options.size()]), (ITeamRepository)repo, (IProgressMonitor)progress);
        ArrayList relatedArtifacts = NewCollection.arrayList();
        IVersionableHandle[] iVersionableHandleArray = versionables;
        int n3 = versionables.length;
        int n4 = 0;
        while (n4 < n3) {
            IVersionableHandle v = iVersionableHandleArray[n4];
            StateId stateId = new StateId((IItemHandle)v);
            RelatedArtifactsDTO resource = FilesystemRestClientDTOresourceFactory.eINSTANCE.createRelatedArtifactsDTO();
            relatedArtifacts.add(resource);
            resource.getRelatedArtifacts().addAll(ResourceUtil.createOslcFileLinkDTO((RelatedArtifacts)allArtifacts.get(stateId)));
            ++n4;
        }
        return relatedArtifacts.toArray(new RelatedArtifactsDTO[relatedArtifacts.size()]);
    }

    public static ResourcesDTO getResourceProperties(ParmsResourceProperties parms, IProgressMonitor progress) throws TeamRepositoryException {
        boolean computeFully;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(2 * parms.fullResourcePaths.length + 1));
        boolean bl = computeFully = parms.computeFully != null && parms.computeFully != false;
        if (computeFully) {
            monitor.setWorkRemaining(parms.fullResourcePaths.length * 3);
        }
        HashMap<ConfigurationFacade, ArrayList<ResourcePropertiesDTO>> sharePaths = new HashMap<ConfigurationFacade, ArrayList<ResourcePropertiesDTO>>();
        ArrayList<IShareable> shareables = new ArrayList<IShareable>(parms.fullResourcePaths.length);
        String[] stringArray = parms.fullResourcePaths;
        int n = parms.fullResourcePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String fullResourceStringPath = stringArray[n2];
            PathLocation path = new PathLocation((IPath)new Path(fullResourceStringPath));
            ResourceType resourceType = CommonUtil.getResourceType(path, (IProgressMonitor)monitor.newChild(1));
            if (resourceType == null) {
                resourceType = ResourceType.FILE;
            }
            shareables.add(SharingManager.getInstance().findShareable(path, resourceType));
            ++n2;
        }
        SharingManager.getInstance().getIgnoreManager().flushInAbsenceOfEvents(shareables, (IProgressMonitor)monitor.newChild(1));
        ResourcesDTO resources = FilesystemRestClientDTOresourceFactory.eINSTANCE.createResourcesDTO();
        int path = 0;
        for (IShareable iShareable : shareables) {
            SubMonitor resourceMonitor = monitor.newChild(1);
            resourceMonitor.setWorkRemaining(100);
            ResourcePropertiesDTO resourceProperties = FilesystemRestClientDTOresourceFactory.eINSTANCE.createResourcePropertiesDTO();
            resources.getResourceProperties().add(resourceProperties);
            resourceProperties.setFullPath(parms.fullResourcePaths[path++]);
            if (iShareable != null) {
                resourceProperties.setPath(CoreUtil.translateShareable(iShareable));
                ResourceType type = iShareable.getResourceType((IProgressMonitor)resourceMonitor.newChild(5));
                resourceProperties.setLocal(type != null);
                IShare share = iShareable.getShare((IProgressMonitor)resourceMonitor.newChild(10));
                resourceProperties.setShared(share != null);
                if (!resourceProperties.isShared()) {
                    resourceProperties.setRemote(false);
                } else {
                    FileItemInfo info;
                    IVersionableHandle versionable;
                    assert (share != null);
                    ISharingDescriptor descriptor = share.getSharingDescriptor();
                    resourceProperties.setShare(CoreUtil.translateShare(share, (IProgressMonitor)resourceMonitor.newChild(5)));
                    resourceProperties.setIgnored(iShareable.shouldBeIgnored((IProgressMonitor)resourceMonitor.newChild(10)));
                    if (computeFully && resourceProperties.isIgnored()) {
                        ResourceUtil.getResourceIgnoreProperties(iShareable, resourceProperties, resourceMonitor.newChild(10));
                    }
                    if ((versionable = iShareable.getVersionable((IProgressMonitor)resourceMonitor.newChild(15))) == null) {
                        resourceProperties.setRemote(false);
                    } else {
                        resourceProperties.setItemId(versionable.getItemId().getUuidValue());
                        resourceProperties.setVersionableItemType(CoreUtil.getVersionableItemType(versionable));
                        if (versionable.hasStateId()) {
                            ITeamRepository repo;
                            resourceProperties.setStateId(versionable.getStateId().getUuidValue());
                            resourceProperties.setRemote(true);
                            if (computeFully && (repo = RepositoryUtils.getTeamRepositoryById(descriptor.getRepositoryId())) != null) {
                                ConfigurationFacade configDescriptor = new ConfigurationFacade(repo, descriptor.getConnectionHandle(), descriptor.getComponent());
                                ArrayList<ResourcePropertiesDTO> properties = (ArrayList<ResourcePropertiesDTO>)sharePaths.get((Object)configDescriptor);
                                if (properties == null) {
                                    properties = new ArrayList<ResourcePropertiesDTO>();
                                    sharePaths.put(configDescriptor, properties);
                                }
                                properties.add(resourceProperties);
                            }
                        } else {
                            resourceProperties.setRemote(false);
                        }
                    }
                    ILocalChange pendingChange = LocalChangeManager.getInstance().getPendingChange(iShareable, (IProgressMonitor)resourceMonitor.newChild(15));
                    resourceProperties.setDirty(pendingChange.getType() != 0);
                    IMetadataProperties userProperties = iShareable.getMetadataProperties((IProgressMonitor)resourceMonitor.newChild(5));
                    if (type == ResourceType.FILE) {
                        resourceProperties.setVersionableItemType("file");
                        info = ((Shareable)iShareable).getFileItemInfo((IProgressMonitor)resourceMonitor.newChild(10));
                        if (info != null) {
                            FilePropertiesDTO fileProperties = FilesystemRestClientDTOresourceFactory.eINSTANCE.createFilePropertiesDTO();
                            fileProperties.setContentType(info.getContentType());
                            if (info.getLineDelimiter() != null) {
                                fileProperties.setLineDelimiter(info.getLineDelimiter().toString());
                            }
                            fileProperties.setOriginalContentType(info.getOriginalContentType());
                            if (info.getOriginalLineDelimiter() != null) {
                                fileProperties.setOriginalLineDelimiter(info.getOriginalLineDelimiter().toString());
                            }
                            fileProperties.setExecutable(iShareable.isExecutable((IProgressMonitor)resourceMonitor.newChild(10)));
                            try {
                                fileProperties.setEncoding(SharingManager.getInstance().getContentExaminer(iShareable).getEncoding(iShareable, (IProgressMonitor)resourceMonitor.newChild(5)));
                            }
                            catch (FileSystemException fileSystemException) {
                                // empty catch block
                            }
                            fileProperties.setOriginalExecutable(info.isOriginalExecutable());
                            fileProperties.setOriginalEncoding(info.getStoredEncoding());
                            resourceProperties.setFileProperties(fileProperties);
                        }
                    } else if (type == ResourceType.FOLDER) {
                        resourceProperties.setVersionableItemType("folder");
                    } else if (type == ResourceType.SYMBOLIC_LINK) {
                        info = ((Shareable)iShareable).getFileItemInfo((IProgressMonitor)resourceMonitor.newChild(10));
                        resourceProperties.setVersionableItemType("symbolic_link");
                        SymlinkPropertiesDTO symlinkProperties = FilesystemRestClientDTOresourceFactory.eINSTANCE.createSymlinkPropertiesDTO();
                        if (info != null) {
                            symlinkProperties.setType(info.isDirectoryLink() ? "directory" : "file");
                        } else {
                            symlinkProperties.setType("file");
                        }
                        resourceProperties.setSymlinkProperties(symlinkProperties);
                    }
                    resourceProperties.getUserProperties().putAll(userProperties.getCurrentProperties());
                }
            }
            resourceMonitor.done();
        }
        if (computeFully) {
            monitor = monitor.setWorkRemaining(sharePaths.size() * 30);
            for (Map.Entry entry : sharePaths.entrySet()) {
                IVersionablePermissionsReport[] permissions;
                IConfiguration configuration = ((ConfigurationFacade)((Object)entry.getKey())).getConfiguration((IProgressMonitor)monitor.newChild(10));
                ITeamRepository repository = configuration == null ? null : configuration.teamRepository();
                List properties = (List)entry.getValue();
                ArrayList<Object> versionables = new ArrayList<Object>(properties.size());
                for (ResourcePropertiesDTO resourceProperties : properties) {
                    if ("folder".equals(resourceProperties.getVersionableItemType())) {
                        versionables.add((IFolderHandle)IFolder.ITEM_TYPE.createItemHandle((Object)repository, UUID.valueOf((String)resourceProperties.getItemId()), null));
                    } else if ("file".equals(resourceProperties.getVersionableItemType())) {
                        versionables.add((IFileItemHandle)IFileItem.ITEM_TYPE.createItemHandle((Object)repository, UUID.valueOf((String)resourceProperties.getItemId()), null));
                    } else if ("symbolic_link".equals(resourceProperties.getVersionableItemType())) {
                        versionables.add((ISymbolicLinkHandle)ISymbolicLink.ITEM_TYPE.createItemHandle((Object)repository, UUID.valueOf((String)resourceProperties.getItemId()), null));
                    }
                    PermissionsContextDTO context = FilesystemRestClientDTOresourceFactory.eINSTANCE.createPermissionsContextDTO();
                    context.setAccessible(true);
                    resourceProperties.setPermissionsContext(context);
                }
                if (configuration == null || versionables.isEmpty()) continue;
                List ancestors = configuration.locateAncestors(versionables, (IProgressMonitor)monitor.newChild(15));
                int i = 0;
                for (IAncestorReport report : ancestors) {
                    ResourcePropertiesDTO resourceProperties = (ResourcePropertiesDTO)properties.get(i);
                    ++i;
                    if (report.getNameItemPairs().isEmpty()) continue;
                    resourceProperties.setRemotePath(CoreUtil.translatePath(report));
                }
                IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
                IVersionablePermissionsReport[] iVersionablePermissionsReportArray = permissions = wm.getPermissions(versionables.toArray(new IVersionableHandle[versionables.size()]), configuration.component(), (IProgressMonitor)monitor.newChild(5));
                int n3 = permissions.length;
                int n4 = 0;
                while (n4 < n3) {
                    IVersionablePermissionsReport report = iVersionablePermissionsReportArray[n4];
                    if (report.getContext() != null) {
                        for (ResourcePropertiesDTO rp : properties) {
                            if (!report.getItemsIds().contains(UUID.valueOf((String)rp.getItemId()))) continue;
                            rp.getPermissionsContext().setReadContext(report.getContext().getReadContext());
                        }
                    } else if (report.isReportOfInaccessible()) {
                        for (ResourcePropertiesDTO rp : properties) {
                            if (!report.getItemsIds().contains(UUID.valueOf((String)rp.getItemId()))) continue;
                            rp.getPermissionsContext().setAccessible(false);
                        }
                    }
                    ++n4;
                }
            }
        }
        return resources;
    }

    public static String getRemoteFullPath(IShareable target, IProgressMonitor monitor) throws FileSystemException {
        IVersionableHandle h;
        String remotePath = null;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IShare share = target.getShare((IProgressMonitor)progress.newChild(1));
        if (share != null && (h = target.getRemote((IProgressMonitor)progress.newChild(1))) != null) {
            ISharingDescriptor sharingDescriptor = share.getSharingDescriptor();
            try {
                IAncestorReport ancestors;
                ConfigurationFacade descriptor;
                IConfiguration configuration;
                ITeamRepository repo = RepositoryUtils.getTeamRepositoryById(sharingDescriptor.getRepositoryId());
                if (repo != null && (configuration = (descriptor = new ConfigurationFacade(repo, sharingDescriptor.getConnectionHandle(), sharingDescriptor.getComponent())).getConfiguration((IProgressMonitor)progress.newChild(8))) != null && !(ancestors = (IAncestorReport)configuration.locateAncestors(Collections.singletonList(h), (IProgressMonitor)progress.newChild(90)).get(0)).getNameItemPairs().isEmpty()) {
                    StringBuilder builder = new StringBuilder();
                    Iterator iterator = ancestors.getNameItemPairs().iterator();
                    iterator.next();
                    while (iterator.hasNext()) {
                        INameItemPair nameItemPair = (INameItemPair)iterator.next();
                        builder.append('/');
                        builder.append(nameItemPair.getName());
                    }
                    remotePath = builder.length() == 0 ? "/" : builder.toString();
                }
            }
            catch (TeamRepositoryException teamRepositoryException) {
                // empty catch block
            }
        }
        return remotePath;
    }

    private static void getResourceIgnoreProperties(IShareable shareable, ResourcePropertiesDTO resourceProperties, SubMonitor monitor) {
        IIgnoreManager.IIgnoreReason reasons;
        try {
            reasons = IgnoreManager.getInstance().findIgnoreReasons(shareable, (IProgressMonitor)monitor);
        }
        catch (FileSystemException e) {
            return;
        }
        if (reasons == null) {
            return;
        }
        IgnoreReasonDTO reasonDTO = FilesystemRestClientDTOresourceFactory.eINSTANCE.createIgnoreReasonDTO();
        PathDTO inheritPath = null;
        if (reasons.inherited()) {
            inheritPath = CoreUtil.translatePath(reasons.inheritsFrom().getLocalPath());
        }
        reasonDTO.setInheritsFrom(inheritPath);
        for (IIgnoreProvider.IIgnoreRule rule : reasons.getRules()) {
            reasonDTO.getRules().add(IgnoresUtil.translateRule(rule));
        }
        resourceProperties.setIgnoreReason(reasonDTO);
    }

    private static int getDirection(String direction) {
        if ("cancel".equals(direction)) {
            return 1;
        }
        if ("continue".equals(direction)) {
            return 0;
        }
        return 2;
    }

    public static ChangePropertiesDilemmaHandler getChangePropertiesDilemmaHandler(ParmsLineDelimiterDilemmaHandler lineDelimiterDilemmaHandler, List<LineDelimiterErrorDTO> lineDelimiterErrorsReported, ParmsInvalidPropertiesDilemmaHandler invalidPropertiesDilemmaHandler, List<PropertyFailureDTO> propertyFailuresReported, ParmsInvalidMimeTypeDilemmaHandler invalidMimeTypeDilemmaHandler, List<MimeTypeErrorDTO> mimeTypeFailuresReported, BackupDilemmaHandler backupDilemmaHandler) {
        int invalidPropertyDirection = ResourceUtil.getInvalidPropertyDirection(invalidPropertiesDilemmaHandler);
        int invalidMimeTypeDirection = ResourceUtil.getInvalidMimeTypeDirection(invalidMimeTypeDilemmaHandler);
        return ResourceUtil.getChangePropertiesDilemmaHandler(lineDelimiterDilemmaHandler, lineDelimiterErrorsReported, invalidPropertyDirection, propertyFailuresReported, invalidMimeTypeDirection, mimeTypeFailuresReported, null, backupDilemmaHandler);
    }

    private static ChangeExtendedPropertiesDilemmaHandler getChangeExtendedPropertiesDilemmaHandler(final int invalidPropertyDirection, final List<PropertyFailureDTO> propertyFailuresReported, final BackupDilemmaHandler backupDilemmaHandler) {
        ChangeExtendedPropertiesDilemmaHandler dilemmaHandler = new ChangeExtendedPropertiesDilemmaHandler(){

            @Override
            public int invalidProperties(List<? extends IChangeExtendedPropertiesRequest> invalidPropertyChangeRequests, IProgressMonitor monitor) throws FileSystemException {
                if (propertyFailuresReported != null) {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)invalidPropertyChangeRequests.size());
                    for (IChangeExtendedPropertiesRequest iChangeExtendedPropertiesRequest : invalidPropertyChangeRequests) {
                        SubMonitor subProgress = progress.newChild(1).setWorkRemaining(100);
                        Map<String, IStatus> invalidProperties = iChangeExtendedPropertiesRequest.getInvalidProperties();
                        propertyFailuresReported.add(ResourceUtil.translatePropertyFailure(iChangeExtendedPropertiesRequest.getShareableToChange(), invalidProperties, (IProgressMonitor)subProgress.newChild(70)));
                    }
                }
                return invalidPropertyDirection;
            }

            @Override
            public BackupDilemmaHandler getBackupDilemmaHandler() {
                return backupDilemmaHandler;
            }
        };
        return dilemmaHandler;
    }

    private static ChangePropertiesDilemmaHandler getChangePropertiesDilemmaHandler(ParmsLineDelimiterDilemmaHandler lineDelimiterDilemmaHandler, List<LineDelimiterErrorDTO> lineDelimiterErrorsReported, final int invalidPropertyDirection, final List<PropertyFailureDTO> propertyFailuresReported, final int invalidMimeTypeDirection, final List<MimeTypeErrorDTO> mimeTypeFailuresReported, final List<ShareableDTO> executableFailuresReported, final BackupDilemmaHandler backupDilemmaHandler) {
        final LineDelimiterErrorHandler lineDelimiterErrorHandler = new LineDelimiterErrorHandler(lineDelimiterDilemmaHandler, lineDelimiterErrorsReported);
        ChangePropertiesDilemmaHandler dilemmaHandler = new ChangePropertiesDilemmaHandler(){

            @Override
            public int inconsistentLineDelimiters(List<? extends IChangePropertiesRequest> inconsistentDelimiters, IProgressMonitor monitor) throws FileSystemException {
                return lineDelimiterErrorHandler.inconsistentLineDelimiters(inconsistentDelimiters, monitor);
            }

            @Override
            public int invalidProperties(List<? extends IChangePropertiesRequest> invalidPropertyChangeRequests, IProgressMonitor monitor) throws FileSystemException {
                if (propertyFailuresReported != null) {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)invalidPropertyChangeRequests.size());
                    for (IChangePropertiesRequest iChangePropertiesRequest : invalidPropertyChangeRequests) {
                        SubMonitor subProgress = progress.newChild(1).setWorkRemaining(100);
                        Map<String, IStatus> invalidProperties = iChangePropertiesRequest.getInvalidProperties();
                        propertyFailuresReported.add(ResourceUtil.translatePropertyFailure(iChangePropertiesRequest.getShareableToChange(), invalidProperties, (IProgressMonitor)subProgress.newChild(70)));
                    }
                }
                return invalidPropertyDirection;
            }

            @Override
            public int invalidContentTypes(List<? extends IChangePropertiesRequest> invalidContentTypeChangeRequests, IProgressMonitor monitor) throws FileSystemException {
                if (mimeTypeFailuresReported != null) {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)invalidContentTypeChangeRequests.size());
                    for (IChangePropertiesRequest iChangePropertiesRequest : invalidContentTypeChangeRequests) {
                        SubMonitor subProgress = progress.newChild(1).setWorkRemaining(100);
                        String invalidMineType = iChangePropertiesRequest.getContentType((IProgressMonitor)subProgress.newChild(30));
                        mimeTypeFailuresReported.add(ResourceUtil.translateMineTypeFailure(iChangePropertiesRequest.getShareableToChange(), invalidMineType, (IProgressMonitor)subProgress.newChild(70)));
                    }
                }
                return invalidMimeTypeDirection;
            }

            @Override
            public void executableFailures(List<? extends IChangePropertiesRequest> executableChangeRequests, IProgressMonitor monitor) throws FileSystemException {
                if (executableFailuresReported != null) {
                    for (IChangePropertiesRequest iChangePropertiesRequest : executableChangeRequests) {
                        executableFailuresReported.add(CoreUtil.translateShareable(iChangePropertiesRequest.getShareableToChange()));
                    }
                }
            }

            @Override
            public BackupDilemmaHandler getBackupDilemmaHandler() {
                return backupDilemmaHandler;
            }
        };
        return dilemmaHandler;
    }

    protected static PropertyFailureDTO translatePropertyFailure(IShareable shareable, Map<String, IStatus> invalidProperties, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        PropertyFailureDTO propertyFailure = FilesystemRestClientDTOresourceFactory.eINSTANCE.createPropertyFailureDTO();
        propertyFailure.setFileName(CoreUtil.translatePath(shareable.getLocalPath()));
        propertyFailure.setShare(CoreUtil.translateShare(shareable.getShare((IProgressMonitor)progress.newChild(55)), (IProgressMonitor)progress.newChild(45)));
        for (Map.Entry<String, IStatus> entry : invalidProperties.entrySet()) {
            InvalidPropertyDTO invalidProperty = FilesystemRestClientDTOresourceFactory.eINSTANCE.createInvalidPropertyDTO();
            invalidProperty.setPropertyName(entry.getKey());
            invalidProperty.setReason(entry.getValue().getMessage());
            propertyFailure.getInvalidProperties().add(invalidProperty);
        }
        return propertyFailure;
    }

    protected static MimeTypeErrorDTO translateMineTypeFailure(IShareable shareable, String invalidMimeType, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        MimeTypeErrorDTO mimeTypeFailure = FilesystemRestClientDTOresourceFactory.eINSTANCE.createMimeTypeErrorDTO();
        mimeTypeFailure.setFileName(CoreUtil.translatePath(shareable.getLocalPath()));
        mimeTypeFailure.setShare(CoreUtil.translateShare(shareable.getShare((IProgressMonitor)progress.newChild(55)), (IProgressMonitor)progress.newChild(45)));
        mimeTypeFailure.setMimeType(invalidMimeType);
        return mimeTypeFailure;
    }

    public static LineDelimiterErrorDTO translateLineDelimiterError(IShareable shareable, FileLineDelimiter incompatibleLineDelimiterSetting, IProgressMonitor monitor) throws FileSystemException {
        return ResourceUtil.translateLineDelimiterError(null, shareable, incompatibleLineDelimiterSetting, monitor);
    }

    public static LineDelimiterErrorDTO translateLineDelimiterError(String reason, IShareable shareable, FileLineDelimiter incompatibleLineDelimiterSetting, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        LineDelimiterErrorDTO failedUpload = FilesystemRestClientDTOresourceFactory.eINSTANCE.createLineDelimiterErrorDTO();
        failedUpload.setFileName(CoreUtil.translatePath(shareable.getLocalPath()));
        failedUpload.setShare(CoreUtil.translateShare(shareable.getShare((IProgressMonitor)progress.newChild(55)), (IProgressMonitor)progress.newChild(45)));
        if (reason != null) {
            failedUpload.setReason(reason);
        }
        if (incompatibleLineDelimiterSetting != null) {
            failedUpload.setLineDelimiter(ResourceUtil.getLineDelimiter(incompatibleLineDelimiterSetting));
        }
        return failedUpload;
    }

    public static ResourcePropertyChangeResultDTO postResourceProperties(ParmsResourcePropertyUpdates parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        ResourcePropertyChangeResultDTO result = FilesystemRestClientDTOresourceFactory.eINSTANCE.createResourcePropertyChangeResultDTO();
        BackupDilemmaHandler backupDilemmaHandler = BackupUtil.getBackupDilemmaHandler(parms.backupDilemmaHandler, result.getBackedUpToShed());
        int invalidPropertyDirection = ResourceUtil.getInvalidPropertyDirection(parms.invalidPropertiesDilemmaHandler);
        int invalidMimeTypeDirection = ResourceUtil.getInvalidMimeTypeDirection(parms.invalidMimeTypeDilemmaHandler);
        ChangePropertiesDilemmaHandler dilemmaHandler = ResourceUtil.getChangePropertiesDilemmaHandler(parms.lineDelimiterDilemmaHandler, result.getLineDelimiterFailures(), invalidPropertyDirection, result.getPropertyFailures(), invalidMimeTypeDirection, result.getMimeTypeFailures(), result.getExecutableFailures(), backupDilemmaHandler);
        try {
            IChangePropertiesOperation op = ResourceUtil.prepareChangePropertyOperation(parms, invalidPropertyDirection, dilemmaHandler, result, (IProgressMonitor)monitor.newChild(10));
            op.run((IProgressMonitor)monitor.newChild(90));
        }
        catch (OperationCanceledException e) {
            result.setCancelled(true);
        }
        return result;
    }

    private static int getInvalidPropertyDirection(ParmsInvalidPropertiesDilemmaHandler invalidPropertiesDilemmaHandler) {
        int invalidPropertyDirection = invalidPropertiesDilemmaHandler == null ? 2 : ResourceUtil.getDirection(invalidPropertiesDilemmaHandler.generalInstruction);
        return invalidPropertyDirection;
    }

    private static int getInvalidMimeTypeDirection(ParmsInvalidMimeTypeDilemmaHandler parmsInvalidMimeTypeDilemmaHandler) {
        int invalidMimeTypeDirection = parmsInvalidMimeTypeDilemmaHandler == null ? 2 : ResourceUtil.getDirection(parmsInvalidMimeTypeDilemmaHandler.generalInstruction);
        return invalidMimeTypeDirection;
    }

    private static IChangePropertiesOperation prepareChangePropertyOperation(ParmsResourcePropertyUpdates parms, int invalidPropertyDirection, ChangePropertiesDilemmaHandler dilemmaHandler, ResourcePropertyChangeResultDTO result, IProgressMonitor progress) throws TeamRepositoryException, FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(5 * parms.resourcePropertyChanges.length));
        IChangePropertiesOperation op = IOperationFactory.instance.getChangePropertiesOperation(dilemmaHandler);
        RefreshUtil.configureRefresh(parms.preOpRefresh, op);
        ParmsResourcePropertyChange[] parmsResourcePropertyChangeArray = parms.resourcePropertyChanges;
        int n = parms.resourcePropertyChanges.length;
        int n2 = 0;
        while (n2 < n) {
            OslcFileLink link2;
            int n3;
            ParmsResourcePropertyChange propertyChangeRequest = parmsResourcePropertyChangeArray[n2];
            IShareable shareable = ResourceUtil.findShareableFor(propertyChangeRequest.sandboxPath, propertyChangeRequest.filePath, (IProgressMonitor)monitor.newChild(1));
            if (propertyChangeRequest.lineDelimiter != null && propertyChangeRequest.lineDelimiter.length() > 0) {
                FileLineDelimiter lineDelimiter = ResourceUtil.getLineDelimiter(propertyChangeRequest.lineDelimiter);
                op.setLineDelimiter(shareable, lineDelimiter);
            }
            if (propertyChangeRequest.linkType != null) {
                op.setIsDirectoryLink(shareable, "directory".equals(propertyChangeRequest.linkType));
            }
            if (propertyChangeRequest.mimeType != null && propertyChangeRequest.mimeType.length() > 0) {
                op.setContentType(shareable, propertyChangeRequest.mimeType);
            }
            if (propertyChangeRequest.executable != null) {
                op.setExecutable(shareable, propertyChangeRequest.executable);
            }
            if (propertyChangeRequest.oslcLinksAdditions != null || propertyChangeRequest.oslcLinksRemovals != null) {
                IValidatingParameterWrapper oslcLink;
                int n4;
                IValidatingParameterWrapper[] iValidatingParameterWrapperArray;
                if (propertyChangeRequest.oslcLinksAdditions != null) {
                    iValidatingParameterWrapperArray = propertyChangeRequest.oslcLinksAdditions;
                    n3 = propertyChangeRequest.oslcLinksAdditions.length;
                    n4 = 0;
                    while (n4 < n3) {
                        oslcLink = iValidatingParameterWrapperArray[n4];
                        op.addExternalLink(shareable, LinkTypeIdentifier.createFromLinkTypeIdAndInstance((String)((ParamsAddOSLCLink)oslcLink).linkTypeID, (String)((ParamsAddOSLCLink)oslcLink).linkTypeInstanceId), URI.create(((ParamsAddOSLCLink)oslcLink).relatedArtifactUri));
                        ++n4;
                    }
                }
                if (propertyChangeRequest.oslcLinksRemovals != null) {
                    iValidatingParameterWrapperArray = propertyChangeRequest.oslcLinksRemovals;
                    n3 = propertyChangeRequest.oslcLinksRemovals.length;
                    n4 = 0;
                    while (n4 < n3) {
                        oslcLink = iValidatingParameterWrapperArray[n4];
                        link2 = OslcFileLink.create((URI)URI.create(((ParamsRemoveOSLCLink)oslcLink).relatedArtifactUri), (String)"", null, (URI)URI.create(((ParamsRemoveOSLCLink)oslcLink).oslcRelationshipUri), (Direction)Direction.Outgoing);
                        op.removeExternalLink(shareable, link2, (IProgressMonitor)monitor.newChild(1));
                        ++n4;
                    }
                }
            }
            if (propertyChangeRequest.replacementProperties != null) {
                HashMap<String, String> properties = new HashMap<String, String>();
                link2 = propertyChangeRequest.replacementProperties;
                int n5 = ((ParmsProperty[])link2).length;
                n3 = 0;
                while (n3 < n5) {
                    ParmsProperty property = link2[n3];
                    properties.put(property.propertyName, property.propertyValue);
                    ++n3;
                }
                op.setProperties(shareable, properties);
            } else if (propertyChangeRequest.propertyChanges != null || propertyChangeRequest.propertyRemovals != null) {
                int n6;
                IMetadataProperties current = shareable.getMetadataProperties((IProgressMonitor)monitor.newChild(1));
                HashMap<String, String> changes = new HashMap<String, String>();
                HashSet<String> removals = new HashSet<String>();
                if (propertyChangeRequest.propertyChanges != null) {
                    ParmsProperty[] parmsPropertyArray = propertyChangeRequest.propertyChanges;
                    n6 = propertyChangeRequest.propertyChanges.length;
                    int link2 = 0;
                    while (link2 < n6) {
                        ParmsProperty property = parmsPropertyArray[link2];
                        changes.put(property.propertyName, property.propertyValue);
                        ++link2;
                    }
                }
                HashMap<String, IStatus> badProperties = new HashMap<String, IStatus>();
                if (propertyChangeRequest.propertyRemovals != null) {
                    String[] stringArray = propertyChangeRequest.propertyRemovals;
                    int n7 = propertyChangeRequest.propertyRemovals.length;
                    n6 = 0;
                    while (n6 < n7) {
                        String property = stringArray[n6];
                        IStatus status = op.validatePropertyName(property);
                        if (!status.isOK()) {
                            badProperties.put(property, status);
                        } else {
                            removals.add(property);
                        }
                        ++n6;
                    }
                }
                if (!badProperties.isEmpty()) {
                    result.getPropertyFailures().add(ResourceUtil.translatePropertyFailure(shareable, badProperties, (IProgressMonitor)monitor.newChild(1)));
                    if (invalidPropertyDirection == 1) {
                        throw new OperationCanceledException();
                    }
                    if (invalidPropertyDirection != 0) {
                        MultiStatus status = new MultiStatus("com.ibm.team.filesystem.client", 0, badProperties.values().toArray(new IStatus[badProperties.size()]), NLS.bind((String)Messages.ResourceUtil_2, (Object)shareable.getLocalPath().toString(), (Object[])new Object[0]), null);
                        throw new FileSystemStatusException((IStatus)status);
                    }
                }
                MetadataProperties delta = new MetadataProperties(current.getCurrentProperties(), changes, removals);
                op.setProperties(shareable, delta.getCurrentProperties());
            }
            ++n2;
        }
        return op;
    }

    private static FileLineDelimiter getLineDelimiter(String lineDelimiterSetting) {
        return CoreUtil.getLineDelimiter(lineDelimiterSetting);
    }

    private static String getLineDelimiter(FileLineDelimiter lineDelimiterSetting) {
        return CoreUtil.getLineDelimiter(lineDelimiterSetting);
    }

    public static IShareable findShareableFor(String sandboxPath, String path, IProgressMonitor progress) throws TeamRepositoryException, FileSystemException {
        ISandbox sandbox = SharingManager.getInstance().getSandbox(new PathLocation((IPath)new Path(sandboxPath)), true);
        if (sandbox == null) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.ResourceUtil_0, (Object)sandboxPath, (Object[])new Object[0]));
        }
        RelativeLocation resourcePath = new RelativeLocation(new Path(path).segments());
        ResourceType resourceType = CommonUtil.getResourceType(sandbox.getRoot().append(path), progress);
        if (resourceType == null) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.ResourceUtil_1, (Object)path, (Object[])new Object[0]));
        }
        return sandbox.findShareable(resourcePath, resourceType);
    }

    public static SandboxPathsResultDTO getSandboxPaths(ParmsSandboxPaths parms, IProgressMonitor progress) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)parms.pathsToResolve.length);
        SandboxPathsResultDTO result = FilesystemRestClientDTOresourceFactory.eINSTANCE.createSandboxPathsResultDTO();
        ICopyFileAreaManager cfaMgr = ICopyFileAreaManager.instance;
        SharingManager sm = SharingManager.getInstance();
        String[] stringArray = parms.pathsToResolve;
        int n = parms.pathsToResolve.length;
        int n2 = 0;
        while (n2 < n) {
            IShareable shareable;
            ResourceType resourceType;
            String completePath = stringArray[n2];
            PathLocation path = new PathLocation((IPath)new Path(completePath));
            try {
                resourceType = CommonUtil.getResourceType(path, (IProgressMonitor)monitor.newChild(1));
                if (resourceType == null) {
                    resourceType = ResourceType.FILE;
                }
            }
            catch (FileSystemException e) {
                resourceType = ResourceType.FILE;
            }
            if ((shareable = sm.findShareable(path, resourceType)) == null && cfaMgr.copyFileAreaExists(path, 0)) {
                shareable = new Shareable(path, (IRelativeLocation)RelativeLocation.EMPTY_LOCATION, ResourceType.FOLDER);
            }
            if (shareable == null && parms.includeNonRegisteredSandboxes) {
                ILocation sandboxPath = path;
                IRelativeLocation relativePath = RelativeLocation.EMPTY_LOCATION;
                while (!sandboxPath.isEmpty() && shareable == null) {
                    if (cfaMgr.copyFileAreaExists(sandboxPath, 2)) {
                        relativePath = path.getLocationRelativeTo(sandboxPath);
                        shareable = new Shareable(sandboxPath, relativePath, resourceType);
                        continue;
                    }
                    sandboxPath = sandboxPath.getParent();
                }
            }
            result.getPaths().add(CoreUtil.translateShareable(shareable));
            monitor.worked(1);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            ++n2;
        }
        return result;
    }

    public static ChangeSummaryDTO getChangeSummary(ParmsChangeSummary parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        ChangeSummaryDTO result = FilesystemRestClientDTOresourceFactory.eINSTANCE.createChangeSummaryDTO();
        IWorkspaceConnection wc = parms.workspace.getWorkspaceConnection((IProgressMonitor)monitor.newChild(10));
        ITeamRepository repo = wc.teamRepository();
        IChangeSetHandle handle = CommonUtil.createChangeSetHandle(repo, parms.changeSetItemId);
        IChangeSet changeSet = (IChangeSet)repo.itemManager().fetchCompleteItem((IItemHandle)handle, 0, (IProgressMonitor)monitor.newChild(10));
        IFileSystemView fsv = FileSystemCore.getFileSystemManager(repo).getFileSystemView((IConnection)wc);
        List<IChangeSetSummary> summaries = fsv.interpretChanges(Collections.singletonList(changeSet), (IProgressMonitor)monitor.newChild(80));
        IChangeSetSummary summary = summaries.get(0);
        IChangeSummary changeSummary = null;
        for (IChangeSummary cs : summary.changes()) {
            if (!cs.item().getItemId().getUuidValue().equals(parms.versionableItemId)) continue;
            changeSummary = cs;
            break;
        }
        if (changeSummary == null) {
            throw new TeamRepositoryException("Resource not found in given change set");
        }
        if (changeSummary.afterState() != null) {
            result.setAfterStateId(changeSummary.afterState().getStateId().getUuidValue());
        }
        if (changeSummary.beforeState() != null) {
            result.setBeforeStateId(changeSummary.beforeState().getStateId().getUuidValue());
        }
        for (IChange change : changeSet.changes()) {
            IVersionableHandle lastMergeState;
            if (!change.item().getItemId().getUuidValue().equals(parms.versionableItemId)) continue;
            if (change.mergeStates().size() <= 0 || (lastMergeState = (IVersionableHandle)change.mergeStates().get(change.mergeStates().size() - 1)) == null || lastMergeState.getStateId() == null) break;
            result.setLastMergeState(lastMergeState.getStateId().getUuidValue());
            break;
        }
        result.setPathHint(ResourceUtil.toString(changeSummary.getPathHint()));
        String[] newPathHint = changeSummary.getNewPathHint();
        if (newPathHint != null) {
            result.setNewPathHint(ResourceUtil.toString(newPathHint));
        }
        return result;
    }

    public static IVersionableHandle[] getVersionables(List<VersionablePath> pathList) {
        ArrayList<IVersionableHandle> cleanedList = new ArrayList<IVersionableHandle>(pathList.size());
        for (VersionablePath pathEntry : pathList) {
            cleanedList.add(pathEntry.getHandle());
        }
        return cleanedList.toArray(new IVersionableHandle[cleanedList.size()]);
    }

    public static CustomAttributesDTO[] getExtendedProperties(ParmsResourceProperties parms, IProgressMonitor progress) throws TeamRepositoryException {
        boolean computeFully;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(2 * parms.fullResourcePaths.length + 1));
        boolean bl = computeFully = parms.computeFully != null && parms.computeFully != false;
        if (computeFully) {
            monitor.setWorkRemaining(parms.fullResourcePaths.length * 3);
        }
        HashMap<IShareable, String> shareables = new HashMap<IShareable, String>(parms.fullResourcePaths.length);
        String[] stringArray = parms.fullResourcePaths;
        int n = parms.fullResourcePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String fullResourceStringPath = stringArray[n2];
            PathLocation path = new PathLocation((IPath)new Path(fullResourceStringPath));
            ResourceType resourceType = CommonUtil.getResourceType(path, (IProgressMonitor)monitor.newChild(1));
            if (resourceType == null) {
                resourceType = ResourceType.FILE;
            }
            shareables.put(SharingManager.getInstance().findShareable(path, resourceType), fullResourceStringPath);
            ++n2;
        }
        SharingManager.getInstance().getIgnoreManager().flushInAbsenceOfEvents(shareables.keySet(), (IProgressMonitor)monitor.newChild(1));
        HashMap repoMap = new HashMap();
        int versionCount = 0;
        for (Map.Entry entry : shareables.entrySet()) {
            IShareable shareable = (IShareable)entry.getKey();
            SubMonitor resourceMonitor = monitor.newChild(1);
            resourceMonitor.setWorkRemaining(100);
            if (shareable == null) continue;
            IShare share = shareable.getShare((IProgressMonitor)resourceMonitor.newChild(10));
            assert (share != null);
            ISharingDescriptor descriptor = share.getSharingDescriptor();
            IVersionableHandle versionable = shareable.getVersionable((IProgressMonitor)resourceMonitor.newChild(15));
            if (versionable == null) continue;
            ITeamRepository repo = RepositoryUtils.getTeamRepositoryById(descriptor.getRepositoryId());
            VersionablePath versionPath = new VersionablePath(versionable, (String)entry.getValue());
            ++versionCount;
            if (repo == null) continue;
            if (repoMap.containsKey(repo)) {
                ((List)repoMap.get(repo)).add(versionPath);
                continue;
            }
            ArrayList<VersionablePath> initialList = new ArrayList<VersionablePath>(1);
            initialList.add(versionPath);
            repoMap.put(repo, initialList);
        }
        CustomAttributesDTO[] customAttributesDTOArray = new CustomAttributesDTO[versionCount];
        if (versionCount == 0) {
            return customAttributesDTOArray;
        }
        IWorkspaceManager wm = null;
        int res_ind = 0;
        for (Map.Entry entry : repoMap.entrySet()) {
            ITeamRepository repo = (ITeamRepository)entry.getKey();
            List repoVersionables = (List)entry.getValue();
            wm = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
            IItemCustomAttributes[] customAttributesList = wm.getCustomAttributes(ResourceUtil.getVersionables(repoVersionables), (IProgressMonitor)monitor.newChild(5));
            int attr_ind = 0;
            for (VersionablePath versionable : repoVersionables) {
                SubMonitor resourceMonitor = monitor.newChild(1);
                CustomAttributesDTO customAttrs = FilesystemRestClientDTOresourceFactory.eINSTANCE.createCustomAttributesDTO();
                customAttributesDTOArray[res_ind++] = customAttrs;
                customAttrs.setFullPath(versionable.getPath());
                customAttrs.setItemId(versionable.getHandle().getItemId().getUuidValue());
                IItemCustomAttributes currentAttrs = customAttributesList[attr_ind++];
                Set customNames = currentAttrs.getAttributeNames();
                HashMap<String, String> convertedProperties = new HashMap<String, String>(customNames.size());
                for (String attr : customNames) {
                    String currentValue = currentAttrs.getAttributeValue(attr);
                    if (currentValue != null) {
                        convertedProperties.put(attr, currentValue);
                        continue;
                    }
                    convertedProperties.put(attr, "");
                }
                customAttrs.getCustomAttributes().putAll(convertedProperties);
                resourceMonitor.done();
            }
        }
        return customAttributesDTOArray;
    }

    private static IChangeExtendedPropertiesOperation prepareChangeExtendedPropertyOperation(ParmsResourcePropertyUpdates parms, int invalidPropertyDirection, ChangeExtendedPropertiesDilemmaHandler dilemmaHandler, ResourcePropertyChangeResultDTO result, IProgressMonitor progress) throws TeamRepositoryException, FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(2 * parms.resourcePropertyChanges.length * 2));
        IChangeExtendedPropertiesOperation op = IOperationFactory.instance.getChangeExtendedPropertiesOperation(dilemmaHandler);
        RefreshUtil.configureRefresh(parms.preOpRefresh, op);
        ParmsResourcePropertyChange[] parmsResourcePropertyChangeArray = parms.resourcePropertyChanges;
        int n = parms.resourcePropertyChanges.length;
        int n2 = 0;
        while (n2 < n) {
            ParmsResourcePropertyChange propertyChangeRequest = parmsResourcePropertyChangeArray[n2];
            IShareable shareable = ResourceUtil.findShareableFor(propertyChangeRequest.sandboxPath, propertyChangeRequest.filePath, (IProgressMonitor)monitor);
            if (propertyChangeRequest.propertyChanges != null || propertyChangeRequest.propertyRemovals != null) {
                IStatus status;
                Object property;
                int n3;
                int n4;
                Object[] objectArray;
                HashMap<String, Object> changes = new HashMap<String, Object>();
                HashSet<String> removals = new HashSet<String>();
                HashMap<String, IStatus> badProperties = new HashMap<String, IStatus>();
                if (propertyChangeRequest.propertyChanges != null) {
                    objectArray = propertyChangeRequest.propertyChanges;
                    n4 = propertyChangeRequest.propertyChanges.length;
                    n3 = 0;
                    while (n3 < n4) {
                        property = objectArray[n3];
                        status = op.validatePropertyName(((ParmsProperty)property).propertyName);
                        if (!status.isOK()) {
                            badProperties.put(((ParmsProperty)property).propertyName, status);
                        } else {
                            changes.put(((ParmsProperty)property).propertyName, ((ParmsProperty)property).propertyValue);
                        }
                        ++n3;
                    }
                }
                if (propertyChangeRequest.propertyRemovals != null) {
                    objectArray = propertyChangeRequest.propertyRemovals;
                    n4 = propertyChangeRequest.propertyRemovals.length;
                    n3 = 0;
                    while (n3 < n4) {
                        property = objectArray[n3];
                        status = op.validatePropertyName((String)property);
                        if (!status.isOK()) {
                            badProperties.put((String)property, status);
                        } else {
                            removals.add((String)property);
                        }
                        ++n3;
                    }
                }
                if (!badProperties.isEmpty()) {
                    result.getPropertyFailures().add(ResourceUtil.translatePropertyFailure(shareable, badProperties, (IProgressMonitor)monitor.newChild(1)));
                    if (invalidPropertyDirection == 1) {
                        throw new OperationCanceledException();
                    }
                    if (invalidPropertyDirection != 0) {
                        MultiStatus status2 = new MultiStatus("com.ibm.team.filesystem.client", 0, badProperties.values().toArray(new IStatus[badProperties.size()]), NLS.bind((String)Messages.ResourceUtil_2, (Object)shareable.getLocalPath().toString(), (Object[])new Object[0]), null);
                        throw new FileSystemStatusException((IStatus)status2);
                    }
                }
                op.setProperties(shareable, changes, removals);
            }
            ++n2;
        }
        return op;
    }

    public static ResourcePropertyChangeResultDTO postExtendedProperties(ParmsResourcePropertyUpdates parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        ResourcePropertyChangeResultDTO result = FilesystemRestClientDTOresourceFactory.eINSTANCE.createResourcePropertyChangeResultDTO();
        BackupDilemmaHandler backupDilemmaHandler = BackupUtil.getBackupDilemmaHandler(parms.backupDilemmaHandler, result.getBackedUpToShed());
        int invalidPropertyDirection = ResourceUtil.getInvalidPropertyDirection(parms.invalidPropertiesDilemmaHandler);
        ChangeExtendedPropertiesDilemmaHandler dilemmaHandler = ResourceUtil.getChangeExtendedPropertiesDilemmaHandler(invalidPropertyDirection, result.getPropertyFailures(), backupDilemmaHandler);
        try {
            IChangeExtendedPropertiesOperation op = ResourceUtil.prepareChangeExtendedPropertyOperation(parms, invalidPropertyDirection, dilemmaHandler, result, (IProgressMonitor)monitor.newChild(10));
            op.run((IProgressMonitor)monitor.newChild(90));
        }
        catch (OperationCanceledException e) {
            result.setCancelled(true);
        }
        return result;
    }

    private static String toString(String[] path) {
        StringBuffer buffer = new StringBuffer();
        int length = path.length;
        int i = 0;
        while (i < length) {
            buffer.append('/').append(path[i]);
            ++i;
        }
        return buffer.toString();
    }

    public static class LineDelimiterErrorHandler {
        private final Map<String, Boolean> lineDelimiterInstructions;
        private final int generalLineDelimiterDirection;
        private final List<LineDelimiterErrorDTO> lineDelimiterErrorsReported;

        public LineDelimiterErrorHandler(ParmsLineDelimiterDilemmaHandler parmsLineDelimiterDilemmaHandler, List<LineDelimiterErrorDTO> lineDelimiterErrorsReported) {
            if (parmsLineDelimiterDilemmaHandler == null) {
                this.generalLineDelimiterDirection = 0;
                this.lineDelimiterInstructions = Collections.EMPTY_MAP;
            } else {
                this.generalLineDelimiterDirection = ResourceUtil.getDirection(parmsLineDelimiterDilemmaHandler.generalLineDelimiterErrorInstruction);
                this.lineDelimiterInstructions = this.initializeLineDelimiterInstructions(parmsLineDelimiterDilemmaHandler.lineDelimiterErrorInstructions);
            }
            this.lineDelimiterErrorsReported = lineDelimiterErrorsReported;
        }

        private Map<String, Boolean> initializeLineDelimiterInstructions(ParmsLineDelimiterErrorInstructions[] lineDelimiterErrorInstructions) {
            HashMap<String, Boolean> instructions = new HashMap<String, Boolean>();
            if (lineDelimiterErrorInstructions != null) {
                int i = 0;
                while (i < lineDelimiterErrorInstructions.length) {
                    ParmsLineDelimiterErrorInstructions instruction = lineDelimiterErrorInstructions[i];
                    IPath path = new Path(instruction.sandboxPath).append(instruction.filePath);
                    path.removeTrailingSeparator();
                    instructions.put(path.toString(), instruction.forceConsistentDelimiters);
                    ++i;
                }
            }
            return instructions;
        }

        public int inconsistentLineDelimiters(List<? extends IChangePropertiesRequest> inconsistentDelimiters, IProgressMonitor monitor) throws FileSystemException {
            if (this.lineDelimiterErrorsReported != null) {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)inconsistentDelimiters.size());
                for (IChangePropertiesRequest iChangePropertiesRequest : inconsistentDelimiters) {
                    SubMonitor subProgress = progress.newChild(1).setWorkRemaining(100);
                    FileLineDelimiter d = iChangePropertiesRequest.getLineDelimiter((IProgressMonitor)subProgress.newChild(30));
                    this.lineDelimiterErrorsReported.add(ResourceUtil.translateLineDelimiterError(iChangePropertiesRequest.getShareableToChange(), d, (IProgressMonitor)subProgress.newChild(70)));
                }
            }
            boolean followGeneralInstruction = false;
            for (IChangePropertiesRequest iChangePropertiesRequest : inconsistentDelimiters) {
                ILocation location = iChangePropertiesRequest.getShareableToChange().getFullPath();
                IPath path = (IPath)location.getAdapter(IPath.class);
                if (path == null) {
                    throw new IllegalStateException("Not a hierarchical location " + location.toOSString());
                }
                path.removeTrailingSeparator();
                Boolean instruction = this.lineDelimiterInstructions.get(path.toString());
                if (instruction == null) {
                    if (this.generalLineDelimiterDirection == 0) {
                        iChangePropertiesRequest.setForceLineDelimiterConversion(false);
                    }
                    followGeneralInstruction = true;
                    continue;
                }
                iChangePropertiesRequest.setForceLineDelimiterConversion(instruction);
            }
            if (followGeneralInstruction) {
                return this.generalLineDelimiterDirection;
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int lineDelimiterErrors(Collection<? extends ILineDelimiterUploadFailure> failedFiles, IProgressMonitor monitor) throws FileSystemException {
            if (this.lineDelimiterErrorsReported != null) {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(10 * failedFiles.size()));
                List<LineDelimiterErrorDTO> list = this.lineDelimiterErrorsReported;
                synchronized (list) {
                    for (ILineDelimiterUploadFailure iLineDelimiterUploadFailure : failedFiles) {
                        FileLineDelimiter ld = iLineDelimiterUploadFailure.getShareable().getLineDelimiter((IProgressMonitor)progress.newChild(5));
                        if (ld == null) {
                            ld = iLineDelimiterUploadFailure.getLineDelimiter();
                        }
                        this.lineDelimiterErrorsReported.add(ResourceUtil.translateLineDelimiterError(iLineDelimiterUploadFailure.getStatus().getMessage(), iLineDelimiterUploadFailure.getShareable(), ld, (IProgressMonitor)progress.newChild(5)));
                    }
                }
            }
            int result = 0;
            for (ILineDelimiterUploadFailure iLineDelimiterUploadFailure : failedFiles) {
                ILocation location = iLineDelimiterUploadFailure.getShareable().getFullPath();
                IPath path = (IPath)location.getAdapter(IPath.class);
                if (path == null) {
                    throw new IllegalStateException("Not a hierarchical location " + location.toOSString());
                }
                path.removeTrailingSeparator();
                Boolean instruction = this.lineDelimiterInstructions.get(path.toString());
                if (instruction == null) {
                    if (this.generalLineDelimiterDirection == 0) {
                        iLineDelimiterUploadFailure.setForceConsistentDelimiters(false);
                        continue;
                    }
                    result = this.generalLineDelimiterDirection;
                    break;
                }
                iLineDelimiterUploadFailure.setForceConsistentDelimiters(instruction);
            }
            return result;
        }
    }

    private static class VersionablePath {
        private final IVersionableHandle handle;
        private final String path;

        public VersionablePath(IVersionableHandle handle, String path) {
            this.handle = handle;
            this.path = path;
        }

        public IVersionableHandle getHandle() {
            return this.handle;
        }

        public String getPath() {
            return this.path;
        }
    }
}

