/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.rest.util;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.rest.util.CommitUtil;
import com.ibm.team.filesystem.client.internal.rest.util.CoreUtil;
import com.ibm.team.filesystem.client.internal.rest.util.RefreshUtil;
import com.ibm.team.filesystem.client.internal.rest.util.ResourceUtil;
import com.ibm.team.filesystem.client.internal.rest.util.SandboxUpdateDilemmaUtil;
import com.ibm.team.filesystem.client.internal.rest.util.UpdateDilemmaUtil;
import com.ibm.team.filesystem.client.internal.rest.util.VerifyOutOfSyncUtil;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICheckinOptions;
import com.ibm.team.filesystem.client.operations.IDeleteFoldersOperation;
import com.ibm.team.filesystem.client.operations.IMoveFoldersOperation;
import com.ibm.team.filesystem.client.operations.IMoveVersionablesOperation;
import com.ibm.team.filesystem.client.operations.MoveFoldersDilemmaHandler;
import com.ibm.team.filesystem.client.operations.MoveVersionablesDilemmaHandler;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeleteFoldersInWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsMoveAcrossComponentRequest;
import com.ibm.team.filesystem.client.rest.parameters.ParmsMoveFoldersInWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsMoveVersionablesAcrossComponentRequest;
import com.ibm.team.filesystem.client.rest.parameters.ParmsMoveVersionablesInWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsMoveVersionablesWithinComponentRequest;
import com.ibm.team.filesystem.client.rest.parameters.ParmsMoveWithinComponentRequest;
import com.ibm.team.filesystem.client.rest.parameters.ParmsRenameFolderRequest;
import com.ibm.team.filesystem.client.rest.parameters.ParmsRenameVersionableRequest;
import com.ibm.team.filesystem.common.internal.rest.client.core.ConfigurationWithUncheckedInChangesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.FilesystemRestClientDTOcoreFactory;
import com.ibm.team.filesystem.common.internal.rest.client.dilemma.CommitDilemmaDTO;
import com.ibm.team.filesystem.common.internal.rest.client.dilemma.SandboxUpdateDilemmaDTO;
import com.ibm.team.filesystem.common.internal.rest.client.dilemma.UpdateDilemmaDTO;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.DeleteFoldersInWorkspaceResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.FilesystemRestClientDTOworkspaceFactory;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.MoveFoldersInWorkspaceResultDTO;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class MoveInRepositoryUtil {
    static final String MOVE_FOLDERS = "moveFoldersInWorkspace";
    static final String DELETE_FOLDERS = "deleteFoldersInWorkspace";

    public static DeleteFoldersInWorkspaceResultDTO deleteFoldersInWorkspace(ParmsDeleteFoldersInWorkspace parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        DeleteFoldersInWorkspaceResultDTO result = FilesystemRestClientDTOworkspaceFactory.eINSTANCE.createDeleteFoldersInWorkspaceResultDTO();
        OutOfSyncDilemmaHandler oosDilemmaHandler = VerifyOutOfSyncUtil.getOutOfSyncDilemmaHandler(parms.outOfSyncInstructions, result.getOutOfSyncShares(), parms.sandboxUpdateDilemmaHandler, result.getSandboxUpdateDilemma(), (IProgressMonitor)monitor.newChild(10));
        CommitDilemmaHandler dilemmaHandler = CommitUtil.getCommitDilemmaHandler(null, null, parms.sandboxUpdateDilemmaHandler, result.getSandboxUpdateDilemma(), null, null, oosDilemmaHandler);
        try {
            IDeleteFoldersOperation op = MoveInRepositoryUtil.prepareOperation(parms, dilemmaHandler, (IProgressMonitor)monitor.newChild(10));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            op.run((IProgressMonitor)monitor.newChild(75));
        }
        catch (OperationCanceledException e) {
            result.setCancelled(true);
        }
        return result;
    }

    private static IDeleteFoldersOperation prepareOperation(ParmsDeleteFoldersInWorkspace parms, CommitDilemmaHandler dilemmaHandler, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        IDeleteFoldersOperation op = IOperationFactory.instance.getDeleteFoldersOperation(dilemmaHandler);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(parms.projectsToDelete.length + 5));
        IShareable[] shareables = new IShareable[parms.projectsToDelete.length];
        int i = 0;
        while (i < parms.projectsToDelete.length) {
            shareables[i] = ResourceUtil.findShareableFor(parms.sandboxPath, parms.projectsToDelete[i], (IProgressMonitor)progress.newChild(1));
            ++i;
        }
        op.addDeleteRequest(shareables, IRepositoryResolver.EXISTING_SHARED, (IProgressMonitor)progress.newChild(5));
        if (parms.deleteContent != null && parms.deleteContent.booleanValue()) {
            op.setDeleteContent(true);
        } else {
            op.setDeleteContent(false);
        }
        return op;
    }

    public static MoveFoldersInWorkspaceResultDTO moveFoldersInWorkspace(ParmsMoveFoldersInWorkspace parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        MoveFoldersInWorkspaceResultDTO result = FilesystemRestClientDTOworkspaceFactory.eINSTANCE.createMoveFoldersInWorkspaceResultDTO();
        MoveFoldersDilemmaHandler dilemmaHandler = MoveInRepositoryUtil.getMoveFoldersDilemmaHandler(parms, result.getOutOfSyncShares(), result.getConfigurationsWithUncheckedInChanges(), result.getCommitDilemma(), result.getSandboxUpdateDilemma(), result.getUpdateDilemma(), (IProgressMonitor)monitor.newChild(10));
        IMoveFoldersOperation op = MoveInRepositoryUtil.prepareOperation(parms, dilemmaHandler, (IProgressMonitor)monitor.newChild(10));
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            op.run((IProgressMonitor)monitor.newChild(80));
        }
        catch (OperationCanceledException e) {
            result.setCancelled(true);
        }
        return result;
    }

    private static MoveFoldersDilemmaHandler getMoveFoldersDilemmaHandler(ParmsMoveFoldersInWorkspace parms, List outOfSyncShares, final List configurationsWithUncheckedInChanges, CommitDilemmaDTO commitDilemma, SandboxUpdateDilemmaDTO sandboxUpdateDilemma, UpdateDilemmaDTO updateDilemma, IProgressMonitor monitor) {
        final int uncheckedInChangesInstruction = CommitUtil.getUncheckedInChangesInstruction(parms.pendingChangesDilemmaHandler);
        final SandboxUpdateDilemmaUtil sandboxUpdateDilemmaUtil = new SandboxUpdateDilemmaUtil(parms.sandboxUpdateDilemmaHandler, sandboxUpdateDilemma);
        final UpdateDilemmaUtil updateDilemmaUtil = new UpdateDilemmaUtil(parms.updateDilemmaHandler, updateDilemma);
        final OutOfSyncDilemmaHandler outOfSyncDilemmaHandler = VerifyOutOfSyncUtil.getOutOfSyncDilemmaHandler(parms.outOfSyncInstructions, outOfSyncShares, parms.sandboxUpdateDilemmaHandler, sandboxUpdateDilemma, monitor);
        final CommitDilemmaHandler commitDilemmaHandler = CommitUtil.getCommitDilemmaHandler(parms.pendingChangesDilemmaHandler, commitDilemma, parms.sandboxUpdateDilemmaHandler, sandboxUpdateDilemma, parms.updateDilemmaHandler, updateDilemma, outOfSyncDilemmaHandler);
        MoveFoldersDilemmaHandler dilemmaHandler = new MoveFoldersDilemmaHandler(){

            @Override
            public CommitDilemmaHandler getCommitDilemmaHandler() {
                return commitDilemmaHandler;
            }

            @Override
            public int uncheckedInChanges(Map<ConfigurationFacade, Collection<ILocalChange>> configurationToChangesMap) {
                for (Map.Entry<ConfigurationFacade, Collection<ILocalChange>> entry : configurationToChangesMap.entrySet()) {
                    ConfigurationWithUncheckedInChangesDTO uncheckedInChanges = FilesystemRestClientDTOcoreFactory.eINSTANCE.createConfigurationWithUncheckedInChangesDTO();
                    uncheckedInChanges.setConfiguration(CoreUtil.translateConfigurationDescriptor(entry.getKey()));
                    uncheckedInChanges.setChangeCount(entry.getValue().size());
                    configurationsWithUncheckedInChanges.add(uncheckedInChanges);
                }
                return uncheckedInChangesInstruction;
            }

            @Override
            public OutOfSyncDilemmaHandler getOutOfSyncDilemmaHandler() {
                return outOfSyncDilemmaHandler;
            }

            @Override
            public BackupDilemmaHandler getBackupDilemmaHandler() {
                return sandboxUpdateDilemmaUtil.getBackupDilemmaHandler();
            }

            @Override
            public int deletedContent(Collection<IShareable> contentDeleted) {
                return sandboxUpdateDilemmaUtil.deletedContent(contentDeleted);
            }

            @Override
            public int inaccessibleForUpdate(Collection<IShareable> shareables) {
                return updateDilemmaUtil.inaccessibleForUpdate(shareables);
            }

            @Override
            public int siblingSharesToAdd(Collection<IShareable> shareables) {
                return updateDilemmaUtil.siblingSharesToAdd(shareables);
            }
        };
        return dilemmaHandler;
    }

    private static IMoveFoldersOperation prepareOperation(ParmsMoveFoldersInWorkspace parms, MoveFoldersDilemmaHandler dilemmaHandler, IProgressMonitor progress) throws TeamRepositoryException {
        IComponentHandle sourceComponent;
        IWorkspaceConnection workspaceConnection;
        Object request;
        int n;
        int n2;
        Object[] objectArray;
        SubMonitor iterProgress;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IMoveFoldersOperation op = IOperationFactory.instance.getMoveFoldersOperation(dilemmaHandler);
        if (parms.moveAcrossComponentRequests != null) {
            iterProgress = monitor.newChild(50);
            iterProgress = iterProgress.setWorkRemaining(parms.moveAcrossComponentRequests.length);
            objectArray = parms.moveAcrossComponentRequests;
            n2 = parms.moveAcrossComponentRequests.length;
            n = 0;
            while (n < n2) {
                request = objectArray[n];
                workspaceConnection = ((ParmsMoveAcrossComponentRequest)request).workspace.getWorkspaceConnection((IProgressMonitor)iterProgress.newChild(1));
                sourceComponent = ((ParmsMoveAcrossComponentRequest)request).getSourceComponentHandle();
                IComponentHandle targetComponent = ((ParmsMoveAcrossComponentRequest)request).getTargetComponentHandle();
                IFolderHandle[] foldersToMove = ((ParmsMoveAcrossComponentRequest)request).getToMoveFolderHandles();
                IFolderHandle[] parentsToMoveInto = ((ParmsMoveAcrossComponentRequest)request).getParentFolderHandles();
                op.addMoveAcrossComponentRequest(workspaceConnection, sourceComponent, foldersToMove, targetComponent, parentsToMoveInto, ((ParmsMoveAcrossComponentRequest)request).sourceChangeSetComment, ((ParmsMoveAcrossComponentRequest)request).targetChangeSetComment);
                ++n;
            }
        }
        if (parms.moveWithinComponentRequests != null) {
            iterProgress = monitor.newChild(50);
            iterProgress = iterProgress.setWorkRemaining(parms.moveWithinComponentRequests.length);
            objectArray = parms.moveWithinComponentRequests;
            n2 = parms.moveWithinComponentRequests.length;
            n = 0;
            while (n < n2) {
                request = objectArray[n];
                workspaceConnection = ((ParmsMoveWithinComponentRequest)request).workspace.getWorkspaceConnection((IProgressMonitor)iterProgress.newChild(1));
                sourceComponent = ((ParmsMoveWithinComponentRequest)request).getComponentHandle();
                IFolderHandle[] foldersToMove = ((ParmsMoveWithinComponentRequest)request).getToMoveFolderHandles();
                IFolderHandle[] parentsToMoveInto = ((ParmsMoveWithinComponentRequest)request).getParentFolderHandles();
                op.addMoveWithinComponentRequest(workspaceConnection, sourceComponent, (IVersionableHandle[])foldersToMove, parentsToMoveInto, ((ParmsMoveWithinComponentRequest)request).changeSetComment);
                ++n;
            }
        }
        if (parms.renameFolderRequests != null) {
            iterProgress = monitor.newChild(50);
            iterProgress = iterProgress.setWorkRemaining(parms.moveWithinComponentRequests.length);
            objectArray = parms.renameFolderRequests;
            n2 = parms.renameFolderRequests.length;
            n = 0;
            while (n < n2) {
                request = objectArray[n];
                workspaceConnection = ((ParmsRenameFolderRequest)request).workspace.getWorkspaceConnection((IProgressMonitor)iterProgress.newChild(1));
                IComponentHandle component = ((ParmsRenameFolderRequest)request).getComponentHandle();
                IFolderHandle[] foldersToRename = ((ParmsRenameFolderRequest)request).getRenameFolderHandles();
                op.addRenameRequest(workspaceConnection, component, (IVersionableHandle[])foldersToRename, ((ParmsRenameFolderRequest)request).newNames, ((ParmsRenameFolderRequest)request).changeSetComment);
                ++n;
            }
        }
        RefreshUtil.configureRefresh(parms.preoperationRefresh, op);
        CommitUtil.configureCommit(parms.pendingChangesDilemmaHandler, (ICheckinOptions)op);
        return op;
    }

    public static MoveFoldersInWorkspaceResultDTO moveVersionablesInWorkspace(ParmsMoveVersionablesInWorkspace parms, IProgressMonitor progress) throws FileSystemException, TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        MoveFoldersInWorkspaceResultDTO result = FilesystemRestClientDTOworkspaceFactory.eINSTANCE.createMoveFoldersInWorkspaceResultDTO();
        MoveVersionablesDilemmaHandler dilemmaHandler = MoveInRepositoryUtil.getMoveVersionablesDilemmaHandler(parms, result.getOutOfSyncShares(), result.getConfigurationsWithUncheckedInChanges(), result.getCommitDilemma(), result.getSandboxUpdateDilemma(), result.getUpdateDilemma(), (IProgressMonitor)monitor.newChild(10));
        IMoveVersionablesOperation op = MoveInRepositoryUtil.prepareOperation(parms, dilemmaHandler, (IProgressMonitor)monitor.newChild(10));
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            op.run((IProgressMonitor)monitor.newChild(80));
        }
        catch (OperationCanceledException e) {
            result.setCancelled(true);
        }
        return result;
    }

    private static IMoveVersionablesOperation prepareOperation(ParmsMoveVersionablesInWorkspace parms, MoveVersionablesDilemmaHandler dilemmaHandler, IProgressMonitor progress) throws TeamRepositoryException {
        IComponentHandle sourceComponent;
        IWorkspaceConnection workspaceConnection;
        Object request;
        int n;
        int n2;
        Object[] objectArray;
        SubMonitor iterProgress;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IMoveVersionablesOperation op = IOperationFactory.instance.getMoveVersionablesOperation(dilemmaHandler);
        if (parms.moveAcrossComponentRequests != null) {
            iterProgress = monitor.newChild(50);
            iterProgress = iterProgress.setWorkRemaining(parms.moveAcrossComponentRequests.length);
            objectArray = parms.moveAcrossComponentRequests;
            n2 = parms.moveAcrossComponentRequests.length;
            n = 0;
            while (n < n2) {
                request = objectArray[n];
                workspaceConnection = ((ParmsMoveVersionablesAcrossComponentRequest)request).workspace.getWorkspaceConnection((IProgressMonitor)iterProgress.newChild(1));
                sourceComponent = ((ParmsMoveVersionablesAcrossComponentRequest)request).getSourceComponentHandle();
                IComponentHandle targetComponent = ((ParmsMoveVersionablesAcrossComponentRequest)request).getTargetComponentHandle();
                op.addMoveVersionablesAcrossComponentRequest(workspaceConnection, sourceComponent, ((ParmsMoveVersionablesAcrossComponentRequest)request).getVersionableHandles(), targetComponent, ((ParmsMoveVersionablesAcrossComponentRequest)request).getParentFolderHandles(), ((ParmsMoveVersionablesAcrossComponentRequest)request).sourceChangeSetComment, ((ParmsMoveVersionablesAcrossComponentRequest)request).targetChangeSetComment);
                ++n;
            }
        }
        if (parms.moveWithinComponentRequests != null) {
            iterProgress = monitor.newChild(50);
            iterProgress = iterProgress.setWorkRemaining(parms.moveWithinComponentRequests.length);
            objectArray = parms.moveWithinComponentRequests;
            n2 = parms.moveWithinComponentRequests.length;
            n = 0;
            while (n < n2) {
                request = objectArray[n];
                workspaceConnection = ((ParmsMoveVersionablesWithinComponentRequest)request).workspace.getWorkspaceConnection((IProgressMonitor)iterProgress.newChild(1));
                sourceComponent = ((ParmsMoveVersionablesWithinComponentRequest)request).getComponentHandle();
                op.addMoveWithinComponentRequest(workspaceConnection, sourceComponent, ((ParmsMoveVersionablesWithinComponentRequest)request).getVersionableHandles(), ((ParmsMoveVersionablesWithinComponentRequest)request).getParentFolderHandles(), ((ParmsMoveVersionablesWithinComponentRequest)request).changeSetComment);
                ++n;
            }
        }
        if (parms.renameFolderRequests != null) {
            iterProgress = monitor.newChild(50);
            iterProgress = iterProgress.setWorkRemaining(parms.moveWithinComponentRequests.length);
            objectArray = parms.renameFolderRequests;
            n2 = parms.renameFolderRequests.length;
            n = 0;
            while (n < n2) {
                request = objectArray[n];
                workspaceConnection = ((ParmsRenameVersionableRequest)request).workspace.getWorkspaceConnection((IProgressMonitor)iterProgress.newChild(1));
                IComponentHandle component = ((ParmsRenameVersionableRequest)request).getComponentHandle();
                op.addRenameRequest(workspaceConnection, component, ((ParmsRenameVersionableRequest)request).getVersionableHandles(), ((ParmsRenameVersionableRequest)request).newNames, ((ParmsRenameVersionableRequest)request).changeSetComment);
                ++n;
            }
        }
        RefreshUtil.configureRefresh(parms.preoperationRefresh, op);
        CommitUtil.configureCommit(parms.pendingChangesDilemmaHandler, (ICheckinOptions)op);
        return op;
    }

    private static MoveVersionablesDilemmaHandler getMoveVersionablesDilemmaHandler(ParmsMoveVersionablesInWorkspace parms, List outOfSyncShares, final List configurationsWithUncheckedInChanges, CommitDilemmaDTO commitDilemma, SandboxUpdateDilemmaDTO sandboxUpdateDilemma, UpdateDilemmaDTO updateDilemma, IProgressMonitor monitor) {
        final int uncheckedInChangesInstruction = CommitUtil.getUncheckedInChangesInstruction(parms.pendingChangesDilemmaHandler);
        final SandboxUpdateDilemmaUtil sandboxUpdateDilemmaUtil = new SandboxUpdateDilemmaUtil(parms.sandboxUpdateDilemmaHandler, sandboxUpdateDilemma);
        final UpdateDilemmaUtil updateDilemmaUtil = new UpdateDilemmaUtil(parms.updateDilemmaHandler, updateDilemma);
        final OutOfSyncDilemmaHandler outOfSyncDilemmaHandler = VerifyOutOfSyncUtil.getOutOfSyncDilemmaHandler(parms.outOfSyncInstructions, outOfSyncShares, parms.sandboxUpdateDilemmaHandler, sandboxUpdateDilemma, monitor);
        final CommitDilemmaHandler commitDilemmaHandler = CommitUtil.getCommitDilemmaHandler(parms.pendingChangesDilemmaHandler, commitDilemma, parms.sandboxUpdateDilemmaHandler, sandboxUpdateDilemma, parms.updateDilemmaHandler, updateDilemma, outOfSyncDilemmaHandler);
        MoveVersionablesDilemmaHandler dilemmaHandler = new MoveVersionablesDilemmaHandler(){

            @Override
            public CommitDilemmaHandler getCommitDilemmaHandler() {
                return commitDilemmaHandler;
            }

            @Override
            public int uncheckedInChanges(Map<ConfigurationFacade, Collection<ILocalChange>> configurationToChangesMap) {
                for (Map.Entry<ConfigurationFacade, Collection<ILocalChange>> entry : configurationToChangesMap.entrySet()) {
                    ConfigurationWithUncheckedInChangesDTO uncheckedInChanges = FilesystemRestClientDTOcoreFactory.eINSTANCE.createConfigurationWithUncheckedInChangesDTO();
                    uncheckedInChanges.setConfiguration(CoreUtil.translateConfigurationDescriptor(entry.getKey()));
                    uncheckedInChanges.setChangeCount(entry.getValue().size());
                    configurationsWithUncheckedInChanges.add(uncheckedInChanges);
                }
                return uncheckedInChangesInstruction;
            }

            @Override
            public OutOfSyncDilemmaHandler getOutOfSyncDilemmaHandler() {
                return outOfSyncDilemmaHandler;
            }

            @Override
            public BackupDilemmaHandler getBackupDilemmaHandler() {
                return sandboxUpdateDilemmaUtil.getBackupDilemmaHandler();
            }

            @Override
            public int deletedContent(Collection<IShareable> contentDeleted) {
                return sandboxUpdateDilemmaUtil.deletedContent(contentDeleted);
            }

            @Override
            public int inaccessibleForUpdate(Collection<IShareable> shareables) {
                return updateDilemmaUtil.inaccessibleForUpdate(shareables);
            }

            @Override
            public int siblingSharesToAdd(Collection<IShareable> shareables) {
                return updateDilemmaUtil.siblingSharesToAdd(shareables);
            }
        };
        return dilemmaHandler;
    }
}

