/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.rest.util;

import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.componenthierarchy.ComponentHierarchyManager;
import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.internal.rest.util.CommitUtil;
import com.ibm.team.filesystem.client.internal.rest.util.CoreUtil;
import com.ibm.team.filesystem.client.internal.rest.util.ISyncViewProxy;
import com.ibm.team.filesystem.client.internal.rest.util.RefreshUtil;
import com.ibm.team.filesystem.client.internal.rest.util.SandboxUpdateDilemmaUtil;
import com.ibm.team.filesystem.client.internal.rest.util.UpdateDilemmaUtil;
import com.ibm.team.filesystem.client.internal.rest.util.VerifyOutOfSyncUtil;
import com.ibm.team.filesystem.client.internal.rest.util.WorkspaceUpdateUtil;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.DeliverDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICheckinOptions;
import com.ibm.team.filesystem.client.operations.IDeliverOperation;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeliver;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeliverChangeSetsOrBaselines;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeliverComponents;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeliverDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeliverWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeliveryRequiresHistoryReorderingDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.DeliverResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.FilesystemRestClientDTOchangesetFactory;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.WorkspaceComponentOperationsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ConfigurationWithUncheckedInChangesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.FilesystemRestClientDTOcoreFactory;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ComponentSyncDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IComponentHierarchyResult;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.dto.IStreamLockReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class DeliverUtil {
    public static DeliverResultDTO deliver(ParmsDeliver parms, ISyncViewProxy syncViewProxy, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        DeliverResultDTO result = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createDeliverResultDTO();
        DeliverDilemmaHandler dilemmaHandler = DeliverUtil.getDeliverDilemmaHandler(parms, result, (IProgressMonitor)monitor.newChild(5));
        ArrayList<ComponentSyncDTO> conflictingComponents = new ArrayList<ComponentSyncDTO>();
        ArrayList<ComponentSyncDTO> multipleParticipants = new ArrayList<ComponentSyncDTO>();
        IDeliverOperation deliverOperation = DeliverUtil.prepareDeliverOperation(parms, syncViewProxy, dilemmaHandler, conflictingComponents, multipleParticipants, (IProgressMonitor)monitor.newChild(8));
        if (!conflictingComponents.isEmpty()) {
            result.getComponentsWithConflictingTargets().addAll(conflictingComponents);
            result.setCancelled(true);
            return result;
        }
        if (!multipleParticipants.isEmpty() && !"continue".equals(parms.deliverDilemmaHandler.multipleParticipantsDirection)) {
            result.getComponentsWithMultipleParticipants().addAll(multipleParticipants);
            result.setCancelled(true);
            return result;
        }
        try {
            deliverOperation.run((IProgressMonitor)monitor.newChild(85));
        }
        catch (OperationCanceledException e) {
            result.setCancelled(true);
        }
        if (parms.structuredResultOptions != null) {
            WorkspaceUpdateUtil.populateWorkspaceUpdateResult(deliverOperation.getUpdateReport(), result.getStructuredResult(), (IProgressMonitor)monitor.newChild(2));
        }
        return result;
    }

    public static DeliverDilemmaHandler getDeliverDilemmaHandler(final ParmsDeliver parms, final DeliverResultDTO result, IProgressMonitor progress) {
        final SandboxUpdateDilemmaUtil sandboxUpdateDilemmaUtil = new SandboxUpdateDilemmaUtil(parms.sandboxUpdateDilemmaHandler, result.getSandboxUpdateDilemma());
        final UpdateDilemmaUtil updateDilemmaUtil = new UpdateDilemmaUtil(parms.updateDilemmaHandler, result.getUpdateDilemma());
        final OutOfSyncDilemmaHandler outOfSyncDilemmaHandler = VerifyOutOfSyncUtil.getOutOfSyncDilemmaHandler(parms.outOfSyncInstructions, result.getOutOfSyncShares(), parms.sandboxUpdateDilemmaHandler, result.getSandboxUpdateDilemma(), progress);
        final CommitDilemmaHandler commitDilemmaHandler = CommitUtil.getCommitDilemmaHandler(parms.pendingChangesDilemmaHandler, result.getCommitDilemma(), parms.sandboxUpdateDilemmaHandler, result.getSandboxUpdateDilemma(), parms.updateDilemmaHandler, result.getUpdateDilemma(), outOfSyncDilemmaHandler);
        final int uncheckedInChangesInstruction = CommitUtil.getUncheckedInChangesInstruction(parms.pendingChangesDilemmaHandler);
        final int flowComponentsInstruction = DeliverUtil.getFlowComponentsDilemaValue(parms.deliverDilemmaHandler);
        final int flowToNonDefaultTarget = DeliverUtil.getFlowToNonDefaultTarget(parms.deliverDilemmaHandler);
        final int flowWithIncomingReplace = DeliverUtil.getFlowWithIncomingRepalceDilemaValue(parms.deliverDilemmaHandler);
        DeliverDilemmaHandler handler = new DeliverDilemmaHandler(){

            @Override
            public int uncheckedInChanges(Map<ConfigurationFacade, Collection<ILocalChange>> configurationToChangesMap) {
                for (Map.Entry<ConfigurationFacade, Collection<ILocalChange>> entry : configurationToChangesMap.entrySet()) {
                    ConfigurationWithUncheckedInChangesDTO uncheckedInChanges = FilesystemRestClientDTOcoreFactory.eINSTANCE.createConfigurationWithUncheckedInChangesDTO();
                    uncheckedInChanges.setConfiguration(CoreUtil.translateConfigurationDescriptor(entry.getKey()));
                    uncheckedInChanges.setChangeCount(entry.getValue().size());
                    result.getConfigurationsWithUncheckedInChanges().add(uncheckedInChanges);
                }
                return uncheckedInChangesInstruction;
            }

            @Override
            public int notDefaultTarget(Collection<IWorkspaceConnection> targets) {
                result.setFlowToNonDefaultTarget(true);
                return flowToNonDefaultTarget;
            }

            @Override
            public CommitDilemmaHandler getCommitDilemmaHandler() {
                return commitDilemmaHandler;
            }

            @Override
            public int deliverCombinedProblem(IWorkspaceConnection workspaceConnection, IChangeHistorySyncReport syncReport, List<IBaselineHandle> baselines, List<IChangeSetHandle> changeSets, TeamRepositoryException exception) {
                return super.deliverCombinedProblem(workspaceConnection, syncReport, baselines, changeSets, exception);
            }

            @Override
            public int componentsToBeAddedOrRemoved(List<IComponentHandle> added, List<IComponentHandle> removed) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int componentsToBeAddedRemovedOrReplaced(List<DeliverDilemmaHandler.IWorkspaceComponentOperations> workspaceComponentOperationsList, IProgressMonitor monitor) throws TeamRepositoryException {
                result.setComponentsToFlow(true);
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)workspaceComponentOperationsList.size());
                for (DeliverDilemmaHandler.IWorkspaceComponentOperations wco : workspaceComponentOperationsList) {
                    IComponent component;
                    ComponentDTO compDto;
                    WorkspaceComponentOperationsDTO wcoDTO = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createWorkspaceComponentOperationsDTO();
                    IWorkspaceConnection sourceWorkspace = wco.getSourceWorkspace();
                    wcoDTO.setSourceWorkspace(this.asWorkspaceDTO(sourceWorkspace));
                    wcoDTO.setTargetWorkspace(this.asWorkspaceDTO(wco.getTargetWorkspace()));
                    ArrayList<IComponentHandle> componentsToFetch = new ArrayList<IComponentHandle>();
                    componentsToFetch.addAll(wco.getAddedComponents());
                    componentsToFetch.addAll(wco.getRemovedComponents());
                    componentsToFetch.addAll(wco.getReplacedComponents());
                    HashMap<UUID, IComponent> componentsMap = new HashMap<UUID, IComponent>();
                    List componentsList = sourceWorkspace.teamRepository().itemManager().fetchCompleteItems(componentsToFetch, 0, (IProgressMonitor)progress.newChild(1));
                    for (IComponent component2 : componentsList) {
                        componentsMap.put(component2.getItemId(), component2);
                    }
                    for (IComponentHandle componentHandle : wco.getAddedComponents()) {
                        compDto = FilesystemRestClientDTOcoreFactory.eINSTANCE.createComponentDTO();
                        component = (IComponent)componentsMap.get(componentHandle.getItemId());
                        compDto.setName(component.getName());
                        compDto.setItemId(component.getItemId().getUuidValue());
                        wcoDTO.getAddedComponents().add(compDto);
                    }
                    for (IComponentHandle componentHandle : wco.getRemovedComponents()) {
                        compDto = FilesystemRestClientDTOcoreFactory.eINSTANCE.createComponentDTO();
                        component = (IComponent)componentsMap.get(componentHandle.getItemId());
                        compDto.setName(component.getName());
                        compDto.setItemId(component.getItemId().getUuidValue());
                        wcoDTO.getRemovedComponents().add(compDto);
                    }
                    for (IComponentHandle componentHandle : wco.getReplacedComponents()) {
                        compDto = FilesystemRestClientDTOcoreFactory.eINSTANCE.createComponentDTO();
                        component = (IComponent)componentsMap.get(componentHandle.getItemId());
                        compDto.setName(component.getName());
                        compDto.setItemId(component.getItemId().getUuidValue());
                        wcoDTO.getReplacedComponents().add(compDto);
                    }
                    result.getComponentOperations().add(wcoDTO);
                }
                return flowComponentsInstruction;
            }

            @Override
            public int deliveryWithIncomingReplace(List<IComponentHandle> components, IProgressMonitor monitor) {
                for (IComponentHandle handle : components) {
                    result.getComponentsWithIncomingReplace().add(handle.getItemId().getUuidValue());
                }
                return flowWithIncomingReplace;
            }

            private WorkspaceDTO asWorkspaceDTO(IWorkspaceConnection workspace) {
                WorkspaceDTO workspaceDTO = FilesystemRestClientDTOcoreFactory.eINSTANCE.createWorkspaceDTO();
                workspaceDTO.setItemId(workspace.getResolvedWorkspace().getItemId().getUuidValue());
                workspaceDTO.setName(workspace.getName());
                workspaceDTO.setStream(workspace.isStream());
                workspaceDTO.setRepositoryId(workspace.teamRepository().getId().getUuidValue());
                workspaceDTO.setRepositoryURL(workspace.teamRepository().getRepositoryURI());
                return workspaceDTO;
            }

            @Override
            public OutOfSyncDilemmaHandler getOutOfSyncDilemmaHandler() {
                return outOfSyncDilemmaHandler;
            }

            @Override
            public int lockBeingHeld(IStreamLockReport lock, IWorkspaceConnection workspaceConnection, int requestsLeft) {
                return 0;
            }

            @Override
            public Map<IStreamLockReport, IWorkspaceConnection> locksToRelease(Map<IStreamLockReport, IWorkspaceConnection> locks) {
                for (Map.Entry<IStreamLockReport, IWorkspaceConnection> entry : locks.entrySet()) {
                    result.getLocksToRelease().add(CoreUtil.getStreamLockReportDTO(entry.getValue(), entry.getKey()));
                }
                return parms.autoReleaseLocks != false ? locks : Collections.EMPTY_MAP;
            }

            @Override
            public void locksWereHeld(Map<IStreamLockReport, IWorkspaceConnection> locks) {
                for (Map.Entry<IStreamLockReport, IWorkspaceConnection> entry : locks.entrySet()) {
                    result.getLocksWereHeld().add(CoreUtil.getStreamLockReportDTO(entry.getValue(), entry.getKey()));
                }
            }

            @Override
            public BackupDilemmaHandler getBackupDilemmaHandler() {
                return sandboxUpdateDilemmaUtil.getBackupDilemmaHandler();
            }

            @Override
            public int deliveryRequiresHistoryReordering(IWorkspaceConnection source, IWorkspaceConnection target, IComponent component) {
                ParmsDeliveryRequiresHistoryReorderingDilemmaHandler handler = parms.deliveryRequiresHistoryReorderingDilemmaHandler;
                result.getDeliveryRequiresHistoryReordering().add(CoreUtil.getDeliveryRequiresHistoryReorderingDTO(source, target, component));
                if (handler != null && handler.deliveryRequiresHistoryReordering != null) {
                    if (handler.deliveryRequiresHistoryReordering.equals("continue")) {
                        return 0;
                    }
                    if (handler.deliveryRequiresHistoryReordering.equals("cancel")) {
                        return 1;
                    }
                    if (handler.deliveryRequiresHistoryReordering.equals("fail")) {
                        return 2;
                    }
                }
                return 2;
            }

            @Override
            public int deletedContent(Collection<IShareable> contentDeleted) {
                return sandboxUpdateDilemmaUtil.deletedContent(contentDeleted);
            }

            @Override
            public int inaccessibleForUpdate(Collection<IShareable> shareables) {
                return updateDilemmaUtil.inaccessibleForUpdate(shareables);
            }

            @Override
            public int siblingSharesToAdd(Collection<IShareable> shareables) {
                return updateDilemmaUtil.siblingSharesToAdd(shareables);
            }
        };
        return handler;
    }

    private static IDeliverOperation prepareDeliverOperation(ParmsDeliver parms, ISyncViewProxy syncViewProxy, DeliverDilemmaHandler dilemmaHandler, List<ComponentSyncDTO> conflictingComponents, List<ComponentSyncDTO> multipleParticipants, IProgressMonitor progress) throws TeamRepositoryException {
        int n;
        Object[] objectArray;
        SubMonitor subMonitor;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)200);
        IDeliverOperation deliverOperation = IOperationFactory.instance.getDeliverOperation(dilemmaHandler);
        deliverOperation.setPopulateUpdateReport(parms.structuredResultOptions != null);
        if (parms.deliverChangeSetsOrBaselines != null) {
            subMonitor = monitor.newChild(100).setWorkRemaining(parms.deliverChangeSetsOrBaselines.length * 10);
            objectArray = parms.deliverChangeSetsOrBaselines;
            n = parms.deliverChangeSetsOrBaselines.length;
            int n2 = 0;
            while (n2 < n) {
                int n3;
                Object deliverChangeSets = objectArray[n2];
                ITeamRepository repo = CommonUtil.getTeamRepository(((ParmsDeliverChangeSetsOrBaselines)deliverChangeSets).sourceWorkspace.repositoryUrl);
                IWorkspaceConnection sourceWorkspace = ((ParmsDeliverChangeSetsOrBaselines)deliverChangeSets).sourceWorkspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                IWorkspaceConnection targetWorkspace = ((ParmsDeliverChangeSetsOrBaselines)deliverChangeSets).targetWorkspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                ArrayList<IChangeSetHandle> changeSets = new ArrayList<IChangeSetHandle>();
                if (((ParmsDeliverChangeSetsOrBaselines)deliverChangeSets).changeSetItemIds != null) {
                    String[] stringArray = ((ParmsDeliverChangeSetsOrBaselines)deliverChangeSets).changeSetItemIds;
                    n3 = ((ParmsDeliverChangeSetsOrBaselines)deliverChangeSets).changeSetItemIds.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String changeSetItemId = stringArray[n4];
                        changeSets.add(CommonUtil.createChangeSetHandle(repo, changeSetItemId));
                        ++n4;
                    }
                }
                ArrayList<IBaselineHandle> baselines = new ArrayList<IBaselineHandle>();
                if (((ParmsDeliverChangeSetsOrBaselines)deliverChangeSets).baselineItemIds != null) {
                    String[] stringArray = ((ParmsDeliverChangeSetsOrBaselines)deliverChangeSets).baselineItemIds;
                    int n5 = ((ParmsDeliverChangeSetsOrBaselines)deliverChangeSets).baselineItemIds.length;
                    n3 = 0;
                    while (n3 < n5) {
                        String baselineId = stringArray[n3];
                        baselines.add((IBaselineHandle)IBaseline.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)baselineId), null));
                        ++n3;
                    }
                }
                IChangeHistorySyncReport report = syncViewProxy.getCompareReport(sourceWorkspace, targetWorkspace, (IProgressMonitor)monitor);
                deliverOperation.deliver(sourceWorkspace, targetWorkspace, report, baselines, changeSets, Collections.EMPTY_LIST);
                ++n2;
            }
        }
        if (parms.deliverComponents != null) {
            ArrayList<ParmsDeliverComponents> hierarchicalDeliverList = new ArrayList<ParmsDeliverComponents>();
            ArrayList<ParmsDeliverComponents> flatDeliverList = new ArrayList<ParmsDeliverComponents>();
            DeliverUtil.groupDeliverByHierarchialAccept(parms, hierarchicalDeliverList, flatDeliverList);
            SubMonitor subMonitor2 = SubMonitor.convert((IProgressMonitor)monitor, (int)(hierarchicalDeliverList.size() + flatDeliverList.size()));
            List<ParmsDeliverComponents> hierarchicalDeliverParmsDeliverComponents = DeliverUtil.getHierarchicalDeliverParmsDeliverComponents(syncViewProxy, conflictingComponents, multipleParticipants, hierarchicalDeliverList, (IProgressMonitor)subMonitor2);
            if (!conflictingComponents.isEmpty()) {
                return null;
            }
            if (!multipleParticipants.isEmpty() && !"continue".equals(parms.deliverDilemmaHandler.multipleParticipantsDirection)) {
                return null;
            }
            flatDeliverList.addAll(hierarchicalDeliverParmsDeliverComponents);
            DeliverUtil.deliver(deliverOperation, flatDeliverList, syncViewProxy, (IProgressMonitor)subMonitor2.newChild(1));
        }
        if (parms.deliverWorkspaces != null) {
            subMonitor = monitor.newChild(100).setWorkRemaining(parms.deliverWorkspaces.length * 10);
            objectArray = parms.deliverWorkspaces;
            n = parms.deliverWorkspaces.length;
            int n6 = 0;
            while (n6 < n) {
                Object deliverWorkspaces = objectArray[n6];
                IWorkspaceConnection sourceWorkspace = ((ParmsDeliverWorkspace)deliverWorkspaces).sourceWorkspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                IWorkspaceConnection targetWorkspace = ((ParmsDeliverWorkspace)deliverWorkspaces).targetWorkspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
                IChangeHistorySyncReport report = syncViewProxy.getCompareReport(sourceWorkspace, targetWorkspace, (IProgressMonitor)monitor);
                deliverOperation.deliver(sourceWorkspace, targetWorkspace, report);
                ++n6;
            }
        }
        RefreshUtil.configureRefresh(parms.preoperationRefresh, deliverOperation);
        CommitUtil.configureCommit(parms.pendingChangesDilemmaHandler, (ICheckinOptions)deliverOperation);
        deliverOperation.setAutoReleaseLocks(parms.autoReleaseLocks);
        return deliverOperation;
    }

    private static void groupDeliverByHierarchialAccept(ParmsDeliver parms, List<ParmsDeliverComponents> hierarchicalDeliverList, List<ParmsDeliverComponents> nonhierarchicalDeliverList) throws TeamRepositoryException {
        ParmsDeliverComponents[] parmsDeliverComponentsArray = parms.deliverComponents;
        int n = parms.deliverComponents.length;
        int n2 = 0;
        while (n2 < n) {
            ParmsDeliverComponents parmsDeliverComponent = parmsDeliverComponentsArray[n2];
            ITeamRepository repo = parmsDeliverComponent.targetWorkspace.getTeamRepository();
            boolean hierarchialAccept = parmsDeliverComponent.hierarchicalDeliver & ComponentHierarchyManager.getInstance().isHierarchicalComponentsEnabled(repo);
            if (hierarchialAccept) {
                hierarchicalDeliverList.add(parmsDeliverComponent);
            } else {
                nonhierarchicalDeliverList.add(parmsDeliverComponent);
            }
            ++n2;
        }
    }

    private static List<ParmsDeliverComponents> getHierarchicalDeliverParmsDeliverComponents(ISyncViewProxy syncViewProxy, List<ComponentSyncDTO> conflictingComponents, List<ComponentSyncDTO> multipleParticipants, List<ParmsDeliverComponents> hierarchicalDeliverList, IProgressMonitor monitor) throws TeamRepositoryException {
        boolean isSourceWorkspaceExplicit;
        ArrayList<ParmsDeliverComponents> result = new ArrayList<ParmsDeliverComponents>();
        boolean bl = isSourceWorkspaceExplicit = hierarchicalDeliverList.isEmpty() ? false : hierarchicalDeliverList.get((int)0).sourceWorkspaceExplicit;
        if (isSourceWorkspaceExplicit) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(hierarchicalDeliverList.size() * 2));
            for (ParmsDeliverComponents hierarchicalDeliver : hierarchicalDeliverList) {
                ParmsDeliverComponents parmsDeliverComponents = new ParmsDeliverComponents();
                parmsDeliverComponents.hierarchicalDeliver = true;
                parmsDeliverComponents.sourceWorkspaceExplicit = true;
                parmsDeliverComponents.sourceWorkspace = hierarchicalDeliver.sourceWorkspace;
                parmsDeliverComponents.targetWorkspace = hierarchicalDeliver.targetWorkspace;
                ArrayList<Object> componentHandles = new ArrayList<Object>();
                componentHandles.addAll(hierarchicalDeliver.getComponentHandles());
                IWorkspaceConnection sourceConnection = hierarchicalDeliver.sourceWorkspace.getWorkspaceConnection((IProgressMonitor)progress.newChild(1));
                IComponentHierarchyResult hierarchy = sourceConnection.getComponentHierarchy(componentHandles);
                Map subComponents = hierarchy.getFlattenedElementsMap();
                componentHandles.addAll(subComponents.values());
                parmsDeliverComponents.componentItemIds = new String[componentHandles.size()];
                int i = 0;
                while (i < componentHandles.size()) {
                    IComponentHandle componentHandle = (IComponentHandle)componentHandles.get(i);
                    parmsDeliverComponents.componentItemIds[i] = componentHandle.getItemId().getUuidValue();
                    ++i;
                }
                result.add(parmsDeliverComponents);
            }
        } else {
            HashMap<IWorkspaceConnection, List<IComponentHandle>> sourceToComponentsMap = new HashMap<IWorkspaceConnection, List<IComponentHandle>>();
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(hierarchicalDeliverList.size() * 2));
            for (ParmsDeliverComponents hierarchicalDeliver : hierarchicalDeliverList) {
                IWorkspaceConnection sourceConnection = hierarchicalDeliver.sourceWorkspace.getWorkspaceConnection((IProgressMonitor)progress.newChild(1));
                ArrayList<IComponentHandle> components = (ArrayList<IComponentHandle>)sourceToComponentsMap.get(sourceConnection);
                if (components == null) {
                    components = new ArrayList<IComponentHandle>();
                    sourceToComponentsMap.put(sourceConnection, components);
                }
                components.addAll(hierarchicalDeliver.getComponentHandles());
            }
            Map<IWorkspaceConnection, Map<IWorkspaceConnection, List<IComponentHandle>>> componentHierarchyChildren = syncViewProxy.getComponentHierarchyChildren(sourceToComponentsMap, true, conflictingComponents, multipleParticipants);
            for (Map.Entry<IWorkspaceConnection, Map<IWorkspaceConnection, List<IComponentHandle>>> sourceToDestinationToComponentsEntry : componentHierarchyChildren.entrySet()) {
                IWorkspaceConnection sourceConnection = sourceToDestinationToComponentsEntry.getKey();
                for (Map.Entry<IWorkspaceConnection, List<IComponentHandle>> destinationToComponentsEntry : sourceToDestinationToComponentsEntry.getValue().entrySet()) {
                    IWorkspaceConnection destConnection = destinationToComponentsEntry.getKey();
                    List<IComponentHandle> componentHandles = destinationToComponentsEntry.getValue();
                    ParmsDeliverComponents parmsDeliverComponents = new ParmsDeliverComponents();
                    parmsDeliverComponents.hierarchicalDeliver = true;
                    parmsDeliverComponents.sourceWorkspaceExplicit = false;
                    parmsDeliverComponents.sourceWorkspace = new ParmsWorkspace();
                    parmsDeliverComponents.sourceWorkspace.repositoryUrl = sourceConnection.teamRepository().getRepositoryURI();
                    parmsDeliverComponents.sourceWorkspace.workspaceItemId = sourceConnection.getResolvedWorkspace().getItemId().getUuidValue();
                    parmsDeliverComponents.targetWorkspace = new ParmsWorkspace();
                    parmsDeliverComponents.targetWorkspace.repositoryUrl = destConnection.teamRepository().getRepositoryURI();
                    parmsDeliverComponents.targetWorkspace.workspaceItemId = destConnection.getResolvedWorkspace().getItemId().getUuidValue();
                    parmsDeliverComponents.componentItemIds = new String[componentHandles.size()];
                    int i = 0;
                    while (i < componentHandles.size()) {
                        IComponentHandle componentHandle = componentHandles.get(i);
                        parmsDeliverComponents.componentItemIds[i] = componentHandle.getItemId().getUuidValue();
                        ++i;
                    }
                    result.add(parmsDeliverComponents);
                }
            }
        }
        return result;
    }

    private static void deliver(IDeliverOperation deliverOperation, List<ParmsDeliverComponents> flatDeliverList, ISyncViewProxy syncViewProxy, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(flatDeliverList.size() * 3));
        for (ParmsDeliverComponents deliverComponents : flatDeliverList) {
            ITeamRepository repo = CommonUtil.getTeamRepository(deliverComponents.sourceWorkspace.repositoryUrl);
            IWorkspaceConnection sourceWorkspace = deliverComponents.sourceWorkspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(1));
            IWorkspaceConnection targetWorkspace = deliverComponents.targetWorkspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(1));
            SubMonitor subMonitor2 = SubMonitor.convert((IProgressMonitor)subMonitor.newChild(1), (int)deliverComponents.componentItemIds.length);
            String[] stringArray = deliverComponents.componentItemIds;
            int n = deliverComponents.componentItemIds.length;
            int n2 = 0;
            while (n2 < n) {
                String componentItemId = stringArray[n2];
                IComponentHandle component = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)componentItemId), null);
                IChangeHistorySyncReport report = syncViewProxy.getCompareReport(sourceWorkspace, targetWorkspace, (IProgressMonitor)subMonitor2.newChild(1));
                deliverOperation.deliver(sourceWorkspace, targetWorkspace, report, component, deliverComponents.reportComponentOps);
                ++n2;
            }
        }
    }

    public static int getFlowComponentsDilemaValue(ParmsDeliverDilemmaHandler deliverParms) {
        int flowComponents;
        if (deliverParms == null) {
            flowComponents = 0;
        } else if ("continue".equals(deliverParms.flowComponents)) {
            flowComponents = 0;
        } else if (deliverParms.flowComponents == null) {
            flowComponents = 0;
        } else if ("cancel".equals(deliverParms.flowComponents)) {
            flowComponents = 1;
        } else if ("fail".equals(deliverParms.flowComponents)) {
            flowComponents = 2;
        } else if ("no".equals(deliverParms.flowComponents)) {
            flowComponents = 3;
        } else {
            throw new IllegalArgumentException("The value of flowComponents must be one of cancel, continue, no or fail");
        }
        return flowComponents;
    }

    public static int getFlowToNonDefaultTarget(ParmsDeliverDilemmaHandler deliverParms) {
        int flowToNonDefaultTarget;
        if (deliverParms == null) {
            flowToNonDefaultTarget = 0;
        } else if ("continue".equals(deliverParms.flowToNonDefault)) {
            flowToNonDefaultTarget = 0;
        } else if (deliverParms.flowToNonDefault == null) {
            flowToNonDefaultTarget = 0;
        } else if ("cancel".equals(deliverParms.flowToNonDefault)) {
            flowToNonDefaultTarget = 1;
        } else if ("fail".equals(deliverParms.flowToNonDefault)) {
            flowToNonDefaultTarget = 2;
        } else {
            throw new IllegalArgumentException("The value of flowToNonDefault must be one of cancel, continue, no or fail");
        }
        return flowToNonDefaultTarget;
    }

    public static int getFlowWithIncomingRepalceDilemaValue(ParmsDeliverDilemmaHandler deliverParms) {
        int flowComponents;
        if (deliverParms == null) {
            flowComponents = 2;
        } else if (deliverParms.flowWithIncomingReplace == null) {
            flowComponents = 2;
        } else if ("continue".equals(deliverParms.flowWithIncomingReplace)) {
            flowComponents = 0;
        } else if ("cancel".equals(deliverParms.flowWithIncomingReplace)) {
            flowComponents = 1;
        } else if ("fail".equals(deliverParms.flowWithIncomingReplace)) {
            flowComponents = 2;
        } else if ("no".equals(deliverParms.flowWithIncomingReplace)) {
            flowComponents = 3;
        } else {
            throw new IllegalArgumentException("The value of flowWithIncomingReplace must be one of cancel, continue, no or fail");
        }
        return flowComponents;
    }
}

