/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.rest.util;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.FlowTableUtil;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.DeliveryRequiresHistoryReorderingDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.FilesystemRestClientDTOchangesetFactory;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.GapChangeSetsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.ProblemChangeSetsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.BaselineDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.BaselineHierarchyDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.BaselineSetDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ComponentHierarchyDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ConfigurationDescriptor2DTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ConfigurationDescriptorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ConnectionDescriptor2DTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ConnectionDescriptorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ExceptionDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.FilesystemRestClientDTOcoreFactory;
import com.ibm.team.filesystem.common.internal.rest.client.core.PathDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ReadScopeDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.SandboxDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareableDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.StackTraceElementDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.StatusDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceDetailsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceFlowEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.locks.ComponentLockReportDTO;
import com.ibm.team.filesystem.common.internal.rest.client.locks.ContributorNameDTO;
import com.ibm.team.filesystem.common.internal.rest.client.locks.FilesystemRestClientDTOlocksFactory;
import com.ibm.team.filesystem.common.internal.rest.client.locks.StreamLockReportDTO;
import com.ibm.team.filesystem.common.internal.rest.client.locks.VersionableLockDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.ConfigurationDescriptor;
import com.ibm.team.scm.client.internal.ConnectionDescriptor;
import com.ibm.team.scm.client.internal.IConfigurationDescriptor;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineHierarchyNode;
import com.ibm.team.scm.common.IBaselineHierarchyResult;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHierarchyResult;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IComponentHierarchyNode;
import com.ibm.team.scm.common.IComponentHierarchyResult;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.ICurrentComponentInfo;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IAccessGroupScope;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.IArchivedScope;
import com.ibm.team.scm.common.dto.IComponentLockReport;
import com.ibm.team.scm.common.dto.IContributorDeferringScope;
import com.ibm.team.scm.common.dto.INameItemPair;
import com.ibm.team.scm.common.dto.IPrivateScope;
import com.ibm.team.scm.common.dto.IProcessAreaScope;
import com.ibm.team.scm.common.dto.IPublicScope;
import com.ibm.team.scm.common.dto.IReadScope;
import com.ibm.team.scm.common.dto.IStreamLockReport;
import com.ibm.team.scm.common.dto.ITeamAreaPrivateScope;
import com.ibm.team.scm.common.dto.IUnknownScope;
import com.ibm.team.scm.common.dto.IVersionableLock;
import com.ibm.team.scm.common.internal.dto.AccessGroupScope;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class CoreUtil {
    public static ShareDTO translateShare(IShare share, IProgressMonitor monitor) {
        ShareDTO translation = FilesystemRestClientDTOcoreFactory.eINSTANCE.createShareDTO();
        ISharingDescriptor sharingDescriptor = share.getSharingDescriptor();
        translation.setComponentItemId(sharingDescriptor.getComponent().getItemId().getUuidValue());
        translation.setComponentName(sharingDescriptor.getComponentName());
        translation.setRootVersionableItemId(sharingDescriptor.getRootVersionable().getItemId().getUuidValue());
        translation.setRootVersionableItemType(CoreUtil.getVersionableItemType(sharingDescriptor.getRootVersionable()));
        translation.setSandboxPath(share.getSandbox().getRoot().toOSString());
        translation.setPath(CoreUtil.translatePath(share.getPath()));
        translation.setContextItemId(sharingDescriptor.getConnectionHandle().getItemId().getUuidValue());
        translation.setIsWorkspaceContext(sharingDescriptor.getConnectionHandle() instanceof IWorkspaceHandle);
        translation.setContextName(sharingDescriptor.getConnectionName());
        translation.setRepositoryId(sharingDescriptor.getRepositoryId().getUuidValue());
        try {
            translation.setIsLoadedWithAnotherName(share.isLoadedWithAnotherName(monitor));
        }
        catch (FileSystemException fileSystemException) {
            // empty catch block
        }
        return translation;
    }

    public static String translatePathToString(PathDTO path) {
        StringBuffer buf = new StringBuffer();
        for (String seg : path.getSegments()) {
            buf.append('/');
            buf.append(seg);
        }
        return buf.toString();
    }

    public static PathDTO translatePath(IRelativeLocation path) {
        return CoreUtil.translatePath(path.segments());
    }

    public static PathDTO translatePath(IShareable shareable) {
        return CoreUtil.translatePath(shareable.getLocalPath());
    }

    public static PathDTO translatePath(String path) {
        return CoreUtil.translatePath(new Path(path).segments());
    }

    public static PathDTO translatePath(String[] pathSegments) {
        PathDTO path = FilesystemRestClientDTOcoreFactory.eINSTANCE.createPathDTO();
        path.getSegments().addAll(Arrays.asList(pathSegments));
        return path;
    }

    public static PathDTO translatePath(IAncestorReport report) {
        PathDTO path = FilesystemRestClientDTOcoreFactory.eINSTANCE.createPathDTO();
        Iterator iPairs = report.getNameItemPairs().iterator();
        iPairs.next();
        while (iPairs.hasNext()) {
            path.getSegments().add(((INameItemPair)iPairs.next()).getName());
        }
        return path;
    }

    public static ConfigurationDescriptorDTO translateConfigurationDescriptor(ConfigurationDescriptor descriptor) {
        ConfigurationDescriptorDTO configurationDescriptor = FilesystemRestClientDTOcoreFactory.eINSTANCE.createConfigurationDescriptorDTO();
        ConnectionDescriptorDTO connectionDescriptor = FilesystemRestClientDTOcoreFactory.eINSTANCE.createConnectionDescriptorDTO();
        connectionDescriptor.setRepositoryId(descriptor.id.getUuidValue());
        connectionDescriptor.setRepositoryURL(descriptor.uri);
        connectionDescriptor.setContextItemId(descriptor.connectionHandle.getItemId().getUuidValue());
        connectionDescriptor.setIsWorkspaceContext(descriptor.connectionHandle instanceof IWorkspaceHandle);
        configurationDescriptor.setConnection(connectionDescriptor);
        configurationDescriptor.setComponentItemId(descriptor.componentHandle.getItemId().getUuidValue());
        return configurationDescriptor;
    }

    public static ConfigurationDescriptor2DTO translateConfigurationDescriptor(IConfigurationDescriptor descriptor) {
        ConfigurationDescriptor2DTO configurationDescriptor = FilesystemRestClientDTOcoreFactory.eINSTANCE.createConfigurationDescriptor2DTO();
        ConnectionDescriptor2DTO connectionDescriptor = FilesystemRestClientDTOcoreFactory.eINSTANCE.createConnectionDescriptor2DTO();
        connectionDescriptor.setRepositoryId(descriptor.getRepositoryId().getUuidValue());
        IContextHandle connectionHandle = descriptor.getConnectionHandle();
        connectionDescriptor.setContextItemId(connectionHandle.getItemId().getUuidValue());
        connectionDescriptor.setIsWorkspaceContext(connectionHandle instanceof IWorkspaceHandle);
        configurationDescriptor.setConnection(connectionDescriptor);
        configurationDescriptor.setComponentItemId(descriptor.getComponentHandle().getItemId().getUuidValue());
        return configurationDescriptor;
    }

    public static ConfigurationDescriptorDTO translateConfigurationDescriptor(ConfigurationFacade descriptor) {
        ConfigurationDescriptorDTO configurationDescriptor = FilesystemRestClientDTOcoreFactory.eINSTANCE.createConfigurationDescriptorDTO();
        ConnectionDescriptorDTO connectionDescriptor = FilesystemRestClientDTOcoreFactory.eINSTANCE.createConnectionDescriptorDTO();
        connectionDescriptor.setRepositoryId(descriptor.getRepositoryId().getUuidValue());
        connectionDescriptor.setRepositoryURL(descriptor.getRepositoryURI());
        IContextHandle connectionHandle = descriptor.getConnectionHandle();
        connectionDescriptor.setContextItemId(connectionHandle.getItemId().getUuidValue());
        connectionDescriptor.setIsWorkspaceContext(connectionHandle instanceof IWorkspaceHandle);
        configurationDescriptor.setConnection(connectionDescriptor);
        configurationDescriptor.setComponentItemId(descriptor.getComponentHandle().getItemId().getUuidValue());
        return configurationDescriptor;
    }

    public static ConnectionDescriptorDTO translateConnection(IConnection connection) {
        ConnectionDescriptorDTO connectionDescriptor = FilesystemRestClientDTOcoreFactory.eINSTANCE.createConnectionDescriptorDTO();
        ITeamRepository teamRepository = connection.teamRepository();
        connectionDescriptor.setRepositoryId(CoreUtil.translateRepositoryId(teamRepository));
        connectionDescriptor.setRepositoryURL(teamRepository.getRepositoryURI());
        connectionDescriptor.setContextItemId(connection.getContextHandle().getItemId().getUuidValue());
        connectionDescriptor.setIsWorkspaceContext(connection.getContextHandle() instanceof IWorkspaceHandle);
        return connectionDescriptor;
    }

    public static Map<UUID, IContributor> fetchCreatorAndGetModifiedByForBaselines(ITeamRepository repo, Collection<IBaseline> baselines, IProgressMonitor monitor) throws TeamRepositoryException {
        HashMap<UUID, IContributorHandle> contributorHandles = new HashMap<UUID, IContributorHandle>();
        CoreUtil.accumulateCreatorAndModifiedByForBaselines(baselines, contributorHandles);
        return CoreUtil.fetchContributors(repo, contributorHandles, monitor);
    }

    private static void accumulateCreatorAndModifiedByForBaselines(Collection<IBaseline> baselines, Map<UUID, IContributorHandle> contributorHandles) {
        for (IBaseline baseline : baselines) {
            IContributorHandle contributor = baseline.getCreator();
            if (contributor != null) {
                contributorHandles.put(contributor.getItemId(), contributor);
            }
            if ((contributor = baseline.getModifiedBy()) == null) continue;
            contributorHandles.put(contributor.getItemId(), contributor);
        }
    }

    private static Map<UUID, IContributor> fetchContributors(ITeamRepository repo, Map<UUID, IContributorHandle> contributorHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        List contributors = repo.itemManager().fetchCompleteItems(new ArrayList<IContributorHandle>(contributorHandles.values()), 0, monitor);
        HashMap<UUID, IContributor> result = new HashMap<UUID, IContributor>(contributors.size());
        for (Object obj : contributors) {
            if (!(obj instanceof IContributor)) continue;
            IContributor contributor = (IContributor)obj;
            result.put(contributor.getItemId(), contributor);
        }
        return result;
    }

    public static Map<UUID, IComponent> fetchComponentsForBaselines(ITeamRepository repo, Collection<IBaseline> baselines, IProgressMonitor monitor) throws TeamRepositoryException {
        HashMap<UUID, IComponentHandle> componentHandles = new HashMap<UUID, IComponentHandle>();
        for (IBaseline baseline : baselines) {
            IComponentHandle componentHandle = baseline.getComponent();
            componentHandles.put(componentHandle.getItemId(), componentHandle);
        }
        List components = repo.itemManager().fetchCompleteItems(new ArrayList(componentHandles.values()), 0, monitor);
        HashMap<UUID, IComponent> result = new HashMap<UUID, IComponent>(components.size());
        for (Object obj : components) {
            if (!(obj instanceof IComponent)) continue;
            IComponent component = (IComponent)obj;
            result.put(component.getItemId(), component);
        }
        return result;
    }

    public static BaselineDTO translateBaseline(ITeamRepository repository, IBaselineHandle baselineHandle, IBaseline baseline, Map<UUID, IContributor> contributors, Map<UUID, IComponent> components, IBaselineConnection baselineConnection) {
        BaselineDTO baselineDTO = FilesystemRestClientDTOcoreFactory.eINSTANCE.createBaselineDTO();
        baselineDTO.setItemId(baselineHandle.getItemId().getUuidValue());
        baselineDTO.setRepositoryId(CoreUtil.translateRepositoryId(repository));
        baselineDTO.setRepositoryURL(repository.getRepositoryURI());
        if (baseline != null) {
            baselineDTO.setId(baseline.getId());
            baselineDTO.setName(baseline.getName());
            baselineDTO.setComment(baseline.getComment());
            baselineDTO.setComponentItemId(baseline.getComponent().getItemId().getUuidValue());
            IComponent component = components.get(baseline.getComponent().getItemId());
            if (component != null) {
                baselineDTO.setComponentName(component.getName());
            }
            baselineDTO.setCreationDate(baseline.getCreationDate().getTime());
            IContributorHandle creator = baseline.getCreator();
            baselineDTO.setCreatorContributorItemId(creator.getItemId().getUuidValue());
            IContributor contributor = contributors.get(creator.getItemId());
            if (contributor != null) {
                baselineDTO.setCreatorContributorName(contributor.getName());
            }
            baselineDTO.setModifiedDate(baseline.modified().getTime());
            IContributorHandle modifiedBy = baseline.getModifiedBy();
            if (modifiedBy != null) {
                baselineDTO.setModifierContributorItemId(modifiedBy.getItemId().getUuidValue());
                contributor = contributors.get(modifiedBy.getItemId());
                if (contributor != null) {
                    baselineDTO.setModifierContributorName(contributor.getName());
                }
            }
            if (baselineConnection != null) {
                baselineDTO.setTags(baselineConnection.getTags());
            }
        }
        return baselineDTO;
    }

    public static BaselineSetDTO translateBaselineSet(ITeamRepository repository, IBaselineSet baselineSet) {
        BaselineSetDTO baselineSetDTO = FilesystemRestClientDTOcoreFactory.eINSTANCE.createBaselineSetDTO();
        baselineSetDTO.setComment(baselineSet.getComment());
        baselineSetDTO.setCreationDate(baselineSet.getCreationDate().getTime());
        baselineSetDTO.setCreatorContributorItemId(baselineSet.getCreator().getItemId().getUuidValue());
        baselineSetDTO.setItemId(baselineSet.getItemId().getUuidValue());
        baselineSetDTO.setModifiedDate(baselineSet.modified().getTime());
        baselineSetDTO.setModifierContributorItemId(baselineSet.getModifiedBy().getItemId().getUuidValue());
        baselineSetDTO.setName(baselineSet.getName());
        baselineSetDTO.setOwnerWorkspaceItemId(baselineSet.getOwner().getItemId().getUuidValue());
        baselineSetDTO.setRepositoryId(CoreUtil.translateRepositoryId(repository));
        baselineSetDTO.setRepositoryURL(repository.getRepositoryURI());
        for (IBaselineHandle baselineHandle : baselineSet.getBaselines()) {
            baselineSetDTO.getBaselineItemIds().add(baselineHandle.getItemId().getUuidValue());
        }
        return baselineSetDTO;
    }

    public static ProblemChangeSetsDTO translateProblemChangeSetsDTO(ConfigurationFacade configurationFacade, Collection<? extends IChangeSetHandle> changeSets) {
        ProblemChangeSetsDTO problemChangeSetsDTO = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createProblemChangeSetsDTO();
        problemChangeSetsDTO.setRepositoryId(configurationFacade.getRepositoryId().getUuidValue());
        problemChangeSetsDTO.setRepositoryURL(configurationFacade.getRepositoryURI());
        problemChangeSetsDTO.setWorkspaceItemId(configurationFacade.getContextHandle().getItemId().getUuidValue());
        for (IChangeSetHandle iChangeSetHandle : changeSets) {
            problemChangeSetsDTO.getChangeSetItemIds().add(iChangeSetHandle.getItemId().getUuidValue());
        }
        return problemChangeSetsDTO;
    }

    public static ProblemChangeSetsDTO translateProblemChangeSetsDTO(IWorkspaceConnection workspace, Collection<? extends IChangeSetHandle> changeSets) {
        ProblemChangeSetsDTO problemChangeSetsDTO = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createProblemChangeSetsDTO();
        ITeamRepository teamRepository = workspace.teamRepository();
        problemChangeSetsDTO.setRepositoryId(CoreUtil.translateRepositoryId(teamRepository));
        problemChangeSetsDTO.setRepositoryURL(teamRepository.getRepositoryURI());
        problemChangeSetsDTO.setWorkspaceItemId(workspace.getContextHandle().getItemId().getUuidValue());
        for (IChangeSetHandle iChangeSetHandle : changeSets) {
            problemChangeSetsDTO.getChangeSetItemIds().add(iChangeSetHandle.getItemId().getUuidValue());
        }
        return problemChangeSetsDTO;
    }

    public static GapChangeSetsDTO translateGapProblemChangeSetsDTO(IWorkspaceConnection workspace, Collection<IChangeSetHandle> changeSets, boolean handlingSuspended) {
        GapChangeSetsDTO gapChangeSetsDTO = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createGapChangeSetsDTO();
        ITeamRepository teamRepository = workspace.teamRepository();
        gapChangeSetsDTO.setRepositoryId(CoreUtil.translateRepositoryId(teamRepository));
        gapChangeSetsDTO.setRepositoryURL(teamRepository.getRepositoryURI());
        gapChangeSetsDTO.setWorkspaceItemId(workspace.getContextHandle().getItemId().getUuidValue());
        for (IChangeSetHandle changeSet : changeSets) {
            gapChangeSetsDTO.getChangeSetItemIds().add(changeSet.getItemId().getUuidValue());
        }
        gapChangeSetsDTO.setHandlingSuspended(handlingSuspended);
        return gapChangeSetsDTO;
    }

    public static BaselineDTO[] translateBaselineSetHierarchyResult(IBaselineSetHierarchyResult hierarchyResult, IWorkspaceManager workspaceManager, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        BaselineDTO[] result = new BaselineDTO[hierarchyResult.getRoots().size()];
        int i = 0;
        SubMonitor loopProgress = progress.newChild(100).setWorkRemaining(hierarchyResult.getRoots().size() * 100);
        for (IBaselineHierarchyNode node : hierarchyResult.getRoots()) {
            IBaselineConnection baselineConnection = workspaceManager.getBaselineConnection(node.getBaselineHandle(), (IProgressMonitor)loopProgress.newChild(10));
            BaselineDTO baselineDTO = CoreUtil.translateBaselineHierarchy(baselineConnection, (IProgressMonitor)loopProgress.newChild(90));
            result[i++] = baselineDTO;
        }
        return result;
    }

    public static WorkspaceDetailsDTO translateWorkspace(IWorkspaceConnection connection, boolean includeComponents, boolean includeComponentHierarchy, boolean includeFlowTargets, boolean includeComponentOwner, boolean includeComponentReadScope, boolean includeSandboxSubfolder, boolean refresh, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        WorkspaceDetailsDTO workspace = CoreUtil.translateWorkspace(connection.teamRepository(), connection.getResolvedWorkspace(), progress.newChild(10));
        if (includeComponents) {
            HashMap<UUID, IComponent> components = new HashMap<UUID, IComponent>();
            HashMap<UUID, IComponent> componentsNotInWorkspace = new HashMap<UUID, IComponent>();
            HashMap<UUID, IBaseline> baselines = new HashMap<UUID, IBaseline>();
            HashMap<UUID, IAuditableHandle> componentOwners = new HashMap<UUID, IAuditableHandle>();
            HashMap<UUID, IReadScope> componentReadScopes = new HashMap<UUID, IReadScope>();
            HashMap<UUID, UUID> lockedComponents = new HashMap<UUID, UUID>();
            CoreUtil.fetchComponentsAndBaselines(connection, components, baselines, refresh, progress.newChild(20));
            IComponentHierarchyResult hierarchy = null;
            if (includeComponentHierarchy) {
                hierarchy = connection.getComponentHierarchy(Collections.emptySet());
                CoreUtil.fetchComponentsNotInWorkspace(connection.teamRepository(), components, hierarchy, componentsNotInWorkspace, progress.newChild(10));
            }
            progress.setWorkRemaining(60);
            HashMap<UUID, IContributorHandle> contributorHandles = new HashMap<UUID, IContributorHandle>();
            CoreUtil.accumulateCreatorAndModifiedByForBaselines(baselines.values(), contributorHandles);
            CoreUtil.accumultateLockByForComponents(connection, components.values(), lockedComponents, contributorHandles);
            Map<UUID, IContributor> contributors = CoreUtil.fetchContributors(connection.teamRepository(), contributorHandles, (IProgressMonitor)progress.newChild(20));
            if (includeComponentOwner) {
                CoreUtil.fetchOwnerForComponents(connection.teamRepository(), components, componentOwners, progress.newChild(20));
            }
            progress.setWorkRemaining(20);
            if (includeComponentReadScope) {
                CoreUtil.fetchVisibilityForComponents(connection.teamRepository(), components, componentReadScopes, progress.newChild(20));
            }
            for (ICurrentComponentInfo currentComponentInfo : connection.getComponentsInfo()) {
                WorkspaceComponentDTO componentDto = CoreUtil.translateComponent(connection, currentComponentInfo, includeComponentOwner, includeComponentReadScope, components, baselines, contributors, componentOwners, componentReadScopes, lockedComponents);
                workspace.getComponents().add(componentDto);
            }
            if (includeComponentHierarchy) {
                for (IComponentHierarchyNode node : hierarchy.getRoots()) {
                    ComponentHierarchyDTO componentHierarchyDto = CoreUtil.translateComponentHierarchy(connection.getResolvedWorkspace(), node, components, componentsNotInWorkspace);
                    componentHierarchyDto.setRoot(true);
                    workspace.getComponentHierarchies().add(componentHierarchyDto);
                }
            }
        }
        if (includeFlowTargets) {
            CoreUtil.translateFlowTargets(connection, workspace);
        }
        if (includeSandboxSubfolder) {
            boolean useDefaultSandboxSubfolder;
            workspace.setSandboxSubfolder(connection.getParentFolder());
            try {
                useDefaultSandboxSubfolder = connection.getWorkspaceParentFolderConfigurationData((IProgressMonitor)progress.newChild(2));
            }
            catch (TeamRepositoryException e) {
                useDefaultSandboxSubfolder = false;
            }
            workspace.setUseDefaultSandboxSubfolder(useDefaultSandboxSubfolder);
        }
        progress.done();
        return workspace;
    }

    public static WorkspaceDetailsDTO translateWorkspace(IWorkspaceConnection connection, boolean includeComponents, boolean includeComponentHierarchy, boolean includeFlowTargets, boolean includeComponentOwner, boolean includeComponentReadScope, IProgressMonitor monitor) throws TeamRepositoryException {
        return CoreUtil.translateWorkspace(connection, includeComponents, includeComponentHierarchy, includeFlowTargets, includeComponentOwner, includeComponentReadScope, false, false, monitor);
    }

    private static void accumultateLockByForComponents(IWorkspaceConnection connection, Collection<IComponent> components, Map<UUID, UUID> lockedComponents, Map<UUID, IContributorHandle> contributorHandles) {
        for (IComponent component : components) {
            String lockOwnerItemID = connection.getLockOwnerItemID((IComponentHandle)component);
            if (lockOwnerItemID == null || lockOwnerItemID.isEmpty()) continue;
            IContributorHandle contributorHandle = (IContributorHandle)IContributor.ITEM_TYPE.createItemHandle(UUID.valueOf((String)lockOwnerItemID), null);
            contributorHandles.put(contributorHandle.getItemId(), contributorHandle);
            lockedComponents.put(component.getItemId(), contributorHandle.getItemId());
        }
    }

    public static BaselineDTO translateBaselineHierarchy(IBaselineConnection connection, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)125);
        ITeamRepository teamRepository = connection.teamRepository();
        IBaselineHierarchyResult baselineHierarchy = connection.getBaselineHierarchy((IProgressMonitor)progress.newChild(25));
        Map flattenedSubcomponents = baselineHierarchy.getFlattenedElementsMap();
        Collection values = flattenedSubcomponents.values();
        ArrayList allBaselines = new ArrayList(values);
        List fetched = teamRepository.itemManager().fetchCompleteItems(allBaselines, 0, (IProgressMonitor)progress.newChild(25));
        HashMap<UUID, IBaseline> baselines = new HashMap<UUID, IBaseline>();
        ArrayList<IComponentHandle> allComponents = new ArrayList<IComponentHandle>();
        for (Object obj : fetched) {
            if (!(obj instanceof IBaseline)) continue;
            IBaseline baseline = (IBaseline)obj;
            baselines.put(baseline.getItemId(), baseline);
            allComponents.add(baseline.getComponent());
        }
        List fetchedComponents = teamRepository.itemManager().fetchCompleteItems(allComponents, 0, (IProgressMonitor)progress.newChild(25));
        HashMap<UUID, IComponent> components = new HashMap<UUID, IComponent>();
        for (Object obj : fetchedComponents) {
            if (!(obj instanceof IComponent)) continue;
            IComponent component = (IComponent)obj;
            components.put(component.getItemId(), component);
        }
        Map<UUID, IContributor> contributors = CoreUtil.fetchCreatorAndGetModifiedByForBaselines(teamRepository, baselines.values(), (IProgressMonitor)progress.newChild(1));
        IBaselineHandle baselineHandle = connection.getBaseline();
        IBaselineConnection baselineConnection = SCMPlatform.getWorkspaceManager((ITeamRepository)teamRepository).getBaselineConnection(baselineHandle, (IProgressMonitor)progress.newChild(1));
        BaselineDTO translateBaseline = CoreUtil.translateBaseline(teamRepository, baselineHandle, (IBaseline)baselines.get(baselineHandle.getItemId()), contributors, components, baselineConnection);
        for (IBaselineHierarchyNode node : baselineHierarchy.getRoots()) {
            BaselineHierarchyDTO dto = CoreUtil.translateBaselineHierarchy(node, teamRepository, baselines, contributors, components);
            dto.setRoot(true);
            translateBaseline.setHierarchy(dto);
        }
        return translateBaseline;
    }

    public static void fetchComponentsNotInWorkspace(ITeamRepository repository, Map<UUID, IComponent> componentsInWorkspace, IComponentHierarchyResult hierarchy, Map<UUID, IComponent> componentsNotInWorkspace, SubMonitor monitor) throws TeamRepositoryException {
        Queue toVisit = NewCollection.arrayQueue();
        toVisit.addAll(hierarchy.getRoots());
        HashMap<UUID, IComponentHandle> componentsNotInWorkspaceHandles = new HashMap<UUID, IComponentHandle>();
        while (!toVisit.isEmpty()) {
            IComponentHierarchyNode node = (IComponentHierarchyNode)toVisit.remove();
            IComponentHandle parentComponent = node.getComponentHandle();
            UUID parentUuid = parentComponent.getItemId();
            if (!componentsInWorkspace.containsKey(parentUuid)) {
                componentsNotInWorkspaceHandles.put(parentUuid, parentComponent);
            }
            for (IComponentHierarchyNode child : node.getChildren()) {
                toVisit.add(child);
            }
        }
        List componentsNotInWorkspaceList = repository.itemManager().fetchCompleteItems(new ArrayList(componentsNotInWorkspaceHandles.values()), 0, (IProgressMonitor)monitor);
        for (Object obj : componentsNotInWorkspaceList) {
            if (!(obj instanceof IComponent)) continue;
            IComponent componentNotInWorkspace = (IComponent)obj;
            componentsNotInWorkspace.put(componentNotInWorkspace.getItemId(), componentNotInWorkspace);
        }
    }

    public static ComponentHierarchyDTO translateComponentHierarchy(IWorkspace workspace, IComponentHierarchyNode node, Map<UUID, IComponent> componentsInWorkspace, Map<UUID, IComponent> componentsNotInWorkspace) {
        ComponentHierarchyDTO componentHierarchyDto = FilesystemRestClientDTOcoreFactory.eINSTANCE.createComponentHierarchyDTO();
        UUID componentUuid = node.getComponentHandle().getItemId();
        IComponent component = componentsInWorkspace.get(componentUuid);
        componentHierarchyDto.setInWorkspace(component != null);
        if (component == null) {
            component = componentsNotInWorkspace.get(componentUuid);
        }
        componentHierarchyDto.setAccessible(component != null);
        if (component != null) {
            componentHierarchyDto.setName(component.getName());
        }
        componentHierarchyDto.setWorkspaceItemId(workspace.getItemId().getUuidValue());
        componentHierarchyDto.setComponentItemId(componentUuid.getUuidValue());
        componentHierarchyDto.setRoot(false);
        componentHierarchyDto.setBranchContainsCycles(node.isBranchContainsCycles());
        componentHierarchyDto.setInCycle(node.isInCycle());
        for (UUID ancestorUuid : node.getAncestorPath()) {
            componentHierarchyDto.getAncestorPath().add(ancestorUuid.getUuidValue());
        }
        for (IComponentHierarchyNode child : node.getChildren()) {
            ComponentHierarchyDTO childDto = CoreUtil.translateComponentHierarchy(workspace, child, componentsInWorkspace, componentsNotInWorkspace);
            componentHierarchyDto.getSubcomponents().add(childDto);
        }
        return componentHierarchyDto;
    }

    private static BaselineHierarchyDTO translateBaselineHierarchy(IBaselineHierarchyNode node, ITeamRepository repository, Map<UUID, IBaseline> allBaselines, Map<UUID, IContributor> contributors, Map<UUID, IComponent> components) {
        BaselineHierarchyDTO baselineHierarchyDto = FilesystemRestClientDTOcoreFactory.eINSTANCE.createBaselineHierarchyDTO();
        IBaseline baseline = allBaselines.get(node.getBaselineHandle().getItemId());
        baselineHierarchyDto.setItemId(node.getBaselineHandle().getItemId().getUuidValue());
        baselineHierarchyDto.setRepositoryId(CoreUtil.translateRepositoryId(repository));
        baselineHierarchyDto.setRepositoryURL(repository.getRepositoryURI());
        baselineHierarchyDto.setRoot(false);
        baselineHierarchyDto.setBranchContainsCycles(node.isBranchContainsCycles());
        baselineHierarchyDto.setInCycle(node.isInCycle());
        baselineHierarchyDto.setAccessible(baseline != null);
        if (baseline != null) {
            baselineHierarchyDto.setId(baseline.getId());
            baselineHierarchyDto.setName(baseline.getName());
            baselineHierarchyDto.setComment(baseline.getComment());
            UUID componentItemId = baseline.getComponent().getItemId();
            baselineHierarchyDto.setComponentItemId(componentItemId.getUuidValue());
            IComponent component = components.get(componentItemId);
            if (component != null) {
                baselineHierarchyDto.setComponentName(component.getName());
            }
            baselineHierarchyDto.setCreationDate(baseline.getCreationDate().getTime());
            IContributorHandle creator = baseline.getCreator();
            baselineHierarchyDto.setCreatorContributorItemId(creator.getItemId().getUuidValue());
            IContributor contributor = contributors.get(creator.getItemId());
            if (contributor != null) {
                baselineHierarchyDto.setCreatorContributorName(contributor.getName());
            }
            baselineHierarchyDto.setModifiedDate(baseline.modified().getTime());
            IContributorHandle modifiedBy = baseline.getModifiedBy();
            if (modifiedBy != null) {
                baselineHierarchyDto.setModifierContributorItemId(modifiedBy.getItemId().getUuidValue());
                contributor = contributors.get(modifiedBy.getItemId());
                if (contributor != null) {
                    baselineHierarchyDto.setModifierContributorName(contributor.getName());
                }
            }
        }
        for (UUID ancestorUuid : node.getAncestorPath()) {
            baselineHierarchyDto.getAncestorPath().add(ancestorUuid.getUuidValue());
        }
        for (IBaselineHierarchyNode child : node.getChildren()) {
            BaselineHierarchyDTO childDto = CoreUtil.translateBaselineHierarchy(child, repository, allBaselines, contributors, components);
            baselineHierarchyDto.getSubbaselines().add(childDto);
        }
        return baselineHierarchyDto;
    }

    private static void translateFlowTargets(IWorkspaceConnection connection, WorkspaceDetailsDTO workspace) {
        WorkspaceFlowEntryDTO flowEntryDTO;
        IFlowNodeHandle flowNode;
        List flowEntries = workspace.getFlowEntries();
        IFlowTable flowTable = connection.getFlowTable();
        ConnectionDescriptor defaultIncomingCollaboration = FlowTableUtil.getDefaultIncomingCollaborationDescriptor(connection);
        IWorkspaceHandle defaultIncomingCollaborationHandle = (IWorkspaceHandle)(defaultIncomingCollaboration == null ? null : defaultIncomingCollaboration.connectionHandle);
        ConnectionDescriptor defaultOutgoingCollaboration = FlowTableUtil.getDefaultOutgoingCollaborationDescriptor(connection);
        IWorkspaceHandle defaultOutgoingCollaborationHandle = (IWorkspaceHandle)(defaultOutgoingCollaboration == null ? null : defaultOutgoingCollaboration.connectionHandle);
        ConnectionDescriptor currentIncomingCollaboration = FlowTableUtil.getCurrentIncomingCollaborationDescriptor(connection);
        IWorkspaceHandle currentIncomingCollaborationHandle = (IWorkspaceHandle)(currentIncomingCollaboration == null ? null : currentIncomingCollaboration.connectionHandle);
        ConnectionDescriptor currentOutgoingCollaboration = FlowTableUtil.getCurrentOutgoingCollaborationDescriptor(connection);
        IWorkspaceHandle currentOutgoingCollaborationHandle = (IWorkspaceHandle)(currentOutgoingCollaboration == null ? null : currentOutgoingCollaboration.connectionHandle);
        HashMap<UUID, WorkspaceFlowEntryDTO> flowIdToEntryMap = new HashMap<UUID, WorkspaceFlowEntryDTO>();
        for (IFlowEntry entry : flowTable.acceptSources()) {
            flowNode = entry.getFlowNode();
            if (!(flowNode instanceof IWorkspaceHandle) || flowIdToEntryMap.containsKey(flowNode.getItemId())) continue;
            flowEntryDTO = CoreUtil.translateFlowEntry(entry, defaultIncomingCollaborationHandle, defaultOutgoingCollaborationHandle, currentIncomingCollaborationHandle, currentOutgoingCollaborationHandle, connection.teamRepository(), flowTable.getComponentScopes(flowNode));
            flowEntryDTO.setIncomingFlow(true);
            flowIdToEntryMap.put(flowNode.getItemId(), flowEntryDTO);
        }
        for (IFlowEntry entry : flowTable.deliverTargets()) {
            flowNode = entry.getFlowNode();
            if (!(flowNode instanceof IWorkspaceHandle)) continue;
            flowEntryDTO = (WorkspaceFlowEntryDTO)flowIdToEntryMap.get(flowNode.getItemId());
            if (flowEntryDTO == null) {
                flowEntryDTO = CoreUtil.translateFlowEntry(entry, defaultIncomingCollaborationHandle, defaultOutgoingCollaborationHandle, currentIncomingCollaborationHandle, currentOutgoingCollaborationHandle, connection.teamRepository(), flowTable.getComponentScopes(flowNode));
            }
            flowEntryDTO.setOutgoingFlow(true);
            flowIdToEntryMap.put(flowNode.getItemId(), flowEntryDTO);
        }
        flowEntries.addAll(flowIdToEntryMap.values());
    }

    private static WorkspaceComponentDTO translateComponent(IWorkspaceConnection connection, ICurrentComponentInfo currentComponentInfo, boolean includeComponentOwner, boolean includeComponentReadScope, Map<UUID, IComponent> components, Map<UUID, IBaseline> baselines, Map<UUID, IContributor> contributors, Map<UUID, IAuditableHandle> componentOwners, Map<UUID, IReadScope> componentReadScopes, Map<UUID, UUID> lockedComponents) {
        UUID lockedById;
        WorkspaceComponentDTO componentDto = FilesystemRestClientDTOcoreFactory.eINSTANCE.createWorkspaceComponentDTO();
        IComponentHandle componentHandle = currentComponentInfo.getComponent();
        UUID componentUuid = componentHandle.getItemId();
        componentDto.setItemId(componentUuid.getUuidValue());
        IComponent component = components.get(componentUuid);
        if (component != null) {
            componentDto.setName(component.getName());
            componentDto.setRootFolder(component.getRootFolder().getItemId().getUuidValue());
        }
        List changeSetHandles = connection.activeChangeSets(componentHandle);
        for (IChangeSetHandle changeSet : changeSetHandles) {
            componentDto.getActiveChangeSetIds().add(changeSet.getItemId().getUuidValue());
        }
        IChangeSetHandle currentChangeSet = connection.getCurrentChangeSet(componentHandle);
        if (currentChangeSet != null) {
            componentDto.setCurrentChangeSetId(currentChangeSet.getItemId().getUuidValue());
        }
        IBaseline baseline = baselines.get(currentComponentInfo.basis().getItemId());
        boolean isAtBaseline = true;
        if (baseline != null) {
            BaselineDTO baselineDTO = CoreUtil.translateBaseline(connection.teamRepository(), (IBaselineHandle)baseline.getItemHandle(), baseline, contributors, components, null);
            componentDto.setBaseline(baselineDTO);
            isAtBaseline = !currentComponentInfo.isHierarchyDivergedFromBasis();
        }
        componentDto.setAtBaseline(isAtBaseline);
        if (includeComponentOwner) {
            IAuditableHandle owner = componentOwners.get(componentUuid);
            componentDto.setOwner(owner);
        }
        if (includeComponentReadScope) {
            IReadScope scope = componentReadScopes.get(componentUuid);
            componentDto.setReadScope(CoreUtil.translate(scope));
        }
        if ((lockedById = lockedComponents.get(component.getItemId())) != null) {
            IContributor contributor = contributors.get(lockedById);
            boolean isCurrentUser = false;
            if (connection.teamRepository().loggedInContributor() != null) {
                isCurrentUser = connection.teamRepository().loggedInContributor().getItemId().equals((Object)lockedById);
            }
            componentDto.setLockedBy(CoreUtil.getContributorNameDTO(lockedById, contributor, isCurrentUser));
        }
        return componentDto;
    }

    private static void fetchComponentsAndBaselines(IWorkspaceConnection connection, Map<UUID, IComponent> components, Map<UUID, IBaseline> baselines, boolean refresh, SubMonitor monitor) throws TeamRepositoryException {
        ArrayList<Object> toRetrieve = new ArrayList<Object>(2 * connection.getComponentsInfo().size());
        for (ICurrentComponentInfo currentComponentInfo : connection.getComponentsInfo()) {
            toRetrieve.add(currentComponentInfo.getComponent());
            toRetrieve.add(currentComponentInfo.basis());
        }
        int refreshFlag = refresh ? 1 : 0;
        List items = connection.teamRepository().itemManager().fetchCompleteItems(toRetrieve, refreshFlag, (IProgressMonitor)monitor);
        for (Object auditable : items) {
            if (auditable instanceof IComponent) {
                IComponent component = (IComponent)auditable;
                components.put(component.getItemId(), component);
            }
            if (!(auditable instanceof IBaseline)) continue;
            IBaseline baseline = (IBaseline)auditable;
            baselines.put(baseline.getItemId(), baseline);
        }
    }

    private static void fetchVisibilityForComponents(ITeamRepository repo, Map<UUID, IComponent> components, Map<UUID, IReadScope> vizByOwner, SubMonitor monitor) throws TeamRepositoryException {
        ArrayList<IComponent> componentsList = new ArrayList<IComponent>(components.values());
        List visibilities = components.isEmpty() ? Collections.EMPTY_LIST : SCMPlatform.getWorkspaceManager((ITeamRepository)repo).findReadScopeForComponents(componentsList, (IProgressMonitor)monitor.newChild(20));
        int i = 0;
        while (i < visibilities.size()) {
            IReadScope viz = (IReadScope)visibilities.get(i);
            IComponentHandle comp = (IComponentHandle)componentsList.get(i);
            vizByOwner.put(comp.getItemId(), viz);
            ++i;
        }
    }

    private static void fetchOwnerForComponents(ITeamRepository repo, Map<UUID, IComponent> components, Map<UUID, IAuditableHandle> byOwner, SubMonitor monitor) throws TeamRepositoryException {
        ArrayList<IComponent> componentsList = new ArrayList<IComponent>(components.values());
        List owners = components.isEmpty() ? Collections.EMPTY_LIST : SCMPlatform.getWorkspaceManager((ITeamRepository)repo).findOwnersForComponents(componentsList, (IProgressMonitor)monitor.newChild(20));
        int i = 0;
        while (i < owners.size()) {
            IAuditableHandle owner = (IAuditableHandle)owners.get(i);
            IComponentHandle comp = (IComponentHandle)componentsList.get(i);
            if (owner != null) {
                byOwner.put(comp.getItemId(), owner);
            }
            ++i;
        }
    }

    public static WorkspaceDetailsDTO translateWorkspace(ITeamRepository repo, IWorkspace workspace, SubMonitor newChild) throws TeamRepositoryException {
        WorkspaceDetailsDTO workspaceDetails = FilesystemRestClientDTOcoreFactory.eINSTANCE.createWorkspaceDetailsDTO();
        workspaceDetails.setRepositoryId(CoreUtil.translateRepositoryId(repo));
        workspaceDetails.setRepositoryURL(repo.getRepositoryURI());
        workspaceDetails.setItemId(workspace.getItemId().getUuidValue());
        workspaceDetails.setOwner(workspace.getOwner());
        workspaceDetails.setName(workspace.getName());
        workspaceDetails.setDescription(workspace.getDescription());
        workspaceDetails.setStream(workspace.isStream());
        workspaceDetails.setReadScope(CoreUtil.translate(workspace.getReadScope()));
        if (workspace.isStream()) {
            String patternString;
            Map properties = workspace.getProperties();
            if (properties.containsKey("exclusiveFileLockPattern") && (patternString = (String)properties.get("exclusiveFileLockPattern")) != null) {
                workspaceDetails.setExclusiveFileLockPatterns(patternString);
            }
            if (workspace.isLocked()) {
                UUID contributorId = UUID.valueOf((String)workspace.getLockOwnerItemID());
                IContributorHandle contributorHandle = (IContributorHandle)IContributor.ITEM_TYPE.createItemHandle(contributorId, null);
                IContributor contributor = (IContributor)repo.itemManager().fetchCompleteItem((IItemHandle)contributorHandle, 0, (IProgressMonitor)newChild);
                boolean isCurrentUser = false;
                if (repo.loggedInContributor() != null) {
                    isCurrentUser = repo.loggedInContributor().getItemId().equals((Object)contributorId);
                }
                ContributorNameDTO contributorDTO = CoreUtil.getContributorNameDTO(contributorId, contributor, isCurrentUser);
                workspaceDetails.setLockedBy(contributorDTO);
            }
        }
        return workspaceDetails;
    }

    public static ContributorNameDTO getContributorNameDTO(UUID lockedById, IContributor contributor, boolean isCurrentUser) {
        ContributorNameDTO contributorDTO = FilesystemRestClientDTOlocksFactory.eINSTANCE.createContributorNameDTO();
        if (contributor == null) {
            contributorDTO.setContributorItemId(lockedById.getUuidValue());
        } else {
            contributorDTO.setContributorItemId(contributor.getItemId().getUuidValue());
            contributorDTO.setName(contributor.getName());
            contributorDTO.setUserId(contributor.getUserId());
        }
        contributorDTO.setCurrentUser(isCurrentUser);
        return contributorDTO;
    }

    private static ReadScopeDTO translate(IReadScope scope) {
        ReadScopeDTO dto = FilesystemRestClientDTOcoreFactory.eINSTANCE.createReadScopeDTO();
        if (scope instanceof IContributorDeferringScope) {
            dto.setReadScope("contributor_deferring_scope");
            dto.setDefersTo(((IContributorDeferringScope)scope).getScope());
        } else if (scope instanceof IPrivateScope) {
            dto.setReadScope("private_scope");
        } else if (scope instanceof IArchivedScope) {
            dto.setReadScope("archived_scope");
        } else if (scope instanceof IProcessAreaScope) {
            dto.setReadScope("process_area_scope");
        } else if (scope instanceof IPublicScope) {
            dto.setReadScope("public_scope");
        } else if (scope instanceof ITeamAreaPrivateScope) {
            dto.setReadScope("team_area_private_scope");
        } else if (scope instanceof IAccessGroupScope) {
            dto.setReadScope("access_group_scope");
            dto.setDefersTo(((AccessGroupScope)scope).getAccessGroup());
        } else if (scope instanceof IUnknownScope) {
            dto.setReadScope("unknown_scope");
        } else {
            dto.setReadScope("unknown_scope");
        }
        return dto;
    }

    private static WorkspaceFlowEntryDTO translateFlowEntry(IFlowEntry entry, IWorkspaceHandle defaultIncomingCollaborationHandle, IWorkspaceHandle defaultOutgoingCollaborationHandle, IWorkspaceHandle currentIncomingCollaborationHandle, IWorkspaceHandle currentOutgoingCollaborationHandle, ITeamRepository repo, Collection<IComponentHandle> componentScopes) {
        WorkspaceFlowEntryDTO flowEntry = FilesystemRestClientDTOcoreFactory.eINSTANCE.createWorkspaceFlowEntryDTO();
        if (entry.getRemoteRepositoryURI() == null) {
            flowEntry.setRepositoryURL(repo.getRepositoryURI());
            flowEntry.setRepositoryId(CoreUtil.translateRepositoryId(repo));
        } else {
            flowEntry.setRepositoryURL(entry.getRemoteRepositoryURI());
            flowEntry.setRepositoryId(entry.getRemoteRepositoryIdentifier().getUuidValue());
        }
        flowEntry.setWorkspaceItemId(entry.getFlowNode().getItemId().getUuidValue());
        boolean isCurrentFlow = false;
        if (currentIncomingCollaborationHandle != null) {
            isCurrentFlow = currentIncomingCollaborationHandle.sameItemId((IItemHandle)entry.getFlowNode());
        }
        flowEntry.setCurrentIncomingFlow(isCurrentFlow);
        isCurrentFlow = false;
        if (currentOutgoingCollaborationHandle != null) {
            isCurrentFlow = currentOutgoingCollaborationHandle.sameItemId((IItemHandle)entry.getFlowNode());
        }
        flowEntry.setCurrentOutgoingFlow(isCurrentFlow);
        boolean isDefaultFlow = false;
        if (defaultIncomingCollaborationHandle != null) {
            isDefaultFlow = defaultIncomingCollaborationHandle.sameItemId((IItemHandle)entry.getFlowNode());
        }
        flowEntry.setDefaultIncomingFlow(isDefaultFlow);
        isDefaultFlow = false;
        if (defaultOutgoingCollaborationHandle != null) {
            isDefaultFlow = defaultOutgoingCollaborationHandle.sameItemId((IItemHandle)entry.getFlowNode());
        }
        flowEntry.setDefaultOutgoingFlow(isDefaultFlow);
        if (componentScopes != null) {
            for (IComponentHandle componentHandle : componentScopes) {
                flowEntry.getScopedComponentItemIds().add(componentHandle.getItemId().getUuidValue());
            }
        }
        return flowEntry;
    }

    public static ShareableDTO translateShareable(IShareable shareable) {
        ShareableDTO shareableDTO = FilesystemRestClientDTOcoreFactory.eINSTANCE.createShareableDTO();
        if (shareable != null) {
            shareableDTO.setSandboxPath(shareable.getSandbox().getRoot().toOSString());
            shareableDTO.setRelativePath(CoreUtil.translatePath(shareable.getLocalPath()));
        }
        return shareableDTO;
    }

    public static SandboxDTO translateSandbox(ISandbox sandbox, boolean computeFully, IProgressMonitor progress) throws FileSystemException {
        SandboxDTO dto = FilesystemRestClientDTOcoreFactory.eINSTANCE.createSandboxDTO();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)4);
        dto.setSandboxPath(sandbox.getRoot().toOSString());
        dto.setCaseSensitive(Boolean.valueOf(sandbox.isCaseSensitive()));
        dto.setCorrupted(Boolean.valueOf(sandbox.isCorrupted((IProgressMonitor)monitor.newChild(1))));
        dto.setSandboxListening(Boolean.valueOf(SharingManager.getInstance().hasSandboxListener(sandbox)));
        if (computeFully) {
            List shares = dto.getAllShares();
            IShare[] iShareArray = sandbox.allShares((IProgressMonitor)monitor.newChild(1));
            int n = iShareArray.length;
            int n2 = 0;
            while (n2 < n) {
                IShare share = iShareArray[n2];
                shares.add(CoreUtil.translateShare(share, (IProgressMonitor)monitor.newChild(1)));
                ++n2;
            }
        }
        return dto;
    }

    public static StatusDTO translateStatus(IStatus status) {
        if (status == null) {
            return null;
        }
        StatusDTO statusDTO = FilesystemRestClientDTOcoreFactory.eINSTANCE.createStatusDTO();
        statusDTO.setPluginId(status.getPlugin());
        statusDTO.setSeverity(status.getSeverity());
        statusDTO.setCode(status.getCode());
        statusDTO.setMessage(status.getMessage());
        statusDTO.setException(CoreUtil.convertException(1, status.getException()));
        IStatus[] iStatusArray = status.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus child = iStatusArray[n2];
            statusDTO.getChildren().add(CoreUtil.translateStatus(child));
            ++n2;
        }
        return statusDTO;
    }

    private static ExceptionDTO convertException(int paranoia, Throwable exception) {
        StackTraceElement[] stackTrace;
        if (exception == null) {
            return null;
        }
        ExceptionDTO exceptionDTO = FilesystemRestClientDTOcoreFactory.eINSTANCE.createExceptionDTO();
        exceptionDTO.setMessage(exception.getMessage());
        StackTraceElement[] stackTraceElementArray = stackTrace = exception.getStackTrace();
        int n = stackTrace.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement trace = stackTraceElementArray[n2];
            StackTraceElementDTO stackTraceElementDTO = FilesystemRestClientDTOcoreFactory.eINSTANCE.createStackTraceElementDTO();
            stackTraceElementDTO.setFileName(trace.getFileName());
            stackTraceElementDTO.setLineNumber(trace.getLineNumber());
            stackTraceElementDTO.setClassName(trace.getClassName());
            stackTraceElementDTO.setMethodName(trace.getMethodName());
            exceptionDTO.getStackTrace().add(stackTraceElementDTO);
            ++n2;
        }
        if (exception.getCause() != null && paranoia < 20) {
            exceptionDTO.setCause(CoreUtil.convertException(paranoia + 1, exception.getCause()));
        }
        return exceptionDTO;
    }

    public static String getVersionableItemType(IItemType itemType) {
        if (IFileItem.ITEM_TYPE.equals(itemType)) {
            return "file";
        }
        if (IFolder.ITEM_TYPE.equals(itemType)) {
            return "folder";
        }
        if (ISymbolicLink.ITEM_TYPE.equals(itemType)) {
            return "symbolic_link";
        }
        return "";
    }

    public static String getVersionableItemType(IVersionableHandle versionableHandle) {
        if (versionableHandle instanceof IFileItemHandle) {
            return "file";
        }
        if (versionableHandle instanceof IFolderHandle) {
            return "folder";
        }
        if (versionableHandle instanceof ISymbolicLinkHandle) {
            return "symbolic_link";
        }
        return "";
    }

    public static StreamLockReportDTO getStreamLockReportDTO(IWorkspaceConnection wc, IStreamLockReport report) {
        StreamLockReportDTO result = FilesystemRestClientDTOlocksFactory.eINSTANCE.createStreamLockReportDTO();
        result.setStreamItemId(report.getStream().getItemId().getUuidValue());
        if (wc != null) {
            result.setStreamName(wc.getName());
        }
        for (IComponentLockReport clr : report.getComponentLocks()) {
            result.getComponentLockReports().add(CoreUtil.getComponentLockReportDTO(clr));
        }
        return result;
    }

    private static ComponentLockReportDTO getComponentLockReportDTO(IComponentLockReport report) {
        ComponentLockReportDTO result = FilesystemRestClientDTOlocksFactory.eINSTANCE.createComponentLockReportDTO();
        result.setComponentItemId(report.getComponent().getItemId().getUuidValue());
        for (IVersionableLock lock : report.getLocks()) {
            result.getVersionableLocks().add(CoreUtil.getVersionableLockDTO(lock));
        }
        return result;
    }

    private static VersionableLockDTO getVersionableLockDTO(IVersionableLock lock) {
        VersionableLockDTO result = FilesystemRestClientDTOlocksFactory.eINSTANCE.createVersionableLockDTO();
        result.setContributorItemId(lock.getContributor().getItemId().getUuidValue());
        result.setVersionableItemId(lock.getVersionable().getItemId().getUuidValue());
        return result;
    }

    public static DeliveryRequiresHistoryReorderingDTO getDeliveryRequiresHistoryReorderingDTO(IWorkspaceConnection source, IWorkspaceConnection target, IComponent component) {
        DeliveryRequiresHistoryReorderingDTO result = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createDeliveryRequiresHistoryReorderingDTO();
        result.setComponentItemId(component.getItemId().getUuidValue());
        result.setWorkspaceItemId(source.getResolvedWorkspace().getItemId().getUuidValue());
        result.setTargetWorkspaceItemId(target.getResolvedWorkspace().getItemId().getUuidValue());
        return result;
    }

    public static String getLineDelimiter(FileLineDelimiter lineDelimiterSetting) {
        if (lineDelimiterSetting == null) {
            return "";
        }
        switch (lineDelimiterSetting) {
            case LINE_DELIMITER_PLATFORM: {
                return "platform";
            }
            case LINE_DELIMITER_CRLF: {
                return "crlf";
            }
            case LINE_DELIMITER_LF: {
                return "lf";
            }
            case LINE_DELIMITER_CR: {
                return "cr";
            }
            case LINE_DELIMITER_NONE: {
                return "none";
            }
        }
        return "";
    }

    public static FileLineDelimiter getLineDelimiter(String lineDelimiterSetting) {
        if ("lf".equals(lineDelimiterSetting)) {
            return FileLineDelimiter.LINE_DELIMITER_LF;
        }
        if ("cr".equals(lineDelimiterSetting)) {
            return FileLineDelimiter.LINE_DELIMITER_CR;
        }
        if ("crlf".equals(lineDelimiterSetting)) {
            return FileLineDelimiter.LINE_DELIMITER_CRLF;
        }
        if ("platform".equals(lineDelimiterSetting)) {
            return FileLineDelimiter.LINE_DELIMITER_PLATFORM;
        }
        if ("none".equals(lineDelimiterSetting)) {
            return FileLineDelimiter.LINE_DELIMITER_NONE;
        }
        throw new IllegalArgumentException(NLS.bind((String)"{0} has value {1} which is not one of {2}, {3}, {4}, {5}, {6}", (Object[])new Object[]{"lineDelimiter", lineDelimiterSetting, "lf", "cr", "crlf", "platform", "none"}));
    }

    public static int getDilemmaInstruction(String instruction, int defaultInstruction) {
        if (instruction == null) {
            return defaultInstruction;
        }
        if ("cancel".equals(instruction)) {
            return 1;
        }
        if ("continue".equals(instruction)) {
            return 0;
        }
        if ("no".equals(instruction)) {
            return 3;
        }
        if ("load".equals(instruction)) {
            return 100;
        }
        return 2;
    }

    public static String translateRepositoryId(ITeamRepository repository) {
        UUID id = RepositoryUtils.getRepositoryId(repository);
        return id == null ? null : id.getUuidValue();
    }
}

