/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.rest.util;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.internal.rest.IValidatingParameterWrapper;
import com.ibm.team.filesystem.client.internal.rest.util.CoreUtil;
import com.ibm.team.filesystem.client.internal.rest.util.EncodingErrorHandler;
import com.ibm.team.filesystem.client.internal.rest.util.RefreshUtil;
import com.ibm.team.filesystem.client.internal.rest.util.ResourceUtil;
import com.ibm.team.filesystem.client.internal.rest.util.SandboxUpdateDilemmaUtil;
import com.ibm.team.filesystem.client.internal.rest.util.UpdateDilemmaUtil;
import com.ibm.team.filesystem.client.internal.rest.util.VerifyOutOfSyncUtil;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICheckinOperation;
import com.ibm.team.filesystem.client.operations.ICheckinOptions;
import com.ibm.team.filesystem.client.operations.IEncodingUploadFailure;
import com.ibm.team.filesystem.client.operations.ILineDelimiterUploadFailure;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCheckInChanges;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCheckInComponentRequest;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCheckInOptions;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCheckInShareablesRequest;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCheckInVersionablesRequest;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCommitDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPendingChangesDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSandboxUpdateDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsUpdateDilemmaHandler;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.CheckInResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.FilesystemRestClientDTOchangesetFactory;
import com.ibm.team.filesystem.common.internal.rest.client.dilemma.CommitDilemmaDTO;
import com.ibm.team.filesystem.common.internal.rest.client.dilemma.SandboxUpdateDilemmaDTO;
import com.ibm.team.filesystem.common.internal.rest.client.dilemma.UpdateDilemmaDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.FilesystemRestClientDTOresourceFactory;
import com.ibm.team.filesystem.common.internal.rest.client.resource.SymlinkWarningDTO;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

public class CommitUtil {
    public static CheckInResultDTO checkInChanges(ParmsCheckInChanges parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        CheckInResultDTO result = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createCheckInResultDTO();
        OutOfSyncDilemmaHandler outOfSyncDilemmaHandler = VerifyOutOfSyncUtil.getOutOfSyncDilemmaHandler(parms.outOfSyncInstructions, result.getOutOfSyncShares(), parms.sandboxUpdateDilemmaHandler, result.getSandboxUpdateDilemma(), (IProgressMonitor)monitor.newChild(5));
        CommitDilemmaHandler commitDilemmaHandler = CommitUtil.getCommitDilemmaHandler(parms.commitDilemmaHandler, result.getCommitDilemma(), parms.sandboxUpdateDilemmaHandler, result.getSandboxUpdateDilemma(), parms.updateDilemmaHandler, result.getUpdateDilemma(), outOfSyncDilemmaHandler);
        try {
            ICheckinOperation commitOp = CommitUtil.getCommitOp(parms, commitDilemmaHandler, (IProgressMonitor)monitor.newChild(1));
            if (commitOp != null) {
                commitOp.run((IProgressMonitor)monitor.newChild(80));
                for (IChangeSetHandle changeSetHandle : commitOp.getCommittedChangeSets()) {
                    result.getChangeSetsCommitted().add(changeSetHandle.getItemId().getUuidValue());
                }
            }
        }
        catch (OperationCanceledException e) {
            result.setCancelled(true);
        }
        return result;
    }

    private static ICheckinOperation getCommitOp(ParmsCheckInChanges parms, CommitDilemmaHandler commitDilemmaHandler, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        IValidatingParameterWrapper request;
        int n;
        int n2;
        IValidatingParameterWrapper[] iValidatingParameterWrapperArray;
        ICheckinOperation commitOp = IOperationFactory.instance.getCheckinOperation(commitDilemmaHandler, IRepositoryResolver.EXISTING_SHARED);
        CommitUtil.configureCommit(parms.checkInOptions, (ICheckinOptions)commitOp);
        int total = 0;
        total += parms.versionables == null ? 0 : parms.versionables.length;
        total += parms.paths == null ? 0 : parms.paths.length;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(total += parms.components == null ? 0 : parms.paths.length));
        if (parms.versionables != null) {
            iValidatingParameterWrapperArray = parms.versionables;
            n2 = parms.versionables.length;
            n = 0;
            while (n < n2) {
                request = iValidatingParameterWrapperArray[n];
                CommitUtil.addRequest(commitOp, (ParmsCheckInVersionablesRequest)request, (IProgressMonitor)subMonitor.newChild(1));
                ++n;
            }
        }
        if (parms.paths != null) {
            iValidatingParameterWrapperArray = parms.paths;
            n2 = parms.paths.length;
            n = 0;
            while (n < n2) {
                request = iValidatingParameterWrapperArray[n];
                CommitUtil.addRequest(commitOp, (ParmsCheckInShareablesRequest)request, (IProgressMonitor)subMonitor.newChild(1));
                ++n;
            }
        }
        if (parms.components != null) {
            iValidatingParameterWrapperArray = parms.components;
            n2 = parms.components.length;
            n = 0;
            while (n < n2) {
                request = iValidatingParameterWrapperArray[n];
                CommitUtil.addRequest(commitOp, (ParmsCheckInComponentRequest)request, (IProgressMonitor)subMonitor.newChild(1));
                ++n;
            }
        }
        RefreshUtil.configureRefresh(parms.preoperationRefresh, commitOp);
        return commitOp;
    }

    private static void addRequest(ICheckinOperation commitOp, ParmsCheckInShareablesRequest parms, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        PathLocation sandboxPath = new PathLocation((IPath)new Path(parms.sandboxPath));
        ArrayList<IShareable> shareableToCommit = new ArrayList<IShareable>(parms.resourcesToCheckIn.length);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(parms.resourcesToCheckIn.length * 2 + 5));
        int i = 0;
        while (i < parms.resourcesToCheckIn.length) {
            RelativeLocation toCheckIn = new RelativeLocation(new Path(parms.resourcesToCheckIn[i]).segments());
            ILocation path = sandboxPath.append(toCheckIn);
            ResourceType resourceType = CommonUtil.getResourceType(path, (IProgressMonitor)subMonitor.newChild(1));
            if (resourceType == null) {
                throw new TeamRepositoryException(NLS.bind((String)Messages.CommitUtil_1, (Object)parms.resourcesToCheckIn[i], (Object[])new Object[0]));
            }
            Shareable shareable = new Shareable(sandboxPath, (IRelativeLocation)toCheckIn, resourceType);
            IShare share = shareable.getShare((IProgressMonitor)subMonitor.newChild(1));
            if (share == null) {
                throw new TeamRepositoryException(NLS.bind((String)Messages.CommitUtil_2, (Object)parms.resourcesToCheckIn[i], (Object[])new Object[0]));
            }
            shareableToCommit.add(shareable);
            ++i;
        }
        SharingManager.getInstance().getIgnoreManager().flushInAbsenceOfEvents(shareableToCommit, (IProgressMonitor)subMonitor.newChild(1));
        IShareable[] shareables = shareableToCommit.toArray(new IShareable[shareableToCommit.size()]);
        IChangeSetHandle changeSet = parms.getChangeSetHandle();
        commitOp.requestCheckin(shareables, changeSet, CommitUtil.getComment(parms.newChangeSetComment), (IProgressMonitor)subMonitor.newChild(4));
    }

    private static void addRequest(ICheckinOperation commitOp, ParmsCheckInComponentRequest request, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        ArrayList<IShareable> shareableToCommit = new ArrayList<IShareable>();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IWorkspaceConnection workspace = request.workspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(5));
        IComponentHandle component = request.getComponentHandle();
        Collection<IShare> shares = SharingManager.getInstance().getShares(new ConfigurationFacade((IConnection)workspace, component), (IProgressMonitor)subMonitor.newChild(25));
        for (IShare share : shares) {
            shareableToCommit.add(share.getShareable());
        }
        SharingManager.getInstance().getIgnoreManager().flushInAbsenceOfEvents(shareableToCommit, (IProgressMonitor)subMonitor.newChild(5));
        IShareable[] shareables = shareableToCommit.toArray(new IShareable[shareableToCommit.size()]);
        IChangeSetHandle changeSet = request.getChangeSetHandle();
        commitOp.requestCheckin(shareables, changeSet, CommitUtil.getComment(request.newChangeSetComment), (IProgressMonitor)subMonitor.newChild(65));
    }

    private static void addRequest(ICheckinOperation commitOp, ParmsCheckInVersionablesRequest request, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IWorkspaceConnection workspace = request.workspace.getWorkspaceConnection((IProgressMonitor)subMonitor.newChild(10));
        IComponentHandle component = request.getComponentHandle();
        SharingManager.getInstance().getIgnoreManager().flushInAbsenceOfEvents(null, (IProgressMonitor)subMonitor.newChild(5));
        HashMap<UUID, ILocalChange> localChanges = CommitUtil.getLocalChanges(workspace, component, (IProgressMonitor)subMonitor.newChild(25));
        ArrayList<ILocalChange> changesToCheckIn = new ArrayList<ILocalChange>(request.versionablesToCheckIn.length);
        int i = 0;
        while (i < request.versionablesToCheckIn.length) {
            ILocalChange change = localChanges.get(UUID.valueOf((String)request.versionablesToCheckIn[i]));
            if (change != null) {
                changesToCheckIn.add(change);
            }
            ++i;
        }
        if (!changesToCheckIn.isEmpty()) {
            IChangeSetHandle changeSet = request.getChangeSetHandle();
            commitOp.requestCheckin(changesToCheckIn.toArray(new ILocalChange[changesToCheckIn.size()]), changeSet, CommitUtil.getComment(request.newChangeSetComment), (IProgressMonitor)subMonitor.newChild(60));
        }
    }

    private static String getComment(String newChangeSetComment) {
        return newChangeSetComment == null ? "" : newChangeSetComment;
    }

    private static HashMap<UUID, ILocalChange> getLocalChanges(IWorkspaceConnection workspace, IComponentHandle component, IProgressMonitor monitor) throws FileSystemException {
        HashMap<UUID, ILocalChange> result = new HashMap<UUID, ILocalChange>();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Collection<ISandbox> sandboxes = FileSystemCore.getSharingManager().getSandboxes(new ConfigurationFacade((IConnection)workspace, component), (IProgressMonitor)progress.newChild(10));
        progress.setWorkRemaining(10 * sandboxes.size());
        for (ISandbox sandbox : sandboxes) {
            ILocalChange[] pendingChanges;
            ILocalChangeManager lcm = FileSystemCore.getSharingManager().getLocalChangeManager();
            lcm.syncPendingChanges(workspace.getContextHandle(), component, sandbox, (IProgressMonitor)progress.newChild(10));
            ILocalChange[] iLocalChangeArray = pendingChanges = lcm.getPendingChanges(workspace.getContextHandle(), component, sandbox);
            int n = pendingChanges.length;
            int n2 = 0;
            while (n2 < n) {
                ILocalChange change = iLocalChangeArray[n2];
                result.put(change.getTarget().getItemId(), change);
                ++n2;
            }
        }
        return result;
    }

    public static final CommitDilemmaHandler getCommitDilemmaHandler(ParmsCommitDilemmaHandler commitDilemmaInstructions, final CommitDilemmaDTO commitDilemma, ParmsSandboxUpdateDilemmaHandler sandboxUpdateDilemmaHandler, SandboxUpdateDilemmaDTO sandboxUpdateDilemma, ParmsUpdateDilemmaHandler updateDilemmaHandler, UpdateDilemmaDTO updateDilemma, OutOfSyncDilemmaHandler oosDilemmaHandler) {
        final OutOfSyncDilemmaHandler outOfSyncDilemmaHandler = oosDilemmaHandler == null ? OutOfSyncDilemmaHandler.getDefault() : oosDilemmaHandler;
        final SandboxUpdateDilemmaUtil sandboxUpdateDilemmaUtil = new SandboxUpdateDilemmaUtil(sandboxUpdateDilemmaHandler, sandboxUpdateDilemma);
        final UpdateDilemmaUtil updateDilemmaUtil = new UpdateDilemmaUtil(updateDilemmaHandler, updateDilemma);
        final ResourceUtil.LineDelimiterErrorHandler lineDelimiterErrorHandler = new ResourceUtil.LineDelimiterErrorHandler(commitDilemmaInstructions == null ? null : commitDilemmaInstructions.lineDelimiterDilemmaHandler, commitDilemma == null ? null : commitDilemma.getLineDelimiterFailures());
        final EncodingErrorHandler encodingErrorHandler = commitDilemmaInstructions == null || commitDilemmaInstructions.encodingDilemmaHandler == null ? new EncodingErrorHandler(commitDilemma == null ? null : commitDilemma.getEncodingFailures()) : new EncodingErrorHandler(commitDilemmaInstructions.encodingDilemmaHandler, commitDilemma == null ? null : commitDilemma.getEncodingFailures());
        final int nonPatchShareablesInstruction = commitDilemmaInstructions == null || commitDilemmaInstructions.nonPatchShareablesInstruction == null ? 2 : CommitUtil.getInstruction(commitDilemmaInstructions.nonPatchShareablesInstruction, "nonPatchShareablesInstruction");
        final int localConflictsInstruction = commitDilemmaInstructions == null || commitDilemmaInstructions.localConflictsInstruction == null ? 2 : CommitUtil.getInstruction(commitDilemmaInstructions.localConflictsInstruction, "localConflictsInstruction");
        final int predecessorDeletedInstruction = commitDilemmaInstructions == null || commitDilemmaInstructions.predecessorContentDeletedInstruction == null ? 2 : CommitUtil.getInstruction(commitDilemmaInstructions.predecessorContentDeletedInstruction, "predecessorContentDeletedInstruction");
        CommitDilemmaHandler commitDilemmaHandler = new CommitDilemmaHandler(){
            volatile boolean gotUnsupportedOutOfSync = false;

            @Override
            public OutOfSyncDilemmaHandler getOutOfSyncDilemmaHandler() {
                return outOfSyncDilemmaHandler;
            }

            @Override
            public int lineDelimiterErrors(Collection<? extends ILineDelimiterUploadFailure> failedFiles, IProgressMonitor monitor) throws FileSystemException {
                return lineDelimiterErrorHandler.lineDelimiterErrors(failedFiles, monitor);
            }

            @Override
            public BackupDilemmaHandler getBackupDilemmaHandler() {
                return sandboxUpdateDilemmaUtil.getBackupDilemmaHandler();
            }

            @Override
            public int encodingErrors(Collection<? extends IEncodingUploadFailure> failedUploads, IProgressMonitor monitor) {
                try {
                    Collection<? extends IEncodingUploadFailure> remainingFailures = encodingErrorHandler.applyDetailedInstructions(failedUploads);
                    if (!remainingFailures.isEmpty() && encodingErrorHandler.isPerformDefault()) {
                        super.encodingErrors(failedUploads, monitor);
                    }
                    for (IEncodingUploadFailure iEncodingUploadFailure : failedUploads) {
                        if (iEncodingUploadFailure.hasDirection()) continue;
                        int n = encodingErrorHandler.getDirection();
                        return n;
                    }
                }
                finally {
                    encodingErrorHandler.recordUploadFailures(failedUploads);
                }
                return 0;
            }

            @Override
            public void unsupportedOutOfSync(IShareable s, IProgressMonitor prog) {
                this.gotUnsupportedOutOfSync = true;
            }

            @Override
            public void commitComplete() throws TeamRepositoryException {
                if (this.gotUnsupportedOutOfSync) {
                    throw new TeamRepositoryException((Throwable)((Object)new FileSystemStatusException(FileSystemStatusUtil.getStatusFor(4, Messages.CommitUtil_UNSUPPORTED_REFRESH_MESSAGE))));
                }
            }

            @Override
            public void linkWarnings(boolean anyBrokenLinks, boolean anyNonInteroperableLinks, IShareable[] shareables, String[] targets, Boolean[] directoryLinks, Boolean[] broken, Boolean[] nonInteroperable) {
                if (commitDilemma == null) {
                    return;
                }
                int i = 0;
                while (i < shareables.length) {
                    if (broken[i].booleanValue()) {
                        commitDilemma.getBrokenLinks().add(CommitUtil.translateSymlinkWarning(shareables[i], targets[i], directoryLinks[i]));
                    }
                    if (nonInteroperable[i].booleanValue()) {
                        commitDilemma.getNonInteroperableLinks().add(CommitUtil.translateSymlinkWarning(shareables[i], targets[i], directoryLinks[i]));
                    }
                    ++i;
                }
            }

            @Override
            public int nonPatchShareables(Collection<IShareable> nonPatchShareables) {
                if (commitDilemma != null) {
                    for (IShareable shareable : nonPatchShareables) {
                        commitDilemma.getNonPatchShareables().add(CoreUtil.translateShareable(shareable));
                    }
                }
                return nonPatchShareablesInstruction;
            }

            @Override
            public int predecessorContentDeletedErrors(Collection<IShareable> failedUploads) {
                if (commitDilemma != null) {
                    for (IShareable shareable : failedUploads) {
                        commitDilemma.getPredecessorDeletedShareables().add(CoreUtil.translateShareable(shareable));
                    }
                }
                return predecessorDeletedInstruction;
            }

            @Override
            public int deletedContent(Collection<IShareable> contentDeleted) {
                return sandboxUpdateDilemmaUtil.deletedContent(contentDeleted);
            }

            @Override
            public int inaccessibleForUpdate(Collection<IShareable> shareables) {
                return updateDilemmaUtil.inaccessibleForUpdate(shareables);
            }

            @Override
            public int siblingSharesToAdd(Collection<IShareable> shareables) {
                return updateDilemmaUtil.siblingSharesToAdd(shareables);
            }

            @Override
            public int localConflicts(List<IShareable> conflictedLocalChanges) {
                if (commitDilemma != null) {
                    for (IShareable shareable : conflictedLocalChanges) {
                        commitDilemma.getLocalConflictShareables().add(CoreUtil.translateShareable(shareable));
                    }
                }
                return localConflictsInstruction;
            }
        };
        return commitDilemmaHandler;
    }

    public static SymlinkWarningDTO translateSymlinkWarning(IShareable shareable, String target, boolean directoryLink) {
        SymlinkWarningDTO result = FilesystemRestClientDTOresourceFactory.eINSTANCE.createSymlinkWarningDTO();
        result.setTarget(target);
        result.setLocation(shareable.getLocalPath().toString());
        result.setSandboxLocation(shareable.getSandbox().getRoot().toString());
        result.setType(directoryLink ? "directory" : "file");
        return result;
    }

    public static int getUncheckedInChangesInstruction(ParmsPendingChangesDilemmaHandler changeDilemmaHandlerParm, int defaultValue) {
        int uncheckedInChangesInstruction = defaultValue;
        if (changeDilemmaHandlerParm != null) {
            uncheckedInChangesInstruction = CommitUtil.getInstruction(changeDilemmaHandlerParm.pendingChangesInstruction, "pendingChangesInstruction");
        }
        return uncheckedInChangesInstruction;
    }

    public static int getUncheckedInChangesSubcomponentsInstruction(ParmsPendingChangesDilemmaHandler changeDilemmaHandlerParm, int defaultValue) {
        int uncheckedInChangesInSubcomponentsInstruction = defaultValue;
        if (changeDilemmaHandlerParm != null) {
            uncheckedInChangesInSubcomponentsInstruction = CommitUtil.getInstruction(changeDilemmaHandlerParm.pendingChangesInSubcomponentsInstruction, "pendingChangesInSubcomponentsInstruction");
        }
        return uncheckedInChangesInSubcomponentsInstruction;
    }

    public static int getUncheckedInChangesInstruction(ParmsPendingChangesDilemmaHandler changeDilemmaHandlerParm) {
        return CommitUtil.getUncheckedInChangesInstruction(changeDilemmaHandlerParm, 2);
    }

    public static int getUncheckedInChangesSubcomponentsInstruction(ParmsPendingChangesDilemmaHandler changeDilemmaHandlerParm) {
        return CommitUtil.getUncheckedInChangesSubcomponentsInstruction(changeDilemmaHandlerParm, 2);
    }

    private static int getInstruction(String instruction, String message) {
        int uncheckedInChangesInstruction = 2;
        if ("continue".equals(instruction)) {
            uncheckedInChangesInstruction = 0;
        } else if (instruction == null) {
            uncheckedInChangesInstruction = 2;
        } else if ("cancel".equals(instruction)) {
            uncheckedInChangesInstruction = 1;
        } else if ("fail".equals(instruction)) {
            uncheckedInChangesInstruction = 2;
        } else if ("no".equals(instruction)) {
            uncheckedInChangesInstruction = 3;
        } else {
            throw new IllegalArgumentException("The value of " + message + " must be one of " + "cancel" + ", " + "continue" + ", " + "no" + " or " + "fail");
        }
        return uncheckedInChangesInstruction;
    }

    public static CommitDilemmaHandler getCommitDilemmaHandler(ParmsPendingChangesDilemmaHandler pendingChangesDilemmaHandler, CommitDilemmaDTO commitDilemma, ParmsSandboxUpdateDilemmaHandler sandboxUpdateDilemmaHandlerParms, SandboxUpdateDilemmaDTO sandboxUpdateDilemma, ParmsUpdateDilemmaHandler configurationUpdateDilemmaHandlerParms, UpdateDilemmaDTO updateDilemma, OutOfSyncDilemmaHandler oosDilemmaHandler) {
        if (pendingChangesDilemmaHandler == null) {
            return CommitUtil.getCommitDilemmaHandler(null, commitDilemma, sandboxUpdateDilemmaHandlerParms, sandboxUpdateDilemma, configurationUpdateDilemmaHandlerParms, updateDilemma, oosDilemmaHandler);
        }
        return CommitUtil.getCommitDilemmaHandler(pendingChangesDilemmaHandler.commitDilemmaHandler, commitDilemma, sandboxUpdateDilemmaHandlerParms, sandboxUpdateDilemma, configurationUpdateDilemmaHandlerParms, updateDilemma, oosDilemmaHandler);
    }

    public static void configureCommit(ParmsPendingChangesDilemmaHandler parms, ICheckinOptions operation) {
        if (parms == null) {
            CommitUtil.configureCommit(null, operation);
        } else {
            CommitUtil.configureCommit(parms.checkInOptions, operation);
        }
    }

    public static void configureCommit(ParmsCheckInOptions parms, ICheckinOptions operation) {
        if (parms == null) {
            operation.enableNonAtomicCommit(200);
        } else if (parms.allowNonAtomicCommit.booleanValue()) {
            operation.enableNonAtomicCommit(parms.numberOfUploads);
        } else {
            operation.disableNonAtomicCommit();
        }
    }
}

