/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.rest;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubMonitor;

public class CommonUtil {
    private static char[] LINE_SEPARATOR = System.getProperty("line.separator").toCharArray();

    public static ITeamRepository getTeamRepository(String repositoryUrl) throws TeamRepositoryException {
        ITeamRepository repo = RepositoryUtils.getTeamRepository(repositoryUrl, 4);
        if (repo == null) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.CommonUtil_0, (Object)repositoryUrl, (Object[])new Object[0]));
        }
        return repo;
    }

    public static IWorkspaceHandle createWorkspaceHandle(ITeamRepository repo, String itemId) {
        return (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)itemId), null);
    }

    public static IComponentHandle createComponentHandle(ITeamRepository repo, String itemId) {
        return (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)itemId), null);
    }

    public static IContributorHandle createContributorHandle(ITeamRepository repo, String itemId) {
        return (IContributorHandle)IContributor.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)itemId), null);
    }

    public static IChangeSetHandle createChangeSetHandle(ITeamRepository repo, String itemId) {
        return (IChangeSetHandle)IChangeSet.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)itemId), null);
    }

    public static IBaselineSetHandle createBaselineSetHandle(ITeamRepository repo, String itemId) {
        return (IBaselineSetHandle)IBaselineSet.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)itemId), null);
    }

    public static IFolderHandle createFolderHandle(ITeamRepository repo, String itemId) {
        return (IFolderHandle)IFolder.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)itemId), null);
    }

    public static List<? extends IItemHandle> createHandles(IItemType itemType, String repositoryUrl, String[] itemIds) {
        ArrayList<IItemHandle> handles = new ArrayList<IItemHandle>();
        if (itemIds != null) {
            try {
                ITeamRepository repo = CommonUtil.getTeamRepository(repositoryUrl);
                String[] stringArray = itemIds;
                int n = itemIds.length;
                int n2 = 0;
                while (n2 < n) {
                    String itemId = stringArray[n2];
                    handles.add(itemType.createItemHandle((Object)repo, UUID.valueOf((String)itemId), null));
                    ++n2;
                }
            }
            catch (TeamRepositoryException teamRepositoryException) {
                // empty catch block
            }
        }
        return handles;
    }

    private static void appendException(final StringBuffer errorMsg, Throwable e) {
        if (e != null) {
            Writer errorBuffer = new Writer(){

                @Override
                public void close() throws IOException {
                }

                @Override
                public void flush() throws IOException {
                }

                @Override
                public void write(char[] cbuf, int off, int len) throws IOException {
                    errorMsg.append(cbuf, off, len);
                }
            };
            e.printStackTrace(new PrintWriter(errorBuffer));
            errorMsg.append(LINE_SEPARATOR);
        }
    }

    public static String getStatusErrors(FileSystemStatusException e) {
        StringBuffer errorMsg = new StringBuffer();
        HashMap<StackTrace, List<IStatus>> exceptions = new HashMap<StackTrace, List<IStatus>>();
        IStatus status = e.getStatus();
        if (status != null) {
            CommonUtil.findStatuses(exceptions, status);
        }
        for (Map.Entry entry : exceptions.entrySet()) {
            for (IStatus statusToReport : (List)entry.getValue()) {
                errorMsg.append(statusToReport.getMessage()).append(LINE_SEPARATOR);
            }
            if (entry.getKey() != null) {
                CommonUtil.appendException(errorMsg, ((StackTrace)entry.getKey()).getException());
            }
            errorMsg.append(LINE_SEPARATOR);
        }
        return errorMsg.toString();
    }

    private static void findStatuses(HashMap<StackTrace, List<IStatus>> exceptions, IStatus status) {
        if (status.getException() != null) {
            StackTrace stackTrace = new StackTrace(status.getException());
            List<IStatus> statusForException = exceptions.get(stackTrace);
            if (statusForException == null) {
                statusForException = new ArrayList<IStatus>();
                exceptions.put(stackTrace, statusForException);
            }
            statusForException.add(status);
        }
        if (status.isMultiStatus()) {
            IStatus[] iStatusArray = ((MultiStatus)status).getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus childStatus = iStatusArray[n2];
                CommonUtil.findStatuses(exceptions, childStatus);
                ++n2;
            }
        }
    }

    public static ResourceType getResourceType(ILocation location, IProgressMonitor progress) throws FileSystemException {
        IPath path = (IPath)location.getAdapter(IPath.class);
        if (path == null) {
            return null;
        }
        return CommonUtil.getResourceType(path, progress);
    }

    public static ResourceType getResourceType(IPath path, IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IFileStore fileStorage = EFS.getLocalFileSystem().getStore(path);
        try {
            IFileInfo fileInfo = fileStorage.fetchInfo(0, (IProgressMonitor)monitor.newChild(100));
            if (fileInfo.getAttribute(32)) {
                return ResourceType.SYMBOLIC_LINK;
            }
            if (fileInfo.isDirectory()) {
                return ResourceType.FOLDER;
            }
            if (fileInfo.exists()) {
                return ResourceType.FILE;
            }
            return null;
        }
        catch (CoreException e) {
            throw new FileSystemException(NLS.bind((String)Messages.PathUtils_1, (Object)path.toString(), (Object[])new Object[0]), e);
        }
    }

    private static class StackTrace {
        private StackTraceElement[] trace;
        private Throwable e;

        public StackTrace(Throwable e) {
            ArrayList<StackTraceElement> stackTrace = new ArrayList<StackTraceElement>();
            int paranoia = 0;
            Throwable cause = e;
            while (cause != null && paranoia < 20) {
                StackTraceElement[] stackTraceElementArray = cause.getStackTrace();
                int n = stackTraceElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    StackTraceElement element = stackTraceElementArray[n2];
                    stackTrace.add(element);
                    ++n2;
                }
                ++paranoia;
                cause = cause.getCause();
            }
            this.trace = stackTrace.toArray(new StackTraceElement[stackTrace.size()]);
            this.e = e;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.trace);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StackTrace other = (StackTrace)obj;
            return Arrays.equals(this.trace, other.trace);
        }

        public Throwable getException() {
            return this.e;
        }
    }
}

