/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.queries;

import com.ibm.team.filesystem.client.internal.queries.AbstractQuery;
import com.ibm.team.filesystem.client.internal.queries.IQuery;
import com.ibm.team.filesystem.client.internal.queries.QueryCache;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public final class QueryPage
extends AbstractQuery
implements IQuery {
    private IQuery toWrap;
    private int start;
    private int length;

    public QueryPage(IQuery toWrap, int start, int length) {
        this.start = start;
        this.length = length;
        this.toWrap = toWrap;
    }

    @Override
    public IQuery getPage(int start, int length) {
        return new QueryPage(this.toWrap, start + this.start, Math.min(length, Math.max(0, this.length - start)));
    }

    public boolean equals(Object obj) {
        if (obj instanceof QueryPage) {
            QueryPage page = (QueryPage)obj;
            return page.start == this.start && page.length == this.length && page.toWrap.equals(this.toWrap);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.start + this.toWrap.hashCode();
    }

    @Override
    public List compute(IProgressMonitor mon) throws TeamRepositoryException {
        List unfiltered = QueryCache.execute(this.toWrap, mon);
        ArrayList filtered = new ArrayList();
        int counter = 0;
        for (Object next : unfiltered) {
            if (counter >= this.start && counter < this.length) {
                filtered.add(next);
            }
            ++counter;
        }
        return filtered;
    }
}

