/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.EclipseReadException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IFileSystemView;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.IFileContentMerger;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreasLock;
import com.ibm.team.filesystem.client.internal.operations.ChangeHistoryChangeSetsOperation;
import com.ibm.team.filesystem.client.internal.operations.IFilesystemRefresher;
import com.ibm.team.filesystem.client.internal.operations.IWorkspaceUpdateReporter;
import com.ibm.team.filesystem.client.internal.operations.NullWorkspaceUpdateReporter;
import com.ibm.team.filesystem.client.internal.operations.UpdateCurrentPortOperation;
import com.ibm.team.filesystem.client.internal.operations.UpdateOperation;
import com.ibm.team.filesystem.client.internal.operations.WorkspaceUpdateReport;
import com.ibm.team.filesystem.client.internal.operations.WorkspaceUpdateRequest;
import com.ibm.team.filesystem.client.internal.utils.ChangeSetRefreshUtils;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.ConnectionFacade;
import com.ibm.team.filesystem.client.internal.utils.ExclusiveFileLockPatternUtil;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.IAutoResolveConflictsOperation;
import com.ibm.team.filesystem.client.operations.IDownloadListener;
import com.ibm.team.filesystem.client.operations.IResumeOperation;
import com.ibm.team.filesystem.client.operations.IUnshareOperation;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.IWorkspaceUpdateOperation;
import com.ibm.team.filesystem.client.operations.IWorkspaceUpdateReport;
import com.ibm.team.filesystem.client.operations.UpdateCurrentPatchDilemmaHandler;
import com.ibm.team.filesystem.client.operations.WorkspaceUpdateDilemmaHandler;
import com.ibm.team.filesystem.common.IContentChangeDetail;
import com.ibm.team.filesystem.common.IEncodingChangeDetail;
import com.ibm.team.filesystem.common.ILineDelimiterChangeDetail;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.ILogicalConflict;
import com.ibm.team.filesystem.common.ILogicalConflictReport;
import com.ibm.team.filesystem.common.internal.util.StringMatcher;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.StaleDataException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.HistoryReorderingCausesNWayConflictException;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.FlowUtils;
import com.ibm.team.scm.common.AcceptSuspendedChangeSetException;
import com.ibm.team.scm.common.ActiveChangeSetsException;
import com.ibm.team.scm.common.ActiveChangeSetsOverlapException;
import com.ibm.team.scm.common.ChangeSetAlreadyInHistoryException;
import com.ibm.team.scm.common.GapException;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineHierarchyResult;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IComponentHierarchyNode;
import com.ibm.team.scm.common.IComponentHierarchyResult;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IHierarchyNode;
import com.ibm.team.scm.common.IHierarchyResult;
import com.ibm.team.scm.common.IHistoryReference;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.LockOperationFailureException;
import com.ibm.team.scm.common.PatchInProgressException;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import com.ibm.team.scm.common.dto.IGapFillingChangeSetsReport;
import com.ibm.team.scm.common.dto.IGapFillingChangeSetsReportList;
import com.ibm.team.scm.common.dto.IStreamLockReport;
import com.ibm.team.scm.common.dto.IUpdateReport;
import com.ibm.team.scm.common.internal.dto.SyncTime;
import com.ibm.team.scm.common.internal.flow.FlowTable;
import com.ibm.team.scm.common.internal.subcomponents.SubcomponentCommonUtils;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class WorkspaceUpdateOperation
extends ChangeHistoryChangeSetsOperation
implements IWorkspaceUpdateOperation,
IResumeOperation {
    private int acceptFlags;
    protected Map<IWorkspaceConnection, List<WorkspaceUpdateRequest>> acceptRequests;
    protected Map<IWorkspaceConnection, List<HierarchicalRequest>> hierarchicalRequests;
    protected Map<IWorkspaceConnection, Set<HierarchicalRemoveRequest>> removeComponentRequests;
    private final WorkspaceUpdateDilemmaHandler problemHandler;
    private Set<ConfigurationFacade> componentsAdded;
    private Set<ConfigurationFacade> componentsRemoved;
    private List<IComponent> componentsCreated;
    private boolean redundantChangeSets;
    private boolean resumedChangeSets;
    private boolean problemsEncountered;
    private IDownloadListener downloadListener;
    private boolean populateUpdateReport = false;
    private IWorkspaceUpdateReporter changes;
    private boolean isEclipseMetadataReadFailure;
    private List<String> eclipseReadMessages;
    private EclipseReadException savedEclipseReadException;
    private boolean autoAcquireLocks = false;
    private int numberOfConflictsResolved;

    public WorkspaceUpdateOperation(WorkspaceUpdateDilemmaHandler dilemmaHandler) {
        super(dilemmaHandler == null ? WorkspaceUpdateDilemmaHandler.getDefault() : dilemmaHandler);
        this.problemHandler = dilemmaHandler == null ? WorkspaceUpdateDilemmaHandler.getDefault() : dilemmaHandler;
        this.acceptRequests = new HashMap<IWorkspaceConnection, List<WorkspaceUpdateRequest>>();
        this.hierarchicalRequests = new HashMap<IWorkspaceConnection, List<HierarchicalRequest>>();
        this.removeComponentRequests = new HashMap<IWorkspaceConnection, Set<HierarchicalRemoveRequest>>();
        this.componentsAdded = new HashSet<ConfigurationFacade>();
        this.componentsRemoved = new HashSet<ConfigurationFacade>();
        this.componentsCreated = new ArrayList<IComponent>();
        this.redundantChangeSets = false;
        this.resumedChangeSets = false;
        this.acceptFlags = 0;
        this.problemsEncountered = false;
        this.isEclipseMetadataReadFailure = false;
        this.eclipseReadMessages = new ArrayList<String>();
    }

    public boolean isPreflightOnly() {
        return (this.acceptFlags & 1) == 1;
    }

    @Override
    public void setDownloadListener(IDownloadListener downloadListener) {
        this.downloadListener = downloadListener;
    }

    @Override
    public void acceptChangeSets(IWorkspaceConnection workspace, ITeamRepository sourceRepository, List<? extends IChangeSetHandle> changeSets) {
        if (workspace == null) {
            throw new IllegalArgumentException("'workspace' must not be null");
        }
        if (sourceRepository == null) {
            throw new IllegalArgumentException("'sourceRepository' must not be null");
        }
        if (changeSets == null) {
            throw new IllegalArgumentException("'changeSets' must not be null");
        }
        List<WorkspaceUpdateRequest> existingRequests = this.acceptRequests.get(workspace);
        WorkspaceUpdateRequest existingRequest = null;
        if (existingRequests == null) {
            existingRequests = new ArrayList<WorkspaceUpdateRequest>();
            this.acceptRequests.put(workspace, existingRequests);
        }
        for (WorkspaceUpdateRequest request : existingRequests) {
            if (!request.isChangeSetContext() || !sourceRepository.equals(request.getSourceRepository())) continue;
            existingRequest = request;
            break;
        }
        if (existingRequest == null) {
            existingRequests.add(new WorkspaceUpdateRequest(workspace, sourceRepository, changeSets));
        } else {
            existingRequest.addChangeSets(changeSets);
        }
    }

    @Override
    public void accept(IWorkspaceConnection workspace, IWorkspaceConnection sourceWorkspace, IChangeHistorySyncReport syncReport, List<? extends IBaselineHandle> baselines, List<? extends IChangeSetHandle> changeSets, List<? extends IComponentHandle> components) throws TeamRepositoryException {
        if (workspace == null) {
            throw new IllegalArgumentException("'workspace' must not be null");
        }
        if (sourceWorkspace == null) {
            throw new IllegalArgumentException("'sourceWorkspace' must not be null");
        }
        if (syncReport == null) {
            throw new IllegalArgumentException("'syncReport' must not be null");
        }
        if (baselines == null) {
            throw new IllegalArgumentException("'baselines' must not be null");
        }
        if (changeSets == null) {
            throw new IllegalArgumentException("'changeSets' must not be null");
        }
        if (components == null) {
            throw new IllegalArgumentException("'components' must not be null");
        }
        List<WorkspaceUpdateRequest> existingRequests = this.acceptRequests.get(workspace);
        WorkspaceUpdateRequest existingRequest = null;
        if (existingRequests == null) {
            existingRequests = new ArrayList<WorkspaceUpdateRequest>();
            this.acceptRequests.put(workspace, existingRequests);
        }
        for (WorkspaceUpdateRequest request : existingRequests) {
            if (request.isChangeSetContext() || !sourceWorkspace.equals((Object)request.getSourceWorkspace())) continue;
            existingRequest = request;
            break;
        }
        if (existingRequest != null) {
            existingRequest.addBaselines(baselines);
            existingRequest.addChangeSets(changeSets);
            existingRequest.addComponents(components, false);
            existingRequest.updateSyncReport(syncReport);
        } else {
            WorkspaceUpdateRequest request;
            request = new WorkspaceUpdateRequest(workspace, sourceWorkspace, syncReport, baselines, changeSets, components);
            existingRequests.add(request);
        }
    }

    @Override
    public void accept(IWorkspaceConnection workspace, IWorkspaceConnection sourceWorkspace, IChangeHistorySyncReport syncReport) throws TeamRepositoryException {
        if (workspace == null) {
            throw new IllegalArgumentException("'workspace' must not be null");
        }
        if (sourceWorkspace == null) {
            throw new IllegalArgumentException("'sourceWorkspace' must not be null");
        }
        if (syncReport == null) {
            throw new IllegalArgumentException("'syncReport' must not be null");
        }
        List<WorkspaceUpdateRequest> existingRequests = this.acceptRequests.get(workspace);
        WorkspaceUpdateRequest existingRequest = null;
        if (existingRequests == null) {
            existingRequests = new ArrayList<WorkspaceUpdateRequest>();
            this.acceptRequests.put(workspace, existingRequests);
        }
        for (WorkspaceUpdateRequest request : existingRequests) {
            if (request.isChangeSetContext() || !sourceWorkspace.equals((Object)request.getSourceWorkspace())) continue;
            existingRequest = request;
            break;
        }
        if (existingRequest != null) {
            existingRequest.setWorkspaceContext(false);
            existingRequest.updateSyncReport(syncReport);
        } else {
            WorkspaceUpdateRequest request;
            request = new WorkspaceUpdateRequest(workspace, sourceWorkspace, syncReport, false);
            existingRequests.add(request);
        }
    }

    @Override
    public void accept(IWorkspaceConnection workspace, IWorkspaceConnection sourceWorkspace, IChangeHistorySyncReport syncReport, List<? extends IComponentHandle> components) throws TeamRepositoryException {
        if (workspace == null) {
            throw new IllegalArgumentException("'workspace' must not be null");
        }
        if (sourceWorkspace == null) {
            throw new IllegalArgumentException("'sourceWorkspace' must not be null");
        }
        if (syncReport == null) {
            throw new IllegalArgumentException("'syncReport' report must not be null");
        }
        if (components == null) {
            throw new IllegalArgumentException("'components' must not be null");
        }
        List<WorkspaceUpdateRequest> existingRequests = this.acceptRequests.get(workspace);
        WorkspaceUpdateRequest existingRequest = null;
        if (existingRequests == null) {
            existingRequests = new ArrayList<WorkspaceUpdateRequest>();
            this.acceptRequests.put(workspace, existingRequests);
        }
        for (WorkspaceUpdateRequest request : existingRequests) {
            if (request.isChangeSetContext() || !sourceWorkspace.equals((Object)request.getSourceWorkspace())) continue;
            existingRequest = request;
            break;
        }
        if (existingRequest != null) {
            existingRequest.addComponents(components, false);
            existingRequest.updateSyncReport(syncReport);
        } else {
            WorkspaceUpdateRequest request;
            request = new WorkspaceUpdateRequest(workspace, sourceWorkspace, syncReport, components, false);
            existingRequests.add(request);
        }
    }

    @Override
    public void resume(IWorkspaceConnection workspace, Collection<? extends IChangeSetHandle> changeSets) {
        if (workspace == null) {
            throw new IllegalArgumentException("'workspace' must not be null");
        }
        if (changeSets == null) {
            throw new IllegalArgumentException("'changeSets' must not be null");
        }
        ArrayList<? extends IChangeSetHandle> needAList = new ArrayList<IChangeSetHandle>();
        needAList.addAll(changeSets);
        this.acceptChangeSets(workspace, workspace.teamRepository(), needAList);
    }

    @Override
    public void replace(IWorkspaceConnection workspace, IRepositoryResolver resolver, IProgressMonitor progress) throws TeamRepositoryException {
        if (workspace == null) {
            throw new IllegalArgumentException("'workspace' must not be null");
        }
        if (resolver == null) {
            throw new IllegalArgumentException("'resolver' must not be null");
        }
        IFlowTable flowTable = workspace.getFlowTable();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)flowTable.acceptSources().size());
        for (IFlowEntry flowEntry : flowTable.acceptSources()) {
            IFlowNodeHandle source = flowEntry.getFlowNode();
            if (!(source instanceof IWorkspaceHandle)) continue;
            ITeamRepository repository = resolver.getRepoFor(flowEntry.getRemoteRepositoryURI(), flowEntry.getRemoteRepositoryIdentifier());
            IWorkspaceConnection sourceWorkspace = SCMPlatform.getWorkspaceManager((ITeamRepository)repository).getWorkspaceConnection((IWorkspaceHandle)source, (IProgressMonitor)monitor.newChild(1));
            ArrayList componentScopes = new ArrayList(flowTable.getComponentScopes(source));
            if (componentScopes.isEmpty()) {
                this.replace(workspace, sourceWorkspace);
                continue;
            }
            this.replace(workspace, sourceWorkspace, componentScopes);
        }
    }

    @Override
    public void replace(IWorkspaceConnection workspace, ITeamRepository sourceRepository, IBaselineSetHandle sourceSnapshot, List<? extends IComponentHandle> components) throws TeamRepositoryException {
        this.replace(workspace, sourceRepository, sourceSnapshot, null, components);
    }

    @Override
    public void replace(IWorkspaceConnection workspace, ITeamRepository sourceRepository, IBaselineSetHandle sourceSnapshot, IWorkspaceHandle operationSource, List<? extends IComponentHandle> components) throws TeamRepositoryException {
        if (workspace == null) {
            throw new IllegalArgumentException("'workspace' must not be null");
        }
        if (sourceRepository == null) {
            throw new IllegalArgumentException("'sourceRepository' must not be null");
        }
        if (sourceSnapshot == null) {
            throw new IllegalArgumentException("'sourceSnapshot' must not be null");
        }
        if (components == null) {
            throw new IllegalArgumentException("'components' must not be null");
        }
        List<WorkspaceUpdateRequest> existingRequests = this.acceptRequests.get(workspace);
        WorkspaceUpdateRequest existingRequest = null;
        if (existingRequests == null) {
            existingRequests = new ArrayList<WorkspaceUpdateRequest>();
            this.acceptRequests.put(workspace, existingRequests);
        }
        for (WorkspaceUpdateRequest request : existingRequests) {
            if (request.isChangeSetContext() || !sourceSnapshot.sameItemId((IItemHandle)request.getSourceSnapshot())) continue;
            existingRequest = request;
            break;
        }
        if (existingRequest != null) {
            existingRequest.addComponents(components, true);
        } else {
            WorkspaceUpdateRequest request;
            request = new WorkspaceUpdateRequest(workspace, sourceRepository, sourceSnapshot, operationSource, components);
            existingRequests.add(request);
        }
    }

    @Override
    public void replace(IWorkspaceConnection workspace, IWorkspaceConnection sourceWorkspace) {
        if (workspace == null) {
            throw new IllegalArgumentException("'workspace' must not be null");
        }
        if (sourceWorkspace == null) {
            throw new IllegalArgumentException("'sourceWorkspace' must not be null");
        }
        List<WorkspaceUpdateRequest> existingRequests = this.acceptRequests.get(workspace);
        WorkspaceUpdateRequest existingRequest = null;
        if (existingRequests == null) {
            existingRequests = new ArrayList<WorkspaceUpdateRequest>();
            this.acceptRequests.put(workspace, existingRequests);
        }
        for (WorkspaceUpdateRequest request : existingRequests) {
            if (request.isChangeSetContext() || sourceWorkspace != request.getSourceWorkspace()) continue;
            existingRequest = request;
            break;
        }
        if (existingRequest != null) {
            existingRequest.setWorkspaceContext(true);
        } else {
            WorkspaceUpdateRequest request;
            request = new WorkspaceUpdateRequest(workspace, sourceWorkspace, null, true);
            existingRequests.add(request);
        }
    }

    @Override
    public void replace(IWorkspaceConnection workspace, IWorkspaceConnection sourceWorkspace, List<? extends IComponentHandle> components, boolean hierarchical) throws TeamRepositoryException {
        if (workspace == null) {
            throw new IllegalArgumentException("'workspace' must not be null");
        }
        if (sourceWorkspace == null) {
            throw new IllegalArgumentException("'sourceWorkspace' must not be null");
        }
        if (components == null) {
            throw new IllegalArgumentException("'components' must not be null");
        }
        if (hierarchical) {
            List<HierarchicalRequest> existingRequests = this.hierarchicalRequests.get(workspace);
            if (existingRequests == null) {
                existingRequests = new ArrayList<HierarchicalRequest>();
                this.hierarchicalRequests.put(workspace, existingRequests);
            }
            HierarchicalRequest existingRequest = null;
            for (HierarchicalRequest request : existingRequests) {
                if (request.getSeedType() != 1 || !sourceWorkspace.getResolvedWorkspace().sameItemId((IItemHandle)request.getWorkspaceConnection().getResolvedWorkspace()) || request.getType() != 1) continue;
                existingRequest = request;
                break;
            }
            if (existingRequest == null) {
                HierarchicalRequest request;
                request = new HierarchicalRequest(sourceWorkspace, components, false);
                existingRequests.add(request);
            } else {
                existingRequest.addComponents(components);
            }
        } else {
            this.replace(workspace, sourceWorkspace, components);
        }
    }

    @Override
    public void add(IWorkspaceConnection workspace, IWorkspaceConnection sourceWorkspace, List<? extends IComponentHandle> components, boolean hierarchical) throws TeamRepositoryException {
        if (workspace == null) {
            throw new IllegalArgumentException("'workspace' must not be null");
        }
        if (sourceWorkspace == null) {
            throw new IllegalArgumentException("'sourceWorkspace' must not be null");
        }
        if (components == null) {
            throw new IllegalArgumentException("'components' must not be null");
        }
        if (hierarchical) {
            List<HierarchicalRequest> existingRequests = this.hierarchicalRequests.get(workspace);
            if (existingRequests == null) {
                existingRequests = new ArrayList<HierarchicalRequest>();
                this.hierarchicalRequests.put(workspace, existingRequests);
            }
            HierarchicalRequest existingRequest = null;
            for (HierarchicalRequest request : existingRequests) {
                if (request.getSeedType() != 1 || !sourceWorkspace.getResolvedWorkspace().sameItemId((IItemHandle)request.getWorkspaceConnection().getResolvedWorkspace()) || request.getType() != 0) continue;
                existingRequest = request;
                break;
            }
            if (existingRequest == null) {
                HierarchicalRequest request;
                request = new HierarchicalRequest(sourceWorkspace, components, true);
                existingRequests.add(request);
            } else {
                existingRequest.addComponents(components);
            }
        } else {
            this.replace(workspace, sourceWorkspace, components);
        }
    }

    @Override
    public void replace(IWorkspaceConnection workspace, IWorkspaceConnection sourceWorkspace, List<? extends IComponentHandle> components) throws TeamRepositoryException {
        if (workspace == null) {
            throw new IllegalArgumentException("'workspace' must not be null");
        }
        if (sourceWorkspace == null) {
            throw new IllegalArgumentException("'sourceWorkspace' must not be null");
        }
        if (components == null) {
            throw new IllegalArgumentException("'components' must not be null");
        }
        List<WorkspaceUpdateRequest> existingRequests = this.acceptRequests.get(workspace);
        WorkspaceUpdateRequest existingRequest = null;
        if (existingRequests == null) {
            existingRequests = new ArrayList<WorkspaceUpdateRequest>();
            this.acceptRequests.put(workspace, existingRequests);
        }
        for (WorkspaceUpdateRequest request : existingRequests) {
            if (request.isChangeSetContext() || !sourceWorkspace.equals((Object)request.getSourceWorkspace())) continue;
            existingRequest = request;
            break;
        }
        if (existingRequest != null) {
            existingRequest.addComponents(components, true);
        } else {
            WorkspaceUpdateRequest request;
            request = new WorkspaceUpdateRequest(workspace, sourceWorkspace, null, components, true);
            existingRequests.add(request);
        }
    }

    @Override
    public void replaceFromHierarchicalBaseline(IWorkspaceConnection workspace, IBaselineConnection sourceBaseline) {
        this.replaceFromHierarchicalBaseline(workspace, sourceBaseline, null);
    }

    @Override
    public void replaceFromHierarchicalBaseline(IWorkspaceConnection workspace, IBaselineConnection sourceBaseline, IWorkspaceHandle operationSource) {
        if (workspace == null) {
            throw new IllegalArgumentException("'workspace' must not be null");
        }
        if (sourceBaseline == null) {
            throw new IllegalArgumentException("'sourceBaseline' must not be null");
        }
        List<HierarchicalRequest> existingRequests = this.hierarchicalRequests.get(workspace);
        HierarchicalRequest existingRequest = null;
        if (existingRequests == null) {
            existingRequests = new ArrayList<HierarchicalRequest>();
            this.hierarchicalRequests.put(workspace, existingRequests);
        }
        for (HierarchicalRequest request : existingRequests) {
            if (!sourceBaseline.getBaseline().sameItemId((IItemHandle)request.getBaselineConnection().getBaseline())) continue;
            existingRequest = request;
            break;
        }
        if (existingRequest == null) {
            HierarchicalRequest request;
            request = new HierarchicalRequest(sourceBaseline, operationSource);
            existingRequests.add(request);
        }
    }

    @Override
    public void replace(IWorkspaceConnection workspace, IBaselineConnection sourceBaseline) {
        this.replace(workspace, sourceBaseline, null);
    }

    @Override
    public void replace(IWorkspaceConnection workspace, IBaselineConnection sourceBaseline, IWorkspaceHandle operationSource) {
        if (workspace == null) {
            throw new IllegalArgumentException("'workspace' must not be null");
        }
        if (sourceBaseline == null) {
            throw new IllegalArgumentException("'sourceBaseline' must not be null");
        }
        List<WorkspaceUpdateRequest> existingRequests = this.acceptRequests.get(workspace);
        WorkspaceUpdateRequest existingRequest = null;
        if (existingRequests == null) {
            existingRequests = new ArrayList<WorkspaceUpdateRequest>();
            this.acceptRequests.put(workspace, existingRequests);
        }
        for (WorkspaceUpdateRequest request : existingRequests) {
            if (request.isChangeSetContext() || request.getSourceBaseline() == null || !sourceBaseline.getBaseline().sameItemId((IItemHandle)request.getSourceBaseline().getBaseline())) continue;
            existingRequest = request;
            break;
        }
        if (existingRequest != null) {
            existingRequest.setWorkspaceContext(true);
        } else {
            WorkspaceUpdateRequest request;
            request = new WorkspaceUpdateRequest(workspace, sourceBaseline, operationSource);
            existingRequests.add(request);
        }
    }

    @Override
    public void replace(IWorkspaceConnection workspace, ITeamRepository sourceRepository, IBaselineSetHandle sourceSnapshot) {
        this.replace(workspace, sourceRepository, sourceSnapshot, (IWorkspaceHandle)null);
    }

    @Override
    public void replace(IWorkspaceConnection workspace, ITeamRepository sourceRepository, IBaselineSetHandle sourceSnapshot, IWorkspaceHandle operationSource) {
        if (workspace == null) {
            throw new IllegalArgumentException("'workspace' must not be null");
        }
        if (sourceRepository == null) {
            throw new IllegalArgumentException("'sourceRepository' must not be null");
        }
        if (sourceSnapshot == null) {
            throw new IllegalArgumentException("'sourceSnapshot' must not be null");
        }
        List<WorkspaceUpdateRequest> existingRequests = this.acceptRequests.get(workspace);
        WorkspaceUpdateRequest existingRequest = null;
        if (existingRequests == null) {
            existingRequests = new ArrayList<WorkspaceUpdateRequest>();
            this.acceptRequests.put(workspace, existingRequests);
        }
        for (WorkspaceUpdateRequest request : existingRequests) {
            if (request.isChangeSetContext() || !sourceSnapshot.sameItemId((IItemHandle)request.getSourceSnapshot())) continue;
            existingRequest = request;
            break;
        }
        if (existingRequest != null) {
            existingRequest.setWorkspaceContext(true);
        } else {
            WorkspaceUpdateRequest request;
            request = new WorkspaceUpdateRequest(workspace, sourceRepository, sourceSnapshot, operationSource);
            existingRequests.add(request);
        }
    }

    @Override
    public void addComponent(IWorkspaceConnection workspace, String newComponentName) {
        if (workspace == null) {
            throw new IllegalArgumentException("'workspace' must not be null");
        }
        if (newComponentName == null) {
            throw new IllegalArgumentException("'newComponentName' must not be null");
        }
        List<WorkspaceUpdateRequest> existingRequests = this.acceptRequests.get(workspace);
        WorkspaceUpdateRequest existingRequest = null;
        if (existingRequests == null) {
            existingRequests = new ArrayList<WorkspaceUpdateRequest>();
            this.acceptRequests.put(workspace, existingRequests);
        }
        for (WorkspaceUpdateRequest request : existingRequests) {
            if (request.isChangeSetContext()) continue;
            existingRequest = request;
            break;
        }
        if (existingRequest != null) {
            existingRequest.addNewComponent(newComponentName);
        } else {
            WorkspaceUpdateRequest request;
            request = new WorkspaceUpdateRequest(workspace, newComponentName);
            existingRequests.add(request);
        }
    }

    @Override
    public void addComponent(IWorkspaceConnection workspace, ITeamRepository sourceRepository, IComponentHandle component) {
        if (workspace == null) {
            throw new IllegalArgumentException("'workspace' must not be null");
        }
        if (sourceRepository == null) {
            throw new IllegalArgumentException("'sourceRepository' must not be null");
        }
        if (component == null) {
            throw new IllegalArgumentException("'component' must not be null");
        }
        List<WorkspaceUpdateRequest> existingRequests = this.acceptRequests.get(workspace);
        WorkspaceUpdateRequest existingRequest = null;
        if (existingRequests == null) {
            existingRequests = new ArrayList<WorkspaceUpdateRequest>();
            this.acceptRequests.put(workspace, existingRequests);
        }
        for (WorkspaceUpdateRequest request : existingRequests) {
            if (request.isChangeSetContext() || !sourceRepository.equals(request.getSourceRepository())) continue;
            existingRequest = request;
            break;
        }
        if (existingRequest != null) {
            existingRequest.addNewComponent(sourceRepository, component);
        } else {
            WorkspaceUpdateRequest request;
            request = new WorkspaceUpdateRequest(workspace, sourceRepository, component);
            existingRequests.add(request);
        }
    }

    protected void addComponent(IWorkspaceConnection workspace, IHistoryReference history, IComponentHandle component) {
        if (workspace == null || history == null || component == null) {
            throw new IllegalArgumentException();
        }
        List<WorkspaceUpdateRequest> existingRequests = this.acceptRequests.get(workspace);
        if (existingRequests == null) {
            existingRequests = new ArrayList<WorkspaceUpdateRequest>();
            this.acceptRequests.put(workspace, existingRequests);
        }
        WorkspaceUpdateRequest request = WorkspaceUpdateRequest.add(workspace, history, component);
        existingRequests.add(request);
    }

    protected void replaceComponent(IWorkspaceConnection workspace, IHistoryReference history, IComponentHandle component) {
        if (workspace == null || history == null || component == null) {
            throw new IllegalArgumentException();
        }
        List<WorkspaceUpdateRequest> existingRequests = this.acceptRequests.get(workspace);
        if (existingRequests == null) {
            existingRequests = new ArrayList<WorkspaceUpdateRequest>();
            this.acceptRequests.put(workspace, existingRequests);
        }
        WorkspaceUpdateRequest request = WorkspaceUpdateRequest.replace(workspace, history, component);
        existingRequests.add(request);
    }

    @Override
    public void removeComponent(IWorkspaceConnection workspace, IComponentHandle componentHandle) {
        this.addHierarchicalRemoveRequest(workspace, componentHandle);
    }

    private void addHierarchicalRemoveRequest(IWorkspaceConnection workspace, IComponentHandle componentHandle) {
        if (workspace == null) {
            throw new IllegalArgumentException("'workspace' must not be null");
        }
        if (componentHandle == null) {
            throw new IllegalArgumentException("'componentHandle' must not be null");
        }
        HierarchicalRemoveRequest request = new HierarchicalRemoveRequest(workspace, componentHandle);
        Set<HierarchicalRemoveRequest> existingRequests = this.removeComponentRequests.get(request.getWorkspaceConnection());
        if (existingRequests == null) {
            existingRequests = new HashSet<HierarchicalRemoveRequest>();
            this.removeComponentRequests.put(workspace, existingRequests);
        }
        existingRequests.add(request);
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        this.changes = this.populateUpdateReport ? new WorkspaceUpdateReport() : new NullWorkspaceUpdateReporter();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.WorkspaceUpdateOperation_5, (int)100);
        this.problemsEncountered = false;
        ArrayList determinants = new ArrayList();
        HashSet<IContextHandle> affectedContexts = new HashSet<IContextHandle>();
        final HashSet<ConfigurationFacade> affectedConfigurations = new HashSet<ConfigurationFacade>();
        final ArrayList<ICopyFileAreaLockRequest> cfaLockRequests = new ArrayList<ICopyFileAreaLockRequest>();
        this.getAffectedConfigurations(affectedContexts, affectedConfigurations, cfaLockRequests, (IProgressMonitor)progress.newChild(2));
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWriteForConfigurations(affectedConfigurations, affectedContexts, determinants, (IProgressMonitor)progress.newChild(1));
        progress.setWorkRemaining(97 + affectedConfigurations.size());
        try {
            if (this.verifyInSyncEnabled() && !this.problemHandler.getOutOfSyncDilemmaHandler().willIgnoreAllSharesOutOfSync()) {
                IVerifyInSyncOperation verifyOp = IOperationFactory.instance.getVerifyInSyncOperation(this.problemHandler.getOutOfSyncDilemmaHandler());
                for (ConfigurationFacade configuration : affectedConfigurations) {
                    verifyOp.addToVerify(configuration.getConnection((IProgressMonitor)progress.newChild(1)), configuration.getComponentHandle());
                }
                verifyOp.run((IProgressMonitor)progress.newChild(2));
            }
            progress.setWorkRemaining(95);
            IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

                @Override
                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    try {
                        ICopyFileAreasLock copyFileAreaLock = ICopyFileAreaManager.instance.lock(cfaLockRequests, (IProgressMonitor)progress.newChild(1));
                        try {
                            WorkspaceUpdateOperation.this.doAccept(affectedConfigurations, (IProgressMonitor)progress.newChild(98));
                        }
                        finally {
                            copyFileAreaLock.release((IProgressMonitor)progress.newChild(1));
                        }
                    }
                    catch (TeamRepositoryException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            this.runWithinFileSystemLock(runnableWithProgress, Messages.WorkspaceUpdateOperation_6, (IProgressMonitor)progress.newChild(95));
        }
        finally {
            WorkspaceLockUtil.release(workspaceLock);
        }
    }

    @Override
    public void runPreConditionsOnly(IProgressMonitor progress) throws TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (String)Messages.WorkspaceUpdateOperation_3, (int)100);
        ArrayList determinants = new ArrayList();
        HashSet<IContextHandle> affectedContexts = new HashSet<IContextHandle>();
        final HashSet<ConfigurationFacade> affectedConfigurations = new HashSet<ConfigurationFacade>();
        final ArrayList<ICopyFileAreaLockRequest> cfaLockRequests = new ArrayList<ICopyFileAreaLockRequest>();
        this.getAffectedConfigurations(affectedContexts, affectedConfigurations, cfaLockRequests, (IProgressMonitor)monitor.newChild(1));
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWriteForConfigurations(affectedConfigurations, affectedContexts, determinants, (IProgressMonitor)monitor.newChild(1));
        try {
            try {
                if (this.verifyInSyncEnabled() && !this.problemHandler.getOutOfSyncDilemmaHandler().willIgnoreAllSharesOutOfSync()) {
                    IVerifyInSyncOperation verifyOp = IOperationFactory.instance.getVerifyInSyncOperation(this.problemHandler.getOutOfSyncDilemmaHandler());
                    for (ConfigurationFacade configuration : affectedConfigurations) {
                        verifyOp.addToVerify(configuration.getConnection(null), configuration.getComponentHandle());
                    }
                    verifyOp.run((IProgressMonitor)monitor.newChild(3));
                }
                IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

                    @Override
                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                        try {
                            ICopyFileAreasLock copyFileAreaLock = ICopyFileAreaManager.instance.lock(cfaLockRequests, (IProgressMonitor)progress.newChild(1));
                            try {
                                WorkspaceUpdateOperation.this.runPreConditions(affectedConfigurations, (IProgressMonitor)progress.newChild(98));
                            }
                            finally {
                                copyFileAreaLock.release((IProgressMonitor)progress.newChild(1));
                            }
                        }
                        catch (TeamRepositoryException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                };
                this.runWithinFileSystemLock(runnableWithProgress, Messages.WorkspaceUpdateOperation_7, (IProgressMonitor)monitor.newChild(95));
            }
            catch (FileSystemException e) {
                throw new TeamRepositoryException((Throwable)((Object)e));
            }
        }
        finally {
            WorkspaceLockUtil.release(workspaceLock);
        }
    }

    @Override
    public Collection<ConfigurationFacade> getComponentsAdded() {
        return this.componentsAdded;
    }

    @Override
    public Collection<ConfigurationFacade> getComponentsRemoved() {
        return this.componentsRemoved;
    }

    @Override
    public List<IComponent> getComponentsCreated() {
        return this.componentsCreated;
    }

    private void doAccept(Set<ConfigurationFacade> affectedConfigurations, IProgressMonitor progress) throws TeamRepositoryException, FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(100 + 100 * this.acceptRequests.size()));
        HashMap<IWorkspaceConnection, List<IUpdateReport>> updateReports = new HashMap<IWorkspaceConnection, List<IUpdateReport>>();
        this.runPreConditions(affectedConfigurations, (IProgressMonitor)monitor.newChild(8));
        HashMap<IWorkspaceConnection, ArrayList<IChangeSetHandle>> workspaceResumedChangeSets = new HashMap<IWorkspaceConnection, ArrayList<IChangeSetHandle>>();
        for (Map.Entry<IWorkspaceConnection, List<WorkspaceUpdateRequest>> entry : this.acceptRequests.entrySet()) {
            SubMonitor iterProgress = monitor.newChild(100);
            IWorkspaceConnection workspace = entry.getKey();
            List<WorkspaceUpdateRequest> requests = entry.getValue();
            if (!this.isPreflightOnly()) {
                this.performComponentOperations(workspace, requests, updateReports, (IProgressMonitor)iterProgress.newChild(5));
            }
            ArrayList<IChangeSetHandle> resumedChangeSetsList = new ArrayList<IChangeSetHandle>();
            iterProgress.setWorkRemaining(20 + 10 * requests.size());
            for (WorkspaceUpdateRequest acceptRequest : requests) {
                this.performAcceptRequest(acceptRequest, updateReports, resumedChangeSetsList, (IProgressMonitor)iterProgress.newChild(10));
                if (this.problemsEncountered) break;
                this.checkCancelled((IProgressMonitor)monitor);
            }
            iterProgress.setWorkRemaining(10 + workspace.getComponents().size());
            if (!resumedChangeSetsList.isEmpty()) {
                ArrayList<IChangeSetHandle> resumedChangeSetHandles = (ArrayList<IChangeSetHandle>)workspaceResumedChangeSets.get(entry.getKey());
                if (resumedChangeSetHandles == null) {
                    resumedChangeSetHandles = new ArrayList<IChangeSetHandle>(resumedChangeSetsList.size());
                    workspaceResumedChangeSets.put(entry.getKey(), resumedChangeSetHandles);
                }
                resumedChangeSetHandles.addAll(resumedChangeSetsList);
                Map<IComponentHandle, IChangeSetHandle> changeSetsToBeCurrent = WorkspaceUpdateOperation.shouldMakeResumedCurrent(workspace, resumedChangeSetsList, (IProgressMonitor)iterProgress.newChild(10));
                for (IChangeSetHandle toMakeCurrent : changeSetsToBeCurrent.values()) {
                    workspace.setCurrentChangeSet(toMakeCurrent, (IProgressMonitor)iterProgress.newChild(1));
                }
            }
            if (this.problemsEncountered) break;
        }
        if (!this.isPreflightOnly()) {
            SubMonitor iterMonitor = monitor.setWorkRemaining(10 + updateReports.size() * 10);
            if (!this.componentsRemoved.isEmpty()) {
                try {
                    IUnshareOperation op = this.getUnshareProjectsOperation(this.componentsRemoved);
                    op.run((IProgressMonitor)iterMonitor.newChild(10));
                }
                catch (TeamRepositoryException e) {
                    this.collectStatus(FileSystemStatusUtil.getStatusFor(e));
                }
            }
            for (Map.Entry entry : updateReports.entrySet()) {
                UpdateOperation updateOperation = new UpdateOperation((IWorkspaceConnection)entry.getKey(), (List)entry.getValue(), 3, this.problemHandler, this.downloadListener);
                this.disableVerifyInSync(updateOperation);
                try {
                    updateOperation.run((IProgressMonitor)iterMonitor.newChild(10));
                }
                catch (EclipseReadException e) {
                    this.isEclipseMetadataReadFailure = true;
                    IStatus s = FileSystemStatusUtil.getStatusFor((Throwable)((Object)e));
                    this.saveRecursiveMessages(s, this.eclipseReadMessages);
                    this.savedEclipseReadException = e;
                }
                catch (FileSystemException e) {
                    this.collectStatus(FileSystemStatusUtil.getStatusFor((Throwable)((Object)e)));
                }
                catch (TeamRepositoryException e) {
                    this.collectStatus(FileSystemStatusUtil.getStatusFor(e));
                }
                if (!this.problemHandler.isAutoResolveEnabled()) continue;
                IAutoResolveConflictsOperation op = IOperationFactory.instance.getAutoResolveConflictsOperation(this.problemHandler.getAutoResolveConflictsDilemmaHandler(), IRepositoryResolver.EXISTING_SHARED);
                op.setFileContentMerger(this.getFileContentMerger());
                IFileSystemView fsv = FileSystemCore.getFileSystemManager(((IWorkspaceConnection)entry.getKey()).teamRepository()).getFileSystemView((IConnection)entry.getKey());
                ILogicalConflictReport conflictReport = fsv.conflictReport((IProgressMonitor)iterMonitor.newChild(1));
                Set<UUID> componentIds = this.getComponentIds((List)entry.getValue());
                for (ILogicalConflict lc : conflictReport.conflicts()) {
                    if (!componentIds.contains(lc.component().getItemId())) continue;
                    op.autoResolveConflict((IWorkspaceConnection)entry.getKey(), conflictReport, (ILogicalChange)lc);
                }
                for (ILogicalConflict lc : conflictReport.autoMergeChanges()) {
                    if (!componentIds.contains(lc.component().getItemId())) continue;
                    op.autoResolveConflict((IWorkspaceConnection)entry.getKey(), conflictReport, (ILogicalChange)lc);
                }
                try {
                    op.run((IProgressMonitor)iterMonitor.newChild(1));
                }
                catch (Exception e) {
                    this.collectStatus(FileSystemStatusUtil.getStatusFor(e));
                    this.problemsEncountered = true;
                }
                this.numberOfConflictsResolved += op.numberOfConflictsResolved();
            }
            if (!workspaceResumedChangeSets.isEmpty()) {
                for (Map.Entry entry : workspaceResumedChangeSets.entrySet()) {
                    this.refreshLocks((IWorkspaceConnection)entry.getKey(), (List)entry.getValue(), affectedConfigurations, monitor.newChild(10));
                }
            }
        }
        boolean autoResolveCurrentPatchContentChanges = !this.problemsEncountered;
        autoResolveCurrentPatchContentChanges |= (this.acceptFlags & 8) != 0;
        if (autoResolveCurrentPatchContentChanges |= (this.acceptFlags & 0xC) != 0) {
            for (IWorkspaceConnection workspace : this.acceptRequests.keySet()) {
                this.performAutoResolveCurrentPatchContentChanges(workspace, this.getComponentsWithCurrentPatch(workspace, updateReports, false), (IProgressMonitor)monitor.newChild(1));
            }
        }
        if (this.numberOfConflictsResolved > 0) {
            this.problemHandler.setConflictsAutoResolved(this.numberOfConflictsResolved);
        }
    }

    private Set<UUID> getComponentIds(List<IUpdateReport> reports) {
        HashSet<UUID> ids = new HashSet<UUID>();
        for (IUpdateReport ur : reports) {
            for (IComponentHandle ch : ur.getAffectedComponents()) {
                ids.add(ch.getItemId());
            }
        }
        return ids;
    }

    private void refreshLocks(IWorkspaceConnection workspaceConnection, List<IChangeSetHandle> resumedChangeSets, Set<ConfigurationFacade> affectedConfigurations, SubMonitor progress) throws TeamRepositoryException {
        try {
            Map<IStreamLockReport, IWorkspaceConnection> locksToAcquire2;
            List<StringMatcher> matchers = ExclusiveFileLockPatternUtil.getPatternsToMatch((IConnection)workspaceConnection, (IProgressMonitor)progress.newChild(1));
            if (matchers.size() == 0) {
                return;
            }
            List resumedChangeSets2 = workspaceConnection.teamRepository().itemManager().fetchCompleteItems(resumedChangeSets, 0, (IProgressMonitor)progress.newChild(1));
            if (resumedChangeSets2.size() == 0) {
                return;
            }
            ArrayList<IChangeSet> resumedChangeSets3 = new ArrayList<IChangeSet>();
            for (IChangeSet changeSet : resumedChangeSets2) {
                if (!changeSet.getAuthor().getItemId().equals((Object)workspaceConnection.teamRepository().loggedInContributor().getItemId())) continue;
                resumedChangeSets3.add(changeSet);
            }
            Map<IStreamLockReport, IWorkspaceConnection> locksHeldByUsers = ExclusiveFileLockPatternUtil.getLocksHeldByUsers(workspaceConnection, resumedChangeSets3, (IProgressMonitor)progress.newChild(50));
            Map<IStreamLockReport, IWorkspaceConnection> locksHeldByOtherUsers = ExclusiveFileLockPatternUtil.getLocksHeldByOtherUsers(workspaceConnection, locksHeldByUsers, (IProgressMonitor)progress.newChild(50));
            if (locksHeldByOtherUsers != null && locksHeldByOtherUsers.size() > 0) {
                this.problemHandler.locksWereHeld(locksHeldByOtherUsers);
                return;
            }
            Map<IStreamLockReport, IWorkspaceConnection> locksToAcquire = ExclusiveFileLockPatternUtil.getLocksToAcquire(workspaceConnection, locksHeldByUsers, resumedChangeSets3, (IProgressMonitor)progress.newChild(50));
            if (locksToAcquire != null && locksToAcquire.size() > 0 && !(locksToAcquire2 = this.autoAcquireLocks ? locksToAcquire : this.problemHandler.locksToAcquire(locksToAcquire)).isEmpty()) {
                try {
                    ExclusiveFileLockPatternUtil.acquireLocks(locksToAcquire2, workspaceConnection, this.problemHandler.getLockDilemmaHandler(), progress.newChild(10));
                    ExclusiveFileLockPatternUtil.refreshFileAttributes(locksToAcquire2, affectedConfigurations, workspaceConnection, matchers, false, progress.newChild(10));
                }
                catch (LockOperationFailureException e) {
                    this.collectStatus(FileSystemStatusUtil.getStatusFor(e));
                }
            }
        }
        catch (FileSystemException e) {
            this.collectStatus(FileSystemStatusUtil.getStatusFor((Throwable)((Object)e)));
        }
        catch (TeamRepositoryException e) {
            this.collectStatus(FileSystemStatusUtil.getStatusFor(e));
        }
    }

    private void saveRecursiveMessages(IStatus status, List<String> savedMessages) {
        IStatus[] sChildren;
        savedMessages.add(status.getMessage());
        IStatus[] iStatusArray = sChildren = status.getChildren();
        int n = sChildren.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus sChild = iStatusArray[n2];
            this.saveRecursiveMessages(sChild, savedMessages);
            ++n2;
        }
    }

    private void performComponentOperations(IWorkspaceConnection workspace, List<WorkspaceUpdateRequest> requests, Map<IWorkspaceConnection, List<IUpdateReport>> updateReports, IProgressMonitor progress) throws TeamRepositoryException, FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(5 + 10 * requests.size()));
        ArrayList<IFlowNodeConnection.IComponentOp> componentOps = new ArrayList<IFlowNodeConnection.IComponentOp>();
        for (WorkspaceUpdateRequest acceptRequest : requests) {
            acceptRequest.createNewComponents((IProgressMonitor)monitor.newChild(1));
            componentOps.addAll(acceptRequest.getComponentOperations((IProgressMonitor)monitor.newChild(1)));
            componentOps.addAll(acceptRequest.getReplaceCandidates((IProgressMonitor)monitor.newChild(1)));
        }
        for (WorkspaceUpdateRequest acceptRequest : requests) {
            Collection<IFlowNodeConnection.IComponentOp> componentOpsDone = acceptRequest.getComponentOperations((IProgressMonitor)monitor.newChild(1));
            SubMonitor iterProgress = monitor.newChild(6);
            iterProgress.setWorkRemaining(componentOpsDone.size());
            for (IFlowNodeConnection.IComponentOp componentOp : componentOpsDone) {
                List activeChangeSets;
                IWorkspaceConnection sourceWorkspace = acceptRequest.getSourceWorkspace();
                if (sourceWorkspace == null || !(componentOp instanceof IFlowNodeConnection.IComponentAdditionOp) || (activeChangeSets = sourceWorkspace.activeChangeSets(componentOp.getComponent())).isEmpty()) continue;
                int result = this.problemHandler.activeChangeSetsComponent(workspace, componentOp.getComponent(), activeChangeSets);
                if (result == 1) {
                    throw new OperationCanceledException();
                }
                if (result == 0) continue;
                throw new FileSystemException(Messages.WorkspaceUpdateOperation_ActiveChangeSetsComponent_FailMessage);
            }
        }
        this.checkCancelled((IProgressMonitor)monitor);
        if (!componentOps.isEmpty() && !this.problemsEncountered) {
            IUpdateReport updateReport = workspace.applyComponentOperations(componentOps, true, (IProgressMonitor)monitor.newChild(5));
            this.changes.recordComponentOps(workspace, componentOps);
            this.holdUpdateReport(workspace, updateReport, updateReports);
            for (WorkspaceUpdateRequest acceptRequest : requests) {
                Collection<IFlowNodeConnection.IComponentOp> componentOpsDone = acceptRequest.getComponentOperations((IProgressMonitor)monitor.newChild(1));
                SubMonitor iterProgress = monitor.newChild(6);
                iterProgress.setWorkRemaining(componentOpsDone.size());
                for (IFlowNodeConnection.IComponentOp componentOp : componentOpsDone) {
                    FlowTable flowTable;
                    IWorkspaceConnection sourceWorkspace = acceptRequest.getSourceWorkspace();
                    if (componentOp instanceof IFlowNodeConnection.IComponentAdditionOp) {
                        flowTable = (FlowTable)acceptRequest.getWorkspace().getFlowTable();
                        if (sourceWorkspace != null && flowTable.getDeliverFlow((IFlowNodeHandle)sourceWorkspace.getResolvedWorkspace(), true) != null) {
                            FlowUtils.addComponentSyncState((IWorkspaceConnection)workspace, (IConnection)sourceWorkspace, (IComponentHandle)componentOp.getComponent(), (IProgressMonitor)iterProgress.newChild(1));
                        }
                        this.componentsAdded.add(new ConfigurationFacade((IConnection)workspace, componentOp.getComponent()));
                        continue;
                    }
                    if (!(componentOp instanceof IFlowNodeConnection.IComponentDeletionOp)) continue;
                    flowTable = (FlowTable)acceptRequest.getWorkspace().getFlowTable();
                    if (sourceWorkspace != null && flowTable.getDeliverFlow((IFlowNodeHandle)sourceWorkspace.getResolvedWorkspace(), true) != null) {
                        FlowUtils.removeComponentSyncState((IWorkspaceConnection)acceptRequest.getWorkspace(), (IConnection)sourceWorkspace, (IComponentHandle)componentOp.getComponent(), (IProgressMonitor)iterProgress.newChild(1));
                    }
                    this.componentsRemoved.add(new ConfigurationFacade((IConnection)workspace, componentOp.getComponent()));
                }
                this.componentsCreated.addAll(acceptRequest.getCreatedComponents());
            }
        }
    }

    private void runPreConditions(Set<ConfigurationFacade> affectedConfigurations, IProgressMonitor progress) throws TeamRepositoryException, FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)50);
        this.verifyComponentFlowing((IProgressMonitor)monitor.newChild(10));
        this.checkinPendingChanges(affectedConfigurations, this.problemHandler, true, (IProgressMonitor)monitor.newChild(10));
        this.verifyReplaceComponents((IProgressMonitor)monitor.newChild(10));
        this.disconnectedComponents(affectedConfigurations, (IProgressMonitor)monitor.newChild(10));
        this.validateRequests((IProgressMonitor)monitor.newChild(10));
    }

    private void verifyReplaceComponents(IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(10 + 10 * this.acceptRequests.size()));
        HashSet<ConfigurationFacade> replaceConfigurations = new HashSet<ConfigurationFacade>();
        HashMap replaces = new HashMap();
        for (List<WorkspaceUpdateRequest> requests : this.acceptRequests.values()) {
            SubMonitor iterProgress = SubMonitor.convert((IProgressMonitor)monitor.newChild(10), (int)(10 * requests.size()));
            for (WorkspaceUpdateRequest request : requests) {
                Collection<IFlowNodeConnection.IComponentReplacementOp> componentOps = request.getReplaceCandidates((IProgressMonitor)iterProgress.newChild(10));
                ArrayList<IComponentHandle> components = new ArrayList<IComponentHandle>();
                for (IFlowNodeConnection.IComponentReplacementOp op : componentOps) {
                    replaceConfigurations.add(new ConfigurationFacade((IConnection)request.getWorkspace(), op.getComponent()));
                    components.add(op.getComponent());
                }
                replaces.put(request, components);
            }
        }
        if (!replaceConfigurations.isEmpty()) {
            int direction = this.getAcceptDilemmaHandler().componentReplacementCandidates(replaceConfigurations);
            if (direction == 1) {
                throw new OperationCanceledException();
            }
            if (direction != 0) {
                if (direction == 3) {
                    SubMonitor iterProgress = SubMonitor.convert((IProgressMonitor)monitor.newChild(10), (int)replaces.size());
                    for (Map.Entry entry : replaces.entrySet()) {
                        WorkspaceUpdateRequest acceptRequest = (WorkspaceUpdateRequest)entry.getKey();
                        acceptRequest.excludeComponentOps((List)entry.getValue(), (IProgressMonitor)iterProgress.newChild(1));
                    }
                } else {
                    throw new FileSystemException(Messages.WorkspaceUpdateOperation_1);
                }
            }
        }
    }

    private void getAffectedConfigurations(Set<IContextHandle> workspacesToLock, Set<ConfigurationFacade> configurationsAffected, List<ICopyFileAreaLockRequest> cfaLockRequests, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(10 + this.acceptRequests.size()));
        HashSet<ConfigurationFacade> configurationsNoBackup = new HashSet<ConfigurationFacade>();
        this.processHierarchicalRequests(configurationsNoBackup, (IProgressMonitor)progress.newChild(10));
        HashSet<ConfigurationFacade> cfaConfigurationsAffected = new HashSet<ConfigurationFacade>();
        for (List<WorkspaceUpdateRequest> requests : this.acceptRequests.values()) {
            SubMonitor outerLoopProgress = progress.newChild(1).setWorkRemaining(requests.size());
            IWorkspaceConnection workspace = null;
            for (WorkspaceUpdateRequest acceptRequest : requests) {
                SubMonitor innerLoopProgress = outerLoopProgress.newChild(1).setWorkRemaining(3);
                workspace = acceptRequest.getWorkspace();
                configurationsAffected.addAll(acceptRequest.getAffectedConfigurations((IProgressMonitor)innerLoopProgress.newChild(1)));
                Collection<IFlowNodeConnection.IComponentOp> componentOps = acceptRequest.getComponentOperations((IProgressMonitor)innerLoopProgress.newChild(1));
                for (IFlowNodeConnection.IComponentOp componentOp : componentOps) {
                    if (componentOp instanceof IFlowNodeConnection.IComponentAdditionOp) {
                        workspacesToLock.add(workspace.getContextHandle());
                        break;
                    }
                    if (!(componentOp instanceof IFlowNodeConnection.IComponentDeletionOp)) continue;
                    workspacesToLock.add(workspace.getContextHandle());
                    break;
                }
                innerLoopProgress.done();
                for (IFlowNodeConnection.IComponentOp componentOp : componentOps) {
                    if (!(componentOp instanceof IFlowNodeConnection.IComponentAdditionOp)) continue;
                    cfaConfigurationsAffected.add(new ConfigurationFacade((IConnection)workspace, componentOp.getComponent()));
                }
                if (acceptRequest.getNewComponentNames().isEmpty()) continue;
                workspacesToLock.add(workspace.getContextHandle());
            }
        }
        if (configurationsNoBackup != null && !configurationsNoBackup.isEmpty()) {
            progress.setWorkRemaining(10);
            int instructions = this.problemHandler.noBackupBaselineForComponent(configurationsNoBackup, (IProgressMonitor)progress.newChild(10));
            if (instructions != 0) {
                if (instructions == 1) {
                    throw new OperationCanceledException();
                }
                this.handleProblem(new FileSystemException(Messages.WorkspaceUpdateOperation_12));
            }
        }
        cfaConfigurationsAffected.addAll(configurationsAffected);
        ICopyFileAreaLockRequest lockRequest = ICopyFileAreaManager.instance.lockRequestFactory().getLockRequest(cfaConfigurationsAffected, true);
        cfaLockRequests.add(lockRequest);
    }

    private void processHierarchicalRequests(Set<ConfigurationFacade> configurationsNoBackup, IProgressMonitor monitor) throws TeamRepositoryException {
        for (Map.Entry<IWorkspaceConnection, List<WorkspaceUpdateRequest>> entry : this.acceptRequests.entrySet()) {
            IWorkspaceConnection workspace = entry.getKey();
            IComponentHierarchyResult result = workspace.getComponentHierarchy(null);
            Map subcomponentStructure = result.getParentToChildrenMap();
            for (WorkspaceUpdateRequest request : entry.getValue()) {
                IBaselineConnection sourceBaseline = request.getSourceBaseline();
                if (sourceBaseline != null) {
                    IComponentHandle componentHandle = sourceBaseline.getComponent();
                    Collection subcomponents = (Collection)subcomponentStructure.get(componentHandle.getItemId());
                    if (subcomponents == null || subcomponents.isEmpty()) continue;
                    configurationsNoBackup.add(new ConfigurationFacade((IConnection)workspace, componentHandle));
                    continue;
                }
                for (IComponentHandle handle : request.getReplacedComponents()) {
                    Collection subcomponents = (Collection)subcomponentStructure.get(handle.getItemId());
                    if (subcomponents == null || subcomponents.isEmpty()) continue;
                    configurationsNoBackup.add(new ConfigurationFacade((IConnection)workspace, handle));
                }
            }
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.hierarchicalRequests.size() + this.removeComponentRequests.size()));
        for (Map.Entry entry : this.hierarchicalRequests.entrySet()) {
            List requests = (List)entry.getValue();
            ArrayList<IBaselineConnection> baselines = new ArrayList<IBaselineConnection>();
            HashMap components = new HashMap();
            HashMap<UUID, IWorkspaceConnection> sourceWorkspaces = new HashMap<UUID, IWorkspaceConnection>();
            HashMap<UUID, IWorkspaceHandle> operationSources = new HashMap<UUID, IWorkspaceHandle>();
            boolean fromBaselines = false;
            boolean fromWorkspaces = false;
            int requestType = 1;
            for (HierarchicalRequest request : requests) {
                switch (request.getSeedType()) {
                    case 0: {
                        baselines.add(request.getBaselineConnection());
                        if (request.getOperationSource() != null) {
                            operationSources.put(request.getBaselineConnection().getBaseline().getItemId(), request.getOperationSource());
                        }
                        fromBaselines = true;
                        break;
                    }
                    case 1: {
                        fromWorkspaces = true;
                        requestType = request.getType();
                        UUID key = request.getWorkspaceConnection().getResolvedWorkspace().getItemId();
                        HashMap<UUID, IComponentHandle> sourceWorkspaceComponents = (HashMap<UUID, IComponentHandle>)components.get(key);
                        if (sourceWorkspaceComponents == null) {
                            sourceWorkspaceComponents = new HashMap<UUID, IComponentHandle>();
                            components.put(key, sourceWorkspaceComponents);
                        }
                        sourceWorkspaceComponents.putAll(request.getComponents());
                        if (sourceWorkspaces.containsKey(key)) break;
                        sourceWorkspaces.put(key, request.getWorkspaceConnection());
                    }
                }
            }
            if (fromBaselines && fromWorkspaces) {
                throw new IllegalStateException("Cannot replace from baselines and workspaces at the same time");
            }
            IWorkspaceConnection workspace = (IWorkspaceConnection)entry.getKey();
            this.performHierarchialReplace(configurationsNoBackup, workspace, baselines, components, sourceWorkspaces, operationSources, requestType, (IProgressMonitor)progress.newChild(1));
        }
        HashMap<UUID, IComponentHandle> hashMap = new HashMap<UUID, IComponentHandle>();
        for (Map.Entry<IWorkspaceConnection, Set<HierarchicalRemoveRequest>> entry : this.removeComponentRequests.entrySet()) {
            for (HierarchicalRemoveRequest request : entry.getValue()) {
                hashMap.put(request.getComponent().getItemId(), request.getComponent());
            }
            if (hashMap.isEmpty()) continue;
            IWorkspaceConnection workspace = entry.getKey();
            List componentsInWorkspace = workspace.getComponents();
            Set componentIdsInWorkspace = componentsInWorkspace.stream().map(IItemHandle::getItemId).collect(Collectors.toSet());
            IComponentHierarchyResult result = workspace.getComponentHierarchy(null);
            Map subcomponentStructure = result.getParentToChildrenMap();
            for (IComponentHandle handle : hashMap.values()) {
                Collection subcomponents = (Collection)subcomponentStructure.get(handle.getItemId());
                if (subcomponents == null || subcomponents.isEmpty()) continue;
                configurationsNoBackup.add(new ConfigurationFacade((IConnection)workspace, handle));
            }
            Collection toRemove = SubcomponentCommonUtils.determineUniqueHierarchy(hashMap.keySet(), (Map)subcomponentStructure);
            IItemManager itemManager = workspace.teamRepository().itemManager();
            ArrayList<IComponentHandle> toFetch = new ArrayList<IComponentHandle>();
            for (UUID id : toRemove) {
                if (!componentIdsInWorkspace.contains(id)) continue;
                toFetch.add((IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(id, null));
            }
            IFetchResult fetchResult = itemManager.fetchCompleteItemsPermissionAware(toFetch, 0, (IProgressMonitor)progress.newChild(1));
            ArrayList componentsToRemove = NewCollection.arrayList();
            for (Object retrievedItem : fetchResult.getRetrievedItems()) {
                if (!(retrievedItem instanceof IComponent)) continue;
                IComponent component = (IComponent)retrievedItem;
                componentsToRemove.add(component);
            }
            for (IComponentHandle componentHandle : componentsToRemove) {
                List<WorkspaceUpdateRequest> existingRequests = this.acceptRequests.get(workspace);
                WorkspaceUpdateRequest existingRequest = null;
                if (existingRequests == null) {
                    existingRequests = new ArrayList<WorkspaceUpdateRequest>();
                    this.acceptRequests.put(workspace, existingRequests);
                }
                for (WorkspaceUpdateRequest request2 : existingRequests) {
                    if (request2.isChangeSetContext()) continue;
                    existingRequest = request2;
                    break;
                }
                if (existingRequest != null) {
                    existingRequest.removeComponent(componentHandle);
                    continue;
                }
                WorkspaceUpdateRequest request = new WorkspaceUpdateRequest(workspace, componentHandle);
                existingRequests.add(request);
            }
        }
        progress.done();
    }

    private void performHierarchialReplace(final Set<ConfigurationFacade> configurationsNoBackup, final IWorkspaceConnection workspace, Collection<IBaselineConnection> sourceBaselines, Map<UUID, Map<UUID, IComponentHandle>> sourceComponents, Map<UUID, IWorkspaceConnection> sourceWorkspaces, Map<UUID, IWorkspaceHandle> operationSources, final int requestType, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)((!sourceBaselines.isEmpty() ? 100 * sourceBaselines.size() : 100 * sourceWorkspaces.size()) + 10));
        IComponentHierarchyResult hierarchy = workspace.getComponentHierarchy(null);
        final Map subcomponentStructure = hierarchy.getParentToChildrenMap();
        HashMap<UUID, IComponentHandle> allSelectedComponents = new HashMap<UUID, IComponentHandle>();
        final HashMap localStructure = new HashMap();
        final HashMap<UUID, IComponentHandle> allSubcomponents = new HashMap<UUID, IComponentHandle>();
        ArrayList<IBaselineConnection> allConnections = new ArrayList<IBaselineConnection>();
        final HashMap<UUID, IComponentHandle> allComponents = new HashMap<UUID, IComponentHandle>();
        if (!sourceBaselines.isEmpty()) {
            for (IBaselineConnection iBaselineConnection : sourceBaselines) {
                IComponentHandle componentHandle = iBaselineConnection.getComponent();
                allSelectedComponents.put(componentHandle.getItemId(), componentHandle);
                IBaselineHierarchyResult baselineHierarchy = iBaselineConnection.getBaselineHierarchy((IProgressMonitor)progress.newChild(20));
                Map map = baselineHierarchy.getParentToChildrenMap();
                Map flattenedBaselines = baselineHierarchy.getFlattenedElementsMap();
                ArrayList baselineHandles = new ArrayList(flattenedBaselines.values());
                IFetchResult result = iBaselineConnection.teamRepository().itemManager().fetchCompleteItemsPermissionAware((List)baselineHandles, 0, (IProgressMonitor)progress.newChild(30));
                if (result.hasMissingItems()) {
                    throw new TeamRepositoryException(Messages.InaccessibleBaselinesInHierarchy);
                }
                List baselines = result.getRetrievedItems();
                HashMap<UUID, IBaseline> baselineMap = new HashMap<UUID, IBaseline>();
                for (IBaseline baseline : baselines) {
                    baselineMap.put(baseline.getItemId(), baseline);
                }
                allConnections.add(iBaselineConnection);
                IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)iBaselineConnection.teamRepository());
                SubMonitor loopPropress = progress.newChild(50).setWorkRemaining(map.size());
                for (Map.Entry entry : map.entrySet()) {
                    IBaseline iBaseline = (IBaseline)baselineMap.get(entry.getKey());
                    if (iBaseline == null) continue;
                    ArrayList<IComponentHandle> components = new ArrayList<IComponentHandle>();
                    SubMonitor innerLoopPropress = loopPropress.newChild(1).setWorkRemaining(((Collection)entry.getValue()).size());
                    for (IBaselineHandle handle : (Collection)entry.getValue()) {
                        IBaselineConnection baselineConnection = workspaceManager.getBaselineConnection(handle, (IProgressMonitor)innerLoopPropress.newChild(1));
                        allConnections.add(baselineConnection);
                        IBaseline localBaseline = (IBaseline)baselineMap.get(handle.getItemId());
                        if (localBaseline == null) continue;
                        IComponentHandle component = localBaseline.getComponent();
                        components.add(component);
                        allSubcomponents.put(component.getItemId(), component);
                    }
                    localStructure.put(iBaseline.getComponent().getItemId(), components);
                }
                allSubcomponents.remove(componentHandle.getItemId());
                Collection subcomponents = (Collection)subcomponentStructure.get(componentHandle.getItemId());
                if (subcomponents == null || subcomponents.isEmpty()) continue;
                configurationsNoBackup.add(new ConfigurationFacade((IConnection)workspace, componentHandle));
            }
        } else {
            for (Map.Entry entry : sourceWorkspaces.entrySet()) {
                Map<UUID, IComponentHandle> components = sourceComponents.get(entry.getKey());
                IWorkspaceConnection seedWorkspaceConnection = (IWorkspaceConnection)entry.getValue();
                allSelectedComponents.putAll(components);
                if (requestType == 1) {
                    allComponents.putAll(components);
                }
                final HashSet<UUID> hashSet = new HashSet<UUID>();
                for (IComponentHandle workspaceComponent : seedWorkspaceConnection.getComponents()) {
                    hashSet.add(workspaceComponent.getItemId());
                }
                final HashSet<UUID> componentsInWorkspace = new HashSet<UUID>();
                for (IComponentHandle workspaceComponent : workspace.getComponents()) {
                    componentsInWorkspace.add(workspaceComponent.getItemId());
                }
                for (IComponentHandle componentHandle : components.values()) {
                    Collection subcomponents = (Collection)subcomponentStructure.get(componentHandle.getItemId());
                    if (subcomponents == null || subcomponents.isEmpty()) continue;
                    configurationsNoBackup.add(new ConfigurationFacade((IConnection)workspace, componentHandle));
                }
                IComponentHierarchyResult incomingHierarchy = seedWorkspaceConnection.getComponentHierarchy(components.values());
                final ArrayList componentsNotInSeedWorkspace = new ArrayList();
                SubcomponentCommonUtils.visitHierarchy((IHierarchyResult)incomingHierarchy, (SubcomponentCommonUtils.IHierarchyVisitor)new SubcomponentCommonUtils.IHierarchyVisitor(){

                    public boolean visit(IHierarchyNode node) {
                        Collection subcomponents;
                        IComponentHandle componentHandle = node.getComponentHandle();
                        UUID id = componentHandle.getItemId();
                        if (requestType == 0 && componentsInWorkspace.contains(id)) {
                            return false;
                        }
                        ArrayList<IComponentHandle> collection = (ArrayList<IComponentHandle>)localStructure.get(id);
                        if (collection == null) {
                            collection = new ArrayList<IComponentHandle>();
                            localStructure.put(id, collection);
                        }
                        Collection children = node.getChildren();
                        for (IComponentHierarchyNode hierarchyNode : children) {
                            collection.add(hierarchyNode.getComponentHandle());
                        }
                        allSubcomponents.put(id, componentHandle);
                        if (componentsInWorkspace.contains(componentHandle.getItemId()) && (subcomponents = (Collection)subcomponentStructure.get(componentHandle.getItemId())) != null && !subcomponents.isEmpty()) {
                            configurationsNoBackup.add(new ConfigurationFacade((IConnection)workspace, componentHandle));
                        }
                        if (hashSet.contains(id)) {
                            allComponents.put(id, componentHandle);
                        } else {
                            componentsNotInSeedWorkspace.add(componentHandle);
                        }
                        return true;
                    }
                });
                SubMonitor conditionalBlockProgress = progress.newChild(100).setWorkRemaining(100);
                if (!componentsNotInSeedWorkspace.isEmpty()) {
                    int instructions;
                    IFetchResult result = seedWorkspaceConnection.teamRepository().itemManager().fetchCompleteItemsPermissionAware(componentsNotInSeedWorkspace, 1, (IProgressMonitor)conditionalBlockProgress.newChild(50));
                    HashSet<ConfigurationFacade> inaccessibleSubcomponentsNotInSeedWorkspace = new HashSet<ConfigurationFacade>();
                    if (result.hasMissingItems()) {
                        HashSet<UUID> unreadableComponents = new HashSet<UUID>();
                        for (IComponentHandle handle : seedWorkspaceConnection.getUnreadableComponents()) {
                            unreadableComponents.add(handle.getItemId());
                        }
                        for (Map.Entry o : result.getMissingItems()) {
                            if (!(o instanceof IComponentHandle)) continue;
                            IComponentHandle componentHandle = (IComponentHandle)o;
                            if (!unreadableComponents.contains(componentHandle.getItemId())) {
                                inaccessibleSubcomponentsNotInSeedWorkspace.add(new ConfigurationFacade((IConnection)seedWorkspaceConnection, componentHandle));
                                continue;
                            }
                            String uuid = componentHandle.getItemId().getUuidValue();
                            if (seedWorkspaceConnection.isStream()) {
                                throw new TeamRepositoryException(NLS.bind((String)Messages.InaccessibleSubcomponentInStream, (Object)uuid, (Object[])new Object[0]));
                            }
                            throw new TeamRepositoryException(NLS.bind((String)Messages.InaccessibleSubcomponentInWorkspace, (Object)uuid, (Object[])new Object[0]));
                        }
                    }
                    conditionalBlockProgress.setWorkRemaining(50);
                    if (!inaccessibleSubcomponentsNotInSeedWorkspace.isEmpty() && (instructions = this.problemHandler.inaccessibleComponentsNotInSeedWorkspace(inaccessibleSubcomponentsNotInSeedWorkspace, (IProgressMonitor)conditionalBlockProgress.newChild(50))) != 0) {
                        if (instructions == 1) {
                            throw new OperationCanceledException();
                        }
                        if (seedWorkspaceConnection.isStream()) {
                            this.handleProblem(new FileSystemException(Messages.InaccessibleSubcomponentsNotInStream));
                        } else {
                            this.handleProblem(new FileSystemException(Messages.InaccessibleSubcomponentsNotInWorkspace));
                        }
                    }
                }
                conditionalBlockProgress.done();
                for (UUID key : allSelectedComponents.keySet()) {
                    allSubcomponents.remove(key);
                }
            }
        }
        progress.setWorkRemaining(10);
        Collection collection = SubcomponentCommonUtils.inMultipleHierarchies(allSelectedComponents, (Map)subcomponentStructure, localStructure);
        Collection subComponentsInMultiHierarchies = SubcomponentCommonUtils.inMultipleHierarchies(allSubcomponents, (Map)subcomponentStructure, localStructure);
        boolean flatReplace = false;
        if (!collection.isEmpty() || !subComponentsInMultiHierarchies.isEmpty()) {
            int instructions = this.problemHandler.componentInMultipleHierarchies(workspace, collection, subComponentsInMultiHierarchies, (IProgressMonitor)progress.newChild(10));
            if (instructions != 0) {
                if (instructions == 1) {
                    throw new OperationCanceledException();
                }
                if (instructions == 3) {
                    flatReplace = true;
                } else {
                    this.handleProblem(new FileSystemException(Messages.WorkspaceUpdateOperation_11));
                }
            }
        } else {
            progress.done();
        }
        if (!sourceBaselines.isEmpty()) {
            Collection<IBaselineConnection> baselines = flatReplace ? sourceBaselines : allConnections;
            for (IBaselineConnection iBaselineConnection : baselines) {
                this.replace(workspace, iBaselineConnection, operationSources.get(iBaselineConnection.getBaseline().getItemId()));
            }
        } else {
            ArrayList fullComponentList = new ArrayList(allComponents.values());
            for (Map.Entry entry : sourceWorkspaces.entrySet()) {
                ArrayList<Object> components = fullComponentList;
                if (flatReplace) {
                    components = new ArrayList<IComponentHandle>(sourceComponents.get(entry.getKey()).values());
                }
                this.replace(workspace, (IWorkspaceConnection)entry.getValue(), components);
            }
        }
    }

    private void disconnectedComponents(Set<ConfigurationFacade> configurationsAffected, IProgressMonitor progress) throws TeamRepositoryException, FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        HashSet<ConfigurationFacade> configurations = new HashSet<ConfigurationFacade>(configurationsAffected);
        Map<ISandbox, Set<ConfigurationFacade>> areasAffected = this.getCopyFileAreasAffected(configurationsAffected, (IProgressMonitor)monitor.newChild(10));
        for (Set<ConfigurationFacade> configurationsLoaded : areasAffected.values()) {
            configurations.removeAll(configurationsLoaded);
        }
        if (!configurations.isEmpty()) {
            int reaction = this.problemHandler.disconnectedComponents(configurations);
            if (reaction == 1) {
                throw new OperationCanceledException();
            }
            if (reaction != 0) {
                throw new FileSystemException(Messages.WorkspaceUpdateOperation_2);
            }
        }
    }

    private void validateRequests(IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(10 * this.acceptRequests.size()));
        for (List<WorkspaceUpdateRequest> requests : this.acceptRequests.values()) {
            SubMonitor iterProgress = monitor.newChild(10).setWorkRemaining(requests.size() * 10);
            HashSet<ITeamRepository> repositoriesAffected = new HashSet<ITeamRepository>();
            HashSet<UUID> componentsAffected = new HashSet<UUID>();
            for (WorkspaceUpdateRequest request : requests) {
                ITeamRepository sourceRepository = request.getSourceRepository();
                repositoriesAffected.add(sourceRepository);
                HashSet<UUID> componentIds = new HashSet<UUID>();
                Collection<ConfigurationFacade> configurations = request.getAffectedConfigurations((IProgressMonitor)iterProgress.newChild(1));
                for (ConfigurationFacade configuration : configurations) {
                    componentIds.add(configuration.getComponentHandle().getItemId());
                }
                Collection<IFlowNodeConnection.IComponentOp> componentOps = request.getComponentOperations((IProgressMonitor)iterProgress.newChild(1));
                for (IFlowNodeConnection.IComponentOp op : componentOps) {
                    componentIds.add(op.getComponent().getItemId());
                    if (repositoriesAffected.size() <= 1) continue;
                    throw new FileSystemException(Messages.WorkspaceUpdateOperation_8);
                }
                for (UUID id : componentIds) {
                    if (componentsAffected.add(id) || request.isChangeSetContext()) continue;
                    IComponent component = (IComponent)request.getWorkspace().teamRepository().itemManager().fetchCompleteItem(IComponent.ITEM_TYPE.createItemHandle(id, null), 0, (IProgressMonitor)iterProgress.newChild(1));
                    throw new FileSystemException(NLS.bind((String)Messages.WorkspaceUpdateOperation_4, (Object)component.getName(), (Object[])new Object[]{request.getWorkspace().getResolvedWorkspace().getName()}));
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void performAcceptRequest(WorkspaceUpdateRequest acceptRequest, Map<IWorkspaceConnection, List<IUpdateReport>> updateReports, List<IChangeSetHandle> resumedChangeSetsList, IProgressMonitor progress) throws TeamRepositoryException {
        block38: {
            paranoiaCheck = 10;
            clearSuspendedChangeSetsAlreadyInHistoryFlag = 3;
            monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(10 + 16 * paranoiaCheck));
            changeSetsToAccept = new ArrayList<IChangeSetHandle>(acceptRequest.getChangeSets((IProgressMonitor)monitor.newChild(1)));
            baselinesToAccept = new ArrayList<IBaselineHandle>(acceptRequest.getBaselines((IProgressMonitor)monitor.newChild(1)));
            if (changeSetsToAccept.isEmpty() && baselinesToAccept.isEmpty()) break block38;
            retryAccept = true;
            staleDataRetries = 0;
            flagsForAccept = this.acceptFlags;
            workspaceConnection = acceptRequest.getWorkspace();
            suspendedChangeSets = workspaceConnection.suspendedChangeSets();
            suspendedMap = this.itemHandleListToMap(suspendedChangeSets);
            while (retryAccept && !this.problemsEncountered && paranoiaCheck-- > 0) {
                block39: {
                    block36: {
                        block37: {
                            this.checkCancelled((IProgressMonitor)monitor);
                            retryAccept = false;
                            action = AcceptAction.UNSPECIFIED;
                            try {
                                if (acceptRequest.isChangeSetContext() && baselinesToAccept.isEmpty()) {
                                    while (!changeSetsToAccept.isEmpty()) {
                                        action = this.getAcceptAction((IChangeSetHandle)changeSetsToAccept.get(0), suspendedMap);
                                        batch = this.batchAcceptOrResume(changeSetsToAccept, suspendedMap, action);
                                        updateReport = null;
                                        if (action == AcceptAction.ACCEPT_CHANGE_SETS) {
                                            updateReport = workspaceConnection.accept(flagsForAccept, batch, acceptRequest.getSourceRepository(), (IProgressMonitor)monitor.newChild(8));
                                        } else if (action == AcceptAction.RESUME) {
                                            if (clearSuspendedChangeSetsAlreadyInHistoryFlag == 0) {
                                                flagsForAccept |= 128;
                                            }
                                            updateReport = workspaceConnection.resume(flagsForAccept, batch, (IProgressMonitor)monitor.newChild(8));
                                            this.resumedChangeSets = true;
                                            resumedChangeSetsList.addAll(batch);
                                        }
                                        this.changes.recordChangeSets(workspaceConnection, batch, (IProgressMonitor)monitor.newChild(1));
                                        this.holdUpdateReport(workspaceConnection, updateReport, updateReports);
                                        for (IChangeSetHandle changeSetHandle : batch) {
                                            changeSetsToAccept.remove(changeSetHandle);
                                        }
                                    }
                                    continue;
                                }
                                if (changeSetsToAccept.isEmpty() && baselinesToAccept.isEmpty()) continue;
                                action = AcceptAction.ACCEPT_COMBINED;
                                updateReport = workspaceConnection.accept(flagsForAccept, acceptRequest.getSourceWorkspace(), acceptRequest.getSyncReport((IProgressMonitor)monitor.newChild(1)), baselinesToAccept, changeSetsToAccept, (IProgressMonitor)monitor.newChild(7));
                                this.changes.recordChangeSets(workspaceConnection, changeSetsToAccept, (IProgressMonitor)monitor.newChild(1));
                                this.changes.recordBaselines(workspaceConnection, baselinesToAccept, (IProgressMonitor)monitor.newChild(1));
                                this.holdUpdateReport(workspaceConnection, updateReport, updateReports);
                                changeSetsToAccept.clear();
                                baselinesToAccept.clear();
                                continue;
                            }
                            catch (ActiveChangeSetsOverlapException e) {
                                retryAccept = this.handleActiveChangeSetsOverlap(acceptRequest, changeSetsToAccept, e, (IProgressMonitor)monitor.newChild(3));
                                continue;
                            }
                            catch (PatchInProgressException e) {
                                if ((flagsForAccept & 2) == 0) {
                                    instructions = this.problemHandler.portInProgress(workspaceConnection, changeSetsToAccept);
                                    switch (instructions) {
                                        case 1: {
                                            throw new OperationCanceledException();
                                        }
                                        case 0: {
                                            retryAccept = true;
                                            break;
                                        }
                                        default: {
                                            this.handleProblem((TeamRepositoryException)e);
                                            break;
                                        }
                                    }
                                } else {
                                    retryAccept = false;
                                }
                                if (retryAccept) {
                                    flagsForAccept |= 2;
                                    flagsForAccept |= 8;
                                }
                                if ((flagsForAccept & 2) == 0 || retryAccept) continue;
                                this.handleProblem((TeamRepositoryException)e);
                                continue;
                            }
                            catch (GapException e) {
                                if ((flagsForAccept & 2) != 0) break block36;
                                changeSetsWithGapUuidMap = this.itemHandleListToMap(changeSetsToAccept);
                                gapFillingComponentMap = this.getGapFillingChangeSets(workspaceConnection, changeSetsToAccept, (IProgressMonitor)monitor.newChild(1));
                                gapFillingUuidMap = this.collapseMapOfLists(gapFillingComponentMap);
                                instructions = 2;
                                handlingSuspended = action == AcceptAction.RESUME;
                                setsAreSame = changeSetsWithGapUuidMap.keySet().equals(gapFillingUuidMap.keySet());
                                instructions = setsAreSame != false ? 3 : (gapFillingUuidMap.isEmpty() != false ? this.problemHandler.gap(workspaceConnection, changeSetsToAccept, handlingSuspended) : this.problemHandler.gap(workspaceConnection, changeSetsToAccept, gapFillingComponentMap, handlingSuspended));
                                gapFillingUuidMap.putAll(changeSetsWithGapUuidMap);
                                if (instructions != 0) break block37;
                                retryAccept = true;
                                flagsForAccept |= 2;
                                flagsForAccept |= 8;
                                iterator = gapFillingUuidMap.entrySet().iterator();
                                ** while (iterator.hasNext())
                            }
lbl-1000:
                            // 1 sources

                            {
                                entry = iterator.next();
                                if (changeSetsWithGapUuidMap.containsKey(entry.getKey())) continue;
                                iterator.remove();
                                continue;
                            }
lbl93:
                            // 1 sources

                            changeSetsToAccept.clear();
                            changeSetsToAccept.addAll(gapFillingUuidMap.values());
                            break block39;
                        }
                        if (instructions == 3) {
                            changeSetsWithGapUuidList = new ArrayList<UUID>(changeSetsWithGapUuidMap.keySet());
                            v0 = retryAccept = changeSetsWithGapUuidList.equals(gapFillingUuidList = new ArrayList<UUID>(gapFillingUuidMap.keySet())) == false;
                            if (retryAccept) {
                                flagsForAccept |= 16;
                                changeSetsToAccept.clear();
                                changeSetsToAccept.addAll(gapFillingUuidMap.values());
                            } else {
                                this.handleProblem((TeamRepositoryException)e);
                            }
                        } else {
                            if (instructions == 1) {
                                throw new OperationCanceledException();
                            }
                            this.handleProblem((TeamRepositoryException)e);
                        }
                        break block39;
                    }
                    retryAccept = false;
                }
                if ((flagsForAccept & 2) == 0 || retryAccept) continue;
                this.handleProblem((TeamRepositoryException)e);
                continue;
                catch (HistoryReorderingCausesNWayConflictException e) {
                    if (action == AcceptAction.ACCEPT_COMBINED && !baselinesToAccept.isEmpty() && (flagsForAccept & 32) == 0) {
                        data = e.getData();
                        ch = null;
                        if (data instanceof IComponentHandle) {
                            ch = (IComponentHandle)data;
                        }
                        if (!(retryAccept = this.handleNWayConflict(workspaceConnection, changeSetsToAccept, baselinesToAccept, ch, e, monitor))) continue;
                        flagsForAccept |= 32;
                        continue;
                    }
                    throw e;
                }
                catch (ChangeSetAlreadyInHistoryException e) {
                    if (action == AcceptAction.RESUME) {
                        clearSuspendedChangeSetsAlreadyInHistoryFlag = this.problemHandler.changeSetAlreadyInHistoryDilemmaHandler();
                    }
                    if (retryAccept = this.handleChangeSetAlreadyInHistory(acceptRequest, changeSetsToAccept, (TeamRepositoryException)e, clearSuspendedChangeSetsAlreadyInHistoryFlag, (IProgressMonitor)monitor.newChild(3))) continue;
                    this.handleProblem((TeamRepositoryException)e);
                    continue;
                }
                catch (ActiveChangeSetsException e) {
                    retryAccept = this.handleActiveChangeSets(acceptRequest, changeSetsToAccept, (TeamRepositoryException)e, (IProgressMonitor)monitor.newChild(3));
                    continue;
                }
                catch (AcceptSuspendedChangeSetException e) {
                    this.handleProblem((TeamRepositoryException)e);
                    continue;
                }
                catch (StaleDataException e) {
                    retryAccept = this.handleStaleData(acceptRequest, staleDataRetries, e, (IProgressMonitor)monitor.newChild(3));
                    ++staleDataRetries;
                    continue;
                }
                catch (TeamRepositoryException e) {
                    retryAccept = this.handleChangeSetAlreadyInHistory(acceptRequest, changeSetsToAccept, e, 3, (IProgressMonitor)monitor.newChild(1));
                    if (!retryAccept) {
                        retryAccept = this.handleActiveChangeSets(acceptRequest, changeSetsToAccept, e, (IProgressMonitor)monitor.newChild(1));
                    }
                    if (retryAccept) continue;
                    this.handleProblem(e);
                }
            }
            if (!this.problemsEncountered && (flagsForAccept & 2) != 0) {
                this.handleCurrentPatches(workspaceConnection, this.getComponentsWithCurrentPatch(workspaceConnection, updateReports, true), (IProgressMonitor)monitor.newChild(1));
            }
        }
    }

    private boolean handleNWayConflict(IWorkspaceConnection workspaceConnection, List<IChangeSetHandle> changeSetsToAccept, List<IBaselineHandle> baselinesToAccept, IComponentHandle ch, HistoryReorderingCausesNWayConflictException exception, SubMonitor monitor) throws TeamRepositoryException {
        int direction;
        List<IBaseline> affectedBaselines;
        IComponent component = null;
        if (ch != null) {
            component = (IComponent)workspaceConnection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)ch, 0, (IProgressMonitor)monitor.newChild(10));
        }
        if ((affectedBaselines = this.getAffectedBaselines(workspaceConnection, ch, baselinesToAccept, monitor.newChild(1))).isEmpty()) {
            throw exception;
        }
        if (component == null) {
            ch = affectedBaselines.get(0).getComponent();
            component = (IComponent)workspaceConnection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)ch, 0, (IProgressMonitor)monitor.newChild(10));
        }
        if ((direction = this.problemHandler.nWayConflict(workspaceConnection, component, affectedBaselines, (IProgressMonitor)monitor.newChild(1))) == 0) {
            return true;
        }
        if (direction != 3) {
            if (direction == 1) {
                throw new OperationCanceledException();
            }
            this.handleProblem((TeamRepositoryException)((Object)exception));
        }
        return false;
    }

    private List<IBaseline> getAffectedBaselines(IWorkspaceConnection workspaceConnection, IComponentHandle ch, List<IBaselineHandle> baselinesToAccept, SubMonitor subMonitor) throws TeamRepositoryException {
        List baselines = workspaceConnection.teamRepository().itemManager().fetchCompleteItems(baselinesToAccept, 0, (IProgressMonitor)subMonitor);
        if (ch == null) {
            return baselines;
        }
        ArrayList<IBaseline> result = new ArrayList<IBaseline>();
        for (IBaseline bl : baselines) {
            if (bl == null || !bl.getComponent().sameItemId((IItemHandle)ch)) continue;
            result.add(bl);
        }
        return result;
    }

    private List<IChangeSetHandle> batchAcceptOrResume(List<IChangeSetHandle> changeSetsToAccept, Map<UUID, IChangeSetHandle> suspendedMap, AcceptAction action) {
        ArrayList<IChangeSetHandle> batch = new ArrayList<IChangeSetHandle>();
        int i = 0;
        while (i < changeSetsToAccept.size()) {
            IChangeSetHandle changeSetHandle = changeSetsToAccept.get(i);
            AcceptAction nextAction = this.getAcceptAction(changeSetHandle, suspendedMap);
            if (nextAction != action) break;
            batch.add(changeSetHandle);
            ++i;
        }
        return batch;
    }

    private AcceptAction getAcceptAction(IChangeSetHandle changeSetHandle, Map<UUID, IChangeSetHandle> suspendedMap) {
        AcceptAction result = suspendedMap.containsKey(changeSetHandle.getItemId()) ? AcceptAction.RESUME : AcceptAction.ACCEPT_CHANGE_SETS;
        return result;
    }

    private List<IComponentHandle> getComponentsWithCurrentPatch(IWorkspaceConnection workspace, Map<IWorkspaceConnection, List<IUpdateReport>> updateReports, boolean includeAcceptQueueChanges) {
        ArrayList<IComponentHandle> componentsWithCurrentPatch = new ArrayList<IComponentHandle>();
        List<IUpdateReport> updateReportList = updateReports.get(workspace);
        if (updateReportList != null) {
            for (IUpdateReport ur : updateReportList) {
                for (IComponentHandle ch : ur.getModifiedComponents()) {
                    if (!this.mayHaveCurrentPatchChange(ur, ch) && (!includeAcceptQueueChanges || !this.mayHaveAcceptQueueChange(ur, ch)) || workspace.getCurrentPatch(ch) == null) continue;
                    componentsWithCurrentPatch.add(ch);
                }
            }
        }
        return componentsWithCurrentPatch;
    }

    private boolean mayHaveCurrentPatchChange(IUpdateReport updateReport, IComponentHandle componentHandle) {
        IComponentStateSummary componentSummaryBefore = updateReport.getComponentSummaryBefore(componentHandle);
        IComponentStateSummary componentSummaryAfter = updateReport.getComponentSummaryAfter(componentHandle);
        if (componentSummaryBefore == null) {
            return true;
        }
        if (componentSummaryAfter == null) {
            return false;
        }
        return ((SyncTime)componentSummaryBefore.getCurrentPortTime()).getValue() != ((SyncTime)componentSummaryAfter.getCurrentPortTime()).getValue();
    }

    private boolean mayHaveAcceptQueueChange(IUpdateReport updateReport, IComponentHandle componentHandle) {
        IComponentStateSummary componentSummaryBefore = updateReport.getComponentSummaryBefore(componentHandle);
        IComponentStateSummary componentSummaryAfter = updateReport.getComponentSummaryAfter(componentHandle);
        if (componentSummaryBefore == null) {
            return true;
        }
        if (componentSummaryAfter == null) {
            return false;
        }
        return ((SyncTime)componentSummaryBefore.getPendingPortsListTime()).getValue() != ((SyncTime)componentSummaryAfter.getPendingPortsListTime()).getValue();
    }

    private void performAutoResolveCurrentPatchContentChanges(IWorkspaceConnection workspace, List<IComponentHandle> components, IProgressMonitor progress) {
        for (IComponentHandle component : components) {
            UpdateCurrentPortOperation updateOperation = (UpdateCurrentPortOperation)IOperationFactory.instance.getUpdateCurrentPortOperation(this.problemHandler.getUpdateCurrentPortDilemmaHandler());
            updateOperation.setFileContentMerger(this.getFileContentMerger());
            updateOperation.setContext(workspace, component);
            if (updateOperation.autoResolveChanges(IContentChangeDetail.class, true)) {
                try {
                    updateOperation.run(progress);
                }
                catch (TeamRepositoryException e) {
                    this.handleProblem(e);
                }
            }
            this.performPostContentChangeEncodingChanges(workspace, component, progress);
        }
    }

    private void performPostContentChangeEncodingChanges(IWorkspaceConnection workspace, IComponentHandle component, IProgressMonitor progress) {
        UpdateCurrentPortOperation updateOperation = (UpdateCurrentPortOperation)IOperationFactory.instance.getUpdateCurrentPortOperation(UpdateCurrentPatchDilemmaHandler.getDefault());
        updateOperation.setFileContentMerger(this.getFileContentMerger());
        updateOperation.setContext(workspace, component);
        boolean hasMoreChanges = updateOperation.autoResolveChanges(IEncodingChangeDetail.class, true);
        if (hasMoreChanges |= updateOperation.autoResolveChanges(ILineDelimiterChangeDetail.class, true)) {
            try {
                updateOperation.run(progress);
            }
            catch (TeamRepositoryException e) {
                this.handleProblem(e);
            }
        }
    }

    private void handleCurrentPatches(IWorkspaceConnection workspace, List<IComponentHandle> components, IProgressMonitor progress) {
        this.problemHandler.currentPortsPresent(workspace, components, progress);
    }

    private boolean handleStaleData(WorkspaceUpdateRequest acceptRequest, int staleDataRetries, StaleDataException exception, IProgressMonitor progress) {
        boolean retry = false;
        if (staleDataRetries > 0) {
            this.handleProblem((TeamRepositoryException)((Object)exception));
        } else {
            int reaction = this.problemHandler.staleData(acceptRequest.getWorkspace(), acceptRequest.getSourceWorkspace());
            if (reaction == 1) {
                throw new OperationCanceledException();
            }
            if (reaction == 0) {
                try {
                    acceptRequest.recomputeSyncReport(progress);
                    retry = true;
                }
                catch (TeamRepositoryException e) {
                    this.collectStatus(FileSystemStatusUtil.getStatusFor(e));
                    this.handleProblem(e);
                }
            } else {
                this.handleProblem((TeamRepositoryException)((Object)exception));
            }
        }
        return retry;
    }

    private void handleProblem(TeamRepositoryException e) {
        this.collectStatus(FileSystemStatusUtil.getStatusFor(e));
        this.problemsEncountered = true;
    }

    private boolean handleChangeSetAlreadyInHistory(WorkspaceUpdateRequest acceptRequest, List<IChangeSetHandle> changeSets, TeamRepositoryException exception, int flag, IProgressMonitor progress) {
        boolean retry = false;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)2);
        try {
            List changeSetsAlreadyInHistory = acceptRequest.getWorkspace().changeSetsInHistory(changeSets, (IProgressMonitor)monitor.newChild(2));
            if (!changeSetsAlreadyInHistory.isEmpty()) {
                HashSet<UUID> redundant = new HashSet<UUID>();
                for (IChangeSetHandle cs : changeSetsAlreadyInHistory) {
                    redundant.add(cs.getItemId());
                }
                Iterator<IChangeSetHandle> iChangeSets = changeSets.iterator();
                while (iChangeSets.hasNext()) {
                    IChangeSetHandle cs = iChangeSets.next();
                    if (!redundant.contains(cs.getItemId())) continue;
                    if (flag != 0) {
                        iChangeSets.remove();
                    }
                    this.redundantChangeSets = true;
                    retry = true;
                }
            }
        }
        catch (TeamRepositoryException failure) {
            this.collectStatus(FileSystemStatusUtil.getStatusFor(exception));
            this.handleProblem(failure);
        }
        return retry;
    }

    private boolean handleActiveChangeSets(WorkspaceUpdateRequest acceptRequest, List<IChangeSetHandle> changeSetsToAccept, TeamRepositoryException exception, IProgressMonitor progress) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        boolean retry = false;
        HashSet<UUID> open = new HashSet<UUID>();
        ArrayList<IChangeSetHandle> activeChangeSets = new ArrayList<IChangeSetHandle>();
        try {
            if (acceptRequest.isChangeSetContext() || acceptRequest.getSourceWorkspace() == null) {
                List fullChangeSets = acceptRequest.getSourceRepository().itemManager().fetchCompleteItems(changeSetsToAccept, 0, (IProgressMonitor)monitor);
                for (IChangeSetHandle changeSet : fullChangeSets) {
                    if (changeSet == null || !changeSet.isActive()) continue;
                    open.add(changeSet.getItemId());
                }
            } else {
                List active = acceptRequest.getSourceWorkspace().activeChangeSets();
                for (IChangeSetHandle changeSet : active) {
                    open.add(changeSet.getItemId());
                }
            }
            if (!open.isEmpty()) {
                Iterator<IChangeSetHandle> iChangeSets = changeSetsToAccept.iterator();
                while (iChangeSets.hasNext()) {
                    IChangeSetHandle cs = iChangeSets.next();
                    if (!open.contains(cs.getItemId())) continue;
                    iChangeSets.remove();
                    activeChangeSets.add(cs);
                }
                if (!activeChangeSets.isEmpty()) {
                    int direction = this.problemHandler.activeChangeSets(acceptRequest.getWorkspace(), activeChangeSets);
                    if (direction == 0) {
                        retry = true;
                    } else if (direction != 3) {
                        if (direction == 1) {
                            throw new OperationCanceledException();
                        }
                        this.handleProblem(exception);
                    }
                }
            }
        }
        catch (TeamRepositoryException e) {
            this.collectStatus(FileSystemStatusUtil.getStatusFor(exception));
            this.handleProblem(e);
        }
        return retry;
    }

    private boolean handleActiveChangeSetsOverlap(WorkspaceUpdateRequest acceptRequest, List<IChangeSetHandle> toResume, ActiveChangeSetsOverlapException exception, IProgressMonitor progress) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        boolean retry = false;
        try {
            List fullChangeSets = acceptRequest.getWorkspace().teamRepository().itemManager().fetchCompleteItems(toResume, 0, (IProgressMonitor)monitor.newChild(50));
            ArrayList<IChangeSet> activeChangeSets = new ArrayList<IChangeSet>();
            for (IChangeSet changeSet : fullChangeSets) {
                if (!changeSet.isActive()) continue;
                activeChangeSets.add(changeSet);
            }
            int instructions = this.problemHandler.activeChangeSetsOverlap(acceptRequest.getWorkspace(), activeChangeSets);
            if (instructions == 0) {
                acceptRequest.getWorkspace().closeChangeSets(activeChangeSets, (IProgressMonitor)monitor.newChild(50));
                retry = true;
            } else if (instructions != 3) {
                if (instructions == 1) {
                    throw new OperationCanceledException();
                }
                this.handleProblem((TeamRepositoryException)((Object)exception));
            }
        }
        catch (TeamRepositoryException e) {
            this.collectStatus(FileSystemStatusUtil.getStatusFor(exception));
            this.handleProblem(e);
        }
        return retry;
    }

    private LinkedHashMap<UUID, IChangeSetHandle> collapseMapOfLists(Map<IComponentHandle, List<IChangeSetHandle>> map) {
        LinkedHashMap<UUID, IChangeSetHandle> collapsedList = new LinkedHashMap<UUID, IChangeSetHandle>();
        for (List<IChangeSetHandle> changeSets : map.values()) {
            for (IChangeSetHandle changeSethandle : changeSets) {
                collapsedList.put(changeSethandle.getItemId(), changeSethandle);
            }
        }
        return collapsedList;
    }

    private LinkedHashMap<UUID, IChangeSetHandle> itemHandleListToMap(List<IChangeSetHandle> changeSetsWithGapHandles) {
        LinkedHashMap<UUID, IChangeSetHandle> uuidMap = new LinkedHashMap<UUID, IChangeSetHandle>();
        for (IChangeSetHandle changeSetHandle : changeSetsWithGapHandles) {
            uuidMap.put(changeSetHandle.getItemId(), changeSetHandle);
        }
        return uuidMap;
    }

    private Map<IComponentHandle, List<IChangeSetHandle>> getGapFillingChangeSets(IWorkspaceConnection workspace, List<IChangeSetHandle> changeSetsWithGapHandles, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        HashMap<IComponentHandle, List<IChangeSetHandle>> gapFillingChangeSets = new HashMap<IComponentHandle, List<IChangeSetHandle>>();
        try {
            IGapFillingChangeSetsReportList reports = workspace.findChangeSetsToAcceptToFillGap(changeSetsWithGapHandles.toArray(new IChangeSetHandle[changeSetsWithGapHandles.size()]), (IProgressMonitor)subMonitor.newChild(1));
            for (IGapFillingChangeSetsReport report : reports.getReports()) {
                gapFillingChangeSets.put(report.getComponent(), report.getChangeSets());
            }
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
        return gapFillingChangeSets;
    }

    private void holdUpdateReport(IWorkspaceConnection workspace, IUpdateReport updateReport, Map<IWorkspaceConnection, List<IUpdateReport>> updateReports) {
        List<IUpdateReport> reports = updateReports.get(workspace);
        if (reports == null) {
            reports = new ArrayList<IUpdateReport>();
            updateReports.put(workspace, reports);
        }
        reports.add(updateReport);
    }

    private void verifyComponentFlowing(IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(10 + this.acceptRequests.size() * 10));
        HashMap<WorkspaceUpdateRequest, ArrayList<IComponentHandle>> componentsFlowedForRequest = new HashMap<WorkspaceUpdateRequest, ArrayList<IComponentHandle>>();
        ArrayList<ConfigurationFacade> added = new ArrayList<ConfigurationFacade>();
        ArrayList<ConfigurationFacade> removed = new ArrayList<ConfigurationFacade>();
        for (List<WorkspaceUpdateRequest> requests : this.acceptRequests.values()) {
            SubMonitor iterMonitor = monitor.newChild(10).setWorkRemaining(requests.size());
            for (WorkspaceUpdateRequest acceptRequest : requests) {
                if (acceptRequest.isChangeSetContext()) continue;
                Collection<IFlowNodeConnection.IComponentOp> componentOps = acceptRequest.getComponentOperations((IProgressMonitor)iterMonitor.newChild(1));
                for (IFlowNodeConnection.IComponentOp componentOp : componentOps) {
                    if (!(componentOp instanceof IFlowNodeConnection.IComponentAdditionOp) && !(componentOp instanceof IFlowNodeConnection.IComponentDeletionOp)) continue;
                    if (componentOp instanceof IFlowNodeConnection.IComponentAdditionOp) {
                        added.add(new ConfigurationFacade((IConnection)acceptRequest.getWorkspace(), componentOp.getComponent()));
                    } else {
                        removed.add(new ConfigurationFacade((IConnection)acceptRequest.getWorkspace(), componentOp.getComponent()));
                    }
                    ArrayList<IComponentHandle> flowsForRequest = (ArrayList<IComponentHandle>)componentsFlowedForRequest.get(acceptRequest);
                    if (flowsForRequest == null) {
                        flowsForRequest = new ArrayList<IComponentHandle>();
                        componentsFlowedForRequest.put(acceptRequest, flowsForRequest);
                    }
                    flowsForRequest.add(componentOp.getComponent());
                }
            }
        }
        if (added.size() > 0 || removed.size() > 0) {
            int result = this.getAcceptDilemmaHandler().componentsToBeAddedOrRemoved(added, removed);
            if (result == 1) {
                throw new OperationCanceledException();
            }
            if (result == 3) {
                SubMonitor iterProgress = monitor.newChild(10);
                iterProgress.setWorkRemaining(componentsFlowedForRequest.entrySet().size());
                for (Map.Entry entry : componentsFlowedForRequest.entrySet()) {
                    WorkspaceUpdateRequest acceptRequest = (WorkspaceUpdateRequest)entry.getKey();
                    acceptRequest.excludeComponentOps((List)entry.getValue(), (IProgressMonitor)iterProgress.newChild(1));
                }
            } else if (result != 0) {
                throw new FileSystemException(Messages.WorkspaceUpdateOperation_0);
            }
        }
    }

    protected final WorkspaceUpdateDilemmaHandler getAcceptDilemmaHandler() {
        return this.problemHandler;
    }

    @Override
    public boolean changeSetsAlreadyInHistory() {
        return this.redundantChangeSets;
    }

    @Override
    public boolean acceptedSuspendedChangeSets() {
        return this.resumedChangeSets;
    }

    private IRepositoryResolver getRepositoryResolver(Set<ConfigurationFacade> componentsRemoved) {
        final HashMap<UUID, ITeamRepository> repos = new HashMap<UUID, ITeamRepository>();
        for (ConfigurationFacade configuration : componentsRemoved) {
            ITeamRepository teamRepository = null;
            try {
                teamRepository = configuration.getTeamRepository();
            }
            catch (TeamRepositoryException teamRepositoryException) {
                // empty catch block
            }
            if (teamRepository == null) continue;
            repos.put(configuration.getRepositoryId(), teamRepository);
        }
        return new IRepositoryResolver(){

            @Override
            public ITeamRepository getRepoFor(String uri, UUID id) throws TeamRepositoryException {
                return (ITeamRepository)repos.get(id);
            }
        };
    }

    private IUnshareOperation getUnshareProjectsOperation(Set<ConfigurationFacade> componentsRemoved) {
        IUnshareOperation op = IOperationFactory.instance.getUnshareOperation(null, this.getRepositoryResolver(componentsRemoved));
        op.requestUnshare(componentsRemoved);
        op.setDeleteContent(true);
        return op;
    }

    @Override
    public IWorkspaceUpdateReport getUpdateReport() {
        if (this.changes == null) {
            throw new IllegalStateException();
        }
        return this.changes.getReport();
    }

    @Override
    public void setPopulateUpdateReport(boolean shouldPopulate) {
        if (this.changes != null) {
            throw new IllegalStateException();
        }
        this.populateUpdateReport = shouldPopulate;
    }

    @Override
    protected void refreshLocal(IFilesystemRefresher refresher, Map<ISandbox, Set<ConfigurationFacade>> affectedAreas, IProgressMonitor progress) throws FileSystemException, TeamRepositoryException {
        int totalReqs = 0;
        for (Map.Entry<IWorkspaceConnection, List<WorkspaceUpdateRequest>> wsConnPair : this.acceptRequests.entrySet()) {
            totalReqs += wsConnPair.getValue().size();
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)totalReqs);
        for (Map.Entry<IWorkspaceConnection, List<WorkspaceUpdateRequest>> wsConnPair : this.acceptRequests.entrySet()) {
            for (WorkspaceUpdateRequest req : wsConnPair.getValue()) {
                Collection<IFlowNodeConnection.IComponentOp> ops = req.getComponentOperations((IProgressMonitor)monitor.newChild(1));
                SubMonitor compMon = monitor.newChild(1);
                compMon.setWorkRemaining(ops.size() * 3);
                for (IFlowNodeConnection.IComponentOp op : ops) {
                    if (!(op instanceof IFlowNodeConnection.IComponentAdditionOp)) {
                        SubMonitor sbMon = compMon.newChild(1);
                        sbMon.setWorkRemaining(affectedAreas.size());
                        refresher.addToRefresh(affectedAreas.keySet(), wsConnPair.getKey().getContextHandle(), op.getComponent(), (IProgressMonitor)compMon.newChild(1));
                        continue;
                    }
                    compMon.worked(1);
                }
                compMon.setWorkRemaining(4);
                List<IBaselineHandle> baselines = req.getBaselines((IProgressMonitor)compMon.newChild(1));
                ArrayList<ConnectionFacade> baselineDescriptors = new ArrayList<ConnectionFacade>();
                for (IBaselineHandle baseline : baselines) {
                    ITeamRepository source = req.getSourceRepository();
                    ConnectionFacade baselineDescriptor = new ConnectionFacade(source, (IContextHandle)baseline);
                    baselineDescriptors.add(baselineDescriptor);
                }
                ChangeSetRefreshUtils.refreshForBaselineConnectionDescriptorChange(refresher, affectedAreas.keySet(), wsConnPair.getKey(), baselineDescriptors, (IProgressMonitor)compMon.newChild(1));
                List<IChangeSetHandle> cses = req.getChangeSets((IProgressMonitor)compMon.newChild(1));
                if (cses.isEmpty()) continue;
                ChangeSetRefreshUtils.refreshLocalForAddition(refresher, affectedAreas, req.getSourceRepository(), wsConnPair.getKey(), cses, (IProgressMonitor)compMon.newChild(1));
            }
        }
    }

    @Override
    public boolean isEclipseMetadataReadFailure() {
        return this.isEclipseMetadataReadFailure;
    }

    @Override
    public List<String> getEclipseMetadataReadFailureMessage() {
        return this.eclipseReadMessages;
    }

    @Override
    public EclipseReadException getSavedEclipseReadException() {
        return this.savedEclipseReadException;
    }

    public static Map<IComponentHandle, IChangeSetHandle> shouldMakeResumedCurrent(IWorkspaceConnection workspaceConnection, List<IChangeSetHandle> changeSetHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        HashMap<UUID, ArrayList<IChangeSet>> groupedByComponent = new HashMap<UUID, ArrayList<IChangeSet>>();
        HashMap<IComponentHandle, IChangeSetHandle> changeSetsToMakeCurrent = new HashMap<IComponentHandle, IChangeSetHandle>();
        List changeSets = workspaceConnection.teamRepository().itemManager().fetchCompleteItems(changeSetHandles, 0, monitor);
        for (IChangeSet changeSet : changeSets) {
            if (!changeSet.isActive()) continue;
            IComponentHandle component = changeSet.getComponent();
            ArrayList<IChangeSet> gCsets = (ArrayList<IChangeSet>)groupedByComponent.get(component.getItemId());
            if (gCsets == null) {
                gCsets = new ArrayList<IChangeSet>();
                groupedByComponent.put(component.getItemId(), gCsets);
            }
            gCsets.add(changeSet);
        }
        for (UUID componentUUID : groupedByComponent.keySet()) {
            IComponentHandle componentHandle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(componentUUID, null);
            IChangeSetHandle currentChangeSetHandle = workspaceConnection.getCurrentChangeSet(componentHandle);
            List changeSetsInComponent = (List)groupedByComponent.get(componentUUID);
            if (currentChangeSetHandle != null || changeSetsInComponent.size() != 1) continue;
            changeSetsToMakeCurrent.put(componentHandle, (IChangeSetHandle)changeSetsInComponent.get(0));
        }
        return changeSetsToMakeCurrent;
    }

    @Override
    public IFileContentMerger getFileContentMerger() {
        if (this.problemHandler != null && this.problemHandler.getFileContentMerger() != null) {
            return this.problemHandler.getFileContentMerger();
        }
        return super.getFileContentMerger();
    }

    @Override
    public void setAutoAcquireLocks(boolean value) {
        this.autoAcquireLocks = value;
    }

    @Override
    public void setReportDeleteDeleteConflicts(boolean value) {
        if (value) {
            this.acceptFlags |= 0x40;
        } else if ((this.acceptFlags & 0x40) != 0) {
            this.acceptFlags -= 64;
        }
    }

    private static enum AcceptAction {
        UNSPECIFIED,
        ACCEPT_CHANGE_SETS,
        ACCEPT_COMBINED,
        RESUME;

    }

    private static class HierarchicalRemoveRequest {
        private IWorkspaceConnection fWorkspaceConnection;
        private IComponentHandle fComponent;

        public HierarchicalRemoveRequest(IWorkspaceConnection workspaceConnection, IComponentHandle component) {
            this.fWorkspaceConnection = workspaceConnection;
            this.fComponent = component;
        }

        public IWorkspaceConnection getWorkspaceConnection() {
            return this.fWorkspaceConnection;
        }

        public IComponentHandle getComponent() {
            return this.fComponent;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.fComponent == null ? 0 : this.fComponent.hashCode());
            result = 31 * result + (this.fWorkspaceConnection == null ? 0 : this.fWorkspaceConnection.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HierarchicalRemoveRequest other = (HierarchicalRemoveRequest)obj;
            if (this.fComponent == null ? other.fComponent != null : !this.fComponent.sameItemId((IItemHandle)other.fComponent)) {
                return false;
            }
            return !(this.fWorkspaceConnection == null ? other.fWorkspaceConnection != null : !this.fWorkspaceConnection.equals((Object)other.fWorkspaceConnection));
        }
    }

    private static class HierarchicalRequest {
        private IBaselineConnection fBaselineConnection;
        private IWorkspaceConnection fWorkspaceConnection;
        private IWorkspaceHandle operationSource;
        private int seedType;
        private int type;
        private Map<UUID, IComponentHandle> components;
        public static final int BASELINE = 0;
        public static final int WORKSPACE = 1;
        public static final int ADDITION = 0;
        public static final int REPLACE = 1;

        public HierarchicalRequest(IBaselineConnection baselineConnection, IWorkspaceHandle operationSource) {
            if (baselineConnection == null) {
                throw new IllegalArgumentException("'baselineConnection' must not be null");
            }
            this.seedType = 0;
            this.operationSource = operationSource;
            this.fBaselineConnection = baselineConnection;
        }

        public HierarchicalRequest(IWorkspaceConnection sourceWorkspace, List<? extends IComponentHandle> components, boolean add) {
            if (sourceWorkspace == null) {
                throw new IllegalArgumentException("'connection' must not be null");
            }
            this.seedType = 1;
            this.type = add ? 0 : 1;
            this.fWorkspaceConnection = sourceWorkspace;
            this.components = new HashMap<UUID, IComponentHandle>();
            for (IComponentHandle iComponentHandle : components) {
                this.components.put(iComponentHandle.getItemId(), iComponentHandle);
            }
        }

        public int getSeedType() {
            return this.seedType;
        }

        public int getType() {
            return this.type;
        }

        public IBaselineConnection getBaselineConnection() {
            return this.fBaselineConnection;
        }

        public IWorkspaceHandle getOperationSource() {
            return this.operationSource;
        }

        public IWorkspaceConnection getWorkspaceConnection() {
            return this.fWorkspaceConnection;
        }

        public Map<UUID, IComponentHandle> getComponents() {
            return this.components;
        }

        public void addComponents(List<? extends IComponentHandle> components2) {
            for (IComponentHandle iComponentHandle : components2) {
                this.components.put(iComponentHandle.getItemId(), iComponentHandle);
            }
        }
    }
}

