/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.internal.operations.WorkspaceUpdateOperation;
import com.ibm.team.filesystem.client.operations.IWorkspaceRollbackOperation;
import com.ibm.team.filesystem.client.operations.WorkspaceUpdateDilemmaHandler;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.WorkspaceManager;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IComponentReference;
import com.ibm.team.scm.common.IHistoryReference;
import com.ibm.team.scm.common.dto.IHistoryReferenceDescription;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class WorkspaceRollbackOperation
extends WorkspaceUpdateOperation
implements IWorkspaceRollbackOperation {
    public WorkspaceRollbackOperation(WorkspaceUpdateDilemmaHandler dilemmaHandler) {
        super(dilemmaHandler);
    }

    @Override
    public void rollback(IWorkspaceConnection workspace, ITeamRepository repository, IHistoryReference history, List<? extends IComponentHandle> filter, IProgressMonitor monitor) throws TeamRepositoryException {
        if (workspace == null || history == null) {
            throw new IllegalArgumentException();
        }
        try {
            HashSet<UUID> filterSet = new HashSet<UUID>();
            if (filter != null) {
                for (IComponentHandle iComponentHandle : filter) {
                    filterSet.add(iComponentHandle.getItemId());
                }
            }
            WorkspaceManager workspaceManager = (WorkspaceManager)SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
            IComponentHandle[] componentFilter = filter != null ? filter.toArray(new IComponentHandle[filter.size()]) : new IComponentHandle[]{};
            IHistoryReferenceDescription historyDescription = workspaceManager.getHistoryDescription(history, componentFilter, monitor);
            HashSet<UUID> componentsInSource = new HashSet<UUID>();
            for (IComponentReference handle : historyDescription.getComponents()) {
                componentsInSource.add(handle.getComponent().getItemId());
            }
            for (IComponentHandle handle : workspace.getComponents()) {
                if (!filterSet.isEmpty() && !filterSet.contains(handle.getItemId())) continue;
                UUID itemId = handle.getItemId();
                if (componentsInSource.contains(itemId)) {
                    this.replaceComponent(workspace, history, handle);
                    componentsInSource.remove(itemId);
                    continue;
                }
                this.removeComponent(workspace, handle);
            }
            if (!componentsInSource.isEmpty()) {
                for (UUID itemId : componentsInSource) {
                    IComponentHandle handle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(itemId, null);
                    this.addComponent(workspace, history, handle);
                }
            }
        }
        finally {
            monitor.done();
        }
    }
}

