/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.EclipseReadException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.internal.FileSystemManager;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.IFileContentMerger;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Sandbox;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.operations.VerifySharesOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.IDownloadListener;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdateReport2;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import com.ibm.team.scm.common.dto.IItemUpdateReport;
import com.ibm.team.scm.common.dto.ISynchronizationInfo;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class UpdateOperation
extends FileSystemOperation {
    private final List<IUpdateReport> updateReports;
    private final HashSet<ConfigurationFacade> affectedConfigurations;
    private final HashSet<ICopyFileArea> copyFileAreasAffected;
    private ILocation rootLocationOfAffectedCopyFileArea;
    private final IWorkspaceConnection connection;
    public static final int PROCESS_UPDATES = 1;
    public static final int PROCESS_INCIDENTAL_UPDATES = 2;
    public static final int PROCESS_ALL_UPDATES = 3;
    private final int updatesToProcess;
    private int updateCount;
    private boolean expandKeywords;
    private HashMap<UUID, IComponentHandle> excludedComponents;
    private ISynchronizationInfo synchronizationInfo;
    protected final UpdateDilemmaHandler problemHandler;
    private Map<ILocation, Map<ConfigurationFacade, Set<UUID>>> ignoreList = new HashMap<ILocation, Map<ConfigurationFacade, Set<UUID>>>();
    private final IDownloadListener downloadMonitor;

    public UpdateOperation(IWorkspaceConnection connection, List<IUpdateReport> updateReports, int updatesToProcess, UpdateDilemmaHandler problemHandler, IDownloadListener downloadMonitor) {
        this(connection, updateReports, Collections.EMPTY_LIST, updatesToProcess, problemHandler, downloadMonitor);
    }

    public UpdateOperation(IWorkspaceConnection connection, List<IUpdateReport> updateReports, Collection<IComponentHandle> componentsToExclude, int updatesToProcess, UpdateDilemmaHandler problemHandler, IDownloadListener downloadMonitor) {
        super(problemHandler == null ? UpdateDilemmaHandler.getDefault() : problemHandler);
        UpdateDilemmaHandler updateDilemmaHandler = this.problemHandler = problemHandler == null ? UpdateDilemmaHandler.getDefault() : problemHandler;
        if (connection == null) {
            throw new IllegalArgumentException();
        }
        if (updateReports == null || updateReports.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (componentsToExclude == null) {
            throw new IllegalArgumentException();
        }
        if ((updatesToProcess | 3) != 3 || updatesToProcess == 0) {
            throw new IllegalArgumentException();
        }
        this.excludedComponents = new HashMap();
        for (IComponentHandle component : componentsToExclude) {
            this.excludedComponents.put(component.getItemId(), component);
        }
        this.connection = connection;
        this.updateReports = updateReports;
        this.downloadMonitor = downloadMonitor;
        this.affectedConfigurations = new HashSet();
        for (IUpdateReport next : updateReports) {
            if (!(next instanceof IUpdateReport)) {
                throw new IllegalArgumentException();
            }
            IUpdateReport report = next;
            for (IComponentHandle component : report.getAffectedComponents()) {
                this.affectedConfigurations.add(new ConfigurationFacade((IConnection)connection, component));
            }
            for (IComponentStateSummary componentStateSummary : report.getComponentStatesBefore()) {
                this.affectedConfigurations.add(new ConfigurationFacade((IConnection)connection, componentStateSummary.getComponent()));
            }
            for (IComponentStateSummary componentStateSummary : report.getComponentStatesAfter()) {
                this.affectedConfigurations.add(new ConfigurationFacade((IConnection)connection, componentStateSummary.getComponent()));
            }
        }
        int flag = 0;
        if ((updatesToProcess & 1) == 1) {
            flag |= 1;
        }
        if ((updatesToProcess & 2) == 2) {
            flag |= 2;
        }
        this.updatesToProcess = flag;
        this.copyFileAreasAffected = new HashSet();
    }

    public UpdateOperation(IWorkspaceConnection connection, List<IUpdateReport> updateReports, Collection<IComponentHandle> componentsToExclude, int updatesToProcess, UpdateDilemmaHandler problemHandler, ILocation rootLocationOfAffectedCopyFileArea, IDownloadListener downloadMonitor) {
        this(connection, updateReports, componentsToExclude, updatesToProcess, problemHandler, downloadMonitor);
        if (rootLocationOfAffectedCopyFileArea == null) {
            throw new IllegalArgumentException();
        }
        this.rootLocationOfAffectedCopyFileArea = rootLocationOfAffectedCopyFileArea;
    }

    public void setSynchronizationInfo(ISynchronizationInfo synchronizationInfo) {
        this.synchronizationInfo = synchronizationInfo;
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    UpdateOperation.this.updateCopyFileArea(monitor);
                }
                catch (FileSystemException e) {
                    throw new InvocationTargetException((Throwable)((Object)e));
                }
                catch (TeamRepositoryException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireReadForConfigurations(this.affectedConfigurations, (IProgressMonitor)progress.newChild(1));
        try {
            this.runWithinFileSystemLock(runnableWithProgress, Messages.UpdateOperation_4, (IProgressMonitor)progress.newChild(99));
        }
        finally {
            WorkspaceLockUtil.release(workspaceLock);
        }
        progress.done();
    }

    /*
     * Unable to fully structure code
     */
    private void updateCopyFileArea(IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        monitor.setTaskName(Messages.UpdateOperation_0);
        progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(30 + 100 * this.updateReports.size()));
        lockRequests = this.cfaLockRequests();
        copyFileAreaLock = ICopyFileAreaManager.instance.lock(lockRequests, (IProgressMonitor)progress.newChild(1));
        try {
            this.determineCopyFileAreasAffected((IProgressMonitor)progress.newChild(10));
            moreComponents = this.getAdditionalComponentsToExclude(this.connection, this.excludedComponents.values(), this.updateReports, (IProgressMonitor)progress.newChild(10));
            for (IComponentHandle component : moreComponents) {
                this.excludedComponents.put(component.getItemId(), component);
            }
            fileSystemService = ((FileSystemManager)FileSystemCore.getFileSystemManager(this.connection.teamRepository())).getFileSystemService();
            this.verifyShares((IProgressMonitor)progress.newChild(8));
            loadCompletedCount = 0;
            try {
                numReports = this.updateReports.size();
                currentReport = 1;
                monitor.setTaskName(Messages.UpdateOperation_1);
                if (!this.problemHandler.isPreserveLocalChanges()) {
                    SharingManager.getInstance().disableChangeMonitoring();
                }
                for (IUpdateReport updateReport : this.updateReports) {
                    if (numReports > 1) {
                        monitor.setTaskName(NLS.bind((String)Messages.UpdateOperation_2, (Object)currentReport, (Object)numReports));
                    }
                    try {
                        updates = fileSystemService.incrementalFileLoadStream(this.connection, updateReport, this.excludedComponents.values(), true, this.updatesToProcess, this.synchronizationInfo, (IProgressMonitor)progress.newChild(50));
                        this.loadFileArea(this.connection, updateReport.getComponentStatesBefore(), updateReport.getComponentStatesAfter(), updates, updateReport.updates(), (IProgressMonitor)progress.newChild(49));
                        this.updateCount += updates.getAdds().size() + updates.getDeletes().size() + updates.getModifies().size() + updates.getMoves().size();
                        ++loadCompletedCount;
                    }
                    catch (EclipseReadException e) {
                        this.collectStatus(FileSystemStatusUtil.getStatusFor(2, e.getMessage(), (Throwable)e));
                    }
                    catch (FileSystemException e) {
                        this.collectStatus(FileSystemStatusUtil.getStatusFor((Throwable)e));
                    }
                    catch (TeamRepositoryException e) {
                        this.collectStatus(FileSystemStatusUtil.getStatusFor(4, Messages.UpdateOperation_3, e));
                    }
                }
            }
            finally {
                if (!this.problemHandler.isPreserveLocalChanges()) {
                    SharingManager.getInstance().enableChangeMonitoring();
                }
                ** for (cfa : this.copyFileAreasAffected)
            }
lbl-1000:
            // 1 sources

            {
                cfa.syncMetaData();
                continue;
lbl46:
                // 1 sources

            }
        }
        finally {
            copyFileAreaLock.release((IProgressMonitor)progress.newChild(1));
        }
        progress.done();
    }

    private void determineCopyFileAreasAffected(IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        ICopyFileAreaManager copyFileAreaManager = ICopyFileAreaManager.instance;
        if (this.rootLocationOfAffectedCopyFileArea != null) {
            this.copyFileAreasAffected.add(copyFileAreaManager.getExistingCopyFileArea(this.rootLocationOfAffectedCopyFileArea));
            monitor.done();
        } else {
            SubMonitor subMonitor = monitor.newChild(100);
            subMonitor.setWorkRemaining(this.affectedConfigurations.size());
            for (ConfigurationFacade configuration : this.affectedConfigurations) {
                this.copyFileAreasAffected.addAll(copyFileAreaManager.getCopyFileAreasForConfiguration(configuration, (IProgressMonitor)subMonitor.newChild(1)));
            }
        }
    }

    private List<ICopyFileAreaLockRequest> cfaLockRequests() {
        ICopyFileAreaManager.ICopyFileAreaLockRequestFactory lockFactory = ICopyFileAreaManager.instance.lockRequestFactory();
        HashSet<ConfigurationFacade> configurationsToLock = new HashSet<ConfigurationFacade>();
        for (IUpdateReport next : this.updateReports) {
            if (!(next instanceof IUpdateReport)) {
                throw new IllegalArgumentException();
            }
            IUpdateReport report = next;
            for (IComponentStateSummary componentStateSummary : report.getComponentStatesBefore()) {
                configurationsToLock.add(new ConfigurationFacade((IConnection)this.connection, componentStateSummary.getComponent()));
            }
        }
        if (this.rootLocationOfAffectedCopyFileArea != null) {
            return Collections.singletonList(lockFactory.getLockRequest(this.rootLocationOfAffectedCopyFileArea, configurationsToLock, true));
        }
        return Collections.singletonList(lockFactory.getLockRequest(configurationsToLock, true));
    }

    private void verifyShares(IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        if (!this.verifyInSyncEnabled() || this.problemHandler.getOutOfSyncDilemmaHandler().willIgnoreAllSharesOutOfSync()) {
            monitor.done();
            return;
        }
        VerifySharesOperation verifyOp = new VerifySharesOperation(this.problemHandler.getOutOfSyncDilemmaHandler());
        HashMap<UUID, IComponentStateSummary> componentStates = new HashMap<UUID, IComponentStateSummary>();
        for (IUpdateReport updateReport : this.updateReports) {
            if (this.excludedComponents.isEmpty()) {
                for (IComponentHandle componentHandle : updateReport.getAffectedComponents()) {
                    verifyOp.addToVerify((IConnection)this.connection, componentHandle);
                }
            } else {
                for (IComponentHandle component : updateReport.getAffectedComponents()) {
                    if (this.excludedComponents.containsKey(component.getItemId())) continue;
                    verifyOp.addToVerify((IConnection)this.connection, component);
                }
            }
            for (IComponentStateSummary summary : updateReport.getComponentStatesBefore()) {
                if (componentStates.get(summary.getComponent().getItemId()) != null) continue;
                componentStates.put(summary.getComponent().getItemId(), summary);
            }
        }
        verifyOp.addToVerifyAgainst((IConnection)this.connection, componentStates.values());
        verifyOp.run(monitor);
    }

    public void setIgnoreList(Map<ILocation, Map<ConfigurationFacade, Set<UUID>>> fullCancelPaths) {
        this.ignoreList = fullCancelPaths;
    }

    public void setExpandKeywords(boolean expandKeywords) {
        this.expandKeywords = expandKeywords;
    }

    /*
     * Unable to fully structure code
     */
    private void loadFileArea(IWorkspaceConnection connection, Collection<IComponentStateSummary> componentStatesBefore, Collection<IComponentStateSummary> componentStatesAfter, FileAreaUpdateReport2 loadStream, Collection<IItemUpdateReport> rawUpdates, IProgressMonitor progress) throws FileSystemException, TeamRepositoryException {
        mutators = SharingManager.getInstance().getUpdateMutator((IConnection)connection, componentStatesBefore, componentStatesAfter, loadStream, rawUpdates, this.copyFileAreasAffected, this.problemHandler, this.downloadMonitor);
        var11_8 = mutators;
        var10_9 = mutators.length;
        var9_12 = 0;
        while (var9_12 < var10_9) {
            mutator = var11_8[var9_12];
            mutator.setExpandKeywords(this.expandKeywords);
            mutator.setFileContentMerger(this.getFileContentMerger());
            ++var9_12;
        }
        try {
            for (IComponentStateSummary componentState : componentStatesBefore) {
                for (ICopyFileArea cfa : this.copyFileAreasAffected) {
                    SharingManager.getInstance().beginAvoidSandboxListening(new Sandbox(cfa), componentState.getComponent());
                }
            }
            var11_8 = mutators;
            var10_11 = mutators.length;
            var9_14 = 0;
            while (var9_14 < var10_11) {
                mutator = var11_8[var9_14];
                mutator.setSkipStoreContent(this.ignoreList);
                mutator.run(progress);
                ++var9_14;
            }
        }
        finally {
            ** for (componentState : componentStatesBefore)
        }
lbl-1000:
        // 3 sources

        {
            for (ICopyFileArea cfa : this.copyFileAreasAffected) {
                try {
                    SharingManager.getInstance().endAvoidSandboxListening(new Sandbox(cfa), componentState.getComponent());
                }
                catch (RuntimeException e) {
                    LoggingHelper.log((IStatus)new Status(4, "com.ibm.team.filesystem.client", e.getMessage(), (Throwable)e));
                }
            }
            continue;
        }
lbl37:
        // 1 sources

    }

    private Collection<IComponentHandle> getAdditionalComponentsToExclude(IWorkspaceConnection connection, Collection<IComponentHandle> excludedComponents, List<IUpdateReport> updateReports, IProgressMonitor progress) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(this.copyFileAreasAffected.size() * this.affectedConfigurations.size()));
        HashMap<UUID, IComponentHandle> result = new HashMap<UUID, IComponentHandle>();
        HashSet<UUID> componentsExamined = new HashSet<UUID>();
        for (IComponentHandle component : excludedComponents) {
            componentsExamined.add(component.getItemId());
        }
        IWorkspace context = connection.getResolvedWorkspace();
        for (IUpdateReport report : updateReports) {
            for (IComponentHandle component : report.getAffectedComponents()) {
                if (componentsExamined.contains(component.getItemId())) continue;
                try {
                    boolean found = false;
                    for (ICopyFileArea copyFileArea : this.copyFileAreasAffected) {
                        if (!copyFileArea.isConfigurationShared((IContextHandle)context, component, (IProgressMonitor)monitor.newChild(1))) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        result.put(component.getItemId(), component);
                    }
                }
                catch (FileSystemException fileSystemException) {
                    // empty catch block
                }
                componentsExamined.add(component.getItemId());
            }
        }
        return result.values();
    }

    @Override
    protected String getTraceMessage() {
        return String.valueOf(super.getTraceMessage()) + " : " + this.connection.getName() + " " + this.updateCount + " updates";
    }

    @Override
    public IFileContentMerger getFileContentMerger() {
        if (this.problemHandler != null && this.problemHandler.getFileContentMerger() != null) {
            return this.problemHandler.getFileContentMerger();
        }
        return super.getFileContentMerger();
    }
}

