/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.FileUploadHandler;
import com.ibm.team.filesystem.client.IFileContentManagerSession;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.operations.AbstractCurrentPortOperation;
import com.ibm.team.filesystem.client.internal.operations.ChangeHistoryChangeSetsDilemmaHandler;
import com.ibm.team.filesystem.client.internal.operations.UpdateOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.client.operations.IChangePropertiesOperation;
import com.ibm.team.filesystem.client.operations.ICheckinOperation;
import com.ibm.team.filesystem.client.operations.IFailedAutoResolveRequest;
import com.ibm.team.filesystem.client.operations.IUpdateCurrentPatchOperation;
import com.ibm.team.filesystem.client.operations.UpdateCurrentPatchDilemmaHandler;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IContentChangeDetail;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ILineDelimiterChangeDetail;
import com.ibm.team.filesystem.common.internal.FileItem;
import com.ibm.team.filesystem.common.internal.FilesystemFactory;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.common.utils.TemporaryOutputStream;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IVersionableManager;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.content.AbstractVersionedContentManagerInputStreamProvider;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.IChangeDetail;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.ICurrentPatch;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableChange;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public class UpdateCurrentPortOperation
extends AbstractCurrentPortOperation
implements IUpdateCurrentPatchOperation {
    List<IWorkspaceConnection.ICurrentPatchOperation> operations = new ArrayList<IWorkspaceConnection.ICurrentPatchOperation>();

    public UpdateCurrentPortOperation(UpdateCurrentPatchDilemmaHandler dilemmaHandler) {
        super(dilemmaHandler == null ? UpdateCurrentPatchDilemmaHandler.getDefault() : dilemmaHandler);
    }

    @Override
    protected String getOperationLabel() {
        return Messages.UpdateCurrentPortOperation_0;
    }

    private ClientAutoResolveOp getClientOp(IWorkspaceConnection.ICurrentPatchOperation op, IVersionableChange change, List<IWorkspaceConnection.ICurrentPatchOperation> operations) {
        if (!(op instanceof IWorkspaceConnection.IAutoResolveOp)) {
            return null;
        }
        if ((change.getFlags() & 0x20) != 0) {
            return null;
        }
        if (op.getChangeDetailId() == null) {
            IContentChangeDetail contentChange = null;
            ILineDelimiterChangeDetail lineChangeDetail = null;
            for (IChangeDetail changeDetail : change.getChanges()) {
                if (changeDetail.isResolved()) continue;
                if (changeDetail instanceof IContentChangeDetail) {
                    contentChange = (IContentChangeDetail)changeDetail;
                    continue;
                }
                if (!(changeDetail instanceof ILineDelimiterChangeDetail) || changeDetail.kind() != 0) continue;
                lineChangeDetail = (ILineDelimiterChangeDetail)changeDetail;
            }
            if (contentChange != null) {
                return new ClientAutoResolveOp(change, contentChange, lineChangeDetail, ((IWorkspaceConnection.IAutoResolveOp)op).isBestEffort());
            }
        } else {
            IChangeDetail changeDetail = change.getChangeDetail(op.getChangeDetailId());
            if (changeDetail instanceof IContentChangeDetail && !changeDetail.isResolved()) {
                ILineDelimiterChangeDetail lineChangeDetail = null;
                for (IWorkspaceConnection.ICurrentPatchOperation otherOp : operations) {
                    IChangeDetail otherChangeDetail;
                    if (!(otherOp instanceof IWorkspaceConnection.IAutoResolveOp) || !otherOp.getVersionable().sameItemId((IItemHandle)change.getVersionable()) || !((otherChangeDetail = change.getChangeDetail(otherOp.getChangeDetailId())) instanceof ILineDelimiterChangeDetail) || otherChangeDetail.isResolved() || otherChangeDetail.kind() != 0) continue;
                    lineChangeDetail = (ILineDelimiterChangeDetail)otherChangeDetail;
                    break;
                }
                return new ClientAutoResolveOp(change, (IContentChangeDetail)changeDetail, lineChangeDetail, ((IWorkspaceConnection.IAutoResolveOp)op).isBestEffort());
            }
        }
        return null;
    }

    @Override
    protected void doExecute(HashSet<ConfigurationFacade> configurationsToLock, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        if (configurationsToLock.size() > 0) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(configurationsToLock.size() * 3));
            for (ConfigurationFacade configurationFacade : configurationsToLock) {
                int result;
                IWorkspaceConnection wc = (IWorkspaceConnection)configurationFacade.getCachedConnection();
                if (wc == null) continue;
                IComponentHandle componentHandle = configurationFacade.getComponentHandle();
                IUpdateReport report = wc.applyCurrentPatchOperations(componentHandle, this.operations, (IProgressMonitor)progress.newChild(1));
                UpdateOperation updateOperation = new UpdateOperation(this.getConnection(), Collections.singletonList(report), 3, this.getUpdateDilemmaHandler(), null);
                this.disableVerifyInSync(updateOperation);
                updateOperation.run((IProgressMonitor)progress.newChild(1));
                ICurrentPatch currentPort = this.getConnection().getCurrentPatch(this.getComponent());
                ArrayList<ClientAutoResolveOp> attemptToResolveOnClient = new ArrayList<ClientAutoResolveOp>();
                ArrayList<IVersionableHandle> nonExisting = new ArrayList<IVersionableHandle>();
                for (IWorkspaceConnection.ICurrentPatchOperation op2 : this.operations) {
                    IVersionableChange vc;
                    ClientAutoResolveOp clientOp = this.getClientOp(op2, vc = currentPort.getVersionableChange(op2.getVersionable().getItemId()), this.operations);
                    if (clientOp == null) {
                        if (vc.isResolved() || !(op2 instanceof IWorkspaceConnection.IAutoResolveOp) || op2.getChangeDetailId() != null || vc.kind() != 3 && vc.kind() != 2 || (vc.getFlags() & 0x20) == 0 || (vc.getFlags() & 0x80) != 0 || (vc.getFlags() & 0x40) != 0) continue;
                        nonExisting.add(vc.getVersionable());
                        continue;
                    }
                    attemptToResolveOnClient.add(clientOp);
                }
                ArrayList<IWorkspaceConnection.ICurrentPatchOperation> subsequentOperations = new ArrayList<IWorkspaceConnection.ICurrentPatchOperation>();
                if (!nonExisting.isEmpty() && (result = ((UpdateCurrentPatchDilemmaHandler)this.getDilemmaHandler()).performAutoResolveForModificationsToMissing(this.getConnection(), this.getComponent(), nonExisting)) == 0) {
                    for (IVersionableHandle vh : nonExisting) {
                        IWorkspaceConnection.ICurrentPatchOperation markOperation = this.getConnection().getCurrentPatchOperationFactory().createResolveWithProposedOp(vh, false);
                        subsequentOperations.add(markOperation);
                    }
                }
                ArrayList<IShareable> toCommit = new ArrayList<IShareable>(attemptToResolveOnClient.size());
                ArrayList<ClientAutoResolveOp> uploads = new ArrayList<ClientAutoResolveOp>();
                HashMap<UUID, IFileItem> fileItemMap = this.makeFileItemMap(configurationFacade.getTeamRepository(), attemptToResolveOnClient, progress.newChild(1));
                ArrayList<ClientAutoResolveOp> missingMerger = new ArrayList<ClientAutoResolveOp>();
                for (ClientAutoResolveOp clientOp : attemptToResolveOnClient) {
                    IStatus iStatus = clientOp.run(configurationFacade, null, subsequentOperations, toCommit, fileItemMap, (IProgressMonitor)progress.newChild(1));
                    if (iStatus.isOK()) {
                        if (!clientOp.hasContentToUpload()) continue;
                        uploads.add(clientOp);
                        continue;
                    }
                    if (iStatus.getCode() == 1002 || iStatus.getCode() == 1001) {
                        missingMerger.add(clientOp);
                        continue;
                    }
                    if (clientOp.isBestEffort()) continue;
                    this.collectStatus(iStatus);
                }
                if (!missingMerger.isEmpty()) {
                    ArrayList<IFailedAutoResolveRequest> failedResolveRequets = new ArrayList<IFailedAutoResolveRequest>();
                    for (ClientAutoResolveOp clientAutoResolveOp : missingMerger) {
                        failedResolveRequets.add(clientAutoResolveOp.getFailureReport());
                    }
                    int n = ((UpdateCurrentPatchDilemmaHandler)this.getUpdateDilemmaHandler()).missingStorageMerger(failedResolveRequets);
                    if (n == 0) {
                        for (IFailedAutoResolveRequest iFailedAutoResolveRequest : failedResolveRequets) {
                            FailedAutoResolveRequest failedRequest = (FailedAutoResolveRequest)iFailedAutoResolveRequest;
                            if (!failedRequest.isRetryMerge()) continue;
                            ClientAutoResolveOp clientOp = failedRequest.getFailedOp();
                            IStatus result3 = clientOp.run(configurationFacade, failedRequest.getDefaultContentTypeMerger(), subsequentOperations, toCommit, fileItemMap, (IProgressMonitor)progress.newChild(1));
                            if (result3.isOK() && clientOp.hasContentToUpload()) {
                                uploads.add(clientOp);
                            }
                            if (clientOp.isBestEffort()) continue;
                            this.collectStatus(result3);
                        }
                    }
                }
                if (!uploads.isEmpty()) {
                    IFileContentManagerSession session = FileSystemCore.getContentManager(configurationFacade.getTeamRepository()).createSession(NLS.bind((String)Messages.NewCheckInOperation_3, (Object)wc.getName(), (Object[])new Object[0]), true, uploads.size(), (IProgressMonitor)progress.newChild(1));
                    for (ClientAutoResolveOp clientAutoResolveOp : uploads) {
                        try {
                            clientAutoResolveOp.uploadContent(session);
                        }
                        catch (TeamRepositoryException teamRepositoryException) {
                            // empty catch block
                        }
                    }
                    session.join();
                    if (session.getErrorStatus().length > 0) {
                        RepositoryUtils.throwAppropriateException(Messages.NewCheckInOperation_4, session.getErrorStatus());
                    }
                    ArrayList<IWorkspaceConnection.IConfigurationOp> arrayList = new ArrayList<IWorkspaceConnection.IConfigurationOp>();
                    for (ClientAutoResolveOp clientAutoResolveOp : uploads) {
                        clientAutoResolveOp.prepareCommitOperation(wc, arrayList, subsequentOperations);
                    }
                    IUpdateReport iUpdateReport = wc.commit(currentPort.getTargetChangeSet(), arrayList, (IProgressMonitor)progress.newChild(1));
                    UpdateOperation updateAfterCommitOperation = new UpdateOperation(this.getConnection(), Collections.singletonList(iUpdateReport), 3, this.getUpdateDilemmaHandler(), null);
                    this.disableVerifyInSync(updateAfterCommitOperation);
                    updateAfterCommitOperation.run((IProgressMonitor)progress.newChild(1));
                    for (ClientAutoResolveOp op5 : uploads) {
                        op5.dispose();
                    }
                }
                if (toCommit.size() > 0) {
                    ICheckinOperation commitOp = IOperationFactory.instance.getCheckinOperation(((UpdateCurrentPatchDilemmaHandler)this.getDilemmaHandler()).getCommitDilemmaHandler(), IRepositoryResolver.EXISTING_SHARED);
                    commitOp.requestCheckin(toCommit.toArray(new IShareable[toCommit.size()]), currentPort.getTargetChangeSet(), null, (IProgressMonitor)progress.newChild(1));
                    commitOp.run((IProgressMonitor)progress.newChild(1));
                }
                if (subsequentOperations.isEmpty()) continue;
                IUpdateReport report2 = wc.applyCurrentPatchOperations(componentHandle, subsequentOperations, (IProgressMonitor)progress.newChild(1));
                UpdateOperation updateOperation2 = new UpdateOperation(this.getConnection(), Collections.singletonList(report2), 3, this.getUpdateDilemmaHandler(), null);
                this.disableVerifyInSync(updateOperation2);
                updateOperation2.run((IProgressMonitor)progress.newChild(1));
            }
        }
    }

    private HashMap<UUID, IFileItem> makeFileItemMap(ITeamRepository repository, List<ClientAutoResolveOp> attemptToResolveOnClient, SubMonitor monitor) throws TeamRepositoryException {
        int handleCount = attemptToResolveOnClient.size() * 2;
        ArrayList<IVersionableHandle> itemHandles = new ArrayList<IVersionableHandle>(handleCount);
        for (ClientAutoResolveOp clientOp : attemptToResolveOnClient) {
            IVersionableHandle configState;
            IVersionableHandle beforeState = clientOp.versionableChange.getBeforeState();
            IVersionableHandle afterState = clientOp.versionableChange.getAfterState();
            if (beforeState != null && afterState != null) {
                itemHandles.add(beforeState);
                itemHandles.add(afterState);
            }
            if ((configState = clientOp.versionableChange.getConfigurationState()) == null) continue;
            itemHandles.add(configState);
        }
        IVersionableManager versionableeManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repository).versionableManager();
        List items = versionableeManager.fetchCompleteStates(itemHandles, (IProgressMonitor)monitor.newChild(handleCount));
        HashMap<UUID, IFileItem> fileItemMap = new HashMap<UUID, IFileItem>();
        for (Object item : items) {
            IFileItem fileItem = (IFileItem)item;
            fileItemMap.put(fileItem.getStateId(), fileItem);
        }
        return fileItemMap;
    }

    @Override
    public void setContext(IWorkspaceConnection connection, IComponentHandle component) {
        super.setContext(connection, component);
    }

    @Override
    public void autoResolve(IVersionableHandle versionable, Set<UUID> changeDetailIds, boolean bestEffort) {
        if (changeDetailIds == null || changeDetailIds.isEmpty()) {
            IWorkspaceConnection.ICurrentPatchOperation op = this.getConnection().getCurrentPatchOperationFactory().createAttemptAutoResolveOp(versionable, bestEffort);
            this.operations.add(op);
        } else {
            for (UUID changeDetailId : changeDetailIds) {
                IWorkspaceConnection.ICurrentPatchOperation op = this.getConnection().getCurrentPatchOperationFactory().createAttemptAutoResolveOp(versionable, changeDetailId, bestEffort);
                this.operations.add(op);
            }
        }
    }

    @Override
    public void markAsResolved(IVersionableHandle versionable, Set<UUID> changeDetailIds, boolean force) {
        if (changeDetailIds == null || changeDetailIds.isEmpty()) {
            IWorkspaceConnection.ICurrentPatchOperation op = this.getConnection().getCurrentPatchOperationFactory().createMarkAsResolvedOp(versionable, force);
            this.operations.add(op);
        } else {
            for (UUID changeDetailId : changeDetailIds) {
                IWorkspaceConnection.ICurrentPatchOperation op = this.getConnection().getCurrentPatchOperationFactory().createMarkAsResolvedOp(versionable, changeDetailId, force);
                this.operations.add(op);
            }
        }
    }

    @Override
    public void markAsUnresolved(IVersionableHandle versionable, Set<UUID> changeDetailIds) {
        if (changeDetailIds == null || changeDetailIds.isEmpty()) {
            IWorkspaceConnection.ICurrentPatchOperation op = this.getConnection().getCurrentPatchOperationFactory().createMarkAsUnresolvedOp(versionable);
            this.operations.add(op);
        } else {
            for (UUID changeDetailId : changeDetailIds) {
                IWorkspaceConnection.ICurrentPatchOperation op = this.getConnection().getCurrentPatchOperationFactory().createMarkAsUnresolvedOp(versionable, changeDetailId);
                this.operations.add(op);
            }
        }
    }

    @Override
    public void resolveWithProposed(IVersionableHandle versionable, Set<UUID> changeDetailIds, boolean force) {
        if (changeDetailIds == null || changeDetailIds.isEmpty()) {
            IWorkspaceConnection.ICurrentPatchOperation op = this.getConnection().getCurrentPatchOperationFactory().createResolveWithProposedOp(versionable, force);
            this.operations.add(op);
        } else {
            for (UUID changeDetailId : changeDetailIds) {
                IWorkspaceConnection.ICurrentPatchOperation op = this.getConnection().getCurrentPatchOperationFactory().createResolveWithProposedOp(versionable, changeDetailId, force);
                this.operations.add(op);
            }
        }
    }

    @Override
    public void undoChanges(IVersionableHandle versionable, Set<UUID> changeDetailIds, boolean force) {
        if (changeDetailIds == null || changeDetailIds.isEmpty()) {
            IWorkspaceConnection.ICurrentPatchOperation op = this.getConnection().getCurrentPatchOperationFactory().createUndoChangeOp(versionable, force);
            this.operations.add(op);
        } else {
            for (UUID changeDetailId : changeDetailIds) {
                IWorkspaceConnection.ICurrentPatchOperation op = this.getConnection().getCurrentPatchOperationFactory().createUndoChangeOp(versionable, changeDetailId, force);
                this.operations.add(op);
            }
        }
    }

    @Override
    public void reparentVersionable(IVersionableHandle versionable, IFolderHandle newParent) {
        IWorkspaceConnection.ICurrentPatchOperation op = this.getConnection().getCurrentPatchOperationFactory().createReparentVersionableOp(versionable, newParent);
        this.operations.add(op);
    }

    @Override
    protected void processLocalChanges(ChangeHistoryChangeSetsDilemmaHandler problemHandler, HashMap<ConfigurationFacade, Collection<ILocalChange>> checkin, boolean forSubcomponents, SubMonitor monitor) throws FileSystemException, TeamRepositoryException {
        if (checkin.isEmpty()) {
            return;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ConfigurationFacade myFacade = new ConfigurationFacade((IConnection)this.getConnection(), this.getComponent());
        Collection<ILocalChange> localChangesForComponent = checkin.get((Object)myFacade);
        if (localChangesForComponent == null) {
            return;
        }
        Collection<ILocalChange> localChangesForOperationTargets = this.getLocalChangesForOperationTargets(this.getComponent(), localChangesForComponent);
        if (!localChangesForOperationTargets.isEmpty()) {
            HashMap<ConfigurationFacade, Collection<ILocalChange>> operationTargetMap = new HashMap<ConfigurationFacade, Collection<ILocalChange>>(1);
            operationTargetMap.put(myFacade, localChangesForOperationTargets);
            int result = forSubcomponents ? problemHandler.uncheckedInChangesInSubcomponents(operationTargetMap, (IProgressMonitor)progress.newChild(20)) : problemHandler.uncheckedInChanges(operationTargetMap);
            switch (result) {
                case 1: {
                    throw new OperationCanceledException();
                }
                case 0: {
                    this.checkInLocalChanges(problemHandler, localChangesForOperationTargets, progress.newChild(80));
                    break;
                }
                case 2: {
                    throw new FileSystemException(Messages.ChangeHistoryChangeSetsOperation_0);
                }
            }
        }
        progress.done();
    }

    private Collection<ILocalChange> getLocalChangesForOperationTargets(IComponentHandle component, Collection<ILocalChange> localChanges) {
        HashMap<Object, ILocalChange> result = new HashMap<Object, ILocalChange>();
        ICurrentPatch currentPatch = this.getConnection().getCurrentPatch(component);
        HashMap<UUID, IVersionableChange> portChangeMap = new HashMap<UUID, IVersionableChange>();
        Collection changes = currentPatch.getVersionableChanges();
        for (IVersionableChange versionableChange : changes) {
            portChangeMap.put(versionableChange.getVersionable().getItemId(), versionableChange);
        }
        HashMap<IRelativeLocation, ILocalChange> localChangePathMap = new HashMap<IRelativeLocation, ILocalChange>();
        HashMap<UUID, ILocalChange> localChangeIDMap = new HashMap<UUID, ILocalChange>();
        for (ILocalChange localChange : localChanges) {
            localChangePathMap.put(localChange.getPath(), localChange);
            localChangeIDMap.put(localChange.getTarget().getItemId(), localChange);
        }
        for (IWorkspaceConnection.ICurrentPatchOperation operation : this.operations) {
            IRelativeLocation location;
            ILocalChange localChange;
            IVersionableChange versionableChange;
            if (!(operation instanceof IWorkspaceConnection.IMarkAsResolvedOp) && !(operation instanceof IWorkspaceConnection.IAutoResolveOp) && !(operation instanceof IWorkspaceConnection.IResolveWithProposedOp) || (versionableChange = (IVersionableChange)portChangeMap.get(operation.getVersionable().getItemId())) == null) continue;
            String[] parentPathHint = versionableChange.getParentPathHint();
            if (parentPathHint == null) {
                parentPathHint = new String[]{};
            }
            if ((localChange = (ILocalChange)localChangePathMap.get(location = new RelativeLocation(parentPathHint))) != null && localChange.getTarget() != null) {
                result.put(localChange.getTarget().getItemId(), localChange);
            } else if (localChange != null) {
                result.put(location, localChange);
            }
            location = location.append(versionableChange.getName());
            localChange = (ILocalChange)localChangePathMap.get(location);
            if (localChange != null && localChange.getTarget() != null) {
                result.put(localChange.getTarget().getItemId(), localChange);
            } else if (localChange != null) {
                result.put(location, localChange);
            }
            if (versionableChange.getParent() != null && (localChange = (ILocalChange)localChangeIDMap.get(versionableChange.getParent().getItemId())) != null) {
                result.put(versionableChange.getParent().getItemId(), localChange);
            }
            if ((localChange = (ILocalChange)localChangeIDMap.get(versionableChange.getVersionable().getItemId())) == null) continue;
            result.put(versionableChange.getVersionable().getItemId(), localChange);
        }
        return result.values();
    }

    private void checkInLocalChanges(ChangeHistoryChangeSetsDilemmaHandler problemHandler, Collection<ILocalChange> changesToCheckIn, SubMonitor monitor) throws TeamRepositoryException {
        SubMonitor subProgress = monitor.newChild(10).setWorkRemaining(changesToCheckIn.size() * 2);
        ICheckinOperation op = IOperationFactory.instance.getCheckinOperation(problemHandler.getCommitDilemmaHandler(), IRepositoryResolver.EXISTING_SHARED);
        if (this.nonAtomicCommitIsAnOption) {
            op.enableNonAtomicCommit(this.nonAtomicCommitFileUploadLimit);
        } else {
            op.disableNonAtomicCommit();
        }
        op.setRefreshBeforeRun(false);
        ILocalChange[] changes = changesToCheckIn.toArray(new ILocalChange[changesToCheckIn.size()]);
        op.requestCheckin(changes, null, "", (IProgressMonitor)subProgress.newChild(1));
        this.disableVerifyInSync(op);
        op.run((IProgressMonitor)monitor.newChild(84));
    }

    protected boolean autoResolveChanges(Class<?> filterOnDetail, boolean bestEffort) {
        ICurrentPatch currentPort = this.getConnection().getCurrentPatch(this.getComponent());
        if (currentPort == null) {
            return false;
        }
        boolean hasChanges = false;
        Collection changes = currentPort.getVersionableChanges();
        for (IVersionableChange change : changes) {
            IVersionableHandle versionable = change.getVersionable();
            HashSet<UUID> filteredChanges = new HashSet<UUID>();
            Collection changeDetails = change.getChanges();
            for (IChangeDetail changeDetail : changeDetails) {
                if (!filterOnDetail.isAssignableFrom(changeDetail.getClass()) || changeDetail.isResolved()) continue;
                filteredChanges.add(changeDetail.getId());
            }
            if (filteredChanges.isEmpty()) continue;
            this.autoResolve(versionable, filteredChanges, bestEffort);
            hasChanges = true;
        }
        return hasChanges;
    }

    private class ClientAutoResolveOp {
        private final IVersionableChange versionableChange;
        private IContentChangeDetail contentChangeDetail;
        private ILineDelimiterChangeDetail lineDelimiterChangeDetail;
        private final boolean bestEffort;
        private FailedAutoResolveRequest failureReport;
        private OutputStream mergedContent;
        private IFileContent uploadedContent;
        private IFileItem current;

        public ClientAutoResolveOp(IVersionableChange versionableChange, IContentChangeDetail contentChangeDetail, ILineDelimiterChangeDetail lineDelimitierChangeDetail, boolean bestEffort) {
            this.versionableChange = versionableChange;
            this.contentChangeDetail = contentChangeDetail;
            this.lineDelimiterChangeDetail = lineDelimitierChangeDetail;
            this.bestEffort = bestEffort;
        }

        public boolean isBestEffort() {
            return this.bestEffort;
        }

        public FailedAutoResolveRequest getFailureReport() {
            return this.failureReport;
        }

        public IStatus run(ConfigurationFacade configurationFacade, String contentTypeForMerge, List<IWorkspaceConnection.ICurrentPatchOperation> subsequentOperations, List<IShareable> toCommit, HashMap<UUID, IFileItem> fileItemMap, IProgressMonitor monitor) throws TeamRepositoryException {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)5);
            IVersionableHandle commonAncestorHandle = this.versionableChange.getBeforeState();
            IVersionableHandle proposedHandle = this.versionableChange.getAfterState();
            if (commonAncestorHandle == null || proposedHandle == null) {
                return Status.OK_STATUS;
            }
            if (!(commonAncestorHandle instanceof IFileItemHandle) || !(commonAncestorHandle instanceof IFileItemHandle)) {
                return Status.OK_STATUS;
            }
            IFileItem commonAncestor = fileItemMap.get(commonAncestorHandle.getStateId());
            IFileItem proposed = fileItemMap.get(proposedHandle.getStateId());
            if (commonAncestor == null || proposed == null) {
                return Status.OK_STATUS;
            }
            IShareable shareable = UpdateCurrentPortOperation.this.findShareable(configurationFacade, this.versionableChange.getVersionable(), (IProgressMonitor)progress.newChild(1));
            if (shareable == null) {
                if (this.versionableChange.getConfigurationState() == null) {
                    return Status.OK_STATUS;
                }
                boolean keepStream = false;
                OutputStream outputStream = this.getTempOutputStream(proposed.getContent().getRawLength());
                try {
                    this.current = fileItemMap.get(this.versionableChange.getConfigurationState().getStateId());
                    IStatus mergeStatus = UpdateCurrentPortOperation.this.getFileContentMerger().performAutoMerge(configurationFacade.getTeamRepository(), commonAncestor, proposed, this.current, outputStream, this.getChangePath(), contentTypeForMerge, (IProgressMonitor)progress.newChild(1));
                    if (mergeStatus.isOK()) {
                        outputStream.close();
                        keepStream = true;
                        this.rememberMergedContent(outputStream);
                    } else if (mergeStatus.getCode() == 1002 || mergeStatus.getCode() == 1001) {
                        this.failureReport = new FailedAutoResolveRequest(this, null, new RelativeLocation(this.getChangePath().segments()), configurationFacade.getComponentHandle(), this.versionableChange.getVersionable(), true);
                    }
                    IStatus iStatus = mergeStatus;
                    return iStatus;
                }
                catch (IOException e) {
                    throw new TeamRepositoryException((Throwable)e);
                }
                finally {
                    if (!keepStream) {
                        this.cleanUpTempStreams(outputStream);
                    }
                }
            }
            if (!shareable.shouldBeIgnored((IProgressMonitor)progress.newChild(1))) {
                try {
                    IStatus mergeStatus = UpdateCurrentPortOperation.this.getFileContentMerger().performAutoMerge(configurationFacade.getTeamRepository(), commonAncestor, proposed, shareable, contentTypeForMerge, new Shed(((UpdateCurrentPatchDilemmaHandler)UpdateCurrentPortOperation.this.getDilemmaHandler()).getBackupDilemmaHandler()), (IProgressMonitor)progress.newChild(1));
                    if (mergeStatus.getCode() == 1002 || mergeStatus.getCode() == 1001) {
                        this.failureReport = new FailedAutoResolveRequest(this, shareable, shareable.getLocalPath(), configurationFacade.getComponentHandle(), this.versionableChange.getVersionable(), true);
                    }
                    if (mergeStatus.isOK()) {
                        IWorkspaceConnection.ICurrentPatchOperation markOperation = UpdateCurrentPortOperation.this.getConnection().getCurrentPatchOperationFactory().createMarkAsResolvedOp(this.versionableChange.getVersionable(), this.contentChangeDetail.getId(), true);
                        subsequentOperations.add(markOperation);
                        toCommit.add(shareable);
                        if (this.lineDelimiterChangeDetail != null) {
                            IChangePropertiesOperation ldOp = IOperationFactory.instance.getChangePropertiesOperation(null);
                            ldOp.setLineDelimiter(shareable, this.lineDelimiterChangeDetail.getAfterLineDelimiter());
                            ldOp.run((IProgressMonitor)progress.newChild(1));
                            markOperation = UpdateCurrentPortOperation.this.getConnection().getCurrentPatchOperationFactory().createMarkAsResolvedOp(this.versionableChange.getVersionable(), this.lineDelimiterChangeDetail.getId(), true);
                            subsequentOperations.add(markOperation);
                        }
                    }
                    return mergeStatus;
                }
                catch (IOException e) {
                    return FileSystemStatusUtil.getStatusFor(e);
                }
            }
            return Status.OK_STATUS;
        }

        private void rememberMergedContent(OutputStream outputStream) {
            this.mergedContent = outputStream;
        }

        private IPath getChangePath() {
            if (this.versionableChange.getParentPathHint() != null) {
                return PathUtils.getPath(this.versionableChange.getParentPathHint()).append(this.versionableChange.getName());
            }
            return new Path(this.versionableChange.getName());
        }

        private OutputStream getTempOutputStream(long estimatedSize) {
            try {
                return TemporaryOutputStream.getEstimatedSizeTemporaryOutputStream((long)estimatedSize);
            }
            catch (IOException e) {
                LoggingHelper.log(FileSystemStatusUtil.getStatusFor(e));
                return new ByteArrayOutputStream();
            }
        }

        private void cleanUpTempStreams(OutputStream outputStream) {
            if (outputStream instanceof TemporaryOutputStream) {
                TemporaryOutputStream tos = (TemporaryOutputStream)outputStream;
                try {
                    tos.dispose();
                }
                catch (IOException e) {
                    LoggingHelper.log(FileSystemStatusUtil.getStatusFor(e));
                }
            }
        }

        private InputStream getTempInputStream(OutputStream out, IProgressMonitor monitor) throws IOException {
            if (out instanceof ByteArrayOutputStream) {
                ByteArrayOutputStream baos = (ByteArrayOutputStream)out;
                baos.close();
                return new ByteArrayInputStream(baos.toByteArray());
            }
            if (out instanceof IInputStreamProvider) {
                IInputStreamProvider isp = (IInputStreamProvider)out;
                return isp.getInputStream(monitor);
            }
            throw new IllegalStateException();
        }

        public boolean hasContentToUpload() {
            return this.mergedContent != null;
        }

        public void uploadContent(IFileContentManagerSession session) throws TeamRepositoryException {
            session.storeContent(this.getUploadHandler());
        }

        private FileUploadHandler getUploadHandler() {
            return new FileUploadHandler(){

                public AbstractVersionedContentManagerInputStreamProvider getStreamProvider() throws TeamRepositoryException {
                    return new AbstractVersionedContentManagerInputStreamProvider(){

                        public InputStream wrapInputStream(InputStream in) throws IOException, TeamRepositoryException {
                            return in;
                        }

                        public InputStream getInputStream(int flags) throws IOException, TeamRepositoryException {
                            return ClientAutoResolveOp.this.getTempInputStream(ClientAutoResolveOp.this.mergedContent, (IProgressMonitor)SubMonitor.convert(null));
                        }

                        public void dispose() throws IOException, TeamRepositoryException {
                            ClientAutoResolveOp.this.cleanUpTempStreams(ClientAutoResolveOp.this.mergedContent);
                        }
                    };
                }

                public ContentHash getPredecessorHintHash() throws TeamRepositoryException {
                    return ClientAutoResolveOp.this.current.getContent().getHash();
                }

                @Override
                protected FileLineDelimiter getLineDelimiter() throws TeamRepositoryException {
                    if (ClientAutoResolveOp.this.lineDelimiterChangeDetail != null) {
                        return ClientAutoResolveOp.this.lineDelimiterChangeDetail.getAfterLineDelimiter();
                    }
                    return ClientAutoResolveOp.this.current.getContent().getLineDelimiter();
                }

                @Override
                protected String getEncoding() throws TeamRepositoryException {
                    return ClientAutoResolveOp.this.current.getContent().getCharacterEncoding();
                }

                @Override
                protected String getContentType() throws TeamRepositoryException {
                    return ClientAutoResolveOp.this.current.getContentType();
                }

                @Override
                protected void uploadCompleted(IFileContent content) throws TeamRepositoryException {
                    ClientAutoResolveOp.this.uploadedContent = content;
                }
            };
        }

        public void prepareCommitOperation(IWorkspaceConnection workspace, List<IWorkspaceConnection.IConfigurationOp> configOps, List<IWorkspaceConnection.ICurrentPatchOperation> subsequentOperations) {
            if (this.uploadedContent == null) {
                return;
            }
            configOps.add((IWorkspaceConnection.IConfigurationOp)workspace.configurationOpFactory().save(this.createFileItem()));
            IWorkspaceConnection.ICurrentPatchOperation markOperation = UpdateCurrentPortOperation.this.getConnection().getCurrentPatchOperationFactory().createMarkAsResolvedOp(this.versionableChange.getVersionable(), this.contentChangeDetail.getId(), true);
            subsequentOperations.add(markOperation);
            if (this.lineDelimiterChangeDetail != null) {
                markOperation = UpdateCurrentPortOperation.this.getConnection().getCurrentPatchOperationFactory().createMarkAsResolvedOp(this.versionableChange.getVersionable(), this.lineDelimiterChangeDetail.getId(), true);
                subsequentOperations.add(markOperation);
            }
        }

        private IVersionable createFileItem() {
            FileItem file = FilesystemFactory.eINSTANCE.createFileItem();
            file.initNew();
            file.setItemId(this.current.getItemId());
            file.setParent(this.current.getParent());
            file.setName(this.current.getName());
            file.getProperties().putAll(this.current.getUserProperties());
            file.setExecutable(this.current.isExecutable());
            file.setContent(this.uploadedContent);
            file.setContentType(this.current.getContentType());
            file.setFileTimestamp(new Date());
            return file;
        }

        public void dispose() {
            if (this.mergedContent != null) {
                this.cleanUpTempStreams(this.mergedContent);
            }
        }
    }

    private class FailedAutoResolveRequest
    implements IFailedAutoResolveRequest {
        private IShareable shareable;
        private boolean mergerUndetermined;
        private boolean retryMerge;
        private String contentType;
        private ClientAutoResolveOp failedOp;
        private final IComponentHandle component;
        private final IVersionableHandle versionable;
        private IRelativeLocation conflictPath;

        public FailedAutoResolveRequest(ClientAutoResolveOp clientAutoResolveOp, IShareable shareable, IRelativeLocation conflictPath, IComponentHandle component, IVersionableHandle versionable, boolean mergerUndetermined) {
            this.failedOp = clientAutoResolveOp;
            this.conflictPath = conflictPath;
            this.shareable = shareable;
            this.component = component;
            this.versionable = versionable;
            this.mergerUndetermined = mergerUndetermined;
        }

        public ClientAutoResolveOp getFailedOp() {
            return this.failedOp;
        }

        @Override
        public IRelativeLocation getConflictPath() {
            return this.conflictPath;
        }

        @Override
        public IShareable getConflictedShareable() {
            return this.shareable;
        }

        @Override
        public boolean isStreamMergerUndetermined() {
            return this.mergerUndetermined;
        }

        @Override
        public void setRetryMerge(boolean retryMerge) {
            this.retryMerge = retryMerge;
        }

        public boolean isRetryMerge() {
            return this.retryMerge;
        }

        @Override
        public void defaultContentTypeMerger(String defaultContentType) {
            this.contentType = defaultContentType;
        }

        @Override
        public String getDefaultContentTypeMerger() {
            return this.contentType;
        }

        @Override
        public IComponentHandle getComponent() {
            return this.component;
        }

        @Override
        public IVersionableHandle getConflictedVersionable() {
            return this.versionable;
        }
    }
}

