/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileDownloadHandler;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemManager;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.IFileOptions;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.MetadataProperties;
import com.ibm.team.filesystem.client.internal.Share;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.api.storage.FileOptionsFactory;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFALockUtil;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.load.LoadFilter;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.operations.ILoadMutator;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.client.operations.IMetadataSynchronizeOperation;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.common.internal.FileContent;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdate;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.VersionedContentDeleted;
import com.ibm.team.scm.common.dto.ISyncTime;
import com.ibm.team.scm.common.dto.ISynchronizationInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class SynchronizeOperation
extends FileSystemOperation
implements IMetadataSynchronizeOperation {
    private Share share;
    private final IRepositoryResolver resolver;
    private ISynchronizationInfo synchronizationInfo;

    public SynchronizeOperation(IRepositoryResolver resolver) {
        super(null);
        this.resolver = resolver;
    }

    @Override
    public void synchronizeRequest(IShare ishare, ISynchronizationInfo synchronizationInfo) {
        if (this.share != null) {
            throw new IllegalStateException("Operation only supports 1 request");
        }
        this.share = (Share)ishare;
        this.synchronizationInfo = synchronizationInfo;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        desc = this.share.getSharingDescriptor();
        component = desc.getComponent();
        connection = desc.getConnectionHandle();
        repo = this.resolver.getRepoFor(null, desc.getRepositoryId());
        contentManager = FileSystemCore.getContentManager(repo);
        progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        trackingRule = SharingManager.getInstance().getTrackingRule(this.share.getSandbox().getRoot());
        otherErrors = new ArrayList<IStatus>();
        try {
            Job.getJobManager().beginRule(trackingRule, (IProgressMonitor)progress.newChild(1));
            rule = CFALockUtil.createAndLockForUpdate(this.share.getSandbox().getRoot(), connection, component, (IProgressMonitor)progress.newChild(1));
            try {
                block58: {
                    block59: {
                        cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(this.share.getSandbox().getRoot());
                        newDesc = cfa.getSharingInfo(this.share.getPath());
                        if (!desc.equals(newDesc)) {
                            return;
                        }
                        filter = null;
                        try {
                            filter = LoadFilter.getFilter(newDesc);
                        }
                        catch (IOException e1) {
                            LoggingHelper.log(FileSystemStatusUtil.getStatusFor(e1));
                        }
                        filteredItems = new HashSet<UUID>();
                        wMgr = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
                        if (desc.getConnectionHandle() instanceof IBaselineHandle) {
                            bConnection = wMgr.getBaselineConnection((IBaselineHandle)desc.getConnectionHandle(), (IProgressMonitor)progress.newChild(3));
                            configuration = bConnection.configuration();
                            lconnection = bConnection;
                        } else {
                            wConnection = wMgr.getWorkspaceConnection((IWorkspaceHandle)desc.getConnectionHandle(), (IProgressMonitor)progress.newChild(3));
                            configuration = wConnection.configuration(component);
                            lconnection = wConnection;
                        }
                        fsm = FileSystemCore.getFileSystemManager(repo);
                        fss = ((FileSystemManager)fsm).getFileSystemService();
                        needHashes = FileLineDelimiter.getPlatformDelimiter() != FileLineDelimiter.LINE_DELIMITER_LF;
                        transformsContentsSet = SharingManager.getInstance().transformsContentsSet(this.share.getSandbox());
                        try {
                            tree = fss.getFileTreeByVersionable((IConnection)lconnection, desc.getComponent(), new IVersionableHandle[]{desc.getRootVersionable()}, -1, true, this.synchronizationInfo, (IProgressMonitor)progress.newChild(needHashes != false || transformsContentsSet != false ? 20 : 35));
                        }
                        catch (TeamRepositoryException e) {
                            progress.setWorkRemaining(56);
                            try {
                                root = configuration.fetchCompleteItems(Collections.singletonList(desc.getRootVersionable()), (IProgressMonitor)progress.newChild(15));
                                if (root.get(0) != null) throw e;
                                ((Shareable)this.share.getShareable()).forget((IProgressMonitor)progress.newChild(20));
                            }
                            catch (TeamRepositoryException ex) {
                                throw e;
                            }
                            SynchronizeOperation.refreshChanges(this.share, (IProgressMonitor)progress.newChild(20));
                            CFALockUtil.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                            Job.getJobManager().endRule(trackingRule);
                            progress.done();
                            return;
                        }
                        if (!tree.getInaccessible().getRequests().isEmpty()) {
                            ((Shareable)this.share.getShareable()).forget((IProgressMonitor)progress.newChild(20));
                            SynchronizeOperation.refreshChanges(this.share, (IProgressMonitor)progress.newChild(20));
                            return;
                        }
                        loadMutator = SharingManager.getInstance().getLoadMutator(this.share.getSandbox(), LoadDilemmaHandler.getDefault());
                        updates = tree.getFileAreaUpdates();
                        builder = new TreeBuilder(needHashes, transformsContentsSet, loadMutator);
                        contentSession = needHashes != false || transformsContentsSet != false ? contentManager.createSession("", true, updates.size(), (IProgressMonitor)progress.newChild(15)) : null;
                        for (FileAreaUpdate update : updates) {
                            if (filter != null) {
                                if (!filter.include(update.getName())) {
                                    filteredItems.add(update.getItem().getItemId());
                                    continue;
                                }
                                if (filteredItems.contains(update.getDestinationParent().getItemId())) {
                                    filteredItems.add(update.getItem().getItemId());
                                    continue;
                                }
                            }
                            builder.addUpdate(update);
                            if (!update.getItem().sameItemId((IItemHandle)desc.getRootVersionable())) {
                                builder.updateChildren(update);
                            }
                            if (!needHashes && !transformsContentsSet) continue;
                            if (update.getOptionalContent() != null && (transformsContentsSet || contentManager.convertDelimitersDuringRetrieval(update.getOptionalContent()))) {
                                oldInfo = cfa.getItemInfo(update.getItem(), component, connection, false);
                                if (oldInfo != null && update.afterState().sameStateId((IItemHandle)oldInfo.getVersionableHandle())) {
                                    contentSession.decrementTransferCount(1L);
                                    continue;
                                }
                                contentSession.retrieveContent((IFileItemHandle)update.afterState(), update.getOptionalContent(), builder);
                                continue;
                            }
                            contentSession.decrementTransferCount(1L);
                        }
                        inTree = builder.getInTree();
                        if (needHashes || transformsContentsSet) {
                            contentSession.join();
                            for (FileAreaUpdate update : inTree.values()) {
                                if (update.getOptionalContent() == null) continue;
                                oldInfo = cfa.getItemInfo(update.getItem(), component, connection, false);
                                builder.getHash(update, oldInfo);
                            }
                            if (builder.hasFailedFetches()) {
                                for (UUID uuid : TreeBuilder.access$0(builder)) {
                                    inTree.remove(uuid);
                                }
                            }
                        }
                        deletedItems = new ArrayList<IVersionableHandle>();
                        subProgress = progress.newChild(25);
                        subProgress.setWorkRemaining(updates.size());
                        md = cfa.internalGetMetadata();
                        for (FileAreaUpdate update : updates) {
                            subSubProgress = subProgress.newChild(1);
                            subSubProgress.setWorkRemaining(100);
                            if (filteredItems.contains(update.getItem().getItemId())) continue;
                            oldInfo = cfa.getItemInfo(update.getItem(), component, connection, false);
                            localPath = cfa.getLocalPathFor(update.getItem(), component, connection, (IProgressMonitor)subSubProgress.newChild(33));
                            children = builder.getChildren(update);
                            item = update.afterState();
                            parent = update.getDestinationParent();
                            name = update.getName();
                            hash = null;
                            size = -1L;
                            originalLineDelimiter = null;
                            originalContentType = null;
                            originalExternalLinks = null;
                            predecessorHintHash = null;
                            sizeInRepo = -1L;
                            encoding = null;
                            hashInRepo = null;
                            numLineDelimiters = -1L;
                            if (update.getOptionalContent() != null) {
                                size = update.getOptionalContent().getEstimatedConvertedLength();
                                hash = builder.getHash(update, oldInfo);
                                if (hash == null) continue;
                                originalLineDelimiter = update.getOptionalContent().getLineDelimiter();
                                originalContentType = update.getContentType();
                                originalExternalLinks = update.getLinkInfo();
                                content = (FileContent)update.getOptionalContent();
                                predecessorHintHash = content.getPredecessorHintHash();
                                sizeInRepo = content.getSize();
                                encoding = content.getCharacterEncoding();
                                hashInRepo = content.getHash();
                                numLineDelimiters = content.getLineDelimiterCount();
                            } else if (update.getItem() instanceof ISymbolicLinkHandle) {
                                try {
                                    target = update.getLinkTarget();
                                    targetInLocalForm = ((Shareable)this.share.getShareable()).getFileStorage().convertTargetIntoLocalForm(target);
                                    hash = CopyFileArea.getLinkHash(targetInLocalForm);
                                    hashInRepo = CopyFileArea.getLinkHash(target);
                                }
                                catch (IOException e) {
                                    otherErrors.add(FileSystemStatusUtil.getStatusFor(e));
                                    continue;
                                }
                            }
                            if (oldInfo == null) {
                                newInfo = new InverseFileItemInfo(item, false, -1L, parent, name, false, children, null, null, hash, size, originalLineDelimiter, originalLineDelimiter, originalContentType, originalContentType, predecessorHintHash, sizeInRepo, encoding, hashInRepo, numLineDelimiters, update.isExecutable(), update.isExecutable(), update.isDirectoryLink(), update.isDirectoryLink(), update.getMetadataProperties(), Collections.EMPTY_SET, Collections.EMPTY_MAP, originalExternalLinks, originalExternalLinks);
                            } else {
                                localParent = oldInfo.getLocalParent();
                                if (localParent == null && item.sameItemId((IItemHandle)desc.getRootVersionable()) && oldInfo.getParent() == null) {
                                    localParent = parent;
                                    loadedWithAnotherName = name.equals(oldInfo.getLocalName()) == false;
                                    useOldContentInfo = false;
                                } else {
                                    loadedWithAnotherName = oldInfo.isLoadedWithAnotherName();
                                    useOldContentInfo = true;
                                }
                                if (hash != null) {
                                    if (hash.equals((Object)oldInfo.getHash()) && size == oldInfo.getContentLength()) {
                                        contentChanged = oldInfo.isContentChanged();
                                        modStamp = oldInfo.getLastContentChangeCheckStamp();
                                    } else {
                                        contentChanged = oldInfo.getLocalName() != null;
                                        modStamp = -1L;
                                    }
                                } else {
                                    modStamp = -1L;
                                    contentChanged = false;
                                }
                                properties = new MetadataProperties((Map<String, String>)update.getMetadataProperties(), new MetadataProperties(oldInfo.getOriginalProperties(), oldInfo.getChangedProperties(), oldInfo.getRemovedProperties()));
                                newInfo = new InverseFileItemInfo(item, contentChanged, modStamp, parent, name, loadedWithAnotherName, children, localParent, oldInfo.getLocalName(), hash, size, originalLineDelimiter, useOldContentInfo != false ? oldInfo.getLineDelimiter() : originalLineDelimiter, originalContentType, useOldContentInfo != false ? oldInfo.getContentType() : originalContentType, predecessorHintHash, sizeInRepo, encoding, hashInRepo, numLineDelimiters, useOldContentInfo != false ? oldInfo.isExecutable() : update.isExecutable(), update.isExecutable(), useOldContentInfo != false ? oldInfo.isDirectoryLink() : update.isDirectoryLink(), update.isDirectoryLink(), properties.getOriginalProperties(), properties.getRemovedProperties(), properties.getChangedProperties(), useOldContentInfo != false ? oldInfo.getExternalLinks() : originalExternalLinks, originalExternalLinks);
                                if (localPath != null) {
                                    md.setFileItemInfo(localPath, newInfo);
                                    subSubProgress.worked(33);
                                }
                                for (IVersionableHandle h : oldInfo.getRemoteChildren().values()) {
                                    if (inTree.containsKey(h.getItemId())) continue;
                                    deletedItems.add(h);
                                }
                            }
                            subSubProgress.setWorkRemaining(33);
                            md.setFileItemInfo(item, component, connection, newInfo, (IProgressMonitor)subSubProgress.newChild(1));
                            subSubProgress.done();
                        }
                        subProgress.done();
                        subProgress = progress.newChild(9);
                        while (!deletedItems.isEmpty()) {
                            subProgress.setWorkRemaining(deletedItems.size() + 1);
                            subSubProgress = subProgress.newChild(1);
                            subSubProgress.setWorkRemaining(100);
                            deleted = (IVersionableHandle)deletedItems.remove(deletedItems.size() - 1);
                            localPath = cfa.getLocalPathFor(deleted, component, connection, (IProgressMonitor)subSubProgress.newChild(24));
                            oldInfo = md.setFileItemInfo(deleted, component, connection, null, (IProgressMonitor)subSubProgress.newChild(1));
                            subSubProgress.worked(25);
                            if (localPath != null) {
                                newHandle = (IVersionableHandle)oldInfo.getVersionableHandle().getItemType().createItemHandle(UUID.generate(), null);
                                newInfo = new InverseFileItemInfo(newHandle, false, -1L, null, null, false, Collections.EMPTY_MAP, oldInfo.getLocalParent(), oldInfo.getLocalName(), null, -1L, null, oldInfo.getLineDelimiter(), null, oldInfo.getContentType(), null, -1L, null, null, -1L, oldInfo.isExecutable(), false, oldInfo.isDirectoryLink(), false, Collections.EMPTY_MAP, Collections.EMPTY_SET, new MetadataProperties(oldInfo.getOriginalProperties(), oldInfo.getChangedProperties(), oldInfo.getRemovedProperties()).getCurrentProperties(), oldInfo.getExternalLinks(), null);
                                md.setFileItemInfo(localPath, newInfo);
                                subSubProgress.worked(12);
                                md.setFileItemInfo(newHandle, component, connection, newInfo, (IProgressMonitor)subSubProgress.newChild(1));
                                subSubProgress.worked(13);
                                if (oldInfo.isFolder()) {
                                    shareable = new Shareable(this.share.getSandboxRoot(), localPath, ResourceType.FOLDER);
                                    childInfos = cfa.getChildInfos(shareable.getLocalPath(), (IProgressMonitor)subSubProgress.newChild(5));
                                    parent = (IFolderHandle)newHandle;
                                    subSubProgress.setWorkRemaining(childInfos.size());
                                    for (FileItemInfo info : childInfos.values()) {
                                        inverseInfo = cfa.getItemInfo(info.getVersionableHandle(), component, connection, true);
                                        newChildInfo = new InverseFileItemInfo(inverseInfo.getVersionableHandle(), inverseInfo.isContentChanged(), inverseInfo.getLastContentChangeCheckStamp(), inverseInfo.getParent(), inverseInfo.getName(), inverseInfo.isLoadedWithAnotherName(), inverseInfo.getRemoteChildren(), parent, inverseInfo.getLocalName(), inverseInfo.getHash(), inverseInfo.getContentLength(), inverseInfo.getOriginalLineDelimiter(), inverseInfo.getLineDelimiter(), inverseInfo.getOriginalContentType(), inverseInfo.getContentType(), inverseInfo.getStoredPredecessorHintHash(), inverseInfo.getStoredSize(), inverseInfo.getStoredEncoding(), inverseInfo.getStoredHash(), inverseInfo.getStoredNumLineDelimiters(), inverseInfo.isExecutable(), inverseInfo.isOriginalExecutable(), inverseInfo.isDirectoryLink(), inverseInfo.isOriginalDirectoryLink(), inverseInfo.getOriginalProperties(), inverseInfo.getRemovedProperties(), inverseInfo.getChangedProperties(), inverseInfo.getExternalLinks(), inverseInfo.getOriginalExternalLinks());
                                        md.setFileItemInfo(newChildInfo.getVersionableHandle(), component, connection, newChildInfo, (IProgressMonitor)subSubProgress.newChild(1));
                                        subSubProgress.worked(1);
                                    }
                                }
                            }
                            for (IVersionableHandle h : oldInfo.getRemoteChildren().values()) {
                                if (inTree.containsKey(h.getItemId())) continue;
                                deletedItems.add(h);
                            }
                            subSubProgress.done();
                        }
                        subProgress.done();
                        if (builder.hasFailedFetches()) {
                            cfa.setConfigurationState(connection, component, this.share.getPath(), ISyncTime.TIME_NONE, (IProgressMonitor)progress.newChild(1));
                        } else {
                            cfa.setConfigurationState(connection, component, this.share.getPath(), ISyncTime.FACTORY.createFrom(tree.getConfigurationState()), (IProgressMonitor)progress.newChild(1));
                        }
                        SynchronizeOperation.refreshChanges(this.share, (IProgressMonitor)progress.newChild(24));
                        if (!needHashes && !transformsContentsSet) break block58;
                        if (otherErrors.isEmpty()) break block59;
                        var35_41 = contentDownloadErrors = contentSession.getErrorStatus();
                        var34_40 = contentDownloadErrors.length;
                        var33_38 = 0;
                        if (true) ** GOTO lbl251
                    }
                    this.throwAppropriateException(Messages.SynchronizeOperation_1, contentSession.getErrorStatus());
                    break block58;
                    do {
                        status = var35_41[var33_38];
                        otherErrors.add(status);
                        ++var33_38;
lbl251:
                        // 2 sources

                    } while (var33_38 < var34_40);
                }
                if (otherErrors.isEmpty() != false) return;
                this.throwAppropriateException(Messages.SynchronizeOperation_1, otherErrors.toArray(new IStatus[otherErrors.size()]));
                return;
            }
            finally {
                CFALockUtil.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            }
        }
        finally {
            Job.getJobManager().endRule(trackingRule);
            progress.done();
        }
    }

    private void throwAppropriateException(String errorMsg, IStatus[] statuses) throws FileSystemException {
        ArrayList<IStatus> filteredStatuses = new ArrayList<IStatus>(statuses.length);
        boolean count = false;
        IStatus[] iStatusArray = statuses;
        int n = statuses.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus status = iStatusArray[n2];
            if (!(status.getException() instanceof VersionedContentDeleted)) {
                filteredStatuses.add(status);
            }
            ++n2;
        }
        if (statuses.length != filteredStatuses.size()) {
            statuses = filteredStatuses.toArray(new IStatus[filteredStatuses.size()]);
        }
        RepositoryUtils.throwAppropriateException(errorMsg, statuses);
    }

    private static void refreshChanges(IShare share, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Shareable rootShareable = (Shareable)share.getShareable();
        SharingManager shMgr = SharingManager.getInstance();
        shMgr.disableChangeMonitoring();
        try {
            rootShareable.getFileStorage().refreshCachedSubTree(Integer.MAX_VALUE, (IProgressMonitor)progress.newChild(40));
        }
        finally {
            shMgr.enableChangeMonitoring();
        }
        ILocalChangeManager changeManager = shMgr.getLocalChangeManager();
        ((LocalChangeManager)changeManager).refreshChanges(rootShareable, (IProgressMonitor)progress.newChild(60));
    }

    private static class TreeBuilder
    extends FileDownloadHandler {
        private final Map<UUID, Map<String, FileAreaUpdate>> childMap = new HashMap<UUID, Map<String, FileAreaUpdate>>();
        private Map<UUID, ContentHash> fetchedHashes;
        private Set<UUID> failedFetches;
        private Set<UUID> deletedContent;
        private final boolean needsHashes;
        private final boolean transformsContentsSet;
        private final Map<UUID, FileAreaUpdate> inTree;
        private final ILoadMutator loadMutator;

        public TreeBuilder(boolean needsHashes, boolean transformsContentsSet, ILoadMutator loadMutator) {
            this.needsHashes = needsHashes;
            this.transformsContentsSet = transformsContentsSet;
            if (needsHashes || transformsContentsSet) {
                this.fetchedHashes = new HashMap<UUID, ContentHash>();
                this.failedFetches = new HashSet<UUID>();
                this.deletedContent = new HashSet<UUID>();
            }
            this.inTree = new HashMap<UUID, FileAreaUpdate>();
            this.loadMutator = loadMutator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addUpdate(FileAreaUpdate update) {
            Map<UUID, FileAreaUpdate> map = this.inTree;
            synchronized (map) {
                this.inTree.put(update.getItem().getItemId(), update);
            }
        }

        public void updateChildren(FileAreaUpdate update) {
            Map<String, FileAreaUpdate> children = this.childMap.get(update.getDestinationParent().getItemId());
            if (children == null) {
                children = new HashMap<String, FileAreaUpdate>();
                this.childMap.put(update.getDestinationParent().getItemId(), children);
            }
            children.put(update.getName(), update);
        }

        public Map<String, IVersionableHandle> getChildren(FileAreaUpdate update) {
            Map<String, FileAreaUpdate> map = this.childMap.get(update.getItem().getItemId());
            if (map == null) {
                return Collections.EMPTY_MAP;
            }
            HashMap<String, IVersionableHandle> result = new HashMap<String, IVersionableHandle>();
            for (Map.Entry<String, FileAreaUpdate> entry : map.entrySet()) {
                if (!this.includeVersionable(entry.getValue())) continue;
                result.put(entry.getKey(), entry.getValue().getItem());
            }
            return result;
        }

        private boolean includeVersionable(FileAreaUpdate fileAreaUpdate) {
            if (this.failedFetches == null) {
                return true;
            }
            if (fileAreaUpdate.getOptionalContent() == null) {
                return true;
            }
            return !this.failedFetches.contains(fileAreaUpdate.getItem().getItemId());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void downloadStreamAcquired(IFileItemHandle handle, IFileContent content, InputStream in) throws TeamRepositoryException {
            ContentHash hash;
            try {
                try {
                    if (this.transformsContentsSet) {
                        FileAreaUpdate update;
                        Map<UUID, FileAreaUpdate> map = this.inTree;
                        synchronized (map) {
                            update = this.inTree.get(handle.getItemId());
                        }
                        IFileOptions fileOptions = FileOptionsFactory.getFileOptions(true, content.getLineDelimiter(), content.getCharacterEncoding(), update.getMetadataProperties());
                        in = this.loadMutator.prepareContentsToSet(fileOptions, in);
                    }
                    hash = ContentHash.valueOf((InputStream)in);
                }
                catch (IOException e) {
                    throw new TeamRepositoryException((Throwable)e);
                }
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                }
                catch (RuntimeException runtimeException) {}
            }
            Map<UUID, ContentHash> map = this.fetchedHashes;
            synchronized (map) {
                this.fetchedHashes.put(handle.getItemId(), hash);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void downloadFailed(IFileItemHandle handle, IFileContent content, Exception e) {
            if (e instanceof VersionedContentDeleted) {
                Set<UUID> set = this.deletedContent;
                synchronized (set) {
                    this.deletedContent.add(handle.getItemId());
                }
            }
            Set<UUID> set = this.failedFetches;
            synchronized (set) {
                this.failedFetches.add(handle.getItemId());
            }
        }

        public ContentHash getHash(FileAreaUpdate update, InverseFileItemInfo oldInfo) {
            if (this.needsHashes || this.transformsContentsSet) {
                if (this.transformsContentsSet || update.getOptionalContent().getLineDelimiter() == FileLineDelimiter.LINE_DELIMITER_PLATFORM) {
                    if (oldInfo != null && update.afterState().sameStateId((IItemHandle)oldInfo.getVersionableHandle())) {
                        return oldInfo.getHash();
                    }
                    ContentHash hash = this.fetchedHashes.get(update.getItem().getItemId());
                    if (hash == null) {
                        if (this.deletedContent.contains(update.getItem().getItemId())) {
                            return update.getOptionalContent().getHash();
                        }
                        if (!this.failedFetches.contains(update.getItem().getItemId())) {
                            this.failedFetches.add(update.getItem().getItemId());
                            LoggingHelper.log(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)"Content was required but not fetched for file ''{0}''", (Object)update.getName())));
                        }
                    }
                    return hash;
                }
                return update.getOptionalContent().getHash();
            }
            return update.getOptionalContent().getHash();
        }

        public boolean hasFailedFetches() {
            return this.failedFetches != null && !this.failedFetches.isEmpty();
        }

        public Map<UUID, FileAreaUpdate> getInTree() {
            return this.inTree;
        }

        static /* synthetic */ Set access$0(TreeBuilder treeBuilder) {
            return treeBuilder.failedFetches;
        }
    }
}

