/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocalConflict;
import com.ibm.team.filesystem.client.IResolveLocalConflictsAsMergedOperation;
import com.ibm.team.filesystem.client.internal.localchanges.LocalConflictManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalConflictTracker;
import com.ibm.team.filesystem.client.internal.operations.AbstractResolveLocalConflictsOperation;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;

public class ResolveLocalConflictsAsMergedOperation
extends AbstractResolveLocalConflictsOperation
implements IResolveLocalConflictsAsMergedOperation {
    public ResolveLocalConflictsAsMergedOperation() {
        super(new DilemmaHandler());
    }

    @Override
    protected void doExecute(Collection<ILocalConflict> conflictsForSameComponent, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        LocalConflictTracker tracker = null;
        for (ILocalConflict conflict : conflictsForSameComponent) {
            if (tracker == null) {
                tracker = LocalConflictManager.getInstance().findTracker(conflict.getContextHandle(), conflict.getComponent(), conflict.getSandbox().getRoot(), monitor);
                LocalConflictManager.getInstance().endUpdateOperation(conflict.getContextHandle(), conflict.getComponent(), conflict.getSandbox().getRoot());
                if (tracker == null) continue;
            }
            tracker.remove(conflict.getItemID());
        }
    }
}

