/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.operations.UpdateOperation;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.ILogicalConflictReport;
import com.ibm.team.filesystem.common.internal.dto.ConflictResolutionReport;
import com.ibm.team.filesystem.common.internal.dto.Resolution;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class ResolveConflictsOperation
extends FileSystemOperation {
    protected IWorkspaceConnection connection;
    protected ILogicalConflictReport conflictReport;
    private Log log;

    public ResolveConflictsOperation(UpdateDilemmaHandler dilemmaHandler) {
        super(dilemmaHandler == null ? UpdateDilemmaHandler.getDefault() : dilemmaHandler);
        this.initializeLogging();
    }

    public void setContext(IWorkspaceConnection connection, ILogicalConflictReport conflictReport) {
        if (connection == null) {
            throw new IllegalArgumentException();
        }
        if (conflictReport == null) {
            throw new IllegalArgumentException();
        }
        this.connection = connection;
        this.conflictReport = conflictReport;
    }

    protected final boolean isContextSet() {
        return this.connection != null;
    }

    protected final IWorkspaceConnection getConnection() {
        return this.connection;
    }

    protected abstract Collection<ILogicalChange> getChanges();

    public Collection<ILogicalChange> getRequiredChanges() {
        HashSet<ILogicalChange> changesSeen = new HashSet<ILogicalChange>();
        HashSet<ILogicalChange> requiredChanges = new HashSet<ILogicalChange>();
        this.accumulateRequiredChanges(this.getChanges(), changesSeen, requiredChanges);
        return requiredChanges;
    }

    private void accumulateRequiredChanges(Collection<ILogicalChange> changesToExamine, HashSet<ILogicalChange> changesSeen, HashSet<ILogicalChange> requiredChanges) {
        for (ILogicalChange change : changesToExamine) {
            if (changesSeen.contains(change)) continue;
            changesSeen.add(change);
            if (!(change.kind() != 1 && change.kind() != 2 || this.getChanges().contains(change) || this.shouldExcludeRequiredChange(change, requiredChanges))) {
                requiredChanges.add(change);
            }
            List<ILogicalChange> moreChangesToExamine = this.getRequiredChanges(change);
            this.accumulateRequiredChanges(moreChangesToExamine, changesSeen, requiredChanges);
        }
    }

    private List<ILogicalChange> getRequiredChanges(ILogicalChange change) {
        List requiredChanges = this.conflictReport.getRequiredChanges(change);
        if (this.isTracingEnabled() && !requiredChanges.isEmpty()) {
            for (ILogicalChange requiredChange : requiredChanges) {
                this.trace("Change: " + change.toString() + " requires: " + requiredChange.toString());
            }
        }
        return requiredChanges;
    }

    protected boolean shouldExcludeRequiredChange(ILogicalChange change, HashSet<ILogicalChange> requiredChanges) {
        return false;
    }

    protected void updateCopyFileArea(ConflictResolutionReport conflictResolutionReport, UpdateDilemmaHandler problemHandler, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        ArrayList<IUpdateReport> updateReports = new ArrayList<IUpdateReport>(conflictResolutionReport.getResolutions().size());
        for (Resolution resolution : conflictResolutionReport.getResolutions()) {
            updateReports.add(resolution.getUpdateReport());
        }
        this.updateCopyFileArea(updateReports, problemHandler, monitor);
    }

    protected void updateCopyFileArea(List<IUpdateReport> updateReports, UpdateDilemmaHandler problemHandler, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        UpdateOperation op = new UpdateOperation(this.connection, updateReports, 3, problemHandler, null);
        this.disableVerifyInSync(op);
        op.run(monitor);
    }

    protected boolean isTracingEnabled() {
        return this.log != null && this.log.isTraceEnabled();
    }

    protected void trace(String message) {
        if (this.log != null) {
            this.log.trace((Object)message);
        }
    }

    private void initializeLogging() {
        Log log = LoggingHelper.getLog(ResolveConflictsOperation.class);
        this.log = log != null && log.isTraceEnabled() ? log : null;
    }
}

