/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.FileUploadHandler;
import com.ibm.team.filesystem.client.IFileContentManagerSession;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.IFileContentMerger;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.MetadataProperties;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.internal.checkin.ChangeSetChooser;
import com.ibm.team.filesystem.client.internal.operations.AutoResolveOperation;
import com.ibm.team.filesystem.client.internal.operations.FailedAutoResolveRequest;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.ILogicalConflictReport;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.common.internal.FileContent;
import com.ibm.team.filesystem.common.internal.FileItem;
import com.ibm.team.filesystem.common.internal.FilesystemFactory;
import com.ibm.team.filesystem.common.internal.SymbolicLink;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.common.utils.TemporaryOutputStream;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.content.AbstractVersionedContentManagerInputStreamProvider;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.internal.Folder;
import com.ibm.team.scm.common.internal.ScmFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;

public class RemoteAutoResolver {
    private IWorkspaceConnection workspace;
    private IComponentHandle component;
    private AutoResolveOperation.AutoResolveRequest conflict;
    private IVersionable current;
    private IVersionable ancestor;
    private IVersionable proposed;
    private boolean canResolve = true;
    private boolean hasChange = false;
    private IVersionable newCurrent;
    private OutputStream mergedContent;
    private String mergedContentType;
    private String mergedEncoding;
    private FileLineDelimiter mergedLineDelimiter;
    private IFileContent uploadedContent;
    private FailedAutoResolveRequest failureReport;

    public RemoteAutoResolver(IWorkspaceConnection workspace, AutoResolveOperation.AutoResolveRequest conflict, IComponentHandle component, IVersionable current, IVersionable ancestor, IVersionable proposed) {
        this.workspace = workspace;
        this.conflict = conflict;
        this.component = component;
        this.current = current;
        this.ancestor = ancestor;
        this.proposed = proposed;
    }

    private void createNewCurrent() {
        IFolderHandle parent;
        String name = this.current.getName();
        if (this.ancestor == null) {
            if (this.canResolve) {
                this.canResolve = name.equals(this.proposed.getName());
            }
        } else if (this.current.getName().equals(this.ancestor.getName())) {
            if (!this.proposed.getName().equals(name)) {
                name = this.proposed.getName();
                this.hasChange = true;
            }
        } else if (!this.proposed.getName().equals(this.ancestor.getName()) && !this.proposed.getName().equals(this.current.getName())) {
            this.canResolve = false;
        }
        if ((parent = this.current.getParent()) != null) {
            if (this.ancestor == null) {
                if (this.canResolve) {
                    this.canResolve = parent.sameItemId((IItemHandle)this.proposed.getParent());
                }
            } else if (this.current.getParent().sameItemId((IItemHandle)this.ancestor.getParent())) {
                if (!this.proposed.getParent().sameItemId((IItemHandle)parent)) {
                    parent = this.proposed.getParent();
                    this.hasChange = true;
                }
            } else if (!this.proposed.getParent().sameItemId((IItemHandle)this.ancestor.getParent()) && !this.proposed.getParent().sameItemId((IItemHandle)this.current.getParent())) {
                this.canResolve = false;
            }
        }
        Map commonProperties = this.ancestor == null ? new HashMap() : this.ancestor.getUserProperties();
        Map proposedProperties = this.proposed.getUserProperties();
        HashMap<String, String> currentProperties = new HashMap<String, String>(this.current.getUserProperties());
        MetadataProperties proposedDelta = new MetadataProperties(commonProperties, proposedProperties);
        for (Map.Entry<String, String> proposedEntry : proposedDelta.getChangedProperties().entrySet()) {
            String currentValue;
            String propertyName = proposedEntry.getKey();
            String proposedValue = proposedEntry.getValue();
            if (proposedValue.equals(currentValue = (String)currentProperties.get(propertyName))) continue;
            String commonValue = (String)commonProperties.get(propertyName);
            if (commonValue == null && currentValue == null) {
                currentProperties.put(propertyName, proposedValue);
                this.hasChange = true;
                continue;
            }
            if (commonValue != null && commonValue.equals(currentValue)) {
                currentProperties.put(propertyName, proposedValue);
                this.hasChange = true;
                continue;
            }
            this.canResolve = false;
        }
        for (String propertyName : proposedDelta.getRemovedProperties()) {
            String currentValue = (String)currentProperties.get(propertyName);
            if (currentValue == null) continue;
            String commonValue = (String)commonProperties.get(propertyName);
            if (!currentValue.equals(commonValue)) {
                this.canResolve = false;
                continue;
            }
            currentProperties.remove(propertyName);
            this.hasChange = true;
        }
        if (this.current instanceof IFolderHandle) {
            Folder folder = ScmFactory.eINSTANCE.createFolder();
            folder.initNew();
            folder.setItemId(this.current.getItemId());
            folder.setParent(parent);
            folder.setName(name);
            folder.getProperties().putAll(currentProperties);
            this.newCurrent = folder;
        } else if (this.current instanceof IFileItemHandle) {
            IFileItem currentFile = (IFileItem)this.current;
            IFileItem proposedFile = (IFileItem)this.proposed;
            IFileItem ancestorFile = (IFileItem)this.ancestor;
            FileItem file = FilesystemFactory.eINSTANCE.createFileItem();
            file.initNew();
            file.setItemId(this.current.getItemId());
            file.setParent(parent);
            file.setName(name);
            file.getProperties().putAll(currentProperties);
            file.setExecutable(currentFile.isExecutable());
            if (ancestorFile == null) {
                if (this.canResolve) {
                    this.canResolve = currentFile.isExecutable() == proposedFile.isExecutable();
                }
            } else if (currentFile.isExecutable() != proposedFile.isExecutable() && ancestorFile.isExecutable() == currentFile.isExecutable()) {
                file.setExecutable(proposedFile.isExecutable());
                this.hasChange = true;
            }
            file.setFileTimestamp(new Date());
            if (this.uploadedContent != null) {
                file.setContent(this.uploadedContent);
                file.setContentType(this.mergedContentType);
            } else {
                FileContent currentContent = (FileContent)currentFile.getContent();
                FileContent content = FilesystemFactory.eINSTANCE.createFileContent();
                content.setPredecessorHint(currentContent.getPredecessorHintHash());
                content.setLineDelimiter(currentContent.getLineDelimiter());
                content.setSize(currentContent.getSize());
                content.setCharacterEncoding(currentContent.getCharacterEncoding());
                content.setHash(currentContent.getHash());
                content.setLineDelimiterCount(currentContent.getLineDelimiterCount());
                content.setOriginalContainingState(currentContent.getOriginalContainingState());
                file.setContent((IFileContent)content);
                file.setContentType(currentFile.getContentType());
                if (ancestorFile != null && !proposedFile.getContentType().equals(ancestorFile.getContentType()) && currentFile.getContentType().equals(ancestorFile.getContentType())) {
                    file.setContentType(proposedFile.getContentType());
                    this.hasChange = true;
                } else if (!proposedFile.getContentType().equals(currentFile.getContentType()) || ancestorFile == null) {
                    this.canResolve = false;
                }
            }
            this.newCurrent = file;
        } else if (this.current instanceof ISymbolicLinkHandle) {
            ISymbolicLink currentLink = (ISymbolicLink)this.current;
            ISymbolicLink proposedLink = (ISymbolicLink)this.proposed;
            ISymbolicLink ancestorLink = (ISymbolicLink)this.ancestor;
            SymbolicLink symbolicLink = FilesystemFactory.eINSTANCE.createSymbolicLink();
            symbolicLink.initNew();
            symbolicLink.setItemId(this.current.getItemId());
            symbolicLink.setParent(parent);
            symbolicLink.setName(name);
            symbolicLink.setLinkTimestamp(new Date());
            symbolicLink.getProperties().putAll(currentProperties);
            symbolicLink.setTarget(currentLink.getTarget());
            symbolicLink.setIsDirectoryLink(currentLink.isDirectoryLink());
            if (ancestorLink == null) {
                if (this.canResolve) {
                    this.canResolve = currentLink.getTarget().equals(proposedLink.getTarget()) && currentLink.isDirectoryLink() == proposedLink.isDirectoryLink();
                }
            } else if (!proposedLink.getTarget().equals(ancestorLink.getTarget())) {
                if (currentLink.getTarget().equals(ancestorLink.getTarget())) {
                    symbolicLink.setTarget(proposedLink.getTarget());
                    symbolicLink.setIsDirectoryLink(proposedLink.isDirectoryLink());
                    this.hasChange = true;
                } else if (!currentLink.getTarget().equals(proposedLink.getTarget())) {
                    this.canResolve = false;
                }
            } else if (proposedLink.isDirectoryLink() != ancestorLink.isDirectoryLink() && ancestorLink.isDirectoryLink() == currentLink.isDirectoryLink()) {
                symbolicLink.setIsDirectoryLink(proposedLink.isDirectoryLink());
                this.hasChange = true;
            }
            this.newCurrent = symbolicLink;
        }
    }

    public boolean canBeResolved() {
        return this.canResolve;
    }

    public boolean prepareCommit(ChangeSetChooser changeSetChooser, IProgressMonitor monitor) throws TeamRepositoryException {
        this.createNewCurrent();
        if (this.hasChange) {
            IWorkspaceConnection.IConfigurationOpFactory opFactory = this.workspace.configurationOpFactory();
            changeSetChooser.toCommit(this.component, (IVersionableHandle)this.newCurrent, (IWorkspaceConnection.IConfigurationOp)opFactory.save(this.newCurrent), monitor);
        }
        return this.hasChange;
    }

    public ILogicalChange getLogicalChange() {
        return this.conflict.getLogicalChange();
    }

    public boolean mergeContent(IFileContentMerger fileContentMerger, IProgressMonitor monitor) throws FileSystemException, IOException {
        if (!(this.proposed instanceof IFileItem)) {
            return false;
        }
        IFileItem proposedFile = (IFileItem)this.proposed;
        IFileItem ancestorFile = (IFileItem)this.ancestor;
        IFileItem currentFile = (IFileItem)this.current;
        if (ancestorFile != null && this.sameContent(proposedFile.getContent(), ancestorFile.getContent())) {
            return false;
        }
        OutputStream outputStream = RemoteAutoResolver.getTempOutputStream(proposedFile.getContent().getRawLength());
        boolean keepStream = false;
        try {
            IPath path = PathUtils.getPath(this.conflict.getLogicalChange().getPathHint());
            String contentTyeForMerge = null;
            if (this.failureReport != null) {
                contentTyeForMerge = this.failureReport.getDefaultContentTypeMerger();
            }
            IStatus status = fileContentMerger.performAutoMerge(this.workspace.teamRepository(), ancestorFile, proposedFile, currentFile, outputStream, path, contentTyeForMerge, monitor);
            outputStream.close();
            if (status.isOK()) {
                this.hasChange = true;
                keepStream = true;
                this.rememberMergedContent(outputStream);
                return true;
            }
            if (this.failureReport == null && status.getCode() == 1002) {
                this.failureReport = new FailedAutoResolveRequest(this.conflict, 1002, null, new RelativeLocation(path.segments()), this.component, (IVersionableHandle)this.current.getItemHandle(), true, this);
            } else if (this.failureReport == null && status.getCode() == 1001) {
                this.failureReport = new FailedAutoResolveRequest(this.conflict, 1001, null, new RelativeLocation(path.segments()), this.component, (IVersionableHandle)this.current.getItemHandle(), true, this);
            } else {
                this.canResolve = false;
            }
            return false;
        }
        finally {
            if (!keepStream) {
                RemoteAutoResolver.cleanUpTempStreams(outputStream);
            }
        }
    }

    public FailedAutoResolveRequest getFailureReport() {
        return this.failureReport;
    }

    private boolean sameContent(IFileContent content1, IFileContent content2) {
        if (!content1.getHash().equals((Object)content2.getHash())) {
            return false;
        }
        if (!content1.getLineDelimiter().equals((Object)content2.getLineDelimiter())) {
            return false;
        }
        return this.equalEncodings(content1.getCharacterEncoding(), content2.getCharacterEncoding());
    }

    private void rememberMergedContent(OutputStream outputStream) {
        this.mergedContent = outputStream;
        IFileItem proposedFile = (IFileItem)this.proposed;
        IFileItem ancestorFile = (IFileItem)this.ancestor;
        IFileItem currentFile = (IFileItem)this.current;
        this.mergedContentType = currentFile.getContentType();
        this.mergedEncoding = currentFile.getContent().getCharacterEncoding();
        this.mergedLineDelimiter = currentFile.getContent().getLineDelimiter();
        if (ancestorFile == null) {
            if (!currentFile.getContentType().equals(proposedFile.getContentType())) {
                this.canResolve = false;
            }
            if (!this.equalEncodings(proposedFile.getContent().getCharacterEncoding(), currentFile.getContent().getCharacterEncoding())) {
                this.canResolve = false;
            }
            if (!proposedFile.getContent().getLineDelimiter().equals((Object)currentFile.getContent().getLineDelimiter())) {
                this.canResolve = false;
            }
        } else {
            if (!proposedFile.getContentType().equals(ancestorFile.getContentType())) {
                if (currentFile.getContentType().equals(ancestorFile.getContentType())) {
                    this.mergedContentType = proposedFile.getContentType();
                } else if (!currentFile.getContentType().equals(proposedFile.getContentType())) {
                    this.canResolve = false;
                }
            }
            if (!this.equalEncodings(proposedFile.getContent().getCharacterEncoding(), ancestorFile.getContent().getCharacterEncoding())) {
                if (this.equalEncodings(ancestorFile.getContent().getCharacterEncoding(), currentFile.getContent().getCharacterEncoding())) {
                    this.mergedEncoding = proposedFile.getContent().getCharacterEncoding();
                } else if (!this.equalEncodings(proposedFile.getContent().getCharacterEncoding(), currentFile.getContent().getCharacterEncoding())) {
                    this.canResolve = false;
                }
            }
            if (!proposedFile.getContent().getLineDelimiter().equals((Object)ancestorFile.getContent().getLineDelimiter())) {
                if (ancestorFile.getContent().getLineDelimiter().equals((Object)currentFile.getContent().getLineDelimiter())) {
                    this.mergedLineDelimiter = proposedFile.getContent().getLineDelimiter();
                } else if (!proposedFile.getContent().getLineDelimiter().equals((Object)currentFile.getContent().getLineDelimiter())) {
                    this.canResolve = false;
                }
            }
        }
    }

    private boolean equalEncodings(String encoding1, String encoding2) {
        if (encoding1 == encoding2) {
            return true;
        }
        if (encoding1 == null || encoding2 == null) {
            return false;
        }
        return encoding1.equals(encoding2);
    }

    public void dispose() {
        if (this.mergedContent != null) {
            RemoteAutoResolver.cleanUpTempStreams(this.mergedContent);
        }
    }

    private static OutputStream getTempOutputStream(long estimatedSize) {
        try {
            return TemporaryOutputStream.getEstimatedSizeTemporaryOutputStream((long)estimatedSize);
        }
        catch (IOException e) {
            LoggingHelper.log(FileSystemStatusUtil.getStatusFor(e));
            return new ByteArrayOutputStream();
        }
    }

    private static InputStream getTempInputStream(OutputStream out, IProgressMonitor monitor) throws IOException {
        if (out instanceof ByteArrayOutputStream) {
            ByteArrayOutputStream baos = (ByteArrayOutputStream)out;
            baos.close();
            return new ByteArrayInputStream(baos.toByteArray());
        }
        if (out instanceof IInputStreamProvider) {
            IInputStreamProvider isp = (IInputStreamProvider)out;
            return isp.getInputStream(monitor);
        }
        throw new IllegalStateException();
    }

    private static void cleanUpTempStreams(OutputStream outputStream) {
        if (outputStream instanceof TemporaryOutputStream) {
            TemporaryOutputStream tos = (TemporaryOutputStream)outputStream;
            try {
                tos.dispose();
            }
            catch (IOException e) {
                LoggingHelper.log(FileSystemStatusUtil.getStatusFor(e));
            }
        }
    }

    public boolean hasContentToUpload() {
        return this.mergedContent != null;
    }

    public void uploadContent(IFileContentManagerSession session) throws TeamRepositoryException {
        session.storeContent(this.getUploadHandler());
    }

    private FileUploadHandler getUploadHandler() {
        return new FileUploadHandler(){

            public AbstractVersionedContentManagerInputStreamProvider getStreamProvider() throws TeamRepositoryException {
                return new AbstractVersionedContentManagerInputStreamProvider(){

                    public InputStream wrapInputStream(InputStream in) throws IOException, TeamRepositoryException {
                        return in;
                    }

                    public InputStream getInputStream(int flags) throws IOException, TeamRepositoryException {
                        return RemoteAutoResolver.getTempInputStream(RemoteAutoResolver.this.mergedContent, (IProgressMonitor)SubMonitor.convert(null));
                    }

                    public void dispose() throws IOException, TeamRepositoryException {
                        RemoteAutoResolver.cleanUpTempStreams(RemoteAutoResolver.this.mergedContent);
                    }
                };
            }

            public ContentHash getPredecessorHintHash() throws TeamRepositoryException {
                return ((IFileItem)RemoteAutoResolver.this.current).getContent().getHash();
            }

            @Override
            protected FileLineDelimiter getLineDelimiter() throws TeamRepositoryException {
                return RemoteAutoResolver.this.mergedLineDelimiter;
            }

            @Override
            protected String getEncoding() throws TeamRepositoryException {
                return RemoteAutoResolver.this.mergedEncoding;
            }

            @Override
            protected String getContentType() throws TeamRepositoryException {
                return RemoteAutoResolver.this.mergedContentType;
            }

            @Override
            protected void uploadCompleted(IFileContent content) throws TeamRepositoryException {
                RemoteAutoResolver.this.uploadedContent = content;
            }
        };
    }

    public void setCanResolve(boolean canResolve) {
        this.canResolve = canResolve;
    }

    public ILogicalConflictReport getLogicalConflictReport() {
        return this.conflict.getLogicalConflictReport();
    }
}

