/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.PersistentHeapManager;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.internal.Share;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingDescriptorsMap;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.StringWrapper;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFALockUtil;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaUtil;
import com.ibm.team.filesystem.client.internal.copyfileareas.migration.MigrationUtil;
import com.ibm.team.filesystem.client.internal.core.LoadedComponentsStore;
import com.ibm.team.filesystem.client.internal.core.SharingMetadata2;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.filesystem.client.operations.IMetadataRepairOperation;
import com.ibm.team.filesystem.client.operations.MetadataRepairDilemmaHandler;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class RebuildCFAOperation
extends FileSystemOperation
implements IMetadataRepairOperation {
    private final MetadataRepairDilemmaHandler p;
    private ILocation cfaRoot;
    private final ILocation metadataRoot;
    private final IRepositoryResolver resolver;
    private final Log traceLog;

    public RebuildCFAOperation(ILocation root, ILocation metadataRoot, MetadataRepairDilemmaHandler dilemmaHandler, IRepositoryResolver resolver) {
        super(dilemmaHandler == null ? MetadataRepairDilemmaHandler.getDefault() : dilemmaHandler);
        this.p = dilemmaHandler == null ? MetadataRepairDilemmaHandler.getDefault() : dilemmaHandler;
        this.cfaRoot = root;
        this.metadataRoot = metadataRoot;
        this.resolver = resolver;
        Log log = LoggingHelper.getLog(RebuildCFAOperation.class);
        this.traceLog = log != null && log.isTraceEnabled() ? log : null;
    }

    private void traceIfEnabled(String message) {
        if (this.traceLog != null && this.traceLog.isTraceEnabled()) {
            this.traceLog.trace((Object)message);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    protected void execute(IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.RebuildCFAOperation_0, (int)101);
        rule = SharingManager.getInstance().getTrackingRule(this.cfaRoot);
        cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(this.cfaRoot);
        this.cfaRoot = cfa.getRoot();
        sandbox = SharingManager.getInstance().getSandbox(this.cfaRoot, false);
        SharingManager.getInstance().register(sandbox, true, (IProgressMonitor)progress.newChild(1));
        try {
            Job.getJobManager().beginRule(rule, (IProgressMonitor)progress.newChild(1));
            lock = CFALockUtil.createAndLockSuperExclusive(this.cfaRoot, (IProgressMonitor)progress.newChild(1));
            try {
                unsetWorkspaceComponentState = false;
                exceptions = new ArrayList<Object>();
                try {
                    try {
                        block104: {
                            block103: {
                                block106: {
                                    metadata = cfa.internalGetMetadata();
                                    progress.setTaskName(Messages.RebuildCFAOperation_1);
                                    if (CopyFileAreaManager.instance.hasOldMetaDataFolder(this.cfaRoot)) {
                                        path = (IPath)this.metadataRoot.getAdapter(IPath.class);
                                        try {
                                            sharingDescriptors = MigrationUtil.readOldSharingDescriptors(this.cfaRoot);
                                            subProgress = progress.newChild(1);
                                            subProgress.setWorkRemaining(sharingDescriptors.length);
                                            var16_19 = sharingDescriptors;
                                            var15_26 = sharingDescriptors.length;
                                            var14_31 = 0;
                                            while (var14_31 < var15_26) {
                                                sharingInfoWrapper = var16_19[var14_31];
                                                sharePath = sharingInfoWrapper.path;
                                                sharingDescriptor = metadata.getSharingDescriptor(sharePath);
                                                if (sharingDescriptor == null) {
                                                    desc = sharingInfoWrapper.getSharingDescriptor();
                                                    shareRoot = sandbox.findShareable(sharePath, ResourceType.getResourceType(desc.getRootVersionable()));
                                                    if (shareRoot.exists((IProgressMonitor)subProgress.newChild(1))) {
                                                        if (RebuildCFAOperation.isLoggedInToRepo(this.resolver, (ISharingDescriptor)desc)) {
                                                            metadata.setSharingDescriptor(sharePath, (ISharingDescriptor)desc, (IProgressMonitor)subProgress.newChild(1));
                                                        } else {
                                                            RebuildCFAOperation.ensureUnshared(this.cfaRoot, sharePath, subProgress.newChild(1));
                                                            exceptions.add((Object)new FileSystemException(NLS.bind((String)Messages.RebuildCFAOperation_RepositoryNotLoggedIn, (Object[])new Object[]{sharePath.toString(), this.cfaRoot.toOSString()})));
                                                        }
                                                    } else {
                                                        exceptions.add((Object)new FileSystemException(NLS.bind((String)Messages.RebuildCFAOperation_FolderNotInSandbox, (Object)sharePath.toString(), (Object)this.cfaRoot.toOSString())));
                                                    }
                                                } else {
                                                    exceptions.add((Object)new FileSystemStatusException(FileSystemStatusUtil.getStatusFor(2, NLS.bind((String)Messages.RebuildCFAOperation_FolderAlreadySharedInSandbox, (Object)sharePath.toString(), (Object)this.cfaRoot.toOSString()), null)));
                                                }
                                                ++var14_31;
                                            }
                                            subProgress.done();
                                            RebuildCFAOperation.delete(path.toFile());
                                        }
                                        catch (IOException e) {
                                            throw new FileSystemException(NLS.bind((String)Messages.RebuildCFAOperation_ErrorReadingOldMetadata, (Object)path.toOSString()), e);
                                        }
                                    }
                                    if (!CopyFileAreaManager.instance.hasInterumMetadataFolder(this.cfaRoot)) break block106;
                                    try {
                                        block102: {
                                            metadataPath = (IPath)this.metadataRoot.getAdapter(IPath.class);
                                            descPath = metadataPath.append(".descriptors.dat");
                                            descriptorsMap = new SharingDescriptorsMap(descPath.toFile(), metadata.isCaseSensitive());
                                            subProgress = progress.newChild(1);
                                            subProgress.setWorkRemaining(descriptorsMap.size());
                                            i = descriptorsMap.entrySet().iterator();
                                            while (true) lbl-1000:
                                            // 6 sources

                                            {
                                                try {
                                                    e = (Map.Entry)i.next();
                                                }
                                                catch (NoSuchElementException ex) {
                                                    break block102;
                                                }
                                                catch (OperationCanceledException ex) {
                                                    throw ex;
                                                }
                                                catch (Exception ex) {
                                                    exceptions.add(ex);
                                                    break block102;
                                                }
                                                try {
                                                    path = ((StringWrapper)e.getKey()).toString();
                                                    descriptor = (ISharingDescriptor)e.getValue();
                                                    sharePath = new RelativeLocation(new Path(path).segments());
                                                    sharingDescriptor = metadata.getSharingDescriptor(sharePath);
                                                    if (sharingDescriptor == null) {
                                                        shareable = sandbox.findShareable(sharePath, ResourceType.getResourceType(descriptor.getRootVersionable()));
                                                        if (shareable.exists((IProgressMonitor)subProgress.newChild(1))) {
                                                            if (RebuildCFAOperation.isLoggedInToRepo(this.resolver, descriptor)) {
                                                                metadata.setSharingDescriptor(sharePath, descriptor, (IProgressMonitor)subProgress.newChild(1));
                                                            }
                                                            RebuildCFAOperation.ensureUnshared(this.cfaRoot, sharePath, subProgress.newChild(1));
                                                            exceptions.add((Object)new FileSystemException(NLS.bind((String)Messages.RebuildCFAOperation_RepositoryNotLoggedIn, (Object[])new Object[]{sharePath.toString(), this.cfaRoot.toOSString()})));
                                                        }
                                                        exceptions.add((Object)new FileSystemException(NLS.bind((String)Messages.RebuildCFAOperation_FolderNotInSandbox, (Object)sharePath.toString(), (Object)this.cfaRoot.toOSString())));
                                                    }
                                                    exceptions.add((Object)new FileSystemStatusException(FileSystemStatusUtil.getStatusFor(2, NLS.bind((String)Messages.RebuildCFAOperation_FolderAlreadySharedInSandbox, (Object)sharePath.toString(), (Object)this.cfaRoot.toOSString()), null)));
                                                }
                                                catch (OperationCanceledException ex) {
                                                    throw ex;
                                                }
                                                catch (Exception ex) {
                                                    exceptions.add(ex);
                                                    continue;
                                                }
                                                break;
                                            }
                                            ** GOTO lbl-1000
                                            finally {
                                                descriptorsMap.close();
                                            }
                                        }
                                        subProgress.done();
                                        RebuildCFAOperation.delete(metadataPath.toFile());
                                    }
                                    catch (OperationCanceledException ex) {
                                        throw ex;
                                    }
                                    catch (Exception ex) {
                                        exceptions.add(ex);
                                    }
                                }
                                metadata.close();
                                descriptors = new HashMap<RootKey, ISharingDescriptor>();
                                roots = new HashMap<RootKey, String>();
                                try {
                                    metadataPath = (IPath)this.metadataRoot.getAdapter(IPath.class);
                                    descPath = metadataPath.append(".descriptors.dat");
                                    descriptorsMap = new SharingDescriptorsMap(descPath.toFile(), metadata.isCaseSensitive());
                                    subProgress = progress.newChild(1);
                                    subProgress.setWorkRemaining(descriptorsMap.size() * 4);
                                    i = descriptorsMap.entrySet().iterator();
                                    while (true) lbl-1000:
                                    // 6 sources

                                    {
                                        try {
                                            e = (Map.Entry)i.next();
                                        }
                                        catch (NoSuchElementException ex) {
                                            break block103;
                                        }
                                        catch (OperationCanceledException ex) {
                                            throw ex;
                                        }
                                        catch (Exception ex) {
                                            exceptions.add(ex);
                                            break block103;
                                        }
                                        try {
                                            path = ((StringWrapper)e.getKey()).toString();
                                            descriptor = (ISharingDescriptor)e.getValue();
                                            r = new RootKey(descriptor.getConnectionHandle().getItemId(), descriptor.getComponent().getItemId(), descriptor.getRootVersionable().getItemId());
                                            otherPath = roots.put(r, path);
                                            if (otherPath == null) {
                                                descriptors.put(r, descriptor);
                                            }
                                            otherShareable = sandbox.findShareable(new RelativeLocation(new Path(null, otherPath).segments()), ResourceType.FOLDER);
                                            if (!otherShareable.exists((IProgressMonitor)subProgress.newChild(1)) || otherShareable.getResourceType((IProgressMonitor)subProgress.newChild(1)) != ResourceType.FOLDER) {
                                                newShareable = sandbox.findShareable(new RelativeLocation(new Path(null, path).segments()), ResourceType.FOLDER);
                                                if (newShareable.exists((IProgressMonitor)subProgress.newChild(1)) && newShareable.getResourceType((IProgressMonitor)subProgress.newChild(1)) == ResourceType.FOLDER) {
                                                    descriptors.put(r, descriptor);
                                                    exceptions.add(new Exception(NLS.bind((String)Messages.RebuildCFAOperation_4, (Object)otherPath, (Object)path)));
                                                }
                                                roots.put(r, otherPath);
                                                exceptions.add(new Exception(NLS.bind((String)Messages.RebuildCFAOperation_4, (Object)path, (Object)otherPath)));
                                            }
                                            roots.put(r, otherPath);
                                            exceptions.add(new Exception(NLS.bind((String)Messages.RebuildCFAOperation_4, (Object)path, (Object)otherPath)));
                                        }
                                        catch (OperationCanceledException ex) {
                                            throw ex;
                                        }
                                        catch (Exception ex) {
                                            exceptions.add(ex);
                                            continue;
                                        }
                                        break;
                                    }
                                    ** GOTO lbl-1000
                                    finally {
                                        descriptorsMap.close();
                                    }
                                }
                                catch (OperationCanceledException ex) {
                                    throw ex;
                                }
                                catch (Exception ex) {
                                    exceptions.add(ex);
                                }
                            }
                            loaded = new ArrayList<Object>();
                            try {
                                metadataPath = (IPath)this.metadataRoot.getAdapter(IPath.class);
                                descPath = metadataPath.append(".components");
                                mgr = new PersistentHeapManager();
                                componentsMap = new LoadedComponentsStore(mgr, descPath.toFile());
                                i = componentsMap.entrySet().iterator();
                                while (true) lbl-1000:
                                // 3 sources

                                {
                                    try {
                                        e = (Map.Entry)i.next();
                                    }
                                    catch (NoSuchElementException ex) {
                                        break block104;
                                    }
                                    catch (OperationCanceledException ex) {
                                        throw ex;
                                    }
                                    catch (Exception ex) {
                                        exceptions.add(ex);
                                        break block104;
                                    }
                                    try {
                                        desc = (LoadedConfigurationDescriptor)e.getValue();
                                        loaded.add(desc);
                                    }
                                    catch (OperationCanceledException ex) {
                                        throw ex;
                                    }
                                    catch (Exception ex) {
                                        exceptions.add(ex);
                                        continue;
                                    }
                                    break;
                                }
                                ** GOTO lbl-1000
                                finally {
                                    componentsMap.close();
                                }
                            }
                            catch (OperationCanceledException ex) {
                                throw ex;
                            }
                            catch (Exception ex) {
                                exceptions.add(ex);
                            }
                        }
                        progress.worked(1);
                        progress.setTaskName(Messages.RebuildCFAOperation_5);
                        if (roots.isEmpty()) {
                            this.p.noDescriptorsFound();
                        }
                        metadata.clear();
                        corrupt = true;
                        try {
                            progress.worked(4);
                            managedRoots = new HashMap<String, Shareable>();
                            mgr = SharingManager.getInstance();
                            subProgress = progress.newChild(1);
                            try {
                                shareables = RebuildCFAOperation.getRootShareables(this.cfaRoot, progress.newChild(1));
                                subProgress.setWorkRemaining(shareables.size());
                                for (IShareable s : shareables) {
                                    sh = (Shareable)s;
                                    if (!sh.getFileStorage().isRepositoryProviderRegistered((IProgressMonitor)subProgress.newChild(1))) continue;
                                    managedRoots.put(sh.getLocalPath().getName(), sh);
                                }
                            }
                            catch (OperationCanceledException e) {
                                throw e;
                            }
                            catch (Exception e) {
                                exceptions.add(e);
                            }
                            subProgress.done();
                            subProgress = progress.newChild(1);
                            subProgress.setWorkRemaining(roots.size() * 2);
                            i = roots.values().iterator();
                            for (Object desc : descriptors.values()) {
                                s = sandbox.findShareable(new RelativeLocation(new Path(null, (String)i.next()).segments()), ResourceType.getResourceType(desc.getRootVersionable()));
                                managedRoots.remove(s.getLocalPath().getName());
                                cfa.setSharingInfo(s.getLocalPath(), (ISharingDescriptor)desc, (IProgressMonitor)subProgress.newChild(1));
                                try {
                                    ((Shareable)s).getFileStorage().registerRepositorProvider((IProgressMonitor)subProgress.newChild(1));
                                }
                                catch (OperationCanceledException e) {
                                    throw e;
                                }
                                catch (Exception e) {
                                    exceptions.add(e);
                                }
                            }
                            subProgress.done();
                            subProgress = progress.newChild(1);
                            subProgress.setWorkRemaining(loaded.size());
                            for (Object desc : loaded) {
                                cfa.componentLoaded((LoadedConfigurationDescriptor)desc, (IProgressMonitor)subProgress.newChild(1));
                            }
                            subProgress.done();
                            subProgress = progress.newChild(2);
                            subProgress.setWorkRemaining(managedRoots.size());
                            for (IShareable s : managedRoots.values()) {
                                try {
                                    s.getFileStorage().deregisterRepositoryProvider((IProgressMonitor)subProgress.newChild(1));
                                }
                                catch (OperationCanceledException e) {
                                    throw e;
                                }
                                catch (Exception e) {
                                    exceptions.add(e);
                                }
                            }
                            subProgress.done();
                            subProgress = progress.newChild(82);
                            subProgress.setWorkRemaining(roots.size());
                            rebuilt = 1;
                            for (String path : roots.values()) {
                                try {
                                    subSubProgress = subProgress.newChild(1);
                                    subSubProgress.setWorkRemaining(100);
                                    share = (Share)mgr.getShare(this.cfaRoot, new RelativeLocation(new Path(path).segments()), (IProgressMonitor)subSubProgress.newChild(1));
                                    subSubProgress.setTaskName(NLS.bind((String)Messages.RebuildCFAOperation_6, (Object[])new Object[]{share.getPath().toString(), rebuilt++, roots.size()}));
                                    desc = share.getSharingDescriptor();
                                    info = new InverseFileItemInfo((IVersionableHandle)desc.getRootVersionable().getItemType().createItemHandle(desc.getRootVersionable().getItemId(), null), false, -1L, null, null, false, Collections.EMPTY_MAP, null, share.getPath().getName(), null, -1L, null, null, null, null, null, -1L, null, null, -1L, false, false, false, false, Collections.EMPTY_MAP, Collections.EMPTY_SET, Collections.EMPTY_MAP, null, null);
                                    metadata.setFileItemInfo(share.getPath(), info);
                                    subSubProgress.worked(1);
                                    metadata.setFileItemInfo(info.getVersionableHandle(), desc.getComponent(), desc.getConnectionHandle(), info, (IProgressMonitor)subSubProgress.newChild(1));
                                    subSubProgress.worked(1);
                                    try {
                                        synchronizeOperation = IOperationFactory.instance.getMetadataSynchronizeOperation(this.resolver);
                                        synchronizeOperation.synchronizeRequest(share, null);
                                        synchronizeOperation.run((IProgressMonitor)subSubProgress.newChild(97));
                                    }
                                    catch (ComponentNotInWorkspaceException e) {
                                        shareable = (Shareable)share.getShareable();
                                        shareable.forget((IProgressMonitor)subSubProgress.newChild(1));
                                        throw new FileSystemException(NLS.bind((String)Messages.RebuildCFAOperation_ComponentOfShareNotInWorkspace, (Object)shareable.getFullPath().toOSString()), e);
                                    }
                                    catch (ItemNotFoundException e) {
                                        shareable = (Shareable)share.getShareable();
                                        shareable.forget((IProgressMonitor)subSubProgress.newChild(1));
                                        throw new FileSystemException(NLS.bind((String)Messages.RebuildCFAOperation_ItemNotFound, (Object)shareable.getFullPath().toOSString()), e);
                                    }
                                    catch (OperationCanceledException e) {
                                        cfa.deleteTreeInfo(share.getPath(), true, (IProgressMonitor)subSubProgress.newChild(1));
                                        throw e;
                                    }
                                    subSubProgress.done();
                                }
                                catch (OperationCanceledException e) {
                                    throw e;
                                }
                                catch (Exception e) {
                                    exceptions.add(e);
                                }
                            }
                            subProgress.done();
                            corrupt = false;
                        }
                        catch (Throwable var27_77) {
                            debugExplanation = corrupt != false ? NLS.bind((String)"Repair sandbox failed {0} ", (Object)new Date(System.currentTimeMillis()).toString()) : NLS.bind((String)"Rebuilt sandbox {0}", (Object)new Date(System.currentTimeMillis()).toString());
                            metadata.setCorrupt(corrupt, debugExplanation, null);
                            throw var27_77;
                        }
                        debugExplanation = corrupt != false ? NLS.bind((String)"Repair sandbox failed {0} ", (Object)new Date(System.currentTimeMillis()).toString()) : NLS.bind((String)"Rebuilt sandbox {0}", (Object)new Date(System.currentTimeMillis()).toString());
                        metadata.setCorrupt(corrupt, debugExplanation, null);
                        direction = 0;
                        status /* !! */  = Status.OK_STATUS;
                        switch (exceptions.size()) {
                            case 0: {
                                break;
                            }
                            case 1: {
                                e = (Exception)exceptions.get(0);
                                status /* !! */  = FileSystemStatusUtil.getStatusFor(2, Messages.RebuildCFAOperation_7, e);
                                direction = this.p.ignoredErrors(status /* !! */ );
                                break;
                            }
                            default: {
                                statuses = new IStatus[exceptions.size()];
                                idx = exceptions.size() - 1;
                                while (idx >= 0) {
                                    statuses[idx] = FileSystemStatusUtil.getStatusFor((Throwable)exceptions.get(idx));
                                    --idx;
                                }
                                status /* !! */  = new MultiStatus("com.ibm.team.filesystem.client", 0, statuses, Messages.RebuildCFAOperation_8, null){
                                    {
                                        this.setSeverity(2);
                                    }
                                };
                                direction = this.p.ignoredErrors(status /* !! */ );
                            }
                        }
                        if (direction == 1) {
                            throw new OperationCanceledException();
                        }
                        if (direction != 0) {
                            throw new FileSystemStatusException(status /* !! */ );
                        }
                        metadata.release(false);
                    }
                    catch (Exception e) {
                        unsetWorkspaceComponentState = true;
                        throw e;
                    }
                }
                finally {
                    if (unsetWorkspaceComponentState || exceptions.size() > 0) {
                        this.traceIfEnabled(NLS.bind((String)"RebuildCFAOperation#execute: There were errors while performing rebuild operation. Set the workspace component state of all the components loaded into sandbox: \"{0}\", to UNKNOWN, in the metadata.", (Object)this.cfaRoot));
                        this.updateWorkspaceComponentStateToUnknown((IProgressMonitor)progress.newChild(1));
                    } else {
                        progress.worked(1);
                    }
                }
            }
            finally {
                CopyFileAreaStore.endBatching(lock, (IProgressMonitor)progress.newChild(1));
            }
        }
        finally {
            Job.getJobManager().endRule(rule);
        }
        sm2 = (SharingMetadata2)cfa.internalGetMetadata();
        sm2.updateCaseModeFile();
        cfa.markSandboxListenerEvent(new Date());
    }

    private void updateWorkspaceComponentStateToUnknown(IProgressMonitor monitor) throws FileSystemException {
        this.traceIfEnabled("RebuildCFAOperation#updateWorkspaceComponentStateToUnknown: Start.");
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.traceIfEnabled(NLS.bind((String)"RebuildCFAOperation#updateWorkspaceComponentStateToUnknown: Processing the sandbox at location: \"{0}\".", (Object)this.cfaRoot));
        this.traceIfEnabled("RebuildCFAOperation#updateWorkspaceComponentStateToUnknown: Fetching all the loaded configuration descriptors for the sandbox.");
        Collection<LoadedConfigurationDescriptor> allLoadedComponentConfigurations = SharingManager.getInstance().allLoadedConfigurations(this.cfaRoot, (IProgressMonitor)progress.newChild(50));
        this.traceIfEnabled("RebuildCFAOperation#updateWorkspaceComponentStateToUnknown: Invoking CopyFileAreaUtil#updateWorkspaceComponentStateToUnknown().");
        CopyFileAreaUtil.updateWorkspaceComponentStateToUnknown(this.cfaRoot, allLoadedComponentConfigurations, this.traceLog, (IProgressMonitor)progress.newChild(50));
        this.traceIfEnabled("RebuildCFAOperation#updateWorkspaceComponentStateToUnknown: End.");
    }

    private static List<IShareable> getRootShareables(ILocation cfaRoot, SubMonitor newChild) {
        File[] children;
        ArrayList<IShareable> result = new ArrayList<IShareable>();
        File root = (File)cfaRoot.getAdapter(File.class);
        if (root != null && (children = root.listFiles()) != null) {
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                result.add(new Shareable(cfaRoot, (IRelativeLocation)new RelativeLocation(child.getName()), child.isDirectory() ? ResourceType.FOLDER : ResourceType.FILE));
                ++n2;
            }
        }
        return result;
    }

    private static void ensureUnshared(ILocation cfaRoot, IRelativeLocation sharePath, SubMonitor progress) throws FileSystemException {
        IFileStorage fileStorage;
        Shareable shareable = (Shareable)FileSystemCore.getSharingManager().findShareable(cfaRoot.append(sharePath), ResourceType.FOLDER);
        if (shareable != null && (fileStorage = shareable.getFileStorage()) != null) {
            fileStorage.deregisterRepositoryProvider((IProgressMonitor)progress);
        }
    }

    private static boolean isLoggedInToRepo(IRepositoryResolver resolver, ISharingDescriptor descriptor) {
        if (resolver == null) {
            ITeamRepository[] repos;
            ITeamRepositoryService service = TeamPlatform.getTeamRepositoryService();
            ITeamRepository[] iTeamRepositoryArray = repos = service.getTeamRepositories();
            int n = repos.length;
            int n2 = 0;
            while (n2 < n) {
                ITeamRepository teamRepository = iTeamRepositoryArray[n2];
                if (teamRepository.getId().equals((Object)descriptor.getRepositoryId()) && teamRepository.loggedIn()) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        try {
            ITeamRepository repository = resolver.getRepoFor(null, descriptor.getRepositoryId());
            return repository.loggedIn();
        }
        catch (TeamRepositoryException e) {
            return false;
        }
    }

    private static void delete(File file) {
        if (file.delete() && !file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] children;
            File[] fileArray = children = file.listFiles();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                RebuildCFAOperation.delete(child);
                ++n2;
            }
        }
        file.delete();
    }

    private static class RootKey {
        UUID connection;
        UUID component;
        UUID root;

        public RootKey(UUID connection, UUID component, UUID root) {
            this.connection = connection;
            this.component = component;
            this.root = root;
        }

        public int hashCode() {
            return this.connection.hashCode() ^ this.component.hashCode() ^ this.root.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof RootKey)) {
                return false;
            }
            RootKey other = (RootKey)obj;
            return this.connection.equals((Object)other.connection) && this.component.equals((Object)other.component) && this.root.equals((Object)other.root);
        }
    }
}

