/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.operations.ILoadLocation;
import com.ibm.team.filesystem.client.operations.IMultipleSandboxLoad;
import com.ibm.team.scm.client.IWorkspaceConnection;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public class MultipleSandboxLoad
implements IMultipleSandboxLoad {
    private final ConfigurationFacade configuration;
    private final Set<ISandbox> sandboxes;
    private final Set<ILoadLocation> loadLocations;
    private final IWorkspaceConnection remoteLoadConflictWorkspace;

    public MultipleSandboxLoad(ConfigurationFacade configuration, Set<ISandbox> sandboxes, Set<ILoadLocation> loadLocations) {
        this.configuration = configuration;
        this.sandboxes = sandboxes;
        this.loadLocations = loadLocations;
        this.remoteLoadConflictWorkspace = null;
    }

    public MultipleSandboxLoad(ConfigurationFacade configuration, IWorkspaceConnection remoteLoadConflictWorkspace) {
        this.configuration = configuration;
        this.sandboxes = Collections.EMPTY_SET;
        this.loadLocations = Collections.EMPTY_SET;
        this.remoteLoadConflictWorkspace = remoteLoadConflictWorkspace;
    }

    @Override
    public ConfigurationFacade getConfiguration() {
        return this.configuration;
    }

    @Override
    public Collection<ILoadLocation> getLoadLocations() {
        return this.loadLocations;
    }

    @Override
    public Collection<ISandbox> getSandboxes() {
        return this.sandboxes;
    }

    @Override
    public boolean isRemoteLoadConflict() {
        return this.remoteLoadConflictWorkspace != null;
    }

    @Override
    public IWorkspaceConnection getRemoteLoadConflictWorkspace() {
        return this.remoteLoadConflictWorkspace;
    }
}

