/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.IMarkAsMergedOperation;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileSystemManager;
import com.ibm.team.filesystem.client.internal.FileSystemServiceProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Sandbox;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreasLock;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.operations.ResolveConflictsOperation;
import com.ibm.team.filesystem.client.internal.utils.ChangeSetRefreshUtils;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICheckinOperation;
import com.ibm.team.filesystem.client.operations.IEncodingUploadFailure;
import com.ibm.team.filesystem.client.operations.ILineDelimiterUploadFailure;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.MarkAsMergedDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.internal.dto.ConflictResolutionReport;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IItemConflictReport;
import com.ibm.team.scm.common.dto.IUpdateReport;
import com.ibm.team.scm.common.internal.FetchedItems;
import com.ibm.team.scm.common.internal.gc.ExternalLinks;
import com.ibm.team.scm.common.internal.gc.LinkUtils;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.internal.util.StateId;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class MarkAsMergedOperation
extends ResolveConflictsOperation
implements IMarkAsMergedOperation {
    private final MarkAsMergedDilemmaHandler problemHandler;
    private boolean nonAtomicCommitIsAnOption = true;
    private int nonAtomicCommitFileUploadLimit = 200;
    private boolean refreshBeforeRun;
    private Collection<ILogicalChange> changes;

    public MarkAsMergedOperation(MarkAsMergedDilemmaHandler dilemmaHandler) {
        super(dilemmaHandler == null ? MarkAsMergedDilemmaHandler.getDefault() : dilemmaHandler);
        this.problemHandler = dilemmaHandler == null ? MarkAsMergedDilemmaHandler.getDefault() : dilemmaHandler;
        this.changes = new HashSet<ILogicalChange>();
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        if (this.changes.isEmpty()) {
            return;
        }
        if (!this.isContextSet()) {
            throw new IllegalStateException("Caller must configure the connection that has the conflicts");
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Collection<ILogicalChange> missingChanges = this.processDuplicateItemIDs(this.getChanges(), this.getRequiredChanges());
        if (missingChanges.size() > 0) {
            switch (this.problemHandler.missingRequiredChanges(missingChanges)) {
                case 2: {
                    throw new FileSystemException(NLS.bind((String)Messages.MarkAsMergedOperation_0, (Object)missingChanges.size()));
                }
                case 1: {
                    throw new OperationCanceledException();
                }
                case 0: {
                    this.changes.addAll(missingChanges);
                }
            }
        }
        IVerifyInSyncOperation verifyOp = IOperationFactory.instance.getVerifyInSyncOperation(this.problemHandler.getOutOfSyncDilemmaHandler());
        final HashSet configurationsToLock = NewCollection.hashSet();
        for (ILogicalChange change : this.changes) {
            verifyOp.addToVerify((IConnection)this.connection, change.component());
            configurationsToLock.add(new ConfigurationFacade((IConnection)this.connection, change.component()));
        }
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWrite(configurationsToLock, (IProgressMonitor)progress.newChild(1));
        try {
            if (this.verifyInSyncEnabled() && !this.problemHandler.getOutOfSyncDilemmaHandler().willIgnoreAllSharesOutOfSync()) {
                verifyOp.run((IProgressMonitor)progress.newChild(5));
            }
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

                @Override
                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    ICopyFileAreaLockRequest lockRequest = ICopyFileAreaManager.instance.lockRequestFactory().getLockRequest(configurationsToLock, true);
                    try {
                        ICopyFileAreasLock copyFileAreaLock = ICopyFileAreaManager.instance.lock(Collections.singleton(lockRequest), (IProgressMonitor)progress.newChild(1));
                        try {
                            MarkAsMergedOperation.this.doMarkAsMerged(configurationsToLock, (IProgressMonitor)progress.newChild(98));
                        }
                        finally {
                            copyFileAreaLock.release((IProgressMonitor)progress.newChild(1));
                        }
                    }
                    catch (FileSystemException e) {
                        throw new InvocationTargetException((Throwable)((Object)e));
                    }
                    catch (TeamRepositoryException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            this.runWithinFileSystemLock(runnableWithProgress, Messages.MarkAsMergedOperation_3, (IProgressMonitor)progress);
        }
        finally {
            WorkspaceLockUtil.release(workspaceLock);
        }
    }

    private void doMarkAsMerged(Set<ConfigurationFacade> affectedConfigurations, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        List<IUpdateReport> updateReports;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Map<ConfigurationFacade, Map<UUID, ILogicalChange>> organizedChanges = this.organizeChanges(this.getChanges());
        Map<ISandbox, Set<ConfigurationFacade>> affectedAreas = this.getCopyFileAreasAffected(affectedConfigurations, (IProgressMonitor)progress.newChild(1));
        this.checkinPendingChanges(organizedChanges, affectedAreas, this.problemHandler, (IProgressMonitor)progress.newChild(24));
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.verifyChangesMerged(organizedChanges, affectedAreas, this.problemHandler, (IProgressMonitor)progress.newChild(5));
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.checkForExternalLinkDifferences(this.problemHandler, (IProgressMonitor)progress.newChild(5));
        this.confirmMarkAsMerged(this.problemHandler);
        FileSystemServiceProxy fileSystemService = ((FileSystemManager)FileSystemCore.getFileSystemManager(this.connection.teamRepository())).getFileSystemService();
        try {
            updateReports = fileSystemService.markAsMerged(this.connection, this.changes, (IProgressMonitor)progress.newChild(20));
        }
        catch (TeamRepositoryException e) {
            if (e.getData() instanceof ConflictResolutionReport) {
                this.collectStatus(FileSystemStatusUtil.getStatusFor(4, e.getMessage(), e));
                if (e.getCause() != null) {
                    this.collectStatus(FileSystemStatusUtil.getStatusFor(4, e.getCause().getMessage()));
                }
                this.updateCopyFileArea((ConflictResolutionReport)e.getData(), (UpdateDilemmaHandler)this.problemHandler, (IProgressMonitor)progress.newChild(45));
            }
            throw e;
        }
        if (!updateReports.isEmpty()) {
            this.updateCopyFileArea(updateReports, (UpdateDilemmaHandler)this.problemHandler, (IProgressMonitor)progress.newChild(45));
        }
    }

    private void checkForExternalLinkDifferences(MarkAsMergedDilemmaHandler problemHandler, IProgressMonitor progress) throws TeamRepositoryException {
        IUpdateReport conflictReport = this.connection.conflictReport();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)conflictReport.conflicts().size());
        boolean foundLinkDifferences = false;
        for (IItemConflictReport conflict : conflictReport.conflicts()) {
            ExternalLinks proposedExternalLinks;
            IVersionableHandle selectedContributorState = conflict.getSelectedContributorState();
            IVersionableHandle proposedContributorState = conflict.getProposedContributorState();
            if (selectedContributorState == null) {
                if (proposedContributorState == null || !this.hasExternalLinks(proposedContributorState, (IProgressMonitor)monitor.newChild(1))) continue;
                foundLinkDifferences = true;
                break;
            }
            if (proposedContributorState == null) {
                if (!this.hasExternalLinks(selectedContributorState, (IProgressMonitor)monitor.newChild(1))) continue;
                foundLinkDifferences = true;
                break;
            }
            StateId selectedStateId = new StateId((IItemHandle)selectedContributorState);
            StateId proposedStateId = new StateId((IItemHandle)proposedContributorState);
            FetchedItems fetched = RepoFetcher.fetchItemsWithLinks((ITeamRepository)this.connection.teamRepository(), Arrays.asList(selectedStateId, proposedStateId), (IProgressMonitor)monitor.newChild(1));
            ExternalLinks selectedExternalLinks = fetched.getLinks(selectedStateId);
            if (LinkUtils.areUnchanged((ExternalLinks)selectedExternalLinks, (ExternalLinks)(proposedExternalLinks = fetched.getLinks(proposedStateId)))) continue;
            foundLinkDifferences = true;
            break;
        }
        if (foundLinkDifferences) {
            problemHandler.warnUnmergedRelatedArtifacts();
        }
    }

    private boolean hasExternalLinks(IVersionableHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        StateId stateId = new StateId((IItemHandle)handle);
        FetchedItems fetched = RepoFetcher.fetchItemsWithLinks((ITeamRepository)this.connection.teamRepository(), Arrays.asList(stateId), (IProgressMonitor)monitor);
        ExternalLinks externalLinks = fetched.getLinks(stateId);
        return !externalLinks.isEmpty();
    }

    private void confirmMarkAsMerged(MarkAsMergedDilemmaHandler ignoreSyncs) throws FileSystemException {
        int result = ignoreSyncs.confirmMarkAsMerged(this.changes);
        if (result == 1) {
            throw new OperationCanceledException();
        }
    }

    private Map<ConfigurationFacade, Map<UUID, ILogicalChange>> organizeChanges(Collection<ILogicalChange> changesToSort) {
        HashMap<ConfigurationFacade, Map<UUID, ILogicalChange>> result = new HashMap<ConfigurationFacade, Map<UUID, ILogicalChange>>();
        for (ILogicalChange change : changesToSort) {
            ConfigurationFacade descriptor = new ConfigurationFacade((IConnection)this.connection, change.component());
            HashMap<UUID, ILogicalChange> logicalChangesByVersionable = (HashMap<UUID, ILogicalChange>)result.get((Object)descriptor);
            if (logicalChangesByVersionable == null) {
                logicalChangesByVersionable = new HashMap<UUID, ILogicalChange>();
                result.put(descriptor, logicalChangesByVersionable);
            }
            logicalChangesByVersionable.put(change.item().getItemId(), change);
        }
        return result;
    }

    protected void verifyChangesMerged(Map<ConfigurationFacade, Map<UUID, ILogicalChange>> organizedChanges, Map<ISandbox, Set<ConfigurationFacade>> affectedAreas, MarkAsMergedDilemmaHandler problemHandler, IProgressMonitor progress) throws TeamRepositoryException, FileSystemException {
        int result;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        ArrayList unmergedChanges = NewCollection.arrayList();
        IUpdateReport conflictReport = this.connection.conflictReport();
        for (IItemConflictReport conflict : conflictReport.conflicts()) {
            ILogicalChange change;
            ConfigurationFacade descriptor;
            Map<UUID, ILogicalChange> changesToMarkAsMerged;
            boolean wasMerged = false;
            IVersionableHandle selectedContributorState = conflict.getSelectedContributorState();
            IVersionableHandle proposedContributorState = conflict.getProposedContributorState();
            IVersionableHandle originalSelectedContributorState = conflict.getOriginalSelectedContributorState();
            if (selectedContributorState == null && originalSelectedContributorState != null) {
                wasMerged = true;
            } else if (selectedContributorState != null && originalSelectedContributorState == null) {
                wasMerged = true;
            } else if (selectedContributorState == null && originalSelectedContributorState == null) {
                if (proposedContributorState == null) {
                    wasMerged = true;
                }
            } else if (!selectedContributorState.sameStateId((IItemHandle)originalSelectedContributorState)) {
                wasMerged = true;
            }
            if (wasMerged || (changesToMarkAsMerged = organizedChanges.get((Object)(descriptor = new ConfigurationFacade((IConnection)this.connection, conflict.getComponent())))) == null || !changesToMarkAsMerged.containsKey(conflict.item().getItemId()) || this.isEvilTwin(conflict, change = changesToMarkAsMerged.get(conflict.item().getItemId()), descriptor, affectedAreas, (IProgressMonitor)monitor)) continue;
            unmergedChanges.add(change);
        }
        if (!unmergedChanges.isEmpty() && (result = problemHandler.unmergedChanges(unmergedChanges)) != 0) {
            if (result == 1) {
                throw new OperationCanceledException();
            }
            throw new FileSystemException(Messages.MarkAsMergedOperation_2);
        }
    }

    private boolean isEvilTwin(IItemConflictReport conflict, ILogicalChange change, ConfigurationFacade descriptor, Map<ISandbox, Set<ConfigurationFacade>> affectedAreas, IProgressMonitor monitor) throws FileSystemException {
        boolean evilTwin = false;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)affectedAreas.size());
        for (Map.Entry<ISandbox, Set<ConfigurationFacade>> entry : affectedAreas.entrySet()) {
            ISandbox sandbox = entry.getKey();
            Set<ConfigurationFacade> configurationsLoaded = entry.getValue();
            if (!configurationsLoaded.contains((Object)descriptor) || !(evilTwin |= this.isEvilTwin(sandbox, conflict, change, (IProgressMonitor)progress.newChild(1)))) continue;
            return evilTwin;
        }
        return false;
    }

    private boolean isEvilTwin(ISandbox sandbox, IItemConflictReport conflict, ILogicalChange change, IProgressMonitor progress) throws FileSystemException {
        Shareable shareable;
        ResourceType type;
        IRelativeLocation fullName;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)2);
        IVersionableHandle selectedContributorState = conflict.getSelectedContributorState();
        IVersionableHandle proposedContributorState = conflict.getProposedContributorState();
        IVersionableHandle originalSelectedContributorState = conflict.getOriginalSelectedContributorState();
        return selectedContributorState == null && originalSelectedContributorState == null && proposedContributorState != null && (fullName = sandbox.getPathRelativeToShares(this.connection.getContextHandle(), conflict.getComponent(), Collections.singletonList(change.getAncestorPathHint()), (IProgressMonitor)monitor.newChild(1)).get(0)) != null && (type = (shareable = (Shareable)sandbox.findShareable(fullName, ResourceType.getResourceType(conflict.item()))).getResourceType((IProgressMonitor)monitor.newChild(1))) != null && type == ResourceType.getResourceType(conflict.item());
    }

    private void checkinPendingChanges(Map<ConfigurationFacade, Map<UUID, ILogicalChange>> changes, Map<ISandbox, Set<ConfigurationFacade>> affectedAreas, final MarkAsMergedDilemmaHandler problemHandler, IProgressMonitor progress) throws TeamRepositoryException, FileSystemException {
        final ArrayList skippedCheckins = new ArrayList();
        ArrayList<ILocalChange> pendingChanges = new ArrayList<ILocalChange>();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)110);
        this.handleRefresh(affectedAreas, (IProgressMonitor)monitor.newChild(10));
        SubMonitor iterMon = monitor.newChild(2).setWorkRemaining(affectedAreas.size());
        for (Map.Entry<ISandbox, Set<ConfigurationFacade>> entry : affectedAreas.entrySet()) {
            ISandbox sandbox = entry.getKey();
            Set<ConfigurationFacade> configurationsForCFA = entry.getValue();
            SubMonitor subIterMon = iterMon.newChild(1).setWorkRemaining(configurationsForCFA.size());
            for (ConfigurationFacade descriptor : configurationsForCFA) {
                ILocalChange[] localChanges;
                Map<UUID, ILogicalChange> toMarkAsMerged = changes.get((Object)descriptor);
                ILocalChangeManager lcm = FileSystemCore.getSharingManager().getLocalChangeManager();
                lcm.syncPendingChanges(descriptor.getConnectionHandle(), descriptor.getComponentHandle(), sandbox, (IProgressMonitor)subIterMon.newChild(1));
                ILocalChange[] iLocalChangeArray = localChanges = lcm.getPendingChanges(descriptor.getConnectionHandle(), descriptor.getComponentHandle(), sandbox);
                int n = localChanges.length;
                int n2 = 0;
                while (n2 < n) {
                    ILocalChange localChange = iLocalChangeArray[n2];
                    if (toMarkAsMerged.containsKey(localChange.getTarget().getItemId())) {
                        pendingChanges.add(localChange);
                    }
                    ++n2;
                }
            }
        }
        if (!pendingChanges.isEmpty()) {
            int result = problemHandler.uncheckedInChanges(pendingChanges);
            if (result == 0) {
                CommitDilemmaHandler skipChecker = new CommitDilemmaHandler(){

                    @Override
                    public int encodingErrors(Collection<? extends IEncodingUploadFailure> failedUploads, IProgressMonitor monitor) {
                        int result = problemHandler.encodingErrors(failedUploads, monitor);
                        for (IEncodingUploadFailure iEncodingUploadFailure : failedUploads) {
                            if (!iEncodingUploadFailure.isSkipFailure()) continue;
                            skippedCheckins.add(iEncodingUploadFailure.getStatus());
                        }
                        return result;
                    }

                    @Override
                    public int lineDelimiterErrors(Collection<? extends ILineDelimiterUploadFailure> failedFiles, IProgressMonitor monitor) throws FileSystemException {
                        int result = problemHandler.lineDelimiterErrors(failedFiles, monitor);
                        for (ILineDelimiterUploadFailure iLineDelimiterUploadFailure : failedFiles) {
                            if (!iLineDelimiterUploadFailure.isSkipFailure()) continue;
                            skippedCheckins.add(iLineDelimiterUploadFailure.getStatus());
                        }
                        return result;
                    }

                    @Override
                    public int predecessorContentDeletedErrors(Collection<IShareable> failedUploads) {
                        int result = problemHandler.predecessorContentDeletedErrors(failedUploads);
                        if (result == 3) {
                            for (IShareable shareable : failedUploads) {
                                skippedCheckins.add(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.MarkAsMergedOperation_5, (Object)shareable.getLocalPath().toString())));
                            }
                        }
                        return result;
                    }

                    @Override
                    public int localConflicts(List<IShareable> conflictedLocalChanges) {
                        int result = problemHandler.localConflicts(conflictedLocalChanges);
                        if (result == 3) {
                            for (IShareable shareable : conflictedLocalChanges) {
                                skippedCheckins.add(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.MarkAsMergedOperation_6, (Object)shareable.getLocalPath().toString())));
                            }
                        }
                        return result;
                    }
                };
                ICheckinOperation op = IOperationFactory.instance.getCheckinOperation(skipChecker, new IRepositoryResolver(){

                    @Override
                    public ITeamRepository getRepoFor(String uri, UUID id) throws TeamRepositoryException {
                        if (id.equals((Object)MarkAsMergedOperation.this.connection.teamRepository().getId())) {
                            return MarkAsMergedOperation.this.connection.teamRepository();
                        }
                        return null;
                    }
                });
                if (this.nonAtomicCommitIsAnOption) {
                    op.enableNonAtomicCommit(this.nonAtomicCommitFileUploadLimit);
                } else {
                    op.disableNonAtomicCommit();
                }
                op.requestCheckin(pendingChanges.toArray(new ILocalChange[pendingChanges.size()]), null, Messages.MarkAsMergedOperation_ChangeSetDefaultComment, (IProgressMonitor)monitor.newChild(1));
                this.disableVerifyInSync(op);
                op.run((IProgressMonitor)monitor.newChild(90));
                if (!skippedCheckins.isEmpty()) {
                    MultiStatus status = new MultiStatus("com.ibm.team.filesystem.client", 0, Messages.MarkAsMergedOperation_1, null);
                    for (IStatus childStatus : skippedCheckins) {
                        status.add(childStatus);
                    }
                    throw new FileSystemStatusException((IStatus)status);
                }
            } else {
                if (result == 1) {
                    throw new OperationCanceledException();
                }
                throw new FileSystemException(Messages.MarkAsMergedOperation_1);
            }
        }
        monitor.done();
    }

    private void handleRefresh(Map<ISandbox, Set<ConfigurationFacade>> affectedAreas, IProgressMonitor progress) throws FileSystemException, TeamRepositoryException {
        if (this.getRefreshBeforeRun()) {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
            monitor.setTaskName(Messages.MarkAsMergedOperation_4);
            Collection<IShareable> toRefresh = ChangeSetRefreshUtils.refreshLocalForLogicalChanges(this.getConnection(), affectedAreas.keySet(), this.getChanges(), (IProgressMonitor)monitor.newChild(10));
            List<IShareable> shareables = ChangeSetRefreshUtils.rationalizeRefreshTree(toRefresh);
            monitor.setWorkRemaining(affectedAreas.size() * 10 + shareables.size() * 2);
            for (IShareable iShareable : shareables) {
                ((Shareable)iShareable).getFileStorage().refreshCachedSubTree(Integer.MAX_VALUE, (IProgressMonitor)monitor.newChild(1));
            }
            LocalChangeManager.getInstance().refreshChanges(shareables, (IProgressMonitor)monitor.newChild(shareables.size()));
            for (Map.Entry entry : affectedAreas.entrySet()) {
                SubMonitor descMon = monitor.newChild(10);
                descMon.setWorkRemaining(((Set)entry.getValue()).size());
                for (ConfigurationFacade desc : (Set)entry.getValue()) {
                    LocalChangeManager.getInstance().syncPendingChanges(desc.getConnectionHandle(), desc.getComponentHandle(), (ISandbox)entry.getKey(), (IProgressMonitor)descMon.newChild(1));
                }
            }
        }
    }

    protected final Map<ISandbox, Set<ConfigurationFacade>> getCopyFileAreasAffected(Set<ConfigurationFacade> affectedConfigurations, IProgressMonitor progress) throws FileSystemException {
        HashMap<ISandbox, Set<ConfigurationFacade>> result = new HashMap<ISandbox, Set<ConfigurationFacade>>();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)affectedConfigurations.size());
        ICopyFileAreaManager copyFileAreaManager = ICopyFileAreaManager.instance;
        for (ConfigurationFacade configuration : affectedConfigurations) {
            Collection<ICopyFileArea> copyFileAreas = copyFileAreaManager.getCopyFileAreasForConfiguration(configuration, (IProgressMonitor)monitor.newChild(1));
            for (ICopyFileArea cfa : copyFileAreas) {
                Sandbox sandbox = new Sandbox(cfa);
                HashSet<ConfigurationFacade> configurations = (HashSet<ConfigurationFacade>)result.get(sandbox);
                if (configurations == null) {
                    configurations = new HashSet<ConfigurationFacade>();
                    result.put(sandbox, configurations);
                }
                configurations.add(configuration);
            }
        }
        return result;
    }

    @Override
    public void addChangesToResolve(Collection<? extends ILogicalChange> moreChanges) {
        this.changes.addAll(moreChanges);
    }

    @Override
    public void disableNonAtomicCommit() {
        this.nonAtomicCommitIsAnOption = false;
    }

    @Override
    public void enableNonAtomicCommit(int numberUploads) {
        this.nonAtomicCommitIsAnOption = true;
        this.nonAtomicCommitFileUploadLimit = numberUploads;
    }

    @Override
    public final void setRefreshBeforeRun(boolean newValue) {
        this.refreshBeforeRun = newValue;
    }

    @Override
    public final boolean getRefreshBeforeRun() {
        return this.refreshBeforeRun;
    }

    @Override
    protected Collection<ILogicalChange> getChanges() {
        return this.changes;
    }

    private Collection<ILogicalChange> processDuplicateItemIDs(Collection<ILogicalChange> selectedChanges, Collection<ILogicalChange> requiredChanges) {
        Map<ConfigurationFacade, Map<UUID, ILogicalChange>> selectedChangesByComponent = this.organizeChanges(selectedChanges);
        Map<ConfigurationFacade, Map<UUID, ILogicalChange>> requiredChangesByComponent = this.organizeChanges(requiredChanges);
        ArrayList<ILogicalChange> missingChanges = new ArrayList<ILogicalChange>();
        ArrayList<ILogicalChange> toAdd = new ArrayList<ILogicalChange>(requiredChanges.size());
        for (Map.Entry<ConfigurationFacade, Map<UUID, ILogicalChange>> entry : selectedChangesByComponent.entrySet()) {
            Map<UUID, ILogicalChange> componentMissingChanges = requiredChangesByComponent.remove((Object)entry.getKey());
            if (componentMissingChanges == null || componentMissingChanges.isEmpty()) continue;
            for (ILogicalChange selectedChange : entry.getValue().values()) {
                ILogicalChange transfer = componentMissingChanges.remove(selectedChange.item().getItemId());
                if (transfer == null) continue;
                if (this.isTracingEnabled()) {
                    this.trace("Required Change Added: " + transfer.toString());
                }
                toAdd.add(transfer);
            }
            missingChanges.addAll(componentMissingChanges.values());
        }
        for (Map map : requiredChangesByComponent.values()) {
            missingChanges.addAll(map.values());
        }
        selectedChanges.addAll(toAdd);
        if (this.isTracingEnabled() && !missingChanges.isEmpty()) {
            for (ILogicalChange iLogicalChange : missingChanges) {
                this.trace("Required Change Missing: " + iLogicalChange.toString());
            }
        }
        return missingChanges;
    }
}

