/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.operations.AbstractLockOperation;
import com.ibm.team.filesystem.client.operations.ILockOperation;
import com.ibm.team.filesystem.client.operations.LockDilemmaHandler;
import com.ibm.team.filesystem.client.operations.LockEntry;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class LockOperation
extends AbstractLockOperation
implements ILockOperation {
    public LockOperation(LockDilemmaHandler dilemmaHandler) {
        super(dilemmaHandler);
    }

    @Override
    protected void execute(IProgressMonitor progress) throws FileSystemException, TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        int result = this.checkLockOwners((IProgressMonitor)monitor.newChild(25));
        switch (result) {
            case 1: {
                throw new OperationCanceledException();
            }
            case 2: {
                throw new FileSystemException(Messages.LockOperation_FileAlreadyLocked);
            }
            case 0: {
                break;
            }
        }
        super.execute((IProgressMonitor)monitor.newChild(75));
    }

    @Override
    protected boolean isLockOperation() {
        return true;
    }

    @Override
    protected IWorkspaceManager.IVersionableLockOperation getLockOperation(IWorkspaceManager.IVersionableLockOperationFactory lockOperationFactory, LockEntry lockEntry, IWorkspaceConnection connection) {
        if (lockEntry.isStreamLockEntry()) {
            return lockOperationFactory.acquireStream(connection);
        }
        if (lockEntry.isComponentLockEntry()) {
            return lockOperationFactory.acquireComponent(connection, lockEntry.getComponent());
        }
        IVersionableHandle versionable = lockEntry.getVersionable();
        if (versionable instanceof IFolderHandle) {
            return null;
        }
        return lockOperationFactory.acquire(versionable, connection, lockEntry.getComponent());
    }

    @Override
    public void lock(IWorkspaceConnection workspaceConnection, IComponentHandle componentHandle, IVersionableHandle versionableHandle) {
        this.add(workspaceConnection, componentHandle, versionableHandle, null);
    }

    @Override
    public void lock(IWorkspaceConnection sourceWorkspaceConnection, IWorkspaceConnection workspaceConnection, IComponentHandle componentHandle, IVersionableHandle versionableHandle) {
        this.add(sourceWorkspaceConnection, workspaceConnection, componentHandle, versionableHandle, null);
    }

    @Override
    public void lock(IWorkspaceConnection stream) {
        if (!stream.isStream()) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.AbstractLockOperation_OnlyStreamsSupported, (Object)stream.getName(), (Object[])new Object[0]));
        }
        this.add(stream, null, null, null);
    }

    @Override
    public void lock(IWorkspaceConnection stream, IComponentHandle component) {
        if (!stream.isStream()) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.AbstractLockOperation_OnlyStreamsSupported, (Object)stream.getName(), (Object[])new Object[0]));
        }
        this.add(stream, component, null, null);
    }
}

