/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.EclipseReadException;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IFileSystemManager;
import com.ibm.team.filesystem.client.ILoadFilter;
import com.ibm.team.filesystem.client.ILoadRule;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileSystemManager;
import com.ibm.team.filesystem.client.internal.FileSystemServiceProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.load.InvalidLoadLocation;
import com.ibm.team.filesystem.client.internal.load.LoadLocation;
import com.ibm.team.filesystem.client.internal.load.LoadRequest;
import com.ibm.team.filesystem.client.internal.load.LockAndLoadFileVisitor;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.operations.ILoadEvaluator;
import com.ibm.team.filesystem.client.internal.operations.ILoadMutator;
import com.ibm.team.filesystem.client.internal.operations.ILoadMutator2;
import com.ibm.team.filesystem.client.internal.operations.InvalidLoadRequest;
import com.ibm.team.filesystem.client.internal.operations.LoadEvaluator;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.ICollision;
import com.ibm.team.filesystem.client.operations.IDownloadListener;
import com.ibm.team.filesystem.client.operations.IInvalidLoadLocation;
import com.ibm.team.filesystem.client.operations.IInvalidLoadRequest;
import com.ibm.team.filesystem.client.operations.ILoadLocation;
import com.ibm.team.filesystem.client.operations.ILoadOperation;
import com.ibm.team.filesystem.client.operations.ILoadOverlap;
import com.ibm.team.filesystem.client.operations.ILoadRequest;
import com.ibm.team.filesystem.client.operations.IMultipleSandboxLoad;
import com.ibm.team.filesystem.client.operations.IRemovedShare;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.IShareableToLoad;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.common.internal.dto.LoadTree;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.ISynchronizationInfo;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class LoadOperation
extends FileSystemOperation
implements ILoadOperation {
    private final LoadDilemmaHandler dilemmaHandler;
    private Map<ISandbox, Map<IConnection, Map<ConfigurationFacade, Set<LoadRequest>>>> requestsByCFA;
    private Set<ISandbox> copyFileAreasAffected;
    private ISynchronizationInfo synchronizationInfo;
    private Set<Shareable> symbolicLinksToRefresh = new HashSet<Shareable>();
    private Map<String, ILoadEvaluator> evaluators;
    private Map<ISandbox, Set<IRemovedShare>> sharesToRemove = new HashMap<ISandbox, Set<IRemovedShare>>();
    private Map<ILoadRequest, IInvalidLoadLocation> invalidLoadLocations = new HashMap<ILoadRequest, IInvalidLoadLocation>();
    private Set<LoadLocation> treesToLoad;
    private Map<ILocation, ICollision> collisions;
    private Map<ILocation, IShareableToLoad> newItems;
    private List<ILoadOverlap> loadOverLaps;
    private List<IShareOutOfSync> sharesOutOfSync;
    private List<IInvalidLoadRequest> invalidLoadRequests;
    private int options;
    private IDownloadListener downloadMonitor;
    private ILoadFilter filter;
    private boolean isEclipseMetadataReadFailure;
    private List<String> eclipseReadMessages;
    private EclipseReadException savedEclipseReadException;
    private boolean isPreserveLocalChanges;
    private boolean isPreserveFileTimestamps;
    private boolean expandKeywords;
    private boolean skipLocalRefresh = Boolean.getBoolean("com.ibm.team.filesystem.client.skipRefreshOnLoad");

    public LoadOperation(LoadDilemmaHandler problemHandler) {
        super(problemHandler == null ? LoadDilemmaHandler.getDefault() : problemHandler);
        this.dilemmaHandler = problemHandler == null ? LoadDilemmaHandler.getDefault() : problemHandler;
        this.requestsByCFA = new HashMap<ISandbox, Map<IConnection, Map<ConfigurationFacade, Set<LoadRequest>>>>();
        this.treesToLoad = new HashSet<LoadLocation>();
        this.sharesToRemove = new HashMap<ISandbox, Set<IRemovedShare>>();
        this.invalidLoadLocations = new HashMap<ILoadRequest, IInvalidLoadLocation>();
        this.collisions = new HashMap<ILocation, ICollision>();
        this.newItems = new HashMap<ILocation, IShareableToLoad>();
        this.loadOverLaps = new ArrayList<ILoadOverlap>();
        this.sharesOutOfSync = new ArrayList<IShareOutOfSync>();
        this.invalidLoadRequests = new ArrayList<IInvalidLoadRequest>();
        this.copyFileAreasAffected = new HashSet<ISandbox>();
        this.options = 0;
        this.isEclipseMetadataReadFailure = false;
        this.eclipseReadMessages = new ArrayList<String>();
    }

    private void saveRecursiveMessages(IStatus status, List<String> savedMessages) {
        IStatus[] sChildren;
        savedMessages.add(status.getMessage());
        IStatus[] iStatusArray = sChildren = status.getChildren();
        int n = sChildren.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus sChild = iStatusArray[n2];
            this.saveRecursiveMessages(sChild, savedMessages);
            ++n2;
        }
    }

    @Override
    public boolean isEclipseMetadataReadFailure() {
        return this.isEclipseMetadataReadFailure;
    }

    @Override
    public List<String> getEclipseMetadataReadFailureMessage() {
        return this.eclipseReadMessages;
    }

    @Override
    public EclipseReadException getSavedEclipseReadException() {
        return this.savedEclipseReadException;
    }

    @Override
    public void requestLoad(ISandbox sandbox, IRelativeLocation relativeLoadPath, IWorkspaceConnection workspaceConnection, IComponentHandle component, Collection<? extends IVersionableHandle> itemsToLoad) {
        this.requestLoad(sandbox, relativeLoadPath, workspaceConnection, component, itemsToLoad, false);
    }

    @Override
    public void requestLoad(ISandbox sandbox, IRelativeLocation relativeLoadPath, IWorkspaceConnection workspaceConnection, IComponentHandle component, Collection<? extends IVersionableHandle> itemsToLoad, boolean allowsNestedShares) {
        this.validateRequestToLoad(sandbox, relativeLoadPath, (IConnection)workspaceConnection, component, itemsToLoad);
        this.recordRequestToLoad(sandbox, relativeLoadPath, (IConnection)workspaceConnection, component, itemsToLoad, allowsNestedShares);
    }

    @Override
    public void requestLoad(ISandbox sandbox, IRelativeLocation relativeLoadPath, IBaselineConnection baselineConnection, Collection<? extends IVersionableHandle> itemsToLoad, boolean allowsNestedShares) {
        if (baselineConnection == null) {
            throw new IllegalArgumentException();
        }
        this.validateRequestToLoad(sandbox, relativeLoadPath, (IConnection)baselineConnection, baselineConnection.getComponent(), itemsToLoad);
        this.recordRequestToLoad(sandbox, relativeLoadPath, (IConnection)baselineConnection, baselineConnection.getComponent(), itemsToLoad, allowsNestedShares);
    }

    @Override
    public void requestLoad(ISandbox sandbox, IRelativeLocation relativeLoadPath, Collection<ILoadRule> loadRules, IProgressMonitor progress) throws TeamRepositoryException {
        if (loadRules == null) {
            throw new IllegalArgumentException();
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)loadRules.size());
        for (ILoadRule loadRule : loadRules) {
            this.recordRequestToLoad(sandbox, relativeLoadPath, (IConnection)loadRule.getWorkspaceConnection(), loadRule.getComponent(), loadRule.getItemsToLoad((IProgressMonitor)monitor.newChild(1)), false);
        }
    }

    private void validateRequestToLoad(ISandbox sandbox, IRelativeLocation relativeLoadPath, IConnection connection, IComponentHandle component, Collection<? extends IVersionableHandle> itemsToLoad) {
        if (sandbox == null) {
            throw new IllegalArgumentException();
        }
        if (connection == null) {
            throw new IllegalArgumentException();
        }
        if (component == null) {
            throw new IllegalArgumentException();
        }
        if (itemsToLoad == null) {
            throw new IllegalArgumentException();
        }
        for (IVersionableHandle iVersionableHandle : itemsToLoad) {
            if (iVersionableHandle != null) continue;
            throw new IllegalArgumentException();
        }
    }

    private void recordRequestToLoad(ISandbox sandbox, IRelativeLocation relativeLoadPath, IConnection connection, IComponentHandle component, Collection<? extends IVersionableHandle> itemsToLoad, boolean allowsNestedShares) {
        ConfigurationFacade descriptor = new ConfigurationFacade(connection, component);
        if (!itemsToLoad.isEmpty()) {
            Set<LoadRequest> requests;
            Map<ConfigurationFacade, Set<LoadRequest>> requestsByConfig;
            Map<IConnection, Map<ConfigurationFacade, Set<LoadRequest>>> requestsByConnection = this.requestsByCFA.get(sandbox);
            if (requestsByConnection == null) {
                requestsByConnection = new HashMap<IConnection, Map<ConfigurationFacade, Set<LoadRequest>>>();
                this.requestsByCFA.put(sandbox, requestsByConnection);
            }
            if ((requestsByConfig = requestsByConnection.get(connection)) == null) {
                requestsByConfig = new HashMap<ConfigurationFacade, Set<LoadRequest>>();
                requestsByConnection.put(connection, requestsByConfig);
            }
            if ((requests = requestsByConfig.get((Object)descriptor)) == null) {
                requests = new HashSet<LoadRequest>();
                requestsByConfig.put(descriptor, requests);
            }
            for (IVersionableHandle iVersionableHandle : itemsToLoad) {
                LoadRequest request = new LoadRequest(sandbox, relativeLoadPath, "", connection, component, iVersionableHandle, false, allowsNestedShares);
                requests.add(request);
            }
        }
    }

    @Override
    public void requestReLoad(Collection<IShare> sharesToReload, IRepositoryResolver resolver, boolean allowsNestedShares, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)sharesToReload.size());
        if (sharesToReload == null || sharesToReload.isEmpty()) {
            throw new IllegalArgumentException();
        }
        for (IShare share : sharesToReload) {
            if (share != null) continue;
            throw new IllegalArgumentException();
        }
        for (IShare share : sharesToReload) {
            Set<LoadRequest> requests;
            Map<ConfigurationFacade, Set<LoadRequest>> requestsByConfig;
            ISharingDescriptor sharingDescriptor = share.getSharingDescriptor();
            ITeamRepository repository = resolver.getRepoFor(null, sharingDescriptor.getRepositoryId());
            ConfigurationFacade configurationDescriptor = new ConfigurationFacade(repository, sharingDescriptor.getConnectionHandle(), sharingDescriptor.getComponent());
            IConnection connection = configurationDescriptor.getConnection((IProgressMonitor)monitor.newChild(1));
            Map<IConnection, Map<ConfigurationFacade, Set<LoadRequest>>> requestsByConnection = this.requestsByCFA.get(share.getSandbox());
            if (requestsByConnection == null) {
                requestsByConnection = new HashMap<IConnection, Map<ConfigurationFacade, Set<LoadRequest>>>();
                this.requestsByCFA.put(share.getSandbox(), requestsByConnection);
            }
            if ((requestsByConfig = requestsByConnection.get(connection)) == null) {
                requestsByConfig = new HashMap<ConfigurationFacade, Set<LoadRequest>>();
                requestsByConnection.put(connection, requestsByConfig);
            }
            if ((requests = requestsByConfig.get((Object)configurationDescriptor)) == null) {
                requests = new HashSet<LoadRequest>();
                requestsByConfig.put(configurationDescriptor, requests);
            }
            IRelativeLocation localCopyFileAreaPath = share.getPath().removeLastSegments(1);
            String alternativeName = share.getPath().getName();
            requests.add(new LoadRequest(share.getSandbox(), localCopyFileAreaPath, alternativeName, connection, sharingDescriptor.getComponent(), sharingDescriptor.getRootVersionable(), true, allowsNestedShares));
        }
    }

    @Override
    public void requestReLoad(Collection<IShare> sharesToReload, IRepositoryResolver resolver, IProgressMonitor progress) throws TeamRepositoryException {
        this.requestReLoad(sharesToReload, resolver, false, progress);
    }

    @Override
    public void requestLoadAs(ISandbox sandbox, IRelativeLocation relativeLoadPath, String alternativeName, IBaselineConnection baselineConnection, IVersionableHandle itemToLoad, boolean allowNestedShares) {
        this.privateRequestLoadAs(sandbox, relativeLoadPath, alternativeName, (IConnection)baselineConnection, baselineConnection.getComponent(), itemToLoad, allowNestedShares);
    }

    @Override
    public void requestLoadAs(ISandbox sandbox, IRelativeLocation relativeLoadPath, String alternativeName, IWorkspaceConnection workspaceConnection, IComponentHandle component, IVersionableHandle itemToLoad, boolean allowsNestedShares) {
        this.privateRequestLoadAs(sandbox, relativeLoadPath, alternativeName, (IConnection)workspaceConnection, component, itemToLoad, allowsNestedShares);
    }

    @Override
    public void requestLoadAs(ISandbox sandbox, IRelativeLocation relativeLoadPath, String alternativeName, IWorkspaceConnection workspaceConnection, IComponentHandle component, IVersionableHandle itemToLoad) {
        this.privateRequestLoadAs(sandbox, relativeLoadPath, alternativeName, (IConnection)workspaceConnection, component, itemToLoad, false);
    }

    public void privateRequestLoadAs(ISandbox sandbox, IRelativeLocation relativeLoadPath, String alternativeName, IConnection connection, IComponentHandle component, IVersionableHandle itemToLoad, boolean allowsNestedShares) {
        ConfigurationFacade descriptor;
        Set<LoadRequest> requests;
        Map<ConfigurationFacade, Set<LoadRequest>> requestsByConfig;
        if (connection == null) {
            throw new IllegalArgumentException();
        }
        this.validateRequestToLoad(sandbox, relativeLoadPath, connection, component, Collections.singletonList(itemToLoad));
        Map<IConnection, Map<ConfigurationFacade, Set<LoadRequest>>> requestsByConnection = this.requestsByCFA.get(sandbox);
        if (requestsByConnection == null) {
            requestsByConnection = new HashMap<IConnection, Map<ConfigurationFacade, Set<LoadRequest>>>();
            this.requestsByCFA.put(sandbox, requestsByConnection);
        }
        if ((requestsByConfig = requestsByConnection.get(connection)) == null) {
            requestsByConfig = new HashMap<ConfigurationFacade, Set<LoadRequest>>();
            requestsByConnection.put(connection, requestsByConfig);
        }
        if ((requests = requestsByConfig.get((Object)(descriptor = new ConfigurationFacade(connection, component)))) == null) {
            requests = new HashSet<LoadRequest>();
            requestsByConfig.put(descriptor, requests);
        }
        LoadRequest request = new LoadRequest(sandbox, relativeLoadPath, alternativeName, connection, component, itemToLoad, false, allowsNestedShares);
        requests.add(request);
    }

    @Override
    public Collection<ILoadRequest> getLoadRequests() {
        ArrayList<LoadRequest> allRequests = new ArrayList<LoadRequest>();
        for (Map<IConnection, Map<ConfigurationFacade, Set<LoadRequest>>> requestsByConnection : this.requestsByCFA.values()) {
            for (Map<ConfigurationFacade, Set<LoadRequest>> requestsByConfig : requestsByConnection.values()) {
                for (Set<LoadRequest> requests : requestsByConfig.values()) {
                    allRequests.addAll(requests);
                }
            }
        }
        return Collections.unmodifiableCollection(allRequests);
    }

    @Override
    public Collection<ILoadOverlap> getLoadOverlaps() {
        return Collections.unmodifiableCollection(this.loadOverLaps);
    }

    @Override
    public Collection<IInvalidLoadRequest> getInvalidLoadRequests() {
        return Collections.unmodifiableCollection(this.invalidLoadRequests);
    }

    @Override
    public Collection<IMultipleSandboxLoad> getMultipleSandboxLoads(IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        Set<ConfigurationFacade> affectedConfigurations = this.getAffectedConfigurations();
        Map<ConfigurationFacade, Set<ISandbox>> configurationSandboxes = this.getConfigurationSandboxes(affectedConfigurations, (IProgressMonitor)monitor.newChild(10));
        return this.validateMultipleCopyFileAreas(configurationSandboxes, (IProgressMonitor)monitor.newChild(90));
    }

    private Collection<IMultipleSandboxLoad> validateMultipleCopyFileAreas(Map<ConfigurationFacade, Set<ISandbox>> configurationSandboxes, IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(100 * this.evaluators.size()));
        ArrayList<IMultipleSandboxLoad> result = new ArrayList<IMultipleSandboxLoad>();
        for (ILoadEvaluator evaluator : this.evaluators.values()) {
            result.addAll(evaluator.getMultipleSandboxLoads((IProgressMonitor)monitor.newChild(100)));
        }
        return result;
    }

    @Override
    public void evaluateLoadRequests(IProgressMonitor progress) throws FileSystemException, TeamRepositoryException {
        Map<ILoadRequest, IInvalidLoadLocation> overlappingSandboxes = this.validateSandboxOverlap();
        this.internalEvaluateLoadRequests(overlappingSandboxes, progress);
    }

    private void internalEvaluateLoadRequests(Map<ILoadRequest, IInvalidLoadLocation> overlappingSandboxes, IProgressMonitor progress) throws FileSystemException, TeamRepositoryException {
        this.treesToLoad = new HashSet<LoadLocation>();
        this.sharesToRemove = new HashMap<ISandbox, Set<IRemovedShare>>();
        this.invalidLoadLocations = new HashMap<ILoadRequest, IInvalidLoadLocation>();
        this.collisions = new HashMap<ILocation, ICollision>();
        this.newItems = new HashMap<ILocation, IShareableToLoad>();
        this.loadOverLaps = new ArrayList<ILoadOverlap>();
        this.invalidLoadRequests = new ArrayList<IInvalidLoadRequest>();
        this.sharesOutOfSync = new ArrayList<IShareOutOfSync>();
        this.invalidLoadLocations.putAll(overlappingSandboxes);
        this.validateComponentInConnection(this.invalidLoadRequests);
        this.evaluators = SharingManager.getInstance().getLoadEvaluators(this.requestsByCFA.keySet());
        for (Map.Entry<ISandbox, Map<IConnection, Map<ConfigurationFacade, Set<LoadRequest>>>> entry : this.requestsByCFA.entrySet()) {
            ISandbox sandbox = entry.getKey();
            Map<IConnection, Map<ConfigurationFacade, Set<LoadRequest>>> allRequests = entry.getValue();
            int pagingSize = 0;
            for (Map<ConfigurationFacade, Set<LoadRequest>> loadRequest : allRequests.values()) {
                Iterator<Set<LoadRequest>> requests = loadRequest.values().iterator();
                while (requests.hasNext()) {
                    pagingSize = requests.next().size();
                }
            }
            CopyFileArea cfa = (CopyFileArea)ICopyFileAreaManager.instance.getExistingCopyFileArea(sandbox.getRoot());
            if (cfa != null) {
                cfa.internalGetMetadata().setPagingSize(pagingSize);
            }
            ILoadEvaluator evaluator = this.evaluators.get(sandbox.getRoot().getStorageId());
            evaluator.setRequests(sandbox, allRequests);
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(100 * this.evaluators.size()));
        for (ILoadEvaluator evaluator : this.evaluators.values()) {
            evaluator.evaluateLoadRequests((IProgressMonitor)monitor.newChild(100));
            this.collisions.putAll(evaluator.getCollisions());
            this.sharesToRemove.putAll(evaluator.getSharesToBeRemoved());
            this.invalidLoadLocations.putAll(evaluator.getInvalidLoadLocations());
            this.newItems.putAll(evaluator.getNewSharesToLoad());
            this.loadOverLaps.addAll(evaluator.getLoadOverlaps());
            this.invalidLoadRequests.addAll(evaluator.getInvalidLoadRequests());
            this.sharesOutOfSync.addAll(evaluator.getSharesOutOfSync());
            this.treesToLoad.addAll(evaluator.getItemsToLoad());
        }
    }

    private void validateComponentInConnection(List<IInvalidLoadRequest> invalidRequests) {
        Iterator<Map.Entry<ISandbox, Map<IConnection, Map<ConfigurationFacade, Set<LoadRequest>>>>> iRequestsByCfa = this.requestsByCFA.entrySet().iterator();
        while (iRequestsByCfa.hasNext()) {
            Map<IConnection, Map<ConfigurationFacade, Set<LoadRequest>>> requestsByConnection = iRequestsByCfa.next().getValue();
            Iterator<Map.Entry<IConnection, Map<ConfigurationFacade, Set<LoadRequest>>>> iRequestsByConnection = requestsByConnection.entrySet().iterator();
            while (iRequestsByConnection.hasNext()) {
                Map.Entry<IConnection, Map<ConfigurationFacade, Set<LoadRequest>>> requestByConnection = iRequestsByConnection.next();
                IConnection connection = requestByConnection.getKey();
                HashSet<UUID> componentsAvailable = new HashSet<UUID>();
                if (connection instanceof IWorkspaceConnection) {
                    IWorkspaceConnection workspaceConnection = (IWorkspaceConnection)connection;
                    try {
                        for (IComponentHandle component : workspaceConnection.getComponents()) {
                            componentsAvailable.add(component.getItemId());
                        }
                    }
                    catch (TeamRepositoryException component) {}
                } else if (connection instanceof IBaselineConnection) {
                    componentsAvailable.add(((IBaselineConnection)connection).getComponent().getItemId());
                }
                Map<ConfigurationFacade, Set<LoadRequest>> requestsByConfiguration = requestByConnection.getValue();
                Iterator<Map.Entry<ConfigurationFacade, Set<LoadRequest>>> iRequestsByConfiguration = requestsByConfiguration.entrySet().iterator();
                while (iRequestsByConfiguration.hasNext()) {
                    Map.Entry<ConfigurationFacade, Set<LoadRequest>> entry = iRequestsByConfiguration.next();
                    ConfigurationFacade facade = entry.getKey();
                    if (componentsAvailable.contains(facade.getComponentHandle().getItemId())) continue;
                    Set<LoadRequest> requests = entry.getValue();
                    for (LoadRequest request : requests) {
                        invalidRequests.add(new InvalidLoadRequest(request, IInvalidLoadRequest.InvalidLoadRequestReason.InvalidRequest, FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.LoadOperation_20, (Object)connection.getName()))));
                    }
                    iRequestsByConfiguration.remove();
                }
                if (!requestByConnection.getValue().isEmpty()) continue;
                iRequestsByConnection.remove();
            }
            if (!requestsByConnection.isEmpty()) continue;
            iRequestsByCfa.remove();
        }
    }

    @Override
    public void removeLoadRequests(Collection<ILoadRequest> requestsToRemove) {
        if (requestsToRemove == null) {
            throw new IllegalArgumentException();
        }
        for (ILoadRequest request : requestsToRemove) {
            Set<LoadRequest> requests;
            Map<IConnection, Map<ConfigurationFacade, Set<LoadRequest>>> requestsByConnection = this.requestsByCFA.get(request.getSandbox());
            if (requestsByConnection == null) continue;
            ConfigurationFacade descriptor = new ConfigurationFacade(request.getConnection(), request.getComponent());
            Map<ConfigurationFacade, Set<LoadRequest>> requestsByConfig = requestsByConnection.get(request.getConnection());
            if (requestsByConfig == null || (requests = requestsByConfig.get((Object)descriptor)) == null) continue;
            requests.remove(request);
            if (!requests.isEmpty()) continue;
            requestsByConfig.remove((Object)descriptor);
            if (!requestsByConfig.isEmpty()) continue;
            requestsByConnection.remove(request.getConnection());
            if (!requestsByConnection.isEmpty()) continue;
            this.requestsByCFA.remove(request.getSandbox());
        }
    }

    @Override
    public Collection<IInvalidLoadLocation> getInvalidLoadLocations() {
        return Collections.unmodifiableCollection(this.invalidLoadLocations.values());
    }

    @Override
    public Collection<IRemovedShare> getSharesToBeRemoved() {
        ArrayList<IRemovedShare> toRemove = new ArrayList<IRemovedShare>();
        for (Set<IRemovedShare> shares : this.sharesToRemove.values()) {
            toRemove.addAll(shares);
        }
        return toRemove;
    }

    @Override
    public Collection<ICollision> getCollisions() {
        return Collections.unmodifiableCollection(this.collisions.values());
    }

    @Override
    public Collection<LoadLocation> getItemsToLoad() {
        return Collections.unmodifiableCollection(this.treesToLoad);
    }

    @Override
    public Collection<IShareableToLoad> getNewSharesToLoad() {
        return Collections.unmodifiableCollection(this.newItems.values());
    }

    @Override
    public Collection<IShareOutOfSync> getSharesOutOfSync() {
        return Collections.unmodifiableCollection(this.sharesOutOfSync);
    }

    @Override
    public void setSychronizationInfo(ISynchronizationInfo synchronizationInfo) {
        this.synchronizationInfo = synchronizationInfo;
    }

    @Override
    public void setDownloadListener(IDownloadListener downloadListener) {
        this.downloadMonitor = downloadListener;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected final void execute(IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        affectedConfigurations = this.getAffectedConfigurations();
        loadedConnectionsToSandboxMap = new HashMap<K, V>();
        runnableWithProgress = new IRunnableWithProgress(){

            /*
             * Unable to fully structure code
             */
            @Override
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                try {
                    overlappingSandboxes = LoadOperation.access$0(LoadOperation.this);
                    configurationSandboxes = LoadOperation.this.getConfigurationSandboxes(affectedConfigurations, (IProgressMonitor)progress.newChild(1));
                    lockRequests = LoadOperation.access$1(LoadOperation.this);
                    copyFileAreaLock = ICopyFileAreaManager.instance.lock(lockRequests, (IProgressMonitor)progress.newChild(1));
                    try {
                        try {
                            LoadOperation.access$4(LoadOperation.this, overlappingSandboxes, (IProgressMonitor)progress.newChild(2));
                            LoadOperation.this.notifyDilemmaHandler(configurationSandboxes, (IProgressMonitor)progress.newChild(1));
                            LoadOperation.this.load(LoadOperation.access$5(LoadOperation.this), loadedConnectionsToSandboxMap, (IProgressMonitor)progress.newChild(81));
                            LoadOperation.access$7(LoadOperation.this, LoadOperation.access$6(LoadOperation.this), (IProgressMonitor)progress.newChild(2));
                        }
                        finally {
                            LoadOperation.access$2(LoadOperation.this).addAll(LoadOperation.access$3(LoadOperation.this).keySet());
                            ** for (sandbox : LoadOperation.access$2((LoadOperation)LoadOperation.this))
                        }
lbl-1000:
                        // 1 sources

                        {
                            cfa = (CopyFileArea)ICopyFileAreaManager.instance.getExistingCopyFileArea(sandbox.getRoot());
                            if (cfa == null) continue;
                            cfa.syncMetaData();
                            continue;
lbl22:
                            // 1 sources

                        }
                    }
                    finally {
                        copyFileAreaLock.release((IProgressMonitor)progress.newChild(1));
                        progress.done();
                    }
                }
                catch (FileSystemException e) {
                    throw new InvocationTargetException((Throwable)e);
                }
                catch (TeamRepositoryException e) {
                    throw new InvocationTargetException(e);
                }
                catch (OperationCanceledException e) {
                    throw new InterruptedException();
                }
            }
        };
        progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        jazzWorkspaceLock = WorkspaceLockUtil.acquireReadForConfigurations(affectedConfigurations, (IProgressMonitor)progress.newChild(1));
        try {
            this.runWithinFileSystemLock(runnableWithProgress, Messages.LoadOperation_18, (IProgressMonitor)progress.newChild(99));
        }
        finally {
            WorkspaceLockUtil.release(jazzWorkspaceLock);
            ** for (entry : loadedConnectionsToSandboxMap.entrySet())
        }
lbl-1000:
        // 1 sources

        {
            if (!(entry.getKey() instanceof IWorkspaceConnection) || !(workspaceConnection = (IWorkspaceConnection)entry.getKey()).teamRepository().loggedInContributor().sameItemId((IItemHandle)workspaceConnection.getOwner())) continue;
            workspaceConnection.setLastLoadPath(((ISandbox)entry.getValue()).getRoot().toString(), (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)progress, loadedConnectionsToSandboxMap.size()));
            continue;
        }
lbl15:
        // 1 sources

        progress.done();
    }

    protected Map<ConfigurationFacade, Set<ISandbox>> getConfigurationSandboxes(Set<ConfigurationFacade> affectedConfigurations, IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)affectedConfigurations.size());
        HashMap<ConfigurationFacade, Set<ISandbox>> result = new HashMap<ConfigurationFacade, Set<ISandbox>>();
        for (ConfigurationFacade configuration : affectedConfigurations) {
            Collection<ISandbox> sandboxes = SharingManager.getInstance().getSandboxes(configuration, (IProgressMonitor)monitor.newChild(1));
            result.put(configuration, new HashSet<ISandbox>(sandboxes));
        }
        return result;
    }

    private List<ICopyFileAreaLockRequest> cfaLockRequests() {
        ICopyFileAreaManager.ICopyFileAreaLockRequestFactory lockFactory = ICopyFileAreaManager.instance.lockRequestFactory();
        ArrayList<ICopyFileAreaLockRequest> requests = new ArrayList<ICopyFileAreaLockRequest>();
        for (Map.Entry<ISandbox, Map<IConnection, Map<ConfigurationFacade, Set<LoadRequest>>>> requestsByConnection : this.requestsByCFA.entrySet()) {
            HashSet<ConfigurationFacade> configurations = new HashSet<ConfigurationFacade>();
            ILocation copyFileAreaRoot = requestsByConnection.getKey().getRoot();
            for (Map<ConfigurationFacade, Set<LoadRequest>> requestsByConfigurations : requestsByConnection.getValue().values()) {
                configurations.addAll(requestsByConfigurations.keySet());
            }
            requests.add(lockFactory.getLockRequest(copyFileAreaRoot, configurations, true));
        }
        return requests;
    }

    protected final Set<ConfigurationFacade> getAffectedConfigurations() {
        HashSet<ConfigurationFacade> configurationsAffected = new HashSet<ConfigurationFacade>();
        for (Map<IConnection, Map<ConfigurationFacade, Set<LoadRequest>>> requestsByConnection : this.requestsByCFA.values()) {
            for (Map<ConfigurationFacade, Set<LoadRequest>> requestsByConfig : requestsByConnection.values()) {
                configurationsAffected.addAll(requestsByConfig.keySet());
            }
        }
        return configurationsAffected;
    }

    @Override
    public void notifyDilemmaHandler(IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Map<ConfigurationFacade, Set<ISandbox>> configurationSandboxes = this.getConfigurationSandboxes(this.getAffectedConfigurations(), (IProgressMonitor)progress.newChild(40));
        this.notifyDilemmaHandler(configurationSandboxes, (IProgressMonitor)progress.newChild(60));
    }

    protected void notifyDilemmaHandler(Map<ConfigurationFacade, Set<ISandbox>> configurationSandboxes, IProgressMonitor reporter) throws TeamRepositoryException, FileSystemException {
        int reaction;
        Collection<IMultipleSandboxLoad> multipleSandboxes;
        MultiStatus status;
        int reaction2;
        MultiStatus status2;
        int i;
        int result;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)reporter, (int)(100 + this.requestsByCFA.size()));
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!this.loadOverLaps.isEmpty()) {
            result = this.dilemmaHandler.overlappingLoadRequests(Collections.unmodifiableCollection(this.loadOverLaps));
            if (result == 1) {
                throw new OperationCanceledException();
            }
            if (result != 0) {
                IStatus[] reportedOverlaps = new IStatus[this.loadOverLaps.size()];
                i = 0;
                for (ILoadOverlap overlap : this.loadOverLaps) {
                    String msg = "";
                    if (!overlap.getOverlappingShares().isEmpty()) {
                        msg = NLS.bind((String)Messages.LoadOperation_1, (Object)PathUtils.getString(overlap.getPath()), (Object)overlap.getOverlappingShares().size());
                    }
                    if (!overlap.getOverlappingItems().isEmpty()) {
                        msg = NLS.bind((String)Messages.LoadOperation_2, (Object)PathUtils.getString(overlap.getPath()), (Object)overlap.getOverlappingItems().size());
                    }
                    reportedOverlaps[i] = FileSystemStatusUtil.getStatusFor(4, msg);
                    ++i;
                }
                status2 = new MultiStatus("com.ibm.team.filesystem.client", 2, reportedOverlaps, Messages.LoadOperation_3, null);
                this.reportErrorsAsException(new IStatus[]{status2});
            }
        }
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!this.newItems.isEmpty()) {
            result = this.dilemmaHandler.newItemsToLoad(Collections.unmodifiableCollection(this.newItems.values()));
            if (result == 0) {
                for (IShareableToLoad newItem : this.newItems.values()) {
                    if (newItem.willLoad()) continue;
                    this.treesToLoad.remove(newItem.getLoadLocation());
                }
            } else {
                if (result == 1) {
                    throw new OperationCanceledException();
                }
                IStatus[] reportedNewItems = new IStatus[this.newItems.size()];
                i = 0;
                for (IShareableToLoad shareableToLoad : this.newItems.values()) {
                    reportedNewItems[i] = FileSystemStatusUtil.getStatusFor(2, shareableToLoad.getShareable().getLocalPath() + Messages.LoadOperation_4);
                    ++i;
                }
                status2 = new MultiStatus("com.ibm.team.filesystem.client", 2, reportedNewItems, Messages.LoadOperation_5, null);
                this.reportErrorsAsException(new IStatus[]{status2});
            }
        }
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (this.invalidLoadLocations.size() > 0 && (reaction2 = this.dilemmaHandler.invalidLoadLocations(this.getInvalidLoadLocations())) != 0) {
            if (reaction2 == 1) {
                throw new OperationCanceledException();
            }
            IStatus[] reasons = new IStatus[this.invalidLoadLocations.size()];
            int i2 = 0;
            for (IInvalidLoadLocation invalidLocation : this.invalidLoadLocations.values()) {
                reasons[i2] = ((InvalidLoadLocation)invalidLocation).getStatus();
                ++i2;
            }
            status2 = new MultiStatus("com.ibm.team.filesystem.client", 4, reasons, NLS.bind((String)Messages.LoadOperation_15, (Object)this.invalidLoadLocations.size()), null);
            this.reportErrorsAsException(new IStatus[]{status2});
        }
        if (this.collisions.size() > 0 || this.sharesToRemove.size() > 0) {
            Collection<IRemovedShare> sharesForRemoval = this.getSharesToBeRemoved();
            int result2 = this.dilemmaHandler.collision(Collections.unmodifiableCollection(this.collisions.values()), Collections.unmodifiableCollection(sharesForRemoval), Collections.unmodifiableCollection(this.sharesOutOfSync));
            if (result2 == 0) {
                ICollision[] collisionDecisions = this.collisions.values().toArray(new ICollision[this.collisions.size()]);
                int i3 = 0;
                while (i3 < collisionDecisions.length) {
                    LoadLocation loadLocation;
                    ICollision collision = collisionDecisions[i3];
                    IStatus status3 = collision.getStatus();
                    if (status3.getCode() == 4) {
                        this.reportErrorsAsException(new IStatus[]{status3});
                    }
                    if ((loadLocation = (LoadLocation)collision.getLoadLocation()) != null) {
                        this.treesToLoad.add(loadLocation);
                    }
                    ++i3;
                }
            } else if (result2 != 1) {
                IStatus[] reportedCollisions = new IStatus[this.collisions.size() + sharesForRemoval.size()];
                int i4 = 0;
                Iterator<ICollision> iCollisions = this.collisions.values().iterator();
                while (iCollisions.hasNext()) {
                    reportedCollisions[i4] = iCollisions.next().getStatus();
                    ++i4;
                }
                for (IRemovedShare removedShare : sharesForRemoval) {
                    reportedCollisions[i4] = FileSystemStatusUtil.getStatusFor(2, NLS.bind((String)Messages.LoadOperation_0, (Object)removedShare.getLocalPath()));
                    ++i4;
                }
                status = new MultiStatus("com.ibm.team.filesystem.client", 2, reportedCollisions, Messages.LoadOperation_7, null);
                this.reportErrorsAsException(new IStatus[]{status});
            } else {
                throw new OperationCanceledException();
            }
        }
        if ((multipleSandboxes = this.validateMultipleCopyFileAreas(configurationSandboxes, (IProgressMonitor)progress.newChild(10))).size() > 0 && (reaction = this.dilemmaHandler.multipleSandboxLoad(multipleSandboxes)) != 0) {
            if (reaction == 1) {
                throw new OperationCanceledException();
            }
            IStatus status4 = FileSystemStatusUtil.getStatusFor(4, Messages.LoadOperation_19, null);
            this.reportErrorsAsException(new IStatus[]{status4});
        }
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (this.invalidLoadRequests.size() > 0 && (reaction = this.dilemmaHandler.invalidLoadRequest(Collections.unmodifiableCollection(this.invalidLoadRequests))) != 0) {
            if (reaction == 1) {
                throw new OperationCanceledException();
            }
            IStatus[] reasons = new IStatus[this.invalidLoadRequests.size()];
            int i5 = 0;
            for (IInvalidLoadRequest request : this.invalidLoadRequests) {
                reasons[i5] = ((InvalidLoadRequest)request).getStatus();
                ++i5;
            }
            status = new MultiStatus("com.ibm.team.filesystem.client", 4, reasons, NLS.bind((String)Messages.LoadOperation_15, (Object)this.invalidLoadRequests.size()), null);
            this.reportErrorsAsException(new IStatus[]{status});
        }
        progress.done();
    }

    protected boolean maintainShareInfo() {
        return true;
    }

    protected void load(IDownloadListener downloadMonitor, Map<IConnection, ISandbox> loadedConnectionsToSandboxMap, IProgressMonitor reporter) throws TeamRepositoryException, FileSystemException {
        SubMonitor subProgress = SubMonitor.convert((IProgressMonitor)reporter, (int)(this.treesToLoad.size() * 10 + this.sharesToRemove.size()));
        int configCount = 0;
        HashMap toLoad = new HashMap();
        for (LoadLocation loadLocation : this.treesToLoad) {
            ConfigurationFacade descriptor;
            ArrayList<LoadLocation> itemsToLoad;
            HashMap<ConfigurationFacade, ArrayList<LoadLocation>> componentsToLoad = (HashMap<ConfigurationFacade, ArrayList<LoadLocation>>)toLoad.get(loadLocation.getSandbox());
            if (componentsToLoad == null) {
                componentsToLoad = new HashMap<ConfigurationFacade, ArrayList<LoadLocation>>();
                toLoad.put(loadLocation.getSandbox(), componentsToLoad);
            }
            if ((itemsToLoad = (ArrayList<LoadLocation>)componentsToLoad.get((Object)(descriptor = new ConfigurationFacade(loadLocation.getConnection(), (IComponentHandle)loadLocation.getComponent())))) == null) {
                ++configCount;
                itemsToLoad = new ArrayList<LoadLocation>();
                componentsToLoad.put(descriptor, itemsToLoad);
            }
            itemsToLoad.add(loadLocation);
        }
        for (Map.Entry entry : this.sharesToRemove.entrySet()) {
            subProgress.setTaskName(Messages.LoadOperation_9);
            ILoadMutator mutator = SharingManager.getInstance().getLoadMutator((ISandbox)entry.getKey(), this.dilemmaHandler);
            mutator.configureShareRemoval((Set)entry.getValue());
            mutator.run((IProgressMonitor)subProgress.newChild(1));
        }
        subProgress.beginTask(Messages.LoadOperation_10, this.treesToLoad.size() * 10);
        LockAndLoadFileVisitor lockAndLoadFileVisitor = new LockAndLoadFileVisitor();
        block16: for (Map.Entry toLoadEntry : toLoad.entrySet()) {
            ISandbox sandbox = (ISandbox)toLoadEntry.getKey();
            boolean sandboxRegistered = false;
            Map componentsToLoad = (Map)toLoadEntry.getValue();
            ArrayList allLocations = new ArrayList();
            for (List itemsToLoad : componentsToLoad.values()) {
                allLocations.addAll(itemsToLoad);
            }
            Collections.sort(allLocations, new Comparator<LoadLocation>(){

                @Override
                public int compare(LoadLocation loadLocation1, LoadLocation loadLocation2) {
                    return loadLocation1.getLoadPath().toString().compareTo(loadLocation2.getLoadPath().toString());
                }
            });
            boolean hasNestedShares = false;
            IRelativeLocation previous = null;
            for (LoadLocation location : allLocations) {
                if (previous == null) {
                    previous = location.getLoadPath();
                    continue;
                }
                if (previous.isPrefixOf(location.getLoadPath())) {
                    location.setNested();
                    hasNestedShares = true;
                    continue;
                }
                previous = location.getLoadPath();
            }
            if (hasNestedShares) {
                int allLocationsSize = allLocations.size();
                SubProgressMonitor dlMonitor = new SubProgressMonitor((IProgressMonitor)subProgress, allLocationsSize * 8 + 8);
                int index = 0;
                for (LoadLocation location : allLocations) {
                    IConnection connection;
                    block47: {
                        List<LoadLocation> itemsToLoad = Collections.singletonList(location);
                        IComponent component = location.getComponent();
                        IFileSystemManager fsm = (IFileSystemManager)location.getConnection().teamRepository().getClientLibrary(IFileSystemManager.class);
                        connection = location.getConnection();
                        FileSystemServiceProxy fss = ((FileSystemManager)fsm).getFileSystemService();
                        dlMonitor.setTaskName(NLS.bind((String)Messages.LoadOperation_21, (Object[])new Object[]{connection.getName(), location.getLoadPath(), component.getName(), index + 1, allLocationsSize}));
                        dlMonitor.worked(1);
                        ++index;
                        subProgress.subTask(NLS.bind((String)Messages.LoadOperation_12, (Object)location.getLoadPath()));
                        IVersionableHandle[] versionableHandles = new IVersionableHandle[itemsToLoad.size()];
                        int j = 0;
                        for (ILoadLocation iLoadLocation : itemsToLoad) {
                            versionableHandles[j] = ((LoadLocation)iLoadLocation).getRootToLoad();
                            ++j;
                        }
                        LoadTree loadTree = fss.getFileTreeByVersionable(connection, (IComponentHandle)component, versionableHandles, -1, true, this.synchronizationInfo, (IProgressMonitor)subProgress.newChild(itemsToLoad.size() * 2));
                        if (!sandboxRegistered) {
                            SharingManager.getInstance().register(sandbox, false, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)dlMonitor, 8));
                            sandboxRegistered = true;
                        }
                        if (!loadTree.getInaccessible().getRequests().isEmpty()) {
                            HashSet<UUID> inacessibleVersionables = new HashSet<UUID>();
                            for (IVersionableHandle handle : loadTree.getInaccessible().getRequests()) {
                                inacessibleVersionables.add(handle.getItemId());
                            }
                            ArrayList<IInvalidLoadRequest> inaccessibleForLoading = new ArrayList<IInvalidLoadRequest>();
                            for (LoadLocation aLoadLocation : itemsToLoad) {
                                if (!inacessibleVersionables.contains(aLoadLocation.getRootToLoad().getItemId())) continue;
                                LoadRequest loadRequest = new LoadRequest(aLoadLocation.getSandbox(), aLoadLocation.getLoadPath().removeLastSegments(1), aLoadLocation.isLoadWithAnotherName() ? aLoadLocation.getLoadPath().getName() : null, connection, (IComponentHandle)aLoadLocation.getComponent(), aLoadLocation.getRootToLoad(), false);
                                IStatus msg = FileSystemStatusUtil.getStatusFor(2, Messages.LoadOperation_16);
                                InvalidLoadRequest invalidRequest = new InvalidLoadRequest(loadRequest, IInvalidLoadRequest.InvalidLoadRequestReason.NonExistantItem, msg);
                                inaccessibleForLoading.add(invalidRequest);
                            }
                            int direction = this.dilemmaHandler.invalidLoadRequest(inaccessibleForLoading);
                            if (direction == 1) {
                                throw new OperationCanceledException();
                            }
                            if (direction != 0) {
                                throw new FileSystemException(NLS.bind((String)Messages.LoadOperation_6, (Object)inaccessibleForLoading.size()));
                            }
                        }
                        ILoadMutator mutator = SharingManager.getInstance().getLoadMutator(sandbox, this.dilemmaHandler);
                        mutator.configureLoad(this.options, connection, component, itemsToLoad, loadTree, downloadMonitor, this.filter);
                        if (mutator instanceof ILoadMutator2) {
                            ILoadMutator2 lm2 = (ILoadMutator2)mutator;
                            lm2.setLoadedFileVisitor(lockAndLoadFileVisitor);
                            lm2.setPreserveLocalChanges(this.isPreserveLocalChanges());
                            lm2.setPreserveFileTimestamps(this.isPreserveFileTimestamps);
                            lm2.setExpandKeywords(this.expandKeywords);
                            lm2.setSkipLocalRefresh(this.skipLocalRefresh);
                        }
                        SharingManager.getInstance().beginAvoidSandboxListening(sandbox, (IComponentHandle)component);
                        try {
                            mutator.run((IProgressMonitor)dlMonitor);
                        }
                        catch (EclipseReadException e) {
                            this.isEclipseMetadataReadFailure = true;
                            IStatus s = FileSystemStatusUtil.getStatusFor((Throwable)((Object)e));
                            this.saveRecursiveMessages(s, this.eclipseReadMessages);
                            this.savedEclipseReadException = e;
                            SharingManager.getInstance().endAvoidSandboxListening(sandbox, (IComponentHandle)component);
                            dlMonitor.done();
                            break block47;
                        }
                        catch (FileSystemException e) {
                            try {
                                IStatus status = FileSystemStatusUtil.getStatusFor((Throwable)((Object)e));
                                this.collectStatus(status);
                                if (status.getSeverity() == 4) {
                                    continue block16;
                                }
                                break block47;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                SharingManager.getInstance().endAvoidSandboxListening(sandbox, (IComponentHandle)component);
                                dlMonitor.done();
                            }
                        }
                        SharingManager.getInstance().endAvoidSandboxListening(sandbox, (IComponentHandle)component);
                        dlMonitor.done();
                    }
                    if (subProgress.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    loadedConnectionsToSandboxMap.put(connection, sandbox);
                }
                continue;
            }
            int i = 1;
            for (List itemsToLoad : componentsToLoad.values()) {
                IConnection connection;
                block48: {
                    LoadLocation location;
                    location = (LoadLocation)itemsToLoad.get(0);
                    SubProgressMonitor dlMonitor = new SubProgressMonitor((IProgressMonitor)subProgress, itemsToLoad.size() * 8 + 8);
                    IFileSystemManager fsm = (IFileSystemManager)location.getConnection().teamRepository().getClientLibrary(IFileSystemManager.class);
                    connection = location.getConnection();
                    FileSystemServiceProxy fss = ((FileSystemManager)fsm).getFileSystemService();
                    dlMonitor.setTaskName(NLS.bind((String)Messages.LoadOperation_11, (Object[])new Object[]{connection.getName(), location.getComponent().getName(), i, configCount}));
                    subProgress.subTask(NLS.bind((String)Messages.LoadOperation_12, (Object)location.getComponent().getName()));
                    IVersionableHandle[] versionableHandles = new IVersionableHandle[itemsToLoad.size()];
                    int j = 0;
                    for (ILoadLocation loadLocation : itemsToLoad) {
                        versionableHandles[j] = ((LoadLocation)loadLocation).getRootToLoad();
                        ++j;
                    }
                    LoadTree loadTree = fss.getFileTreeByVersionable(connection, (IComponentHandle)location.getComponent(), versionableHandles, -1, true, this.synchronizationInfo, (IProgressMonitor)subProgress.newChild(itemsToLoad.size() * 2));
                    if (!sandboxRegistered) {
                        SharingManager.getInstance().register(sandbox, false, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)dlMonitor, 8));
                        sandboxRegistered = true;
                    }
                    if (!loadTree.getInaccessible().getRequests().isEmpty()) {
                        HashSet<UUID> inacessibleVersionables = new HashSet<UUID>();
                        for (IVersionableHandle iVersionableHandle : loadTree.getInaccessible().getRequests()) {
                            inacessibleVersionables.add(iVersionableHandle.getItemId());
                        }
                        ArrayList<IInvalidLoadRequest> arrayList = new ArrayList<IInvalidLoadRequest>();
                        for (LoadLocation aLoadLocation : itemsToLoad) {
                            if (!inacessibleVersionables.contains(aLoadLocation.getRootToLoad().getItemId())) continue;
                            LoadRequest loadRequest = new LoadRequest(aLoadLocation.getSandbox(), aLoadLocation.getLoadPath().removeLastSegments(1), aLoadLocation.isLoadWithAnotherName() ? aLoadLocation.getLoadPath().getName() : null, connection, (IComponentHandle)aLoadLocation.getComponent(), aLoadLocation.getRootToLoad(), false);
                            IStatus msg = FileSystemStatusUtil.getStatusFor(2, Messages.LoadOperation_16);
                            InvalidLoadRequest invalidRequest = new InvalidLoadRequest(loadRequest, IInvalidLoadRequest.InvalidLoadRequestReason.NonExistantItem, msg);
                            arrayList.add(invalidRequest);
                        }
                        int direction = this.dilemmaHandler.invalidLoadRequest(arrayList);
                        if (direction == 1) {
                            throw new OperationCanceledException();
                        }
                        if (direction != 0) {
                            throw new FileSystemException(NLS.bind((String)Messages.LoadOperation_6, (Object)arrayList.size()));
                        }
                    }
                    ILoadMutator mutator = SharingManager.getInstance().getLoadMutator(sandbox, this.dilemmaHandler);
                    mutator.configureLoad(this.options, connection, location.getComponent(), itemsToLoad, loadTree, downloadMonitor, this.filter);
                    if (mutator instanceof ILoadMutator2) {
                        ILoadMutator2 iLoadMutator2 = (ILoadMutator2)mutator;
                        iLoadMutator2.setLoadedFileVisitor(lockAndLoadFileVisitor);
                        iLoadMutator2.setPreserveLocalChanges(this.isPreserveLocalChanges());
                        iLoadMutator2.setPreserveFileTimestamps(this.isPreserveFileTimestamps);
                        iLoadMutator2.setExpandKeywords(this.expandKeywords);
                        iLoadMutator2.setSkipLocalRefresh(this.skipLocalRefresh);
                    }
                    SharingManager.getInstance().beginAvoidSandboxListening(sandbox, (IComponentHandle)location.getComponent());
                    try {
                        mutator.run((IProgressMonitor)dlMonitor);
                        if (mutator instanceof ILoadMutator2) {
                            this.symbolicLinksToRefresh.addAll(((ILoadMutator2)mutator).getSymbolicLinksLoaded());
                        }
                    }
                    catch (EclipseReadException eclipseReadException) {
                        this.isEclipseMetadataReadFailure = true;
                        IStatus s = FileSystemStatusUtil.getStatusFor((Throwable)((Object)eclipseReadException));
                        this.saveRecursiveMessages(s, this.eclipseReadMessages);
                        this.savedEclipseReadException = eclipseReadException;
                        SharingManager.getInstance().endAvoidSandboxListening(sandbox, (IComponentHandle)location.getComponent());
                        dlMonitor.done();
                        break block48;
                    }
                    catch (FileSystemException fileSystemException) {
                        try {
                            IStatus status = FileSystemStatusUtil.getStatusFor((Throwable)((Object)fileSystemException));
                            this.collectStatus(status);
                            if (status.getSeverity() == 4) {
                                continue block16;
                            }
                            break block48;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            SharingManager.getInstance().endAvoidSandboxListening(sandbox, (IComponentHandle)location.getComponent());
                            dlMonitor.done();
                        }
                    }
                    SharingManager.getInstance().endAvoidSandboxListening(sandbox, (IComponentHandle)location.getComponent());
                    dlMonitor.done();
                }
                if (subProgress.isCanceled()) {
                    throw new OperationCanceledException();
                }
                ++i;
                loadedConnectionsToSandboxMap.put(connection, sandbox);
            }
        }
        subProgress.setTaskName(Messages.LoadOperation_13);
        subProgress.done();
    }

    @Override
    public int getEclipseSpecificLoadOptions() {
        return this.options;
    }

    @Override
    public void setEclipseSpecificLoadOptions(int options) {
        if ((options & 3) == 3) {
            throw new IllegalArgumentException("Only one of CREATE_PROJECTS_FOR_NEW_SHARE_ROOTS or IMPORT_PROJECTS can be specified");
        }
        if (options > 15) {
            throw new IllegalArgumentException("Invalid option " + options);
        }
        this.options = options;
    }

    @Override
    public ILoadFilter getLoadFilter() {
        return this.filter;
    }

    @Override
    public void setLoadFilter(ILoadFilter filter) {
        this.filter = filter;
    }

    private Map<ILoadRequest, IInvalidLoadLocation> validateSandboxOverlap() {
        HashMap<ILoadRequest, IInvalidLoadLocation> overlappingSandboxes = new HashMap<ILoadRequest, IInvalidLoadLocation>();
        HashSet<ISandbox> allCopyFileAreas = new HashSet<ISandbox>();
        allCopyFileAreas.addAll(SharingManager.getInstance().getRegisteredSandboxes());
        ArrayList<ISandbox> sandboxesToBeLoaded = new ArrayList<ISandbox>(this.requestsByCFA.size());
        sandboxesToBeLoaded.addAll(this.requestsByCFA.keySet());
        Iterator<Map.Entry<ISandbox, Map<IConnection, Map<ConfigurationFacade, Set<LoadRequest>>>>> i = this.requestsByCFA.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<ISandbox, Map<IConnection, Map<ConfigurationFacade, Set<LoadRequest>>>> entry = i.next();
            Map<ILoadRequest, IInvalidLoadLocation> invalidRequests = LoadEvaluator.validateCopyFileAreas(entry.getKey(), entry.getValue(), sandboxesToBeLoaded, allCopyFileAreas);
            if (invalidRequests.isEmpty()) continue;
            i.remove();
            overlappingSandboxes.putAll(invalidRequests);
        }
        return overlappingSandboxes;
    }

    @Override
    public void setPreserveLocalChanges(boolean isPreserveLocalChanges) {
        this.isPreserveLocalChanges = isPreserveLocalChanges;
    }

    @Override
    public boolean isPreserveLocalChanges() {
        return this.isPreserveLocalChanges;
    }

    @Override
    public void setPreserveFileTimestamps(boolean isPreserveFileTimestamps) {
        this.isPreserveFileTimestamps = isPreserveFileTimestamps;
    }

    @Override
    public boolean isPreserveFileTimestamps() {
        return this.isPreserveFileTimestamps;
    }

    @Override
    public void setExpandKeywords(boolean enabled) {
        this.expandKeywords = enabled;
    }

    @Override
    public boolean isExpandKeywords() {
        return this.expandKeywords;
    }

    public boolean isSkipLocalRefresh() {
        return this.skipLocalRefresh;
    }

    @Override
    public void setSkipLocalRefresh(boolean skipLocalRefresh) {
        this.skipLocalRefresh = skipLocalRefresh;
    }

    private void refreshLinks(Set<Shareable> linksToRefresh, IProgressMonitor progress) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)linksToRefresh.size());
        for (Shareable shareable : linksToRefresh) {
            try {
                new Shareable(shareable.getSandbox(), shareable.getLocalPath(), ResourceType.SYMBOLIC_LINK).getFileStorage().refreshCachedSubTree(Integer.MAX_VALUE, (IProgressMonitor)monitor.newChild(1));
            }
            catch (FileSystemException fileSystemException) {
                // empty catch block
            }
        }
    }

    static /* synthetic */ Map access$0(LoadOperation loadOperation) {
        return loadOperation.validateSandboxOverlap();
    }

    static /* synthetic */ List access$1(LoadOperation loadOperation) {
        return loadOperation.cfaLockRequests();
    }

    static /* synthetic */ Set access$2(LoadOperation loadOperation) {
        return loadOperation.copyFileAreasAffected;
    }

    static /* synthetic */ Map access$3(LoadOperation loadOperation) {
        return loadOperation.requestsByCFA;
    }

    static /* synthetic */ void access$4(LoadOperation loadOperation, Map map, IProgressMonitor iProgressMonitor) throws FileSystemException, TeamRepositoryException {
        loadOperation.internalEvaluateLoadRequests(map, iProgressMonitor);
    }

    static /* synthetic */ IDownloadListener access$5(LoadOperation loadOperation) {
        return loadOperation.downloadMonitor;
    }

    static /* synthetic */ Set access$6(LoadOperation loadOperation) {
        return loadOperation.symbolicLinksToRefresh;
    }

    static /* synthetic */ void access$7(LoadOperation loadOperation, Set set, IProgressMonitor iProgressMonitor) {
        loadOperation.refreshLinks(set, iProgressMonitor);
    }
}

