/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.load.InvalidLoadLocation;
import com.ibm.team.filesystem.client.internal.load.LoadLocation;
import com.ibm.team.filesystem.client.internal.load.LoadRequest;
import com.ibm.team.filesystem.client.internal.operations.ILoadEvaluator;
import com.ibm.team.filesystem.client.internal.operations.MultipleSandboxLoad;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.RepoIdConnectionComponentTriple;
import com.ibm.team.filesystem.client.operations.ICollision;
import com.ibm.team.filesystem.client.operations.IInvalidLoadLocation;
import com.ibm.team.filesystem.client.operations.ILoadLocation;
import com.ibm.team.filesystem.client.operations.ILoadRequest;
import com.ibm.team.filesystem.client.operations.IMultipleSandboxLoad;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public abstract class LoadEvaluator
implements ILoadEvaluator {
    protected Map<ISandbox, Map<IConnection, Map<ConfigurationFacade, Set<LoadRequest>>>> requestsByCFA;
    private Map<ILoadRequest, IInvalidLoadLocation> invalidLoadLocations = new HashMap<ILoadRequest, IInvalidLoadLocation>();

    protected abstract void doEvaluation(IProgressMonitor var1) throws FileSystemException, TeamRepositoryException;

    protected LoadEvaluator() {
    }

    @Override
    public void setRequests(ISandbox sandbox, Map<IConnection, Map<ConfigurationFacade, Set<LoadRequest>>> requests) {
        if (this.requestsByCFA == null) {
            this.requestsByCFA = new HashMap<ISandbox, Map<IConnection, Map<ConfigurationFacade, Set<LoadRequest>>>>();
        }
        if (this.invalidLoadLocations == null) {
            this.invalidLoadLocations = new HashMap<ILoadRequest, IInvalidLoadLocation>();
        }
        HashMap bySandbox = new HashMap();
        this.requestsByCFA.put(sandbox, bySandbox);
        for (Map.Entry<IConnection, Map<ConfigurationFacade, Set<LoadRequest>>> entry : requests.entrySet()) {
            HashMap byConnection = new HashMap();
            bySandbox.put(entry.getKey(), byConnection);
            for (Map.Entry<ConfigurationFacade, Set<LoadRequest>> entry2 : entry.getValue().entrySet()) {
                byConnection.put(entry2.getKey(), new HashSet(entry2.getValue()));
            }
        }
    }

    @Override
    public final void evaluateLoadRequests(IProgressMonitor progress) throws FileSystemException, TeamRepositoryException {
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.doEvaluation(progress);
    }

    @Override
    public final Collection<IMultipleSandboxLoad> getMultipleSandboxLoads(IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        Set<ConfigurationFacade> affectedConfigurations = this.getAffectedConfigurations();
        Map<ConfigurationFacade, Set<ISandbox>> configurationSandboxes = this.getConfigurationSandboxes(affectedConfigurations, (IProgressMonitor)monitor.newChild(10));
        Collection<IMultipleSandboxLoad> result = this.validateMultipleCopyFileAreas(configurationSandboxes, (IProgressMonitor)monitor.newChild(90));
        result.addAll(this.getMultipleClientLoads(result));
        return result;
    }

    private Collection<IMultipleSandboxLoad> validateMultipleCopyFileAreas(Map<ConfigurationFacade, Set<ISandbox>> configurationSandboxes, IProgressMonitor monitor) throws FileSystemException {
        HashMap<ConfigurationFacade, Set<ISandbox>> multipleCFA = new HashMap<ConfigurationFacade, Set<ISandbox>>();
        HashMap<ConfigurationFacade, Set<ILoadLocation>> loadLocations = new HashMap<ConfigurationFacade, Set<ILoadLocation>>();
        this.recordSandbox(this.getItemsToLoad(), multipleCFA, loadLocations);
        for (ICollision collision : this.getCollisions().values()) {
            this.recordSandbox(collision.getLocations(), multipleCFA, loadLocations);
        }
        ArrayList<IMultipleSandboxLoad> result = new ArrayList<IMultipleSandboxLoad>();
        for (Map.Entry entry : multipleCFA.entrySet()) {
            ConfigurationFacade configuration = (ConfigurationFacade)((Object)entry.getKey());
            Set<ISandbox> loadedSandboxes = configurationSandboxes.get((Object)configuration);
            Set sandboxes = (Set)entry.getValue();
            if (loadedSandboxes != null) {
                sandboxes.addAll(loadedSandboxes);
            }
            if (sandboxes.size() <= 1) continue;
            boolean multipleSandboxesAllowed = true;
            for (LoadLocation loadLoc : this.getItemsToLoad()) {
                if (loadLoc.getRootToLoad() instanceof IFileItemHandle) continue;
                multipleSandboxesAllowed = false;
                break;
            }
            if (multipleSandboxesAllowed) {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(2 * sandboxes.size()));
                block3: for (ISandbox sandbox : sandboxes) {
                    IShare[] shares = sandbox.allShares((IProgressMonitor)progress.newChild(1));
                    SubMonitor subProgress = SubMonitor.convert((IProgressMonitor)progress.newChild(1), (int)shares.length);
                    IShare[] iShareArray = shares;
                    int n = shares.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IShare share = iShareArray[n2];
                        ISharingDescriptor dtor = share.getSharingDescriptor();
                        if (configuration.id.equals((Object)dtor.getRepositoryId()) && configuration.getComponentHandle().getItemId().equals((Object)dtor.getComponent().getItemId()) && configuration.getConnectionHandle().getItemId().equals((Object)dtor.getConnectionHandle().getItemId())) {
                            if (share.getShareable().getResourceType((IProgressMonitor)subProgress.newChild(1)) != ResourceType.FILE) {
                                multipleSandboxesAllowed = false;
                                break block3;
                            }
                            IVersionableHandle rootVersionable = share.getSharingDescriptor().getRootVersionable();
                            Set locations = (Set)loadLocations.get((Object)configuration);
                            if (locations != null) {
                                for (ILoadLocation loadLocation : locations) {
                                    if (!rootVersionable.getItemId().equals((Object)loadLocation.getRootToLoad().getItemId())) continue;
                                    multipleSandboxesAllowed = false;
                                    break block3;
                                }
                            }
                        } else {
                            subProgress.worked(1);
                        }
                        ++n2;
                    }
                }
            }
            if (multipleSandboxesAllowed) continue;
            MultipleSandboxLoad multipleSandboxLoad = new MultipleSandboxLoad(configuration, sandboxes, (Set)loadLocations.get((Object)configuration));
            result.add(multipleSandboxLoad);
        }
        return result;
    }

    private void recordSandbox(Collection<? extends ILoadLocation> toLoad, Map<ConfigurationFacade, Set<ISandbox>> multipleCFA, Map<ConfigurationFacade, Set<ILoadLocation>> loadLocations) {
        for (ILoadLocation iLoadLocation : toLoad) {
            ConfigurationFacade configuration = new ConfigurationFacade(iLoadLocation.getConnection(), (IComponentHandle)iLoadLocation.getComponent());
            Set<ISandbox> sandboxes = multipleCFA.get((Object)configuration);
            if (sandboxes == null) {
                sandboxes = new HashSet<ISandbox>();
                multipleCFA.put(configuration, sandboxes);
            }
            sandboxes.add(iLoadLocation.getSandbox());
            Set<ILoadLocation> locations = loadLocations.get((Object)configuration);
            if (locations == null) {
                locations = new HashSet<ILoadLocation>();
                loadLocations.put(configuration, locations);
            }
            locations.add(iLoadLocation);
        }
    }

    public static final Map<ILoadRequest, IInvalidLoadLocation> validateCopyFileAreas(ISandbox sandbox, Map<IConnection, Map<ConfigurationFacade, Set<LoadRequest>>> requestsByConnectionForSandbox, Collection<ISandbox> sandboxesToBeLoaded, Set<ISandbox> allCopyFileAreas) {
        HashMap<ILoadRequest, IInvalidLoadLocation> invalidSandboxes = new HashMap<ILoadRequest, IInvalidLoadLocation>();
        if (!allCopyFileAreas.contains(sandbox)) {
            HashSet<ISandbox> copyFileAreasOverlapped = null;
            for (ISandbox iSandbox : allCopyFileAreas) {
                if (!sandbox.getRoot().isPrefixOf(iSandbox.getRoot()) && !iSandbox.getRoot().isPrefixOf(sandbox.getRoot())) continue;
                if (copyFileAreasOverlapped == null) {
                    copyFileAreasOverlapped = new HashSet<ISandbox>();
                }
                copyFileAreasOverlapped.add(iSandbox);
            }
            for (ISandbox iSandbox : sandboxesToBeLoaded) {
                if (sandbox.equals(iSandbox) || !sandbox.getRoot().isPrefixOf(iSandbox.getRoot()) && !iSandbox.getRoot().isPrefixOf(sandbox.getRoot())) continue;
                if (copyFileAreasOverlapped == null) {
                    copyFileAreasOverlapped = new HashSet();
                }
                copyFileAreasOverlapped.add(iSandbox);
            }
            if (copyFileAreasOverlapped != null) {
                for (Map map : requestsByConnectionForSandbox.values()) {
                    for (Set loadRequests : map.values()) {
                        for (ILoadRequest loadRequest : loadRequests) {
                            InvalidLoadLocation invalidLoadLocation = new InvalidLoadLocation(loadRequest);
                            invalidLoadLocation.addCopyFileAreaPaths(copyFileAreasOverlapped);
                            invalidSandboxes.put(loadRequest, invalidLoadLocation);
                        }
                    }
                }
            }
        }
        return invalidSandboxes;
    }

    protected final void addInvalidLoadLocation(ILoadRequest request, IInvalidLoadLocation invalidLoadLocation) {
        this.invalidLoadLocations.put(request, invalidLoadLocation);
    }

    protected final Collection<IMultipleSandboxLoad> getMultipleClientLoads(Collection<IMultipleSandboxLoad> existingLoadWarnings) {
        HashSet<IConnection> existingConnectionsWithWarnings = new HashSet<IConnection>();
        for (IMultipleSandboxLoad warning : existingLoadWarnings) {
            Collection<ILoadLocation> loadLocations = warning.getLoadLocations();
            if (loadLocations.isEmpty()) continue;
            existingConnectionsWithWarnings.add(loadLocations.iterator().next().getConnection());
        }
        HashMap<IConnection, MultipleSandboxLoad> results = new HashMap<IConnection, MultipleSandboxLoad>();
        for (Map.Entry<ISandbox, Map<IConnection, Map<ConfigurationFacade, Set<LoadRequest>>>> entry : this.requestsByCFA.entrySet()) {
            ISandbox sandbox = entry.getKey();
            for (Map<ConfigurationFacade, Set<LoadRequest>> loadRequestsByConfigurationMap : entry.getValue().values()) {
                for (Map.Entry<ConfigurationFacade, Set<LoadRequest>> loadRequestsByConfigurationEntry : loadRequestsByConfigurationMap.entrySet()) {
                    ConfigurationFacade configuration = loadRequestsByConfigurationEntry.getKey();
                    Set<LoadRequest> loadRequestsByConfiguration = loadRequestsByConfigurationEntry.getValue();
                    for (LoadRequest loadRequest : loadRequestsByConfiguration) {
                        IWorkspaceConnection workspaceConnection;
                        IConnection connection = loadRequest.getConnection();
                        if (existingConnectionsWithWarnings.contains(connection) || !(connection instanceof IWorkspaceConnection) || this.sameLoadLocation(workspaceConnection = (IWorkspaceConnection)connection, sandbox)) continue;
                        MultipleSandboxLoad aResult = new MultipleSandboxLoad(configuration, workspaceConnection);
                        results.put(connection, aResult);
                    }
                }
            }
        }
        return results.values();
    }

    private boolean sameLoadLocation(IWorkspaceConnection connection, ISandbox sandbox) {
        String lastLoadHost = connection.getLastLoadHost();
        String lastLoadPath = connection.getLastLoadPath();
        if (lastLoadHost == null || lastLoadPath == null) {
            return true;
        }
        String hostName = connection.getHostName();
        String loadPath = sandbox.getRoot().toString();
        return lastLoadHost.equals(hostName) && lastLoadPath.equals(loadPath);
    }

    protected final Set<ConfigurationFacade> getAffectedConfigurations() {
        HashSet<ConfigurationFacade> configurationsAffected = new HashSet<ConfigurationFacade>();
        for (Map<IConnection, Map<ConfigurationFacade, Set<LoadRequest>>> requestsByConnection : this.requestsByCFA.values()) {
            for (Map<ConfigurationFacade, Set<LoadRequest>> requestsByConfig : requestsByConnection.values()) {
                configurationsAffected.addAll(requestsByConfig.keySet());
            }
        }
        return configurationsAffected;
    }

    protected final Map<ConfigurationFacade, Set<ISandbox>> getConfigurationSandboxes(Set<ConfigurationFacade> affectedConfigurations, IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)affectedConfigurations.size());
        HashMap<ConfigurationFacade, Set<ISandbox>> result = new HashMap<ConfigurationFacade, Set<ISandbox>>();
        for (ConfigurationFacade configuration : affectedConfigurations) {
            Collection<ISandbox> sandboxes = SharingManager.getInstance().getSandboxes(configuration, (IProgressMonitor)monitor.newChild(1));
            result.put(configuration, new HashSet<ISandbox>(sandboxes));
        }
        return result;
    }

    protected final void organizeShares(ISandbox sandbox, Map<ILocation, IShare> allShares, Map<RepoIdConnectionComponentTriple, Map<UUID, IShare>> existingShares, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        ICopyFileAreaManager cfaManager = ICopyFileAreaManager.instance;
        if (cfaManager.copyFileAreaExists(sandbox.getRoot(), 1)) {
            IShare[] iShareArray = sandbox.allShares(monitor);
            int n = iShareArray.length;
            int n2 = 0;
            while (n2 < n) {
                IShare share = iShareArray[n2];
                if (share.getSharingDescriptor() != null) {
                    ISharingDescriptor shareDesc = share.getSharingDescriptor();
                    RepoIdConnectionComponentTriple descriptor = new RepoIdConnectionComponentTriple(shareDesc.getRepositoryId(), shareDesc.getConnectionHandle(), shareDesc.getComponent());
                    Map<UUID, IShare> shares = existingShares.get(descriptor);
                    if (shares == null) {
                        shares = new HashMap<UUID, IShare>();
                        existingShares.put(descriptor, shares);
                    }
                    shares.put(shareDesc.getRootVersionable().getItemId(), share);
                }
                ILocation path = sandbox.getRoot().append(share.getPath());
                allShares.put(path, share);
                ++n2;
            }
        }
    }

    protected final Map<UUID, Map<UUID, ? extends IVersionable>> fetchCompleteItems(IConnection connection, List<IComponentHandle> interestingComponents, List<List<? extends IVersionableHandle>> interestingVersionables, SubMonitor progress) throws TeamRepositoryException {
        HashMap<UUID, HashMap<UUID, IFolder>> fullVersionables;
        if (connection instanceof IWorkspaceConnection) {
            fullVersionables = ((IWorkspaceConnection)connection).configuration().fetchCompleteItems(interestingComponents, interestingVersionables, (IProgressMonitor)progress.newChild(10));
        } else {
            IConfiguration configuration = ((IBaselineConnection)connection).configuration();
            if (interestingComponents.size() != 1) {
                throw new IllegalStateException("There should be just 1 component in a baseline connection");
            }
            List<? extends IVersionableHandle> versionablesToGet = interestingVersionables.get(0);
            List fullFoldersRetrieved = configuration.fetchCompleteItems(versionablesToGet, (IProgressMonitor)progress.newChild(10));
            Iterator iFullFoldersRetrieved = fullFoldersRetrieved.iterator();
            HashMap<UUID, IFolder> fullFoldersForComponent = new HashMap<UUID, IFolder>();
            fullVersionables = new HashMap<UUID, HashMap<UUID, IFolder>>(1);
            fullVersionables.put(configuration.component().getItemId(), fullFoldersForComponent);
            for (IVersionableHandle iVersionableHandle : versionablesToGet) {
                IFolder folder = (IFolder)iFullFoldersRetrieved.next();
                fullFoldersForComponent.put(iVersionableHandle.getItemId(), folder);
            }
        }
        return fullVersionables;
    }

    @Override
    public final Map<ILoadRequest, IInvalidLoadLocation> getInvalidLoadLocations() {
        return this.invalidLoadLocations;
    }
}

