/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILoadFilter;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.UnknownWorkspaceComponentStateException;
import com.ibm.team.filesystem.client.internal.FileSystemManager;
import com.ibm.team.filesystem.client.internal.FileSystemServiceProxy;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaUtil;
import com.ibm.team.filesystem.client.internal.load.LoadLocation;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.operations.UpdateOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.filesystem.client.operations.IDownloadListener;
import com.ibm.team.filesystem.client.operations.ILoadOperation;
import com.ibm.team.filesystem.client.operations.ILoadRequest;
import com.ibm.team.filesystem.client.operations.ILoadRule2;
import com.ibm.team.filesystem.client.operations.IUnshareOperation;
import com.ibm.team.filesystem.client.operations.IncrementalLoadDilemmaHandler;
import com.ibm.team.filesystem.client.operations.LoadRuleSpecificLoadDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UnshareDilemmaHandler;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdate;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdateReport2;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.WorkspaceManager;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IHistoryReference;
import com.ibm.team.scm.common.IRepositoryProgressMonitor;
import com.ibm.team.scm.common.IRepositoryProgressMonitorHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IItemUpdateReport;
import com.ibm.team.scm.common.dto.ISynchronizationInfo;
import com.ibm.team.scm.common.dto.IUpdateReport;
import com.ibm.team.scm.common.internal.dto.ItemUpdateReport;
import com.ibm.team.scm.common.internal.dto.ScmDtoFactory;
import com.ibm.team.scm.common.internal.dto.UpdateReport;
import com.ibm.team.scm.common.internal.dto2.ScmDto2Factory;
import com.ibm.team.scm.common.internal.dto2.WorkspaceComponentState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class IncrementalLoadOperation
extends FileSystemOperation {
    private final IWorkspaceConnection connection;
    private final int updatesToProcess;
    private HashMap<UUID, IComponentHandle> excludedComponents;
    private ISynchronizationInfo synchronizationInfo;
    private boolean expandKeywords;
    protected final IncrementalLoadDilemmaHandler problemHandler;
    private Map<ILocation, Map<ConfigurationFacade, Set<UUID>>> ignoreList = new HashMap<ILocation, Map<ConfigurationFacade, Set<UUID>>>();
    private final IDownloadListener downloadMonitor;
    private final ILocation cfaRoot;
    private final ILoadRule2 loadRule;
    private final boolean createFoldersForComponents;
    private final Collection<IShare> deletedShares;
    private final Log traceLog;

    public IncrementalLoadOperation(IWorkspaceConnection connection, Collection<IComponentHandle> componentsToExclude, int updatesToProcess, IncrementalLoadDilemmaHandler problemHandler, ILocation cfaRoot, IDownloadListener downloadMonitor) {
        this(connection, componentsToExclude, updatesToProcess, problemHandler, cfaRoot, null, false, null, downloadMonitor);
    }

    public IncrementalLoadOperation(IWorkspaceConnection connection, Collection<IComponentHandle> componentsToExclude, int updatesToProcess, IncrementalLoadDilemmaHandler problemHandler, ILocation cfaRoot, ILoadRule2 loadRule, boolean createFoldersForComponents, Collection<IShare> deletedShares, IDownloadListener downloadMonitor) {
        super(problemHandler == null ? IncrementalLoadDilemmaHandler.getDefault() : problemHandler);
        IncrementalLoadDilemmaHandler incrementalLoadDilemmaHandler = this.problemHandler = problemHandler == null ? IncrementalLoadDilemmaHandler.getDefault() : problemHandler;
        if (connection == null) {
            throw new IllegalArgumentException();
        }
        if (componentsToExclude == null) {
            throw new IllegalArgumentException();
        }
        if ((updatesToProcess | 3) != 3 || updatesToProcess == 0) {
            throw new IllegalArgumentException();
        }
        this.excludedComponents = new HashMap();
        for (IComponentHandle component : componentsToExclude) {
            this.excludedComponents.put(component.getItemId(), component);
        }
        this.cfaRoot = cfaRoot;
        this.connection = connection;
        this.downloadMonitor = downloadMonitor;
        this.updatesToProcess = updatesToProcess;
        this.loadRule = loadRule;
        this.createFoldersForComponents = createFoldersForComponents;
        this.deletedShares = deletedShares != null ? deletedShares : Collections.EMPTY_LIST;
        Log log = LoggingHelper.getLog(IncrementalLoadOperation.class);
        this.traceLog = log != null && log.isTraceEnabled() ? log : null;
    }

    private void traceIfEnabled(String message) {
        if (this.traceLog != null && this.traceLog.isTraceEnabled()) {
            this.traceLog.trace((Object)message);
        }
    }

    public void setIgnoreList(Map<ILocation, Map<ConfigurationFacade, Set<UUID>>> fullCancelPaths) {
        this.ignoreList = fullCancelPaths;
    }

    public void setSynchronizationInfo(ISynchronizationInfo synchronizationInfo) {
        this.synchronizationInfo = synchronizationInfo;
    }

    public void setExpandKeywords(boolean expandKeywords) {
        this.expandKeywords = expandKeywords;
    }

    private void checkOperationCancelled(IProgressMonitor progress) {
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private boolean isSandboxMatchingLoadRuleForSharesInWorkspace(Collection<ComponentDataForLoadRule> allComponentDataForLoadRule) throws TeamRepositoryException {
        for (ComponentDataForLoadRule componentData : allComponentDataForLoadRule) {
            if (componentData.isSandboxMatchingLoadRuleForSharesInComponent()) continue;
            return false;
        }
        return true;
    }

    private void populateLoadRuleData(Collection<LoadLocation> sharesToLoad, ISandbox sandbox, Map<UUID, IComponentHandle> componentsToUpdateAsPerLoadRule, Map<UUID, ComponentDataForLoadRule> loadRuleData, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IShare[] loadedShares = sandbox.allShares((IProgressMonitor)progress.newChild(50));
        SubMonitor subProgress = progress.newChild(50);
        subProgress.setWorkRemaining(componentsToUpdateAsPerLoadRule.values().size());
        for (IComponentHandle component : componentsToUpdateAsPerLoadRule.values()) {
            ComponentDataForLoadRule componentData = new ComponentDataForLoadRule(component, sharesToLoad, loadedShares, (IProgressMonitor)subProgress.newChild(1));
            loadRuleData.put(component.getItemId(), componentData);
        }
    }

    private ILoadOperation getLoadOperationForLoadRule(ISandbox sandbox, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ILoadOperation loadOp = null;
        if (this.loadRule != null) {
            LoadRuleSpecificLoadDilemmaHandler loadRuleSpecificLoadDilemmaHandler = this.problemHandler.getLoadRuleSpecificLoadDilemmaHandler();
            loadOp = this.loadRule.getLoadOp(sandbox, loadRuleSpecificLoadDilemmaHandler.getLoadDilemmaHandler(), (IProgressMonitor)progress.newChild(100));
            if (loadRuleSpecificLoadDilemmaHandler.isSynchronizeLoad() && this.synchronizationInfo != null) {
                loadOp.setSychronizationInfo(this.synchronizationInfo);
            }
            loadOp.setEclipseSpecificLoadOptions(loadRuleSpecificLoadDilemmaHandler.getEclipseSpecificLoadOptions());
            loadOp.setPreserveFileTimestamps(loadRuleSpecificLoadDilemmaHandler.isPreserveFileTimestamps());
            loadOp.setExpandKeywords(this.expandKeywords);
        } else {
            progress.done();
        }
        return loadOp;
    }

    private void createFoldersForComponents(ILoadOperation loadOperation, ISandbox sandbox, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Collection<ILoadRequest> requests = loadOperation.getLoadRequests();
        loadOperation.removeLoadRequests(requests);
        SubMonitor subProgress = progress.newChild(100);
        subProgress.setWorkRemaining(requests.size());
        HashMap<UUID, IComponent> fullComponentCache = new HashMap<UUID, IComponent>();
        for (ILoadRequest request : requests) {
            try {
                IComponent component = (IComponent)fullComponentCache.get(request.getComponent().getItemId());
                if (component == null) {
                    component = (IComponent)this.connection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)request.getComponent(), 1, (IProgressMonitor)subProgress.newChild(1));
                    fullComponentCache.put(component.getItemId(), component);
                } else {
                    subProgress.worked(1);
                }
                IRelativeLocation relativeLocation = new RelativeLocation(component.getName());
                if (request.getRelativeLoadPath() != null) {
                    relativeLocation = relativeLocation.append(request.getRelativeLoadPath());
                }
                if (request.getAlternativeName() != null && !request.getAlternativeName().isEmpty()) {
                    loadOperation.requestLoadAs(sandbox, relativeLocation, request.getAlternativeName(), (IWorkspaceConnection)request.getConnection(), request.getComponent(), request.getVersionableToLoad());
                    continue;
                }
                loadOperation.requestLoad(sandbox, relativeLocation, (IWorkspaceConnection)request.getConnection(), request.getComponent(), Collections.singleton(request.getVersionableToLoad()));
            }
            catch (TeamRepositoryException teamRepositoryException) {
                // empty catch block
            }
        }
    }

    private void removeUnwantedLoadRequests(ILoadOperation loadOperation) {
        ArrayList<ILoadRequest> requestsToRemove = new ArrayList<ILoadRequest>();
        for (ILoadRequest loadRequest : loadOperation.getLoadRequests()) {
            if (loadRequest.getConnection().getContextHandle().sameItemId((IItemHandle)this.connection.getContextHandle())) continue;
            requestsToRemove.add(loadRequest);
        }
        if (!requestsToRemove.isEmpty()) {
            loadOperation.removeLoadRequests(requestsToRemove);
        }
    }

    private Collection<LoadLocation> getLoadLocationsToProcess(List<LoadLocation> allLoadLocation, Map<UUID, IComponentHandle> componentsWithUpdatesAndValidWCState) {
        ArrayList<LoadLocation> loadLocationsToProcess = new ArrayList<LoadLocation>();
        for (LoadLocation loadLocation : allLoadLocation) {
            if (!componentsWithUpdatesAndValidWCState.containsKey(loadLocation.getComponent().getItemId())) continue;
            loadLocationsToProcess.add(loadLocation);
        }
        return loadLocationsToProcess;
    }

    private Set<FileAreaUpdate> getShareUpdates(List<FileAreaUpdate> allUpdates, Map<UUID, ComponentDataForLoadRule> loadRuleData) {
        HashSet<FileAreaUpdate> shareUpdates = new HashSet<FileAreaUpdate>();
        for (FileAreaUpdate update : allUpdates) {
            ComponentDataForLoadRule componentData = loadRuleData.get(update.getComponent().getItemId());
            boolean isShareUpdate = componentData.getSharesToProcess().contains(update.getItem().getItemId());
            if (!isShareUpdate) continue;
            shareUpdates.add(update);
        }
        return shareUpdates;
    }

    private Set<FileAreaUpdate> getNonShareUpdates(List<FileAreaUpdate> allUpdates, Map<UUID, ComponentDataForLoadRule> loadRuleData) {
        HashSet<FileAreaUpdate> nonShareUpdates = new HashSet<FileAreaUpdate>();
        for (FileAreaUpdate update : allUpdates) {
            ComponentDataForLoadRule componentData = loadRuleData.get(update.getComponent().getItemId());
            boolean isShareUpdate = componentData.getSharesToProcess().contains(update.getItem().getItemId());
            if (isShareUpdate) continue;
            nonShareUpdates.add(update);
        }
        return nonShareUpdates;
    }

    private Map<UUID, IComponentHandle> getComponentsToUpdateAsPerLoadRule(Collection<LoadLocation> loadLocationsToProcess) {
        HashMap<UUID, IComponentHandle> componentsToUpdateAsPerLoadRule = new HashMap<UUID, IComponentHandle>();
        for (LoadLocation loadLocation : loadLocationsToProcess) {
            IComponent component = loadLocation.getComponent();
            if (componentsToUpdateAsPerLoadRule.containsKey(component.getItemId())) continue;
            componentsToUpdateAsPerLoadRule.put(component.getItemId(), (IComponentHandle)component);
        }
        return componentsToUpdateAsPerLoadRule;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void execute(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.traceIfEnabled("IncrementalLoadOperation#execute: Start.");
        this.checkOperationCancelled((IProgressMonitor)progress);
        this.traceIfEnabled(NLS.bind((String)"IncrementalLoadOperation#execute: Fetching all the loaded configuration descriptors for sandbox at location: \"{0}\".", (Object)this.cfaRoot, (Object[])new Object[0]));
        configurationsOfLoadedComponents = new HashMap<UUID, LoadedConfigurationDescriptor>();
        allLoadedComponentConfigurations = SharingManager.getInstance().allLoadedConfigurations(this.cfaRoot, (IProgressMonitor)progress.newChild(5));
        for (LoadedConfigurationDescriptor compConfiguration : allLoadedComponentConfigurations) {
            if (!compConfiguration.getConnectionHandle().getItemId().equals((Object)this.connection.getContextHandle().getItemId())) continue;
            configurationsOfLoadedComponents.put(compConfiguration.getComponentHandle().getItemId(), compConfiguration);
        }
        this.checkOperationCancelled((IProgressMonitor)progress);
        this.traceIfEnabled(NLS.bind((String)"IncrementalLoadOperation#execute: Fetching the current workspace component state for all component in workspace: \"{0}\".", (Object)this.connection.getName(), (Object[])new Object[0]));
        allWCStateOfComponentsInWorkspace = new HashMap<UUID, WorkspaceComponentState>();
        scmService = ((WorkspaceManager)SCMPlatform.getWorkspaceManager((ITeamRepository)this.connection.teamRepository())).getServerConfigurationService();
        allWCStateList = scmService.getWorkspaceComponentStateForComponents((IWorkspaceHandle)this.connection.getResolvedWorkspace(), new IComponentHandle[0], (IRepositoryProgressMonitorHandle)IRepositoryProgressMonitor.ITEM_FACTORY.createItem((IProgressMonitor)progress.newChild(5)));
        var11_8 = allWCStateList;
        var10_9 = allWCStateList.length;
        var9_12 = 0;
        while (var9_12 < var10_9) {
            wcs = var11_8[var9_12];
            allWCStateOfComponentsInWorkspace.put(wcs.getComponent().getItemId(), wcs);
            ++var9_12;
        }
        this.checkOperationCancelled((IProgressMonitor)progress);
        this.traceIfEnabled("IncrementalLoadOperation#execute: Filtering out components that need not be processed.");
        handlesOfComponentsInWorkspace = this.connection.getComponents();
        configOfCompContainingDelta = new ArrayList<LoadedConfigurationDescriptor>();
        for (IComponentHandle handleOfComponentInWorkspace : handlesOfComponentsInWorkspace) {
            if (this.excludedComponents.keySet().contains(handleOfComponentInWorkspace.getItemId()) || (componentConfiguration = (LoadedConfigurationDescriptor)configurationsOfLoadedComponents.get(handleOfComponentInWorkspace.getItemId())) == null || componentConfiguration.workspaceComponentState == ((WorkspaceComponentState)allWCStateOfComponentsInWorkspace.get(handleOfComponentInWorkspace.getItemId())).getState()) continue;
            configOfCompContainingDelta.add(componentConfiguration);
        }
        this.checkOperationCancelled((IProgressMonitor)progress);
        this.traceIfEnabled("IncrementalLoadOperation#execute: Grouping components based on if they have a know workspace component state in the metadata or not.");
        componentsWithUpdatesAndValidWCState = new HashMap<UUID, IComponentHandle>();
        componentsWithUnknownWCState = new HashMap<UUID, IComponentHandle>();
        for (LoadedConfigurationDescriptor componentConfiguration : configOfCompContainingDelta) {
            if (componentConfiguration.workspaceComponentState == -1L) {
                componentsWithUnknownWCState.put(componentConfiguration.getComponentHandle().getItemId(), componentConfiguration.getComponentHandle());
                continue;
            }
            componentsWithUpdatesAndValidWCState.put(componentConfiguration.getComponentHandle().getItemId(), componentConfiguration.getComponentHandle());
        }
        this.checkOperationCancelled((IProgressMonitor)progress);
        if (componentsWithUnknownWCState.isEmpty()) ** GOTO lbl73
        this.traceIfEnabled("IncrementalLoadOperation#execute: Handling components with UNKNOWN workspace component state in the metadata.");
        unknownWCStateHandler = this.problemHandler.getUnknownWorkspaceComponentStateDilemmaHandler();
        direction = unknownWCStateHandler.unknownWorkspaceComponentState();
        if (direction == 1) {
            this.traceIfEnabled("IncrementalLoadOperation#execute: Operation cancelled.");
            throw new OperationCanceledException();
        }
        if (direction == 100) {
            this.traceIfEnabled("IncrementalLoadOperation#execute: Reloading those components with unknown workspace component state in the metadata.");
            reloadProgress = progress.newChild(20);
            reloadProgress.setWorkRemaining(componentsWithUnknownWCState.values().size() * 3);
            resolver = new IRepositoryResolver(){

                @Override
                public ITeamRepository getRepoFor(String uri, UUID id) throws TeamRepositoryException {
                    return IncrementalLoadOperation.this.connection.teamRepository();
                }
            };
            for (IComponentHandle compHandle : componentsWithUnknownWCState.values()) {
                this.traceIfEnabled(NLS.bind((String)"IncrementalLoadOperation#execute: Reloading component with item id: \"{0}\".", (Object)compHandle.getItemId(), (Object[])new Object[0]));
                loadedShares = SharingManager.getInstance().allShares(this.cfaRoot, this.connection.getContextHandle(), compHandle, (IProgressMonitor)reloadProgress.newChild(1));
                op = IOperationFactory.instance.getLoadOperation(unknownWCStateHandler.getLoadDilemmaHandler());
                op.setEclipseSpecificLoadOptions(4);
                op.requestReLoad(Arrays.asList(loadedShares), resolver, true, (IProgressMonitor)reloadProgress.newChild(1));
                op.setPreserveLocalChanges(unknownWCStateHandler.isPreserveLocalChangesOnReload());
                op.run((IProgressMonitor)reloadProgress.newChild(1));
            }
        } else {
            this.traceIfEnabled("IncrementalLoadOperation#execute: The workspace component state for some of the components being updated are not set in the metadata. IncrementalLoadOperation Failed.");
            throw new UnknownWorkspaceComponentStateException(Messages.IncrementalLoadOperation_Unknown_WorkspaceComponentState_Error);
lbl73:
            // 1 sources

            this.traceIfEnabled("IncrementalLoadOperation#execute: All the components that need to be processed have value set for the workspace component state, in the metadata.");
            progress.worked(20);
        }
        this.checkOperationCancelled((IProgressMonitor)progress);
        updateReportProgress = progress.newChild(5);
        updateReportProgress.setWorkRemaining(componentsWithUpdatesAndValidWCState.keySet().size());
        this.traceIfEnabled("IncrementalLoadOperation#execute: Fetching the IUpdateReport for those components with a value set for the workspace component state in the metadata.");
        updateReports = new ArrayList<IUpdateReport>();
        for (UUID compId : componentsWithUpdatesAndValidWCState.keySet()) {
            compConfig = (LoadedConfigurationDescriptor)configurationsOfLoadedComponents.get(compId);
            wcs = ScmDto2Factory.eINSTANCE.createWorkspaceComponentState();
            wcs.setWorkspace((IWorkspaceHandle)compConfig.getConnectionHandle());
            wcs.setComponent(compConfig.getComponentHandle());
            wcs.setState(compConfig.workspaceComponentState);
            compareResult = scmService.compareHistoryConfigurations((IHistoryReference)wcs, (IHistoryReference)this.connection.getResolvedWorkspace(), null, 128, new IComponentHandle[]{compConfig.getComponentHandle()}, null, (IRepositoryProgressMonitorHandle)IRepositoryProgressMonitor.ITEM_FACTORY.createItem((IProgressMonitor)updateReportProgress.newChild(1)));
            updateReports.add(compareResult);
        }
        this.checkOperationCancelled((IProgressMonitor)progress);
        if (!updateReports.isEmpty()) {
            this.traceIfEnabled("IncrementalLoadOperation#execute: Merging all the individual update reports for the components that were out-of-sync, into a single report.");
            mergedUpdateReport = this.mergeUpdateReports(updateReports);
            if (this.loadRule != null) {
                this.handleLoadRule(mergedUpdateReport, componentsWithUpdatesAndValidWCState, (IProgressMonitor)progress.newChild(65));
            } else {
                this.applyUpdateOperation((IUpdateReport)mergedUpdateReport, (IProgressMonitor)progress.newChild(65));
            }
        } else {
            progress.worked(65);
            this.traceIfEnabled("IncrementalLoadOperation#execute: There were no updates required for any of the components.");
        }
        this.traceIfEnabled("IncrementalLoadOperation#execute: End.");
    }

    private void handleLoadRule(UpdateReport updateReport, Map<UUID, IComponentHandle> componentsWithUpdatesAndValidWCState, IProgressMonitor monitor) throws TeamRepositoryException {
        block39: {
            this.traceIfEnabled("IncrementalLoadOperation#handleLoadRule: A loadrule has been provided.");
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            ISandbox sandbox = FileSystemCore.getSharingManager().getSandbox(this.cfaRoot, true);
            this.traceIfEnabled("IncrementalLoadOperation#handleLoadRule: Generating a load operation corresponding to the loadrule.");
            ILoadOperation loadOpForLoadRule = this.getLoadOperationForLoadRule(sandbox, (IProgressMonitor)progress.newChild(3));
            this.traceIfEnabled("IncrementalLoadOperation#handleLoadRule: Removing unwanted load requests from the loadOperation.");
            this.removeUnwantedLoadRequests(loadOpForLoadRule);
            if (this.createFoldersForComponents) {
                this.traceIfEnabled("IncrementalLoadOperation#handleLoadRule: Creating folders for components.");
                this.createFoldersForComponents(loadOpForLoadRule, sandbox, (IProgressMonitor)progress.newChild(3));
            } else {
                progress.worked(3);
            }
            loadOpForLoadRule.evaluateLoadRequests((IProgressMonitor)progress.newChild(3));
            loadOpForLoadRule.notifyDilemmaHandler((IProgressMonitor)progress.newChild(3));
            List<LoadLocation> allLoadLocations = this.getLoadLocations(loadOpForLoadRule);
            Collection<LoadLocation> loadLocationsToProcess = this.getLoadLocationsToProcess(allLoadLocations, componentsWithUpdatesAndValidWCState);
            Map<UUID, IComponentHandle> componentsToUpdateAsPerLoadRule = this.getComponentsToUpdateAsPerLoadRule(loadLocationsToProcess);
            this.traceIfEnabled("IncrementalLoadOperation#handleLoadRule: Populating all the information required to perform loadrule specific pre-processing of updates, for the components to be updated as per the loadrule.");
            HashMap<UUID, ComponentDataForLoadRule> loadRuleData = new HashMap<UUID, ComponentDataForLoadRule>();
            this.populateLoadRuleData(loadLocationsToProcess, sandbox, componentsToUpdateAsPerLoadRule, loadRuleData, (IProgressMonitor)progress.newChild(3));
            this.traceIfEnabled("IncrementalLoadOperation#handleLoadRule: For those component that are to be updated as per loadrule, fetch the FileAreaUpdateReport2");
            FileAreaUpdateReport2 allUpdates = this.getFileAreaUpdateReport((IUpdateReport)updateReport, componentsToUpdateAsPerLoadRule, componentsWithUpdatesAndValidWCState, (IProgressMonitor)progress.newChild(3));
            HashSet<FileAreaUpdate> nonShareUpdatesToLoad = new HashSet<FileAreaUpdate>();
            HashSet<UUID> nonSharesToDelete = new HashSet<UUID>();
            ILoadFilter loadFilter = loadOpForLoadRule.getLoadFilter();
            if (loadFilter != null) {
                this.traceIfEnabled("IncrementalLoadOperation#handleLoadRule: LoadRule contains load filters, we are required to perform some pre-processing on the updateReport and also determine if some shares are to be reloaded.");
                Set<FileAreaUpdate> addOrModifyOfNonShare = this.getNonShareUpdates(allUpdates.getAdds(), loadRuleData);
                addOrModifyOfNonShare.addAll(this.getNonShareUpdates(allUpdates.getModifies(), loadRuleData));
                Set<FileAreaUpdate> moveOrRenameOfNonShare = this.getNonShareUpdates(allUpdates.getMoves(), loadRuleData);
                nonSharesToDelete.addAll(this.applyLoadFilterOnUpdateReport(updateReport, loadFilter, addOrModifyOfNonShare, moveOrRenameOfNonShare));
                nonShareUpdatesToLoad.addAll(this.getNonShareUpdatesToLoad(loadFilter, moveOrRenameOfNonShare, (IProgressMonitor)progress.newChild(2)));
                this.traceIfEnabled("IncrementalLoadOperation#handleLoadRule: The processing based on load filters is complete, recompute FileAreaUpdateReport2.");
                allUpdates = this.getFileAreaUpdateReport((IUpdateReport)updateReport, componentsToUpdateAsPerLoadRule, componentsWithUpdatesAndValidWCState, (IProgressMonitor)progress.newChild(3));
            } else {
                progress.worked(5);
            }
            Map<UUID, Set<UUID>> sharesToLoad = this.getNestedSharesToLoad(allUpdates, nonSharesToDelete, nonShareUpdatesToLoad, allLoadLocations, (IProgressMonitor)progress.newChild(3));
            this.addSharesIntoMap(sharesToLoad, this.getNestedSharesToLoad(this.deletedShares, allLoadLocations));
            this.traceIfEnabled("IncrementalLoadOperation#handleLoadRule: Verifying if sandbox matches the loadrule in terms of shares, for those components that are to be updated as per the loadrule.");
            boolean sandboxMatchesTheLoadRule = this.isSandboxMatchingLoadRuleForSharesInWorkspace(loadRuleData.values());
            if (sandboxMatchesTheLoadRule) {
                this.traceIfEnabled("IncrementalLoadOperation#handleLoadRule: Sandbox matches the loadrule in terms of shares, but, there is a need to reload some of the nested shares OR to filter some of the versionable items, based on the loadrule global excludeFilter.");
                boolean unsetWorkspaceComponentState = false;
                int errorsBeforeSandboxChanges = this.getErrors().length;
                try {
                    try {
                        this.applyUpdateOperation((IUpdateReport)updateReport, (IProgressMonitor)progress.newChild(20));
                        if (!nonShareUpdatesToLoad.isEmpty()) {
                            this.addSharesIntoMap(sharesToLoad, this.getSharesToReLoad(nonShareUpdatesToLoad, (IProgressMonitor)progress.newChild(3)));
                        } else {
                            progress.worked(3);
                        }
                        if (!nonSharesToDelete.isEmpty()) {
                            UpdateReport additionalReport = this.getAdditionalUpdateReport(updateReport, nonSharesToDelete);
                            this.applyUpdateOperation((IUpdateReport)additionalReport, (IProgressMonitor)progress.newChild(10));
                        } else {
                            progress.worked(10);
                        }
                        if (!sharesToLoad.isEmpty()) {
                            this.applyLoadOperation(loadOpForLoadRule, allLoadLocations, sharesToLoad, (IProgressMonitor)progress.newChild(38));
                        } else {
                            progress.worked(38);
                        }
                        break block39;
                    }
                    catch (Exception e) {
                        unsetWorkspaceComponentState = true;
                        throw e;
                    }
                }
                finally {
                    if (unsetWorkspaceComponentState || this.getErrors().length > errorsBeforeSandboxChanges) {
                        this.traceIfEnabled(NLS.bind((String)"IncrementalLoadOperation#handleLoadRule: There were errors while performing incremental load operation. Set the workspace component state of all the components being updated, belonging to workspace: \"{0}\", to UNKNOWN, in the metadata.", (Object)this.connection.getName(), (Object[])new Object[0]));
                        this.updateWorkspaceComponentStateToUnknown((IProgressMonitor)progress.newChild(3));
                    } else {
                        progress.worked(3);
                    }
                }
            }
            this.traceIfEnabled("IncrementalLoadOperation#handleLoadRule: Sandbox does not match the loadrule in terms of shares. Need to perform some pre-processing on the updates.");
            boolean unsetWorkspaceComponentState = false;
            int errorsBeforeSandboxChanges = this.getErrors().length;
            try {
                try {
                    this.traceIfEnabled("IncrementalLoadOperation#handleLoadRule: Delete the shares that are loaded into the sandbox but are not mentioned in the loadrule.");
                    HashMap<UUID, IShare> toUnshareMap = new HashMap<UUID, IShare>();
                    for (UUID compId : componentsToUpdateAsPerLoadRule.keySet()) {
                        ComponentDataForLoadRule componentData = (ComponentDataForLoadRule)loadRuleData.get(compId);
                        toUnshareMap.putAll(componentData.getSharesToDelete());
                    }
                    if (!toUnshareMap.isEmpty()) {
                        this.addSharesIntoMap(sharesToLoad, this.getNestedSharesToLoad(toUnshareMap.values(), allLoadLocations));
                        IUnshareOperation unshareOp = IOperationFactory.instance.getUnshareOperation(UnshareDilemmaHandler.getDefault(), new IRepositoryResolver(){

                            @Override
                            public ITeamRepository getRepoFor(String uri, UUID id) throws TeamRepositoryException {
                                return IncrementalLoadOperation.this.connection.teamRepository();
                            }
                        });
                        unshareOp.requestUnshareShares(toUnshareMap.values());
                        unshareOp.setDeleteContent(true);
                        unshareOp.run((IProgressMonitor)progress.newChild(20));
                    } else {
                        progress.worked(20);
                    }
                    this.traceIfEnabled("IncrementalLoadOperation#handleLoadRule: Filter out the updates from the IUpdateReport, corresponding to shares that are to be loaded as part of the loadOperation and not updated as part of the UpdateOperation.");
                    HashMap<UUID, Set<UUID>> sharesToTransfer = new HashMap<UUID, Set<UUID>>();
                    Set<FileAreaUpdate> addOfShare = this.getShareUpdates(allUpdates.getAdds(), loadRuleData);
                    for (FileAreaUpdate add : addOfShare) {
                        this.addShareIntoMap(sharesToTransfer, add.getComponent().getItemId(), add.getItem().getItemId());
                    }
                    Set<FileAreaUpdate> moveOrRenameOfShare = this.getShareUpdates(allUpdates.getMoves(), loadRuleData);
                    for (FileAreaUpdate moveOrRename : moveOrRenameOfShare) {
                        UUID compId = moveOrRename.getComponent().getItemId();
                        UUID shareToMoveOrRename = moveOrRename.getItem().getItemId();
                        ComponentDataForLoadRule componentData = (ComponentDataForLoadRule)loadRuleData.get(compId);
                        Map<UUID, IShare> loadedShares = componentData.getLoadedShares();
                        Map<UUID, LoadLocation> loadLocations = componentData.getSharesToLoad();
                        if (!loadedShares.containsKey(shareToMoveOrRename) || !loadLocations.containsKey(shareToMoveOrRename)) continue;
                        this.addShareIntoMap(sharesToTransfer, compId, shareToMoveOrRename);
                    }
                    if (!sharesToTransfer.isEmpty()) {
                        this.filterUpdateReport(updateReport, sharesToTransfer, sharesToLoad);
                    }
                    this.applyUpdateOperation((IUpdateReport)updateReport, (IProgressMonitor)progress.newChild(16));
                    if (!nonShareUpdatesToLoad.isEmpty()) {
                        this.addSharesIntoMap(sharesToLoad, this.getSharesToReLoad(nonShareUpdatesToLoad, (IProgressMonitor)progress.newChild(5)));
                    } else {
                        progress.worked(5);
                    }
                    if (!nonSharesToDelete.isEmpty()) {
                        UpdateReport additionalReport = this.getAdditionalUpdateReport(updateReport, nonSharesToDelete);
                        this.applyUpdateOperation((IUpdateReport)additionalReport, (IProgressMonitor)progress.newChild(10));
                    } else {
                        progress.worked(10);
                    }
                    for (UUID compId : componentsToUpdateAsPerLoadRule.keySet()) {
                        ComponentDataForLoadRule componentData = (ComponentDataForLoadRule)loadRuleData.get(compId);
                        Set<UUID> sharesToAdd = componentData.getSharesToAdd();
                        if (sharesToAdd.isEmpty()) continue;
                        if (sharesToLoad.containsKey(compId)) {
                            sharesToLoad.get(compId).addAll(sharesToAdd);
                            continue;
                        }
                        sharesToLoad.put(compId, sharesToAdd);
                    }
                    if (!sharesToLoad.isEmpty()) {
                        this.applyLoadOperation(loadOpForLoadRule, allLoadLocations, sharesToLoad, (IProgressMonitor)progress.newChild(20));
                    } else {
                        progress.worked(20);
                    }
                }
                catch (Exception e) {
                    unsetWorkspaceComponentState = true;
                    throw e;
                }
            }
            finally {
                if (unsetWorkspaceComponentState || this.getErrors().length > errorsBeforeSandboxChanges) {
                    this.traceIfEnabled(NLS.bind((String)"IncrementalLoadOperation#handleLoadRule: There were errors while performing incremental load operation. Set the workspace component state of all the components being updated, belonging to workspace: \"{0}\", to UNKNOWN, in the metadata.", (Object)this.connection.getName(), (Object[])new Object[0]));
                    this.updateWorkspaceComponentStateToUnknown((IProgressMonitor)progress.newChild(3));
                } else {
                    progress.worked(3);
                }
            }
        }
    }

    private FileAreaUpdateReport2 getFileAreaUpdateReport(IUpdateReport updateReport, Map<UUID, IComponentHandle> componentsToUpdateAsPerLoadRule, Map<UUID, IComponentHandle> componentsWithUpdatesAndValidWCState, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        ArrayList<IComponentHandle> excludeComponentsToBeUpdated = new ArrayList<IComponentHandle>();
        for (UUID compId : componentsWithUpdatesAndValidWCState.keySet()) {
            if (componentsToUpdateAsPerLoadRule.containsKey(compId)) continue;
            excludeComponentsToBeUpdated.add(componentsWithUpdatesAndValidWCState.get(compId));
        }
        FileSystemServiceProxy fileSystemService = ((FileSystemManager)FileSystemCore.getFileSystemManager(this.connection.teamRepository())).getFileSystemService();
        return fileSystemService.incrementalFileLoadStream(this.connection, updateReport, excludeComponentsToBeUpdated, true, this.updatesToProcess, this.synchronizationInfo, monitor);
    }

    private void applyUpdateOperation(IUpdateReport updateReport, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        this.traceIfEnabled("IncrementalLoadOperation#applyUpdateOperation: Applying the updates for the components that were out-of-sync, by invoking the UpdateOperation.");
        UpdateOperation op = new UpdateOperation(this.connection, Collections.singletonList(updateReport), this.excludedComponents.values(), this.updatesToProcess, this.problemHandler.getUpdateDilemmaHandler(this.loadRule != null), this.cfaRoot, this.downloadMonitor);
        op.setSynchronizationInfo(this.synchronizationInfo);
        op.setIgnoreList(this.ignoreList);
        op.setExpandKeywords(this.expandKeywords);
        this.disableVerifyInSync(op);
        op.run(monitor);
        this.traceIfEnabled("IncrementalLoadOperation#applyUpdateOperation: Done applying the updates for those components that were out-of-sync.");
    }

    private void load(ILoadOperation loadOpForLoadRule, Map<UUID, Set<UUID>> sharesToLoad, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        ArrayList<ILoadRequest> requestsToRemove = new ArrayList<ILoadRequest>();
        for (ILoadRequest loadRequest : loadOpForLoadRule.getLoadRequests()) {
            Set<UUID> shares = sharesToLoad.get(loadRequest.getComponent().getItemId());
            if (shares != null && shares.contains(loadRequest.getVersionableToLoad().getItemId())) continue;
            requestsToRemove.add(loadRequest);
        }
        loadOpForLoadRule.removeLoadRequests(requestsToRemove);
        loadOpForLoadRule.run(monitor);
    }

    private void applyLoadOperation(ILoadOperation loadOpForLoadRule, List<LoadLocation> allLoadLocations, Map<UUID, Set<UUID>> sharesToLoad, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        this.traceIfEnabled("IncrementalLoadOperation#applyLoadOperation: If a share to be loaded is a nested share or consists of nested shares under it, then we would require additional processing.");
        HashMap<UUID, Set<UUID>> filteredSharesToLoad = new HashMap<UUID, Set<UUID>>();
        this.addSharesIntoMap(filteredSharesToLoad, this.getFilteredShares(loadOpForLoadRule, sharesToLoad));
        this.addSharesIntoMap(filteredSharesToLoad, this.processNestedShares(allLoadLocations, filteredSharesToLoad));
        if (!filteredSharesToLoad.isEmpty()) {
            this.traceIfEnabled("IncrementalLoadOperation#applyLoadOperation: Load all the shares into the sandbox, that are required to be loaded as per the loadrule.");
            this.load(loadOpForLoadRule, filteredSharesToLoad, monitor);
        } else {
            monitor.done();
        }
    }

    private Map<UUID, Set<UUID>> getFilteredShares(ILoadOperation loadOpForLoadRule, Map<UUID, Set<UUID>> sharesToLoad) {
        HashMap<UUID, Set<UUID>> sharesWithLoadRequest = new HashMap<UUID, Set<UUID>>();
        for (ILoadRequest loadRequest : loadOpForLoadRule.getLoadRequests()) {
            Set<UUID> shares = sharesToLoad.get(loadRequest.getComponent().getItemId());
            if (shares == null || !shares.contains(loadRequest.getVersionableToLoad().getItemId())) continue;
            this.addShareIntoMap(sharesWithLoadRequest, loadRequest.getComponent().getItemId(), loadRequest.getVersionableToLoad().getItemId());
        }
        return sharesWithLoadRequest;
    }

    private Map<UUID, Set<UUID>> processNestedShares(List<LoadLocation> allLoadLocations, Map<UUID, Set<UUID>> sharesToLoad) {
        HashMap<LoadLocation, LoadLocation> nestedToParentShare = new HashMap<LoadLocation, LoadLocation>();
        HashMap<LoadLocation, Set<LoadLocation>> parentToNestedShares = new HashMap<LoadLocation, Set<LoadLocation>>();
        this.populateNestedShareInfo(allLoadLocations, nestedToParentShare, parentToNestedShares);
        HashMap<UUID, Set<UUID>> additionalSharesToLoad = new HashMap<UUID, Set<UUID>>();
        this.addSharesIntoMap(additionalSharesToLoad, this.getNestedSharesToLoad(parentToNestedShares, sharesToLoad));
        this.addSharesIntoMap(additionalSharesToLoad, this.getParentSharesToLoad(nestedToParentShare, sharesToLoad));
        return additionalSharesToLoad;
    }

    private List<LoadLocation> getLoadLocations(ILoadOperation loadOpForLoadRule) {
        ArrayList<LoadLocation> allLocations = new ArrayList<LoadLocation>();
        allLocations.addAll(loadOpForLoadRule.getItemsToLoad());
        Collections.sort(allLocations, new Comparator<LoadLocation>(){

            @Override
            public int compare(LoadLocation loadLocation1, LoadLocation loadLocation2) {
                return loadLocation1.getLoadPath().toString().compareTo(loadLocation2.getLoadPath().toString());
            }
        });
        return allLocations;
    }

    private void populateNestedShareInfo(List<LoadLocation> allLoadLocations, Map<LoadLocation, LoadLocation> nestedToParentShare, Map<LoadLocation, Set<LoadLocation>> parentToNestedShares) {
        int parentIndex = 0;
        while (parentIndex < allLoadLocations.size() - 1) {
            LoadLocation parent = allLoadLocations.get(parentIndex);
            if (parent.getRootToLoad() instanceof IFolderHandle) {
                int childIndex = parentIndex + 1;
                while (childIndex < allLoadLocations.size()) {
                    LoadLocation child = allLoadLocations.get(childIndex);
                    if (parent.getLoadPath().isPrefixOf(child.getLoadPath())) {
                        LoadLocation childsExistingParent = nestedToParentShare.get(child);
                        if (childsExistingParent != null) {
                            parentToNestedShares.get(childsExistingParent).remove(child);
                        }
                        nestedToParentShare.put(child, parent);
                        this.addLoadLocationIntoMap(parentToNestedShares, parent, child);
                    }
                    ++childIndex;
                }
            }
            ++parentIndex;
        }
    }

    private Map<UUID, Set<UUID>> getNestedSharesToLoad(Map<LoadLocation, Set<LoadLocation>> parentToNestedShares, Map<UUID, Set<UUID>> sharesToLoad) {
        HashSet nestedSharesToLoad = new HashSet();
        for (LoadLocation share : parentToNestedShares.keySet()) {
            Set<UUID> shares = sharesToLoad.get(share.getComponent().getItemId());
            if (shares == null || !shares.contains(share.getRootToLoad().getItemId())) continue;
            nestedSharesToLoad.addAll(parentToNestedShares.get(share));
        }
        HashMap<UUID, Set<UUID>> shareMap = new HashMap<UUID, Set<UUID>>();
        for (LoadLocation share : nestedSharesToLoad) {
            this.addShareIntoMap(shareMap, share.getComponent().getItemId(), share.getRootToLoad().getItemId());
        }
        return shareMap;
    }

    private Map<UUID, Set<UUID>> getParentSharesToLoad(Map<LoadLocation, LoadLocation> nestedToParentShare, Map<UUID, Set<UUID>> sharesToLoad) {
        HashMap<UUID, Set<UUID>> parentSharesToLoad = new HashMap<UUID, Set<UUID>>();
        for (LoadLocation share : nestedToParentShare.keySet()) {
            Set<UUID> shares = sharesToLoad.get(share.getComponent().getItemId());
            if (shares == null || !shares.contains(share.getRootToLoad().getItemId())) continue;
            LoadLocation parentShare = nestedToParentShare.get(share);
            this.addShareIntoMap(parentSharesToLoad, parentShare.getComponent().getItemId(), parentShare.getRootToLoad().getItemId());
        }
        return parentSharesToLoad;
    }

    private Map<UUID, Set<UUID>> getNestedSharesToLoad(FileAreaUpdateReport2 allUpdates, Set<UUID> nonSharesToDelete, Set<FileAreaUpdate> nonShareUpdatesToLoad, List<LoadLocation> allLoadLocations, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Map<IRelativeLocation, FileAreaUpdate> deletePathsToProcess = this.getPathsToProcess(allUpdates.getDeletes(), (IProgressMonitor)progress.newChild(50));
        Map<IRelativeLocation, FileAreaUpdate> moveRenamePathsToProcess = this.getPathsToProcess(allUpdates.getMoves(), (IProgressMonitor)progress.newChild(50));
        HashSet<IRelativeLocation> parentPathsToProcess = new HashSet<IRelativeLocation>();
        parentPathsToProcess.addAll(deletePathsToProcess.keySet());
        parentPathsToProcess.addAll(moveRenamePathsToProcess.keySet());
        HashMap<UUID, Set<UUID>> shareMap = new HashMap<UUID, Set<UUID>>();
        for (IRelativeLocation parentPath : parentPathsToProcess) {
            for (LoadLocation loadLocation : allLoadLocations) {
                if (!parentPath.isPrefixOf(loadLocation.getLoadPath())) continue;
                this.addShareIntoMap(shareMap, loadLocation.getComponent().getItemId(), loadLocation.getRootToLoad().getItemId());
                if (!moveRenamePathsToProcess.containsKey(parentPath)) continue;
                FileAreaUpdate update = moveRenamePathsToProcess.get(parentPath);
                nonSharesToDelete.add(update.getItem().getItemId());
                nonShareUpdatesToLoad.add(update);
            }
        }
        return shareMap;
    }

    private Map<UUID, Set<UUID>> getNestedSharesToLoad(Collection<IShare> sharesToProcess, List<LoadLocation> allLoadLocations) {
        HashSet<IRelativeLocation> parentPathsToProcess = new HashSet<IRelativeLocation>();
        for (IShare share : sharesToProcess) {
            if (!(share.getSharingDescriptor().getRootVersionable() instanceof IFolderHandle)) continue;
            parentPathsToProcess.add(share.getShareable().getLocalPath());
        }
        HashMap<UUID, Set<UUID>> shareMap = new HashMap<UUID, Set<UUID>>();
        for (IRelativeLocation parentPath : parentPathsToProcess) {
            for (LoadLocation loadLocation : allLoadLocations) {
                if (!parentPath.isPrefixOf(loadLocation.getLoadPath())) continue;
                this.addShareIntoMap(shareMap, loadLocation.getComponent().getItemId(), loadLocation.getRootToLoad().getItemId());
            }
        }
        return shareMap;
    }

    private Map<IRelativeLocation, FileAreaUpdate> getPathsToProcess(List<FileAreaUpdate> shareUpdatesToProcess, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        SubMonitor subProgress = progress.newChild(100);
        subProgress.setWorkRemaining(shareUpdatesToProcess.size() * 2);
        HashMap<IRelativeLocation, FileAreaUpdate> updatePathsToProcess = new HashMap<IRelativeLocation, FileAreaUpdate>();
        for (FileAreaUpdate update : shareUpdatesToProcess) {
            if (update.getItem() instanceof IFolderHandle) {
                IComponentHandle component = update.getPreviousComponent() != null ? update.getPreviousComponent() : update.getComponent();
                IShareable shareable = SharingManager.getInstance().findShareable(this.cfaRoot, this.connection.getContextHandle(), component, update.getItem(), (IProgressMonitor)subProgress.newChild(1));
                if (shareable != null) {
                    IShare share = shareable.getShare((IProgressMonitor)subProgress.newChild(1));
                    if (share == null) continue;
                    updatePathsToProcess.put(shareable.getLocalPath(), update);
                    continue;
                }
                subProgress.worked(1);
                continue;
            }
            subProgress.worked(2);
        }
        return updatePathsToProcess;
    }

    private UpdateReport getAdditionalUpdateReport(UpdateReport updateReport, Set<UUID> nonSharesToDelete) throws FileSystemException {
        UpdateReport newUpdateReport = ScmDtoFactory.eINSTANCE.createUpdateReport();
        ArrayList<ItemUpdateReport> itemReportsToAdd = new ArrayList<ItemUpdateReport>();
        for (IItemUpdateReport itemReport : updateReport.updates()) {
            if (!nonSharesToDelete.contains(itemReport.item().getItemId())) continue;
            itemReportsToAdd.add(this.convertToDeleteReport(itemReport));
        }
        newUpdateReport.updates().addAll(itemReportsToAdd);
        itemReportsToAdd.clear();
        for (IItemUpdateReport itemReport : updateReport.incidentalResolutionUpdates()) {
            if (!nonSharesToDelete.contains(itemReport.item().getItemId())) continue;
            itemReportsToAdd.add(this.convertToDeleteReport(itemReport));
        }
        newUpdateReport.incidentalResolutionUpdates().addAll(itemReportsToAdd);
        newUpdateReport.conflicts().addAll(updateReport.conflicts());
        newUpdateReport.getComponentStateSummariesBefore().addAll(updateReport.getComponentStatesBefore());
        newUpdateReport.getComponentStateSummaries().addAll(updateReport.getComponentStatesAfter());
        return newUpdateReport;
    }

    private Map<UUID, Set<UUID>> getSharesToReLoad(Set<FileAreaUpdate> updatesToReload, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        HashMap<UUID, Set<UUID>> sharesToReLoad = new HashMap<UUID, Set<UUID>>();
        SubMonitor subProgress = progress.newChild(100);
        subProgress.setWorkRemaining(updatesToReload.size() * 2);
        for (FileAreaUpdate update : updatesToReload) {
            IShareable shareable = SharingManager.getInstance().findShareable(this.cfaRoot, this.connection.getContextHandle(), update.getComponent(), update.getItem(), (IProgressMonitor)subProgress.newChild(1));
            if (shareable != null) {
                IShare share = shareable.getShare((IProgressMonitor)subProgress.newChild(1));
                if (share == null) continue;
                ISharingDescriptor descriptor = share.getSharingDescriptor();
                this.addShareIntoMap(sharesToReLoad, descriptor.getComponent().getItemId(), descriptor.getRootVersionable().getItemId());
                continue;
            }
            subProgress.worked(1);
        }
        return sharesToReLoad;
    }

    private Set<FileAreaUpdate> getNonShareUpdatesToLoad(ILoadFilter loadFilter, Set<FileAreaUpdate> moveOrRenameOfNonShare, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        HashSet<FileAreaUpdate> updatesToLoad = new HashSet<FileAreaUpdate>();
        SubMonitor subProgress = progress.newChild(100);
        subProgress.setWorkRemaining(moveOrRenameOfNonShare.size());
        for (FileAreaUpdate update : moveOrRenameOfNonShare) {
            if (loadFilter.include(update.getName())) {
                if (update.getItem() instanceof IFolderHandle) {
                    InverseFileItemInfo itemInfo = CopyFileAreaUtil.getItemInfo(this.cfaRoot, update.getItem(), update.getComponent(), this.connection.getContextHandle(), this.traceLog, (IProgressMonitor)subProgress.newChild(1));
                    if (itemInfo != null) continue;
                    updatesToLoad.add(update);
                    continue;
                }
                subProgress.worked(1);
                continue;
            }
            subProgress.worked(1);
        }
        return updatesToLoad;
    }

    private Set<UUID> applyLoadFilterOnUpdateReport(UpdateReport updateReport, ILoadFilter loadFilter, Set<FileAreaUpdate> addOrModifyOfNonShare, Set<FileAreaUpdate> moveOrRenameOfNonShare) throws FileSystemException {
        HashSet<UUID> nonSharesToExclude = new HashSet<UUID>();
        for (FileAreaUpdate update : addOrModifyOfNonShare) {
            if (loadFilter.include(update.getName())) continue;
            nonSharesToExclude.add(update.getItem().getItemId());
        }
        HashSet<UUID> nonSharesToDelete = new HashSet<UUID>();
        for (FileAreaUpdate update : moveOrRenameOfNonShare) {
            if (loadFilter.include(update.getName())) continue;
            nonSharesToDelete.add(update.getItem().getItemId());
        }
        if (!nonSharesToExclude.isEmpty()) {
            this.filterUpdateReport(updateReport, nonSharesToExclude);
        }
        return nonSharesToDelete;
    }

    private void filterUpdateReport(UpdateReport updateReport, Set<UUID> nonSharesToExclude) {
        ArrayList<IItemUpdateReport> itemReportsToRemove = new ArrayList<IItemUpdateReport>();
        for (IItemUpdateReport itemReport : updateReport.updates()) {
            if (!nonSharesToExclude.contains(itemReport.item().getItemId())) continue;
            itemReportsToRemove.add(itemReport);
        }
        updateReport.updates().removeAll(itemReportsToRemove);
        itemReportsToRemove.clear();
        for (IItemUpdateReport itemReport : updateReport.incidentalResolutionUpdates()) {
            if (!nonSharesToExclude.contains(itemReport.item().getItemId())) continue;
            itemReportsToRemove.add(itemReport);
        }
        updateReport.incidentalResolutionUpdates().removeAll(itemReportsToRemove);
    }

    private ItemUpdateReport convertToDeleteReport(IItemUpdateReport existingItemReport) {
        UUID previousState = existingItemReport.getPreviousState() == null ? null : existingItemReport.getPreviousState().getStateId();
        ItemUpdateReport itemReportForDelete = ScmDtoFactory.eINSTANCE.createItemUpdateReport();
        itemReportForDelete.setPreviousStateId(previousState);
        itemReportForDelete.setNewCurrentStateId(null);
        itemReportForDelete.setItem(existingItemReport.item());
        itemReportForDelete.setComponent(existingItemReport.getComponent());
        itemReportForDelete.setPreviousComponent(existingItemReport.getComponent());
        return itemReportForDelete;
    }

    private void addLoadLocationIntoMap(Map<LoadLocation, Set<LoadLocation>> loadLocationMap, LoadLocation keyLocation, LoadLocation valueLocation) {
        if (loadLocationMap.containsKey(keyLocation)) {
            loadLocationMap.get(keyLocation).add(valueLocation);
        } else {
            HashSet<LoadLocation> valueLocations = new HashSet<LoadLocation>();
            valueLocations.add(valueLocation);
            loadLocationMap.put(keyLocation, valueLocations);
        }
    }

    private void addShareIntoMap(Map<UUID, Set<UUID>> sharesByComponent, UUID componentItemId, UUID shareItemId) {
        if (sharesByComponent.containsKey(componentItemId)) {
            sharesByComponent.get(componentItemId).add(shareItemId);
        } else {
            HashSet<UUID> shareItemIds = new HashSet<UUID>();
            shareItemIds.add(shareItemId);
            sharesByComponent.put(componentItemId, shareItemIds);
        }
    }

    private void addSharesIntoMap(Map<UUID, Set<UUID>> sharesByComponent, Map<UUID, Set<UUID>> sharesToInclude) {
        for (UUID componentId : sharesToInclude.keySet()) {
            if (sharesByComponent.containsKey(componentId)) {
                sharesByComponent.get(componentId).addAll((Collection<UUID>)sharesToInclude.get(componentId));
                continue;
            }
            sharesByComponent.put(componentId, sharesToInclude.get(componentId));
        }
    }

    private void filterUpdateReport(UpdateReport updateReport, Map<UUID, Set<UUID>> sharesToTransfer, Map<UUID, Set<UUID>> sharesToLoad) {
        ArrayList<IItemUpdateReport> itemReportsToRemove = new ArrayList<IItemUpdateReport>();
        for (IItemUpdateReport itemReport : updateReport.updates()) {
            if (!this.isItemToBeTransferred(itemReport, sharesToTransfer)) continue;
            itemReportsToRemove.add(itemReport);
            this.addShareIntoMap(sharesToLoad, itemReport.getComponent().getItemId(), itemReport.item().getItemId());
        }
        updateReport.updates().removeAll(itemReportsToRemove);
        itemReportsToRemove.clear();
        for (IItemUpdateReport itemReport : updateReport.incidentalResolutionUpdates()) {
            if (!this.isItemToBeTransferred(itemReport, sharesToTransfer)) continue;
            itemReportsToRemove.add(itemReport);
            this.addShareIntoMap(sharesToLoad, itemReport.getComponent().getItemId(), itemReport.item().getItemId());
        }
        updateReport.incidentalResolutionUpdates().removeAll(itemReportsToRemove);
    }

    private boolean isItemToBeTransferred(IItemUpdateReport itemReport, Map<UUID, Set<UUID>> sharesToTransferByComponent) {
        Set<UUID> sharesToTransfer = sharesToTransferByComponent.get(itemReport.getComponent().getItemId());
        return sharesToTransfer != null && sharesToTransfer.contains(itemReport.item().getItemId());
    }

    private UpdateReport mergeUpdateReports(List<IUpdateReport> updateReportsToBeMerged) {
        UpdateReport mergedUpdateReport = ScmDtoFactory.eINSTANCE.createUpdateReport();
        for (IUpdateReport updateReport : updateReportsToBeMerged) {
            Map<UUID, Map<UUID, Integer>> updateMap = this.getUpdateMap(mergedUpdateReport.getUpdates());
            Map<UUID, List<Integer>> updatesByItemId = this.getItemMapping(mergedUpdateReport);
            for (IItemUpdateReport update : updateReport.updates()) {
                this.replaceOrAddIfRequired(update, mergedUpdateReport.getUpdates(), updateMap, updatesByItemId);
            }
            for (IItemUpdateReport incidentalUpdate : updateReport.incidentalResolutionUpdates()) {
                this.replaceOrAddIfRequired(incidentalUpdate, mergedUpdateReport.getIncidentalUpdates(), updateMap, updatesByItemId);
            }
            mergedUpdateReport.conflicts().addAll(updateReport.conflicts());
            mergedUpdateReport.getComponentStateSummariesBefore().addAll(updateReport.getComponentStatesBefore());
            mergedUpdateReport.getComponentStateSummaries().addAll(updateReport.getComponentStatesAfter());
        }
        return mergedUpdateReport;
    }

    private Map<UUID, Map<UUID, Integer>> getUpdateMap(List<ItemUpdateReport> itemReportList) {
        HashMap<UUID, Map<UUID, Integer>> updateMap = new HashMap<UUID, Map<UUID, Integer>>((int)((double)itemReportList.size() / 0.75));
        int idx = 0;
        for (ItemUpdateReport itemReport : itemReportList) {
            Map<UUID, Integer> perComponentReport = (HashMap<UUID, Integer>)updateMap.get(itemReport.getComponent().getItemId());
            if (perComponentReport == null) {
                perComponentReport = new HashMap<UUID, Integer>();
                updateMap.put(itemReport.getComponent().getItemId(), perComponentReport);
            }
            perComponentReport.put(itemReport.getItem().getItemId(), idx);
            if (itemReport.getPreviousComponent() != null) {
                perComponentReport = (Map)updateMap.get(itemReport.getPreviousComponent().getItemId());
                if (perComponentReport == null) {
                    perComponentReport = new HashMap();
                    updateMap.put(itemReport.getPreviousComponent().getItemId(), perComponentReport);
                }
                perComponentReport.put(itemReport.getItem().getItemId(), idx);
            }
            ++idx;
        }
        return updateMap;
    }

    private Map<UUID, List<Integer>> getItemMapping(UpdateReport updateReport) {
        HashMap<UUID, List<Integer>> updatesByItemId = new HashMap<UUID, List<Integer>>();
        int idx = 0;
        for (IItemUpdateReport iur : updateReport.updates()) {
            UUID itemId = iur.item().getItemId();
            ArrayList<Integer> l = (ArrayList<Integer>)updatesByItemId.get(itemId);
            if (l == null) {
                l = new ArrayList<Integer>();
                updatesByItemId.put(itemId, l);
            }
            l.add(idx);
            ++idx;
        }
        return updatesByItemId;
    }

    private boolean itemUpdateReportRedundant(ItemUpdateReport itemReport) {
        if (!itemReport.getComponent().sameItemId((IItemHandle)itemReport.getPriorComponent())) {
            return false;
        }
        UUID prevState = itemReport.getPreviousStateId();
        UUID newState = itemReport.getNewCurrentStateId();
        if (prevState == null && newState == null) {
            return true;
        }
        return itemReport.getPreviousStateId() != null && itemReport.getPreviousStateId().equals((Object)itemReport.getNewCurrentStateId());
    }

    private boolean equal(UUID s1, UUID s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null) {
            return false;
        }
        return s1.equals((Object)s2);
    }

    private void replaceOrAddIfRequired(IItemUpdateReport update, List<ItemUpdateReport> itemReportList, Map<UUID, Map<UUID, Integer>> updateMap, Map<UUID, List<Integer>> updatesByItemId) {
        UUID currentState;
        UUID previousState = update.getPreviousState() == null ? null : update.getPreviousState().getStateId();
        UUID uUID = currentState = update.getNewCurrentState() == null ? null : update.getNewCurrentState().getStateId();
        if (!this.equal(currentState, previousState)) {
            ItemUpdateReport itemReport = ScmDtoFactory.eINSTANCE.createItemUpdateReport();
            itemReport.setComponent(update.getComponent());
            itemReport.setNewCurrentStateId(currentState);
            itemReport.setPreviousStateId(previousState);
            itemReport.setItem(update.item());
            itemReport.setPreviousComponent(update.getPriorComponent());
            if (!this.itemUpdateReportRedundant(itemReport)) {
                this.replaceOrAdd(itemReportList, updateMap, updatesByItemId, itemReport);
            }
        }
    }

    private void replaceOrAdd(List<ItemUpdateReport> itemReportList, Map<UUID, Map<UUID, Integer>> updateMap, Map<UUID, List<Integer>> updatesByItemId, ItemUpdateReport itemReport) {
        Integer idx;
        Map<UUID, Integer> compUpdateMap = updateMap.get(itemReport.getPriorComponent().getItemId());
        Integer n = idx = compUpdateMap == null ? null : compUpdateMap.get(itemReport.getItem().getItemId());
        if (idx != null) {
            int i = idx;
            ItemUpdateReport oldItemReport = itemReportList.get(i);
            if (itemReport.getPreviousComponent() != null) {
                if (oldItemReport.getPreviousComponent() != null) {
                    itemReport.setPreviousComponent(oldItemReport.getPreviousComponent());
                    compUpdateMap = updateMap.get(oldItemReport.getComponent().getItemId());
                    compUpdateMap.remove(itemReport.getItem().getItemId());
                    if (compUpdateMap.isEmpty()) {
                        updateMap.remove(oldItemReport.getComponent().getItemId());
                    }
                    if ((compUpdateMap = updateMap.get(itemReport.getComponent().getItemId())) == null) {
                        compUpdateMap = new HashMap<UUID, Integer>();
                        updateMap.put(itemReport.getComponent().getItemId(), compUpdateMap);
                    }
                    compUpdateMap.put(itemReport.getItem().getItemId(), idx);
                }
            } else if (!oldItemReport.getComponent().sameItemId((IItemHandle)itemReport.getComponent()) && this.checkForMergeOpportunity(itemReport, oldItemReport)) {
                return;
            }
            itemReport.setPreviousStateId(oldItemReport.getPreviousStateId());
            itemReportList.set(idx, itemReport);
        } else {
            List<Integer> indices = updatesByItemId.get(itemReport.getItem().getItemId());
            if (indices != null) {
                for (Integer i : indices) {
                    ItemUpdateReport oldItemReport = itemReportList.get(i);
                    if (oldItemReport.getComponent().sameItemId((IItemHandle)itemReport.getComponent()) || !this.checkForMergeOpportunity(itemReport, oldItemReport)) continue;
                    return;
                }
            }
            itemReportList.add(itemReport);
            compUpdateMap = updateMap.get(itemReport.getComponent().getItemId());
            if (compUpdateMap == null) {
                compUpdateMap = new HashMap<UUID, Integer>();
                updateMap.put(itemReport.getComponent().getItemId(), compUpdateMap);
            }
            compUpdateMap.put(itemReport.getItem().getItemId(), itemReportList.size() - 1);
            if (itemReport.getPreviousComponent() != null) {
                compUpdateMap = updateMap.get(itemReport.getPreviousComponent().getItemId());
                if (compUpdateMap == null) {
                    compUpdateMap = new HashMap<UUID, Integer>();
                    updateMap.put(itemReport.getPreviousComponent().getItemId(), compUpdateMap);
                }
                compUpdateMap.put(itemReport.getItem().getItemId(), itemReportList.size() - 1);
            }
        }
    }

    private boolean checkForMergeOpportunity(ItemUpdateReport itemReport, ItemUpdateReport oldItemReport) {
        if (oldItemReport.getPreviousStateId() == null && itemReport.getNewCurrentStateId() == null) {
            this.mergeDeleteIntoAdd(itemReport, oldItemReport);
            return true;
        }
        if (itemReport.getPreviousStateId() == null && oldItemReport.getNewCurrentStateId() == null) {
            this.mergeAddIntoDelete(itemReport, oldItemReport);
            return true;
        }
        return false;
    }

    private void mergeDeleteIntoAdd(ItemUpdateReport itemReport, ItemUpdateReport oldItemReport) {
        oldItemReport.setPreviousStateId(itemReport.getPreviousStateId());
        oldItemReport.setPreviousComponent(itemReport.getComponent());
    }

    private void mergeAddIntoDelete(ItemUpdateReport itemReport, ItemUpdateReport oldItemReport) {
        oldItemReport.setNewCurrentStateId(itemReport.getNewCurrentStateId());
        oldItemReport.setPreviousComponent(oldItemReport.getComponent());
        oldItemReport.setComponent(itemReport.getComponent());
    }

    private void updateWorkspaceComponentStateToUnknown(IProgressMonitor monitor) throws TeamRepositoryException {
        this.traceIfEnabled("IncrementalLoadOperation#updateWorkspaceComponentStateToUnknown: Start.");
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        HashSet<UUID> itemIdsOfComponents = new HashSet<UUID>();
        List componentsInWorkspace = this.connection.getComponents();
        for (IComponentHandle component : componentsInWorkspace) {
            itemIdsOfComponents.add(component.getItemId());
        }
        this.traceIfEnabled(NLS.bind((String)"IncrementalLoadOperation#updateWorkspaceComponentStateToUnknown: Fetching all the loaded configuration descriptors for the sandbox at location: \"{0}\".", (Object)this.cfaRoot, (Object[])new Object[0]));
        Collection<LoadedConfigurationDescriptor> allLoadedComponentConfigurations = SharingManager.getInstance().allLoadedConfigurations(this.cfaRoot, (IProgressMonitor)progress.newChild(50));
        this.traceIfEnabled("IncrementalLoadOperation#updateWorkspaceComponentStateToUnknown: Retrieving the loaded configuration descriptors for the components.");
        Collection<LoadedConfigurationDescriptor> loadedComponentConfigurations = CopyFileAreaUtil.getFilteredLoadedConfigurationForComponents(this.connection.getContextHandle().getItemId(), itemIdsOfComponents, allLoadedComponentConfigurations);
        this.traceIfEnabled("IncrementalLoadOperation#updateWorkspaceComponentStateToUnknown: Invoking CopyFileAreaUtil#updateWorkspaceComponentStateToUnknown().");
        CopyFileAreaUtil.updateWorkspaceComponentStateToUnknown(this.cfaRoot, loadedComponentConfigurations, this.traceLog, (IProgressMonitor)progress.newChild(50));
        this.traceIfEnabled("IncrementalLoadOperation#updateWorkspaceComponentStateToUnknown: End.");
    }

    private class ComponentDataForLoadRule {
        final IComponentHandle componentHandle;
        private final Map<UUID, IShare> loadedShares;
        private final Map<UUID, LoadLocation> sharesToLoad;
        private final Map<UUID, IVersionable> shareVersionables;
        private final Set<UUID> sharesToProcess;

        public ComponentDataForLoadRule(IComponentHandle componentHandle, Collection<LoadLocation> loadLocations, IShare[] shares, IProgressMonitor monitor) throws TeamRepositoryException {
            this.componentHandle = componentHandle;
            this.loadedShares = new HashMap<UUID, IShare>();
            this.sharesToLoad = new HashMap<UUID, LoadLocation>();
            this.shareVersionables = new HashMap<UUID, IVersionable>();
            this.sharesToProcess = new HashSet<UUID>();
            this.populateData(loadLocations, shares, monitor);
        }

        private void populateData(Collection<LoadLocation> sharesToLoad, IShare[] shares, IProgressMonitor monitor) throws TeamRepositoryException {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            this.populateSharesToLoad(sharesToLoad);
            this.fetchVersionables((IProgressMonitor)progress.newChild(100));
            this.populateLoadedShares(shares);
        }

        private void populateSharesToLoad(Collection<LoadLocation> sharesToLoad) {
            for (LoadLocation shareToLoad : sharesToLoad) {
                if (!this.componentHandle.getItemId().equals((Object)shareToLoad.getComponent().getItemId())) continue;
                this.addShareToLoad(shareToLoad);
            }
        }

        private void addShareToLoad(LoadLocation shareToLoad) {
            UUID shareItemId = shareToLoad.getRootToLoad().getItemId();
            this.sharesToLoad.put(shareItemId, shareToLoad);
            this.sharesToProcess.add(shareItemId);
        }

        private void fetchVersionables(IProgressMonitor monitor) throws TeamRepositoryException {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            ArrayList<IVersionableHandle> versionableHandlesToFetch = new ArrayList<IVersionableHandle>();
            Map<UUID, LoadLocation> sharesToLoad = this.getSharesToLoad();
            for (UUID itemIdOfShareToLoad : sharesToLoad.keySet()) {
                versionableHandlesToFetch.add(sharesToLoad.get(itemIdOfShareToLoad).getRootToLoad());
            }
            List fullVerionables = IncrementalLoadOperation.this.connection.configuration(this.componentHandle).fetchCompleteItems(versionableHandlesToFetch, (IProgressMonitor)progress.newChild(100));
            for (IVersionable fullVerionable : fullVerionables) {
                if (fullVerionable == null) continue;
                this.shareVersionables.put(fullVerionable.getItemId(), fullVerionable);
            }
        }

        private void populateLoadedShares(IShare[] shares) {
            IShare[] iShareArray = shares;
            int n = shares.length;
            int n2 = 0;
            while (n2 < n) {
                IShare share = iShareArray[n2];
                ISharingDescriptor shareDescriptor = share.getSharingDescriptor();
                if (shareDescriptor.getConnectionHandle().sameItemId((IItemHandle)IncrementalLoadOperation.this.connection.getContextHandle())) {
                    UUID componentItemId = shareDescriptor.getComponent().getItemId();
                    if (this.componentHandle.getItemId().equals((Object)componentItemId)) {
                        this.addLoadedShare(share);
                    }
                }
                ++n2;
            }
        }

        private void addLoadedShare(IShare share) {
            UUID shareItemId = share.getSharingDescriptor().getRootVersionable().getItemId();
            this.loadedShares.put(shareItemId, share);
            this.sharesToProcess.add(shareItemId);
        }

        public Map<UUID, IShare> getLoadedShares() {
            return this.loadedShares;
        }

        public Map<UUID, LoadLocation> getSharesToLoad() {
            return this.sharesToLoad;
        }

        public Set<UUID> getSharesToProcess() {
            return this.sharesToProcess;
        }

        public Map<UUID, IShare> getSharesToDelete() {
            Map<UUID, IShare> loadedShares = this.getLoadedShares();
            Map<UUID, LoadLocation> sharesToLoad = this.getSharesToLoad();
            HashMap<UUID, IShare> sharesToDelete = new HashMap<UUID, IShare>();
            for (UUID loadedShareItemId : loadedShares.keySet()) {
                if (!sharesToLoad.containsKey(loadedShareItemId)) {
                    sharesToDelete.put(loadedShareItemId, loadedShares.get(loadedShareItemId));
                    continue;
                }
                IShare loadedShare = loadedShares.get(loadedShareItemId);
                LoadLocation shareToLoad = sharesToLoad.get(loadedShareItemId);
                if (loadedShare.getPath().equals(shareToLoad.getLoadPath())) continue;
                sharesToDelete.put(loadedShareItemId, loadedShares.get(loadedShareItemId));
            }
            return sharesToDelete;
        }

        public Set<UUID> getSharesToAdd() {
            Map<UUID, LoadLocation> sharesToLoad = this.getSharesToLoad();
            Map<UUID, IShare> loadedShares = this.getLoadedShares();
            HashSet<UUID> sharesToAdd = new HashSet<UUID>();
            for (UUID itemIdOfShareToLoad : sharesToLoad.keySet()) {
                if (!loadedShares.containsKey(itemIdOfShareToLoad)) {
                    sharesToAdd.add(itemIdOfShareToLoad);
                    continue;
                }
                IShare loadedShare = loadedShares.get(itemIdOfShareToLoad);
                LoadLocation shareToLoad = sharesToLoad.get(itemIdOfShareToLoad);
                if (loadedShare.getPath().equals(shareToLoad.getLoadPath())) continue;
                sharesToAdd.add(itemIdOfShareToLoad);
            }
            return sharesToAdd;
        }

        private boolean isSandboxMatchingLoadRuleForShare(LoadLocation shareToLoad, IShare loadedShare, IVersionable shareVersionable) {
            if (loadedShare == null || shareToLoad == null || shareVersionable == null) {
                return false;
            }
            if (!shareToLoad.getLoadPath().equals(loadedShare.getPath())) {
                return false;
            }
            UUID stateIdOfShareToLoad = shareToLoad.getRootToLoad().getStateId();
            if (stateIdOfShareToLoad == null) {
                stateIdOfShareToLoad = shareVersionable.getStateId();
            }
            return stateIdOfShareToLoad.equals((Object)loadedShare.getSharingDescriptor().getRootVersionable().getStateId());
        }

        public boolean isSandboxMatchingLoadRuleForSharesInComponent() {
            if (this.getLoadedShares().isEmpty() || this.getSharesToLoad().isEmpty() || this.shareVersionables.isEmpty()) {
                return false;
            }
            for (UUID itemIdOfShare : this.getSharesToProcess()) {
                IVersionable shareVersionable;
                IShare loadedShare;
                LoadLocation shareToLoad = this.getSharesToLoad().get(itemIdOfShare);
                if (this.isSandboxMatchingLoadRuleForShare(shareToLoad, loadedShare = this.getLoadedShares().get(itemIdOfShare), shareVersionable = this.shareVersionables.get(itemIdOfShare))) continue;
                return false;
            }
            return true;
        }
    }
}

