/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IWorkItemsLinksRemover;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreasLock;
import com.ibm.team.filesystem.client.internal.operations.ChangeHistoryChangeSetsOperation;
import com.ibm.team.filesystem.client.internal.operations.IFilesystemRefresher;
import com.ibm.team.filesystem.client.internal.operations.UpdateOperation;
import com.ibm.team.filesystem.client.internal.utils.ChangeSetRefreshUtils;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.ExclusiveFileLockPatternUtil;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.DiscardDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IDiscardOperation;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.common.internal.util.StringMatcher;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.PatchInProgressException;
import com.ibm.team.scm.common.dto.IStreamLockReport;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public class DiscardOperation
extends ChangeHistoryChangeSetsOperation
implements IDiscardOperation {
    private final Map<IWorkspaceConnection, List<IChangeSetHandle>> discardRequests;
    private final DiscardDilemmaHandler problemHandler;
    private boolean discardWorkItemsLinks;
    private boolean autoReleaseLocks = false;

    public DiscardOperation(DiscardDilemmaHandler dilemmaHandler) {
        super(dilemmaHandler == null ? DiscardDilemmaHandler.getDefault() : dilemmaHandler);
        this.problemHandler = dilemmaHandler == null ? DiscardDilemmaHandler.getDefault() : dilemmaHandler;
        this.discardRequests = new HashMap<IWorkspaceConnection, List<IChangeSetHandle>>();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void discard(IWorkspaceConnection workspace, Collection<? extends IChangeSetHandle> changeSetsToDiscard) {
        void var4_8;
        if (workspace == null) {
            throw new IllegalArgumentException();
        }
        if (changeSetsToDiscard == null) {
            throw new IllegalArgumentException();
        }
        HashSet<UUID> checkForDuplicateInput = new HashSet<UUID>();
        for (IChangeSetHandle iChangeSetHandle : changeSetsToDiscard) {
            if (checkForDuplicateInput.add(iChangeSetHandle.getItemId())) continue;
            throw new IllegalArgumentException();
        }
        List<IChangeSetHandle> list = this.discardRequests.get(workspace);
        if (list == null) {
            ArrayList arrayList = new ArrayList();
            this.discardRequests.put(workspace, arrayList);
        } else {
            HashSet<UUID> alreadyExisting = new HashSet<UUID>();
            for (IChangeSetHandle iChangeSetHandle : changeSetsToDiscard) {
                alreadyExisting.add(iChangeSetHandle.getItemId());
            }
            if (checkForDuplicateInput.removeAll(alreadyExisting)) {
                throw new IllegalArgumentException();
            }
        }
        var4_8.addAll(changeSetsToDiscard);
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.DiscardOperation_ProgressMessage, (int)100);
        ArrayList<IAuditable> determinants = new ArrayList<IAuditable>();
        final Set<ConfigurationFacade> affectedConfigurations = this.getAffectedConfigurations(determinants, (IProgressMonitor)progress.newChild(4));
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWrite(affectedConfigurations, determinants, (IProgressMonitor)progress.newChild(1));
        try {
            IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

                @Override
                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        DiscardOperation.this.discard(affectedConfigurations, monitor);
                    }
                    catch (FileSystemException e) {
                        throw new InvocationTargetException((Throwable)((Object)e));
                    }
                    catch (TeamRepositoryException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            this.runWithinFileSystemLock(runnableWithProgress, Messages.DiscardOperation_0, (IProgressMonitor)progress.newChild(95));
        }
        finally {
            WorkspaceLockUtil.release(workspaceLock);
        }
    }

    private void discard(Set<ConfigurationFacade> affectedConfigurations, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException, InvocationTargetException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.DiscardOperation_ProgressMessage, (int)(3 * this.discardRequests.size() + 23));
        if (this.verifyInSyncEnabled() && !this.problemHandler.getOutOfSyncDilemmaHandler().willIgnoreAllSharesOutOfSync()) {
            SubMonitor iterProgress = progress.newChild(1);
            iterProgress.setWorkRemaining(affectedConfigurations.size());
            IVerifyInSyncOperation verifyOp = IOperationFactory.instance.getVerifyInSyncOperation(this.problemHandler.getOutOfSyncDilemmaHandler());
            for (ConfigurationFacade configurationFacade : affectedConfigurations) {
                verifyOp.addToVerify(configurationFacade.getConnection((IProgressMonitor)iterProgress.newChild(1)), configurationFacade.getComponentHandle());
            }
            verifyOp.run((IProgressMonitor)progress.newChild(10));
        }
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        ICopyFileAreaLockRequest lockRequest = ICopyFileAreaManager.instance.lockRequestFactory().getLockRequest(affectedConfigurations, true);
        ICopyFileAreasLock copyFileAreaLock = ICopyFileAreaManager.instance.lock(Collections.singleton(lockRequest), (IProgressMonitor)progress.newChild(1));
        try {
            this.checkinPendingChanges(affectedConfigurations, this.problemHandler, true, (IProgressMonitor)progress.newChild(10));
            for (Map.Entry entry : this.discardRequests.entrySet()) {
                try {
                    Map<IStreamLockReport, IWorkspaceConnection> locksToRelease;
                    Map<IStreamLockReport, IWorkspaceConnection> locksHeld2;
                    Map<IStreamLockReport, IWorkspaceConnection> locksHeld;
                    List<StringMatcher> matchers;
                    IWorkspaceConnection workspaceConnection = (IWorkspaceConnection)entry.getKey();
                    List changeSetHandles = (List)entry.getValue();
                    if (progress.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    IUpdateReport report = workspaceConnection.discardChangeSets(false, (Collection)changeSetHandles, (IProgressMonitor)progress.newChild(changeSetHandles.size()));
                    UpdateOperation updateOperation = new UpdateOperation(workspaceConnection, Collections.singletonList(report), 3, this.problemHandler, null);
                    this.disableVerifyInSync(updateOperation);
                    updateOperation.run((IProgressMonitor)progress.newChild(changeSetHandles.size()));
                    if (this.discardWorkItemsLinks) {
                        this.removeWorkItemLinks(entry, (IProgressMonitor)progress);
                    }
                    if ((matchers = ExclusiveFileLockPatternUtil.getPatternsToMatch((IConnection)workspaceConnection, (IProgressMonitor)progress.newChild(1))).size() == 0 || (locksHeld = ExclusiveFileLockPatternUtil.getLocksHeldByUser(workspaceConnection, changeSetHandles, (IProgressMonitor)progress.newChild(50))) == null || locksHeld.size() <= 0 || (locksHeld2 = ExclusiveFileLockPatternUtil.updateComponentLocks(workspaceConnection, locksHeld, progress.newChild(10))) == null || locksHeld2.size() == 0 || (locksToRelease = this.autoReleaseLocks ? locksHeld2 : this.problemHandler.locksToRelease(locksHeld2)).isEmpty()) continue;
                    ExclusiveFileLockPatternUtil.releaseLocks(locksToRelease, this.problemHandler.getLockDilemmaHandler(), progress.newChild(10));
                    ExclusiveFileLockPatternUtil.refreshFileAttributes(locksToRelease, affectedConfigurations, workspaceConnection, matchers, true, progress.newChild(10));
                }
                catch (PatchInProgressException e) {
                    throw new InvocationTargetException(e);
                }
                catch (TeamRepositoryException e) {
                    this.collectStatus((IStatus)new Status(4, "com.ibm.team.filesystem.client", "Error while discarding change set", (Throwable)e));
                }
            }
        }
        finally {
            copyFileAreaLock.release((IProgressMonitor)progress.newChild(1));
        }
    }

    private Set<ConfigurationFacade> getAffectedConfigurations(Collection<IAuditable> determinants, IProgressMonitor monitor) throws TeamRepositoryException {
        HashSet<ConfigurationFacade> affectedConfigurations = new HashSet<ConfigurationFacade>();
        for (Map.Entry<IWorkspaceConnection, List<IChangeSetHandle>> entry : this.discardRequests.entrySet()) {
            IWorkspaceConnection workspaceConnection = entry.getKey();
            List<IChangeSetHandle> changeSetHandles = entry.getValue();
            List changeSets = workspaceConnection.teamRepository().itemManager().fetchCompleteItems(changeSetHandles, 0, monitor);
            determinants.addAll(changeSets);
            for (IChangeSet changeSet : changeSets) {
                affectedConfigurations.add(new ConfigurationFacade((IConnection)workspaceConnection, changeSet.getComponent()));
            }
        }
        return affectedConfigurations;
    }

    @Override
    protected void refreshLocal(IFilesystemRefresher refresher, Map<ISandbox, Set<ConfigurationFacade>> affectedAreas, IProgressMonitor progress) throws FileSystemException, TeamRepositoryException {
        for (Map.Entry<IWorkspaceConnection, List<IChangeSetHandle>> entry : this.discardRequests.entrySet()) {
            IWorkspaceConnection workspaceConnection = entry.getKey();
            List<IChangeSetHandle> changeSetHandles = entry.getValue();
            ChangeSetRefreshUtils.refreshLocalForRemoval(refresher, affectedAreas, workspaceConnection, changeSetHandles, progress);
        }
    }

    private void removeWorkItemLinks(Map.Entry<IWorkspaceConnection, List<IChangeSetHandle>> entry, IProgressMonitor monitor) throws TeamRepositoryException {
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.team.filesystem.client", "workItemLinksRemover");
        if (extension != null) {
            IExtension[] extensions = extension.getExtensions();
            int i = 0;
            int max = extensions.length;
            while (i < max) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                int max2 = configElements.length;
                while (j < max2) {
                    try {
                        Object execExt = configElements[j].createExecutableExtension("class");
                        if (execExt instanceof IWorkItemsLinksRemover) {
                            List<IChangeSetHandle> list = entry.getValue();
                            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.DiscardOperation_WorkItemLinksProgressMessage, (int)list.size());
                            ((IWorkItemsLinksRemover)execExt).removeWorkItemLinks(entry.getKey(), list, (IProgressMonitor)subMonitor);
                            return;
                        }
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            LoggingHelper.log((IStatus)new Status(2, "com.ibm.team.filesystem.client", "Missing extension point for work item remover"));
        }
    }

    @Override
    public void setRemoveWorkItemLinks(boolean value) {
        this.discardWorkItemsLinks = value;
    }

    @Override
    public void setAutoReleaseLocks(boolean value) {
        this.autoReleaseLocks = value;
    }
}

