/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.operations.ChangeHistoryChangeSetsOperation;
import com.ibm.team.filesystem.client.internal.operations.IFilesystemRefresher;
import com.ibm.team.filesystem.client.internal.operations.IWorkspaceUpdateReporter;
import com.ibm.team.filesystem.client.internal.operations.NullWorkspaceUpdateReporter;
import com.ibm.team.filesystem.client.internal.operations.OperationRequest;
import com.ibm.team.filesystem.client.internal.operations.UnlockOperation;
import com.ibm.team.filesystem.client.internal.operations.UpdateOperation;
import com.ibm.team.filesystem.client.internal.operations.WorkspaceUpdateReport;
import com.ibm.team.filesystem.client.internal.utils.ChangeSetRefreshUtils;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.ExclusiveFileLockPatternUtil;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.FlowTableUtil;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.DeliverDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IDeliverOperation;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.IWorkspaceUpdateReport;
import com.ibm.team.filesystem.client.operations.LockEntry;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.DeliveryRequiresHistoryReorderingException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.internal.ConnectionDescriptor;
import com.ibm.team.scm.client.internal.FlowUtils;
import com.ibm.team.scm.client.internal.isv.IWorkspaceOperationRunner;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.ItemLockedInStreamException;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.dto.IComponentLockReport;
import com.ibm.team.scm.common.dto.IStreamLockReport;
import com.ibm.team.scm.common.dto.IUpdateReport;
import com.ibm.team.scm.common.internal.flow.FlowTable;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.ItemLists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class DeliverOperation
extends ChangeHistoryChangeSetsOperation
implements IDeliverOperation {
    private DeliverDilemmaHandler problemHandler;
    public Map<DeliverDescriptor, DeliverOperationRequest> deliverRequests = new HashMap<DeliverDescriptor, DeliverOperationRequest>();
    private boolean flowComponents = true;
    private boolean skipIncomingReplace = false;
    private boolean populateUpdateReport = false;
    private IWorkspaceUpdateReporter changes;
    private boolean autoReleaseLocks = false;

    public DeliverOperation(DeliverDilemmaHandler dilemmaHandler) {
        super(dilemmaHandler == null ? DeliverDilemmaHandler.getDefault() : dilemmaHandler);
        this.problemHandler = dilemmaHandler == null ? DeliverDilemmaHandler.getDefault() : dilemmaHandler;
        this.deliverRequests = new HashMap<DeliverDescriptor, DeliverOperationRequest>();
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.DeliverOperation_0, (int)100);
        this.changes = this.populateUpdateReport ? new WorkspaceUpdateReport() : new NullWorkspaceUpdateReporter();
        ArrayList<IAuditable> determinants = new ArrayList<IAuditable>();
        ArrayList<IContextHandle> targets = new ArrayList<IContextHandle>();
        Set<ConfigurationFacade> affectedConfigurations = this.getAffectedDeliverConfigurations(this.deliverRequests.values(), determinants, targets, (IProgressMonitor)progress.newChild(1));
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWriteForConfigurations(affectedConfigurations, targets, determinants, (IProgressMonitor)progress.newChild(1));
        HashMap<IStreamLockReport, IWorkspaceConnection> locksToRelease = new HashMap<IStreamLockReport, IWorkspaceConnection>();
        HashMap<IStreamLockReport, IWorkspaceConnection> locksBeingHeld = new HashMap<IStreamLockReport, IWorkspaceConnection>();
        HashMap<IWorkspaceConnection, List<IFlowNodeConnection.IComponentOp>> workspaceComponentOps = new HashMap<IWorkspaceConnection, List<IFlowNodeConnection.IComponentOp>>();
        HashMap<IWorkspaceConnection, Boolean> workspaceHasPatterns = new HashMap<IWorkspaceConnection, Boolean>();
        try {
            this.internalRunPreconditions(affectedConfigurations, (IProgressMonitor)progress.newChild(1));
            if (this.flowComponents) {
                progress.subTask(Messages.DeliverOperation_1);
                SubMonitor loopProgress = progress.newChild(10).setWorkRemaining(this.deliverRequests.size() * 4);
                for (DeliverOperationRequest deliverRequest : this.deliverRequests.values()) {
                    FlowTable flowTable;
                    IChangeHistorySyncReport report = deliverRequest.getSyncReport();
                    List<IFlowNodeConnection.IComponentOp> componentOps = this.getComponentSynchronizationOps(deliverRequest.isWorkspaceContext(), deliverRequest.getAffectedComponents((IProgressMonitor)loopProgress.newChild(1)), deliverRequest.getWorkspace(), deliverRequest.getTargetWorkspace(), report);
                    if (this.skipIncomingReplace) {
                        Iterator<IFlowNodeConnection.IComponentOp> itr = componentOps.iterator();
                        while (itr.hasNext()) {
                            IFlowNodeConnection.IComponentOp componentOp = itr.next();
                            if (!(componentOp instanceof IFlowNodeConnection.IComponentReplacementOp) || !this.isIncomingReplace(componentOp.getComponent(), deliverRequest.getSyncReport())) continue;
                            itr.remove();
                        }
                    }
                    if (componentOps.size() <= 0) continue;
                    if (!deliverRequest.getWorkspace().isStream()) {
                        ArrayList csToClose = new ArrayList();
                        for (IFlowNodeConnection.IComponentOp componentOp : componentOps) {
                            if (!(componentOp instanceof IFlowNodeConnection.IComponentAdditionOp)) continue;
                            csToClose.addAll(deliverRequest.getWorkspace().activeChangeSets(componentOp.getComponent()));
                        }
                        deliverRequest.getWorkspace().closeChangeSets(csToClose, (IProgressMonitor)loopProgress.newChild(1));
                    }
                    deliverRequest.getTargetWorkspace().applyComponentOperations(componentOps, (IProgressMonitor)loopProgress.newChild(1));
                    this.changes.recordComponentOps(deliverRequest.getTargetWorkspace(), componentOps);
                    boolean hasPattern = this.hasPattern(deliverRequest.getWorkspace(), workspaceHasPatterns, loopProgress);
                    if (hasPattern) {
                        workspaceComponentOps.put(deliverRequest.getWorkspace(), componentOps);
                    }
                    boolean updateFlowTable = (flowTable = (FlowTable)deliverRequest.getWorkspace().getFlowTable()).getDeliverFlow((IFlowNodeHandle)deliverRequest.getTargetWorkspace().getResolvedWorkspace(), true) != null;
                    SubMonitor componentOpProgress = loopProgress.newChild(1).setWorkRemaining(componentOps.size() + 10);
                    ArrayList<IComponentHandle> syncStatesToAdd = new ArrayList<IComponentHandle>();
                    ArrayList<IComponentHandle> syncStatesToRemove = new ArrayList<IComponentHandle>();
                    for (IFlowNodeConnection.IComponentOp componentOp : componentOps) {
                        IComponentHandle component = componentOp.getComponent();
                        if (updateFlowTable) {
                            if (componentOp instanceof IFlowNodeConnection.IComponentAdditionOp && !FlowUtils.hasComponentSyncState((IComponentHandle)component, (IWorkspaceConnection)deliverRequest.getWorkspace(), (IWorkspaceConnection)deliverRequest.getTargetWorkspace())) {
                                syncStatesToAdd.add(component);
                            }
                            if (componentOp instanceof IFlowNodeConnection.IComponentDeletionOp && FlowUtils.hasComponentSyncState((IComponentHandle)component, (IWorkspaceConnection)deliverRequest.getWorkspace(), (IWorkspaceConnection)deliverRequest.getTargetWorkspace())) {
                                syncStatesToRemove.add(component);
                            }
                        }
                        deliverRequest.clearChanges(component, (IProgressMonitor)componentOpProgress.newChild(1));
                    }
                    if (!syncStatesToAdd.isEmpty()) {
                        FlowUtils.addComponentSyncStates((IWorkspaceConnection)deliverRequest.getWorkspace(), (IConnection)deliverRequest.getTargetWorkspace(), syncStatesToAdd, (IProgressMonitor)componentOpProgress.newChild(5));
                    }
                    componentOpProgress.setWorkRemaining(5);
                    if (!syncStatesToRemove.isEmpty()) {
                        FlowUtils.removeComponentSyncStates((IWorkspaceConnection)deliverRequest.getWorkspace(), (IConnection)deliverRequest.getTargetWorkspace(), syncStatesToRemove, (IProgressMonitor)componentOpProgress.newChild(5));
                    }
                    componentOpProgress.setWorkRemaining(0);
                }
            }
            HashMap<IWorkspaceConnection, List<IChangeSet>> workspaceDeliveredChangeSets = new HashMap<IWorkspaceConnection, List<IChangeSet>>();
            SubMonitor loopProgress = progress.newChild(88).setWorkRemaining(this.deliverRequests.size() * 20);
            progress.subTask(Messages.DeliverOperation_0);
            int ignoreLocks = 3;
            ArrayList<DeliverOperationRequest> deliverRequests2 = new ArrayList<DeliverOperationRequest>(this.deliverRequests.values());
            int i = 0;
            while (i < deliverRequests2.size()) {
                DeliverOperationRequest deliverRequest = (DeliverOperationRequest)deliverRequests2.get(i);
                IChangeHistorySyncReport report = deliverRequest.getSyncReport();
                if (deliverRequest.getChangeSets().size() > 0 || deliverRequest.getBaselines().size() > 0) {
                    boolean hasPattern;
                    IChangeHistorySyncReport updatedReport = null;
                    IWorkspaceConnection targetWorkspaceConnection = deliverRequest.getTargetWorkspace();
                    try {
                        List outgoingChangeSetHandles;
                        IWorkspaceConnection workspaceConnection = deliverRequest.getWorkspace();
                        List<IComponentLockReport> componentLocks = ((IWorkspaceOperationRunner)workspaceConnection).runDeliverWithPrecondition(new IWorkspaceOperationRunner.IWorkspaceOperationRunnable(){

                            public void run(IProgressMonitor monitor) throws TeamRepositoryException {
                                DeliverOperation.this.verifyUncheckedInChanges(monitor);
                            }
                        }, targetWorkspaceConnection, report, deliverRequest.getBaselines(), deliverRequest.getChangeSets(), (IProgressMonitor)loopProgress.newChild(18));
                        this.changes.recordBaselines(targetWorkspaceConnection, deliverRequest.getBaselines(), (IProgressMonitor)loopProgress.newChild(1));
                        this.changes.recordChangeSets(targetWorkspaceConnection, deliverRequest.getChangeSets(), (IProgressMonitor)loopProgress.newChild(1));
                        updatedReport = deliverRequest.getWorkspace().compareTo((IFlowNodeConnection)deliverRequest.getTargetWorkspace(), 0, Collections.EMPTY_LIST, (IProgressMonitor)loopProgress.newChild(1));
                        if (componentLocks.size() > 0 && (outgoingChangeSetHandles = updatedReport.outgoingChangeSets()).size() != 0) {
                            componentLocks = ExclusiveFileLockPatternUtil.updateComponentLocks(componentLocks, deliverRequest.getWorkspace().teamRepository(), outgoingChangeSetHandles, loopProgress.newChild(1));
                        }
                        if (componentLocks.size() > 0) {
                            locksToRelease.put(IStreamLockReport.FACTORY.createInstance((IWorkspaceHandle)targetWorkspaceConnection.getResolvedWorkspace(), (Collection)componentLocks), targetWorkspaceConnection);
                        }
                    }
                    catch (ItemLockedInStreamException e) {
                        IStreamLockReport lockReport = e.getLockReport();
                        if (lockReport != null) {
                            locksBeingHeld.put(lockReport, targetWorkspaceConnection);
                            if (ignoreLocks == 3) {
                                ignoreLocks = this.getProblemHandler().lockBeingHeld(lockReport, targetWorkspaceConnection, deliverRequests2.size() - i - 1);
                                switch (ignoreLocks) {
                                    case 3: {
                                        break;
                                    }
                                    case 0: {
                                        break;
                                    }
                                    case 1: {
                                        throw new OperationCanceledException(e.getMessage());
                                    }
                                    case 2: {
                                        throw new FileSystemException(e);
                                    }
                                    default: {
                                        break;
                                    }
                                }
                            }
                        }
                        throw e;
                    }
                    catch (DeliveryRequiresHistoryReorderingException e) {
                        SubProgressMonitor subProgressMonitor = new SubProgressMonitor((IProgressMonitor)loopProgress, 2);
                        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)subProgressMonitor, (int)3);
                        IWorkspaceConnection source = deliverRequest.getWorkspace();
                        IComponentHandle componentHandle = e.getComponent();
                        IComponent component = (IComponent)source.teamRepository().itemManager().fetchCompleteItem((IItemHandle)componentHandle, 0, (IProgressMonitor)subMonitor.newChild(1));
                        int deliveryRequiresHistoryReordering = this.getProblemHandler().deliveryRequiresHistoryReordering(source, targetWorkspaceConnection, component);
                        switch (deliveryRequiresHistoryReordering) {
                            case 3: {
                                break;
                            }
                            case 0: {
                                IUpdateReport updateReport = source.harmonizeHistory(targetWorkspaceConnection, e.getComponent(), (IProgressMonitor)subMonitor.newChild(1));
                                UpdateOperation updateOperation = new UpdateOperation(source, Collections.singletonList(updateReport), 3, this.problemHandler, null);
                                this.disableVerifyInSync(updateOperation);
                                try {
                                    updateOperation.run((IProgressMonitor)subMonitor.newChild(1));
                                }
                                catch (FileSystemException e2) {
                                    this.collectStatus(FileSystemStatusUtil.getStatusFor((Throwable)((Object)e2)));
                                }
                                catch (TeamRepositoryException e2) {
                                    this.collectStatus(FileSystemStatusUtil.getStatusFor(e2));
                                }
                                break;
                            }
                            case 1: {
                                throw new OperationCanceledException(e.getMessage());
                            }
                            case 2: {
                                throw new FileSystemException(e);
                            }
                        }
                    }
                    if ((hasPattern = this.hasPattern(deliverRequest.getWorkspace(), workspaceHasPatterns, loopProgress)) && updatedReport != null) {
                        this.getDeliveredChangeSets(deliverRequest, updatedReport, workspaceDeliveredChangeSets, loopProgress);
                    }
                }
                ++i;
            }
            this.getProblemHandler().locksWereHeld(locksBeingHeld);
            Map<IStreamLockReport, IWorkspaceConnection> locksToRelease2 = this.autoReleaseLocks ? locksToRelease : this.getProblemHandler().locksToRelease(locksToRelease);
            if (locksToRelease2.size() > 0) {
                UnlockOperation unlockOperation = new UnlockOperation(this.getProblemHandler().getLockDilemmaHandler());
                for (Map.Entry<IStreamLockReport, IWorkspaceConnection> entry : locksToRelease2.entrySet()) {
                    List<LockEntry> locksEntries = LockEntry.createEntries(entry.getValue().teamRepository(), entry.getKey());
                    for (LockEntry lockEntry : locksEntries) {
                        unlockOperation.unlock(lockEntry.getWorkspaceConnection((IProgressMonitor)progress.newChild(1)), lockEntry.getComponent(), lockEntry.getVersionable(), lockEntry.getContributor());
                    }
                }
                unlockOperation.run((IProgressMonitor)progress.newChild(1));
            }
            ExclusiveFileLockPatternUtil.refreshFileAttributes(affectedConfigurations, workspaceDeliveredChangeSets, workspaceComponentOps, true, progress);
        }
        finally {
            WorkspaceLockUtil.release(workspaceLock);
            progress.done();
        }
    }

    private boolean hasPattern(IWorkspaceConnection workspaceConnection, Map<IWorkspaceConnection, Boolean> workspaceHasPatterns, SubMonitor loopProgress) {
        Boolean hasPattern = workspaceHasPatterns.get(workspaceConnection);
        if (hasPattern != null) {
            return hasPattern;
        }
        hasPattern = false;
        IWorkspaceConnection defaultFlowConnection = null;
        try {
            defaultFlowConnection = ExclusiveFileLockPatternUtil.getDefaultFlowConnection(workspaceConnection, (IProgressMonitor)loopProgress);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
        if (defaultFlowConnection != null) {
            String exclusiveFileLockPattern = defaultFlowConnection.getExclusiveFileLockPatterns();
            hasPattern = exclusiveFileLockPattern != null && exclusiveFileLockPattern.length() > 0;
        }
        workspaceHasPatterns.put(workspaceConnection, hasPattern);
        return hasPattern;
    }

    private void getDeliveredChangeSets(DeliverOperationRequest deliverRequest, IChangeHistorySyncReport updatedReport, Map<IWorkspaceConnection, List<IChangeSet>> workspaceDeliveredChangeSets, SubMonitor loopProgress) throws TeamRepositoryException {
        IChangeHistorySyncReport report = deliverRequest.getSyncReport();
        ArrayList<IChangeSetHandle> deliveredChangeSetHandles = new ArrayList<IChangeSetHandle>();
        for (IChangeSetHandle changeSetHandle : report.outgoingChangeSets()) {
            boolean found = false;
            for (IChangeSetHandle changeSetHandle2 : updatedReport.outgoingChangeSets()) {
                if (!changeSetHandle.getItemId().equals((Object)changeSetHandle2.getItemId())) continue;
                found = true;
                break;
            }
            if (found) continue;
            deliveredChangeSetHandles.add(changeSetHandle);
        }
        if (deliveredChangeSetHandles.size() > 0) {
            IItemManager itemManager = deliverRequest.getSourceWorkspace().teamRepository().itemManager();
            try {
                List deliveredChangeSets = itemManager.fetchCompleteItems(deliveredChangeSetHandles, 0, (IProgressMonitor)loopProgress.newChild(1));
                if (!workspaceDeliveredChangeSets.containsKey(deliverRequest.getWorkspace())) {
                    workspaceDeliveredChangeSets.put(deliverRequest.getWorkspace(), deliveredChangeSets);
                }
            }
            catch (TeamRepositoryException teamRepositoryException) {
                // empty catch block
            }
        }
    }

    private void verifyNonDefaultTargets() throws FileSystemException, TeamRepositoryException {
        int result;
        ArrayList<IWorkspaceConnection> nonDefaultTargets = new ArrayList<IWorkspaceConnection>(1);
        for (DeliverOperationRequest deliverRequest : this.deliverRequests.values()) {
            IWorkspaceConnection source = deliverRequest.getWorkspace();
            IWorkspaceConnection target = deliverRequest.getTargetWorkspace();
            ConnectionDescriptor defaultTarget = FlowTableUtil.getDefaultOutgoingCollaborationDescriptor(source);
            if (defaultTarget != null && defaultTarget.connectionHandle.sameItemId((IItemHandle)target.getResolvedWorkspace())) continue;
            nonDefaultTargets.add(target);
        }
        if (nonDefaultTargets.size() > 0 && (result = this.getProblemHandler().notDefaultTarget(nonDefaultTargets)) != 0) {
            if (result == 1) {
                throw new OperationCanceledException();
            }
            throw new FileSystemException(Messages.DeliverOperation_2);
        }
    }

    private void verifyOverrideIncomingReplace(SubMonitor monitor) throws TeamRepositoryException {
        ArrayList<ItemId<IComponent>> componentsWithIncomingReplace = new ArrayList<ItemId<IComponent>>();
        for (DeliverOperationRequest deliverRequest : this.deliverRequests.values()) {
            List<IComponentHandle> componentsToDeliver = deliverRequest.getAffectedComponents((IProgressMonitor)monitor.newChild(1));
            List<ItemId<IComponent>> componentsWithReplace = this.getComponentsWithIncomingReplace(componentsToDeliver, deliverRequest.getSyncReport());
            componentsWithIncomingReplace.addAll(componentsWithReplace);
        }
        if (!componentsWithIncomingReplace.isEmpty()) {
            List affectedComponents = ItemLists.idsToHandles(componentsWithIncomingReplace);
            int result = this.getProblemHandler().deliveryWithIncomingReplace(affectedComponents, (IProgressMonitor)monitor);
            if (result == 1) {
                throw new OperationCanceledException();
            }
            if (result == 2) {
                throw new FileSystemException(Messages.DeliverOperation_4);
            }
            if (result == 3) {
                this.setSkipIncomingReplace(true);
                for (DeliverOperationRequest deliverRequest : this.deliverRequests.values()) {
                    List<IComponentHandle> impactedComponents = deliverRequest.getAffectedComponents((IProgressMonitor)monitor.newChild(1));
                    for (IComponentHandle componentHandle : impactedComponents) {
                        if (!componentsWithIncomingReplace.contains(new ItemId((IItemHandle)componentHandle))) continue;
                        deliverRequest.clearChanges(componentHandle, (IProgressMonitor)monitor.newChild(1));
                    }
                }
            }
        }
    }

    private void verifyComponentFlowing(SubMonitor monitor) throws FileSystemException, TeamRepositoryException {
        ArrayList<UUID> affectedComponents = new ArrayList<UUID>();
        monitor.setWorkRemaining(4);
        ArrayList<DeliverDilemmaHandler.IWorkspaceComponentOperations> wco = new ArrayList<DeliverDilemmaHandler.IWorkspaceComponentOperations>();
        final ArrayList<IComponentHandle> added = new ArrayList<IComponentHandle>();
        final ArrayList<IComponentHandle> removed = new ArrayList<IComponentHandle>();
        final ArrayList<IComponentHandle> replaced = new ArrayList<IComponentHandle>();
        for (final DeliverOperationRequest deliverRequest : this.deliverRequests.values()) {
            boolean needToReportAddsAndRemoves;
            List<IFlowNodeConnection.IComponentOp> componentOps = this.getComponentSynchronizationOps(deliverRequest.isWorkspaceContext(), deliverRequest.getAffectedComponents((IProgressMonitor)monitor.newChild(1)), deliverRequest.getWorkspace(), deliverRequest.getTargetWorkspace(), deliverRequest.getSyncReport());
            for (IFlowNodeConnection.IComponentOp componentOp : componentOps) {
                IComponentHandle component = componentOp.getComponent();
                affectedComponents.add(component.getItemId());
                if (componentOp instanceof IFlowNodeConnection.IComponentAdditionOp) {
                    added.add(component);
                    continue;
                }
                if (componentOp instanceof IFlowNodeConnection.IComponentDeletionOp) {
                    removed.add(component);
                    continue;
                }
                if (!(componentOp instanceof IFlowNodeConnection.IComponentReplacementOp)) continue;
                replaced.add(component);
            }
            boolean bl = needToReportAddsAndRemoves = !deliverRequest.isComponentContext() && (added.size() > 0 || removed.size() > 0);
            if (!needToReportAddsAndRemoves && replaced.size() <= 0) continue;
            wco.add(new DeliverDilemmaHandler.IWorkspaceComponentOperations(){

                @Override
                public IWorkspaceConnection getSourceWorkspace() {
                    return deliverRequest.getWorkspace();
                }

                @Override
                public IWorkspaceConnection getTargetWorkspace() {
                    return deliverRequest.getTargetWorkspace();
                }

                @Override
                public List<IComponentHandle> getReplacedComponents() {
                    return replaced;
                }

                @Override
                public List<IComponentHandle> getRemovedComponents() {
                    return removed;
                }

                @Override
                public List<IComponentHandle> getAddedComponents() {
                    return added;
                }
            });
        }
        if (!wco.isEmpty()) {
            int result = this.getProblemHandler().componentsToBeAddedRemovedOrReplaced(wco, (IProgressMonitor)monitor.newChild(1));
            if (result == 1) {
                throw new OperationCanceledException();
            }
            if (result == 2) {
                throw new FileSystemException(Messages.DeliverOperation_3);
            }
            if (result == 3) {
                this.setFlowComponents(false);
                for (DeliverOperationRequest deliverRequest : this.deliverRequests.values()) {
                    List<IComponentHandle> impactedComponents = deliverRequest.getAffectedComponents((IProgressMonitor)monitor.newChild(1));
                    for (IComponentHandle componentHandle : impactedComponents) {
                        for (IComponentHandle changedComponent : removed) {
                            if (!changedComponent.getItemId().equals((Object)componentHandle.getItemId()) || !affectedComponents.contains(componentHandle.getItemId())) continue;
                            deliverRequest.clearChanges(componentHandle, (IProgressMonitor)monitor.newChild(1));
                        }
                        for (IComponentHandle changedComponent : added) {
                            if (!changedComponent.getItemId().equals((Object)componentHandle.getItemId()) || !affectedComponents.contains(componentHandle.getItemId())) continue;
                            deliverRequest.clearChanges(componentHandle, (IProgressMonitor)monitor.newChild(1));
                        }
                    }
                }
            }
        }
    }

    @Override
    public void deliver(IWorkspaceConnection sourceWorkspace, IWorkspaceConnection targetWorkspace, IChangeHistorySyncReport report) {
        DeliverOperationRequest request = new DeliverOperationRequest(sourceWorkspace, targetWorkspace, report, new ArrayList<IBaselineHandle>(), new ArrayList<IChangeSetHandle>(), new ArrayList<IComponentHandle>());
        if (sourceWorkspace.getResolvedWorkspace().sameItemId((IItemHandle)targetWorkspace.getResolvedWorkspace())) {
            return;
        }
        ArrayList components = new ArrayList();
        try {
            components.addAll(sourceWorkspace.getComponents());
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
        this.deliverRequests.put(new DeliverDescriptor(sourceWorkspace, targetWorkspace), request);
        for (IComponentHandle componentHandle : components) {
            this.deliver(sourceWorkspace, targetWorkspace, report, componentHandle);
        }
        request.setWorkspaceContext(true);
    }

    @Override
    public void deliver(IWorkspaceConnection sourceWorkspace, IWorkspaceConnection targetWorkspace, IChangeHistorySyncReport report, IComponentHandle component, boolean flowAll) {
        if (sourceWorkspace.getResolvedWorkspace().sameItemId((IItemHandle)targetWorkspace.getResolvedWorkspace())) {
            return;
        }
        DeliverDescriptor deliverKey = new DeliverDescriptor(sourceWorkspace, targetWorkspace);
        DeliverOperationRequest request = this.deliverRequests.get(deliverKey);
        if (request != null && request.isWorkspaceContext()) {
            return;
        }
        if (request == null) {
            ArrayList<IComponentHandle> components = new ArrayList<IComponentHandle>();
            request = new DeliverOperationRequest(sourceWorkspace, targetWorkspace, report, new ArrayList<IBaselineHandle>(), new ArrayList<IChangeSetHandle>(), components);
            request.setComponentContext(!flowAll);
            this.deliverRequests.put(deliverKey, request);
        }
        if (!request.getComponents().contains(component)) {
            request.setReport(report);
            request.addComponent(component);
            this.selectWhatToDeliver(sourceWorkspace, targetWorkspace, component, report, request);
        }
    }

    @Override
    public void deliver(IWorkspaceConnection sourceWorkspace, IWorkspaceConnection targetWorkspace, IChangeHistorySyncReport report, IComponentHandle component) {
        this.deliver(sourceWorkspace, targetWorkspace, report, component, false);
    }

    @Override
    public void deliver(IWorkspaceConnection sourceWorkspace, IWorkspaceConnection targetWorkspace, IChangeHistorySyncReport report, List<? extends IChangeSetHandle> changeSets) {
        if (sourceWorkspace.getResolvedWorkspace().sameItemId((IItemHandle)targetWorkspace.getResolvedWorkspace())) {
            return;
        }
        DeliverDescriptor deliverKey = new DeliverDescriptor(sourceWorkspace, targetWorkspace);
        DeliverOperationRequest request = this.deliverRequests.get(deliverKey);
        if (request != null && (request.isWorkspaceContext() || request.isComponentContext())) {
            return;
        }
        if (request == null) {
            request = new DeliverOperationRequest(sourceWorkspace, targetWorkspace, report, new ArrayList<IBaselineHandle>(), new ArrayList<IChangeSetHandle>(), new ArrayList<IComponentHandle>());
            this.deliverRequests.put(deliverKey, request);
        }
        request.addChangeSet(changeSets);
    }

    @Override
    public void deliver(IWorkspaceConnection sourceWorkspace, IWorkspaceConnection targetWorkspace, IChangeHistorySyncReport report, List<IBaselineHandle> baselines, List<IChangeSetHandle> changeSets, List<IComponentHandle> components) throws TeamRepositoryException {
        if (sourceWorkspace.getResolvedWorkspace().sameItemId((IItemHandle)targetWorkspace.getResolvedWorkspace())) {
            return;
        }
        DeliverDescriptor deliverKey = new DeliverDescriptor(sourceWorkspace, targetWorkspace);
        DeliverOperationRequest request = this.deliverRequests.get(deliverKey);
        if (request != null && request.isWorkspaceContext()) {
            return;
        }
        if (request == null) {
            request = new DeliverOperationRequest(sourceWorkspace, targetWorkspace, report, new ArrayList<IBaselineHandle>(), new ArrayList<IChangeSetHandle>(), new ArrayList<IComponentHandle>());
            this.deliverRequests.put(deliverKey, request);
        }
        request.addChangeSet(changeSets);
        request.addBaseline(baselines);
        request.addComponent(components);
    }

    protected void setFlowComponents(boolean flowComponents) {
        this.flowComponents = flowComponents;
    }

    protected void setSkipIncomingReplace(boolean skipIncomingReplace) {
        this.skipIncomingReplace = skipIncomingReplace;
    }

    protected Collection<DeliverOperationRequest> getDeliverRequests() {
        return this.deliverRequests.values();
    }

    protected DeliverDilemmaHandler getProblemHandler() {
        return this.problemHandler;
    }

    protected Set<ConfigurationFacade> getAffectedDeliverConfigurations(Collection<DeliverOperationRequest> requests, List<IAuditable> determinants, List<IContextHandle> targets, IProgressMonitor monitor) throws TeamRepositoryException {
        Set<ConfigurationFacade> descriptors = this.getAffectedConfigurations(requests, determinants, monitor);
        for (DeliverOperationRequest deliverOperationRequest : requests) {
            targets.add((IContextHandle)deliverOperationRequest.getTargetWorkspace().getResolvedWorkspace());
            targets.add((IContextHandle)deliverOperationRequest.getWorkspace().getResolvedWorkspace());
        }
        return descriptors;
    }

    protected Set<ConfigurationFacade> getAffectedConfigurations(Collection<? extends OperationRequest> acceptRequests, List<IAuditable> determinants, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)acceptRequests.size());
        HashSet<ConfigurationFacade> configurations = new HashSet<ConfigurationFacade>();
        for (OperationRequest operationRequest : acceptRequests) {
            configurations.addAll(operationRequest.getAffectedConfigurations(determinants, (IProgressMonitor)monitor.newChild(1)));
        }
        return configurations;
    }

    protected final void verifyUncheckedInChanges(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Set<ConfigurationFacade> affectedConfigurations = this.getAffectedDeliverConfigurations(this.getDeliverRequests(), new ArrayList<IAuditable>(3), new ArrayList<IContextHandle>(3), (IProgressMonitor)progress.newChild(1));
        this.checkinPendingChanges(affectedConfigurations, this.problemHandler, false, (IProgressMonitor)progress.newChild(99));
    }

    private void selectWhatToDeliver(IWorkspaceConnection source, IWorkspaceConnection target, IComponentHandle component, IChangeHistorySyncReport report, OperationRequest request) {
        try {
            IBaselineHandle targetBasis;
            IBaselineHandle sourceBasis;
            if (this.isOutgoingReplace(component, report)) {
                this.trace(NLS.bind((String)"Component {0} is an outgoing replace", (Object)component.getItemId().getUuidValue()));
                request.setReplace(true);
            }
            if ((sourceBasis = source.getComponentInfo(component).basis()).sameItemId((IItemHandle)(targetBasis = target.getComponentInfo(component).basis()))) {
                this.trace(NLS.bind((String)"The source basis {0} is the same as the target basis", (Object)sourceBasis.getItemId().getUuidValue()));
            } else {
                List outgoingBaselines = ItemLists.handlesToIds((Collection)report.outgoingBaselines(component));
                if (outgoingBaselines.contains(ItemId.create((IItemHandle)sourceBasis))) {
                    request.addBaseline(sourceBasis);
                    request.addChangeSet(report.outgoingChangeSetsAfterBasis(component));
                    this.trace(NLS.bind((String)"The source basis {0} is being delivered along with any change sets after the basis", (Object)sourceBasis.getItemId().getUuidValue()));
                    return;
                }
                this.trace(NLS.bind((String)"The source basis {0} is not outgoing", (Object)sourceBasis.getItemId().getUuidValue()));
            }
        }
        catch (ComponentNotInWorkspaceException e) {
            this.trace(NLS.bind((String)"Component {0} is not in the workspace", (Object)component.getItemId().getUuidValue()));
        }
        request.addChangeSet(report.outgoingChangeSets(component));
    }

    private void trace(String message) {
        Log log = LoggingHelper.getLog(this.getClass());
        if (log != null && log.isTraceEnabled()) {
            log.trace((Object)message);
        }
    }

    @Override
    public void runPreConditionsOnly(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Set<ConfigurationFacade> affectedConfigurations = this.getAffectedConfigurations(this.getDeliverRequests(), new ArrayList<IAuditable>(3), (IProgressMonitor)progress.newChild(10));
        this.internalRunPreconditions(affectedConfigurations, (IProgressMonitor)progress.newChild(90));
    }

    private void internalRunPreconditions(Collection<ConfigurationFacade> affectedConfigurations, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)25);
        this.verifyInSync(affectedConfigurations, (IProgressMonitor)progress.newChild(10));
        this.verifyNonDefaultTargets();
        this.verifyOverrideIncomingReplace(progress.newChild(5));
        this.verifyComponentFlowing(progress.newChild(5));
        this.verifyUncheckedInChanges((IProgressMonitor)progress.newChild(5));
    }

    private void verifyInSync(Collection<ConfigurationFacade> affectedConfigurations, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(100 + affectedConfigurations.size()));
        IVerifyInSyncOperation op = IOperationFactory.instance.getVerifyInSyncOperation(this.problemHandler.getOutOfSyncDilemmaHandler());
        for (ConfigurationFacade configuration : affectedConfigurations) {
            op.addToVerify(configuration.getConnection((IProgressMonitor)progress.newChild(1)), configuration.getComponentHandle());
        }
        op.run((IProgressMonitor)progress.newChild(100));
    }

    @Override
    protected void refreshLocal(IFilesystemRefresher refresher, Map<ISandbox, Set<ConfigurationFacade>> affectedAreas, IProgressMonitor progress) throws FileSystemException, TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (String)Messages.DeliverOperation_REFRESHING_LOCAL_FILESYSTEM, (int)(this.deliverRequests.size() * 2));
        for (Map.Entry<DeliverDescriptor, DeliverOperationRequest> entry : this.deliverRequests.entrySet()) {
            DeliverOperationRequest deliverRequest = entry.getValue();
            ChangeSetRefreshUtils.refreshLocalForAddition(refresher, affectedAreas, entry.getKey().source, deliverRequest.getChangeSets(), (IProgressMonitor)monitor.newChild(1));
            ChangeSetRefreshUtils.refreshForBaselineChange(refresher, affectedAreas.keySet(), entry.getKey().source, deliverRequest.getBaselines(), (IProgressMonitor)monitor.newChild(1));
            if (!this.flowComponents) {
                monitor.newChild(1);
                continue;
            }
            IChangeHistorySyncReport report = deliverRequest.getSyncReport();
            List<IFlowNodeConnection.IComponentOp> componentOps = this.getComponentSynchronizationOps(deliverRequest.isWorkspaceContext(), deliverRequest.getAffectedComponents((IProgressMonitor)monitor.newChild(1)), deliverRequest.getWorkspace(), deliverRequest.getTargetWorkspace(), report);
            if (componentOps.size() <= 0) continue;
            SubMonitor opsMon = monitor.newChild(1);
            opsMon.setWorkRemaining(componentOps.size());
            for (IFlowNodeConnection.IComponentOp op : componentOps) {
                IConnection conn;
                if (op instanceof IFlowNodeConnection.IComponentAdditionOp) {
                    conn = ((IFlowNodeConnection.IComponentAdditionOp)op).getSeedConnection();
                } else if (op instanceof IFlowNodeConnection.IComponentReplacementOp) {
                    conn = ((IFlowNodeConnection.IComponentReplacementOp)op).getSeedConnection();
                } else {
                    opsMon.newChild(1);
                    continue;
                }
                refresher.addToRefresh(affectedAreas.keySet(), conn.getContextHandle(), op.getComponent(), (IProgressMonitor)opsMon.newChild(1));
            }
        }
        monitor.done();
    }

    @Override
    public IWorkspaceUpdateReport getUpdateReport() {
        if (this.changes == null) {
            throw new IllegalStateException();
        }
        return this.changes.getReport();
    }

    @Override
    public void setPopulateUpdateReport(boolean shouldPopulate) {
        if (this.changes != null) {
            throw new IllegalStateException();
        }
        this.populateUpdateReport = shouldPopulate;
    }

    @Override
    public void setAutoReleaseLocks(boolean value) {
        this.autoReleaseLocks = value;
    }

    private List<IFlowNodeConnection.IComponentOp> getComponentSynchronizationOps(boolean workspaceContext, List<? extends IComponentHandle> components, IWorkspaceConnection source, IWorkspaceConnection target, IChangeHistorySyncReport report) {
        List remoteComponents = ItemLists.handlesToIds((Collection)report.remoteComponents());
        List localComponents = ItemLists.handlesToIds((Collection)report.localComponents());
        HashSet affectedComponents = new HashSet();
        affectedComponents.addAll(ItemLists.handlesToIds(components));
        if (workspaceContext) {
            affectedComponents.addAll(ItemLists.handlesToIds((Collection)FlowUtils.getComponentsSyncState((IFlowTable)source.getFlowTable(), (IWorkspaceHandle)target.getResolvedWorkspace())));
        }
        ArrayList<IFlowNodeConnection.IComponentOp> componentOps = new ArrayList<IFlowNodeConnection.IComponentOp>();
        for (ItemId componentId : affectedComponents) {
            boolean existsLocal = localComponents.contains(componentId);
            boolean existsRemote = remoteComponents.contains(componentId);
            IFlowNodeConnection.IComponentReplacementOp op = null;
            IComponentHandle componentHandle = (IComponentHandle)componentId.toHandle();
            if (existsLocal && existsRemote) {
                if (this.isOutgoingReplace(componentHandle, report)) {
                    op = target.componentOpFactory().replaceComponent(componentHandle, (IConnection)source, false);
                }
            } else if (existsLocal && !existsRemote) {
                if (!FlowUtils.hasDeliverFlow((IWorkspaceConnection)source, (IWorkspaceConnection)target) && target.isStream() && source.isStream() && FlowUtils.hasAcceptFlow((IWorkspaceConnection)target, (IWorkspaceConnection)source)) {
                    if (!FlowUtils.hasComponentSyncState((IComponentHandle)componentHandle, (IWorkspaceConnection)target, (IWorkspaceConnection)source)) {
                        op = target.componentOpFactory().addComponent(componentHandle, (IConnection)source, false);
                    }
                } else {
                    op = target.componentOpFactory().addComponent(componentHandle, (IConnection)source, false);
                }
            } else if (!existsLocal && existsRemote) {
                boolean hasDeliverFlow = FlowUtils.hasDeliverFlow((IWorkspaceConnection)source, (IWorkspaceConnection)target);
                if (hasDeliverFlow && FlowUtils.hasComponentSyncState((IComponentHandle)componentHandle, (IWorkspaceConnection)source, (IWorkspaceConnection)target)) {
                    op = target.componentOpFactory().removeComponent(componentHandle, false);
                } else if (!hasDeliverFlow && target.isStream() && source.isStream() && FlowUtils.hasAcceptFlow((IWorkspaceConnection)target, (IWorkspaceConnection)source) && FlowUtils.hasComponentSyncState((IComponentHandle)componentHandle, (IWorkspaceConnection)target, (IWorkspaceConnection)source)) {
                    op = target.componentOpFactory().removeComponent(componentHandle, false);
                }
            }
            if (op == null) continue;
            componentOps.add((IFlowNodeConnection.IComponentOp)op);
        }
        return componentOps;
    }

    private boolean isOutgoingReplace(IComponentHandle component, IChangeHistorySyncReport report) {
        if (report != null) {
            for (IComponentHandle replaced : report.getOutgoingReplacedComponents()) {
                if (!component.sameItemId((IItemHandle)replaced)) continue;
                return true;
            }
        }
        return false;
    }

    private List<ItemId<IComponent>> getComponentsWithIncomingReplace(List<? extends IComponentHandle> components, IChangeHistorySyncReport report) {
        HashSet affectedComponents = new HashSet();
        affectedComponents.addAll(ItemLists.handlesToIds(components));
        ArrayList<ItemId<IComponent>> componentsWithIncomingReplace = new ArrayList<ItemId<IComponent>>();
        for (ItemId componentId : affectedComponents) {
            IComponentHandle componentHandle = (IComponentHandle)componentId.toHandle();
            if (!this.isIncomingReplace(componentHandle, report)) continue;
            componentsWithIncomingReplace.add((ItemId<IComponent>)componentId);
        }
        return componentsWithIncomingReplace;
    }

    private boolean isIncomingReplace(IComponentHandle component, IChangeHistorySyncReport report) {
        if (report != null) {
            for (IComponentHandle replaced : report.getIncomingReplacedComponents()) {
                if (!component.sameItemId((IItemHandle)replaced)) continue;
                return true;
            }
        }
        return false;
    }

    public static class DeliverDescriptor {
        public IWorkspaceConnection source;
        public IWorkspaceConnection target;

        public DeliverDescriptor(IWorkspaceConnection source, IWorkspaceConnection target) {
            this.source = source;
            this.target = target;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof DeliverDescriptor)) {
                return false;
            }
            return ((DeliverDescriptor)other).source.equals((Object)this.source) && ((DeliverDescriptor)other).target.equals((Object)this.target);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.source.hashCode();
            result = 31 * result + this.target.hashCode();
            return result;
        }
    }

    public static class DeliverOperationRequest
    extends OperationRequest {
        private IWorkspaceConnection targetWorkspace;
        private boolean workspaceContext = false;
        private boolean componentContext = false;

        public DeliverOperationRequest(IWorkspaceConnection workspace, IWorkspaceConnection targetWorkspace, IChangeHistorySyncReport syncReport, List<IBaselineHandle> baselines, List<IChangeSetHandle> changeSets, List<IComponentHandle> components) {
            super(workspace, syncReport, baselines, changeSets, components, targetWorkspace);
            this.targetWorkspace = targetWorkspace;
        }

        public IWorkspaceConnection getTargetWorkspace() {
            return this.targetWorkspace;
        }

        public boolean isWorkspaceContext() {
            return this.workspaceContext;
        }

        public void setWorkspaceContext(boolean workspaceContext) {
            this.workspaceContext = workspaceContext;
        }

        public boolean isComponentContext() {
            return this.componentContext;
        }

        public void setComponentContext(boolean componentContext) {
            this.componentContext = componentContext;
        }
    }
}

