/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaUtil;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.ConnectionFacade;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IDeleteFoldersOperation;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import com.ibm.team.scm.common.dto.ISyncTime;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class DeleteInRepositoryOperation
extends FileSystemOperation
implements IDeleteFoldersOperation {
    private int totalToDelete;
    private Set<ConfigurationFacade> affectedConfigurations;
    private Map<ConnectionFacade, Map<UUID, Collection<IShareable>>> toDelete;
    private boolean deleteContent;
    private final CommitDilemmaHandler problemHandler;
    private final Shed shed;
    private final Log traceLog;

    public DeleteInRepositoryOperation(CommitDilemmaHandler problemHandler) {
        super(problemHandler == null ? CommitDilemmaHandler.getDefault() : problemHandler);
        this.problemHandler = problemHandler == null ? CommitDilemmaHandler.getDefault() : problemHandler;
        this.shed = new Shed(this.problemHandler.getBackupDilemmaHandler());
        this.toDelete = new HashMap<ConnectionFacade, Map<UUID, Collection<IShareable>>>();
        this.affectedConfigurations = new HashSet<ConfigurationFacade>();
        this.totalToDelete = 0;
        Log log = LoggingHelper.getLog(DeleteInRepositoryOperation.class);
        this.traceLog = log != null && log.isTraceEnabled() ? log : null;
    }

    private void traceIfEnabled(String message) {
        if (this.traceLog != null && this.traceLog.isTraceEnabled()) {
            this.traceLog.trace((Object)message);
        }
    }

    @Override
    public void addDeleteRequest(IShareable[] shareables, IRepositoryResolver resolver, IProgressMonitor progress) throws TeamRepositoryException, FileSystemException {
        if (shareables == null) {
            throw new IllegalArgumentException("Shareables must be supplied");
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)shareables.length);
        IShareable[] iShareableArray = shareables;
        int n = shareables.length;
        int n2 = 0;
        while (n2 < n) {
            Collection<IShareable> shareablesToDelete;
            IShareable shareable = iShareableArray[n2];
            if (shareable == null) {
                throw new IllegalArgumentException("List of shareables must not contain null");
            }
            IShare share = shareable.getShare((IProgressMonitor)monitor.newChild(1));
            if (share == null) {
                throw new FileSystemException(NLS.bind((String)Messages.DeleteOperation_0, (Object)shareable.getLocalPath().toString(), (Object[])new Object[0]));
            }
            ISharingDescriptor sharingDescriptor = share.getSharingDescriptor();
            if (!(sharingDescriptor.getConnectionHandle() instanceof IWorkspaceHandle)) {
                throw new FileSystemException(NLS.bind((String)Messages.DeleteOperation_1, (Object)shareable.getLocalPath().toString(), (Object[])new Object[0]));
            }
            UUID repositoryId = sharingDescriptor.getRepositoryId();
            ITeamRepository teamRepository = resolver.getRepoFor(null, repositoryId);
            ConfigurationFacade configurationDescriptor = new ConfigurationFacade(teamRepository, sharingDescriptor.getConnectionHandle(), sharingDescriptor.getComponent());
            this.affectedConfigurations.add(configurationDescriptor);
            ConnectionFacade descriptor = new ConnectionFacade(repositoryId, teamRepository.getRepositoryURI(), resolver, sharingDescriptor.getConnectionHandle());
            Map<UUID, Collection<IShareable>> components = this.toDelete.get((Object)descriptor);
            if (components == null) {
                components = new HashMap<UUID, Collection<IShareable>>();
                this.toDelete.put(descriptor, components);
            }
            if ((shareablesToDelete = components.get(sharingDescriptor.getComponent().getItemId())) == null) {
                shareablesToDelete = new ArrayList<IShareable>();
                components.put(sharingDescriptor.getComponent().getItemId(), shareablesToDelete);
            }
            shareablesToDelete.add(shareable);
            ++this.totalToDelete;
            ++n2;
        }
    }

    @Override
    public void setDeleteContent(boolean shouldDeleteContent) {
        this.deleteContent = shouldDeleteContent;
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.DeleteOperation_MainProgressMessage, (int)100);
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWrite(this.affectedConfigurations, (IProgressMonitor)progress.newChild(1));
        try {
            this.verifyInSync((IProgressMonitor)progress.newChild(9));
            IRunnableWithProgress workspaceOp = new IRunnableWithProgress(){

                /*
                 * Unable to fully structure code
                 */
                @Override
                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    try {
                        cfaMgr = ICopyFileAreaManager.instance;
                        lockFactory = cfaMgr.lockRequestFactory();
                        lockRequest = lockFactory.getLockRequest(DeleteInRepositoryOperation.access$0(DeleteInRepositoryOperation.this), true);
                        cfaLock = cfaMgr.lock(Collections.singleton(lockRequest), (IProgressMonitor)progress.newChild(1));
                        try {
                            iterProgress = progress.newChild(3);
                            iterProgress.setWorkRemaining(DeleteInRepositoryOperation.access$0(DeleteInRepositoryOperation.this).size());
                            affectedCopyFileAreas = new HashSet<ICopyFileArea>();
                            affectedCopyFileAreasByConfiguration = new HashMap<ConfigurationFacade, Collection<ICopyFileArea>>();
                            for (ConfigurationFacade configuration : DeleteInRepositoryOperation.access$0(DeleteInRepositoryOperation.this)) {
                                copyFileAreas = cfaMgr.getCopyFileAreasForConfiguration(configuration, (IProgressMonitor)iterProgress.newChild(1));
                                affectedCopyFileAreas.addAll(copyFileAreas);
                                affectedCopyFileAreasByConfiguration.put(configuration, copyFileAreas);
                            }
                            try {
                                try {
                                    DeleteInRepositoryOperation.access$1(DeleteInRepositoryOperation.this, affectedCopyFileAreasByConfiguration, (IProgressMonitor)progress.newChild(95));
                                }
                                catch (TeamRepositoryException e) {
                                    throw new InvocationTargetException(e);
                                }
                            }
                            finally {
                                ** for (cfa : affectedCopyFileAreas)
                            }
lbl-1000:
                            // 1 sources

                            {
                                cfa.syncMetaData();
                                continue;
lbl30:
                                // 1 sources

                            }
                        }
                        finally {
                            cfaLock.release((IProgressMonitor)progress.newChild(1));
                        }
                    }
                    catch (FileSystemException e) {
                        throw new InvocationTargetException((Throwable)e);
                    }
                }
            };
            this.runWithinFileSystemLock(workspaceOp, Messages.DeleteInRepositoryOperation_0, (IProgressMonitor)progress.newChild(90));
        }
        finally {
            WorkspaceLockUtil.release(workspaceLock);
        }
    }

    private void verifyInSync(IProgressMonitor progress) throws TeamRepositoryException, FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(this.toDelete.size() * 10 + 10));
        if (this.verifyInSyncEnabled() && !this.problemHandler.getOutOfSyncDilemmaHandler().willIgnoreAllSharesOutOfSync()) {
            IVerifyInSyncOperation verifyOp = IOperationFactory.instance.getVerifyInSyncOperation(this.problemHandler.getOutOfSyncDilemmaHandler());
            boolean verify = false;
            for (Map.Entry<ConnectionFacade, Map<UUID, Collection<IShareable>>> entry : this.toDelete.entrySet()) {
                SubMonitor iterProgress = monitor.newChild(10);
                iterProgress.setWorkRemaining(entry.getValue().size() + 1);
                HashMap<String, IShare> toVerify = new HashMap<String, IShare>();
                for (Collection<IShareable> shareablesToDelete : entry.getValue().values()) {
                    for (IShareable shareable : shareablesToDelete) {
                        IShare share = shareable.getShare((IProgressMonitor)iterProgress.newChild(1));
                        if (share == null) continue;
                        toVerify.put(share.getPath().toString(), share);
                    }
                }
                if (toVerify.isEmpty()) continue;
                verifyOp.addToVerify(entry.getKey().getConnection((IProgressMonitor)iterProgress.newChild(1)), toVerify.values());
                verify = true;
            }
            if (verify) {
                verifyOp.run((IProgressMonitor)monitor.newChild(10));
            }
        }
    }

    private void delete(Map<ConfigurationFacade, Collection<ICopyFileArea>> affectedCopyFileAreas, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        SubMonitor deleteIterationProgress = progress.newChild(100);
        deleteIterationProgress.setWorkRemaining(this.toDelete.size() * 14);
        for (Map.Entry<ConnectionFacade, Map<UUID, Collection<IShareable>>> entry : this.toDelete.entrySet()) {
            IWorkspaceConnection connection = (IWorkspaceConnection)entry.getKey().getConnection((IProgressMonitor)deleteIterationProgress.newChild(1));
            ArrayList<IChangeSetHandle> changeSets = new ArrayList<IChangeSetHandle>();
            ArrayList<Collection<? extends IWorkspaceConnection.IConfigurationOp>> configurationOps = new ArrayList<Collection<? extends IWorkspaceConnection.IConfigurationOp>>();
            HashMap<UUID, Set<ILocation>> componentToCfaRootList = new HashMap<UUID, Set<ILocation>>();
            Map<UUID, Collection<IShareable>> shareablesByComponent = entry.getValue();
            this.prepareCommitArgs(connection, shareablesByComponent, changeSets, configurationOps, componentToCfaRootList, (IProgressMonitor)deleteIterationProgress.newChild(1));
            boolean unsetWorkspaceComponentState = false;
            int errorsBeforeSandboxChanges = this.getErrors().length;
            try {
                if (!configurationOps.isEmpty()) {
                    IUpdateReport updateReport = connection.commit(changeSets, configurationOps, (IProgressMonitor)deleteIterationProgress.newChild(5));
                    HashMap<UUID, ISyncTime> beforeStates = new HashMap<UUID, ISyncTime>();
                    for (IComponentStateSummary summary : updateReport.getComponentStatesBefore()) {
                        beforeStates.put(summary.getComponent().getItemId(), summary.getConfigurationTime());
                    }
                    SubMonitor stateUpdationProgress = deleteIterationProgress.newChild(1);
                    stateUpdationProgress.setWorkRemaining(updateReport.getComponentStatesAfter().size() * 2);
                    HashMap<ILocation, Collection<LoadedConfigurationDescriptor>> cfaRootToLoadedComponentConfigurations = new HashMap<ILocation, Collection<LoadedConfigurationDescriptor>>();
                    for (IComponentStateSummary summary : updateReport.getComponentStatesAfter()) {
                        Set cfaRootList = (Set)componentToCfaRootList.get(summary.getComponent().getItemId());
                        if (cfaRootList != null) {
                            SubMonitor stateUpdationSubProgress_1 = stateUpdationProgress.newChild(1);
                            stateUpdationSubProgress_1.setWorkRemaining(cfaRootList.size());
                            for (ILocation cfaRoot : cfaRootList) {
                                this.updateWorkspaceComponentState(cfaRootToLoadedComponentConfigurations, connection.getContextHandle().getItemId(), cfaRoot, summary, (IProgressMonitor)stateUpdationSubProgress_1.newChild(1));
                            }
                        } else {
                            throw new FileSystemException(Messages.CopyFileAreaUtil_ErrorUpdatingWorkspaceComponentStateInMetadata);
                        }
                        ISyncTime beforeState = (ISyncTime)beforeStates.get(summary.getComponent().getItemId());
                        Collection<ICopyFileArea> cfaForConfiguration = affectedCopyFileAreas.get((Object)new ConfigurationFacade((IConnection)connection, summary.getComponent()));
                        SubMonitor stateUpdationSubProgress_2 = stateUpdationProgress.newChild(1);
                        stateUpdationSubProgress_2.setWorkRemaining(cfaForConfiguration.size());
                        for (ICopyFileArea cfa : cfaForConfiguration) {
                            cfa.setConfigurationState((IContextHandle)connection.getResolvedWorkspace(), summary.getComponent(), beforeState, summary.getConfigurationTime(), (IProgressMonitor)stateUpdationSubProgress_2.newChild(1));
                        }
                    }
                } else {
                    deleteIterationProgress.worked(6);
                }
                this.deleteFromCFA(shareablesByComponent, (IProgressMonitor)deleteIterationProgress.newChild(5));
            }
            catch (TeamRepositoryException e) {
                this.collectStatus(FileSystemStatusUtil.getStatusFor(4, Messages.DeleteOperation_ErrorFromServer, e));
                if (unsetWorkspaceComponentState || this.getErrors().length > errorsBeforeSandboxChanges) {
                    this.traceIfEnabled(NLS.bind((String)"DeleteInRepositoryOperation#delete: There were errors while performing delete operation. Set the workspace component state of all the components being updated, belonging to workspace: \"{0}\", to UNKNOWN, in the metadata.", (Object)connection.getName(), (Object[])new Object[0]));
                    this.updateWorkspaceComponentStateToUnknown(connection, shareablesByComponent.keySet(), componentToCfaRootList, (IProgressMonitor)deleteIterationProgress.newChild(1));
                    continue;
                }
                deleteIterationProgress.worked(1);
                continue;
            }
            catch (Exception e) {
                try {
                    unsetWorkspaceComponentState = true;
                    throw e;
                }
                catch (Throwable throwable) {
                    if (unsetWorkspaceComponentState || this.getErrors().length > errorsBeforeSandboxChanges) {
                        this.traceIfEnabled(NLS.bind((String)"DeleteInRepositoryOperation#delete: There were errors while performing delete operation. Set the workspace component state of all the components being updated, belonging to workspace: \"{0}\", to UNKNOWN, in the metadata.", (Object)connection.getName(), (Object[])new Object[0]));
                        this.updateWorkspaceComponentStateToUnknown(connection, shareablesByComponent.keySet(), componentToCfaRootList, (IProgressMonitor)deleteIterationProgress.newChild(1));
                    } else {
                        deleteIterationProgress.worked(1);
                    }
                    throw throwable;
                }
            }
            if (unsetWorkspaceComponentState || this.getErrors().length > errorsBeforeSandboxChanges) {
                this.traceIfEnabled(NLS.bind((String)"DeleteInRepositoryOperation#delete: There were errors while performing delete operation. Set the workspace component state of all the components being updated, belonging to workspace: \"{0}\", to UNKNOWN, in the metadata.", (Object)connection.getName(), (Object[])new Object[0]));
                this.updateWorkspaceComponentStateToUnknown(connection, shareablesByComponent.keySet(), componentToCfaRootList, (IProgressMonitor)deleteIterationProgress.newChild(1));
                continue;
            }
            deleteIterationProgress.worked(1);
        }
    }

    private void updateWorkspaceComponentState(Map<ILocation, Collection<LoadedConfigurationDescriptor>> cfaRootToLoadedComponentConfigurations, UUID workspaceItemId, ILocation cfaRoot, IComponentStateSummary summary, IProgressMonitor monitor) throws FileSystemException {
        this.traceIfEnabled("DeleteInRepositoryOperation#updateWorkspaceComponentState: Start.");
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.traceIfEnabled(NLS.bind((String)"DeleteInRepositoryOperation#updateWorkspaceComponentState: Processing the sandbox at location: \"{0}\".", (Object)cfaRoot, (Object[])new Object[0]));
        this.traceIfEnabled("DeleteInRepositoryOperation#updateWorkspaceComponentState: Fetching all the loaded configuration descriptors for the sandbox.");
        Collection<LoadedConfigurationDescriptor> loadedComponentConfigurations = SharingManager.getInstance().allLoadedConfigurations(cfaRoot, cfaRootToLoadedComponentConfigurations, (IProgressMonitor)progress.newChild(50));
        UUID componentItemId = summary.getComponent().getItemId();
        this.traceIfEnabled(NLS.bind((String)"DeleteInRepositoryOperation#updateWorkspaceComponentState: Retrieving the loaded configuration descriptor for the component with itemId \"{0}\".", (Object)componentItemId.getUuidValue(), (Object[])new Object[0]));
        LoadedConfigurationDescriptor loadedComponentConfiguration = CopyFileAreaUtil.getFilteredLoadedConfigurationForComponent(workspaceItemId, componentItemId, loadedComponentConfigurations);
        if (loadedComponentConfiguration != null) {
            this.traceIfEnabled("DeleteInRepositoryOperation#updateWorkspaceComponentState: Invoking CopyFileAreaUtil#updateWorkspaceComponentState().");
            CopyFileAreaUtil.updateWorkspaceComponentState(cfaRoot, summary.getWorkspaceComponentState(), false, loadedComponentConfiguration, this.traceLog, (IProgressMonitor)progress.newChild(50));
        } else {
            this.traceIfEnabled(NLS.bind((String)"DeleteInRepositoryOperation#updateWorkspaceComponentState: The component with itemId \"{0}\" is not loaded, hence we do not update it's workspace component state in the metadata.", (Object)summary.getComponent().getItemId().getUuidValue(), (Object[])new Object[0]));
            progress.worked(50);
        }
        this.traceIfEnabled("DeleteInRepositoryOperation#updateWorkspaceComponentState: End.");
    }

    private void deleteFromCFA(Map<UUID, Collection<IShareable>> shareablesByComponent, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(shareablesByComponent.size() * 100));
        String action = this.deleteContent ? Messages.DeleteOperation_SubProgressActionName : Messages.DeleteOperation_SubProgressActionNameAlt;
        int i = 0;
        for (Collection<IShareable> shareables : shareablesByComponent.values()) {
            ++i;
            final SubMonitor subProgress = progress.newChild(100);
            subProgress.setWorkRemaining(shareables.size() * 50);
            for (IShareable shareable : shareables) {
                IRelativeLocation path = shareable.getLocalPath();
                subProgress.setTaskName(NLS.bind((String)Messages.DeleteOperation_ActionNumbers, (Object)action, (Object[])new Object[]{path, i, this.totalToDelete}));
                final IFileStorage fileStorage = ((Shareable)shareable).getFileStorage();
                try {
                    ((Shareable)shareable).forget((IProgressMonitor)subProgress.newChild(24));
                }
                catch (FileSystemException e) {
                    this.collectStatus(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.DeleteOperation_ErrorFromClientDelete, (Object)path, (Object[])new Object[0]), (Throwable)((Object)e)));
                    break;
                }
                boolean exists = false;
                try {
                    exists = shareable.exists((IProgressMonitor)subProgress.newChild(1));
                }
                catch (FileSystemException e) {
                    this.collectStatus(FileSystemStatusUtil.getStatusFor((Throwable)((Object)e)));
                }
                if (!exists || !this.deleteContent) continue;
                try {
                    SharingManager.getInstance().doSilentChange(new SharingManager.FileSystemRunnable(){

                        @Override
                        public void run() throws TeamRepositoryException {
                            fileStorage.delete(DeleteInRepositoryOperation.this.shed, (IProgressMonitor)subProgress.newChild(25));
                        }
                    });
                }
                catch (TeamRepositoryException e) {
                    this.collectStatus(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.DeleteOperation_ErrorFromFileSystemDelete, (Object)path, (Object[])new Object[0]), e));
                }
            }
            subProgress.done();
        }
    }

    private void prepareCommitArgs(IWorkspaceConnection connection, Map<UUID, Collection<IShareable>> shareablesForConnection, ArrayList<IChangeSetHandle> changeSets, ArrayList<Collection<? extends IWorkspaceConnection.IConfigurationOp>> configurationOps, Map<UUID, Set<ILocation>> componentToCfaRootList, IProgressMonitor progress) throws TeamRepositoryException, FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(shareablesForConnection.size() * 100));
        for (Map.Entry<UUID, Collection<IShareable>> shareablesByComponent : shareablesForConnection.entrySet()) {
            Collection<IShareable> shareables = shareablesByComponent.getValue();
            ArrayList<Object> configurationOpsForComponent = new ArrayList<Object>(shareables.size());
            SubMonitor iterProgress = monitor.newChild(100);
            iterProgress.setWorkRemaining(shareables.size() + 1);
            for (IShareable shareable : shareables) {
                IVersionableHandle versionable = shareable.getRemote((IProgressMonitor)iterProgress.newChild(1));
                if (versionable instanceof IFolderHandle) {
                    configurationOpsForComponent.add(connection.configurationOpFactory().deleteSubtree((IFolderHandle)versionable));
                } else if (versionable instanceof IFileItemHandle || versionable instanceof ISymbolicLinkHandle) {
                    configurationOpsForComponent.add(connection.configurationOpFactory().delete(versionable));
                }
                ILocation cfaRoot = shareable.getSandbox().getRoot();
                if (componentToCfaRootList.containsKey(shareablesByComponent.getKey())) {
                    componentToCfaRootList.get(shareablesByComponent.getKey()).add(cfaRoot);
                    continue;
                }
                HashSet<ILocation> cfaRootList = new HashSet<ILocation>();
                cfaRootList.add(cfaRoot);
                componentToCfaRootList.put(shareablesByComponent.getKey(), cfaRootList);
            }
            if (iterProgress.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (configurationOpsForComponent.isEmpty()) continue;
            IComponentHandle componentHandle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((Object)connection, shareablesByComponent.getKey(), null);
            IChangeSetHandle cs = connection.getCurrentChangeSet(componentHandle);
            if (cs == null) {
                cs = connection.createChangeSet(componentHandle, Messages.DeleteOperation_2, true, (IProgressMonitor)iterProgress.newChild(1));
            }
            changeSets.add(cs);
            configurationOps.add(configurationOpsForComponent);
        }
    }

    private void updateWorkspaceComponentStateToUnknown(IWorkspaceConnection connection, Collection<UUID> componentIds, Map<UUID, Set<ILocation>> componentToCfaRootList, IProgressMonitor monitor) throws FileSystemException {
        this.traceIfEnabled("DeleteInRepositoryOperation#updateWorkspaceComponentStateToUnknown: Start.");
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        HashMap cfaRootToComponentIds = new HashMap();
        for (UUID compId : componentIds) {
            Collection cfaRootsForComponent = componentToCfaRootList.get(compId);
            for (ILocation cfaRoot : cfaRootsForComponent) {
                if (cfaRootToComponentIds.containsKey(cfaRoot)) {
                    ((Set)cfaRootToComponentIds.get(cfaRoot)).add(compId);
                    continue;
                }
                HashSet<UUID> compIds = new HashSet<UUID>();
                compIds.add(compId);
                cfaRootToComponentIds.put(cfaRoot, compIds);
            }
        }
        SubMonitor subProgress = progress.newChild(100);
        subProgress.setWorkRemaining(cfaRootToComponentIds.size() * 2);
        for (ILocation cfaRoot : cfaRootToComponentIds.keySet()) {
            this.traceIfEnabled(NLS.bind((String)"DeleteInRepositoryOperation#updateWorkspaceComponentStateToUnknown: Processing the sandbox at location: \"{0}\".", (Object)cfaRoot, (Object[])new Object[0]));
            this.traceIfEnabled("DeleteInRepositoryOperation#updateWorkspaceComponentStateToUnknown: Fetching all the loaded configuration descriptors for the sandbox.");
            Collection<LoadedConfigurationDescriptor> allLoadedComponentConfigurations = SharingManager.getInstance().allLoadedConfigurations(cfaRoot, (IProgressMonitor)subProgress.newChild(1));
            this.traceIfEnabled("DeleteInRepositoryOperation#updateWorkspaceComponentStateToUnknown: Retrieving the loaded configuration descriptors for the components.");
            Collection<LoadedConfigurationDescriptor> loadedComponentConfigurations = CopyFileAreaUtil.getFilteredLoadedConfigurationForComponents(connection.getContextHandle().getItemId(), (Collection)cfaRootToComponentIds.get(cfaRoot), allLoadedComponentConfigurations);
            this.traceIfEnabled("DeleteInRepositoryOperation#updateWorkspaceComponentStateToUnknown: Invoking CopyFileAreaUtil#updateWorkspaceComponentStateToUnknown().");
            CopyFileAreaUtil.updateWorkspaceComponentStateToUnknown(cfaRoot, loadedComponentConfigurations, this.traceLog, (IProgressMonitor)subProgress.newChild(1));
        }
        this.traceIfEnabled("DeleteInRepositoryOperation#updateWorkspaceComponentStateToUnknown: End.");
    }

    static /* synthetic */ Set access$0(DeleteInRepositoryOperation deleteInRepositoryOperation) {
        return deleteInRepositoryOperation.affectedConfigurations;
    }

    static /* synthetic */ void access$1(DeleteInRepositoryOperation deleteInRepositoryOperation, Map map, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemException {
        deleteInRepositoryOperation.delete(map, iProgressMonitor);
    }
}

