/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.IFileContentMerger;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.internal.util.StringMatcher;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;

public class DelegatingFileContentMerger
implements IFileContentMerger {
    private static final String ALWAYS_VALUE = "always";
    private static final String NEVER_VALUE = "never";
    private static final String INCLUSIVE_VALUE = "inclusive";
    private static final String EXCLUSIVE_VALUE = "exclusive";
    private IFileContentMerger internalDelegate = SharingManager.getInstance().getFileContentMerger();
    private IFileContentMerger externalDelegate;
    private String filePatterns;
    private String policy;
    private static Map<String, StringMatcher> cache = new HashMap<String, StringMatcher>();

    public DelegatingFileContentMerger(IFileContentMerger externalDelegate) {
        this.externalDelegate = externalDelegate;
    }

    public void setFilePatterns(String filePatternList, String policy) {
        this.policy = policy;
        this.filePatterns = filePatternList;
    }

    private boolean shouldUseExternalTool(String filename) throws FileSystemException {
        if (NEVER_VALUE.equalsIgnoreCase(this.policy) || this.externalDelegate == null) {
            return false;
        }
        if (ALWAYS_VALUE.equalsIgnoreCase(this.policy) || this.filePatterns == null || this.filePatterns.isEmpty()) {
            return true;
        }
        if (INCLUSIVE_VALUE.equalsIgnoreCase(this.policy)) {
            return DelegatingFileContentMerger.filenameMatches(this.filePatterns, filename, true);
        }
        if (EXCLUSIVE_VALUE.equalsIgnoreCase(this.policy)) {
            return DelegatingFileContentMerger.filenameMatches(this.filePatterns, filename, false);
        }
        throw new FileSystemException(NLS.bind((String)Messages.ParmValidation_11, (Object)this.policy));
    }

    public static boolean filenameMatches(String filePatterns, String filename, boolean inclusive) {
        String[] stringArray = filePatterns.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = stringArray[n2];
            if (!(pattern = pattern.trim()).isEmpty()) {
                StringMatcher matcher = cache.get(pattern);
                if (matcher == null) {
                    matcher = new StringMatcher(pattern, true, false);
                    cache.put(pattern, matcher);
                }
                if (matcher.match(filename)) {
                    return inclusive;
                }
            }
            ++n2;
        }
        return !inclusive;
    }

    @Override
    public IStatus performAutoMerge(ITeamRepository repository, IFileItem commonAncestorItem, IFileItem proposedItem, IShareable shareable, String contentTypeForMerge, Shed backupShed, IProgressMonitor progress) throws FileSystemException, IOException, TeamRepositoryException {
        IFileContentMerger merger = this.internalDelegate;
        if (this.shouldUseExternalTool(shareable.getFullPath().getName())) {
            merger = this.externalDelegate;
        }
        return merger.performAutoMerge(repository, commonAncestorItem, proposedItem, shareable, contentTypeForMerge, backupShed, progress);
    }

    @Override
    public void convertLineDelimiter(IShareable shareable, IFileItem proposedItem, FileLineDelimiter lineDelimiter, Shed shed, IProgressMonitor monitor) throws FileSystemException {
        IFileContentMerger merger = this.internalDelegate;
        if (this.shouldUseExternalTool(shareable.getFullPath().getName())) {
            merger = this.externalDelegate;
        }
        merger.convertLineDelimiter(shareable, proposedItem, lineDelimiter, shed, monitor);
    }

    @Override
    public IStatus performAutoMerge(ITeamRepository repository, IFileItem commonAncestor, IFileItem proposed, IFileItem current, OutputStream outputStream, IPath remotePath, String contentTypeForMerge, IProgressMonitor monitor) throws FileSystemException, IOException {
        IFileContentMerger merger = this.internalDelegate;
        if (this.shouldUseExternalTool(commonAncestor.getName())) {
            merger = this.externalDelegate;
        }
        return merger.performAutoMerge(repository, commonAncestor, proposed, current, outputStream, remotePath, contentTypeForMerge, monitor);
    }
}

