/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.operations.ChangeHistoryChangeSetsOperation;
import com.ibm.team.filesystem.client.internal.operations.IFilesystemRefresher;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.CreateSnapshotDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICreateSnapshotOperation;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.BaselineSetFlags;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IComponentHierarchyNode;
import com.ibm.team.scm.common.IComponentHierarchyResult;
import com.ibm.team.scm.common.dto.IItemConflictReport;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class CreateSnapshotOperation
extends ChangeHistoryChangeSetsOperation
implements ICreateSnapshotOperation {
    IWorkspaceConnection workspace;
    Collection<? extends IComponentHandle> componentList;
    int baselineSetFlag;
    public String name;
    public String comment;
    private CreateSnapshotDilemmaHandler problemHandler;
    private IBaselineSetHandle snapshot;

    public CreateSnapshotOperation(CreateSnapshotDilemmaHandler dilemmaHandler) {
        super(dilemmaHandler == null ? CreateSnapshotDilemmaHandler.getDefault() : dilemmaHandler);
        this.problemHandler = dilemmaHandler == null ? CreateSnapshotDilemmaHandler.getDefault() : dilemmaHandler;
    }

    @Override
    public void createSnapshotRequest(IWorkspaceConnection workspace, Collection<? extends IComponentHandle> componentHandles, int flags, String name, String comment) {
        if (workspace == null) {
            throw new IllegalArgumentException("missing workspace");
        }
        if (!BaselineSetFlags.isValid((int)flags)) {
            throw new IllegalArgumentException("invalid flag value");
        }
        if (this.workspace != null) {
            throw new IllegalArgumentException("com.ibm.team.filesystem.client.internal.operations.CreateSnapshotOperation.createSnapshotRequest(IWorkspaceConnection, Collection<IComponentHandle>, int, String, String) can only be called once");
        }
        this.workspace = workspace;
        this.componentList = componentHandles == null ? Collections.emptyList() : componentHandles;
        this.baselineSetFlag = flags;
        this.name = name;
        this.comment = comment;
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.CreateSnapshotOperation_0, (int)100);
        HashMap<UUID, IComponentHandle> rootComponentsNotExcluded = new HashMap<UUID, IComponentHandle>();
        HashMap<UUID, IComponentHandle> subcomponentsNotExcluded = new HashMap<UUID, IComponentHandle>();
        HashSet<ConfigurationFacade> inaccessibleSubcomponentsInWorkspace = new HashSet<ConfigurationFacade>();
        HashSet<ConfigurationFacade> inaccessibleSubcomponentsNotInWorkspace = new HashSet<ConfigurationFacade>();
        HashSet<ConfigurationFacade> subcomponentsNotInWorkspace = new HashSet<ConfigurationFacade>();
        HashMap<UUID, IComponentHandle> entireHierarchyNotInSnapshotConfiguration = new HashMap<UUID, IComponentHandle>();
        ArrayList<IComponentHandle> excludesList = new ArrayList<IComponentHandle>();
        this.getConfigurationsForSubcomponents(excludesList, rootComponentsNotExcluded, subcomponentsNotExcluded, inaccessibleSubcomponentsInWorkspace, inaccessibleSubcomponentsNotInWorkspace, subcomponentsNotInWorkspace, entireHierarchyNotInSnapshotConfiguration, (IProgressMonitor)progress.newChild(15));
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWrite((IConnection)this.workspace, (IProgressMonitor)progress.newChild(5));
        try {
            this.runPreConditions(rootComponentsNotExcluded, subcomponentsNotExcluded, inaccessibleSubcomponentsInWorkspace, inaccessibleSubcomponentsNotInWorkspace, subcomponentsNotInWorkspace, entireHierarchyNotInSnapshotConfiguration, (IProgressMonitor)progress.newChild(20));
            int adjustedFlags = this.baselineSetFlag &= 0xFFFFFFFB;
            this.snapshot = this.workspace.createBaselineSet(excludesList, this.name, this.comment, adjustedFlags, (IProgressMonitor)progress.newChild(60));
        }
        finally {
            WorkspaceLockUtil.release(workspaceLock);
        }
    }

    private void runPreConditions(Map<UUID, IComponentHandle> rootComponentsNotExcluded, Map<UUID, IComponentHandle> subcomponentsNotExcluded, Set<ConfigurationFacade> inaccessibleSubcomponentsInWorkspace, Set<ConfigurationFacade> inaccessibleSubcomponentsNotInWorkspace, Set<ConfigurationFacade> subcomponentsNotInWorkspace, Map<UUID, IComponentHandle> missingComponentsForHierarchy, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(100 + (subcomponentsNotExcluded.isEmpty() ? 0 : 50) + (inaccessibleSubcomponentsNotInWorkspace.isEmpty() ? 0 : 10) + (subcomponentsNotInWorkspace.isEmpty() ? 0 : 10)));
        try {
            if (this.verifyInSyncEnabled() && !this.problemHandler.getOutOfSyncDilemmaHandler().willIgnoreAllSharesOutOfSync()) {
                IVerifyInSyncOperation verifyOp = IOperationFactory.instance.getVerifyInSyncOperation(this.problemHandler.getOutOfSyncDilemmaHandler());
                for (IComponentHandle componentHandle : rootComponentsNotExcluded.values()) {
                    verifyOp.addToVerify((IConnection)this.workspace, componentHandle);
                }
                for (IComponentHandle componentHandle : subcomponentsNotExcluded.values()) {
                    verifyOp.addToVerify((IConnection)this.workspace, componentHandle);
                }
                verifyOp.run((IProgressMonitor)progress.newChild(50));
            }
            progress.setWorkRemaining(50 + (subcomponentsNotExcluded.isEmpty() ? 0 : 50) + (inaccessibleSubcomponentsNotInWorkspace.isEmpty() ? 0 : 10) + (subcomponentsNotInWorkspace.isEmpty() ? 0 : 10));
            this.checkingConflicts(rootComponentsNotExcluded, subcomponentsNotExcluded, (IProgressMonitor)progress.newChild(5));
            if (!inaccessibleSubcomponentsInWorkspace.isEmpty()) {
                int size = inaccessibleSubcomponentsInWorkspace.size();
                if (size == 1) {
                    ConfigurationFacade config = inaccessibleSubcomponentsInWorkspace.iterator().next();
                    String uuid = config.getComponentHandle().getItemId().getUuidValue();
                    if (this.workspace.isStream()) {
                        throw new FileSystemException(NLS.bind((String)Messages.CreateSnapshotOperation_InaccessibleSubcomponentInStream, (Object)uuid));
                    }
                    throw new FileSystemException(NLS.bind((String)Messages.CreateSnapshotOperation_InaccessibleSubcomponentInWorkspace, (Object)uuid));
                }
                if (this.workspace.isStream()) {
                    throw new FileSystemException(NLS.bind((String)Messages.CreateSnapshotOperation_InaccessibleSubcomponentsInStream, (Object)size));
                }
                throw new FileSystemException(NLS.bind((String)Messages.CreateSnapshotOperation_InaccessibleSubcomponentsInWorkspace, (Object)size));
            }
            this.checkingActiveChangeSets(false, rootComponentsNotExcluded, (IProgressMonitor)progress.newChild(5));
            this.checkinPendingChanges(rootComponentsNotExcluded, false, false, (IProgressMonitor)progress.newChild(40));
            if (!inaccessibleSubcomponentsNotInWorkspace.isEmpty()) {
                int direction = this.problemHandler.inaccessibleSubcomponents(inaccessibleSubcomponentsNotInWorkspace, (IProgressMonitor)progress.newChild(10));
                if (direction == 1) {
                    throw new OperationCanceledException();
                }
                if (direction != 0) {
                    throw new FileSystemException(Messages.CreateSnapshotOperation_4);
                }
            }
            if (!subcomponentsNotInWorkspace.isEmpty()) {
                int direction = this.problemHandler.subcomponentsNotInWorkspace(subcomponentsNotInWorkspace, (IProgressMonitor)progress.newChild(10));
                if (direction == 1) {
                    throw new OperationCanceledException();
                }
                if (direction != 0) {
                    throw new FileSystemException(Messages.CreateSnapshotOperation_5);
                }
            }
            if (!missingComponentsForHierarchy.isEmpty()) {
                ArrayList<ConfigurationFacade> missingComponentsInHierarchies = new ArrayList<ConfigurationFacade>();
                for (IComponentHandle handle : missingComponentsForHierarchy.values()) {
                    missingComponentsInHierarchies.add(new ConfigurationFacade((IConnection)this.workspace, handle));
                }
                int direction = this.problemHandler.entireHierarchyNotInSnapshot(missingComponentsInHierarchies);
                if (direction == 1) {
                    throw new OperationCanceledException();
                }
                if (direction != 0) {
                    throw new FileSystemException(Messages.CreateSnapshotOperation_7);
                }
            }
            HashMap<UUID, IComponentHandle> toCheckforActiveChangeSets = new HashMap<UUID, IComponentHandle>(subcomponentsNotExcluded.size() + missingComponentsForHierarchy.size());
            toCheckforActiveChangeSets.putAll(subcomponentsNotExcluded);
            toCheckforActiveChangeSets.putAll(missingComponentsForHierarchy);
            this.checkingActiveChangeSets(true, toCheckforActiveChangeSets, (IProgressMonitor)progress.newChild(10));
            this.checkinPendingChanges(subcomponentsNotExcluded, false, true, (IProgressMonitor)progress.newChild(40));
        }
        finally {
            progress.done();
        }
    }

    private void checkinPendingChanges(Map<UUID, IComponentHandle> configurations, boolean locksAcquired, boolean subComponents, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        if (configurations.size() == 0) {
            return;
        }
        HashSet<ConfigurationFacade> facades = new HashSet<ConfigurationFacade>();
        for (IComponentHandle handle : configurations.values()) {
            facades.add(new ConfigurationFacade((IConnection)this.workspace, handle));
        }
        this.checkinPendingChanges(facades, this.problemHandler, locksAcquired, subComponents, monitor);
    }

    private void checkingActiveChangeSets(boolean inSubcomponents, Map<UUID, IComponentHandle> configurations, IProgressMonitor monitor) throws FileSystemException {
        if (configurations.size() == 0) {
            return;
        }
        HashMap<ConfigurationFacade, Collection<IChangeSetHandle>> handles = new HashMap<ConfigurationFacade, Collection<IChangeSetHandle>>();
        for (IComponentHandle handle : configurations.values()) {
            List activeChangeSets = this.workspace.activeChangeSets(handle);
            if (activeChangeSets.isEmpty()) continue;
            handles.put(new ConfigurationFacade((IConnection)this.workspace, handle), activeChangeSets);
        }
        if (!handles.isEmpty()) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
            if (inSubcomponents) {
                int direction = this.problemHandler.activeChangeSetsInSubcomponents(handles, (IProgressMonitor)progress.newChild(10));
                if (direction == 1) {
                    throw new OperationCanceledException();
                }
                if (direction != 0) {
                    throw new FileSystemException(Messages.CreateSnapshotOperation_3);
                }
            } else {
                int direction = this.problemHandler.activeChangeSetsInConfiguration(handles, (IProgressMonitor)progress.newChild(10));
                if (direction == 1) {
                    throw new OperationCanceledException();
                }
                if (direction != 0) {
                    throw new FileSystemException(Messages.CreateSnapshotOperation_6);
                }
            }
        }
    }

    private void checkingConflicts(Map<UUID, IComponentHandle> rootComponentsNotExcluded, Map<UUID, IComponentHandle> subcomponentsNotExcluded, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        HashSet<ConfigurationFacade> conflictedRootConfigurations = new HashSet<ConfigurationFacade>();
        HashSet<ConfigurationFacade> conflictedSubcomponents = new HashSet<ConfigurationFacade>();
        Collection conflicts = this.workspace.conflictReport().conflicts();
        if (!conflicts.isEmpty()) {
            for (IItemConflictReport report : conflicts) {
                IComponentHandle component = report.getComponent();
                UUID itemId = component.getItemId();
                if (rootComponentsNotExcluded.get(itemId) != null) {
                    conflictedRootConfigurations.add(new ConfigurationFacade((IConnection)this.workspace, component));
                }
                if (subcomponentsNotExcluded.get(itemId) == null) continue;
                conflictedSubcomponents.add(new ConfigurationFacade((IConnection)this.workspace, component));
            }
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)((conflictedRootConfigurations.isEmpty() ? 0 : 10) + (conflictedSubcomponents.isEmpty() ? 0 : 10)));
        if (!conflictedRootConfigurations.isEmpty()) {
            int direction = this.problemHandler.conflictedConfigurations(conflictedRootConfigurations, (IProgressMonitor)progress.newChild(10));
            if (direction == 1) {
                throw new OperationCanceledException();
            }
            throw new FileSystemException(Messages.CreateSnapshotOperation_1);
        }
        if (!conflictedSubcomponents.isEmpty()) {
            int direction = this.problemHandler.conflictedConfigurationsInSubcomponents(conflictedSubcomponents, (IProgressMonitor)progress.newChild(10));
            if (direction == 1) {
                throw new OperationCanceledException();
            }
            throw new FileSystemException(Messages.CreateSnapshotOperation_2);
        }
    }

    @Override
    public IBaselineSetHandle getSnapshotCreated() {
        return this.snapshot;
    }

    @Override
    protected void refreshLocal(IFilesystemRefresher refresher, Map<ISandbox, Set<ConfigurationFacade>> affectedAreas, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.CreateSnapshotOperation_REFRESHING_LOCAL_FILESYSTEM, (int)affectedAreas.size());
        for (Map.Entry<ISandbox, Set<ConfigurationFacade>> entry : affectedAreas.entrySet()) {
            IShare[] iShareArray = entry.getKey().allShares((IProgressMonitor)progress);
            int n = iShareArray.length;
            int n2 = 0;
            while (n2 < n) {
                IShare share = iShareArray[n2];
                refresher.addToRefresh(share.getShareable());
                ++n2;
            }
        }
    }

    protected void getConfigurationsForSubcomponents(Collection<IComponentHandle> excludedComponents, Map<UUID, IComponentHandle> rootComponentsNotExcluded, Map<UUID, IComponentHandle> subcomponentsNotExcluded, Set<ConfigurationFacade> inaccessibleSubcomponentsInWorkspace, Set<ConfigurationFacade> inaccessibleSubcomponentsNotInWorkspace, Set<ConfigurationFacade> subcomponentsNotInWorkspace, Map<UUID, IComponentHandle> entireHierarchyNotInSnapshotConfiguration, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)15);
        this.workspace.refresh((IProgressMonitor)progress.newChild(5));
        HashMap<UUID, IComponentHandle> allComponentsInWorkspace = new HashMap<UUID, IComponentHandle>();
        for (IComponentHandle handle : this.workspace.getComponents()) {
            allComponentsInWorkspace.put(handle.getItemId(), handle);
        }
        if ((this.baselineSetFlag & 4) != 0 && !this.componentList.isEmpty()) {
            HashMap<UUID, IComponentHandle> excludesMap = new HashMap<UUID, IComponentHandle>();
            excludesMap.putAll(allComponentsInWorkspace);
            for (IComponentHandle iComponentHandle : this.componentList) {
                excludesMap.remove(iComponentHandle.getItemId());
            }
            excludedComponents.addAll(excludesMap.values());
        } else {
            excludedComponents.addAll(this.componentList);
        }
        HashSet<UUID> allInaccessibleComponentsInWorkspace = new HashSet<UUID>();
        for (IComponentHandle iComponentHandle : this.workspace.getUnreadableComponents()) {
            allInaccessibleComponentsInWorkspace.add(iComponentHandle.getItemId());
        }
        IComponentHierarchyResult iComponentHierarchyResult = this.workspace.getComponentHierarchy(null);
        Collection roots = iComponentHierarchyResult.getRoots();
        for (IComponentHierarchyNode node : roots) {
            rootComponentsNotExcluded.put(node.getComponentHandle().getItemId(), node.getComponentHandle());
        }
        HashMap<UUID, IComponentHandle> excludedConfigurations = new HashMap<UUID, IComponentHandle>();
        for (IComponentHandle handle : excludedComponents) {
            UUID itemId = handle.getItemId();
            rootComponentsNotExcluded.remove(itemId);
            excludedConfigurations.put(itemId, handle);
        }
        Map subcomponentsToFetch = iComponentHierarchyResult.getFlattenedElementsMap();
        if (!subcomponentsToFetch.isEmpty()) {
            IComponent subcomponent;
            UUID subComponentUUID;
            IFetchResult fetchResult = this.workspace.teamRepository().itemManager().fetchCompleteItemsPermissionAware(new ArrayList(subcomponentsToFetch.values()), 1, (IProgressMonitor)progress.newChild(10));
            for (Object retrievedItem : fetchResult.getRetrievedItems()) {
                if (!(retrievedItem instanceof IComponent) || rootComponentsNotExcluded.containsKey(subComponentUUID = (subcomponent = (IComponent)retrievedItem).getItemId()) || excludedConfigurations.containsKey(subComponentUUID)) continue;
                if (allComponentsInWorkspace.keySet().contains(subComponentUUID)) {
                    subcomponentsNotExcluded.put(subComponentUUID, (IComponentHandle)subcomponent);
                    continue;
                }
                subcomponentsNotInWorkspace.add(new ConfigurationFacade((IConnection)this.workspace, (IComponentHandle)subcomponent));
            }
            for (Object missingItem : fetchResult.getMissingItems()) {
                if (!(missingItem instanceof IComponentHandle) || rootComponentsNotExcluded.containsKey(subComponentUUID = (subcomponent = (IComponentHandle)missingItem).getItemId()) || excludedConfigurations.containsKey(subComponentUUID)) continue;
                ConfigurationFacade configuration = new ConfigurationFacade((IConnection)this.workspace, (IComponentHandle)subcomponent);
                if (allInaccessibleComponentsInWorkspace.contains(subcomponent.getItemId())) {
                    inaccessibleSubcomponentsInWorkspace.add(configuration);
                    continue;
                }
                inaccessibleSubcomponentsNotInWorkspace.add(configuration);
            }
        }
        Map subcomponentStructure = iComponentHierarchyResult.getParentToChildrenMap();
        Queue toBeVisited = NewCollection.arrayQueue();
        HashSet<UUID> visited = new HashSet<UUID>();
        for (IComponentHandle handle : rootComponentsNotExcluded.values()) {
            toBeVisited.add(handle.getItemId());
        }
        while (!toBeVisited.isEmpty()) {
            UUID componentId = (UUID)toBeVisited.poll();
            visited.add(componentId);
            Collection subComponentsInHiearchy = (Collection)subcomponentStructure.get(componentId);
            if (subComponentsInHiearchy == null) continue;
            for (IComponentHandle handle2 : subComponentsInHiearchy) {
                UUID itemId = handle2.getItemId();
                if (visited.contains(itemId) || !allComponentsInWorkspace.containsKey(itemId)) continue;
                if (!rootComponentsNotExcluded.containsKey(itemId) && !subcomponentsNotExcluded.containsKey(itemId)) {
                    entireHierarchyNotInSnapshotConfiguration.put(itemId, handle2);
                }
                toBeVisited.add(itemId);
            }
        }
        HashSet<UUID> configurations = new HashSet<UUID>();
        for (Map.Entry entry : excludedConfigurations.entrySet()) {
            toBeVisited.add(((IComponentHandle)entry.getValue()).getItemId());
        }
        while (!toBeVisited.isEmpty()) {
            UUID componentId = (UUID)toBeVisited.poll();
            visited.add(componentId);
            Collection subComponentsInHiearchy = (Collection)subcomponentStructure.get(componentId);
            if (subComponentsInHiearchy == null) continue;
            for (IComponentHandle handle2 : subComponentsInHiearchy) {
                UUID itemId = handle2.getItemId();
                if (visited.contains(itemId)) continue;
                if (subcomponentsNotExcluded.containsKey(itemId)) {
                    configurations.add(componentId);
                }
                toBeVisited.add(itemId);
            }
        }
        if (!configurations.isEmpty()) {
            for (UUID uuid : configurations) {
                IComponentHandle componentHandle = (IComponentHandle)excludedConfigurations.get(uuid);
                if (componentHandle == null) continue;
                entireHierarchyNotInSnapshotConfiguration.put(uuid, componentHandle);
            }
        }
    }
}

